/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.common.spore;

import com.google.common.math.DoubleMath;
import org.eclipse.elk.alg.common.TEdge;
import org.eclipse.elk.alg.common.utils.Utils;
import org.eclipse.elk.core.math.ElkMath;
import org.eclipse.elk.core.math.ElkRectangle;
import org.eclipse.elk.core.math.KVector;

public class Node {
    public KVector originalVertex;
    public KVector vertex;
    public ElkRectangle rect;

    public Node(KVector v, ElkRectangle r) {
        this.originalVertex = v;
        this.vertex = this.originalVertex.clone();
        this.rect = new ElkRectangle(r);
    }

    public void translate(KVector v) {
        this.vertex.add(v);
        this.rect.x += v.x;
        this.rect.y += v.y;
    }

    public void setCenterPosition(KVector p) {
        this.translate(p.clone().sub(this.vertex));
    }

    public double underlap(Node other) {
        double horizontalCenterDistance = Math.abs(this.rect.getCenter().x - other.rect.getCenter().x);
        double verticalCenterDistance = Math.abs(this.rect.getCenter().y - other.rect.getCenter().y);
        double horizontalUnderlap = 0.0;
        double verticalUnderlap = 0.0;
        double hScale = 1.0;
        double vScale = 1.0;
        if (horizontalCenterDistance > this.rect.width / 2.0 + other.rect.width / 2.0) {
            horizontalUnderlap = Math.min(Math.abs(this.rect.x - (other.rect.x + other.rect.width)), Math.abs(this.rect.x + this.rect.width - other.rect.x));
            hScale = 1.0 - horizontalUnderlap / horizontalCenterDistance;
        }
        if (verticalCenterDistance > this.rect.height / 2.0 + other.rect.height / 2.0) {
            verticalUnderlap = Math.min(Math.abs(this.rect.y - (other.rect.y + other.rect.height)), Math.abs(this.rect.y + this.rect.height - other.rect.y));
            vScale = 1.0 - verticalUnderlap / verticalCenterDistance;
        }
        double scale = Math.min(hScale, vScale);
        return (1.0 - scale) * Math.sqrt(horizontalCenterDistance * horizontalCenterDistance + verticalCenterDistance * verticalCenterDistance);
    }

    public double distance(Node other, KVector v) {
        double result = Double.POSITIVE_INFINITY;
        for (TEdge e1 : Utils.getRectEdges(this.rect)) {
            for (TEdge e2 : Utils.getRectEdges(other.rect)) {
                double distance = ElkMath.distance(e1.u, e1.v, e2.u, e2.v, v);
                result = Math.min(result, distance);
            }
        }
        return result;
    }

    public boolean touches(Node other) {
        return DoubleMath.fuzzyCompare(this.rect.x, other.rect.x + other.rect.width, 1.0E-4) <= 0 && DoubleMath.fuzzyCompare(other.rect.x, this.rect.x + this.rect.width, 1.0E-4) <= 0 && DoubleMath.fuzzyCompare(this.rect.y, other.rect.y + other.rect.height, 1.0E-4) <= 0 && DoubleMath.fuzzyCompare(other.rect.y, this.rect.y + this.rect.height, 1.0E-4) <= 0;
    }
}

