/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mysql.ui.config;

import java.util.Collection;
import java.util.Map;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ext.mysql.MySQLMessages;
import org.jkiss.dbeaver.ext.mysql.model.MySQLTable;
import org.jkiss.dbeaver.ext.mysql.model.MySQLTableColumn;
import org.jkiss.dbeaver.ext.mysql.model.MySQLTableIndex;
import org.jkiss.dbeaver.ext.mysql.model.MySQLTableIndexColumn;
import org.jkiss.dbeaver.ext.mysql.ui.internal.MySQLUIMessages;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEObjectConfigurator;
import org.jkiss.dbeaver.model.impl.DBObjectNameCaseTransformer;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableIndex;
import org.jkiss.dbeaver.ui.UITask;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.object.struct.AttributesSelectorPage;
import org.jkiss.dbeaver.ui.editors.object.struct.EditIndexPage;
import org.jkiss.utils.CommonUtils;

public class MySQLIndexConfigurator
implements DBEObjectConfigurator<MySQLTableIndex> {
    public MySQLTableIndex configureObject(@NotNull DBRProgressMonitor monitor, @Nullable DBECommandContext commandContext, @Nullable Object parent, @NotNull MySQLTableIndex index, @NotNull Map<String, Object> options) {
        return (MySQLTableIndex)UITask.run(() -> {
            MySQLEditIndexPage editPage = new MySQLEditIndexPage(index);
            if (!editPage.edit()) {
                return null;
            }
            StringBuilder idxName = new StringBuilder(64);
            idxName.append(CommonUtils.escapeIdentifier((String)((MySQLTable)index.getParentObject()).getName()));
            int colIndex = 1;
            for (DBSEntityAttribute tableColumn : editPage.getSelectedAttributes()) {
                if (colIndex == 1) {
                    idxName.append("_").append(CommonUtils.escapeIdentifier((String)tableColumn.getName()));
                }
                Integer length = (Integer)editPage.getAttributeProperty((DBSAttributeBase)tableColumn, "length");
                index.addColumn(new MySQLTableIndexColumn(index, (MySQLTableColumn)tableColumn, colIndex++, !Boolean.TRUE.equals(editPage.getAttributeProperty((DBSAttributeBase)tableColumn, "desc")), false, length == null ? null : String.valueOf(length)));
            }
            idxName.append("_IDX");
            index.setName(DBObjectNameCaseTransformer.transformObjectName((DBSObject)index, (String)idxName.toString()));
            index.setName(idxName.toString());
            index.setIndexType(editPage.getIndexType());
            index.setUnique(editPage.isUnique());
            return index;
        });
    }

    private static class MySQLEditIndexPage
    extends EditIndexPage {
        public static final String PROP_LENGTH = "length";
        private int lengthColumnIndex;

        MySQLEditIndexPage(MySQLTableIndex index) {
            super(MySQLUIMessages.edit_index_manager_title, (DBSTableIndex)index, (Collection)index.getDataSource().supportedIndexTypes());
        }

        protected void createAttributeColumns(Table columnsTable) {
            super.createAttributeColumns(columnsTable);
            TableColumn colDesc = UIUtils.createTableColumn((Table)columnsTable, (int)0, (String)MySQLMessages.table_column_length);
            colDesc.setToolTipText(MySQLMessages.table_column_length_tooltip);
        }

        protected int fillAttributeColumns(DBSEntityAttribute attribute, AttributesSelectorPage.AttributeInfo attributeInfo, TableItem columnItem) {
            this.lengthColumnIndex = super.fillAttributeColumns(attribute, attributeInfo, columnItem) + 1;
            Integer length = (Integer)attributeInfo.getProperty(PROP_LENGTH);
            columnItem.setText(this.lengthColumnIndex, length == null ? "" : length.toString());
            return this.lengthColumnIndex;
        }

        protected Control createCellEditor(Table table, int index, TableItem item, AttributesSelectorPage.AttributeInfo attributeInfo) {
            if (index == this.lengthColumnIndex && attributeInfo.getAttribute().getDataKind() == DBPDataKind.STRING) {
                Integer length = (Integer)attributeInfo.getProperty(PROP_LENGTH);
                Spinner spinner = new Spinner((Composite)table, 2048);
                spinner.setMinimum(0);
                spinner.setMaximum((int)attributeInfo.getAttribute().getMaxLength());
                if (length != null) {
                    spinner.setSelection(length.intValue());
                }
                return spinner;
            }
            return super.createCellEditor(table, index, item, attributeInfo);
        }

        protected void saveCellValue(Control control, int index, TableItem item, AttributesSelectorPage.AttributeInfo attributeInfo) {
            if (index == this.lengthColumnIndex) {
                Spinner spinner = (Spinner)control;
                int length = spinner.getSelection();
                item.setText(index, length <= 0 ? "" : String.valueOf(length));
                if (length <= 0) {
                    attributeInfo.setProperty(PROP_LENGTH, null);
                } else {
                    attributeInfo.setProperty(PROP_LENGTH, (Object)length);
                }
            } else {
                super.saveCellValue(control, index, item, attributeInfo);
            }
        }
    }
}

