/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.filters;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import javax.servlet.http.HttpSession;
import org.apache.catalina.filters.CsrfPreventionFilterBase;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class CsrfPreventionFilter
extends CsrfPreventionFilterBase {
    private static final String DEFAULT_NO_NONCE_URL_PATTERNS = "*.css, *.js, *.gif, *.png, *.jpg, *.svg, *.ico, *.jpeg, *.mjs";
    private ServletContext context;
    private final Log log = LogFactory.getLog(CsrfPreventionFilter.class);
    private final Set<String> entryPoints = new HashSet<String>();
    private int nonceCacheSize = 5;
    private String nonceRequestParameterName = "org.apache.catalina.filters.CSRF_NONCE";
    private boolean enforce = true;
    private String noNoncePatterns = "*.css, *.js, *.gif, *.png, *.jpg, *.svg, *.ico, *.jpeg, *.mjs";
    private Collection<Predicate<String>> noNoncePredicates;

    public void setEntryPoints(String string) {
        String[] stringArray;
        for (String string2 : stringArray = string.split(",")) {
            this.entryPoints.add(string2.trim());
        }
    }

    public void setNonceCacheSize(int n) {
        this.nonceCacheSize = n;
    }

    public void setNonceRequestParameterName(String string) {
        this.nonceRequestParameterName = string;
    }

    public void setEnforce(boolean bl) {
        this.enforce = bl;
    }

    public boolean isEnforce() {
        return this.enforce;
    }

    public void setNoNonceURLPatterns(String string) {
        this.noNoncePatterns = string;
        if (null != this.context) {
            this.noNoncePredicates = CsrfPreventionFilter.createNoNoncePredicates(this.context, this.noNoncePatterns);
        }
    }

    protected static Collection<Predicate<String>> createNoNoncePredicates(ServletContext servletContext, String string) {
        if (null == string || string.trim().isEmpty()) {
            return null;
        }
        if (string.startsWith("/") && string.endsWith("/")) {
            return Collections.singleton(new PatternPredicate(string.substring(1, string.length() - 1)));
        }
        String[] stringArray = string.split(",");
        ArrayList<Predicate<String>> arrayList = new ArrayList<Predicate<String>>(stringArray.length);
        for (String string2 : stringArray) {
            Predicate<String> predicate = CsrfPreventionFilter.createNoNoncePredicate(servletContext, string2.trim());
            if (null == predicate) continue;
            arrayList.add(predicate);
        }
        arrayList.trimToSize();
        return arrayList;
    }

    protected static Predicate<String> createNoNoncePredicate(ServletContext servletContext, String string) {
        if (null == string || string.trim().isEmpty()) {
            return null;
        }
        if (string.startsWith("mime:")) {
            return new MimePredicate(servletContext, CsrfPreventionFilter.createNoNoncePredicate(servletContext, string.substring(5)));
        }
        if (string.startsWith("*")) {
            return new SuffixPredicate(string.substring(1));
        }
        if (string.endsWith("*")) {
            return new PrefixPredicate(string.substring(0, string.length() - 1));
        }
        if (string.startsWith("/") && string.endsWith("/")) {
            return new PatternPredicate(string.substring(1, string.length() - 1));
        }
        throw new IllegalArgumentException(sm.getString("csrfPrevention.unsupportedPattern", new Object[]{string}));
    }

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        super.init(filterConfig);
        this.context = filterConfig.getServletContext();
        this.noNoncePredicates = CsrfPreventionFilter.createNoNoncePredicates(this.context, this.noNoncePatterns);
        filterConfig.getServletContext().setAttribute("org.apache.catalina.filters.CSRF_NONCE_PARAM_NAME", (Object)this.nonceRequestParameterName);
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        CsrfResponseWrapper csrfResponseWrapper = null;
        if (servletRequest instanceof HttpServletRequest && servletResponse instanceof HttpServletResponse) {
            String string;
            HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
            HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
            HttpSession httpSession = httpServletRequest.getSession(false);
            String string2 = this.getRequestedPath(httpServletRequest);
            boolean bl = this.skipNonceCheck(httpServletRequest);
            NonceCache<String> nonceCache = null;
            if (!bl) {
                string = httpServletRequest.getParameter(this.nonceRequestParameterName);
                if (string == null) {
                    if (this.enforce(httpServletRequest, string2)) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)sm.getString("csrfPrevention.rejectNoNonce", new Object[]{this.getRequestedPath(httpServletRequest), null == httpSession ? "(null)" : httpSession.getId()}));
                        }
                        httpServletResponse.sendError(this.getDenyStatus());
                        return;
                    }
                    if (this.log.isTraceEnabled()) {
                        this.log.trace((Object)("Would have rejected request for " + this.getRequestedPath(httpServletRequest) + ", session " + (null == httpSession ? "(null)" : httpSession.getId()) + " with no CSRF nonce found in request"));
                    }
                } else {
                    nonceCache = this.getNonceCache(httpServletRequest, httpSession);
                    if (nonceCache == null) {
                        if (this.enforce(httpServletRequest, string2)) {
                            if (this.log.isDebugEnabled()) {
                                this.log.debug((Object)sm.getString("csrfPrevention.rejectNoCache", new Object[]{this.getRequestedPath(httpServletRequest), null == httpSession ? "(null)" : httpSession.getId()}));
                            }
                            httpServletResponse.sendError(this.getDenyStatus());
                            return;
                        }
                        if (this.log.isTraceEnabled()) {
                            this.log.trace((Object)("Would have rejecting request for " + this.getRequestedPath(httpServletRequest) + ", session " + (null == httpSession ? "(null)" : httpSession.getId()) + " due to empty / missing nonce cache"));
                        }
                    } else if (!nonceCache.contains(string)) {
                        if (this.enforce(httpServletRequest, string2)) {
                            if (this.log.isDebugEnabled()) {
                                this.log.debug((Object)sm.getString("csrfPrevention.rejectInvalidNonce", new Object[]{this.getRequestedPath(httpServletRequest), null == httpSession ? "(null)" : httpSession.getId(), string}));
                            }
                            httpServletResponse.sendError(this.getDenyStatus());
                            return;
                        }
                        if (this.log.isTraceEnabled()) {
                            this.log.trace((Object)("Would have rejecting request for " + this.getRequestedPath(httpServletRequest) + ", session " + (null == httpSession ? "(null)" : httpSession.getId()) + " due to invalid nonce " + string));
                        }
                    } else if (this.log.isTraceEnabled()) {
                        this.log.trace((Object)("Allowing request to " + this.getRequestedPath(httpServletRequest) + " with valid CSRF nonce " + string));
                    }
                }
            }
            if (!this.skipNonceGeneration(httpServletRequest)) {
                if (bl) {
                    nonceCache = this.getNonceCache(httpServletRequest, httpSession);
                }
                if (nonceCache == null) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)sm.getString("csrfPrevention.createCache", new Object[]{this.nonceCacheSize, null == httpSession ? "(null)" : httpSession.getId()}));
                    }
                    if (httpSession == null) {
                        if (this.log.isTraceEnabled()) {
                            this.log.trace((Object)"Creating new session to store CSRF nonce cache");
                        }
                        httpSession = httpServletRequest.getSession(true);
                    }
                    nonceCache = this.createNonceCache(httpServletRequest, httpSession);
                }
                string = this.generateNonce(httpServletRequest);
                nonceCache.add(string);
                servletRequest.setAttribute("org.apache.catalina.filters.CSRF_REQUEST_NONCE", (Object)string);
                csrfResponseWrapper = new CsrfResponseWrapper(httpServletResponse, this.nonceRequestParameterName, string, this.noNoncePredicates);
            }
        }
        filterChain.doFilter(servletRequest, (ServletResponse)(csrfResponseWrapper == null ? servletResponse : csrfResponseWrapper));
    }

    protected boolean enforce(HttpServletRequest httpServletRequest, String string) {
        return this.isEnforce();
    }

    protected boolean skipNonceCheck(HttpServletRequest httpServletRequest) {
        if (!"GET".equals(httpServletRequest.getMethod())) {
            return false;
        }
        String string = this.getRequestedPath(httpServletRequest);
        if (this.entryPoints.contains(string)) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Skipping CSRF nonce-check for GET request to entry point " + string));
            }
            return true;
        }
        if (null != this.noNoncePredicates && !this.noNoncePredicates.isEmpty()) {
            for (Predicate<String> predicate : this.noNoncePredicates) {
                if (!predicate.test(string)) continue;
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("Skipping CSRF nonce-check for GET request to no-nonce path " + string));
                }
                return true;
            }
        }
        return false;
    }

    protected boolean skipNonceGeneration(HttpServletRequest httpServletRequest) {
        return false;
    }

    protected NonceCache<String> createNonceCache(HttpServletRequest httpServletRequest, HttpSession httpSession) {
        LruCache<String> lruCache = new LruCache<String>(this.nonceCacheSize);
        httpSession.setAttribute("org.apache.catalina.filters.CSRF_NONCE", lruCache);
        return lruCache;
    }

    protected NonceCache<String> getNonceCache(HttpServletRequest httpServletRequest, HttpSession httpSession) {
        if (httpSession == null) {
            return null;
        }
        NonceCache nonceCache = (NonceCache)httpSession.getAttribute("org.apache.catalina.filters.CSRF_NONCE");
        return nonceCache;
    }

    protected static class PatternPredicate
    implements Predicate<String> {
        private final Pattern pattern;

        public PatternPredicate(String string) {
            this.pattern = Pattern.compile(string);
        }

        @Override
        public boolean test(String string) {
            return this.pattern.matcher(string).matches();
        }
    }

    protected static class MimePredicate
    implements Predicate<String> {
        private final ServletContext context;
        private final Predicate<String> predicate;

        public MimePredicate(ServletContext servletContext, Predicate<String> predicate) {
            this.context = servletContext;
            this.predicate = predicate;
        }

        @Override
        public boolean test(String string) {
            String string2 = this.context.getMimeType(string);
            if (string2 == null) {
                return false;
            }
            return this.predicate.test(string2);
        }

        public Predicate<String> getPredicate() {
            return this.predicate;
        }
    }

    protected static class SuffixPredicate
    implements Predicate<String> {
        private final String suffix;

        public SuffixPredicate(String string) {
            this.suffix = string;
        }

        @Override
        public boolean test(String string) {
            return string.endsWith(this.suffix);
        }
    }

    protected static class PrefixPredicate
    implements Predicate<String> {
        private final String prefix;

        public PrefixPredicate(String string) {
            this.prefix = string;
        }

        @Override
        public boolean test(String string) {
            return string.startsWith(this.prefix);
        }
    }

    protected static interface NonceCache<T>
    extends Serializable {
        public void add(T var1);

        public boolean contains(T var1);
    }

    protected static class CsrfResponseWrapper
    extends HttpServletResponseWrapper {
        private final String nonceRequestParameterName;
        private final String nonce;
        private final Collection<Predicate<String>> noNoncePatterns;

        public CsrfResponseWrapper(HttpServletResponse httpServletResponse, String string, String string2, Collection<Predicate<String>> collection) {
            super(httpServletResponse);
            this.nonceRequestParameterName = string;
            this.nonce = string2;
            this.noNoncePatterns = collection;
        }

        @Deprecated
        public String encodeRedirectUrl(String string) {
            return this.encodeRedirectURL(string);
        }

        public String encodeRedirectURL(String string) {
            if (this.shouldAddNonce(string)) {
                return this.addNonce(super.encodeRedirectURL(string));
            }
            return string;
        }

        @Deprecated
        public String encodeUrl(String string) {
            return this.encodeURL(string);
        }

        public String encodeURL(String string) {
            if (this.shouldAddNonce(string)) {
                return this.addNonce(super.encodeURL(string));
            }
            return string;
        }

        private boolean shouldAddNonce(String string) {
            if (null == this.noNoncePatterns || this.noNoncePatterns.isEmpty()) {
                return true;
            }
            for (Predicate<String> predicate : this.noNoncePatterns) {
                if (!predicate.test(string)) continue;
                return false;
            }
            return true;
        }

        private String addNonce(String string) {
            int n;
            if (string == null || this.nonce == null) {
                return string;
            }
            String string2 = string;
            String string3 = "";
            String string4 = "";
            int n2 = string2.indexOf(35);
            if (n2 >= 0) {
                string4 = string2.substring(n2);
                string2 = string2.substring(0, n2);
            }
            if ((n = string2.indexOf(63)) >= 0) {
                string3 = string2.substring(n);
                string2 = string2.substring(0, n);
            }
            StringBuilder stringBuilder = new StringBuilder(string2);
            if (!string3.isEmpty()) {
                stringBuilder.append(string3);
                stringBuilder.append('&');
            } else {
                stringBuilder.append('?');
            }
            stringBuilder.append(this.nonceRequestParameterName);
            stringBuilder.append('=');
            stringBuilder.append(this.nonce);
            stringBuilder.append(string4);
            return stringBuilder.toString();
        }
    }

    protected static class LruCache<T>
    implements NonceCache<T> {
        private static final long serialVersionUID = 1L;
        private final Map<T, T> cache;

        public LruCache(final int n) {
            this.cache = new LinkedHashMap<T, T>(){
                private static final long serialVersionUID = 1L;

                @Override
                protected boolean removeEldestEntry(Map.Entry<T, T> entry) {
                    return this.size() > n;
                }
            };
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void add(T t) {
            Map<T, T> map = this.cache;
            synchronized (map) {
                this.cache.put(t, null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean contains(T t) {
            Map<T, T> map = this.cache;
            synchronized (map) {
                return this.cache.containsKey(t);
            }
        }
    }
}

