/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex;

import com.dickimawbooks.texparserlib.DoubleParam;
import com.dickimawbooks.texparserlib.GenericCommand;
import com.dickimawbooks.texparserlib.Param;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXSyntaxException;
import java.io.IOException;
import java.util.Arrays;

public class LaTeXGenericCommand
extends GenericCommand {
    private char[] latexSyntax;
    private TeXObject[] defaultArgs;
    protected boolean isRobust = false;
    public static final char SYNTAX_OPTIONAL = 'o';
    public static final char SYNTAX_MANDATORY = 'm';

    public LaTeXGenericCommand(String string) {
        this(true, string);
    }

    public LaTeXGenericCommand(boolean bl, String string) {
        super(bl, string, null, new TeXObjectList());
        this.latexSyntax = null;
    }

    public LaTeXGenericCommand(boolean bl, String string, TeXObjectList teXObjectList) {
        this(bl, string, false, teXObjectList);
    }

    public LaTeXGenericCommand(boolean bl, String string, boolean bl2, TeXObjectList teXObjectList) {
        super(bl, string, null, teXObjectList);
        this.latexSyntax = null;
        this.isRobust = bl2;
    }

    public LaTeXGenericCommand(boolean bl, String string, String string2, TeXObjectList teXObjectList) {
        this(bl, string, false, string2, teXObjectList);
    }

    public LaTeXGenericCommand(boolean bl, String string, boolean bl2, String string2, TeXObjectList teXObjectList) {
        this(bl, string, string2.toCharArray(), teXObjectList, (TeXObjectList)null);
    }

    public LaTeXGenericCommand(boolean bl, String string, char[] cArray, TeXObjectList teXObjectList) {
        this(bl, string, false, cArray, teXObjectList);
    }

    public LaTeXGenericCommand(boolean bl, String string, boolean bl2, char[] cArray, TeXObjectList teXObjectList) {
        this(bl, string, bl2, cArray, teXObjectList, (TeXObjectList)null);
    }

    public LaTeXGenericCommand(boolean bl, String string, String string2, TeXObjectList teXObjectList, TeXObjectList teXObjectList2) {
        this(bl, string, false, string2, teXObjectList, teXObjectList2);
    }

    public LaTeXGenericCommand(boolean bl, String string, boolean bl2, String string2, TeXObjectList teXObjectList, TeXObjectList teXObjectList2) {
        this(bl, string, bl2, string2.toCharArray(), teXObjectList, teXObjectList2);
    }

    public LaTeXGenericCommand(boolean bl, String string, char[] cArray, TeXObjectList teXObjectList, TeXObjectList teXObjectList2) {
        this(bl, string, false, cArray, teXObjectList, teXObjectList2);
    }

    public LaTeXGenericCommand(boolean bl, String string, boolean bl2, char[] cArray, TeXObjectList teXObjectList, TeXObjectList teXObjectList2) {
        super(bl, string, null, teXObjectList);
        this.latexSyntax = cArray;
        this.isRobust = bl2;
        int n = teXObjectList2 == null ? 0 : teXObjectList2.size();
        this.defaultArgs = n == 0 ? null : new TeXObject[n];
        this.numArgs = 0;
        if (this.latexSyntax != null) {
            int n2 = 0;
            for (int i = 0; i < this.latexSyntax.length; ++i) {
                if (this.latexSyntax[i] == 'm') {
                    ++this.numArgs;
                    continue;
                }
                if (this.latexSyntax[i] == 'o') {
                    ++this.numArgs;
                    this.defaultArgs[n2] = (TeXObject)((TeXObject)teXObjectList2.get(n2)).clone();
                    ++n2;
                    continue;
                }
                throw new IllegalArgumentException("Invalid argument identifier: " + this.latexSyntax[i]);
            }
        }
    }

    public LaTeXGenericCommand(boolean bl, String string, char[] cArray, TeXObjectList teXObjectList, TeXObject[] teXObjectArray) {
        this(bl, string, false, cArray, teXObjectList, teXObjectArray);
    }

    public LaTeXGenericCommand(boolean bl, String string, boolean bl2, char[] cArray, TeXObjectList teXObjectList, TeXObject[] teXObjectArray) {
        super(bl, string, null, teXObjectList);
        this.latexSyntax = cArray;
        this.isRobust = bl2;
        int n = teXObjectArray == null ? 0 : teXObjectArray.length;
        this.defaultArgs = n == 0 ? null : new TeXObject[n];
        this.numArgs = 0;
        if (this.latexSyntax != null) {
            int n2 = 0;
            for (int i = 0; i < this.latexSyntax.length; ++i) {
                if (this.latexSyntax[i] == 'm') {
                    ++this.numArgs;
                    continue;
                }
                if (this.latexSyntax[i] == 'o') {
                    ++this.numArgs;
                    this.defaultArgs[n2] = (TeXObject)teXObjectArray[n2].clone();
                    ++n2;
                    continue;
                }
                throw new IllegalArgumentException("Invalid argument identifier: " + this.latexSyntax[i]);
            }
        }
    }

    @Override
    public Object clone() {
        return new LaTeXGenericCommand(this.isShort, this.getName(), this.isRobust, this.latexSyntax, (TeXObjectList)this.getDefinition().clone());
    }

    @Override
    public boolean equals(Object object) {
        if (object == null || !(object instanceof LaTeXGenericCommand)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        LaTeXGenericCommand laTeXGenericCommand = (LaTeXGenericCommand)object;
        if (this.isShort != laTeXGenericCommand.isShort || !this.getDefinition().equals(laTeXGenericCommand.getDefinition())) {
            return false;
        }
        return Arrays.equals(this.latexSyntax, laTeXGenericCommand.latexSyntax) && Arrays.equals(this.defaultArgs, laTeXGenericCommand.defaultArgs);
    }

    @Override
    public boolean canExpand() {
        return !this.isRobust;
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        return this.isRobust ? null : this.getReplacement(teXParser, teXObjectList);
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser) throws IOException {
        return this.isRobust ? null : this.getReplacement(teXParser);
    }

    @Override
    public TeXObjectList expandfully(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        return this.isRobust ? null : this.getReplacement(teXParser, teXObjectList).expandfully(teXParser, teXObjectList);
    }

    @Override
    public TeXObjectList expandfully(TeXParser teXParser) throws IOException {
        return this.isRobust ? null : this.getReplacement(teXParser).expandfully(teXParser);
    }

    @Override
    protected TeXObjectList getReplacement(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXObject[] teXObjectArray;
        TeXObject[] teXObjectArray2 = teXObjectArray = this.numArgs == 0 ? null : new TeXObject[this.numArgs];
        if (this.numArgs > 0) {
            byte by = TeXObjectList.getArgPopStyle(this.isShort);
            int n = 0;
            for (int i = 0; i < this.numArgs; ++i) {
                TeXObject teXObject = null;
                switch (this.latexSyntax[i]) {
                    case 'o': {
                        teXObject = teXObjectList.popArg(teXParser, by, 91, 93);
                        if (teXObject == null) {
                            teXObject = this.defaultArgs[n++];
                        }
                        if (teXParser.isDebugMode(32)) {
                            teXParser.logMessage(String.format("OARG[%d]: %s", i, teXObject));
                        }
                        if (!teXParser.isDebugMode(16)) break;
                        teXParser.logMessage(String.format("OARG[%d]: %s", i, teXObject.toString(teXParser)));
                        break;
                    }
                    case 'm': {
                        teXObject = teXObjectList.popArg(teXParser, by);
                        if (teXParser.isDebugMode(32)) {
                            teXParser.logMessage(String.format("MARG[%d]: %s", i, teXObject));
                        }
                        if (!teXParser.isDebugMode(16)) break;
                        teXParser.logMessage(String.format("MARG[%d]: %s", i, teXObject.toString(teXParser)));
                    }
                }
                teXObjectArray[i] = teXObject;
            }
        }
        TeXObjectList teXObjectList2 = new TeXObjectList();
        this.addReplacements(teXParser, teXObjectList2, teXObjectArray, this.getDefinition());
        if (teXParser.isDebugMode(32)) {
            teXParser.logMessage("Replacement: " + teXObjectList2);
        }
        if (teXParser.isDebugMode(16)) {
            teXParser.logMessage("Replacement: " + teXObjectList2.toString(teXParser));
        }
        return teXObjectList2;
    }

    @Override
    protected TeXObjectList getReplacement(TeXParser teXParser) throws IOException {
        TeXObject[] teXObjectArray;
        TeXObject[] teXObjectArray2 = teXObjectArray = this.numArgs == 0 ? null : new TeXObject[this.numArgs];
        if (this.numArgs > 0) {
            byte by = TeXObjectList.POP_IGNORE_LEADING_SPACE;
            if (this.isShort) {
                by = (byte)(TeXObjectList.POP_SHORT | by);
            }
            int n = 0;
            for (int i = 0; i < this.numArgs; ++i) {
                TeXObject teXObject = null;
                switch (this.latexSyntax[i]) {
                    case 'o': {
                        teXObject = teXParser.popNextArg(by, 91, 93);
                        if (teXObject == null) {
                            teXObject = this.defaultArgs[n++];
                        }
                        if (teXParser.isDebugMode(32)) {
                            teXParser.logMessage(String.format("OARG[%d]: %s", i, teXObject));
                        }
                        if (!teXParser.isDebugMode(16)) break;
                        teXParser.logMessage(String.format("OARG[%d]: %s", i, teXObject.toString(teXParser)));
                        break;
                    }
                    case 'm': {
                        teXObject = teXParser.popNextArg(by);
                        if (teXParser.isDebugMode(32)) {
                            teXParser.logMessage(String.format("MARG[%d]: %s", i, teXObject));
                        }
                        if (!teXParser.isDebugMode(16)) break;
                        teXParser.logMessage(String.format("MARG[%d]: %s", i, teXObject.toString(teXParser)));
                    }
                }
                teXObjectArray[i] = teXObject;
            }
        }
        TeXObjectList teXObjectList = new TeXObjectList();
        this.addReplacements(teXParser, teXObjectList, teXObjectArray, this.getDefinition());
        if (teXParser.isDebugMode(32)) {
            teXParser.logMessage("Replacement: " + teXObjectList);
        }
        if (teXParser.isDebugMode(16)) {
            teXParser.logMessage("Replacement: " + teXObjectList.toString(teXParser));
        }
        return teXObjectList;
    }

    protected void addReplacements(TeXParser teXParser, TeXObjectList teXObjectList, TeXObject[] teXObjectArray, TeXObjectList teXObjectList2) throws TeXSyntaxException {
        for (TeXObject teXObject : teXObjectList2) {
            if (teXObject instanceof Param) {
                int n = ((Param)teXObject).getDigit();
                if (teXObjectArray == null || n > teXObjectArray.length) {
                    throw new TeXSyntaxException(teXParser, "tex.error.illegal_param", n, this.toString(teXParser));
                }
                teXObjectList.add((TeXObject)teXObjectArray[--n].clone());
                continue;
            }
            if (teXObject instanceof DoubleParam) {
                teXObjectList.add((TeXObject)((DoubleParam)teXObject).next().clone());
                continue;
            }
            if (teXObject instanceof TeXObjectList) {
                TeXObjectList teXObjectList3 = ((TeXObjectList)teXObject).createList();
                teXObjectList.add(teXObjectList3);
                this.addReplacements(teXParser, teXObjectList3, teXObjectArray, (TeXObjectList)teXObject);
                continue;
            }
            teXObjectList.add((TeXObject)teXObject.clone());
        }
    }

    public char[] getLaTeXSyntax() {
        return this.latexSyntax;
    }

    public String getLaTeXSyntaxString() {
        return this.latexSyntax == null ? "" : new String(this.latexSyntax);
    }

    @Override
    public String toString() {
        return String.format("%s[name=%s,robust=%s,syntax=%s,definition=%s]", this.getClass().getSimpleName(), this.getName(), this.isRobust, this.getLaTeXSyntaxString(), this.getDefinition());
    }
}

