/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.nodes.dfa;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.regex.tregex.automaton.TransitionOp;
import com.oracle.truffle.regex.tregex.nodes.dfa.CounterTracker;
import com.oracle.truffle.regex.tregex.nodes.dfa.CounterTrackerData;

public final class CounterTrackerTrivialNeverReEnter
extends CounterTracker {
    private final int min;
    private final int max;
    private final int fixedOffset;

    public CounterTrackerTrivialNeverReEnter(int min, int max, int numberOfCells, CounterTrackerData.Builder dataBuilder) {
        this.min = min;
        this.max = max;
        this.fixedOffset = dataBuilder.getFixedDataSize();
        dataBuilder.requestFixedSize(numberOfCells);
    }

    @Override
    @ExplodeLoop
    public void apply(long op, long[] data, int[][] intArrays) {
        CompilerAsserts.partialEvaluationConstant((long)op);
        int dst = this.mapId(TransitionOp.getTarget(op));
        int kind = TransitionOp.getKind(op);
        assert (TransitionOp.getModifier(op) == 1 || TransitionOp.getModifier(op) == 3);
        switch (kind) {
            case 2: {
                data[dst] = 1L;
                break;
            }
            case 1: {
                data[dst] = data[this.mapId(TransitionOp.getSource(op))] + 1L;
                break;
            }
            case 0: {
                int src = this.mapId(TransitionOp.getSource(op));
                if (TransitionOp.getModifier(op) == 3) {
                    long tmp = data[dst];
                    data[dst] = data[src];
                    data[src] = tmp;
                    break;
                }
                data[dst] = data[src];
            }
        }
    }

    @Override
    public void init(long[] fixedData, int[][] intArrays) {
    }

    @Override
    public boolean support(long operation) {
        return true;
    }

    private int mapId(int sId) {
        return sId + this.fixedOffset;
    }

    @Override
    protected boolean anyLtMax(int sId, long[] fixedData, int[][] intArrays) {
        if (this.max == -1) {
            return true;
        }
        return fixedData[this.mapId(sId)] < (long)this.max;
    }

    @Override
    protected boolean anyGeMin(int sId, long[] fixedData, int[][] intArrays) {
        assert (this.min != 0);
        return fixedData[this.mapId(sId)] >= (long)this.min;
    }

    @Override
    protected boolean anyLtMin(int sId, long[] fixedData, int[][] intArrays) {
        assert (this.min != 0);
        return fixedData[this.mapId(sId)] < (long)this.min;
    }

    @Override
    public String dumpState(int sId, long[] fixedData, int[][] intArrays) {
        return "TrivialNeverReEnter, current value: " + fixedData[this.mapId(sId)];
    }
}

