/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.runtime.internal.repository.metadata.parser;

import com.ibm.db2.cmx.runtime.internal.repository.MetadataException;
import com.ibm.db2.cmx.runtime.internal.repository.metadata.Constants;
import com.ibm.db2.cmx.runtime.internal.repository.metadata.PerformanceInfo;
import com.ibm.db2.cmx.runtime.internal.repository.metadata.SourceInfo;
import com.ibm.db2.cmx.runtime.internal.repository.metadata.parser.MetadataListener;
import com.ibm.db2.cmx.runtime.internal.repository.metadata.parser.QueryLanguageTypes;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class MetadataParser
extends DefaultHandler {
    private MetadataListener listener;
    private SAXParser parser;
    StringBuffer buffer;
    private static final String ProgramSetKey = "programSet";
    private static final String OriginKey = "origin";
    private static final String OriginType = "originType";
    private static final String OriginEnvironment = "originEnvironment";
    private static final String SpecialRegValuesSet = "specialRegValuesSet";
    private static final String SpecialRegValue = "specialRegValue";
    private static final String StatementSetKey = "statementSet";
    private static final String StatementSetMetadataKey = "statementSetMetadata";
    private static final String SourceFileKey = "sourceFile";
    private static final String SourceFileNameKey = "name";
    private static final String SourceFileCompletePathKey = "completePath";
    private static final String JavaInterfaceKey = "javaInterface";
    private static final String JavaInterfaceNameKey = "name";
    private static final String JavaInterfaceContainerKey = "container";
    private static final String CollectionNameKey = "collection";
    private static final String PackageNameRootKey = "name";
    private static final String StatementsKey = "statements";
    private static final String PackageKey = "package";
    private static final String StatementKey = "statement";
    private static final String StatementDescriptorKey = "statementDescriptor";
    private static final String PrepareSQLKey = "prepareSql";
    private static final String StatementMetadataKey = "statementMetadata";
    private static final String CaptureStatisticsKey = "captureStatistics";
    private static final String ExecutionCountKey = "executionCount";
    private static final String LastUsedTimestampKey = "lastUsedTimestamp";
    private static final String SQLDefinitionStackTracesKey = "sqlDefinitionStackTraces";
    private static final String SQLExecutionStackTracesKey = "sqlExecutionStackTraces";
    private static final String TraceInfoKey = "traceInfo";
    private static final String TraceKey = "trace";
    private static final String TraceEntryKey = "traceEntry";
    private static final String ConsistencyTokenKey = "consistencyToken";
    private static final String ClassFileKey = "classFile";
    private static final String FileNameKey = "fileName";
    private static final String LineNoKey = "lineNo";
    private static final String MethodKey = "method";
    private static final String MethodSignatureKey = "signature";
    private static final String ContainingPkgKey = "containingPkg";
    private static final String IsNativeKey = "isNative";
    private static final String SectionNumberKey = "sectionNumber";
    private static final String IdKey = "id";
    private static final String DbPkgVersionKey = "version";
    private static final String JavaMethodKey = "javaMethod";
    private static final String MethodNameKey = "methodName";
    private static final String SourceCodeLineNumberKey = "sourceCodeLineNumber";
    private static final String OperationTypeKey = "operationType";
    private static final String AnnotationKey = "annotation";
    private static final String UserSqlKey = "sql";
    private static final String IsBindableKey = "isBindable";
    private static final String ConfigureStatus = "configureStatus";
    private static final String StatementAttributesKey = "statementAttributes";
    private static final String ExpressionTypeKey = "type";
    private static final String ProcessedSQLKey = "processedSql";
    private static final String IncrementalSpecialRegValuesUsedKey = "specialRegValuesUsed";
    private static final String NamedNativeQueryKey = "namedNativeQuery";
    private static final String NamedQueryKey = "namedQuery";
    private static final String NamedQueryNameKey = "name";
    private static final String DefinedInClassKey = "definedInClass";
    private static final String DefinedInFileKey = "definedInFile";
    private static final String EntityKey = "entity";
    private static final String EntityOperationKey = "operation";
    private static final String LineNumberKey = "line";
    private static final String ExecutionRecordsKey = "executionRecords";
    private static final String RunKey = "run";
    private static final String BeginAttribute = "begin";
    private static final String EndAttribute = "end";
    private static final String SpecialRegValueIdKey = "specialRegValueId";
    private static final String SpecialRegisterVectorValueKey = "specialRegisterVectorValue";
    private State currentState;
    private State definedInReturnState = null;
    private State traceReturnState = null;
    private ArrayList<SourceInfo> currentSourceInfoList = null;
    private HashMap<Constants.SourceOpType, List<List<SourceInfo>>> sourceInfoMap = null;
    private List<List<SourceInfo>> currentSourceInfoLists = null;
    private boolean oldFormatTraceEntries = false;
    private String expression;
    private String sql;
    private String packageNameRoot;
    private String collectionName;
    private String consistencyToken;
    private int sectionNumber;
    private String id;
    private String dbPkgVersion;
    private String path;
    private String javaInterface;
    private String sourceFileName;
    private String javaPackage;
    private String javaMethod;
    private String javaMethodSignature = null;
    private String metadataSource;
    private String interfaceFileName;
    private boolean packageIsBindable;
    private boolean statementIsBindable;
    private String methodName;
    private LinkedList<StatementInfo> statementList;
    private int lineNumber;
    private Constants.SourceOpType operationType = null;
    private char expressionType;
    private char queryTextType;
    boolean insertOnly = false;
    private String queryName = null;
    private String queryNameType = null;
    private String processedSql;
    private HashMap<String, String> specialRegisters = null;
    String incrementalSpecialRegValuesUsed = null;
    private String configureStatus = null;
    private Integer executionCount = null;
    private String lastUsedTimestamp = null;

    public MetadataParser() throws SAXException, ParserConfigurationException {
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        sAXParserFactory.setFeature("http://xml.org/sax/features/validation", false);
        this.parser = sAXParserFactory.newSAXParser();
    }

    public void parse(InputStream inputStream, MetadataListener metadataListener, boolean bl2) throws SAXException, IOException {
        this.currentState = State.None;
        this.listener = metadataListener;
        this.insertOnly = bl2;
        try {
            this.parser.parse(inputStream, (DefaultHandler)this);
        }
        catch (SAXException sAXException) {
            System.err.println("state is " + this.currentState.name());
            throw sAXException;
        }
        catch (IOException iOException) {
            System.err.println("state is " + this.currentState.name());
            throw iOException;
        }
    }

    @Override
    public void startDocument() {
        this.statementIsBindable = true;
        this.packageIsBindable = true;
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) {
        if (string3.equalsIgnoreCase(ProgramSetKey) && this.currentState == State.None) {
            this.currentState = State.ProgramSet;
        } else if (string3.equalsIgnoreCase(OriginKey) && this.currentState == State.ProgramSet) {
            this.currentState = State.Origin;
        } else if (string3.equalsIgnoreCase(OriginType) && this.currentState == State.Origin) {
            this.currentState = State.OriginType;
            this.buffer = new StringBuffer();
        } else if (string3.equalsIgnoreCase(OriginEnvironment) && this.currentState == State.Origin) {
            this.currentState = State.OriginEnvironment;
        } else if (string3.equalsIgnoreCase(SpecialRegValuesSet) && this.currentState == State.OriginEnvironment) {
            this.currentState = State.SpecialRegValuesSet;
            this.specialRegisters = new HashMap();
        } else if (string3.equalsIgnoreCase(SpecialRegValue) && this.currentState == State.SpecialRegValuesSet) {
            this.currentState = State.SpecialRegValue;
            String string4 = attributes.getValue(SpecialRegValueIdKey);
            String string5 = attributes.getValue(SpecialRegisterVectorValueKey);
            this.specialRegisters.put(string4, string5);
        } else if (string3.equalsIgnoreCase(StatementSetKey) && this.currentState == State.ProgramSet) {
            this.currentState = State.StatementSet;
            this.configureStatus = attributes.getValue(ConfigureStatus);
            this.statementList = new LinkedList();
        } else if (string3.equalsIgnoreCase(StatementSetMetadataKey) && this.currentState == State.StatementSet) {
            this.currentState = State.StatementSetMetadata;
        } else if (string3.equalsIgnoreCase(SourceFileKey) && this.currentState == State.StatementSetMetadata) {
            this.currentState = State.SourceFile;
        } else if (string3.equalsIgnoreCase("name") && this.currentState == State.SourceFile) {
            this.currentState = State.SourceFileName;
            this.buffer = new StringBuffer();
        } else if (string3.equalsIgnoreCase(SourceFileCompletePathKey) && this.currentState == State.SourceFile) {
            this.currentState = State.SourceFileCompletePath;
        } else if (string3.equalsIgnoreCase(JavaInterfaceKey) && this.currentState == State.StatementSetMetadata) {
            this.currentState = State.JavaInterface;
            this.javaInterface = null;
            this.javaPackage = null;
        } else if (string3.equalsIgnoreCase("name") && this.currentState == State.JavaInterface) {
            this.currentState = State.JavaInterfaceName;
            this.buffer = new StringBuffer();
        } else if (string3.equalsIgnoreCase(JavaInterfaceContainerKey) && this.currentState == State.JavaInterface) {
            this.currentState = State.JavaInterfaceContainer;
            this.buffer = new StringBuffer();
        } else if (string3.equalsIgnoreCase(StatementAttributesKey)) {
            String string6 = attributes.getValue(IsBindableKey);
            this.statementIsBindable = string6 == null || !string6.equalsIgnoreCase("false");
            this.incrementalSpecialRegValuesUsed = attributes.getValue(IncrementalSpecialRegValuesUsedKey);
        } else if (string3.equalsIgnoreCase(PackageKey) && this.currentState == State.StatementSet) {
            this.currentState = State.Package;
            this.collectionName = attributes.getValue(CollectionNameKey);
            this.consistencyToken = attributes.getValue(ConsistencyTokenKey);
            this.packageNameRoot = attributes.getValue("name");
            this.dbPkgVersion = attributes.getValue(DbPkgVersionKey);
            String string7 = attributes.getValue(IsBindableKey);
            this.packageIsBindable = string7 == null || !string7.equalsIgnoreCase("false");
        } else if (string3.equalsIgnoreCase(StatementsKey) && this.currentState == State.StatementSet) {
            this.currentState = State.Statements;
        } else if (string3.equalsIgnoreCase(StatementKey) && this.currentState == State.Statements) {
            this.currentState = State.Statement;
            this.expression = null;
            this.sql = null;
            this.processedSql = null;
            this.executionCount = null;
            this.lastUsedTimestamp = null;
            this.queryTextType = (char)32;
            this.expressionType = (char)85;
            this.sectionNumber = 0;
            this.id = attributes.getValue(IdKey);
            this.sourceInfoMap = new HashMap();
            String string8 = attributes.getValue(SectionNumberKey);
            if (string8 != null) {
                try {
                    this.sectionNumber = Integer.parseInt(string8);
                }
                catch (NumberFormatException numberFormatException) {}
            }
        } else if (string3.equalsIgnoreCase(StatementDescriptorKey) && this.currentState == State.Statement) {
            this.currentState = State.StatementDescriptor;
        } else if (string3.equalsIgnoreCase(PrepareSQLKey) && this.currentState == State.StatementDescriptor) {
            this.currentState = State.PrepareSQL;
            this.buffer = new StringBuffer();
            this.queryTextType = (char)83;
            String string9 = attributes.getValue(ExpressionTypeKey);
            if (string9 != null && string9.length() > 0) {
                this.queryTextType = string9.charAt(0);
            }
        } else if (this.currentState == State.StatementDescriptor && QueryLanguageTypes.fromExportElementName(string3) != ' ') {
            this.currentState = State.NonSQLQueryLanguage;
            this.buffer = new StringBuffer();
            this.queryTextType = QueryLanguageTypes.fromExportElementName(string3);
        } else if (string3.equalsIgnoreCase(StatementMetadataKey) && this.currentState == State.Statement) {
            this.currentState = State.StatementMetadata;
            this.javaMethod = null;
            this.javaMethodSignature = null;
        } else if (string3.equalsIgnoreCase(CaptureStatisticsKey) && this.currentState == State.StatementMetadata) {
            this.currentState = State.CaptureStatistics;
        } else if (string3.equalsIgnoreCase(ExecutionCountKey) && this.currentState == State.CaptureStatistics) {
            this.currentState = State.ExecutionCount;
            this.buffer = new StringBuffer();
        } else if (string3.equalsIgnoreCase(LastUsedTimestampKey) && this.currentState == State.CaptureStatistics) {
            this.currentState = State.LastUsedTimestamp;
            this.buffer = new StringBuffer();
        } else if (string3.equalsIgnoreCase(JavaMethodKey) && this.currentState == State.StatementMetadata) {
            this.currentState = State.JavaMethod;
        } else if (string3.equalsIgnoreCase(MethodNameKey) && this.currentState == State.JavaMethod) {
            this.currentState = State.MethodName;
            this.buffer = new StringBuffer();
        } else if (string3.equalsIgnoreCase(MethodSignatureKey) && this.currentState == State.JavaMethod) {
            this.currentState = State.MethodSignature;
            this.buffer = new StringBuffer();
        } else if (string3.equalsIgnoreCase(SourceCodeLineNumberKey) && this.currentState == State.JavaMethod) {
            this.currentState = State.SourceCodeLineNumber;
            this.buffer = new StringBuffer();
        } else if (string3.equalsIgnoreCase(OperationTypeKey) && this.currentState == State.JavaMethod) {
            this.currentState = State.OperationType;
            this.buffer = new StringBuffer();
        } else if (string3.equalsIgnoreCase(AnnotationKey) && this.currentState == State.JavaMethod) {
            this.currentState = State.Annotation;
        } else if (string3.equalsIgnoreCase(UserSqlKey) && this.currentState == State.Annotation) {
            this.currentState = State.UserSQL;
            this.buffer = new StringBuffer();
            this.expressionType = (char)83;
            String string10 = attributes.getValue(ExpressionTypeKey);
            if (string10 != null && string10.equalsIgnoreCase(Character.toString('U'))) {
                this.expressionType = (char)85;
            }
        } else if (string3.equalsIgnoreCase(TraceInfoKey) && this.currentState == State.StatementMetadata) {
            if (!this.oldFormatTraceEntries) {
                this.currentSourceInfoList = null;
                this.currentSourceInfoLists = null;
            }
            this.currentState = State.TraceInfo;
        } else if (string3.equalsIgnoreCase(SQLDefinitionStackTracesKey) && this.currentState == State.TraceInfo) {
            this.currentSourceInfoLists = new ArrayList<List<SourceInfo>>();
            this.currentState = State.SQLDefinitionStackTraces;
        } else if (string3.equalsIgnoreCase(SQLExecutionStackTracesKey) && this.currentState == State.TraceInfo) {
            this.currentSourceInfoLists = new ArrayList<List<SourceInfo>>();
            this.currentState = State.SQLExecutionStackTraces;
        } else if (string3.equalsIgnoreCase(TraceKey) && (this.currentState == State.SQLDefinitionStackTraces || this.currentState == State.SQLExecutionStackTraces)) {
            this.traceReturnState = this.currentState;
            this.currentState = State.Trace;
            this.currentSourceInfoList = new ArrayList();
        } else if (string3.equalsIgnoreCase(TraceEntryKey) && (this.currentState == State.TraceInfo || this.currentState == State.Trace)) {
            Object object;
            if (this.currentState == State.TraceInfo) {
                this.oldFormatTraceEntries = true;
                if (this.currentSourceInfoLists == null) {
                    this.currentSourceInfoLists = new ArrayList<List<SourceInfo>>();
                    this.sourceInfoMap.put(Constants.SourceOpType.SQLExecution, this.currentSourceInfoLists);
                }
                if (this.currentSourceInfoList == null) {
                    this.currentSourceInfoList = new ArrayList();
                    this.currentSourceInfoLists.add(this.currentSourceInfoList);
                }
            }
            this.currentState = State.TraceEntry;
            String string11 = attributes.getValue(IsNativeKey);
            if (string11 == null) {
                string11 = "false";
            }
            String string12 = attributes.getValue(ContainingPkgKey);
            int n2 = -1;
            try {
                object = attributes.getValue(LineNoKey);
                if (object != null) {
                    n2 = Integer.parseInt(attributes.getValue(LineNoKey));
                }
            }
            catch (NumberFormatException numberFormatException) {
                n2 = -1;
            }
            object = new SourceInfo(null, string12, attributes.getValue(ClassFileKey), attributes.getValue(MethodKey), null, this.getFilePath(string12, attributes.getValue(FileNameKey)), n2, string11, null, null);
            this.currentSourceInfoList.add((SourceInfo)object);
        } else if (string3.equalsIgnoreCase(ExecutionRecordsKey) && this.currentState == State.TraceEntry) {
            this.currentState = State.ExecutionRecords;
        } else if (string3.equalsIgnoreCase(RunKey) && this.currentState == State.ExecutionRecords) {
            Object object;
            long l2 = 0L;
            long l3 = 0L;
            try {
                String string13 = attributes.getValue(BeginAttribute);
                if (string13 != null) {
                    l2 = Long.parseLong(string13);
                }
                if ((object = attributes.getValue(EndAttribute)) != null) {
                    l3 = Long.parseLong((String)object);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            int n3 = this.currentSourceInfoList.size() - 1;
            object = new PerformanceInfo();
            ((PerformanceInfo)object).setEntry(l2);
            ((PerformanceInfo)object).setExit(l3);
            this.currentSourceInfoList.get(n3).addPerformanceInfo("Default", (PerformanceInfo)object);
            this.currentState = State.Run;
        } else if (string3.equalsIgnoreCase(ProcessedSQLKey) && this.currentState == State.StatementMetadata) {
            this.currentState = State.ProcessedSQLInStmtMetadata;
            this.buffer = new StringBuffer();
        } else if (string3.equalsIgnoreCase(ProcessedSQLKey) && this.currentState == State.StatementDescriptor) {
            this.currentState = State.ProcessedSQLInStmtDescriptor;
            this.buffer = new StringBuffer();
        } else if ((string3.equalsIgnoreCase(NamedNativeQueryKey) || string3.equalsIgnoreCase(NamedQueryKey)) && this.currentState == State.StatementMetadata) {
            this.queryNameType = string3;
            this.currentState = State.NamedQuery;
            this.path = null;
            this.lineNumber = -1;
            this.queryName = null;
        } else if (string3.equalsIgnoreCase(DefinedInFileKey) && (this.currentState == State.NamedQuery || this.currentState == State.Entity)) {
            this.definedInReturnState = this.currentState;
            this.currentState = State.DefinedInFile;
            this.path = null;
            this.javaInterface = null;
            this.javaPackage = null;
            this.lineNumber = -1;
            String string14 = attributes.getValue(LineNumberKey);
            if (string14 != null) {
                try {
                    this.lineNumber = Integer.parseInt(string14);
                }
                catch (NumberFormatException numberFormatException) {
                    this.lineNumber = -1;
                }
            }
            this.buffer = new StringBuffer();
        } else if (string3.equalsIgnoreCase("name") && this.currentState == State.NamedQuery) {
            this.currentState = State.NQ_Name;
            this.buffer = new StringBuffer();
        } else if (string3.equalsIgnoreCase(DefinedInClassKey) && (this.currentState == State.NamedQuery || this.currentState == State.Entity)) {
            this.definedInReturnState = this.currentState;
            this.currentState = State.DefinedInClass;
            this.buffer = new StringBuffer();
            this.path = null;
            this.javaInterface = null;
            this.javaPackage = null;
            this.lineNumber = -1;
        } else if (string3.equalsIgnoreCase(EntityKey) && this.currentState == State.StatementMetadata) {
            this.currentState = State.Entity;
            this.path = null;
            this.methodName = null;
            this.lineNumber = -1;
        } else if (string3.equalsIgnoreCase(EntityOperationKey) && this.currentState == State.Entity) {
            this.currentState = State.EntityOperation;
            this.buffer = new StringBuffer();
        }
    }

    @Override
    public void characters(char[] cArray, int n2, int n3) {
        if (this.buffer != null) {
            this.buffer.append(cArray, n2, n3);
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        if (string3.equalsIgnoreCase(ProgramSetKey) && this.currentState == State.ProgramSet) {
            this.currentState = State.None;
        } else if (string3.equalsIgnoreCase(OriginType) && this.currentState == State.OriginType) {
            this.metadataSource = this.buffer.toString();
            this.currentState = State.Origin;
        } else if (string3.equalsIgnoreCase(OriginKey) && this.currentState == State.Origin) {
            this.currentState = State.ProgramSet;
        } else if (string3.equalsIgnoreCase(OriginEnvironment) && this.currentState == State.OriginEnvironment) {
            this.currentState = State.Origin;
        } else if (string3.equalsIgnoreCase(SpecialRegValuesSet) && this.currentState == State.SpecialRegValuesSet) {
            this.currentState = State.OriginEnvironment;
        } else if (string3.equalsIgnoreCase(SpecialRegValue) && this.currentState == State.SpecialRegValue) {
            this.currentState = State.SpecialRegValuesSet;
        } else if (string3.equalsIgnoreCase(StatementSetKey) && this.currentState == State.StatementSet) {
            if (this.listener != null && this.statementList != null) {
                for (StatementInfo statementInfo : this.statementList) {
                    try {
                        if (this.specialRegisters == null || statementInfo.getIncrementalSpecialRegValuesUsed() == null) {
                            this.listener.updateSQL(this.metadataSource, statementInfo.getSourceInfoMap(), statementInfo.getExpression(), statementInfo.getSql(), statementInfo.getProcessedSql(), this.packageNameRoot, this.collectionName, this.consistencyToken, statementInfo.getSectionNumber(), this.dbPkgVersion, this.packageIsBindable, statementInfo.getExpressionType(), this.insertOnly, statementInfo.getQueryTextType(), statementInfo.getId(), statementInfo.isBindable(), null, statementInfo.getExecutionCount(), statementInfo.getLastUsedTimestamp(), this.configureStatus);
                            continue;
                        }
                        StringTokenizer stringTokenizer = new StringTokenizer(statementInfo.getIncrementalSpecialRegValuesUsed(), ",");
                        while (stringTokenizer.hasMoreTokens()) {
                            this.listener.updateSQL(this.metadataSource, statementInfo.getSourceInfoMap(), statementInfo.getExpression(), statementInfo.getSql(), statementInfo.getProcessedSql(), this.packageNameRoot, this.collectionName, this.consistencyToken, statementInfo.getSectionNumber(), this.dbPkgVersion, this.packageIsBindable, statementInfo.getExpressionType(), this.insertOnly, statementInfo.getQueryTextType(), statementInfo.getId(), statementInfo.isBindable(), this.specialRegisters.get(stringTokenizer.nextToken()), statementInfo.getExecutionCount(), statementInfo.getLastUsedTimestamp(), this.configureStatus);
                        }
                    }
                    catch (MetadataException metadataException) {
                        metadataException.printStackTrace();
                        throw new SAXException("cannot parse metadata", metadataException);
                    }
                }
            }
            this.currentState = State.ProgramSet;
        } else if (string3.equalsIgnoreCase(StatementSetMetadataKey) && this.currentState == State.StatementSetMetadata) {
            this.currentState = State.StatementSet;
        } else if (string3.equalsIgnoreCase(SourceFileKey) && this.currentState == State.SourceFile) {
            this.currentState = State.StatementSetMetadata;
        } else if (string3.equalsIgnoreCase("name") && this.currentState == State.SourceFileName) {
            this.currentState = State.SourceFile;
            this.sourceFileName = this.buffer.toString();
            this.buffer = null;
        } else if (string3.equalsIgnoreCase(SourceFileCompletePathKey) && this.currentState == State.SourceFileCompletePath) {
            this.currentState = State.StatementSetMetadata;
        } else if (string3.equalsIgnoreCase(StatementsKey) && this.currentState == State.Statements) {
            this.currentState = State.StatementSet;
        } else if (string3.equalsIgnoreCase(PackageKey) && this.currentState == State.Package) {
            this.currentState = State.StatementSet;
        } else if (string3.equalsIgnoreCase(JavaInterfaceKey) && this.currentState == State.JavaInterface) {
            this.currentState = State.StatementSetMetadata;
            this.interfaceFileName = this.getInterfaceFile(this.javaPackage, this.javaInterface + ".java");
        } else if (string3.equalsIgnoreCase("name") && this.currentState == State.JavaInterfaceName) {
            this.currentState = State.JavaInterface;
            this.javaInterface = this.getClassName(this.buffer.toString());
            this.buffer = null;
        } else if (string3.equalsIgnoreCase(JavaInterfaceContainerKey) && this.currentState == State.JavaInterfaceContainer) {
            this.currentState = State.JavaInterface;
            this.javaPackage = this.buffer.toString();
            this.buffer = null;
        } else if (string3.equalsIgnoreCase(StatementKey) && this.currentState == State.Statement) {
            this.currentState = State.Statements;
            if (this.currentSourceInfoLists == null && this.javaMethod != null) {
                if (this.operationType == null) {
                    this.operationType = Constants.SourceOpType.SQLExecution;
                }
                ArrayList<SourceInfo> arrayList = new ArrayList<SourceInfo>();
                String string4 = null;
                string4 = this.sourceFileName != null && "Analysis".equals(this.metadataSource) ? this.getInterfaceFile(this.javaPackage, this.sourceFileName) : this.interfaceFileName;
                arrayList.add(new SourceInfo(null, this.javaPackage, this.javaInterface, this.javaMethod, this.javaMethodSignature, string4, this.lineNumber, "false", null, null));
                ArrayList<ArrayList<SourceInfo>> arrayList2 = new ArrayList<ArrayList<SourceInfo>>();
                arrayList2.add(arrayList);
                this.sourceInfoMap = new HashMap();
                this.sourceInfoMap.put(this.operationType, arrayList2);
            }
            this.statementList.add(new StatementInfo(this.expression, this.sql, this.processedSql, this.sourceInfoMap, this.statementIsBindable, this.expressionType, this.queryTextType, this.sectionNumber, this.id, this.executionCount, this.lastUsedTimestamp, this.incrementalSpecialRegValuesUsed));
            if (this.oldFormatTraceEntries) {
                this.currentSourceInfoLists = null;
                this.currentSourceInfoList = null;
            }
        } else if (string3.equalsIgnoreCase(StatementDescriptorKey) && this.currentState == State.StatementDescriptor) {
            this.currentState = State.Statement;
        } else if (string3.equalsIgnoreCase(PrepareSQLKey) && this.currentState == State.PrepareSQL) {
            this.currentState = State.StatementDescriptor;
            this.sql = this.buffer.toString();
        } else if (this.currentState == State.NonSQLQueryLanguage && QueryLanguageTypes.fromExportElementName(string3) != ' ') {
            this.currentState = State.StatementDescriptor;
            this.sql = this.buffer.toString();
        } else if (string3.equalsIgnoreCase(StatementMetadataKey) && this.currentState == State.StatementMetadata) {
            this.currentState = State.Statement;
        } else if (string3.equalsIgnoreCase(TraceInfoKey) && (this.currentState == State.TraceInfo || this.currentState == State.Trace)) {
            if (this.oldFormatTraceEntries) {
                this.currentSourceInfoList = null;
            }
            this.currentState = State.StatementMetadata;
        } else if (string3.equalsIgnoreCase(TraceEntryKey) && this.currentState == State.TraceEntry) {
            this.currentState = this.oldFormatTraceEntries ? State.TraceInfo : State.Trace;
        } else if (string3.equalsIgnoreCase(CaptureStatisticsKey) && this.currentState == State.CaptureStatistics) {
            this.currentState = State.StatementMetadata;
        } else if (string3.equalsIgnoreCase(ExecutionCountKey) && this.currentState == State.ExecutionCount) {
            this.currentState = State.CaptureStatistics;
            this.executionCount = Integer.valueOf(this.buffer.toString());
        } else if (string3.equalsIgnoreCase(LastUsedTimestampKey) && this.currentState == State.LastUsedTimestamp) {
            this.currentState = State.CaptureStatistics;
            this.lastUsedTimestamp = this.buffer.toString();
        } else if (string3.equalsIgnoreCase(TraceKey) && this.currentState == State.Trace) {
            if (this.currentSourceInfoList.size() > 0) {
                this.currentSourceInfoLists.add(this.currentSourceInfoList);
            }
            this.currentState = this.traceReturnState;
        } else if (string3.equalsIgnoreCase(RunKey) && this.currentState == State.Run) {
            this.currentState = State.ExecutionRecords;
        } else if (string3.equalsIgnoreCase(ExecutionRecordsKey) && this.currentState == State.ExecutionRecords) {
            this.currentState = State.TraceEntry;
        } else if (string3.equalsIgnoreCase(SQLDefinitionStackTracesKey) && this.currentState == State.SQLDefinitionStackTraces) {
            this.currentState = State.TraceInfo;
            if (this.currentSourceInfoLists.size() > 0) {
                this.sourceInfoMap.put(Constants.SourceOpType.SQLPrepare, this.currentSourceInfoLists);
            }
        } else if (string3.equalsIgnoreCase(SQLExecutionStackTracesKey) && this.currentState == State.SQLExecutionStackTraces) {
            this.currentState = State.TraceInfo;
            if (this.currentSourceInfoLists.size() > 0) {
                this.sourceInfoMap.put(Constants.SourceOpType.SQLExecution, this.currentSourceInfoLists);
            }
        } else if (string3.equalsIgnoreCase(JavaMethodKey) && this.currentState == State.JavaMethod) {
            this.currentState = State.StatementMetadata;
        } else if (string3.equalsIgnoreCase(MethodNameKey) && this.currentState == State.MethodName) {
            this.currentState = State.JavaMethod;
            this.javaMethod = this.buffer.toString();
        } else if (string3.equalsIgnoreCase(MethodSignatureKey) && this.currentState == State.MethodSignature) {
            String string5 = this.buffer.toString();
            int n2 = string5.indexOf(40);
            if (n2 >= 0) {
                this.javaMethodSignature = string5.substring(n2);
            }
            this.currentState = State.JavaMethod;
        } else if (string3.equalsIgnoreCase(SourceCodeLineNumberKey) && this.currentState == State.SourceCodeLineNumber) {
            this.currentState = State.JavaMethod;
            try {
                this.lineNumber = Integer.parseInt(this.buffer.toString());
            }
            catch (NumberFormatException numberFormatException) {
                this.lineNumber = -1;
            }
            this.buffer = null;
        } else if (string3.equalsIgnoreCase(OperationTypeKey) && this.currentState == State.OperationType) {
            this.currentState = State.JavaMethod;
            this.operationType = Constants.SourceOpType.fromSQLString(this.buffer.toString());
            this.buffer = null;
        } else if (string3.equalsIgnoreCase(AnnotationKey) && this.currentState == State.Annotation) {
            this.currentState = State.JavaMethod;
        } else if (string3.equalsIgnoreCase(UserSqlKey) && this.currentState == State.UserSQL) {
            this.currentState = State.Annotation;
            this.expression = this.buffer.toString();
            this.buffer = null;
        } else if (string3.equalsIgnoreCase(ProcessedSQLKey) && this.currentState == State.ProcessedSQLInStmtMetadata) {
            this.currentState = State.StatementMetadata;
            this.processedSql = this.buffer.toString();
            this.buffer = null;
        } else if (string3.equalsIgnoreCase(ProcessedSQLKey) && this.currentState == State.ProcessedSQLInStmtDescriptor) {
            this.currentState = State.StatementDescriptor;
            this.processedSql = this.buffer.toString();
            this.buffer = null;
        } else if (string3.equalsIgnoreCase("name") && this.currentState == State.NQ_Name) {
            this.currentState = State.NamedQuery;
            this.queryName = this.buffer.toString();
            this.buffer = null;
        } else if (string3.equalsIgnoreCase(DefinedInFileKey) && this.currentState == State.DefinedInFile) {
            this.currentState = this.definedInReturnState;
            this.definedInReturnState = null;
            this.path = this.buffer.toString();
            this.buffer = null;
        } else if (string3.equalsIgnoreCase(DefinedInClassKey) && this.currentState == State.DefinedInClass) {
            this.currentState = this.definedInReturnState;
            this.definedInReturnState = null;
            String string6 = this.buffer.toString();
            this.path = this.convertToPath(string6);
            if (!this.path.endsWith(".java")) {
                this.path = this.path + ".java";
            }
            this.javaPackage = this.getPackageFromQualifiedClassName(string6);
            this.javaInterface = this.getClassFromQualifiedClassName(string6);
            this.buffer = null;
        } else if ((string3.equalsIgnoreCase(NamedNativeQueryKey) || string3.equalsIgnoreCase(NamedQueryKey)) && this.currentState == State.NamedQuery) {
            if (this.path != null) {
                List<List<SourceInfo>> list = this.sourceInfoMap.get((Object)Constants.SourceOpType.Definition);
                if (list == null) {
                    list = new ArrayList<List<SourceInfo>>();
                    this.sourceInfoMap.put(Constants.SourceOpType.Definition, list);
                }
                ArrayList<SourceInfo> arrayList = new ArrayList<SourceInfo>();
                arrayList.add(new SourceInfo(null, this.javaPackage, this.javaInterface, null, null, this.path, this.lineNumber, "false", this.queryName, this.queryNameType));
                list.add(arrayList);
            }
            this.queryName = null;
            this.queryNameType = null;
            this.currentState = State.StatementMetadata;
        } else if (string3.equalsIgnoreCase(EntityOperationKey) && this.currentState == State.EntityOperation) {
            this.methodName = this.buffer.toString();
            this.buffer = null;
            this.currentState = State.Entity;
        } else if (string3.equalsIgnoreCase(EntityKey) && this.currentState == State.Entity) {
            List<List<SourceInfo>> list = this.sourceInfoMap.get((Object)Constants.SourceOpType.Definition);
            if (list == null) {
                list = new ArrayList<List<SourceInfo>>();
                this.sourceInfoMap.put(Constants.SourceOpType.Definition, list);
            }
            ArrayList<SourceInfo> arrayList = new ArrayList<SourceInfo>();
            if (this.lineNumber == -1 && this.methodName != null) {
                this.lineNumber = this.methodName.hashCode();
                if (this.lineNumber > 0) {
                    this.lineNumber *= -1;
                }
            }
            arrayList.add(new SourceInfo(null, this.javaPackage, this.javaInterface, this.methodName, null, this.path, this.lineNumber, "false", null, null));
            list.add(arrayList);
            this.currentState = State.StatementMetadata;
        }
    }

    private String getFilePath(String string, String string2) {
        if (string == null && string2 == null) {
            return null;
        }
        return this.convertToPath(string) + "/" + string2;
    }

    private String convertToPath(String string) {
        if (string == null) {
            return null;
        }
        return string.replace('.', '/');
    }

    private String getInterfaceFile(String string, String string2) {
        if (string == null) {
            return string2;
        }
        return this.convertToPath(string) + "/" + string2;
    }

    private String getClassName(String string) {
        if (string.endsWith(".java")) {
            return string.substring(0, string.length() - ".java".length());
        }
        return string;
    }

    private String getPackageFromQualifiedClassName(String string) {
        int n2 = string.lastIndexOf(".");
        String string2 = null;
        if (n2 > 0) {
            string2 = string.substring(0, n2);
        }
        return string2;
    }

    private String getClassFromQualifiedClassName(String string) {
        int n2 = string.lastIndexOf(".");
        String string2 = null;
        if (n2 > 0) {
            string2 = string.substring(n2 + 1);
        }
        return string2;
    }

    private static enum State {
        None,
        ProgramSet,
        Origin,
        OriginType,
        OriginEnvironment,
        SpecialRegValuesSet,
        SpecialRegValue,
        StatementSet,
        StatementSetMetadata,
        SourceFile,
        SourceFileName,
        SourceFileContainer,
        SourceFileCompletePath,
        JavaInterface,
        JavaInterfaceName,
        JavaInterfaceContainer,
        Package,
        Statements,
        Statement,
        StatementDescriptor,
        PrepareSQL,
        NonSQLQueryLanguage,
        ProfilerPrepareSQL,
        StatementAttributes,
        ProcessedSQLInStmtDescriptor,
        StatementMetadata,
        ProcessedSQLInStmtMetadata,
        JavaMethod,
        MethodName,
        MethodSignature,
        SourceCodeLineNumber,
        OperationType,
        Annotation,
        UserSQL,
        TraceInfo,
        SQLDefinitionStackTraces,
        SQLExecutionStackTraces,
        Trace,
        TraceEntry,
        ExecutionRecords,
        Run,
        CaptureStatistics,
        ExecutionCount,
        LastUsedTimestamp,
        NamedQuery,
        NQ_Name,
        DefinedInClass,
        DefinedInFile,
        Entity,
        EntityName,
        EntityOperation;

    }

    private static class StatementInfo {
        private String expression;
        private String sql;
        private String processedSql;
        private HashMap<Constants.SourceOpType, List<List<SourceInfo>>> sourceInfoMap = new HashMap();
        private boolean isBindable;
        private char expressionType;
        private char queryTextType;
        private int sectionNumber;
        private String id;
        private Integer executionCount = null;
        private String lastUsedTimestamp = null;
        private String incrementalSpecialRegValuesUsed = null;

        public StatementInfo(String string, String string2, String string3, HashMap<Constants.SourceOpType, List<List<SourceInfo>>> hashMap, boolean bl2, char c10, char c11, int n2, String string4, Integer n3, String string5, String string6) {
            this.expression = string;
            this.sql = string2;
            this.processedSql = string3;
            this.sourceInfoMap = hashMap;
            this.isBindable = bl2;
            this.expressionType = c10;
            this.queryTextType = c11;
            this.sectionNumber = n2;
            this.id = string4;
            this.executionCount = n3;
            this.lastUsedTimestamp = string5;
            this.incrementalSpecialRegValuesUsed = string6;
        }

        public String getExpression() {
            return this.expression;
        }

        public String getSql() {
            return this.sql;
        }

        public String getProcessedSql() {
            return this.processedSql;
        }

        public HashMap<Constants.SourceOpType, List<List<SourceInfo>>> getSourceInfoMap() {
            return this.sourceInfoMap;
        }

        public boolean isBindable() {
            return this.isBindable;
        }

        public char getExpressionType() {
            return this.expressionType;
        }

        public char getQueryTextType() {
            return this.queryTextType;
        }

        public int getSectionNumber() {
            return this.sectionNumber;
        }

        public void setSectionNumber(int n2) {
            this.sectionNumber = n2;
        }

        public String getId() {
            return this.id;
        }

        public Integer getExecutionCount() {
            return this.executionCount;
        }

        public String getLastUsedTimestamp() {
            return this.lastUsedTimestamp;
        }

        public String getIncrementalSpecialRegValuesUsed() {
            return this.incrementalSpecialRegValuesUsed;
        }
    }
}

