/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.ser.impl;

import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonGenerator;
import tools.jackson.databind.BeanProperty;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.ValueSerializer;
import tools.jackson.databind.jsontype.TypeSerializer;

public final class TypeWrappedSerializer
extends ValueSerializer<Object> {
    protected final TypeSerializer _typeSerializer;
    protected final ValueSerializer<Object> _serializer;

    public TypeWrappedSerializer(TypeSerializer typeSer, ValueSerializer<?> ser) {
        this._typeSerializer = typeSer;
        this._serializer = ser;
    }

    @Override
    public void serialize(Object value, JsonGenerator g, SerializationContext provider) throws JacksonException {
        this._serializer.serializeWithType(value, g, provider, this._typeSerializer);
    }

    @Override
    public void serializeWithType(Object value, JsonGenerator g, SerializationContext provider, TypeSerializer typeSer) throws JacksonException {
        this._serializer.serializeWithType(value, g, provider, typeSer);
    }

    @Override
    public Class<Object> handledType() {
        return Object.class;
    }

    @Override
    public ValueSerializer<?> createContextual(SerializationContext provider, BeanProperty property) {
        ValueSerializer<Object> ser = this._serializer;
        if (ser != null) {
            ser = provider.handleSecondaryContextualization(ser, property);
        }
        if (ser == this._serializer) {
            return this;
        }
        return new TypeWrappedSerializer(this._typeSerializer, ser);
    }

    public ValueSerializer<Object> valueSerializer() {
        return this._serializer;
    }

    public TypeSerializer typeSerializer() {
        return this._typeSerializer;
    }
}

