\name{LaplacianImageFilter}
\alias{LaplacianImageFilter}
\title{LaplacianImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
This filter computes the Laplacian of a scalar-valued image.
LaplacianImageFilter}
\details{
The Laplacian is an isotropic measure of the 2nd spatial derivative of
an image. The Laplacian of an image highlights regions of rapid
intensity change and is therefore often used for edge detection.
Often, the Laplacian is applied to an image that has first been
smoothed with a Gaussian filter in order to reduce its sensitivity to
noise.
The Laplacian at each pixel location is computed by convolution with
the itk::LaplacianOperator .
Inputs and Outputs
The input to this filter is a scalar-valued itk::Image of arbitrary dimension. The output is a scalar-valued itk::Image .
WARNING:
The pixel type of the input and output images must be of real type
(float or double). ConceptChecking is used here to enforce the input
pixel type. You will get a compilation error if the pixel type of the
input and output images is not float or double.
See:
Image
Neighborhood
NeighborhoodOperator
NeighborhoodIterator
LaplacianOperator
Laplacian for the procedural interface
itk::LaplacianImageFilter for the Doxygen on the original ITK class.
LaplacianImageFilter}
%C++ includes: sitkLaplacianImageFilter.h
\section{Methods}{
\describe{
\item{Image Execute(const Image &image1):}{
Execute the filter on the input image
}
\item{std::string GetName() const:}{
Name of this class
}
\item{bool GetUseImageSpacing() const:}{
Set/Get whether or not the filter will use the spacing of the input
image in its calculations
}
\item{ LaplacianImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{Self SetUseImageSpacing(bool UseImageSpacing):}{
Set/Get whether or not the filter will use the spacing of the input
image in its calculations
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{Self UseImageSpacingOff():}{}
\item{Self UseImageSpacingOn():}{
Set the value of UseImageSpacing to true or false respectfully.
}
\item{ ~LaplacianImageFilter():}{
Destructor
}
}
}
