/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.impl;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomReferenceInjector;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.SubTag;
import com.intellij.util.xml.impl.ConvertContextFactory;
import com.intellij.util.xml.impl.DomInvocationHandler;
import com.intellij.util.xml.impl.DomManagerImpl;
import com.intellij.util.xml.impl.Invocation;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class GetInvocation
implements Invocation {
    private static final Key<CachedValue<List<Pair<Converter, Object>>>> DOM_VALUE_KEY = Key.create((String)"Dom element value key");
    private final Converter myConverter;

    protected GetInvocation(Converter converter) {
        assert (converter != null);
        this.myConverter = converter;
    }

    @Override
    public Object invoke(DomInvocationHandler handler, Object[] args) throws Throwable {
        if (this.myConverter == Converter.EMPTY_CONVERTER) {
            return GetInvocation.getValueInner(handler, this.myConverter);
        }
        CachedValue value = (CachedValue)handler.getUserData(DOM_VALUE_KEY);
        if (value == null) {
            DomManagerImpl domManager = handler.getManager();
            Project project = domManager.getProject();
            CachedValuesManager cachedValuesManager = CachedValuesManager.getManager((Project)project);
            value = cachedValuesManager.createCachedValue(() -> {
                List list = ContainerUtil.createLockFreeCopyOnWriteList();
                return CachedValueProvider.Result.create((Object)list, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT, domManager, ProjectRootManager.getInstance((Project)project)});
            }, false);
            handler.putUserData(DOM_VALUE_KEY, value);
        }
        return this.getOrCalcValue(handler, (List)value.getValue());
    }

    @Nullable
    private Object getOrCalcValue(DomInvocationHandler handler, List<Pair<Converter, Object>> list) {
        if (!list.isEmpty()) {
            for (int i = 0; i < list.size(); ++i) {
                Pair<Converter, Object> pair = list.get(i);
                if (pair.first != this.myConverter) continue;
                return pair.second;
            }
        }
        Object returnValue = GetInvocation.getValueInner(handler, this.myConverter);
        list.add((Pair<Converter, Object>)Pair.create((Object)this.myConverter, (Object)returnValue));
        return returnValue;
    }

    @Nullable
    private static Object getValueInner(DomInvocationHandler handler, Converter converter) {
        SubTag annotation = handler.getAnnotation(SubTag.class);
        if (annotation != null && annotation.indicator()) {
            boolean tagNotNull;
            boolean bl = tagNotNull = handler.getXmlTag() != null;
            if (converter == Converter.EMPTY_CONVERTER) {
                return tagNotNull ? "" : null;
            }
            return tagNotNull;
        }
        String tagValue = handler.getValue();
        ConvertContext context = ConvertContextFactory.createConvertContext(handler);
        for (DomReferenceInjector each : DomUtil.getFileElement((DomElement)handler).getFileDescription().getReferenceInjectors()) {
            tagValue = each.resolveString(tagValue, context);
        }
        return converter.fromString(tagValue, context);
    }
}

