/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.copyright;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.copyright.CopyrightManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AppUIExecutor;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.BulkFileListenerBackgroundable;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.maddyhome.idea.copyright.actions.UpdateCopyrightProcessor;
import com.maddyhome.idea.copyright.util.FileTypeUtil;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016J\b\u0010\u0012\u001a\u00020\u000eH\u0002J\u0018\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R>\u0010\u0004\u001a2\u0012\u000e\u0012\f0\u0006\u00a2\u0006\u0002\b\u0007\u00a2\u0006\u0002\b\b \n*\u0017\u0012\u000e\u0012\f0\u0006\u00a2\u0006\u0002\b\u0007\u00a2\u0006\u0002\b\b0\t\u00a2\u0006\u0002\b\u00070\u0005\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/copyright/CopyrightManagerDocumentListener;", "Lcom/intellij/openapi/vfs/newvfs/BulkFileListenerBackgroundable;", "<init>", "()V", "newFilePaths", "", "", "Lorg/jetbrains/annotations/NotNull;", "Lkotlin/jvm/internal/EnhancedNullability;", "", "kotlin.jvm.PlatformType", "isDocumentListenerAdded", "Ljava/util/concurrent/atomic/AtomicBoolean;", "after", "", "events", "", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "addDocumentListener", "handleEvent", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.copyright"})
final class CopyrightManagerDocumentListener
implements BulkFileListenerBackgroundable {
    @NotNull
    private final Set<String> newFilePaths;
    @NotNull
    private final AtomicBoolean isDocumentListenerAdded;

    public CopyrightManagerDocumentListener() {
        Set set = ConcurrentCollectionFactory.createConcurrentSet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"createConcurrentSet(...)");
        this.newFilePaths = set;
        this.isDocumentListenerAdded = new AtomicBoolean();
    }

    public void after(@NotNull List<? extends VFileEvent> events) {
        Intrinsics.checkNotNullParameter(events, (String)"events");
        for (VFileEvent vFileEvent : events) {
            if (vFileEvent.isFromRefresh() || !(vFileEvent instanceof VFileCreateEvent) && !(vFileEvent instanceof VFileMoveEvent)) continue;
            this.newFilePaths.add(vFileEvent.getPath());
            if (!this.isDocumentListenerAdded.compareAndSet(false, true)) continue;
            this.addDocumentListener();
        }
    }

    private final void addDocumentListener() {
        EditorFactory.getInstance().getEventMulticaster().addDocumentListener(new DocumentListener(this){
            final /* synthetic */ CopyrightManagerDocumentListener this$0;
            {
                this.this$0 = $receiver;
            }

            public void documentChanged(DocumentEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (CopyrightManagerDocumentListener.access$getNewFilePaths$p(this.this$0).isEmpty()) {
                    return;
                }
                VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(e.getDocument());
                if (virtualFile == null) {
                    return;
                }
                VirtualFile virtualFile2 = virtualFile;
                if (!CopyrightManagerDocumentListener.access$getNewFilePaths$p(this.this$0).remove(virtualFile2.getPath())) {
                    return;
                }
                boolean $i$f$serviceIfCreated = false;
                Application application = ApplicationManager.getApplication();
                ProjectManager projectManager = (ProjectManager)(application != null ? application.getServiceIfCreated(ProjectManager.class) : null);
                if (projectManager == null) {
                    return;
                }
                ProjectManager projectManager2 = projectManager;
                Project[] projectArray = projectManager2.getOpenProjects();
                Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"getOpenProjects(...)");
                for (Project project : projectArray) {
                    Intrinsics.checkNotNull((Object)project);
                    Project project2 = project;
                    if (project2.isDisposed()) continue;
                    CopyrightManagerDocumentListener.access$handleEvent(this.this$0, virtualFile2, project2);
                }
            }
        }, (Disposable)FileTypeUtil.getInstance());
    }

    private final void handleEvent(VirtualFile virtualFile, Project project) {
        CopyrightManager copyrightManager = CopyrightManager.Companion.getInstance(project);
        if (!copyrightManager.hasAnyCopyrights()) {
            return;
        }
        Module module = ProjectRootManager.getInstance((Project)project).getFileIndex().getModuleForFile(virtualFile);
        if (module == null) {
            return;
        }
        Module module2 = module;
        if (!FileTypeUtil.isSupportedFile(virtualFile)) {
            return;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(virtualFile);
        if (psiFile == null) {
            return;
        }
        PsiFile file = psiFile;
        if (!file.isWritable()) {
            return;
        }
        if (copyrightManager.getCopyrightOptions(file) == null) {
            return;
        }
        AppUIExecutor.onUiThread((ModalityState)ModalityState.nonModal()).later().withDocumentsCommitted(project).execute(() -> CopyrightManagerDocumentListener.handleEvent$lambda$0(project, file, module2));
    }

    private static final void handleEvent$lambda$0(Project $project, PsiFile $file, Module $module) {
        if ($project.isDisposed() || !$file.isValid()) {
            return;
        }
        new UpdateCopyrightProcessor($project, $module, $file).run();
    }

    public static final /* synthetic */ Set access$getNewFilePaths$p(CopyrightManagerDocumentListener $this) {
        return $this.newFilePaths;
    }

    public static final /* synthetic */ void access$handleEvent(CopyrightManagerDocumentListener $this, VirtualFile virtualFile, Project project) {
        $this.handleEvent(virtualFile, project);
    }
}

