/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.csv;

import com.intellij.database.csv.CsvRecordFormat;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CsvFormat {
    @NlsSafe
    public final String name;
    @NotNull
    public final CsvRecordFormat dataRecord;
    @Nullable
    public final CsvRecordFormat headerRecord;
    public final boolean rowNumbers;
    public final String id;

    public CsvFormat(@NotNull CsvRecordFormat dataRecord, @Nullable CsvRecordFormat headerRecord, boolean rowNumbers) {
        if (dataRecord == null) {
            CsvFormat.$$$reportNull$$$0(0);
        }
        this("", dataRecord, headerRecord, rowNumbers);
    }

    public CsvFormat(@NotNull String name, @NotNull CsvRecordFormat dataRecord, @Nullable CsvRecordFormat headerRecord, boolean rowNumbers) {
        if (name == null) {
            CsvFormat.$$$reportNull$$$0(1);
        }
        if (dataRecord == null) {
            CsvFormat.$$$reportNull$$$0(2);
        }
        this(name, dataRecord, headerRecord, UUID.randomUUID().toString(), rowNumbers);
    }

    public CsvFormat(@NotNull String name, @NotNull CsvRecordFormat dataRecord, @Nullable CsvRecordFormat headerRecord, @NotNull String id, boolean rowNumbers) {
        if (name == null) {
            CsvFormat.$$$reportNull$$$0(3);
        }
        if (dataRecord == null) {
            CsvFormat.$$$reportNull$$$0(4);
        }
        if (id == null) {
            CsvFormat.$$$reportNull$$$0(5);
        }
        this.name = name;
        this.dataRecord = dataRecord;
        this.headerRecord = headerRecord;
        this.rowNumbers = rowNumbers;
        this.id = id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CsvFormat)) {
            return false;
        }
        CsvFormat format = (CsvFormat)o;
        if (this.rowNumbers != format.rowNumbers) {
            return false;
        }
        if (!this.name.equals(format.name)) {
            return false;
        }
        if (!this.dataRecord.equals(format.dataRecord)) {
            return false;
        }
        if (this.headerRecord != null ? !this.headerRecord.equals(format.headerRecord) : format.headerRecord != null) {
            return false;
        }
        return this.id.equals(format.id);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.dataRecord.hashCode();
        result = 31 * result + (this.headerRecord != null ? this.headerRecord.hashCode() : 0);
        result = 31 * result + (this.rowNumbers ? 1 : 0);
        result = 31 * result + this.id.hashCode();
        return result;
    }

    public static int indexOfFormatNamed(@NotNull List<CsvFormat> formats, @Nullable String name) {
        if (formats == null) {
            CsvFormat.$$$reportNull$$$0(6);
        }
        return name == null ? -1 : ContainerUtil.indexOf(formats, format -> StringUtil.equals((CharSequence)name, (CharSequence)format.name));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataRecord";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formats";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/csv/CsvFormat";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "indexOfFormatNamed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

