/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.objectdiagram.command;

import net.sourceforge.plantuml.abel.Entity;
import net.sourceforge.plantuml.abel.LeafType;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.NameAndCodeParser;
import net.sourceforge.plantuml.command.ParserPass;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.klimt.color.ColorParser;
import net.sourceforge.plantuml.klimt.color.ColorType;
import net.sourceforge.plantuml.klimt.color.NoSuchColorException;
import net.sourceforge.plantuml.klimt.creole.CreoleMode;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.klimt.font.FontParam;
import net.sourceforge.plantuml.objectdiagram.AbstractClassOrObjectDiagram;
import net.sourceforge.plantuml.plasma.Quark;
import net.sourceforge.plantuml.regex.IRegex;
import net.sourceforge.plantuml.regex.RegexConcat;
import net.sourceforge.plantuml.regex.RegexLeaf;
import net.sourceforge.plantuml.regex.RegexResult;
import net.sourceforge.plantuml.stereo.Stereotype;
import net.sourceforge.plantuml.stereo.StereotypePattern;
import net.sourceforge.plantuml.url.Url;
import net.sourceforge.plantuml.url.UrlBuilder;
import net.sourceforge.plantuml.url.UrlMode;
import net.sourceforge.plantuml.utils.LineLocation;

public class CommandCreateEntityObject
extends SingleLineCommand2<AbstractClassOrObjectDiagram> {
    public CommandCreateEntityObject() {
        super(CommandCreateEntityObject.getRegexConcat());
    }

    private static IRegex getRegexConcat() {
        return RegexConcat.build(CommandCreateEntityObject.class.getName(), RegexLeaf.start(), new RegexLeaf(0, "TYPE", "object"), RegexLeaf.spaceOneOrMore(), NameAndCodeParser.nameAndCode(), StereotypePattern.optional("STEREO"), UrlBuilder.OPTIONAL, RegexLeaf.spaceZeroOrMore(), ColorParser.exp1(), RegexLeaf.end());
    }

    @Override
    protected CommandExecutionResult executeArg(AbstractClassOrObjectDiagram diagram, LineLocation location, RegexResult arg, ParserPass currentPass) throws NoSuchColorException {
        String s;
        String urlString;
        String idShort = diagram.cleanId(arg.getLazzy("CODE", 0));
        Quark<Entity> quark = diagram.quarkInContext(true, diagram.cleanId(idShort));
        String displayString = arg.getLazzy("DISPLAY", 0);
        String stereotype = arg.get("STEREO", 0);
        if (quark.getData() != null) {
            return CommandExecutionResult.error("Object already exists: " + quark.getName());
        }
        Display display = Display.getWithNewlines(diagram.getPragma(), displayString);
        if (Display.isNull(display)) {
            display = Display.getWithNewlines(diagram.getPragma(), quark.getName()).withCreoleMode(CreoleMode.SIMPLE_LINE);
        }
        Entity entity = diagram.reallyCreateLeaf(location, quark, display, LeafType.OBJECT, null);
        if (stereotype != null) {
            entity.setStereotype(Stereotype.build(stereotype, diagram.getSkinParam().getCircledCharacterRadius(), diagram.getSkinParam().getFont(null, false, FontParam.CIRCLED_CHARACTER), diagram.getSkinParam().getIHtmlColorSet()));
        }
        if ((urlString = arg.get("URL", 0)) != null) {
            UrlBuilder urlBuilder = new UrlBuilder(diagram.getSkinParam().getValue("topurl"), UrlMode.STRICT);
            Url url = urlBuilder.getUrl(urlString);
            entity.addUrl(url);
        }
        entity.setSpecificColorTOBEREMOVED(ColorType.BACK, (s = arg.get("COLOR", 0)) == null ? null : diagram.getSkinParam().getIHtmlColorSet().getColor(s));
        return CommandExecutionResult.ok();
    }
}

