/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.server.handlers;

import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.ext.ExceptionMapper;
import java.util.List;
import org.jboss.resteasy.reactive.server.core.Deployment;
import org.jboss.resteasy.reactive.server.core.RequestContextFactory;
import org.jboss.resteasy.reactive.server.core.ResteasyReactiveRequestContext;
import org.jboss.resteasy.reactive.server.handlers.MatrixParamHandler;
import org.jboss.resteasy.reactive.server.jaxrs.ProvidersImpl;
import org.jboss.resteasy.reactive.server.mapping.RequestMapper;
import org.jboss.resteasy.reactive.server.spi.ServerRestHandler;
import org.jboss.resteasy.reactive.spi.ThreadSetupAction;

public class RestInitialHandler
implements ServerRestHandler {
    final RequestMapper<InitialMatch> mappers;
    final Deployment deployment;
    final List<ServerRestHandler> preMappingHandlers;
    final ServerRestHandler[] initialChain;
    final ThreadSetupAction requestContext;
    final RequestContextFactory requestContextFactory;

    public RestInitialHandler(Deployment deployment) {
        this.mappers = new RequestMapper(deployment.getClassMappers());
        this.deployment = deployment;
        this.preMappingHandlers = deployment.getPreMatchHandlers();
        if (this.preMappingHandlers.isEmpty()) {
            this.initialChain = new ServerRestHandler[]{new MatrixParamHandler(), this};
        } else {
            this.initialChain = new ServerRestHandler[this.preMappingHandlers.size() + 2];
            this.initialChain[0] = new MatrixParamHandler();
            for (int i = 0; i < this.preMappingHandlers.size(); ++i) {
                this.initialChain[i + 1] = this.preMappingHandlers.get(i);
            }
            this.initialChain[this.initialChain.length - 1] = this;
        }
        this.requestContext = deployment.getThreadSetupAction();
        this.requestContextFactory = deployment.getRequestContextFactory();
    }

    public void beginProcessing(Object externalHttpContext) {
        ResteasyReactiveRequestContext rq = this.requestContextFactory.createContext(this.deployment, externalHttpContext, this.requestContext, this.initialChain, this.deployment.getAbortHandlerChain());
        rq.run();
    }

    public void beginProcessing(Object externalHttpContext, Throwable throwable) {
        ResteasyReactiveRequestContext rq = this.requestContextFactory.createContext(this.deployment, externalHttpContext, this.requestContext, this.initialChain, this.deployment.getAbortHandlerChain());
        rq.handleException(throwable);
        rq.run();
    }

    @Override
    public void handle(ResteasyReactiveRequestContext requestContext) throws Exception {
        RequestMapper.RequestMatch<InitialMatch> target = this.mappers.map(requestContext.getPathWithoutPrefix());
        if (target == null) {
            ProvidersImpl providers = requestContext.getProviders();
            ExceptionMapper<NotFoundException> exceptionMapper = providers.getExceptionMapper(NotFoundException.class);
            if (exceptionMapper != null && !this.deployment.isServletPresent()) {
                requestContext.requireCDIRequestScope();
                requestContext.handleException((Throwable)new NotFoundException());
                return;
            }
            if (requestContext.resumeExternalProcessing()) {
                return;
            }
        }
        requestContext.setupInitialMatchAndRestart(target);
    }

    public static class InitialMatch {
        public final ServerRestHandler[] handlers;
        public final int maxPathParams;

        public InitialMatch(ServerRestHandler[] handlers, int maxPathParams) {
            this.handlers = handlers;
            this.maxPathParams = maxPathParams;
        }
    }
}

