/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.share.session;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.server.share.CachedSharePartition;
import org.apache.kafka.server.share.session.ShareSessionKey;

public class ShareSession {
    private final ShareSessionKey key;
    private final ImplicitLinkedHashCollection<CachedSharePartition> partitionMap;
    public int epoch;
    private int cachedSize = -1;

    public ShareSession(ShareSessionKey key, ImplicitLinkedHashCollection<CachedSharePartition> partitionMap, int epoch) {
        this.key = key;
        this.partitionMap = partitionMap;
        this.epoch = epoch;
    }

    public ShareSessionKey key() {
        return this.key;
    }

    public synchronized int cachedSize() {
        return this.cachedSize;
    }

    public synchronized ImplicitLinkedHashCollection<CachedSharePartition> partitionMap() {
        return this.partitionMap;
    }

    public synchronized int epoch() {
        return this.epoch;
    }

    public synchronized int size() {
        return this.partitionMap.size();
    }

    public synchronized Boolean isEmpty() {
        return this.partitionMap.isEmpty();
    }

    public synchronized Map<ModifiedTopicIdPartitionType, List<TopicIdPartition>> update(List<TopicIdPartition> shareFetchData, List<TopicIdPartition> toForget) {
        ArrayList added = new ArrayList();
        ArrayList updated = new ArrayList();
        ArrayList removed = new ArrayList();
        shareFetchData.forEach(topicIdPartition -> {
            CachedSharePartition cachedSharePartitionKey = new CachedSharePartition((TopicIdPartition)topicIdPartition, true);
            CachedSharePartition cachedPart = (CachedSharePartition)this.partitionMap.find((ImplicitLinkedHashCollection.Element)cachedSharePartitionKey);
            if (cachedPart == null) {
                this.partitionMap.mustAdd((ImplicitLinkedHashCollection.Element)cachedSharePartitionKey);
                added.add(topicIdPartition);
            } else {
                updated.add(topicIdPartition);
            }
        });
        toForget.forEach(topicIdPartition -> {
            if (this.partitionMap.remove((Object)new CachedSharePartition((TopicIdPartition)topicIdPartition))) {
                removed.add(topicIdPartition);
            }
        });
        HashMap<ModifiedTopicIdPartitionType, List<TopicIdPartition>> result = new HashMap<ModifiedTopicIdPartitionType, List<TopicIdPartition>>();
        result.put(ModifiedTopicIdPartitionType.ADDED, added);
        result.put(ModifiedTopicIdPartitionType.UPDATED, updated);
        result.put(ModifiedTopicIdPartitionType.REMOVED, removed);
        return result;
    }

    public synchronized int updateCachedSize() {
        int previousSize = this.cachedSize;
        this.cachedSize = this.partitionMap.size();
        return previousSize != -1 ? this.cachedSize - previousSize : this.cachedSize;
    }

    public static String partitionsToLogString(Collection<TopicIdPartition> partitions, Boolean traceEnabled) {
        if (traceEnabled.booleanValue()) {
            return String.format("( %s )", String.join((CharSequence)", ", partitions.toString()));
        }
        return String.format("%s partition(s)", partitions.size());
    }

    public String toString() {
        return "ShareSession(key=" + String.valueOf(this.key) + ", partitionMap=" + String.valueOf(this.partitionMap) + ", epoch=" + this.epoch + ", cachedSize=" + this.cachedSize + ")";
    }

    public static enum ModifiedTopicIdPartitionType {
        ADDED,
        UPDATED,
        REMOVED;

    }
}

