#!/usr/bin/env python
import argparse
import os
import sys
try:
 import advisor
except ImportError:
 err_msg="""
    Python could not resolve path to Advisor\'s Python API directory. To fix, either manually add path
    to the Python API directory into PYTHONPATH environment variable, or use advixe-vars.* scripts to
    set up product environment variables automatically.
    """
 raise ImportError(err_msg)
def extract_data(proj_dir):
 project=advisor.open_project(proj_dir)
 survey=project.load(advisor.ALL)
 out_file="{}_debug.log".format(proj_dir)
 f=open(out_file,'wb')
 for row in survey.bottomup:
  if args.loops and not row['loop_function_id']in args.loops:
   continue
  f.write("{:#^80}\n".format(" {}, ID:{} ".format(row['function_call_sites_and_loops'],row['loop_function_id'])))
  for key in row:
   f.write('{}: {}\n'.format(key,row[key]))
 f.close()
def main():
 global args
 parser=argparse.ArgumentParser()
 parser.add_argument("-v","--verbose",dest="verbose",help="output verbosity",action="store_true",default=False)
 parser.add_argument("project_dir",help="path to advisor project dir")
 parser.add_argument("-f","--filter",dest="loops",nargs='*',help="Only process these loops")
 args=parser.parse_args()
 sanity_checks(args)
 extract_data(args.project_dir)
def sanity_checks(in_args):
 return
if __name__=='__main__':
 main()
