/*******************************************************************************
 * Copyright 2016 Intel Corporation.
 *
 *
 * This software and the related documents are Intel copyrighted materials, and your use of them is governed by
 * the express license under which they were provided to you ('License'). Unless the License provides otherwise,
 * you may not use, modify, copy, publish, distribute, disclose or transmit this software or the related
 * documents without Intel's prior written permission.
 * This software and the related documents are provided as is, with no express or implied warranties, other than
 * those that are expressly stated in the License.
 *******************************************************************************/

#ifndef __BASE_IW_H__
#define __BASE_IW_H__

#ifdef IPP_PRESERVE_OLD_LAYOUT
  #include "iw/iw.h"
#else /* IPP_PRESERVE_OLD_LAYOUT */
  #include "ipp/iw/iw.h"
#endif /* IPP_PRESERVE_OLD_LAYOUT */
#include "base_image.h"
#include "base_ipp.h"
#include "stdio.h"

static IwiColorFmt ImageColorToIpp(ColorFormat format)
{
    switch (format) {
    case CF_GRAY:
        return iwiColorGray;
    case CF_RGB:
        return iwiColorRGB;
    case CF_BGR:
        return iwiColorBGR;
    case CF_RGBA:
        return iwiColorRGBA;
    case CF_BGRA:
        return iwiColorBGRA;
    default:
        return (IwiColorFmt)-1;
    }
}

static ::IwsVector ImageToIwVector(Image &src)
{
    ::IwsVector vector;
    IwsBorderSize border = {(IwSize)(src.m_border.left + src.m_border.top * (src.m_step / src.m_sampleSize)),
                            (IwSize)(src.m_border.right + src.m_border.bottom * (src.m_step / src.m_sampleSize))};
    iwsVector_InitExternal(&vector, ImageSizeToLen(src.m_size), ImageFormatToIpp(src.m_sampleFormat), &border, src.ptr());
    return vector;
}

static ::IwiImage ImageToIwImage(Image &src)
{
    ::IwiImage image;
    IwiBorderSize border = {(IwSize)src.m_border.left, (IwSize)src.m_border.top, (IwSize)src.m_border.right, (IwSize)src.m_border.bottom};
    iwiImage_InitExternal(&image, ImageSizeToIpp(src.m_size), ImageFormatToIpp(src.m_sampleFormat), src.m_samples, &border, src.ptr(), src.m_step);
    return image;
}

static Image IwImageToImage(::IwiImage &src)
{
    Image image;
    image.AttachBuffer(Size(src.m_size.width, src.m_size.height), src.m_channels, IppFormatToImage(src.m_dataType), src.m_ptr, (size_t)src.m_step);
    image.m_border = BorderSize(src.m_inMemSize.left, src.m_inMemSize.top, src.m_inMemSize.right, src.m_inMemSize.bottom);
    return image;
}

static ::IwiRoi ImageRectToIwiRoi(Rect rect)
{
    ::IwiRoi iwiRoi = {(IwSize)rect.x, (IwSize)rect.y, (IwSize)rect.width, (IwSize)rect.height};
    return iwiRoi;
}

static Rect IwiRoiToImage(::IwiRoi roi)
{
    Rect rect(roi.x, roi.y, roi.width, roi.height);
    return rect;
}

static IwsRoi ImageRectToIwsRoi(Rect rect)
{
    IwsRoi iwsRoi = {(IwSize)rect.x, (IwSize)rect.width};
    return iwsRoi;
}

static IwiBorderSize ImageBorderSizeToIwi(BorderSize borderSize)
{
    IwiBorderSize ippBorder = {(IwSize)borderSize.left, (IwSize)borderSize.top, (IwSize)borderSize.right, (IwSize)borderSize.bottom};
    return ippBorder;
}

static BorderSize IwiBorderSizeToImage(IwiBorderSize borderSize)
{
    return BorderSize(borderSize.left, borderSize.top, borderSize.right, borderSize.bottom);
}

#endif
