/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.parser;

import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.parser.LexicalCallbackTH;
import io.sf.carte.doc.style.css.parser.LexicalProvider;
import io.sf.carte.doc.style.css.parser.LexicalUnitImpl;
import io.sf.carte.doc.style.css.parser.RGBColorUnitImpl;

class HexColorTH
extends LexicalCallbackTH {
    HexColorTH(LexicalProvider caller) {
        super(caller);
    }

    @Override
    public void word(int index, CharSequence word) {
        if (!this.parseHexColor(word)) {
            this.unexpectedTokenError(index, word);
        } else {
            this.yieldBack();
        }
    }

    private boolean parseHexColor(CharSequence word) {
        block6: {
            int buflen = word.length();
            try {
                if (buflen == 3) {
                    this.addFunctionOrExpressionUnit(new RGBColorUnitImpl());
                    this.currentlu.value = "rgb";
                    this.parseHexComponent(word, 0, 1, true);
                    this.parseHexComponent(word, 1, 2, true);
                    this.parseHexComponent(word, 2, 3, true);
                    this.recoverOwnerUnit(word);
                    break block6;
                }
                if (buflen == 6) {
                    this.addFunctionOrExpressionUnit(new RGBColorUnitImpl());
                    this.currentlu.value = "rgb";
                    this.parseHexComponent(word, 0, 2, false);
                    this.parseHexComponent(word, 2, 4, false);
                    this.parseHexComponent(word, 4, 6, false);
                    this.recoverOwnerUnit(word);
                    break block6;
                }
                if (buflen == 8) {
                    this.addFunctionOrExpressionUnit(new RGBColorUnitImpl());
                    this.currentlu.value = "rgb";
                    this.parseHexComponent(word, 0, 2, false);
                    this.parseHexComponent(word, 2, 4, false);
                    this.parseHexComponent(word, 4, 6, false);
                    int comp = HexColorTH.hexComponent(word, 6, 8, false);
                    this.newFunctionArgument(LexicalUnit.LexicalType.OPERATOR_SLASH);
                    this.newNumberArgument((LexicalUnit.LexicalType)LexicalUnit.LexicalType.REAL).floatValue = (float)comp / 255.0f;
                    this.recoverOwnerUnit(word);
                    break block6;
                }
                if (buflen == 4) {
                    this.addFunctionOrExpressionUnit(new RGBColorUnitImpl());
                    this.currentlu.value = "rgb";
                    this.parseHexComponent(word, 0, 1, true);
                    this.parseHexComponent(word, 1, 2, true);
                    this.parseHexComponent(word, 2, 3, true);
                    int comp = HexColorTH.hexComponent(word, 3, 4, true);
                    this.newFunctionArgument(LexicalUnit.LexicalType.OPERATOR_SLASH);
                    this.newNumberArgument((LexicalUnit.LexicalType)LexicalUnit.LexicalType.REAL).floatValue = (float)comp / 255.0f;
                    this.recoverOwnerUnit(word);
                    break block6;
                }
                return false;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return true;
    }

    private void parseHexComponent(CharSequence word, int start, int end, boolean doubleDigit) {
        int comp;
        this.newNumberArgument((LexicalUnit.LexicalType)LexicalUnit.LexicalType.INTEGER).intValue = comp = HexColorTH.hexComponent(word, start, end, doubleDigit);
    }

    private static int hexComponent(CharSequence word, int start, int end, boolean doubleDigit) {
        String s;
        if (doubleDigit) {
            CharSequence seq = word.subSequence(start, end);
            s = new StringBuilder(2).append(seq).append(seq).toString();
        } else {
            s = word.subSequence(start, end).toString();
        }
        return Integer.parseInt(s, 16);
    }

    private LexicalUnitImpl newNumberArgument(LexicalUnit.LexicalType sacType) {
        LexicalUnitImpl lu = this.newFunctionArgument(sacType);
        lu.setCssUnit((short)0);
        return lu;
    }

    private LexicalUnitImpl newFunctionArgument(LexicalUnit.LexicalType type) {
        LexicalUnitImpl arg = new LexicalUnitImpl(type);
        this.currentlu.addFunctionParameter(arg);
        return arg;
    }

    private void recoverOwnerUnit(CharSequence word) {
        this.currentlu.identCssText = "#" + word;
        if (this.currentlu.ownerLexicalUnit != null) {
            this.currentlu = this.currentlu.ownerLexicalUnit;
        }
    }

    @Override
    void processBuffer(int index, int triggerCp) {
    }

    @Override
    public void separator(int index, int codePoint) {
        this.unexpectedCharError(index, codePoint);
    }

    @Override
    void handleSemicolon(int index) {
        this.reportError(index, (byte)4, "Unexpected ';'.");
        this.caller.character(index, 59);
    }

    @Override
    public void escaped(int index, int codePoint) {
        this.unexpectedCharError(index, codePoint);
    }

    @Override
    public void commented(int index, int commentType, String comment) {
        this.unexpectedTokenError(index, comment);
    }

    @Override
    public void endOfStream(int len) {
        this.unexpectedEOFError(len);
        this.caller.endOfStream(len);
    }
}

