#pragma once
#include "livekit/webrtc.h"
#include <array>
#include <cstdint>
#include <memory>
#include <string>
#include <utility>

namespace rust {
inline namespace cxxbridge1 {
// #include "rust/cxx.h"

struct unsafe_bitcopy_t;

#ifndef CXXBRIDGE1_RUST_STRING
#define CXXBRIDGE1_RUST_STRING
class String final {
public:
  String() noexcept;
  String(const String &) noexcept;
  String(String &&) noexcept;
  ~String() noexcept;

  String(const std::string &);
  String(const char *);
  String(const char *, std::size_t);
  String(const char16_t *);
  String(const char16_t *, std::size_t);
#ifdef __cpp_char8_t
  String(const char8_t *s);
  String(const char8_t *s, std::size_t len);
#endif

  static String lossy(const std::string &) noexcept;
  static String lossy(const char *) noexcept;
  static String lossy(const char *, std::size_t) noexcept;
  static String lossy(const char16_t *) noexcept;
  static String lossy(const char16_t *, std::size_t) noexcept;

  String &operator=(const String &) & noexcept;
  String &operator=(String &&) & noexcept;

  explicit operator std::string() const;

  const char *data() const noexcept;
  std::size_t size() const noexcept;
  std::size_t length() const noexcept;
  bool empty() const noexcept;

  const char *c_str() noexcept;

  std::size_t capacity() const noexcept;
  void reserve(size_t new_cap) noexcept;

  using iterator = char *;
  iterator begin() noexcept;
  iterator end() noexcept;

  using const_iterator = const char *;
  const_iterator begin() const noexcept;
  const_iterator end() const noexcept;
  const_iterator cbegin() const noexcept;
  const_iterator cend() const noexcept;

  bool operator==(const String &) const noexcept;
  bool operator!=(const String &) const noexcept;
  bool operator<(const String &) const noexcept;
  bool operator<=(const String &) const noexcept;
  bool operator>(const String &) const noexcept;
  bool operator>=(const String &) const noexcept;

  void swap(String &) noexcept;

  String(unsafe_bitcopy_t, const String &) noexcept;

private:
  struct lossy_t;
  String(lossy_t, const char *, std::size_t) noexcept;
  String(lossy_t, const char16_t *, std::size_t) noexcept;
  friend void swap(String &lhs, String &rhs) noexcept { lhs.swap(rhs); }

  std::array<std::uintptr_t, 3> repr;
};
#endif // CXXBRIDGE1_RUST_STRING

#ifndef CXXBRIDGE1_RUST_FN
#define CXXBRIDGE1_RUST_FN
template <typename Signature>
class Fn;

template <typename Ret, typename... Args>
class Fn<Ret(Args...)> final {
public:
  Ret operator()(Args... args) const noexcept;
  Fn operator*() const noexcept;

private:
  Ret (*trampoline)(Args..., void *fn) noexcept;
  void *fn;
};

template <typename Ret, typename... Args>
Ret Fn<Ret(Args...)>::operator()(Args... args) const noexcept {
  return (*this->trampoline)(std::forward<Args>(args)..., this->fn);
}

template <typename Ret, typename... Args>
Fn<Ret(Args...)> Fn<Ret(Args...)>::operator*() const noexcept {
  return *this;
}
#endif // CXXBRIDGE1_RUST_FN
} // namespace cxxbridge1
} // namespace rust

namespace livekit {
  enum class MediaType : ::std::int32_t;
  enum class Priority : ::std::int32_t;
  enum class RtpTransceiverDirection : ::std::int32_t;
  enum class LoggingSeverity : ::std::int32_t;
  using LogSink = ::livekit::LogSink;
}

namespace livekit {
#ifndef CXXBRIDGE1_ENUM_livekit$MediaType
#define CXXBRIDGE1_ENUM_livekit$MediaType
enum class MediaType : ::std::int32_t {
  Audio = 0,
  Video = 1,
  Data = 2,
  Unsupported = 3,
};
#endif // CXXBRIDGE1_ENUM_livekit$MediaType

#ifndef CXXBRIDGE1_ENUM_livekit$Priority
#define CXXBRIDGE1_ENUM_livekit$Priority
enum class Priority : ::std::int32_t {
  VeryLow = 0,
  Low = 1,
  Medium = 2,
  High = 3,
};
#endif // CXXBRIDGE1_ENUM_livekit$Priority

#ifndef CXXBRIDGE1_ENUM_livekit$RtpTransceiverDirection
#define CXXBRIDGE1_ENUM_livekit$RtpTransceiverDirection
enum class RtpTransceiverDirection : ::std::int32_t {
  SendRecv = 0,
  SendOnly = 1,
  RecvOnly = 2,
  Inactive = 3,
  Stopped = 4,
};
#endif // CXXBRIDGE1_ENUM_livekit$RtpTransceiverDirection

#ifndef CXXBRIDGE1_ENUM_livekit$LoggingSeverity
#define CXXBRIDGE1_ENUM_livekit$LoggingSeverity
enum class LoggingSeverity : ::std::int32_t {
  Verbose = 0,
  Info = 1,
  Warning = 2,
  Error = 3,
  None = 4,
};
#endif // CXXBRIDGE1_ENUM_livekit$LoggingSeverity
} // namespace livekit
