#ifndef AV_VERSION_INT
# define AV_VERSION_INT(a,b,c) 0x7FFFFFFF
#endif
const ff_codec_t ff_video_lookup[] = {
  { BUF_VIDEO_MSMPEG4_V1, AV_CODEC_ID_MSMPEG4V1, "Microsoft MPEG-4 v1 (ffmpeg)" },
  { BUF_VIDEO_MSMPEG4_V2, AV_CODEC_ID_MSMPEG4V2, "Microsoft MPEG-4 v2 (ffmpeg)" },
  { BUF_VIDEO_MSMPEG4_V3, AV_CODEC_ID_MSMPEG4V3, "Microsoft MPEG-4 v3 (ffmpeg)" },
  { BUF_VIDEO_WMV7, AV_CODEC_ID_WMV1, "MS Windows Media Video 7 (ffmpeg)" },
  { BUF_VIDEO_WMV8, AV_CODEC_ID_WMV2, "MS Windows Media Video 8 (ffmpeg)" },
  { BUF_VIDEO_WMV9, AV_CODEC_ID_WMV3, "MS Windows Media Video 9 (ffmpeg)" },
  { BUF_VIDEO_VC1, AV_CODEC_ID_VC1, "MS Windows Media Video VC-1 (ffmpeg)" },
  { BUF_VIDEO_MPEG4, AV_CODEC_ID_MPEG4, "ISO MPEG-4 (ffmpeg)" },
  { BUF_VIDEO_XVID, AV_CODEC_ID_MPEG4, "ISO MPEG-4 (XviD) (ffmpeg)" },
  { BUF_VIDEO_DIVX5, AV_CODEC_ID_MPEG4, "ISO MPEG-4 (DivX5) (ffmpeg)" },
  { BUF_VIDEO_3IVX, AV_CODEC_ID_MPEG4, "ISO MPEG-4 (3ivx) (ffmpeg)" },
  { BUF_VIDEO_JPEG, AV_CODEC_ID_MJPEG, "Motion JPEG (ffmpeg)" },
  { BUF_VIDEO_MJPEG, AV_CODEC_ID_MJPEG, "Motion JPEG (ffmpeg)" },
  { BUF_VIDEO_MJPEG_B, AV_CODEC_ID_MJPEGB, "Motion JPEG B (ffmpeg)" },
  { BUF_VIDEO_I263, AV_CODEC_ID_H263I, "ITU H.263 (ffmpeg)" },
  { BUF_VIDEO_H263, AV_CODEC_ID_H263, "H.263 (ffmpeg)" },
  { BUF_VIDEO_RV10, AV_CODEC_ID_RV10, "Real Video 1.0 (ffmpeg)" },
  { BUF_VIDEO_RV20, AV_CODEC_ID_RV20, "Real Video 2.0 (ffmpeg)" },
  { BUF_VIDEO_RV30, AV_CODEC_ID_RV30, "Real Video 3.0 (ffmpeg)" },
  { BUF_VIDEO_RV40, AV_CODEC_ID_RV40, "Real Video 4.0 (ffmpeg)" },
  { BUF_VIDEO_IV31, AV_CODEC_ID_INDEO3, "Indeo Video 3.1 (ffmpeg)" },
  { BUF_VIDEO_IV32, AV_CODEC_ID_INDEO3, "Indeo Video 3.2 (ffmpeg)" },
  { BUF_VIDEO_SORENSON_V1, AV_CODEC_ID_SVQ1, "Sorenson Video 1 (ffmpeg)" },
  { BUF_VIDEO_SORENSON_V3, AV_CODEC_ID_SVQ3, "Sorenson Video 3 (ffmpeg)" },
  { BUF_VIDEO_DV, AV_CODEC_ID_DVVIDEO, "DV (ffmpeg)" },
  { BUF_VIDEO_HUFFYUV, AV_CODEC_ID_HUFFYUV, "HuffYUV (ffmpeg)" },
  { BUF_VIDEO_VP31, AV_CODEC_ID_VP3, "On2 VP3.1 (ffmpeg)" },
  { BUF_VIDEO_VP5, AV_CODEC_ID_VP5, "On2 VP5 (ffmpeg)" },
  { BUF_VIDEO_VP6, AV_CODEC_ID_VP6, "On2 VP6 (ffmpeg)" },
  { BUF_VIDEO_VP6F, AV_CODEC_ID_VP6F, "On2 VP6 (ffmpeg)" },
  { BUF_VIDEO_VP8, AV_CODEC_ID_VP8, "On2 VP8 (ffmpeg)" },
  { BUF_VIDEO_VP9, AV_CODEC_ID_VP9, "VP9 (ffmpeg)" },
  { BUF_VIDEO_AV1, AV_CODEC_ID_AV1, "AV1 (ffmpeg)" },
  { BUF_VIDEO_4XM, AV_CODEC_ID_4XM, "4X Video (ffmpeg)" },
  { BUF_VIDEO_CINEPAK, AV_CODEC_ID_CINEPAK, "Cinepak (ffmpeg)" },
  { BUF_VIDEO_MSVC, AV_CODEC_ID_MSVIDEO1, "Microsoft Video 1 (ffmpeg)" },
  { BUF_VIDEO_MSRLE, AV_CODEC_ID_MSRLE, "Microsoft RLE (ffmpeg)" },
  { BUF_VIDEO_RPZA, AV_CODEC_ID_RPZA, "Apple Quicktime Video/RPZA (ffmpeg)" },
  { BUF_VIDEO_CYUV, AV_CODEC_ID_CYUV, "Creative YUV (ffmpeg)" },
  { BUF_VIDEO_ROQ, AV_CODEC_ID_ROQ, "Id Software RoQ (ffmpeg)" },
  { BUF_VIDEO_IDCIN, AV_CODEC_ID_IDCIN, "Id Software CIN (ffmpeg)" },
  { BUF_VIDEO_WC3, AV_CODEC_ID_XAN_WC3, "Xan (ffmpeg)" },
  { BUF_VIDEO_VQA, AV_CODEC_ID_WS_VQA, "Westwood Studios VQA (ffmpeg)" },
  { BUF_VIDEO_INTERPLAY, AV_CODEC_ID_INTERPLAY_VIDEO, "Interplay MVE (ffmpeg)" },
  { BUF_VIDEO_FLI, AV_CODEC_ID_FLIC, "FLIC Video (ffmpeg)" },
  { BUF_VIDEO_8BPS, AV_CODEC_ID_8BPS, "Planar RGB (ffmpeg)" },
  { BUF_VIDEO_SMC, AV_CODEC_ID_SMC, "Apple Quicktime Graphics/SMC (ffmpeg)" },
  { BUF_VIDEO_DUCKTM1, AV_CODEC_ID_TRUEMOTION1, "Duck TrueMotion v1 (ffmpeg)" },
  { BUF_VIDEO_DUCKTM2, AV_CODEC_ID_TRUEMOTION2, "Duck TrueMotion v2 (ffmpeg)" },
  { BUF_VIDEO_VMD, AV_CODEC_ID_VMDVIDEO, "Sierra VMD Video (ffmpeg)" },
  { BUF_VIDEO_ZLIB, AV_CODEC_ID_ZLIB, "ZLIB Video (ffmpeg)" },
  { BUF_VIDEO_MSZH, AV_CODEC_ID_MSZH, "MSZH Video (ffmpeg)" },
  { BUF_VIDEO_ASV1, AV_CODEC_ID_ASV1, "ASV v1 Video (ffmpeg)" },
  { BUF_VIDEO_ASV2, AV_CODEC_ID_ASV2, "ASV v2 Video (ffmpeg)" },
  { BUF_VIDEO_ATIVCR1, AV_CODEC_ID_VCR1, "ATI VCR-1 (ffmpeg)" },
  { BUF_VIDEO_FLV1, AV_CODEC_ID_FLV1, "Flash Video (ffmpeg)" },
  { BUF_VIDEO_QTRLE, AV_CODEC_ID_QTRLE, "Apple Quicktime Animation/RLE (ffmpeg)" },
  { BUF_VIDEO_H264, AV_CODEC_ID_H264, "H.264/AVC (ffmpeg)" },
  { BUF_VIDEO_H261, AV_CODEC_ID_H261, "H.261 (ffmpeg)" },
  { BUF_VIDEO_AASC, AV_CODEC_ID_AASC, "Autodesk Video (ffmpeg)" },
  { BUF_VIDEO_LOCO, AV_CODEC_ID_LOCO, "LOCO (ffmpeg)" },
  { BUF_VIDEO_QDRW, AV_CODEC_ID_QDRAW, "QuickDraw (ffmpeg)" },
  { BUF_VIDEO_QPEG, AV_CODEC_ID_QPEG, "Q-Team QPEG (ffmpeg)" },
  { BUF_VIDEO_TSCC, AV_CODEC_ID_TSCC, "TechSmith Video (ffmpeg)" },
  { BUF_VIDEO_ULTI, AV_CODEC_ID_ULTI, "IBM UltiMotion (ffmpeg)" },
  { BUF_VIDEO_WNV1, AV_CODEC_ID_WNV1, "Winnow Video (ffmpeg)" },
  { BUF_VIDEO_XL, AV_CODEC_ID_VIXL, "Miro/Pinnacle VideoXL (ffmpeg)" },
  { BUF_VIDEO_RT21, AV_CODEC_ID_INDEO2, "Indeo/RealTime 2 (ffmpeg)" },
  { BUF_VIDEO_FPS1, AV_CODEC_ID_FRAPS, "Fraps (ffmpeg)" },
  { BUF_VIDEO_MPEG, AV_CODEC_ID_MPEG2VIDEO, "MPEG 1/2 (ffmpeg)" },
  { BUF_VIDEO_CSCD, AV_CODEC_ID_CSCD, "CamStudio (ffmpeg)" },
  { BUF_VIDEO_AVS, AV_CODEC_ID_AVS, "AVS (ffmpeg)" },
  { BUF_VIDEO_ALGMM, AV_CODEC_ID_MMVIDEO, "American Laser Games MM (ffmpeg)" },
  { BUF_VIDEO_ZMBV, AV_CODEC_ID_ZMBV, "Zip Motion Blocks Video (ffmpeg)" },
  { BUF_VIDEO_SMACKER, AV_CODEC_ID_SMACKVIDEO, "Smacker (ffmpeg)" },
  { BUF_VIDEO_NUV, AV_CODEC_ID_NUV, "NuppelVideo (ffmpeg)" },
  { BUF_VIDEO_KMVC, AV_CODEC_ID_KMVC, "Karl Morton's Video Codec (ffmpeg)" },
  { BUF_VIDEO_FLASHSV, AV_CODEC_ID_FLASHSV, "Flash Screen Video (ffmpeg)" },
  { BUF_VIDEO_CAVS, AV_CODEC_ID_CAVS, "Chinese AVS (ffmpeg)" },
  { BUF_VIDEO_VMNC, AV_CODEC_ID_VMNC, "VMware Screen Codec (ffmpeg)" },
  { BUF_VIDEO_THEORA_RAW, AV_CODEC_ID_THEORA, "Theora (ffmpeg)" },
  { BUF_VIDEO_SNOW, AV_CODEC_ID_SNOW, "Snow (ffmpeg)" },
  { BUF_VIDEO_HEVC, AV_CODEC_ID_HEVC, "HEVC/H.265 (ffmpeg)" },
};

static const uint32_t supported_video_types[] = {
  BUF_VIDEO_MSMPEG4_V1,
  BUF_VIDEO_MSMPEG4_V2,
  BUF_VIDEO_MSMPEG4_V3,
  BUF_VIDEO_WMV7,
  BUF_VIDEO_WMV8,
  BUF_VIDEO_WMV9,
  BUF_VIDEO_VC1,
  BUF_VIDEO_MPEG4,
  BUF_VIDEO_XVID,
  BUF_VIDEO_DIVX5,
  BUF_VIDEO_3IVX,
  BUF_VIDEO_JPEG,
  BUF_VIDEO_MJPEG,
  BUF_VIDEO_MJPEG_B,
  BUF_VIDEO_I263,
  BUF_VIDEO_H263,
  BUF_VIDEO_RV10,
  BUF_VIDEO_RV20,
  BUF_VIDEO_RV30,
  BUF_VIDEO_RV40,
  BUF_VIDEO_IV31,
  BUF_VIDEO_IV32,
  BUF_VIDEO_SORENSON_V1,
  BUF_VIDEO_SORENSON_V3,
  BUF_VIDEO_DV,
  BUF_VIDEO_HUFFYUV,
  BUF_VIDEO_VP31,
  BUF_VIDEO_VP5,
  BUF_VIDEO_VP6,
  BUF_VIDEO_VP6F,
  BUF_VIDEO_VP8,
  BUF_VIDEO_VP9,
  BUF_VIDEO_AV1,
  BUF_VIDEO_4XM,
  BUF_VIDEO_CINEPAK,
  BUF_VIDEO_MSVC,
  BUF_VIDEO_MSRLE,
  BUF_VIDEO_RPZA,
  BUF_VIDEO_CYUV,
  BUF_VIDEO_ROQ,
  BUF_VIDEO_IDCIN,
  BUF_VIDEO_WC3,
  BUF_VIDEO_VQA,
  BUF_VIDEO_INTERPLAY,
  BUF_VIDEO_FLI,
  BUF_VIDEO_8BPS,
  BUF_VIDEO_SMC,
  BUF_VIDEO_DUCKTM1,
  BUF_VIDEO_DUCKTM2,
  BUF_VIDEO_VMD,
  BUF_VIDEO_ZLIB,
  BUF_VIDEO_MSZH,
  BUF_VIDEO_ASV1,
  BUF_VIDEO_ASV2,
  BUF_VIDEO_ATIVCR1,
  BUF_VIDEO_FLV1,
  BUF_VIDEO_QTRLE,
  BUF_VIDEO_H264,
  BUF_VIDEO_H261,
  BUF_VIDEO_AASC,
  BUF_VIDEO_LOCO,
  BUF_VIDEO_QDRW,
  BUF_VIDEO_QPEG,
  BUF_VIDEO_TSCC,
  BUF_VIDEO_ULTI,
  BUF_VIDEO_WNV1,
  BUF_VIDEO_XL,
  BUF_VIDEO_RT21,
  BUF_VIDEO_FPS1,
  BUF_VIDEO_MPEG,
  BUF_VIDEO_CSCD,
  BUF_VIDEO_AVS,
  BUF_VIDEO_ALGMM,
  BUF_VIDEO_ZMBV,
  BUF_VIDEO_SMACKER,
  BUF_VIDEO_NUV,
  BUF_VIDEO_KMVC,
  BUF_VIDEO_FLASHSV,
  BUF_VIDEO_CAVS,
  BUF_VIDEO_VMNC,
  BUF_VIDEO_THEORA_RAW,
  BUF_VIDEO_SNOW,
  BUF_VIDEO_HEVC,
  0,
};
