/*
 * Copyright (c) 2016 Apple Inc. All rights reserved.
 * Copyright (c) 2016 Canon Inc.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 * 
 */

// DO NOT EDIT THIS FILE. It is automatically generated from JavaScript files for
// builtins by the script: Source/JavaScriptCore/Scripts/generate-js-builtins.py

#include "config.h"
#include "ReadableByteStreamControllerBuiltins.h"

#include "WebCoreJSClientData.h"
#include <JavaScriptCore/IdentifierInlines.h>
#include <JavaScriptCore/ImplementationVisibility.h>
#include <JavaScriptCore/Intrinsic.h>
#include <JavaScriptCore/JSObjectInlines.h>
#include <JavaScriptCore/VM.h>

namespace WebCore {

constinit const JSC::ConstructAbility s_readableByteStreamControllerInitializeReadableByteStreamControllerCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
constinit const JSC::ConstructorKind s_readableByteStreamControllerInitializeReadableByteStreamControllerCodeConstructorKind = JSC::ConstructorKind::None;
constinit const JSC::ImplementationVisibility s_readableByteStreamControllerInitializeReadableByteStreamControllerCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
constinit const JSC::InlineAttribute s_readableByteStreamControllerInitializeReadableByteStreamControllerCodeInlineAttribute = JSC::InlineAttribute::None;
constinit const int s_readableByteStreamControllerInitializeReadableByteStreamControllerCodeLength = 366;
static constinit const JSC::Intrinsic s_readableByteStreamControllerInitializeReadableByteStreamControllerCodeIntrinsic = JSC::NoIntrinsic;
constinit const char* const s_readableByteStreamControllerInitializeReadableByteStreamControllerCode =
    "(function (stream, underlyingByteSource, highWaterMark)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    if (arguments.length !== 4 && arguments[3] !== @isReadableStream)\n" \
    "        @throwTypeError(\"ReadableByteStreamController constructor should not be called directly\");\n" \
    "\n" \
    "    return @privateInitializeReadableByteStreamController.@call(this, stream, underlyingByteSource, highWaterMark);\n" \
    "})\n" \
;

constinit const JSC::ConstructAbility s_readableByteStreamControllerEnqueueCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
constinit const JSC::ConstructorKind s_readableByteStreamControllerEnqueueCodeConstructorKind = JSC::ConstructorKind::None;
constinit const JSC::ImplementationVisibility s_readableByteStreamControllerEnqueueCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
constinit const JSC::InlineAttribute s_readableByteStreamControllerEnqueueCodeInlineAttribute = JSC::InlineAttribute::None;
constinit const int s_readableByteStreamControllerEnqueueCodeLength = 739;
static constinit const JSC::Intrinsic s_readableByteStreamControllerEnqueueCodeIntrinsic = JSC::NoIntrinsic;
constinit const char* const s_readableByteStreamControllerEnqueueCode =
    "(function (chunk)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    if (!@isReadableByteStreamController(this))\n" \
    "        throw @makeThisTypeError(\"ReadableByteStreamController\", \"enqueue\");\n" \
    "\n" \
    "    if (@getByIdDirectPrivate(this, \"closeRequested\"))\n" \
    "        @throwTypeError(\"ReadableByteStreamController is requested to close\");\n" \
    "\n" \
    "    if (@getByIdDirectPrivate(@getByIdDirectPrivate(this, \"controlledReadableStream\"), \"state\") !== @streamReadable)\n" \
    "        @throwTypeError(\"ReadableStream is not readable\");\n" \
    "\n" \
    "    if (!@isObject(chunk))\n" \
    "        @throwTypeError(\"Provided chunk is not an object\");\n" \
    "\n" \
    "    if (!@ArrayBuffer.@isView(chunk))\n" \
    "        @throwTypeError(\"Provided chunk is not an ArrayBuffer view\");\n" \
    "\n" \
    "    return @readableByteStreamControllerEnqueue(this, chunk);\n" \
    "})\n" \
;

constinit const JSC::ConstructAbility s_readableByteStreamControllerErrorCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
constinit const JSC::ConstructorKind s_readableByteStreamControllerErrorCodeConstructorKind = JSC::ConstructorKind::None;
constinit const JSC::ImplementationVisibility s_readableByteStreamControllerErrorCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
constinit const JSC::InlineAttribute s_readableByteStreamControllerErrorCodeInlineAttribute = JSC::InlineAttribute::None;
constinit const int s_readableByteStreamControllerErrorCodeLength = 396;
static constinit const JSC::Intrinsic s_readableByteStreamControllerErrorCodeIntrinsic = JSC::NoIntrinsic;
constinit const char* const s_readableByteStreamControllerErrorCode =
    "(function (error)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    if (!@isReadableByteStreamController(this))\n" \
    "        throw @makeThisTypeError(\"ReadableByteStreamController\", \"error\");\n" \
    "\n" \
    "    if (@getByIdDirectPrivate(@getByIdDirectPrivate(this, \"controlledReadableStream\"), \"state\") !== @streamReadable)\n" \
    "        @throwTypeError(\"ReadableStream is not readable\");\n" \
    "\n" \
    "    @readableByteStreamControllerError(this, error);\n" \
    "})\n" \
;

constinit const JSC::ConstructAbility s_readableByteStreamControllerCloseCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
constinit const JSC::ConstructorKind s_readableByteStreamControllerCloseCodeConstructorKind = JSC::ConstructorKind::None;
constinit const JSC::ImplementationVisibility s_readableByteStreamControllerCloseCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
constinit const JSC::InlineAttribute s_readableByteStreamControllerCloseCodeInlineAttribute = JSC::InlineAttribute::None;
constinit const int s_readableByteStreamControllerCloseCodeLength = 501;
static constinit const JSC::Intrinsic s_readableByteStreamControllerCloseCodeIntrinsic = JSC::NoIntrinsic;
constinit const char* const s_readableByteStreamControllerCloseCode =
    "(function ()\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    if (!@isReadableByteStreamController(this))\n" \
    "        throw @makeThisTypeError(\"ReadableByteStreamController\", \"close\");\n" \
    "\n" \
    "    if (@getByIdDirectPrivate(this, \"closeRequested\"))\n" \
    "        @throwTypeError(\"Close has already been requested\");\n" \
    "\n" \
    "    if (@getByIdDirectPrivate(@getByIdDirectPrivate(this, \"controlledReadableStream\"), \"state\") !== @streamReadable)\n" \
    "        @throwTypeError(\"ReadableStream is not readable\");\n" \
    "\n" \
    "    @readableByteStreamControllerClose(this);\n" \
    "})\n" \
;

constinit const JSC::ConstructAbility s_readableByteStreamControllerByobRequestCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
constinit const JSC::ConstructorKind s_readableByteStreamControllerByobRequestCodeConstructorKind = JSC::ConstructorKind::None;
constinit const JSC::ImplementationVisibility s_readableByteStreamControllerByobRequestCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
constinit const JSC::InlineAttribute s_readableByteStreamControllerByobRequestCodeInlineAttribute = JSC::InlineAttribute::None;
constinit const int s_readableByteStreamControllerByobRequestCodeLength = 759;
static constinit const JSC::Intrinsic s_readableByteStreamControllerByobRequestCodeIntrinsic = JSC::NoIntrinsic;
constinit const char* const s_readableByteStreamControllerByobRequestCode =
    "(function ()\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    if (!@isReadableByteStreamController(this))\n" \
    "        throw @makeGetterTypeError(\"ReadableByteStreamController\", \"byobRequest\");\n" \
    "\n" \
    "    if (@getByIdDirectPrivate(this, \"byobRequest\") === @undefined && @getByIdDirectPrivate(this, \"pendingPullIntos\").length) {\n" \
    "        const firstDescriptor = @getByIdDirectPrivate(this, \"pendingPullIntos\")[0];\n" \
    "        const view = new @Uint8Array(firstDescriptor.buffer,\n" \
    "            firstDescriptor.byteOffset + firstDescriptor.bytesFilled,\n" \
    "            firstDescriptor.byteLength - firstDescriptor.bytesFilled);\n" \
    "        @putByIdDirectPrivate(this, \"byobRequest\", new @ReadableStreamBYOBRequest(this, view, @isReadableStream));\n" \
    "    }\n" \
    "\n" \
    "    return @getByIdDirectPrivate(this, \"byobRequest\");\n" \
    "})\n" \
;

constinit const JSC::ConstructAbility s_readableByteStreamControllerDesiredSizeCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
constinit const JSC::ConstructorKind s_readableByteStreamControllerDesiredSizeCodeConstructorKind = JSC::ConstructorKind::None;
constinit const JSC::ImplementationVisibility s_readableByteStreamControllerDesiredSizeCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
constinit const JSC::InlineAttribute s_readableByteStreamControllerDesiredSizeCodeInlineAttribute = JSC::InlineAttribute::None;
constinit const int s_readableByteStreamControllerDesiredSizeCodeLength = 231;
static constinit const JSC::Intrinsic s_readableByteStreamControllerDesiredSizeCodeIntrinsic = JSC::NoIntrinsic;
constinit const char* const s_readableByteStreamControllerDesiredSizeCode =
    "(function ()\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    if (!@isReadableByteStreamController(this))\n" \
    "        throw @makeGetterTypeError(\"ReadableByteStreamController\", \"desiredSize\");\n" \
    "\n" \
    "    return @readableByteStreamControllerGetDesiredSize(this);\n" \
    "})\n" \
;


#define DEFINE_BUILTIN_GENERATOR(codeName, functionName, overriddenName, argumentCount) \
JSC::FunctionExecutable* codeName##Generator(JSC::VM& vm) \
{\
    JSVMClientData* clientData = downcast<JSVMClientData>(vm.clientData); \
    return clientData->builtinFunctions().readableByteStreamControllerBuiltins().codeName##Executable()->link(vm, nullptr, clientData->builtinFunctions().readableByteStreamControllerBuiltins().codeName##Source(), std::nullopt, s_##codeName##Intrinsic); \
}
WEBCORE_FOREACH_READABLEBYTESTREAMCONTROLLER_BUILTIN_CODE(DEFINE_BUILTIN_GENERATOR)
#undef DEFINE_BUILTIN_GENERATOR


} // namespace WebCore
