/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSHdrMetadataType.h"

#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <wtf/NeverDestroyed.h>
#include <wtf/SortedArrayMap.h>



namespace WebCore {
using namespace JSC;

String convertEnumerationToString(HdrMetadataType enumerationValue)
{
    static const std::array<NeverDestroyed<String>, 3> values {
        MAKE_STATIC_STRING_IMPL("smpteSt2086"),
        MAKE_STATIC_STRING_IMPL("smpteSt2094-10"),
        MAKE_STATIC_STRING_IMPL("smpteSt2094-40"),
    };
    static_assert(static_cast<size_t>(HdrMetadataType::SmpteSt2086) == 0, "HdrMetadataType::SmpteSt2086 is not 0 as expected");
    static_assert(static_cast<size_t>(HdrMetadataType::SmpteSt209410) == 1, "HdrMetadataType::SmpteSt209410 is not 1 as expected");
    static_assert(static_cast<size_t>(HdrMetadataType::SmpteSt209440) == 2, "HdrMetadataType::SmpteSt209440 is not 2 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < std::size(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(VM& vm, HdrMetadataType enumerationValue)
{
    return jsStringWithCache(vm, convertEnumerationToString(enumerationValue));
}

template<> std::optional<HdrMetadataType> parseEnumerationFromString<HdrMetadataType>(const String& stringValue)
{
    static constexpr std::array<std::pair<ComparableASCIILiteral, HdrMetadataType>, 3> mappings {
        std::pair<ComparableASCIILiteral, HdrMetadataType> { "smpteSt2086"_s, HdrMetadataType::SmpteSt2086 },
        std::pair<ComparableASCIILiteral, HdrMetadataType> { "smpteSt2094-10"_s, HdrMetadataType::SmpteSt209410 },
        std::pair<ComparableASCIILiteral, HdrMetadataType> { "smpteSt2094-40"_s, HdrMetadataType::SmpteSt209440 },
    };
    static constexpr SortedArrayMap enumerationMapping { mappings };
    if (auto* enumerationValue = enumerationMapping.tryGet(stringValue); enumerationValue) [[likely]]
        return *enumerationValue;
    return std::nullopt;
}

template<> std::optional<HdrMetadataType> parseEnumeration<HdrMetadataType>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    return parseEnumerationFromString<HdrMetadataType>(value.toWTFString(&lexicalGlobalObject));
}

template<> ASCIILiteral expectedEnumerationValues<HdrMetadataType>()
{
    return "\"smpteSt2086\", \"smpteSt2094-10\", \"smpteSt2094-40\""_s;
}

} // namespace WebCore

