/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_AUDIO)

#include "JSAudioDestinationNode.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>

namespace WebCore {
using namespace JSC;

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsAudioDestinationNodeConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsAudioDestinationNode_maxChannelCount);

class JSAudioDestinationNodePrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSAudioDestinationNodePrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSAudioDestinationNodePrototype* ptr = new (NotNull, JSC::allocateCell<JSAudioDestinationNodePrototype>(vm)) JSAudioDestinationNodePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSAudioDestinationNodePrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSAudioDestinationNodePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSAudioDestinationNodePrototype, JSAudioDestinationNodePrototype::Base);

using JSAudioDestinationNodeDOMConstructor = JSDOMConstructorNotConstructable<JSAudioDestinationNode>;

template<> const ClassInfo JSAudioDestinationNodeDOMConstructor::s_info = { "AudioDestinationNode"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSAudioDestinationNodeDOMConstructor) };

template<> JSValue JSAudioDestinationNodeDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSAudioNode::getConstructor(vm, &globalObject);
}

template<> void JSAudioDestinationNodeDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "AudioDestinationNode"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSAudioDestinationNode::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const std::array<HashTableValue, 2> JSAudioDestinationNodePrototypeTableValues {
    HashTableValue { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsAudioDestinationNodeConstructor, 0 } },
    HashTableValue { "maxChannelCount"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsAudioDestinationNode_maxChannelCount, 0 } },
};

const ClassInfo JSAudioDestinationNodePrototype::s_info = { "AudioDestinationNode"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSAudioDestinationNodePrototype) };

void JSAudioDestinationNodePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSAudioDestinationNode::info(), JSAudioDestinationNodePrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSAudioDestinationNode::s_info = { "AudioDestinationNode"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSAudioDestinationNode) };

JSAudioDestinationNode::JSAudioDestinationNode(Structure* structure, JSDOMGlobalObject& globalObject, Ref<AudioDestinationNode>&& impl)
    : JSAudioNode(structure, globalObject, WTFMove(impl))
{
}

Ref<AudioDestinationNode> JSAudioDestinationNode::protectedWrapped() const
{
    return wrapped();
}

static_assert(!std::is_base_of<ActiveDOMObject, AudioDestinationNode>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSAudioDestinationNode::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSAudioDestinationNodePrototype::createStructure(vm, &globalObject, JSAudioNode::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSAudioDestinationNodePrototype::create(vm, &globalObject, structure);
}

JSObject* JSAudioDestinationNode::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSAudioDestinationNode>(vm, globalObject);
}

JSValue JSAudioDestinationNode::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSAudioDestinationNodeDOMConstructor, DOMConstructorID::AudioDestinationNode>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsAudioDestinationNodeConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSAudioDestinationNodePrototype*>(JSValue::decode(thisValue));
    if (!prototype) [[unlikely]]
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSAudioDestinationNode::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsAudioDestinationNode_maxChannelCountGetter(JSGlobalObject& lexicalGlobalObject, JSAudioDestinationNode& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.maxChannelCount())));
}

JSC_DEFINE_CUSTOM_GETTER(jsAudioDestinationNode_maxChannelCount, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSAudioDestinationNode>::get<jsAudioDestinationNode_maxChannelCountGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

JSC::GCClient::IsoSubspace* JSAudioDestinationNode::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSAudioDestinationNode, UseCustomHeapCellType::No>(vm, "JSAudioDestinationNode"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForAudioDestinationNode.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForAudioDestinationNode = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForAudioDestinationNode.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForAudioDestinationNode = std::forward<decltype(space)>(space); }
    );
}

void JSAudioDestinationNode::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSAudioDestinationNode*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<AudioDestinationNode>&& impl)
{
    return createWrapper<AudioDestinationNode>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, AudioDestinationNode& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}


}

#endif // ENABLE(WEB_AUDIO)
