// java wrapper for vtkXMLDataWriterHelper object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkXMLDataWriterHelper.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkXMLWriter_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkXMLDataWriterHelper_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkXMLDataWriterHelper",dType)) { return me; }
  if ((res= vtkXMLWriter_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkXMLDataWriterHelper_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkXMLDataWriterHelper* op = static_cast<vtkXMLDataWriterHelper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkXMLDataWriterHelper_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkXMLDataWriterHelper* op = static_cast<vtkXMLDataWriterHelper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkXMLDataWriterHelper_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkXMLDataWriterHelper* op = static_cast<vtkXMLDataWriterHelper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkXMLDataWriterHelper_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkXMLDataWriterHelper* op = static_cast<vtkXMLDataWriterHelper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXMLDataWriterHelper_SetWriter_14(JNIEnv* env, jobject obj,jobject id0)
{
  vtkXMLWriter2 * temp0;
  temp0 = static_cast<vtkXMLWriter2*>(vtkJavaGetPointerFromObject(env, id0));

  vtkXMLDataWriterHelper* op = static_cast<vtkXMLDataWriterHelper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetWriter(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkXMLDataWriterHelper_GetWriter_15(JNIEnv* env, jobject obj)
{
  vtkXMLWriter2 * temp20;

  vtkXMLDataWriterHelper* op = static_cast<vtkXMLDataWriterHelper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetWriter();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkXMLDataWriterHelper_OpenFile_16(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkXMLDataWriterHelper* op = static_cast<vtkXMLDataWriterHelper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->OpenFile();
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkXMLDataWriterHelper_BeginWriting_17(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkXMLDataWriterHelper* op = static_cast<vtkXMLDataWriterHelper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->BeginWriting();
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkXMLDataWriterHelper_EndWriting_18(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkXMLDataWriterHelper* op = static_cast<vtkXMLDataWriterHelper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->EndWriting();
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkXMLDataWriterHelper_AddGlobalFieldData_19(JNIEnv* env, jobject obj,jobject id0)
{
  vtkCompositeDataSet * temp0;
  bool   temp20;
  temp0 = static_cast<vtkCompositeDataSet*>(vtkJavaGetPointerFromObject(env, id0));

  vtkXMLDataWriterHelper* op = static_cast<vtkXMLDataWriterHelper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->AddGlobalFieldData(temp0);
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkXMLDataWriterHelper_AddXML_110(JNIEnv* env, jobject obj,jobject id0)
{
  vtkXMLDataElement * temp0;
  bool   temp20;
  temp0 = static_cast<vtkXMLDataElement*>(vtkJavaGetPointerFromObject(env, id0));

  vtkXMLDataWriterHelper* op = static_cast<vtkXMLDataWriterHelper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->AddXML(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXMLDataWriterHelper_SetDataSetName_111(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  std::string temp0;
  temp0 = vtkJavaUTF8ToString(env, id0, len0);

  vtkXMLDataWriterHelper* op = static_cast<vtkXMLDataWriterHelper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDataSetName(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXMLDataWriterHelper_SetDataSetVersion_112(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkXMLDataWriterHelper* op = static_cast<vtkXMLDataWriterHelper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDataSetVersion(temp0,temp1);

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkXMLDataWriterHelper_GetDefaultFileExtension_113(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkXMLDataWriterHelper* op = static_cast<vtkXMLDataWriterHelper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDefaultFileExtension();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkXMLDataWriterHelper_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkXMLDataWriterHelper::New());
}
