// java wrapper for vtkResourceStream object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkResourceStream.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkObject_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkResourceStream_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkResourceStream",dType)) { return me; }
  if ((res= vtkObject_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkResourceStream_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkResourceStream* op = static_cast<vtkResourceStream*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkResourceStream_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkResourceStream* op = static_cast<vtkResourceStream*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkResourceStream_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkResourceStream* op = static_cast<vtkResourceStream*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkResourceStream_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkResourceStream* op = static_cast<vtkResourceStream*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkResourceStream_EndOfStream_14(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkResourceStream* op = static_cast<vtkResourceStream*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->EndOfStream();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkResourceStream_Seek_15(JNIEnv* env, jobject obj,jlong id0,jint id1)
{
  long long   temp0;
  vtkResourceStream::SeekDirection   temp1;
  long long   temp20;
  temp0 = id0;
  temp1 = static_cast<vtkResourceStream::SeekDirection>(id1);

  vtkResourceStream* op = static_cast<vtkResourceStream*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Seek(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkResourceStream_Tell_16(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkResourceStream* op = static_cast<vtkResourceStream*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Tell();
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkResourceStream_SupportSeek_17(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkResourceStream* op = static_cast<vtkResourceStream*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->SupportSeek();
  return temp20;

}
