// java wrapper for vtkDataObjectTree object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkDataObjectTree.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkCompositeDataSet_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkDataObjectTree_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkDataObjectTree",dType)) { return me; }
  if ((res= vtkCompositeDataSet_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataObjectTree_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDataObjectTree* op = static_cast<vtkDataObjectTree*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataObjectTree_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDataObjectTree* op = static_cast<vtkDataObjectTree*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataObjectTree_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDataObjectTree* op = static_cast<vtkDataObjectTree*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataObjectTree_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDataObjectTree* op = static_cast<vtkDataObjectTree*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataObjectTree_NewTreeIterator_14(JNIEnv* env, jobject obj)
{
  vtkDataObjectTreeIterator * temp20;

  vtkDataObjectTree* op = static_cast<vtkDataObjectTree*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->NewTreeIterator();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataObjectTree_NewIterator_15(JNIEnv* env, jobject obj)
{
  vtkCompositeDataIterator * temp20;

  vtkDataObjectTree* op = static_cast<vtkDataObjectTree*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->NewIterator();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataObjectTree_CopyStructure_16(JNIEnv* env, jobject obj,jobject id0)
{
  vtkCompositeDataSet * temp0;
  temp0 = static_cast<vtkCompositeDataSet*>(vtkJavaGetPointerFromObject(env, id0));

  vtkDataObjectTree* op = static_cast<vtkDataObjectTree*>(vtkJavaGetPointerFromObject(env, obj));
  op->CopyStructure(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataObjectTree_SetDataSet_17(JNIEnv* env, jobject obj,jobject id0,jobject id1)
{
  vtkCompositeDataIterator * temp0;
  vtkDataObject * temp1;
  temp0 = static_cast<vtkCompositeDataIterator*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id1));

  vtkDataObjectTree* op = static_cast<vtkDataObjectTree*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDataSet(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataObjectTree_SetDataSetFrom_18(JNIEnv* env, jobject obj,jobject id0,jobject id1)
{
  vtkDataObjectTreeIterator * temp0;
  vtkDataObject * temp1;
  temp0 = static_cast<vtkDataObjectTreeIterator*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id1));

  vtkDataObjectTree* op = static_cast<vtkDataObjectTree*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDataSetFrom(temp0,temp1);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataObjectTree_GetDataSet_19(JNIEnv* env, jobject obj,jobject id0)
{
  vtkCompositeDataIterator * temp0;
  vtkDataObject * temp20;
  temp0 = static_cast<vtkCompositeDataIterator*>(vtkJavaGetPointerFromObject(env, id0));

  vtkDataObjectTree* op = static_cast<vtkDataObjectTree*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDataSet(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataObjectTree_GetMetaData_110(JNIEnv* env, jobject obj,jobject id0)
{
  vtkCompositeDataIterator * temp0;
  vtkInformation * temp20;
  temp0 = static_cast<vtkCompositeDataIterator*>(vtkJavaGetPointerFromObject(env, id0));

  vtkDataObjectTree* op = static_cast<vtkDataObjectTree*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMetaData(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataObjectTree_HasMetaData_111(JNIEnv* env, jobject obj,jobject id0)
{
  vtkCompositeDataIterator * temp0;
  int   temp20;
  temp0 = static_cast<vtkCompositeDataIterator*>(vtkJavaGetPointerFromObject(env, id0));

  vtkDataObjectTree* op = static_cast<vtkDataObjectTree*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->HasMetaData(temp0);
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataObjectTree_GetActualMemorySize_112(JNIEnv* env, jobject obj)
{
   unsigned long   temp20;

  vtkDataObjectTree* op = static_cast<vtkDataObjectTree*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetActualMemorySize();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataObjectTree_Initialize_113(JNIEnv* env, jobject obj)
{

  vtkDataObjectTree* op = static_cast<vtkDataObjectTree*>(vtkJavaGetPointerFromObject(env, obj));
  op->Initialize();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataObjectTree_CompositeShallowCopy_114(JNIEnv* env, jobject obj,jobject id0)
{
  vtkCompositeDataSet * temp0;
  temp0 = static_cast<vtkCompositeDataSet*>(vtkJavaGetPointerFromObject(env, id0));

  vtkDataObjectTree* op = static_cast<vtkDataObjectTree*>(vtkJavaGetPointerFromObject(env, obj));
  op->CompositeShallowCopy(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataObjectTree_ShallowCopy_115(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataObject * temp0;
  temp0 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id0));

  vtkDataObjectTree* op = static_cast<vtkDataObjectTree*>(vtkJavaGetPointerFromObject(env, obj));
  op->ShallowCopy(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDataObjectTree_DeepCopy_116(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataObject * temp0;
  temp0 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id0));

  vtkDataObjectTree* op = static_cast<vtkDataObjectTree*>(vtkJavaGetPointerFromObject(env, obj));
  op->DeepCopy(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataObjectTree_GetNumberOfPoints_117(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkDataObjectTree* op = static_cast<vtkDataObjectTree*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfPoints();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataObjectTree_GetNumberOfCells_118(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkDataObjectTree* op = static_cast<vtkDataObjectTree*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfCells();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataObjectTree_GetNumberOfChildren_119(JNIEnv* env, jobject obj)
{
   unsigned int   temp20;

  vtkDataObjectTree* op = static_cast<vtkDataObjectTree*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfChildren();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataObjectTree_GetChild_120(JNIEnv* env, jobject obj,jint id0)
{
   unsigned int   temp0;
  vtkDataObject * temp20;
  temp0 = id0;

  vtkDataObjectTree* op = static_cast<vtkDataObjectTree*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetChild(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataObjectTree_GetChildMetaData_121(JNIEnv* env, jobject obj,jint id0)
{
   unsigned int   temp0;
  vtkInformation * temp20;
  temp0 = id0;

  vtkDataObjectTree* op = static_cast<vtkDataObjectTree*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetChildMetaData(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataObjectTree_HasChildMetaData_122(JNIEnv* env, jobject obj,jint id0)
{
   unsigned int   temp0;
  int   temp20;
  temp0 = id0;

  vtkDataObjectTree* op = static_cast<vtkDataObjectTree*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->HasChildMetaData(temp0);
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataObjectTree_GetData_123(JNIEnv* env, jobject obj,jobject id0)
{
  vtkInformation * temp0;
  vtkDataObjectTree * temp20;
  temp0 = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, id0));

  vtkDataObjectTree* op = static_cast<vtkDataObjectTree*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetData(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataObjectTree_GetData_124(JNIEnv* env, jobject obj,jobject id0,jint id1)
{
  vtkInformationVector * temp0;
  int   temp1;
  vtkDataObjectTree * temp20;
  temp0 = static_cast<vtkInformationVector*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;

  vtkDataObjectTree* op = static_cast<vtkDataObjectTree*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetData(temp0,temp1);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDataObjectTree_GetDataObjectType_125(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkDataObjectTree* op = static_cast<vtkDataObjectTree*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDataObjectType();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDataObjectTree_GetDataSet_126(JNIEnv* env, jobject obj,jint id0)
{
   unsigned int   temp0;
  vtkDataObject * temp20;
  temp0 = id0;

  vtkDataObjectTree* op = static_cast<vtkDataObjectTree*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDataSet(temp0);
  return reinterpret_cast<jlong>(temp20);
}
