// java wrapper for vtkUnsignedCharArray object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkUnsignedCharArray.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkDataArray_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkUnsignedCharArray_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkUnsignedCharArray",dType)) { return me; }
  if ((res= vtkDataArray_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}

// Array conversion routines
extern "C" JNIEXPORT jbyteArray JNICALL Java_vtk_vtkUnsignedCharArray_GetJavaArray_10(JNIEnv* env, jobject obj)
{
  vtkUnsignedCharArray* op = static_cast<vtkUnsignedCharArray*>(vtkJavaGetPointerFromObject(env, obj));
  unsigned char* buffer = op->GetPointer(0);
  return vtkJavaMakeJArrayOfByte(env, reinterpret_cast<jbyte*>(buffer), op->GetSize());
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkUnsignedCharArray_SetJavaArray_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  vtkUnsignedCharArray* op = static_cast<vtkUnsignedCharArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetNumberOfTuples(len0 / op->GetNumberOfComponents());
  unsigned char* buffer = op->GetPointer(0);
  env->GetByteArrayRegion(id0, 0, len0, reinterpret_cast<jbyte*>(buffer));
}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkUnsignedCharArray_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkUnsignedCharArray* op = static_cast<vtkUnsignedCharArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkUnsignedCharArray_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkUnsignedCharArray* op = static_cast<vtkUnsignedCharArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkUnsignedCharArray_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkUnsignedCharArray* op = static_cast<vtkUnsignedCharArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkUnsignedCharArray_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkUnsignedCharArray* op = static_cast<vtkUnsignedCharArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkUnsignedCharArray_ExtendedNew_14(JNIEnv* env, jobject obj)
{
  vtkUnsignedCharArray * temp20;

  vtkUnsignedCharArray* op = static_cast<vtkUnsignedCharArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ExtendedNew();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkUnsignedCharArray_GetDataType_15(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkUnsignedCharArray* op = static_cast<vtkUnsignedCharArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDataType();
  return temp20;

}

extern "C" JNIEXPORT jbyte  JNICALL Java_vtk_vtkUnsignedCharArray_GetValue_16(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
   unsigned char   temp20;
  temp0 = id0;

  vtkUnsignedCharArray* op = static_cast<vtkUnsignedCharArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetValue(temp0);
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkUnsignedCharArray_GetValueRange_17(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
   unsigned char * temp20;
  temp0 = id0;

  vtkUnsignedCharArray* op = static_cast<vtkUnsignedCharArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetValueRange(temp0);
  return vtkJavaMakeJArrayOfByte(env, reinterpret_cast<jbyte*>(temp20), 2);

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkUnsignedCharArray_GetValueRange_18(JNIEnv* env, jobject obj)
{
   unsigned char * temp20;

  vtkUnsignedCharArray* op = static_cast<vtkUnsignedCharArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetValueRange();
  return vtkJavaMakeJArrayOfByte(env, reinterpret_cast<jbyte*>(temp20), 2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkUnsignedCharArray_SetValue_19(JNIEnv* env, jobject obj,jlong id0,jbyte id1)
{
  long long   temp0;
   unsigned char   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkUnsignedCharArray* op = static_cast<vtkUnsignedCharArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetValue(temp0,temp1);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkUnsignedCharArray_SetNumberOfValues_110(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  bool   temp20;
  temp0 = id0;

  vtkUnsignedCharArray* op = static_cast<vtkUnsignedCharArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->SetNumberOfValues(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkUnsignedCharArray_InsertValue_111(JNIEnv* env, jobject obj,jlong id0,jbyte id1)
{
  long long   temp0;
   unsigned char   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkUnsignedCharArray* op = static_cast<vtkUnsignedCharArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->InsertValue(temp0,temp1);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkUnsignedCharArray_InsertNextValue_112(JNIEnv* env, jobject obj,jbyte id0)
{
   unsigned char   temp0;
  long long   temp20;
  temp0 = id0;

  vtkUnsignedCharArray* op = static_cast<vtkUnsignedCharArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->InsertNextValue(temp0);
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkUnsignedCharArray_FastDownCast_113(JNIEnv* env, jobject obj,jobject id0)
{
  vtkAbstractArray * temp0;
  vtkUnsignedCharArray * temp20;
  temp0 = static_cast<vtkAbstractArray*>(vtkJavaGetPointerFromObject(env, id0));

  vtkUnsignedCharArray* op = static_cast<vtkUnsignedCharArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->FastDownCast(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jbyte  JNICALL Java_vtk_vtkUnsignedCharArray_GetDataTypeValueMin_114(JNIEnv* env, jobject obj)
{
   unsigned char   temp20;

  vtkUnsignedCharArray* op = static_cast<vtkUnsignedCharArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDataTypeValueMin();
  return temp20;

}

extern "C" JNIEXPORT jbyte  JNICALL Java_vtk_vtkUnsignedCharArray_GetDataTypeValueMax_115(JNIEnv* env, jobject obj)
{
   unsigned char   temp20;

  vtkUnsignedCharArray* op = static_cast<vtkUnsignedCharArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDataTypeValueMax();
  return temp20;

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkUnsignedCharArray_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkUnsignedCharArray::New());
}
