// python wrapper for vtkCompressCompositer
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkCompressCompositer.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkCompressCompositer(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkCompressCompositer_ClassNew(); }

#ifndef DECLARED_PyvtkCompositer_ClassNew
extern "C" { PyObject *PyvtkCompositer_ClassNew(); }
#define DECLARED_PyvtkCompositer_ClassNew
#endif

static PyObject *
PyvtkCompressCompositer_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkCompressCompositer::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCompressCompositer_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCompressCompositer *op = static_cast<vtkCompressCompositer *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkCompressCompositer::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCompressCompositer_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkCompressCompositer *tempr = vtkCompressCompositer::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCompressCompositer_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCompressCompositer *op = static_cast<vtkCompressCompositer *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkCompressCompositer *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkCompressCompositer::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCompressCompositer_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkCompressCompositer::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCompressCompositer_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCompressCompositer *op = static_cast<vtkCompressCompositer *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkCompressCompositer::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCompressCompositer_CompositeBuffer(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "CompositeBuffer");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCompressCompositer *op = static_cast<vtkCompressCompositer *>(vp);

  vtkDataArray *temp0 = nullptr;
  vtkFloatArray *temp1 = nullptr;
  vtkDataArray *temp2 = nullptr;
  vtkFloatArray *temp3 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(4) &&
      ap.GetVTKObject(temp0, "vtkDataArray") &&
      ap.GetVTKObject(temp1, "vtkFloatArray") &&
      ap.GetVTKObject(temp2, "vtkDataArray") &&
      ap.GetVTKObject(temp3, "vtkFloatArray"))
  {
    if (ap.IsBound())
    {
      op->CompositeBuffer(temp0, temp1, temp2, temp3);
    }
    else
    {
      op->vtkCompressCompositer::CompositeBuffer(temp0, temp1, temp2, temp3);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkCompressCompositer_Compress(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "Compress");

  vtkFloatArray *temp0 = nullptr;
  vtkDataArray *temp1 = nullptr;
  vtkFloatArray *temp2 = nullptr;
  vtkDataArray *temp3 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(4) &&
      ap.GetVTKObject(temp0, "vtkFloatArray") &&
      ap.GetVTKObject(temp1, "vtkDataArray") &&
      ap.GetVTKObject(temp2, "vtkFloatArray") &&
      ap.GetVTKObject(temp3, "vtkDataArray"))
  {
    vtkCompressCompositer::Compress(temp0, temp1, temp2, temp3);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkCompressCompositer_Uncompress(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "Uncompress");

  vtkFloatArray *temp0 = nullptr;
  vtkDataArray *temp1 = nullptr;
  vtkFloatArray *temp2 = nullptr;
  vtkDataArray *temp3 = nullptr;
  int temp4;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(5) &&
      ap.GetVTKObject(temp0, "vtkFloatArray") &&
      ap.GetVTKObject(temp1, "vtkDataArray") &&
      ap.GetVTKObject(temp2, "vtkFloatArray") &&
      ap.GetVTKObject(temp3, "vtkDataArray") &&
      ap.GetValue(temp4))
  {
    vtkCompressCompositer::Uncompress(temp0, temp1, temp2, temp3, temp4);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkCompressCompositer_CompositeImagePair(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "CompositeImagePair");

  vtkFloatArray *temp0 = nullptr;
  vtkDataArray *temp1 = nullptr;
  vtkFloatArray *temp2 = nullptr;
  vtkDataArray *temp3 = nullptr;
  vtkFloatArray *temp4 = nullptr;
  vtkDataArray *temp5 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(6) &&
      ap.GetVTKObject(temp0, "vtkFloatArray") &&
      ap.GetVTKObject(temp1, "vtkDataArray") &&
      ap.GetVTKObject(temp2, "vtkFloatArray") &&
      ap.GetVTKObject(temp3, "vtkDataArray") &&
      ap.GetVTKObject(temp4, "vtkFloatArray") &&
      ap.GetVTKObject(temp5, "vtkDataArray"))
  {
    vtkCompressCompositer::CompositeImagePair(temp0, temp1, temp2, temp3, temp4, temp5);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyvtkCompressCompositer_Methods[] = {
  {"IsTypeOf", PyvtkCompressCompositer_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkCompressCompositer_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkCompressCompositer_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkCompressCompositer\nC++: static vtkCompressCompositer *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkCompressCompositer_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkCompressCompositer\nC++: vtkCompressCompositer *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkCompressCompositer_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkCompressCompositer_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"CompositeBuffer", PyvtkCompressCompositer_CompositeBuffer, METH_VARARGS,
   "CompositeBuffer(self, pBuf:vtkDataArray, zBuf:vtkFloatArray,\n    pTmp:vtkDataArray, zTmp:vtkFloatArray) -> None\nC++: void CompositeBuffer(vtkDataArray *pBuf, vtkFloatArray *zBuf,\n     vtkDataArray *pTmp, vtkFloatArray *zTmp) override;\n\nThis method gets called on every process.  The final image gets\nput into pBuf and zBuf.\n"},
  {"Compress", PyvtkCompressCompositer_Compress, METH_VARARGS,
   "Compress(zIn:vtkFloatArray, pIn:vtkDataArray, zOut:vtkFloatArray,\n    pOut:vtkDataArray) -> None\nC++: static void Compress(vtkFloatArray *zIn, vtkDataArray *pIn,\n    vtkFloatArray *zOut, vtkDataArray *pOut)\n\nI am granting access to these methods and making them static So I\ncan create a TileDisplayCompositer which uses compression.\n"},
  {"Uncompress", PyvtkCompressCompositer_Uncompress, METH_VARARGS,
   "Uncompress(zIn:vtkFloatArray, pIn:vtkDataArray,\n    zOut:vtkFloatArray, pOut:vtkDataArray, lengthOut:int) -> None\nC++: static void Uncompress(vtkFloatArray *zIn, vtkDataArray *pIn,\n     vtkFloatArray *zOut, vtkDataArray *pOut, int lengthOut)\n\n"},
  {"CompositeImagePair", PyvtkCompressCompositer_CompositeImagePair, METH_VARARGS,
   "CompositeImagePair(localZ:vtkFloatArray, localP:vtkDataArray,\n    remoteZ:vtkFloatArray, remoteP:vtkDataArray,\n    outZ:vtkFloatArray, outP:vtkDataArray) -> None\nC++: static void CompositeImagePair(vtkFloatArray *localZ,\n    vtkDataArray *localP, vtkFloatArray *remoteZ,\n    vtkDataArray *remoteP, vtkFloatArray *outZ,\n    vtkDataArray *outP)\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkCompressCompositer_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkCompressCompositer_Doc =
  "vtkCompressCompositer - Implements compressed tree based compositing.\n\n"
  "Superclass: vtkCompositer\n\n"
  "vtkCompressCompositer operates in multiple processes.  Each\n"
  "compositer has a render window.  They use vtkMultiProcessController\n"
  "to communicate the color and depth buffer to process 0's render\n"
  "window. It will not handle transparency.  Compositing is run length\n"
  "encoding of background pixels.\n\n"
  "SECTION See Also vtkCompositeManager.\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkCompressCompositer_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRenderingParallel.vtkCompressCompositer", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkCompressCompositer_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkCompressCompositer_StaticNew()
{
  return vtkCompressCompositer::New();
}

PyObject *PyvtkCompressCompositer_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkCompressCompositer_Type, PyvtkCompressCompositer_Methods,
    "vtkCompressCompositer",
 &PyvtkCompressCompositer_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = (PyTypeObject *)PyvtkCompositer_ClassNew();

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkCompressCompositer_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkCompressCompositer(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkCompressCompositer_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkCompressCompositer", o) != 0)
  {
    Py_DECREF(o);
  }

}

