// python wrapper for vtkPostgreSQLQuery
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkStdString.h"
#include "vtkPostgreSQLQuery.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkPostgreSQLQuery(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkPostgreSQLQuery_ClassNew(); }


static PyObject *
PyvtkPostgreSQLQuery_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkPostgreSQLQuery::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPostgreSQLQuery_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPostgreSQLQuery *op = static_cast<vtkPostgreSQLQuery *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkPostgreSQLQuery::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPostgreSQLQuery_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkPostgreSQLQuery *tempr = vtkPostgreSQLQuery::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPostgreSQLQuery_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPostgreSQLQuery *op = static_cast<vtkPostgreSQLQuery *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkPostgreSQLQuery *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkPostgreSQLQuery::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPostgreSQLQuery_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkPostgreSQLQuery::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPostgreSQLQuery_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPostgreSQLQuery *op = static_cast<vtkPostgreSQLQuery *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkPostgreSQLQuery::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPostgreSQLQuery_Execute(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Execute");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPostgreSQLQuery *op = static_cast<vtkPostgreSQLQuery *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->Execute() :
      op->vtkPostgreSQLQuery::Execute());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPostgreSQLQuery_GetNumberOfFields(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfFields");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPostgreSQLQuery *op = static_cast<vtkPostgreSQLQuery *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetNumberOfFields() :
      op->vtkPostgreSQLQuery::GetNumberOfFields());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPostgreSQLQuery_GetFieldName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetFieldName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPostgreSQLQuery *op = static_cast<vtkPostgreSQLQuery *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    const char *tempr = (ap.IsBound() ?
      op->GetFieldName(temp0) :
      op->vtkPostgreSQLQuery::GetFieldName(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPostgreSQLQuery_GetFieldType(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetFieldType");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPostgreSQLQuery *op = static_cast<vtkPostgreSQLQuery *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->GetFieldType(temp0) :
      op->vtkPostgreSQLQuery::GetFieldType(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPostgreSQLQuery_NextRow(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NextRow");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPostgreSQLQuery *op = static_cast<vtkPostgreSQLQuery *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->NextRow() :
      op->vtkPostgreSQLQuery::NextRow());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPostgreSQLQuery_HasError(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "HasError");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPostgreSQLQuery *op = static_cast<vtkPostgreSQLQuery *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->HasError() :
      op->vtkPostgreSQLQuery::HasError());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPostgreSQLQuery_BeginTransaction(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "BeginTransaction");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPostgreSQLQuery *op = static_cast<vtkPostgreSQLQuery *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->BeginTransaction() :
      op->vtkPostgreSQLQuery::BeginTransaction());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPostgreSQLQuery_RollbackTransaction(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RollbackTransaction");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPostgreSQLQuery *op = static_cast<vtkPostgreSQLQuery *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->RollbackTransaction() :
      op->vtkPostgreSQLQuery::RollbackTransaction());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPostgreSQLQuery_CommitTransaction(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "CommitTransaction");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPostgreSQLQuery *op = static_cast<vtkPostgreSQLQuery *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->CommitTransaction() :
      op->vtkPostgreSQLQuery::CommitTransaction());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPostgreSQLQuery_DataValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "DataValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPostgreSQLQuery *op = static_cast<vtkPostgreSQLQuery *>(vp);

  long long temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    vtkVariant tempr = (ap.IsBound() ?
      op->DataValue(temp0) :
      op->vtkPostgreSQLQuery::DataValue(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildSpecialObject(&tempr, "vtkVariant");
    }
  }

  return result;
}


static PyObject *
PyvtkPostgreSQLQuery_GetLastErrorText(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetLastErrorText");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPostgreSQLQuery *op = static_cast<vtkPostgreSQLQuery *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    const char *tempr = (ap.IsBound() ?
      op->GetLastErrorText() :
      op->vtkPostgreSQLQuery::GetLastErrorText());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPostgreSQLQuery_EscapeString(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "EscapeString");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPostgreSQLQuery *op = static_cast<vtkPostgreSQLQuery *>(vp);

  vtkStdString temp0;
  bool temp1 = true;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1, 2) &&
      ap.GetValue(temp0) &&
      (ap.NoArgsLeft() || ap.GetValue(temp1)))
  {
    vtkStdString tempr = (ap.IsBound() ?
      op->EscapeString(temp0, temp1) :
      op->vtkPostgreSQLQuery::EscapeString(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPostgreSQLQuery_GetNumberOfRows(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfRows");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPostgreSQLQuery *op = static_cast<vtkPostgreSQLQuery *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetNumberOfRows() :
      op->vtkPostgreSQLQuery::GetNumberOfRows());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkPostgreSQLQuery_Methods[] = {
  {"IsTypeOf", PyvtkPostgreSQLQuery_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkPostgreSQLQuery_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkPostgreSQLQuery_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkPostgreSQLQuery\nC++: static vtkPostgreSQLQuery *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkPostgreSQLQuery_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkPostgreSQLQuery\nC++: vtkPostgreSQLQuery *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkPostgreSQLQuery_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkPostgreSQLQuery_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"Execute", PyvtkPostgreSQLQuery_Execute, METH_VARARGS,
   "Execute(self) -> bool\nC++: bool Execute() override;\n\nExecute the query.  This must be performed before any field name\nor data access functions are used.\n"},
  {"GetNumberOfFields", PyvtkPostgreSQLQuery_GetNumberOfFields, METH_VARARGS,
   "GetNumberOfFields(self) -> int\nC++: int GetNumberOfFields() override;\n\nThe number of fields in the query result.\n"},
  {"GetFieldName", PyvtkPostgreSQLQuery_GetFieldName, METH_VARARGS,
   "GetFieldName(self, i:int) -> str\nC++: const char *GetFieldName(int i) override;\n\nReturn the name of the specified query field.\n"},
  {"GetFieldType", PyvtkPostgreSQLQuery_GetFieldType, METH_VARARGS,
   "GetFieldType(self, i:int) -> int\nC++: int GetFieldType(int i) override;\n\nReturn the type of the field, using the constants defined in\nvtkType.h.\n"},
  {"NextRow", PyvtkPostgreSQLQuery_NextRow, METH_VARARGS,
   "NextRow(self) -> bool\nC++: bool NextRow() override;\n\nAdvance row, return false if past end.\n"},
  {"HasError", PyvtkPostgreSQLQuery_HasError, METH_VARARGS,
   "HasError(self) -> bool\nC++: bool HasError() override;\n\nReturn true if there is an error on the current query.\n"},
  {"BeginTransaction", PyvtkPostgreSQLQuery_BeginTransaction, METH_VARARGS,
   "BeginTransaction(self) -> bool\nC++: bool BeginTransaction() override;\n\nBegin, abort (roll back), or commit a transaction.\n"},
  {"RollbackTransaction", PyvtkPostgreSQLQuery_RollbackTransaction, METH_VARARGS,
   "RollbackTransaction(self) -> bool\nC++: bool RollbackTransaction() override;\n\n"},
  {"CommitTransaction", PyvtkPostgreSQLQuery_CommitTransaction, METH_VARARGS,
   "CommitTransaction(self) -> bool\nC++: bool CommitTransaction() override;\n\n"},
  {"DataValue", PyvtkPostgreSQLQuery_DataValue, METH_VARARGS,
   "DataValue(self, c:int) -> vtkVariant\nC++: vtkVariant DataValue(vtkIdType c) override;\n\nReturn data in current row, field c\n"},
  {"GetLastErrorText", PyvtkPostgreSQLQuery_GetLastErrorText, METH_VARARGS,
   "GetLastErrorText(self) -> str\nC++: const char *GetLastErrorText() override;\n\nGet the last error text from the query\n"},
  {"EscapeString", PyvtkPostgreSQLQuery_EscapeString, METH_VARARGS,
   "EscapeString(self, s:str, addSurroundingQuotes:bool=True) -> str\nC++: vtkStdString EscapeString(vtkStdString s,\n    bool addSurroundingQuotes=true) override;\n\nEscape a string for inclusion into an SQL query\n"},
  {"GetNumberOfRows", PyvtkPostgreSQLQuery_GetNumberOfRows, METH_VARARGS,
   "GetNumberOfRows(self) -> int\nC++: int GetNumberOfRows()\n\nUnlike some databases, Postgres can tell you right away how many\nrows are in the results of your query.\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkPostgreSQLQuery_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("last_error_text"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPostgreSQLQuery_GetLastErrorText(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetLastErrorText\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("number_of_fields"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPostgreSQLQuery_GetNumberOfFields(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetNumberOfFields\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("number_of_rows"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPostgreSQLQuery_GetNumberOfRows(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetNumberOfRows\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkPostgreSQLQuery_Doc =
  "vtkPostgreSQLQuery - vtkSQLQuery implementation for PostgreSQL\ndatabases\n\n"
  "Superclass: vtkSQLQuery\n\n"
  "This is an implementation of vtkSQLQuery for PostgreSQL databases. \n"
  "See the documentation for vtkSQLQuery for information about what the\n"
  "methods do.\n\n"
  "@par Thanks: Thanks to David Thompson and Andy Wilson from Sandia\n"
  "National Laboratories for implementing this class.\n\n"
  "@sa\n"
  "vtkSQLDatabase vtkSQLQuery vtkPostgreSQLDatabase\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkPostgreSQLQuery_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkIOPostgreSQL.vtkPostgreSQLQuery", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkPostgreSQLQuery_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkPostgreSQLQuery_StaticNew()
{
  return vtkPostgreSQLQuery::New();
}

PyObject *PyvtkPostgreSQLQuery_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkPostgreSQLQuery_Type, PyvtkPostgreSQLQuery_Methods,
    "vtkPostgreSQLQuery",
 &PyvtkPostgreSQLQuery_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkSQLQuery");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkPostgreSQLQuery_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkPostgreSQLQuery(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkPostgreSQLQuery_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkPostgreSQLQuery", o) != 0)
  {
    Py_DECREF(o);
  }

}

