// python wrapper for vtkFFMPEGVideoSource
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkFFMPEGVideoSource.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkFFMPEGVideoSource(PyObject *dict); }
static PyMethodDef PyvtkFFMPEGVideoSourceAudioCallbackData_Methods[] = {
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkFFMPEGVideoSourceAudioCallbackData_GetSets[] = {
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};

static PyObject *
PyvtkFFMPEGVideoSourceAudioCallbackData_vtkFFMPEGVideoSourceAudioCallbackData_s1(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "vtkFFMPEGVideoSourceAudioCallbackData");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    vtkFFMPEGVideoSourceAudioCallbackData *op = new vtkFFMPEGVideoSourceAudioCallbackData();

    result = PyVTKSpecialObject_New("vtkFFMPEGVideoSourceAudioCallbackData", op);
  }

  return result;
}

static PyObject *
PyvtkFFMPEGVideoSourceAudioCallbackData_vtkFFMPEGVideoSourceAudioCallbackData_s2(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "vtkFFMPEGVideoSourceAudioCallbackData");

  vtkFFMPEGVideoSourceAudioCallbackData *temp0 = nullptr;
  PyObject *pobj0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetSpecialObject(temp0, pobj0, "vtkFFMPEGVideoSourceAudioCallbackData"))
  {
    vtkFFMPEGVideoSourceAudioCallbackData *op = new vtkFFMPEGVideoSourceAudioCallbackData(*temp0);

    result = PyVTKSpecialObject_New("vtkFFMPEGVideoSourceAudioCallbackData", op);
  }

  Py_XDECREF(pobj0);

  return result;
}

static PyMethodDef PyvtkFFMPEGVideoSourceAudioCallbackData_vtkFFMPEGVideoSourceAudioCallbackData_Methods[] = {
  {"vtkFFMPEGVideoSourceAudioCallbackData", PyvtkFFMPEGVideoSourceAudioCallbackData_vtkFFMPEGVideoSourceAudioCallbackData_s2, METH_VARARGS,
   "@W vtkFFMPEGVideoSourceAudioCallbackData"},
  {nullptr, nullptr, 0, nullptr}
};

static PyObject *
PyvtkFFMPEGVideoSourceAudioCallbackData_vtkFFMPEGVideoSourceAudioCallbackData(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(args);

  switch(nargs)
  {
    case 0:
      return PyvtkFFMPEGVideoSourceAudioCallbackData_vtkFFMPEGVideoSourceAudioCallbackData_s1(self, args);
    case 1:
      return PyvtkFFMPEGVideoSourceAudioCallbackData_vtkFFMPEGVideoSourceAudioCallbackData_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "vtkFFMPEGVideoSourceAudioCallbackData");
  return nullptr;
}


static const char *PyvtkFFMPEGVideoSourceAudioCallbackData_Doc =

  "vtkFFMPEGVideoSourceAudioCallbackData()\n    -> vtkFFMPEGVideoSourceAudioCallbackData\nC++: vtkFFMPEGVideoSourceAudioCallbackData()\nvtkFFMPEGVideoSourceAudioCallbackData(\n    __a:vtkFFMPEGVideoSourceAudioCallbackData)\n    -> vtkFFMPEGVideoSourceAudioCallbackData\nC++: vtkFFMPEGVideoSourceAudioCallbackData(\n    const &vtkFFMPEGVideoSourceAudioCallbackData)\n""\n"
  "vtkFFMPEGVideoSourceAudioCallbackData - no description provided.\n\n"
;

static PyObject *
PyvtkFFMPEGVideoSourceAudioCallbackData_New(PyTypeObject *, PyObject *args, PyObject *kwds)
{
  if (kwds && PyDict_Size(kwds))
  {
    PyErr_SetString(PyExc_TypeError,
                    "this function takes no keyword arguments");
    return nullptr;
  }

  return PyvtkFFMPEGVideoSourceAudioCallbackData_vtkFFMPEGVideoSourceAudioCallbackData(nullptr, args);
}

static void PyvtkFFMPEGVideoSourceAudioCallbackData_Delete(PyObject *self)
{
  PyVTKSpecialObject *obj = (PyVTKSpecialObject *)self;
  delete static_cast<vtkFFMPEGVideoSourceAudioCallbackData *>(obj->vtk_ptr);
  PyObject_Del(self);
}

static Py_hash_t PyvtkFFMPEGVideoSourceAudioCallbackData_Hash(PyObject *self)
{
  return PyObject_HashNotImplemented(self);
}

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkFFMPEGVideoSourceAudioCallbackData_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkIOFFMPEG.vtkFFMPEGVideoSourceAudioCallbackData", // tp_name
  sizeof(PyVTKSpecialObject), // tp_basicsize
  0, // tp_itemsize
  PyvtkFFMPEGVideoSourceAudioCallbackData_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKSpecialObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  PyvtkFFMPEGVideoSourceAudioCallbackData_Hash, // tp_hash
  nullptr, // tp_call
  nullptr, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  nullptr, // tp_setattro
  nullptr, // tp_as_buffer
  Py_TPFLAGS_DEFAULT, // tp_flags
  PyvtkFFMPEGVideoSourceAudioCallbackData_Doc, // tp_doc
  nullptr, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  0, // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  nullptr, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  0, // tp_dictoffset
  nullptr, // tp_init
  nullptr, // tp_alloc
  PyvtkFFMPEGVideoSourceAudioCallbackData_New, // tp_new
  PyObject_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static void *PyvtkFFMPEGVideoSourceAudioCallbackData_CCopy(const void *obj)
{
  if (obj)
  {
    return new vtkFFMPEGVideoSourceAudioCallbackData(*static_cast<const vtkFFMPEGVideoSourceAudioCallbackData*>(obj));
  }
  return nullptr;
}

#ifndef DECLARED_PyvtkFFMPEGVideoSourceAudioCallbackData_TypeNew
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkFFMPEGVideoSourceAudioCallbackData_TypeNew(); }
#define DECLARED_PyvtkFFMPEGVideoSourceAudioCallbackData_TypeNew
#endif

PyObject *PyvtkFFMPEGVideoSourceAudioCallbackData_TypeNew()
{
  PyTypeObject *pytype = PyVTKSpecialType_Add(
    &PyvtkFFMPEGVideoSourceAudioCallbackData_Type,
    PyvtkFFMPEGVideoSourceAudioCallbackData_Methods,
    PyvtkFFMPEGVideoSourceAudioCallbackData_GetSets,
    PyvtkFFMPEGVideoSourceAudioCallbackData_vtkFFMPEGVideoSourceAudioCallbackData_Methods,
    &PyvtkFFMPEGVideoSourceAudioCallbackData_CCopy);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

static PyMethodDef PyvtkFFMPEGVideoSourceVideoCallbackData_Methods[] = {
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkFFMPEGVideoSourceVideoCallbackData_GetSets[] = {
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};

static PyObject *
PyvtkFFMPEGVideoSourceVideoCallbackData_vtkFFMPEGVideoSourceVideoCallbackData_s1(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "vtkFFMPEGVideoSourceVideoCallbackData");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    vtkFFMPEGVideoSourceVideoCallbackData *op = new vtkFFMPEGVideoSourceVideoCallbackData();

    result = PyVTKSpecialObject_New("vtkFFMPEGVideoSourceVideoCallbackData", op);
  }

  return result;
}

static PyObject *
PyvtkFFMPEGVideoSourceVideoCallbackData_vtkFFMPEGVideoSourceVideoCallbackData_s2(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "vtkFFMPEGVideoSourceVideoCallbackData");

  vtkFFMPEGVideoSourceVideoCallbackData *temp0 = nullptr;
  PyObject *pobj0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetSpecialObject(temp0, pobj0, "vtkFFMPEGVideoSourceVideoCallbackData"))
  {
    vtkFFMPEGVideoSourceVideoCallbackData *op = new vtkFFMPEGVideoSourceVideoCallbackData(*temp0);

    result = PyVTKSpecialObject_New("vtkFFMPEGVideoSourceVideoCallbackData", op);
  }

  Py_XDECREF(pobj0);

  return result;
}

static PyMethodDef PyvtkFFMPEGVideoSourceVideoCallbackData_vtkFFMPEGVideoSourceVideoCallbackData_Methods[] = {
  {"vtkFFMPEGVideoSourceVideoCallbackData", PyvtkFFMPEGVideoSourceVideoCallbackData_vtkFFMPEGVideoSourceVideoCallbackData_s2, METH_VARARGS,
   "@W vtkFFMPEGVideoSourceVideoCallbackData"},
  {nullptr, nullptr, 0, nullptr}
};

static PyObject *
PyvtkFFMPEGVideoSourceVideoCallbackData_vtkFFMPEGVideoSourceVideoCallbackData(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(args);

  switch(nargs)
  {
    case 0:
      return PyvtkFFMPEGVideoSourceVideoCallbackData_vtkFFMPEGVideoSourceVideoCallbackData_s1(self, args);
    case 1:
      return PyvtkFFMPEGVideoSourceVideoCallbackData_vtkFFMPEGVideoSourceVideoCallbackData_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "vtkFFMPEGVideoSourceVideoCallbackData");
  return nullptr;
}


static const char *PyvtkFFMPEGVideoSourceVideoCallbackData_Doc =

  "vtkFFMPEGVideoSourceVideoCallbackData()\n    -> vtkFFMPEGVideoSourceVideoCallbackData\nC++: vtkFFMPEGVideoSourceVideoCallbackData()\nvtkFFMPEGVideoSourceVideoCallbackData(\n    __a:vtkFFMPEGVideoSourceVideoCallbackData)\n    -> vtkFFMPEGVideoSourceVideoCallbackData\nC++: vtkFFMPEGVideoSourceVideoCallbackData(\n    const &vtkFFMPEGVideoSourceVideoCallbackData)\n""\n"
  "vtkFFMPEGVideoSourceVideoCallbackData - no description provided.\n\n"
;

static PyObject *
PyvtkFFMPEGVideoSourceVideoCallbackData_New(PyTypeObject *, PyObject *args, PyObject *kwds)
{
  if (kwds && PyDict_Size(kwds))
  {
    PyErr_SetString(PyExc_TypeError,
                    "this function takes no keyword arguments");
    return nullptr;
  }

  return PyvtkFFMPEGVideoSourceVideoCallbackData_vtkFFMPEGVideoSourceVideoCallbackData(nullptr, args);
}

static void PyvtkFFMPEGVideoSourceVideoCallbackData_Delete(PyObject *self)
{
  PyVTKSpecialObject *obj = (PyVTKSpecialObject *)self;
  delete static_cast<vtkFFMPEGVideoSourceVideoCallbackData *>(obj->vtk_ptr);
  PyObject_Del(self);
}

static Py_hash_t PyvtkFFMPEGVideoSourceVideoCallbackData_Hash(PyObject *self)
{
  return PyObject_HashNotImplemented(self);
}

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkFFMPEGVideoSourceVideoCallbackData_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkIOFFMPEG.vtkFFMPEGVideoSourceVideoCallbackData", // tp_name
  sizeof(PyVTKSpecialObject), // tp_basicsize
  0, // tp_itemsize
  PyvtkFFMPEGVideoSourceVideoCallbackData_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKSpecialObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  PyvtkFFMPEGVideoSourceVideoCallbackData_Hash, // tp_hash
  nullptr, // tp_call
  nullptr, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  nullptr, // tp_setattro
  nullptr, // tp_as_buffer
  Py_TPFLAGS_DEFAULT, // tp_flags
  PyvtkFFMPEGVideoSourceVideoCallbackData_Doc, // tp_doc
  nullptr, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  0, // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  nullptr, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  0, // tp_dictoffset
  nullptr, // tp_init
  nullptr, // tp_alloc
  PyvtkFFMPEGVideoSourceVideoCallbackData_New, // tp_new
  PyObject_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static void *PyvtkFFMPEGVideoSourceVideoCallbackData_CCopy(const void *obj)
{
  if (obj)
  {
    return new vtkFFMPEGVideoSourceVideoCallbackData(*static_cast<const vtkFFMPEGVideoSourceVideoCallbackData*>(obj));
  }
  return nullptr;
}

#ifndef DECLARED_PyvtkFFMPEGVideoSourceVideoCallbackData_TypeNew
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkFFMPEGVideoSourceVideoCallbackData_TypeNew(); }
#define DECLARED_PyvtkFFMPEGVideoSourceVideoCallbackData_TypeNew
#endif

PyObject *PyvtkFFMPEGVideoSourceVideoCallbackData_TypeNew()
{
  PyTypeObject *pytype = PyVTKSpecialType_Add(
    &PyvtkFFMPEGVideoSourceVideoCallbackData_Type,
    PyvtkFFMPEGVideoSourceVideoCallbackData_Methods,
    PyvtkFFMPEGVideoSourceVideoCallbackData_GetSets,
    PyvtkFFMPEGVideoSourceVideoCallbackData_vtkFFMPEGVideoSourceVideoCallbackData_Methods,
    &PyvtkFFMPEGVideoSourceVideoCallbackData_CCopy);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkFFMPEGVideoSource_ClassNew(); }


static PyObject *
PyvtkFFMPEGVideoSource_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkFFMPEGVideoSource::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkFFMPEGVideoSource_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkFFMPEGVideoSource *op = static_cast<vtkFFMPEGVideoSource *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkFFMPEGVideoSource::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkFFMPEGVideoSource_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkFFMPEGVideoSource *tempr = vtkFFMPEGVideoSource::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkFFMPEGVideoSource_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkFFMPEGVideoSource *op = static_cast<vtkFFMPEGVideoSource *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkFFMPEGVideoSource *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkFFMPEGVideoSource::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkFFMPEGVideoSource_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkFFMPEGVideoSource::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkFFMPEGVideoSource_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkFFMPEGVideoSource *op = static_cast<vtkFFMPEGVideoSource *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkFFMPEGVideoSource::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkFFMPEGVideoSource_Record(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Record");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkFFMPEGVideoSource *op = static_cast<vtkFFMPEGVideoSource *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->Record();
    }
    else
    {
      op->vtkFFMPEGVideoSource::Record();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkFFMPEGVideoSource_Play(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Play");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkFFMPEGVideoSource *op = static_cast<vtkFFMPEGVideoSource *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->Play();
    }
    else
    {
      op->vtkFFMPEGVideoSource::Play();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkFFMPEGVideoSource_Stop(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Stop");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkFFMPEGVideoSource *op = static_cast<vtkFFMPEGVideoSource *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->Stop();
    }
    else
    {
      op->vtkFFMPEGVideoSource::Stop();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkFFMPEGVideoSource_Grab(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Grab");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkFFMPEGVideoSource *op = static_cast<vtkFFMPEGVideoSource *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->Grab();
    }
    else
    {
      op->vtkFFMPEGVideoSource::Grab();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkFFMPEGVideoSource_SetFrameSize_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetFrameSize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkFFMPEGVideoSource *op = static_cast<vtkFFMPEGVideoSource *>(vp);

  int temp0;
  int temp1;
  int temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetFrameSize(temp0, temp1, temp2);
    }
    else
    {
      op->vtkFFMPEGVideoSource::SetFrameSize(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkFFMPEGVideoSource_SetFrameSize_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetFrameSize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkFFMPEGVideoSource *op = static_cast<vtkFFMPEGVideoSource *>(vp);

  const size_t size0 = 3;
  int temp0[3];
  int save0[3];
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    vtkPythonArgs::Save(temp0, save0, size0);

    if (ap.IsBound())
    {
      op->SetFrameSize(temp0);
    }
    else
    {
      op->vtkFFMPEGVideoSource::SetFrameSize(temp0);
    }

    if (vtkPythonArgs::HasChanged(temp0, save0, size0) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(0, temp0, size0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkFFMPEGVideoSource_SetFrameSize(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 3:
      return PyvtkFFMPEGVideoSource_SetFrameSize_s1(self, args);
    case 1:
      return PyvtkFFMPEGVideoSource_SetFrameSize_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SetFrameSize");
  return nullptr;
}


static PyObject *
PyvtkFFMPEGVideoSource_SetFrameRate(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetFrameRate");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkFFMPEGVideoSource *op = static_cast<vtkFFMPEGVideoSource *>(vp);

  float temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetFrameRate(temp0);
    }
    else
    {
      op->vtkFFMPEGVideoSource::SetFrameRate(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkFFMPEGVideoSource_SetOutputFormat(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetOutputFormat");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkFFMPEGVideoSource *op = static_cast<vtkFFMPEGVideoSource *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetOutputFormat(temp0);
    }
    else
    {
      op->vtkFFMPEGVideoSource::SetOutputFormat(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkFFMPEGVideoSource_Initialize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Initialize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkFFMPEGVideoSource *op = static_cast<vtkFFMPEGVideoSource *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->Initialize();
    }
    else
    {
      op->vtkFFMPEGVideoSource::Initialize();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkFFMPEGVideoSource_ReleaseSystemResources(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ReleaseSystemResources");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkFFMPEGVideoSource *op = static_cast<vtkFFMPEGVideoSource *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->ReleaseSystemResources();
    }
    else
    {
      op->vtkFFMPEGVideoSource::ReleaseSystemResources();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkFFMPEGVideoSource_SetFileName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetFileName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkFFMPEGVideoSource *op = static_cast<vtkFFMPEGVideoSource *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetFilePath(temp0))
  {
    if (ap.IsBound())
    {
      op->SetFileName(temp0);
    }
    else
    {
      op->vtkFFMPEGVideoSource::SetFileName(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkFFMPEGVideoSource_GetFileName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetFileName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkFFMPEGVideoSource *op = static_cast<vtkFFMPEGVideoSource *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    char *tempr = (ap.IsBound() ?
      op->GetFileName() :
      op->vtkFFMPEGVideoSource::GetFileName());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkFFMPEGVideoSource_InternalGrab(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InternalGrab");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkFFMPEGVideoSource *op = static_cast<vtkFFMPEGVideoSource *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->InternalGrab();
    }
    else
    {
      op->vtkFFMPEGVideoSource::InternalGrab();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkFFMPEGVideoSource_GetEndOfFile(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetEndOfFile");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkFFMPEGVideoSource *op = static_cast<vtkFFMPEGVideoSource *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetEndOfFile() :
      op->vtkFFMPEGVideoSource::GetEndOfFile());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkFFMPEGVideoSource_GetStereo3D(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetStereo3D");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkFFMPEGVideoSource *op = static_cast<vtkFFMPEGVideoSource *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetStereo3D() :
      op->vtkFFMPEGVideoSource::GetStereo3D());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkFFMPEGVideoSource_SetDecodingThreads(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetDecodingThreads");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkFFMPEGVideoSource *op = static_cast<vtkFFMPEGVideoSource *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetDecodingThreads(temp0);
    }
    else
    {
      op->vtkFFMPEGVideoSource::SetDecodingThreads(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkFFMPEGVideoSource_GetDecodingThreads(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetDecodingThreads");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkFFMPEGVideoSource *op = static_cast<vtkFFMPEGVideoSource *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetDecodingThreads() :
      op->vtkFFMPEGVideoSource::GetDecodingThreads());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkFFMPEGVideoSource_Methods[] = {
  {"IsTypeOf", PyvtkFFMPEGVideoSource_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkFFMPEGVideoSource_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkFFMPEGVideoSource_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkFFMPEGVideoSource\nC++: static vtkFFMPEGVideoSource *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkFFMPEGVideoSource_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkFFMPEGVideoSource\nC++: vtkFFMPEGVideoSource *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkFFMPEGVideoSource_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkFFMPEGVideoSource_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"Record", PyvtkFFMPEGVideoSource_Record, METH_VARARGS,
   "Record(self) -> None\nC++: void Record() override;\n\nStandard VCR functionality: Record incoming video.\n"},
  {"Play", PyvtkFFMPEGVideoSource_Play, METH_VARARGS,
   "Play(self) -> None\nC++: void Play() override;\n\nStandard VCR functionality: Play recorded video.\n"},
  {"Stop", PyvtkFFMPEGVideoSource_Stop, METH_VARARGS,
   "Stop(self) -> None\nC++: void Stop() override;\n\nStandard VCR functionality: Stop recording or playing.\n"},
  {"Grab", PyvtkFFMPEGVideoSource_Grab, METH_VARARGS,
   "Grab(self) -> None\nC++: void Grab() override;\n\nGrab a single video frame.\n"},
  {"SetFrameSize", PyvtkFFMPEGVideoSource_SetFrameSize, METH_VARARGS,
   "SetFrameSize(self, x:int, y:int, z:int) -> None\nC++: void SetFrameSize(int x, int y, int z) override;\nSetFrameSize(self, dim:[int, int, int]) -> None\nC++: void SetFrameSize(int dim[3]) override;\n\nRequest a particular frame size (set the third value to 1).\n"},
  {"SetFrameRate", PyvtkFFMPEGVideoSource_SetFrameRate, METH_VARARGS,
   "SetFrameRate(self, rate:float) -> None\nC++: void SetFrameRate(float rate) override;\n\nRequest a particular frame rate (default 30 frames per second).\n"},
  {"SetOutputFormat", PyvtkFFMPEGVideoSource_SetOutputFormat, METH_VARARGS,
   "SetOutputFormat(self, format:int) -> None\nC++: void SetOutputFormat(int format) override;\n\nRequest a particular output format (default: VTK_RGB).\n"},
  {"Initialize", PyvtkFFMPEGVideoSource_Initialize, METH_VARARGS,
   "Initialize(self) -> None\nC++: void Initialize() override;\n\nInitialize the driver (this is called automatically when the\nfirst grab is done).\n"},
  {"ReleaseSystemResources", PyvtkFFMPEGVideoSource_ReleaseSystemResources, METH_VARARGS,
   "ReleaseSystemResources(self) -> None\nC++: void ReleaseSystemResources() override;\n\nFree the driver (this is called automatically inside the\ndestructor).\n"},
  {"SetFileName", PyvtkFFMPEGVideoSource_SetFileName, METH_VARARGS,
   "SetFileName(self, _arg:str) -> None\nC++: virtual void SetFileName(const char *_arg)\n\nSpecify file name of the video\n"},
  {"GetFileName", PyvtkFFMPEGVideoSource_GetFileName, METH_VARARGS,
   "GetFileName(self) -> str\nC++: virtual char *GetFileName()\n\n"},
  {"InternalGrab", PyvtkFFMPEGVideoSource_InternalGrab, METH_VARARGS,
   "InternalGrab(self) -> None\nC++: void InternalGrab() override;\n\nThe internal function which actually does the grab.  You will\ndefinitely want to override this if you develop a vtkVideoSource\nsubclass.\n"},
  {"GetEndOfFile", PyvtkFFMPEGVideoSource_GetEndOfFile, METH_VARARGS,
   "GetEndOfFile(self) -> bool\nC++: virtual bool GetEndOfFile()\n\n"},
  {"GetStereo3D", PyvtkFFMPEGVideoSource_GetStereo3D, METH_VARARGS,
   "GetStereo3D(self) -> bool\nC++: virtual bool GetStereo3D()\n\n"},
  {"SetDecodingThreads", PyvtkFFMPEGVideoSource_SetDecodingThreads, METH_VARARGS,
   "SetDecodingThreads(self, _arg:int) -> None\nC++: virtual void SetDecodingThreads(int _arg)\n\nHow many threads to use for the decoding codec this will be in\naddition to the feed and drain threads. the default value is 4.\n"},
  {"GetDecodingThreads", PyvtkFFMPEGVideoSource_GetDecodingThreads, METH_VARARGS,
   "GetDecodingThreads(self) -> int\nC++: virtual int GetDecodingThreads()\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkFFMPEGVideoSource_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("frame_size"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkFFMPEGVideoSource_SetFrameSize(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkFFMPEGVideoSource_SetFrameSize(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetFrameSize\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("frame_rate"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkFFMPEGVideoSource_SetFrameRate(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkFFMPEGVideoSource_SetFrameRate(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetFrameRate\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("output_format"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkFFMPEGVideoSource_SetOutputFormat(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkFFMPEGVideoSource_SetOutputFormat(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetOutputFormat\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("file_name"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkFFMPEGVideoSource_GetFileName(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkFFMPEGVideoSource_SetFileName(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkFFMPEGVideoSource_SetFileName(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetFileName/SetFileName\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("decoding_threads"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkFFMPEGVideoSource_GetDecodingThreads(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkFFMPEGVideoSource_SetDecodingThreads(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkFFMPEGVideoSource_SetDecodingThreads(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetDecodingThreads/SetDecodingThreads\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("end_of_file"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkFFMPEGVideoSource_GetEndOfFile(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetEndOfFile\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("stereo3d"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkFFMPEGVideoSource_GetStereo3D(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetStereo3D\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkFFMPEGVideoSource_Doc =
  "vtkFFMPEGVideoSource - Reader for ffmpeg supported formats\n\n"
  "Superclass: vtkVideoSource\n\n"
  "Note this this class make use of multiple threads when decoding\n"
  "files. It has a feed thread, a video drain thread, and an audio drain\n"
  "thread. The decoding may use multiple threads as well as specified by\n"
  "DecodingThreads ivar.\n\n"
  "@sa\n"
  "vtkVideoSource\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkFFMPEGVideoSource_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkIOFFMPEG.vtkFFMPEGVideoSource", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkFFMPEGVideoSource_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkFFMPEGVideoSource_StaticNew()
{
  return vtkFFMPEGVideoSource::New();
}

PyObject *PyvtkFFMPEGVideoSource_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkFFMPEGVideoSource_Type, PyvtkFFMPEGVideoSource_Methods,
    "vtkFFMPEGVideoSource",
 &PyvtkFFMPEGVideoSource_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkVideoSource");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkFFMPEGVideoSource_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkFFMPEGVideoSource(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkFFMPEGVideoSourceAudioCallbackData_TypeNew();

  if (o && PyDict_SetItemString(dict, "vtkFFMPEGVideoSourceAudioCallbackData", o) != 0)
  {
    Py_DECREF(o);
  }

  o = PyvtkFFMPEGVideoSourceVideoCallbackData_TypeNew();

  if (o && PyDict_SetItemString(dict, "vtkFFMPEGVideoSourceVideoCallbackData", o) != 0)
  {
    Py_DECREF(o);
  }

  o = PyvtkFFMPEGVideoSource_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkFFMPEGVideoSource", o) != 0)
  {
    Py_DECREF(o);
  }

}

