// Code generated by go-swagger; DO NOT EDIT.

package iam_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-iam/stable/2019-12-10/models"
	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
)

// IamServiceGetOrganizationAuthMetadataReader is a Reader for the IamServiceGetOrganizationAuthMetadata structure.
type IamServiceGetOrganizationAuthMetadataReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *IamServiceGetOrganizationAuthMetadataReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewIamServiceGetOrganizationAuthMetadataOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewIamServiceGetOrganizationAuthMetadataDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewIamServiceGetOrganizationAuthMetadataOK creates a IamServiceGetOrganizationAuthMetadataOK with default headers values
func NewIamServiceGetOrganizationAuthMetadataOK() *IamServiceGetOrganizationAuthMetadataOK {
	return &IamServiceGetOrganizationAuthMetadataOK{}
}

/*
IamServiceGetOrganizationAuthMetadataOK describes a response with status code 200, with default header values.

A successful response.
*/
type IamServiceGetOrganizationAuthMetadataOK struct {
	Payload *models.HashicorpCloudIamGetOrganizationAuthMetadataResponse
}

// IsSuccess returns true when this iam service get organization auth metadata o k response has a 2xx status code
func (o *IamServiceGetOrganizationAuthMetadataOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this iam service get organization auth metadata o k response has a 3xx status code
func (o *IamServiceGetOrganizationAuthMetadataOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this iam service get organization auth metadata o k response has a 4xx status code
func (o *IamServiceGetOrganizationAuthMetadataOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this iam service get organization auth metadata o k response has a 5xx status code
func (o *IamServiceGetOrganizationAuthMetadataOK) IsServerError() bool {
	return false
}

// IsCode returns true when this iam service get organization auth metadata o k response a status code equal to that given
func (o *IamServiceGetOrganizationAuthMetadataOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the iam service get organization auth metadata o k response
func (o *IamServiceGetOrganizationAuthMetadataOK) Code() int {
	return 200
}

func (o *IamServiceGetOrganizationAuthMetadataOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /iam/2019-12-10/organizations/{organization_id}/auth-metadata][%d] iamServiceGetOrganizationAuthMetadataOK %s", 200, payload)
}

func (o *IamServiceGetOrganizationAuthMetadataOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /iam/2019-12-10/organizations/{organization_id}/auth-metadata][%d] iamServiceGetOrganizationAuthMetadataOK %s", 200, payload)
}

func (o *IamServiceGetOrganizationAuthMetadataOK) GetPayload() *models.HashicorpCloudIamGetOrganizationAuthMetadataResponse {
	return o.Payload
}

func (o *IamServiceGetOrganizationAuthMetadataOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudIamGetOrganizationAuthMetadataResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewIamServiceGetOrganizationAuthMetadataDefault creates a IamServiceGetOrganizationAuthMetadataDefault with default headers values
func NewIamServiceGetOrganizationAuthMetadataDefault(code int) *IamServiceGetOrganizationAuthMetadataDefault {
	return &IamServiceGetOrganizationAuthMetadataDefault{
		_statusCode: code,
	}
}

/*
IamServiceGetOrganizationAuthMetadataDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type IamServiceGetOrganizationAuthMetadataDefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this iam service get organization auth metadata default response has a 2xx status code
func (o *IamServiceGetOrganizationAuthMetadataDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this iam service get organization auth metadata default response has a 3xx status code
func (o *IamServiceGetOrganizationAuthMetadataDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this iam service get organization auth metadata default response has a 4xx status code
func (o *IamServiceGetOrganizationAuthMetadataDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this iam service get organization auth metadata default response has a 5xx status code
func (o *IamServiceGetOrganizationAuthMetadataDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this iam service get organization auth metadata default response a status code equal to that given
func (o *IamServiceGetOrganizationAuthMetadataDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the iam service get organization auth metadata default response
func (o *IamServiceGetOrganizationAuthMetadataDefault) Code() int {
	return o._statusCode
}

func (o *IamServiceGetOrganizationAuthMetadataDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /iam/2019-12-10/organizations/{organization_id}/auth-metadata][%d] IamService_GetOrganizationAuthMetadata default %s", o._statusCode, payload)
}

func (o *IamServiceGetOrganizationAuthMetadataDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /iam/2019-12-10/organizations/{organization_id}/auth-metadata][%d] IamService_GetOrganizationAuthMetadata default %s", o._statusCode, payload)
}

func (o *IamServiceGetOrganizationAuthMetadataDefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *IamServiceGetOrganizationAuthMetadataDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
