// Code generated by go-swagger; DO NOT EDIT.

package vault_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
	"github.com/hashicorp/hcp-sdk-go/clients/cloud-vault-service/stable/2020-11-25/models"
)

// UnlockReader is a Reader for the Unlock structure.
type UnlockReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *UnlockReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewUnlockOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewUnlockDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewUnlockOK creates a UnlockOK with default headers values
func NewUnlockOK() *UnlockOK {
	return &UnlockOK{}
}

/*
UnlockOK describes a response with status code 200, with default header values.

A successful response.
*/
type UnlockOK struct {
	Payload *models.HashicorpCloudVault20201125UnlockResponse
}

// IsSuccess returns true when this unlock o k response has a 2xx status code
func (o *UnlockOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this unlock o k response has a 3xx status code
func (o *UnlockOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this unlock o k response has a 4xx status code
func (o *UnlockOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this unlock o k response has a 5xx status code
func (o *UnlockOK) IsServerError() bool {
	return false
}

// IsCode returns true when this unlock o k response a status code equal to that given
func (o *UnlockOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the unlock o k response
func (o *UnlockOK) Code() int {
	return 200
}

func (o *UnlockOK) Error() string {
	return fmt.Sprintf("[POST /vault/2020-11-25/organizations/{location.organization_id}/projects/{location.project_id}/clusters/{cluster_id}/unlock][%d] unlockOK  %+v", 200, o.Payload)
}

func (o *UnlockOK) String() string {
	return fmt.Sprintf("[POST /vault/2020-11-25/organizations/{location.organization_id}/projects/{location.project_id}/clusters/{cluster_id}/unlock][%d] unlockOK  %+v", 200, o.Payload)
}

func (o *UnlockOK) GetPayload() *models.HashicorpCloudVault20201125UnlockResponse {
	return o.Payload
}

func (o *UnlockOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudVault20201125UnlockResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUnlockDefault creates a UnlockDefault with default headers values
func NewUnlockDefault(code int) *UnlockDefault {
	return &UnlockDefault{
		_statusCode: code,
	}
}

/*
UnlockDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type UnlockDefault struct {
	_statusCode int

	Payload *cloud.GrpcGatewayRuntimeError
}

// IsSuccess returns true when this unlock default response has a 2xx status code
func (o *UnlockDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this unlock default response has a 3xx status code
func (o *UnlockDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this unlock default response has a 4xx status code
func (o *UnlockDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this unlock default response has a 5xx status code
func (o *UnlockDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this unlock default response a status code equal to that given
func (o *UnlockDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the unlock default response
func (o *UnlockDefault) Code() int {
	return o._statusCode
}

func (o *UnlockDefault) Error() string {
	return fmt.Sprintf("[POST /vault/2020-11-25/organizations/{location.organization_id}/projects/{location.project_id}/clusters/{cluster_id}/unlock][%d] Unlock default  %+v", o._statusCode, o.Payload)
}

func (o *UnlockDefault) String() string {
	return fmt.Sprintf("[POST /vault/2020-11-25/organizations/{location.organization_id}/projects/{location.project_id}/clusters/{cluster_id}/unlock][%d] Unlock default  %+v", o._statusCode, o.Payload)
}

func (o *UnlockDefault) GetPayload() *cloud.GrpcGatewayRuntimeError {
	return o.Payload
}

func (o *UnlockDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GrpcGatewayRuntimeError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
