//
// DO NOT EDIT.  THIS FILE IS GENERATED FROM $SRCDIR/comm/mailnews/base/public/nsIMsgIncomingServer.idl
//


/// `interface nsIMsgIncomingServer : nsISupports`
///

/// ```text
/// /**
///  * Interface for incoming mail/news host
///  * this is the base interface for all mail server types (imap, pop, nntp, etc)
///  * often you will want to add extra interfaces that give you server-specific
///  * attributes and methods.
///  */
/// ```
///

// The actual type definition for the interface. This struct has methods
// declared on it which will call through its vtable. You never want to pass
// this type around by value, always pass it behind a reference.

#[repr(C)]
pub struct nsIMsgIncomingServer {
    vtable: &'static nsIMsgIncomingServerVTable,

    /// This field is a phantomdata to ensure that the VTable type and any
    /// struct containing it is not safe to send across threads by default, as
    /// XPCOM is generally not threadsafe.
    ///
    /// If this type is marked as [rust_sync], there will be explicit `Send` and
    /// `Sync` implementations on this type, which will override the inherited
    /// negative impls from `Rc`.
    __nosync: ::std::marker::PhantomData<::std::rc::Rc<u8>>,

    // Make the rust compiler aware that there might be interior mutability
    // in what actually implements the interface. This works around UB
    // introduced by https://github.com/llvm/llvm-project/commit/01859da84bad95fd51d6a03b08b60c660e642a4f
    // that a rust lint would make blatantly obvious, but doesn't exist.
    // (See https://github.com/rust-lang/rust/issues/111229).
    // This prevents optimizations, but those optimizations weren't available
    // before rustc switched to LLVM 16, and they now cause problems because
    // of the UB.
    // Until there's a lint available to find all our UB, it's simpler to
    // avoid the UB in the first place, at the cost of preventing optimizations
    // in places that don't cause UB. But again, those optimizations weren't
    // available before.
    __maybe_interior_mutability: ::std::cell::UnsafeCell<[u8; 0]>,
}

// Implementing XpCom for an interface exposes its IID, which allows for easy
// use of the `.query_interface<T>` helper method. This also defines that
// method for nsIMsgIncomingServer.
unsafe impl XpCom for nsIMsgIncomingServer {
    const IID: nsIID = nsID(0xaa9a3389, 0x9dac, 0x41f1,
        [0x9e, 0xc5, 0x18, 0x28, 0x7c, 0xfa, 0xa4, 0x7c]);
}

// We need to implement the RefCounted trait so we can be used with `RefPtr`.
// This trait teaches `RefPtr` how to manage our memory.
unsafe impl RefCounted for nsIMsgIncomingServer {
    #[inline]
    unsafe fn addref(&self) {
        self.AddRef();
    }
    #[inline]
    unsafe fn release(&self) {
        self.Release();
    }
}

// This trait is implemented on all types which can be coerced to from nsIMsgIncomingServer.
// It is used in the implementation of `fn coerce<T>`. We hide it from the
// documentation, because it clutters it up a lot.
#[doc(hidden)]
pub trait nsIMsgIncomingServerCoerce {
    /// Cheaply cast a value of this type from a `nsIMsgIncomingServer`.
    fn coerce_from(v: &nsIMsgIncomingServer) -> &Self;
}

// The trivial implementation: We can obviously coerce ourselves to ourselves.
impl nsIMsgIncomingServerCoerce for nsIMsgIncomingServer {
    #[inline]
    fn coerce_from(v: &nsIMsgIncomingServer) -> &Self {
        v
    }
}

impl nsIMsgIncomingServer {
    /// Cast this `nsIMsgIncomingServer` to one of its base interfaces.
    #[inline]
    pub fn coerce<T: nsIMsgIncomingServerCoerce>(&self) -> &T {
        T::coerce_from(self)
    }
}

// Every interface struct type implements `Deref` to its base interface. This
// causes methods on the base interfaces to be directly avaliable on the
// object. For example, you can call `.AddRef` or `.QueryInterface` directly
// on any interface which inherits from `nsISupports`.
impl ::std::ops::Deref for nsIMsgIncomingServer {
    type Target = nsISupports;
    #[inline]
    fn deref(&self) -> &nsISupports {
        unsafe {
            ::std::mem::transmute(self)
        }
    }
}

// Ensure we can use .coerce() to cast to our base types as well. Any type which
// our base interface can coerce from should be coercable from us as well.
impl<T: nsISupportsCoerce> nsIMsgIncomingServerCoerce for T {
    #[inline]
    fn coerce_from(v: &nsIMsgIncomingServer) -> &Self {
        T::coerce_from(v)
    }
}

// This struct represents the interface's VTable. A pointer to a statically
// allocated version of this struct is at the beginning of every nsIMsgIncomingServer
// object. It contains one pointer field for each method in the interface. In
// the case where we can't generate a binding for a method, we include a void
// pointer.
#[doc(hidden)]
#[repr(C)]
pub struct nsIMsgIncomingServerVTable {
    /// We need to include the members from the base interface's vtable at the start
    /// of the VTable definition.
    pub __base: nsISupportsVTable,

    /* attribute ACString key; */
    pub GetKey: unsafe extern "system" fn (this: *const nsIMsgIncomingServer, aKey: *mut ::nsstring::nsACString) -> ::nserror::nsresult,

    /* attribute ACString key; */
    pub SetKey: unsafe extern "system" fn (this: *const nsIMsgIncomingServer, aKey: *const ::nsstring::nsACString) -> ::nserror::nsresult,

    /* attribute AUTF8String UID; */
    pub GetUID: unsafe extern "system" fn (this: *const nsIMsgIncomingServer, aUID: *mut ::nsstring::nsACString) -> ::nserror::nsresult,

    /* attribute AUTF8String UID; */
    pub SetUID: unsafe extern "system" fn (this: *const nsIMsgIncomingServer, aUID: *const ::nsstring::nsACString) -> ::nserror::nsresult,

    /* attribute AUTF8String prettyName; */
    pub GetPrettyName: unsafe extern "system" fn (this: *const nsIMsgIncomingServer, aPrettyName: *mut ::nsstring::nsACString) -> ::nserror::nsresult,

    /* attribute AUTF8String prettyName; */
    pub SetPrettyName: unsafe extern "system" fn (this: *const nsIMsgIncomingServer, aPrettyName: *const ::nsstring::nsACString) -> ::nserror::nsresult,

    /* readonly attribute AUTF8String constructedPrettyName; */
    pub GetConstructedPrettyName: unsafe extern "system" fn (this: *const nsIMsgIncomingServer, aConstructedPrettyName: *mut ::nsstring::nsACString) -> ::nserror::nsresult,

    /* attribute AUTF8String hostName; */
    pub GetHostName: unsafe extern "system" fn (this: *const nsIMsgIncomingServer, aHostName: *mut ::nsstring::nsACString) -> ::nserror::nsresult,

    /* attribute AUTF8String hostName; */
    pub SetHostName: unsafe extern "system" fn (this: *const nsIMsgIncomingServer, aHostName: *const ::nsstring::nsACString) -> ::nserror::nsresult,

    /* attribute long port; */
    pub GetPort: unsafe extern "system" fn (this: *const nsIMsgIncomingServer, aPort: *mut i32) -> ::nserror::nsresult,

    /* attribute long port; */
    pub SetPort: unsafe extern "system" fn (this: *const nsIMsgIncomingServer, aPort: i32) -> ::nserror::nsresult,

    /* attribute AUTF8String username; */
    pub GetUsername: unsafe extern "system" fn (this: *const nsIMsgIncomingServer, aUsername: *mut ::nsstring::nsACString) -> ::nserror::nsresult,

    /* attribute AUTF8String username; */
    pub SetUsername: unsafe extern "system" fn (this: *const nsIMsgIncomingServer, aUsername: *const ::nsstring::nsACString) -> ::nserror::nsresult,

    /* attribute AUTF8String type; */
    pub GetType: unsafe extern "system" fn (this: *const nsIMsgIncomingServer, aType: *mut ::nsstring::nsACString) -> ::nserror::nsresult,

    /* attribute AUTF8String type; */
    pub SetType: unsafe extern "system" fn (this: *const nsIMsgIncomingServer, aType: *const ::nsstring::nsACString) -> ::nserror::nsresult,

    /* attribute AUTF8String clientid; */
    pub GetClientid: unsafe extern "system" fn (this: *const nsIMsgIncomingServer, aClientid: *mut ::nsstring::nsACString) -> ::nserror::nsresult,

    /* attribute AUTF8String clientid; */
    pub SetClientid: unsafe extern "system" fn (this: *const nsIMsgIncomingServer, aClientid: *const ::nsstring::nsACString) -> ::nserror::nsresult,

    /* attribute boolean clientidEnabled; */
    pub GetClientidEnabled: unsafe extern "system" fn (this: *const nsIMsgIncomingServer, aClientidEnabled: *mut bool) -> ::nserror::nsresult,

    /* attribute boolean clientidEnabled; */
    pub SetClientidEnabled: unsafe extern "system" fn (this: *const nsIMsgIncomingServer, aClientidEnabled: bool) -> ::nserror::nsresult,

    /* readonly attribute nsIMsgProtocolInfo protocolInfo; */
    pub GetProtocolInfo: unsafe extern "system" fn (this: *const nsIMsgIncomingServer, aProtocolInfo: *mut*const nsIMsgProtocolInfo) -> ::nserror::nsresult,

    /* readonly attribute AString accountManagerChrome; */
    pub GetAccountManagerChrome: unsafe extern "system" fn (this: *const nsIMsgIncomingServer, aAccountManagerChrome: *mut ::nsstring::nsAString) -> ::nserror::nsresult,

    /* readonly attribute ACString localStoreType; */
    pub GetLocalStoreType: unsafe extern "system" fn (this: *const nsIMsgIncomingServer, aLocalStoreType: *mut ::nsstring::nsACString) -> ::nserror::nsresult,

    /* readonly attribute ACString localDatabaseType; */
    pub GetLocalDatabaseType: unsafe extern "system" fn (this: *const nsIMsgIncomingServer, aLocalDatabaseType: *mut ::nsstring::nsACString) -> ::nserror::nsresult,

    /* void onUserOrHostNameChanged (in AUTF8String oldName, in AUTF8String newName, in boolean hostnameChanged); */
    pub OnUserOrHostNameChanged: unsafe extern "system" fn (this: *const nsIMsgIncomingServer, oldName: *const ::nsstring::nsACString, newName: *const ::nsstring::nsACString, hostnameChanged: bool) -> ::nserror::nsresult,

    /* attribute AString password; */
    pub GetPassword: unsafe extern "system" fn (this: *const nsIMsgIncomingServer, aPassword: *mut ::nsstring::nsAString) -> ::nserror::nsresult,

    /* attribute AString password; */
    pub SetPassword: unsafe extern "system" fn (this: *const nsIMsgIncomingServer, aPassword: *const ::nsstring::nsAString) -> ::nserror::nsresult,

    /* AString getPasswordWithUI (in AString aPromptString, in AString aPromptTitle); */
    pub GetPasswordWithUI: unsafe extern "system" fn (this: *const nsIMsgIncomingServer, aPromptString: *const ::nsstring::nsAString, aPromptTitle: *const ::nsstring::nsAString, _retval: *mut ::nsstring::nsAString) -> ::nserror::nsresult,

    /* void forgetPassword (); */
    pub ForgetPassword: unsafe extern "system" fn (this: *const nsIMsgIncomingServer) -> ::nserror::nsresult,

    /* void forgetSessionPassword (in boolean modifyLogin); */
    pub ForgetSessionPassword: unsafe extern "system" fn (this: *const nsIMsgIncomingServer, modifyLogin: bool) -> ::nserror::nsresult,

    /* attribute boolean downloadOnBiff; */
    pub GetDownloadOnBiff: unsafe extern "system" fn (this: *const nsIMsgIncomingServer, aDownloadOnBiff: *mut bool) -> ::nserror::nsresult,

    /* attribute boolean downloadOnBiff; */
    pub SetDownloadOnBiff: unsafe extern "system" fn (this: *const nsIMsgIncomingServer, aDownloadOnBiff: bool) -> ::nserror::nsresult,

    /* attribute boolean doBiff; */
    pub GetDoBiff: unsafe extern "system" fn (this: *const nsIMsgIncomingServer, aDoBiff: *mut bool) -> ::nserror::nsresult,

    /* attribute boolean doBiff; */
    pub SetDoBiff: unsafe extern "system" fn (this: *const nsIMsgIncomingServer, aDoBiff: bool) -> ::nserror::nsresult,

    /* attribute long biffMinutes; */
    pub GetBiffMinutes: unsafe extern "system" fn (this: *const nsIMsgIncomingServer, aBiffMinutes: *mut i32) -> ::nserror::nsresult,

    /* attribute long biffMinutes; */
    pub SetBiffMinutes: unsafe extern "system" fn (this: *const nsIMsgIncomingServer, aBiffMinutes: i32) -> ::nserror::nsresult,

    /* attribute unsigned long biffState; */
    pub GetBiffState: unsafe extern "system" fn (this: *const nsIMsgIncomingServer, aBiffState: *mut u32) -> ::nserror::nsresult,

    /* attribute unsigned long biffState; */
    pub SetBiffState: unsafe extern "system" fn (this: *const nsIMsgIncomingServer, aBiffState: u32) -> ::nserror::nsresult,

    /* attribute boolean performingBiff; */
    pub GetPerformingBiff: unsafe extern "system" fn (this: *const nsIMsgIncomingServer, aPerformingBiff: *mut bool) -> ::nserror::nsresult,

    /* attribute boolean performingBiff; */
    pub SetPerformingBiff: unsafe extern "system" fn (this: *const nsIMsgIncomingServer, aPerformingBiff: bool) -> ::nserror::nsresult,

    /* attribute nsIFile localPath; */
    pub GetLocalPath: unsafe extern "system" fn (this: *const nsIMsgIncomingServer, aLocalPath: *mut*const nsIFile) -> ::nserror::nsresult,

    /* attribute nsIFile localPath; */
    pub SetLocalPath: unsafe extern "system" fn (this: *const nsIMsgIncomingServer, aLocalPath: *const nsIFile) -> ::nserror::nsresult,

    /* readonly attribute nsIMsgPluggableStore msgStore; */
    pub GetMsgStore: unsafe extern "system" fn (this: *const nsIMsgIncomingServer, aMsgStore: *mut*const nsIMsgPluggableStore) -> ::nserror::nsresult,

    /* readonly attribute AUTF8String serverURI; */
    pub GetServerURI: unsafe extern "system" fn (this: *const nsIMsgIncomingServer, aServerURI: *mut ::nsstring::nsACString) -> ::nserror::nsresult,

    /* readonly attribute nsIMsgFolder rootFolder; */
    pub GetRootFolder: unsafe extern "system" fn (this: *const nsIMsgIncomingServer, aRootFolder: *mut*const nsIMsgFolder) -> ::nserror::nsresult,

    /* readonly attribute nsIMsgFolder rootMsgFolder; */
    pub GetRootMsgFolder: unsafe extern "system" fn (this: *const nsIMsgIncomingServer, aRootMsgFolder: *mut*const nsIMsgFolder) -> ::nserror::nsresult,

    /* attribute boolean serverBusy; */
    pub GetServerBusy: unsafe extern "system" fn (this: *const nsIMsgIncomingServer, aServerBusy: *mut bool) -> ::nserror::nsresult,

    /* attribute boolean serverBusy; */
    pub SetServerBusy: unsafe extern "system" fn (this: *const nsIMsgIncomingServer, aServerBusy: bool) -> ::nserror::nsresult,

    /* readonly attribute boolean isSecure; */
    pub GetIsSecure: unsafe extern "system" fn (this: *const nsIMsgIncomingServer, aIsSecure: *mut bool) -> ::nserror::nsresult,

    /* attribute nsMsgAuthMethodValue authMethod; */
    pub GetAuthMethod: unsafe extern "system" fn (this: *const nsIMsgIncomingServer, aAuthMethod: *mut nsMsgAuthMethodValue) -> ::nserror::nsresult,

    /* attribute nsMsgAuthMethodValue authMethod; */
    pub SetAuthMethod: unsafe extern "system" fn (this: *const nsIMsgIncomingServer, aAuthMethod: nsMsgAuthMethodValue) -> ::nserror::nsresult,

    /* attribute nsMsgSocketTypeValue socketType; */
    pub GetSocketType: unsafe extern "system" fn (this: *const nsIMsgIncomingServer, aSocketType: *mut nsMsgSocketTypeValue) -> ::nserror::nsresult,

    /* attribute nsMsgSocketTypeValue socketType; */
    pub SetSocketType: unsafe extern "system" fn (this: *const nsIMsgIncomingServer, aSocketType: nsMsgSocketTypeValue) -> ::nserror::nsresult,

    /* attribute boolean emptyTrashOnExit; */
    pub GetEmptyTrashOnExit: unsafe extern "system" fn (this: *const nsIMsgIncomingServer, aEmptyTrashOnExit: *mut bool) -> ::nserror::nsresult,

    /* attribute boolean emptyTrashOnExit; */
    pub SetEmptyTrashOnExit: unsafe extern "system" fn (this: *const nsIMsgIncomingServer, aEmptyTrashOnExit: bool) -> ::nserror::nsresult,

    /* nsIMsgFilterList getFilterList (in nsIMsgWindow aMsgWindow); */
    pub GetFilterList: unsafe extern "system" fn (this: *const nsIMsgIncomingServer, aMsgWindow: *const nsIMsgWindow, _retval: *mut*const nsIMsgFilterList) -> ::nserror::nsresult,

    /* void setFilterList (in nsIMsgFilterList aFilterList); */
    pub SetFilterList: unsafe extern "system" fn (this: *const nsIMsgIncomingServer, aFilterList: *const nsIMsgFilterList) -> ::nserror::nsresult,

    /* nsIMsgFilterList getEditableFilterList (in nsIMsgWindow aMsgWindow); */
    pub GetEditableFilterList: unsafe extern "system" fn (this: *const nsIMsgIncomingServer, aMsgWindow: *const nsIMsgWindow, _retval: *mut*const nsIMsgFilterList) -> ::nserror::nsresult,

    /* void setEditableFilterList (in nsIMsgFilterList aFilterList); */
    pub SetEditableFilterList: unsafe extern "system" fn (this: *const nsIMsgIncomingServer, aFilterList: *const nsIMsgFilterList) -> ::nserror::nsresult,

    /* void setDefaultLocalPath (in nsIFile aDefaultLocalPath); */
    pub SetDefaultLocalPath: unsafe extern "system" fn (this: *const nsIMsgIncomingServer, aDefaultLocalPath: *const nsIFile) -> ::nserror::nsresult,

    /* nsIURI verifyLogon (in nsIUrlListener aUrlListener, in nsIMsgWindow aMsgWindow); */
    pub VerifyLogon: unsafe extern "system" fn (this: *const nsIMsgIncomingServer, aUrlListener: *const nsIUrlListener, aMsgWindow: *const nsIMsgWindow, _retval: *mut*const nsIURI) -> ::nserror::nsresult,

    /* void performBiff (in nsIMsgWindow aMsgWindow); */
    pub PerformBiff: unsafe extern "system" fn (this: *const nsIMsgIncomingServer, aMsgWindow: *const nsIMsgWindow) -> ::nserror::nsresult,

    /* void getNewMessages (in nsIMsgFolder aFolder, in nsIMsgWindow aMsgWindow, in nsIUrlListener aUrlListener); */
    pub GetNewMessages: unsafe extern "system" fn (this: *const nsIMsgIncomingServer, aFolder: *const nsIMsgFolder, aMsgWindow: *const nsIMsgWindow, aUrlListener: *const nsIUrlListener) -> ::nserror::nsresult,

    /* readonly attribute boolean serverRequiresPasswordForBiff; */
    pub GetServerRequiresPasswordForBiff: unsafe extern "system" fn (this: *const nsIMsgIncomingServer, aServerRequiresPasswordForBiff: *mut bool) -> ::nserror::nsresult,

    /* void performExpand (in nsIMsgWindow aMsgWindow); */
    pub PerformExpand: unsafe extern "system" fn (this: *const nsIMsgIncomingServer, aMsgWindow: *const nsIMsgWindow) -> ::nserror::nsresult,

    /* void writeToFolderCache (in nsIMsgFolderCache folderCache); */
    pub WriteToFolderCache: unsafe extern "system" fn (this: *const nsIMsgIncomingServer, folderCache: *const nsIMsgFolderCache) -> ::nserror::nsresult,

    /* void closeCachedConnections (); */
    pub CloseCachedConnections: unsafe extern "system" fn (this: *const nsIMsgIncomingServer) -> ::nserror::nsresult,

    /* void shutdown (); */
    pub Shutdown: unsafe extern "system" fn (this: *const nsIMsgIncomingServer) -> ::nserror::nsresult,

    /* boolean getBoolValue (in string attr); */
    pub GetBoolValue: unsafe extern "system" fn (this: *const nsIMsgIncomingServer, attr: *const libc::c_char, _retval: *mut bool) -> ::nserror::nsresult,

    /* void setBoolValue (in string attr, in boolean value); */
    pub SetBoolValue: unsafe extern "system" fn (this: *const nsIMsgIncomingServer, attr: *const libc::c_char, value: bool) -> ::nserror::nsresult,

    /* AUTF8String getStringValue (in string attr); */
    pub GetStringValue: unsafe extern "system" fn (this: *const nsIMsgIncomingServer, attr: *const libc::c_char, _retval: *mut ::nsstring::nsACString) -> ::nserror::nsresult,

    /* void setStringValue (in string attr, in AUTF8String value); */
    pub SetStringValue: unsafe extern "system" fn (this: *const nsIMsgIncomingServer, attr: *const libc::c_char, value: *const ::nsstring::nsACString) -> ::nserror::nsresult,

    /* long getIntValue (in string attr); */
    pub GetIntValue: unsafe extern "system" fn (this: *const nsIMsgIncomingServer, attr: *const libc::c_char, _retval: *mut i32) -> ::nserror::nsresult,

    /* void setIntValue (in string attr, in long value); */
    pub SetIntValue: unsafe extern "system" fn (this: *const nsIMsgIncomingServer, attr: *const libc::c_char, value: i32) -> ::nserror::nsresult,

    /* nsIFile getFileValue (in string relpref, in string abspref); */
    pub GetFileValue: unsafe extern "system" fn (this: *const nsIMsgIncomingServer, relpref: *const libc::c_char, abspref: *const libc::c_char, _retval: *mut*const nsIFile) -> ::nserror::nsresult,

    /* void setFileValue (in string relpref, in string abspref, in nsIFile aValue); */
    pub SetFileValue: unsafe extern "system" fn (this: *const nsIMsgIncomingServer, relpref: *const libc::c_char, abspref: *const libc::c_char, aValue: *const nsIFile) -> ::nserror::nsresult,

    /* void clearAllValues (); */
    pub ClearAllValues: unsafe extern "system" fn (this: *const nsIMsgIncomingServer) -> ::nserror::nsresult,

    /* void removeFiles (); */
    pub RemoveFiles: unsafe extern "system" fn (this: *const nsIMsgIncomingServer) -> ::nserror::nsresult,

    /* attribute boolean valid; */
    pub GetValid: unsafe extern "system" fn (this: *const nsIMsgIncomingServer, aValid: *mut bool) -> ::nserror::nsresult,

    /* attribute boolean valid; */
    pub SetValid: unsafe extern "system" fn (this: *const nsIMsgIncomingServer, aValid: bool) -> ::nserror::nsresult,

    /* AString toString (); */
    pub ToString: unsafe extern "system" fn (this: *const nsIMsgIncomingServer, _retval: *mut ::nsstring::nsAString) -> ::nserror::nsresult,

    /* boolean equals (in nsIMsgIncomingServer server); */
    pub Equals: unsafe extern "system" fn (this: *const nsIMsgIncomingServer, server: *const nsIMsgIncomingServer, _retval: *mut bool) -> ::nserror::nsresult,

    /* readonly attribute boolean canHaveFilters; */
    pub GetCanHaveFilters: unsafe extern "system" fn (this: *const nsIMsgIncomingServer, aCanHaveFilters: *mut bool) -> ::nserror::nsresult,

    /* attribute boolean loginAtStartUp; */
    pub GetLoginAtStartUp: unsafe extern "system" fn (this: *const nsIMsgIncomingServer, aLoginAtStartUp: *mut bool) -> ::nserror::nsresult,

    /* attribute boolean loginAtStartUp; */
    pub SetLoginAtStartUp: unsafe extern "system" fn (this: *const nsIMsgIncomingServer, aLoginAtStartUp: bool) -> ::nserror::nsresult,

    /* attribute boolean limitOfflineMessageSize; */
    pub GetLimitOfflineMessageSize: unsafe extern "system" fn (this: *const nsIMsgIncomingServer, aLimitOfflineMessageSize: *mut bool) -> ::nserror::nsresult,

    /* attribute boolean limitOfflineMessageSize; */
    pub SetLimitOfflineMessageSize: unsafe extern "system" fn (this: *const nsIMsgIncomingServer, aLimitOfflineMessageSize: bool) -> ::nserror::nsresult,

    /* attribute long maxMessageSize; */
    pub GetMaxMessageSize: unsafe extern "system" fn (this: *const nsIMsgIncomingServer, aMaxMessageSize: *mut i32) -> ::nserror::nsresult,

    /* attribute long maxMessageSize; */
    pub SetMaxMessageSize: unsafe extern "system" fn (this: *const nsIMsgIncomingServer, aMaxMessageSize: i32) -> ::nserror::nsresult,

    /* attribute boolean offlineDownload; */
    pub GetOfflineDownload: unsafe extern "system" fn (this: *const nsIMsgIncomingServer, aOfflineDownload: *mut bool) -> ::nserror::nsresult,

    /* attribute boolean offlineDownload; */
    pub SetOfflineDownload: unsafe extern "system" fn (this: *const nsIMsgIncomingServer, aOfflineDownload: bool) -> ::nserror::nsresult,

    /* attribute boolean autoSyncOfflineStores; */
    pub GetAutoSyncOfflineStores: unsafe extern "system" fn (this: *const nsIMsgIncomingServer, aAutoSyncOfflineStores: *mut bool) -> ::nserror::nsresult,

    /* attribute boolean autoSyncOfflineStores; */
    pub SetAutoSyncOfflineStores: unsafe extern "system" fn (this: *const nsIMsgIncomingServer, aAutoSyncOfflineStores: bool) -> ::nserror::nsresult,

    /* attribute long autoSyncMaxAgeDays; */
    pub GetAutoSyncMaxAgeDays: unsafe extern "system" fn (this: *const nsIMsgIncomingServer, aAutoSyncMaxAgeDays: *mut i32) -> ::nserror::nsresult,

    /* attribute long autoSyncMaxAgeDays; */
    pub SetAutoSyncMaxAgeDays: unsafe extern "system" fn (this: *const nsIMsgIncomingServer, aAutoSyncMaxAgeDays: i32) -> ::nserror::nsresult,

    /* attribute nsIMsgRetentionSettings retentionSettings; */
    pub GetRetentionSettings: unsafe extern "system" fn (this: *const nsIMsgIncomingServer, aRetentionSettings: *mut*const nsIMsgRetentionSettings) -> ::nserror::nsresult,

    /* attribute nsIMsgRetentionSettings retentionSettings; */
    pub SetRetentionSettings: unsafe extern "system" fn (this: *const nsIMsgIncomingServer, aRetentionSettings: *const nsIMsgRetentionSettings) -> ::nserror::nsresult,

    /* readonly attribute boolean canBeDefaultServer; */
    pub GetCanBeDefaultServer: unsafe extern "system" fn (this: *const nsIMsgIncomingServer, aCanBeDefaultServer: *mut bool) -> ::nserror::nsresult,

    /* readonly attribute boolean canSearchMessages; */
    pub GetCanSearchMessages: unsafe extern "system" fn (this: *const nsIMsgIncomingServer, aCanSearchMessages: *mut bool) -> ::nserror::nsresult,

    /* attribute nsIMsgDownloadSettings downloadSettings; */
    pub GetDownloadSettings: unsafe extern "system" fn (this: *const nsIMsgIncomingServer, aDownloadSettings: *mut*const nsIMsgDownloadSettings) -> ::nserror::nsresult,

    /* attribute nsIMsgDownloadSettings downloadSettings; */
    pub SetDownloadSettings: unsafe extern "system" fn (this: *const nsIMsgIncomingServer, aDownloadSettings: *const nsIMsgDownloadSettings) -> ::nserror::nsresult,

    /* readonly attribute long offlineSupportLevel; */
    pub GetOfflineSupportLevel: unsafe extern "system" fn (this: *const nsIMsgIncomingServer, aOfflineSupportLevel: *mut i32) -> ::nserror::nsresult,

    /* attribute boolean hidden; */
    pub GetHidden: unsafe extern "system" fn (this: *const nsIMsgIncomingServer, aHidden: *mut bool) -> ::nserror::nsresult,

    /* attribute boolean hidden; */
    pub SetHidden: unsafe extern "system" fn (this: *const nsIMsgIncomingServer, aHidden: bool) -> ::nserror::nsresult,

    /* attribute boolean defaultCopiesAndFoldersPrefsToServer; */
    pub GetDefaultCopiesAndFoldersPrefsToServer: unsafe extern "system" fn (this: *const nsIMsgIncomingServer, aDefaultCopiesAndFoldersPrefsToServer: *mut bool) -> ::nserror::nsresult,

    /* attribute boolean defaultCopiesAndFoldersPrefsToServer; */
    pub SetDefaultCopiesAndFoldersPrefsToServer: unsafe extern "system" fn (this: *const nsIMsgIncomingServer, aDefaultCopiesAndFoldersPrefsToServer: bool) -> ::nserror::nsresult,

    /* attribute boolean canCreateFoldersOnServer; */
    pub GetCanCreateFoldersOnServer: unsafe extern "system" fn (this: *const nsIMsgIncomingServer, aCanCreateFoldersOnServer: *mut bool) -> ::nserror::nsresult,

    /* attribute boolean canCreateFoldersOnServer; */
    pub SetCanCreateFoldersOnServer: unsafe extern "system" fn (this: *const nsIMsgIncomingServer, aCanCreateFoldersOnServer: bool) -> ::nserror::nsresult,

    /* attribute boolean canFileMessagesOnServer; */
    pub GetCanFileMessagesOnServer: unsafe extern "system" fn (this: *const nsIMsgIncomingServer, aCanFileMessagesOnServer: *mut bool) -> ::nserror::nsresult,

    /* attribute boolean canFileMessagesOnServer; */
    pub SetCanFileMessagesOnServer: unsafe extern "system" fn (this: *const nsIMsgIncomingServer, aCanFileMessagesOnServer: bool) -> ::nserror::nsresult,

    /* readonly attribute nsMsgSearchScopeValue filterScope; */
    pub GetFilterScope: unsafe extern "system" fn (this: *const nsIMsgIncomingServer, aFilterScope: *mut nsMsgSearchScopeValue) -> ::nserror::nsresult,

    /* readonly attribute nsMsgSearchScopeValue searchScope; */
    pub GetSearchScope: unsafe extern "system" fn (this: *const nsIMsgIncomingServer, aSearchScope: *mut nsMsgSearchScopeValue) -> ::nserror::nsresult,

    /* readonly attribute boolean passwordPromptRequired; */
    pub GetPasswordPromptRequired: unsafe extern "system" fn (this: *const nsIMsgIncomingServer, aPasswordPromptRequired: *mut bool) -> ::nserror::nsresult,

    /* void configureTemporaryFilters (in nsIMsgFilterList filterList); */
    pub ConfigureTemporaryFilters: unsafe extern "system" fn (this: *const nsIMsgIncomingServer, filterList: *const nsIMsgFilterList) -> ::nserror::nsresult,

    /* void clearTemporaryReturnReceiptsFilter (); */
    pub ClearTemporaryReturnReceiptsFilter: unsafe extern "system" fn (this: *const nsIMsgIncomingServer) -> ::nserror::nsresult,

    /* readonly attribute nsISpamSettings spamSettings; */
    pub GetSpamSettings: unsafe extern "system" fn (this: *const nsIMsgIncomingServer, aSpamSettings: *mut*const nsISpamSettings) -> ::nserror::nsresult,

    /* readonly attribute nsIMsgFilterPlugin spamFilterPlugin; */
    pub GetSpamFilterPlugin: unsafe extern "system" fn (this: *const nsIMsgIncomingServer, aSpamFilterPlugin: *mut*const nsIMsgFilterPlugin) -> ::nserror::nsresult,

    /* nsIMsgFolder getMsgFolderFromURI (in nsIMsgFolder aFolderResource, in AUTF8String aURI); */
    pub GetMsgFolderFromURI: unsafe extern "system" fn (this: *const nsIMsgIncomingServer, aFolderResource: *const nsIMsgFolder, aURI: *const ::nsstring::nsACString, _retval: *mut*const nsIMsgFolder) -> ::nserror::nsresult,

    /* readonly attribute boolean isDeferredTo; */
    pub GetIsDeferredTo: unsafe extern "system" fn (this: *const nsIMsgIncomingServer, aIsDeferredTo: *mut bool) -> ::nserror::nsresult,

    /* attribute long incomingDuplicateAction; */
    pub GetIncomingDuplicateAction: unsafe extern "system" fn (this: *const nsIMsgIncomingServer, aIncomingDuplicateAction: *mut i32) -> ::nserror::nsresult,

    /* attribute long incomingDuplicateAction; */
    pub SetIncomingDuplicateAction: unsafe extern "system" fn (this: *const nsIMsgIncomingServer, aIncomingDuplicateAction: i32) -> ::nserror::nsresult,

    /* boolean isNewHdrDuplicate (in nsIMsgDBHdr aNewHdr); */
    pub IsNewHdrDuplicate: unsafe extern "system" fn (this: *const nsIMsgIncomingServer, aNewHdr: *const nsIMsgDBHdr, _retval: *mut bool) -> ::nserror::nsresult,
}


// The implementations of the function wrappers which are exposed to rust code.
// Call these methods rather than manually calling through the VTable struct.
impl nsIMsgIncomingServer {

    pub const keepDups: i32 = 0;


    pub const deleteDups: i32 = 1;


    pub const moveDupsToTrash: i32 = 2;


    pub const markDupsRead: i32 = 3;

    /// ```text
    /// /**
    ///    * internal pref key - guaranteed to be unique across all servers
    ///    */
    /// ```
    ///

    /// `attribute ACString key;`
    #[inline]
    pub unsafe fn GetKey(&self, aKey: *mut ::nsstring::nsACString) -> ::nserror::nsresult {
        ((*self.vtable).GetKey)(self, aKey)
    }


    /// ```text
    /// /**
    ///    * internal pref key - guaranteed to be unique across all servers
    ///    */
    /// ```
    ///

    /// `attribute ACString key;`
    #[inline]
    pub unsafe fn SetKey(&self, aKey: *const ::nsstring::nsACString) -> ::nserror::nsresult {
        ((*self.vtable).SetKey)(self, aKey)
    }


    /// ```text
    /// /**
    ///    * A unique identifier for this server that can be used for the same
    ///    * server synced across multiple profiles. Auto-generated on first use.
    ///    */
    /// ```
    ///

    /// `attribute AUTF8String UID;`
    #[inline]
    pub unsafe fn GetUID(&self, aUID: *mut ::nsstring::nsACString) -> ::nserror::nsresult {
        ((*self.vtable).GetUID)(self, aUID)
    }


    /// ```text
    /// /**
    ///    * A unique identifier for this server that can be used for the same
    ///    * server synced across multiple profiles. Auto-generated on first use.
    ///    */
    /// ```
    ///

    /// `attribute AUTF8String UID;`
    #[inline]
    pub unsafe fn SetUID(&self, aUID: *const ::nsstring::nsACString) -> ::nserror::nsresult {
        ((*self.vtable).SetUID)(self, aUID)
    }


    /// ```text
    /// /**
    ///    * pretty name - should be "userid on hostname"
    ///    * if the pref is not set
    ///    */
    /// ```
    ///

    /// `attribute AUTF8String prettyName;`
    #[inline]
    pub unsafe fn GetPrettyName(&self, aPrettyName: *mut ::nsstring::nsACString) -> ::nserror::nsresult {
        ((*self.vtable).GetPrettyName)(self, aPrettyName)
    }


    /// ```text
    /// /**
    ///    * pretty name - should be "userid on hostname"
    ///    * if the pref is not set
    ///    */
    /// ```
    ///

    /// `attribute AUTF8String prettyName;`
    #[inline]
    pub unsafe fn SetPrettyName(&self, aPrettyName: *const ::nsstring::nsACString) -> ::nserror::nsresult {
        ((*self.vtable).SetPrettyName)(self, aPrettyName)
    }


    /// ```text
    /// /**
    ///   * helper function to construct the pretty name in a server type
    ///   * specific way - e.g., mail for foo@test.com, news on news.mozilla.org
    ///   */
    /// ```
    ///

    /// `readonly attribute AUTF8String constructedPrettyName;`
    #[inline]
    pub unsafe fn GetConstructedPrettyName(&self, aConstructedPrettyName: *mut ::nsstring::nsACString) -> ::nserror::nsresult {
        ((*self.vtable).GetConstructedPrettyName)(self, aConstructedPrettyName)
    }


    /// ```text
    /// /**
    ///    * hostname of the server
    ///    */
    /// ```
    ///

    /// `attribute AUTF8String hostName;`
    #[inline]
    pub unsafe fn GetHostName(&self, aHostName: *mut ::nsstring::nsACString) -> ::nserror::nsresult {
        ((*self.vtable).GetHostName)(self, aHostName)
    }


    /// ```text
    /// /**
    ///    * hostname of the server
    ///    */
    /// ```
    ///

    /// `attribute AUTF8String hostName;`
    #[inline]
    pub unsafe fn SetHostName(&self, aHostName: *const ::nsstring::nsACString) -> ::nserror::nsresult {
        ((*self.vtable).SetHostName)(self, aHostName)
    }



    /// `attribute long port;`
    #[inline]
    pub unsafe fn GetPort(&self, aPort: *mut i32) -> ::nserror::nsresult {
        ((*self.vtable).GetPort)(self, aPort)
    }



    /// `attribute long port;`
    #[inline]
    pub unsafe fn SetPort(&self, aPort: i32) -> ::nserror::nsresult {
        ((*self.vtable).SetPort)(self, aPort)
    }


    /// ```text
    /// /**
    ///    * userid to log into the server
    ///    */
    /// ```
    ///

    /// `attribute AUTF8String username;`
    #[inline]
    pub unsafe fn GetUsername(&self, aUsername: *mut ::nsstring::nsACString) -> ::nserror::nsresult {
        ((*self.vtable).GetUsername)(self, aUsername)
    }


    /// ```text
    /// /**
    ///    * userid to log into the server
    ///    */
    /// ```
    ///

    /// `attribute AUTF8String username;`
    #[inline]
    pub unsafe fn SetUsername(&self, aUsername: *const ::nsstring::nsACString) -> ::nserror::nsresult {
        ((*self.vtable).SetUsername)(self, aUsername)
    }


    /// ```text
    /// /**
    ///    * protocol type, i.e. "pop3", "imap", "nntp", "none", etc
    ///    * used to construct URLs
    ///    */
    /// ```
    ///

    /// `attribute AUTF8String type;`
    #[inline]
    pub unsafe fn GetType(&self, aType: *mut ::nsstring::nsACString) -> ::nserror::nsresult {
        ((*self.vtable).GetType)(self, aType)
    }


    /// ```text
    /// /**
    ///    * protocol type, i.e. "pop3", "imap", "nntp", "none", etc
    ///    * used to construct URLs
    ///    */
    /// ```
    ///

    /// `attribute AUTF8String type;`
    #[inline]
    pub unsafe fn SetType(&self, aType: *const ::nsstring::nsACString) -> ::nserror::nsresult {
        ((*self.vtable).SetType)(self, aType)
    }


    /// ```text
    /// /**
    ///    * The CLIENTID to use for this server.
    ///    * @see https://tools.ietf.org/html/draft-yu-imap-client-id-01
    ///    */
    /// ```
    ///

    /// `attribute AUTF8String clientid;`
    #[inline]
    pub unsafe fn GetClientid(&self, aClientid: *mut ::nsstring::nsACString) -> ::nserror::nsresult {
        ((*self.vtable).GetClientid)(self, aClientid)
    }


    /// ```text
    /// /**
    ///    * The CLIENTID to use for this server.
    ///    * @see https://tools.ietf.org/html/draft-yu-imap-client-id-01
    ///    */
    /// ```
    ///

    /// `attribute AUTF8String clientid;`
    #[inline]
    pub unsafe fn SetClientid(&self, aClientid: *const ::nsstring::nsACString) -> ::nserror::nsresult {
        ((*self.vtable).SetClientid)(self, aClientid)
    }


    /// ```text
    /// /**
    ///    * Whether the CLIENTID feature above is enabled.
    ///    */
    /// ```
    ///

    /// `attribute boolean clientidEnabled;`
    #[inline]
    pub unsafe fn GetClientidEnabled(&self, aClientidEnabled: *mut bool) -> ::nserror::nsresult {
        ((*self.vtable).GetClientidEnabled)(self, aClientidEnabled)
    }


    /// ```text
    /// /**
    ///    * Whether the CLIENTID feature above is enabled.
    ///    */
    /// ```
    ///

    /// `attribute boolean clientidEnabled;`
    #[inline]
    pub unsafe fn SetClientidEnabled(&self, aClientidEnabled: bool) -> ::nserror::nsresult {
        ((*self.vtable).SetClientidEnabled)(self, aClientidEnabled)
    }


    /// ```text
    /// /**
    ///    * The proper instance of nsIMsgProtocolInfo corresponding to this server type.
    ///    */
    /// ```
    ///

    /// `readonly attribute nsIMsgProtocolInfo protocolInfo;`
    #[inline]
    pub unsafe fn GetProtocolInfo(&self, aProtocolInfo: *mut*const nsIMsgProtocolInfo) -> ::nserror::nsresult {
        ((*self.vtable).GetProtocolInfo)(self, aProtocolInfo)
    }



    /// `readonly attribute AString accountManagerChrome;`
    #[inline]
    pub unsafe fn GetAccountManagerChrome(&self, aAccountManagerChrome: *mut ::nsstring::nsAString) -> ::nserror::nsresult {
        ((*self.vtable).GetAccountManagerChrome)(self, aAccountManagerChrome)
    }


    /// ```text
    /// /**
    ///    * The schema for the local mail store, such as "mailbox", "imap", or "news"
    ///    * used to construct URIs. The contractID for the nsIMsgMessageService
    ///    * implementation that will manage access to messages associated with this
    ///    * server is constructed using this type.
    ///    */
    /// ```
    ///

    /// `readonly attribute ACString localStoreType;`
    #[inline]
    pub unsafe fn GetLocalStoreType(&self, aLocalStoreType: *mut ::nsstring::nsACString) -> ::nserror::nsresult {
        ((*self.vtable).GetLocalStoreType)(self, aLocalStoreType)
    }


    /// ```text
    /// /**
    ///    * The schema for the nsIMsgDatabase implementation, such as "mailbox" or
    ///    * "imap", that will be used to construct the database instance used by
    ///    * message folders associated with this server.
    ///    */
    /// ```
    ///

    /// `readonly attribute ACString localDatabaseType;`
    #[inline]
    pub unsafe fn GetLocalDatabaseType(&self, aLocalDatabaseType: *mut ::nsstring::nsACString) -> ::nserror::nsresult {
        ((*self.vtable).GetLocalDatabaseType)(self, aLocalDatabaseType)
    }



    /// `void onUserOrHostNameChanged (in AUTF8String oldName, in AUTF8String newName, in boolean hostnameChanged);`
    #[inline]
    pub unsafe fn OnUserOrHostNameChanged(&self, oldName: *const ::nsstring::nsACString, newName: *const ::nsstring::nsACString, hostnameChanged: bool) -> ::nserror::nsresult {
        ((*self.vtable).OnUserOrHostNameChanged)(self, oldName, newName, hostnameChanged)
    }



    /// `attribute AString password;`
    #[inline]
    pub unsafe fn GetPassword(&self, aPassword: *mut ::nsstring::nsAString) -> ::nserror::nsresult {
        ((*self.vtable).GetPassword)(self, aPassword)
    }



    /// `attribute AString password;`
    #[inline]
    pub unsafe fn SetPassword(&self, aPassword: *const ::nsstring::nsAString) -> ::nserror::nsresult {
        ((*self.vtable).SetPassword)(self, aPassword)
    }


    /// ```text
    /// /**
    ///    * Attempts to get the password first from the password manager, if that
    ///    * fails it will attempt to get it from the user.
    ///    *
    ///    * Native (C++/Rust) consumers may use the method's return value as input to
    ///    * prefill the password prompt with.
    ///    *
    ///    * @param aPromptString The text of the prompt if the user is prompted for
    ///    *                      password.
    ///    * @param aPromptTitle  The title of the prompt if the user is prompted.
    ///    * @return              The obtained password. Could be an empty password.
    ///    *
    ///    * @exception NS_ERROR_FAILURE  The password could not be obtained.
    ///    *
    ///    * @note NS_MSG_PASSWORD_PROMPT_CANCELLED is a success code that is returned
    ///    *       if the prompt was presented to the user but the user cancelled the
    ///    *       prompt.
    ///    */
    /// ```
    ///

    /// `AString getPasswordWithUI (in AString aPromptString, in AString aPromptTitle);`
    #[inline]
    pub unsafe fn GetPasswordWithUI(&self, aPromptString: *const ::nsstring::nsAString, aPromptTitle: *const ::nsstring::nsAString, _retval: *mut ::nsstring::nsAString) -> ::nserror::nsresult {
        ((*self.vtable).GetPasswordWithUI)(self, aPromptString, aPromptTitle, _retval)
    }



    /// `void forgetPassword ();`
    #[inline]
    pub unsafe fn ForgetPassword(&self, ) -> ::nserror::nsresult {
        ((*self.vtable).ForgetPassword)(self, )
    }


    /// ```text
    /// /**
    ///    * Forget the password in memory which is cached for the session.
    ///    *
    ///    * @param modifyLogin  Only relevant for nsImapIncomingServer override. When
    ///    *                     true and authentication method is oauth2, the password
    ///    *                     and user authenticated flag are not cleared.
    ///    */
    /// ```
    ///

    /// `void forgetSessionPassword (in boolean modifyLogin);`
    #[inline]
    pub unsafe fn ForgetSessionPassword(&self, modifyLogin: bool) -> ::nserror::nsresult {
        ((*self.vtable).ForgetSessionPassword)(self, modifyLogin)
    }



    /// `attribute boolean downloadOnBiff;`
    #[inline]
    pub unsafe fn GetDownloadOnBiff(&self, aDownloadOnBiff: *mut bool) -> ::nserror::nsresult {
        ((*self.vtable).GetDownloadOnBiff)(self, aDownloadOnBiff)
    }



    /// `attribute boolean downloadOnBiff;`
    #[inline]
    pub unsafe fn SetDownloadOnBiff(&self, aDownloadOnBiff: bool) -> ::nserror::nsresult {
        ((*self.vtable).SetDownloadOnBiff)(self, aDownloadOnBiff)
    }



    /// `attribute boolean doBiff;`
    #[inline]
    pub unsafe fn GetDoBiff(&self, aDoBiff: *mut bool) -> ::nserror::nsresult {
        ((*self.vtable).GetDoBiff)(self, aDoBiff)
    }



    /// `attribute boolean doBiff;`
    #[inline]
    pub unsafe fn SetDoBiff(&self, aDoBiff: bool) -> ::nserror::nsresult {
        ((*self.vtable).SetDoBiff)(self, aDoBiff)
    }



    /// `attribute long biffMinutes;`
    #[inline]
    pub unsafe fn GetBiffMinutes(&self, aBiffMinutes: *mut i32) -> ::nserror::nsresult {
        ((*self.vtable).GetBiffMinutes)(self, aBiffMinutes)
    }



    /// `attribute long biffMinutes;`
    #[inline]
    pub unsafe fn SetBiffMinutes(&self, aBiffMinutes: i32) -> ::nserror::nsresult {
        ((*self.vtable).SetBiffMinutes)(self, aBiffMinutes)
    }



    /// `attribute unsigned long biffState;`
    #[inline]
    pub unsafe fn GetBiffState(&self, aBiffState: *mut u32) -> ::nserror::nsresult {
        ((*self.vtable).GetBiffState)(self, aBiffState)
    }



    /// `attribute unsigned long biffState;`
    #[inline]
    pub unsafe fn SetBiffState(&self, aBiffState: u32) -> ::nserror::nsresult {
        ((*self.vtable).SetBiffState)(self, aBiffState)
    }



    /// `attribute boolean performingBiff;`
    #[inline]
    pub unsafe fn GetPerformingBiff(&self, aPerformingBiff: *mut bool) -> ::nserror::nsresult {
        ((*self.vtable).GetPerformingBiff)(self, aPerformingBiff)
    }



    /// `attribute boolean performingBiff;`
    #[inline]
    pub unsafe fn SetPerformingBiff(&self, aPerformingBiff: bool) -> ::nserror::nsresult {
        ((*self.vtable).SetPerformingBiff)(self, aPerformingBiff)
    }



    /// `attribute nsIFile localPath;`
    #[inline]
    pub unsafe fn GetLocalPath(&self, aLocalPath: *mut*const nsIFile) -> ::nserror::nsresult {
        ((*self.vtable).GetLocalPath)(self, aLocalPath)
    }



    /// `attribute nsIFile localPath;`
    #[inline]
    pub unsafe fn SetLocalPath(&self, aLocalPath: *const nsIFile) -> ::nserror::nsresult {
        ((*self.vtable).SetLocalPath)(self, aLocalPath)
    }



    /// `readonly attribute nsIMsgPluggableStore msgStore;`
    #[inline]
    pub unsafe fn GetMsgStore(&self, aMsgStore: *mut*const nsIMsgPluggableStore) -> ::nserror::nsresult {
        ((*self.vtable).GetMsgStore)(self, aMsgStore)
    }



    /// `readonly attribute AUTF8String serverURI;`
    #[inline]
    pub unsafe fn GetServerURI(&self, aServerURI: *mut ::nsstring::nsACString) -> ::nserror::nsresult {
        ((*self.vtable).GetServerURI)(self, aServerURI)
    }



    /// `readonly attribute nsIMsgFolder rootFolder;`
    #[inline]
    pub unsafe fn GetRootFolder(&self, aRootFolder: *mut*const nsIMsgFolder) -> ::nserror::nsresult {
        ((*self.vtable).GetRootFolder)(self, aRootFolder)
    }



    /// `readonly attribute nsIMsgFolder rootMsgFolder;`
    #[inline]
    pub unsafe fn GetRootMsgFolder(&self, aRootMsgFolder: *mut*const nsIMsgFolder) -> ::nserror::nsresult {
        ((*self.vtable).GetRootMsgFolder)(self, aRootMsgFolder)
    }



    /// `attribute boolean serverBusy;`
    #[inline]
    pub unsafe fn GetServerBusy(&self, aServerBusy: *mut bool) -> ::nserror::nsresult {
        ((*self.vtable).GetServerBusy)(self, aServerBusy)
    }



    /// `attribute boolean serverBusy;`
    #[inline]
    pub unsafe fn SetServerBusy(&self, aServerBusy: bool) -> ::nserror::nsresult {
        ((*self.vtable).SetServerBusy)(self, aServerBusy)
    }


    /// ```text
    /// /**
    ///    * Is the server using a secure channel (SSL or STARTTLS).
    ///    */
    /// ```
    ///

    /// `readonly attribute boolean isSecure;`
    #[inline]
    pub unsafe fn GetIsSecure(&self, aIsSecure: *mut bool) -> ::nserror::nsresult {
        ((*self.vtable).GetIsSecure)(self, aIsSecure)
    }


    /// ```text
    /// /**
    ///    * Authentication mechanism.
    ///    *
    ///    * @see nsMsgAuthMethod (in MailNewsTypes2.idl)
    ///    * Same as "mail.server...authMethod" pref
    ///    */
    /// ```
    ///

    /// `attribute nsMsgAuthMethodValue authMethod;`
    #[inline]
    pub unsafe fn GetAuthMethod(&self, aAuthMethod: *mut nsMsgAuthMethodValue) -> ::nserror::nsresult {
        ((*self.vtable).GetAuthMethod)(self, aAuthMethod)
    }


    /// ```text
    /// /**
    ///    * Authentication mechanism.
    ///    *
    ///    * @see nsMsgAuthMethod (in MailNewsTypes2.idl)
    ///    * Same as "mail.server...authMethod" pref
    ///    */
    /// ```
    ///

    /// `attribute nsMsgAuthMethodValue authMethod;`
    #[inline]
    pub unsafe fn SetAuthMethod(&self, aAuthMethod: nsMsgAuthMethodValue) -> ::nserror::nsresult {
        ((*self.vtable).SetAuthMethod)(self, aAuthMethod)
    }


    /// ```text
    /// /**
    ///    * Whether to SSL or STARTTLS or not
    ///    *
    ///    * @see nsMsgSocketType (in MailNewsTypes2.idl)
    ///    * Same as "mail.server...socketType" pref
    ///    */
    /// ```
    ///

    /// `attribute nsMsgSocketTypeValue socketType;`
    #[inline]
    pub unsafe fn GetSocketType(&self, aSocketType: *mut nsMsgSocketTypeValue) -> ::nserror::nsresult {
        ((*self.vtable).GetSocketType)(self, aSocketType)
    }


    /// ```text
    /// /**
    ///    * Whether to SSL or STARTTLS or not
    ///    *
    ///    * @see nsMsgSocketType (in MailNewsTypes2.idl)
    ///    * Same as "mail.server...socketType" pref
    ///    */
    /// ```
    ///

    /// `attribute nsMsgSocketTypeValue socketType;`
    #[inline]
    pub unsafe fn SetSocketType(&self, aSocketType: nsMsgSocketTypeValue) -> ::nserror::nsresult {
        ((*self.vtable).SetSocketType)(self, aSocketType)
    }



    /// `attribute boolean emptyTrashOnExit;`
    #[inline]
    pub unsafe fn GetEmptyTrashOnExit(&self, aEmptyTrashOnExit: *mut bool) -> ::nserror::nsresult {
        ((*self.vtable).GetEmptyTrashOnExit)(self, aEmptyTrashOnExit)
    }



    /// `attribute boolean emptyTrashOnExit;`
    #[inline]
    pub unsafe fn SetEmptyTrashOnExit(&self, aEmptyTrashOnExit: bool) -> ::nserror::nsresult {
        ((*self.vtable).SetEmptyTrashOnExit)(self, aEmptyTrashOnExit)
    }


    /// ```text
    /// /**
    ///    * Get the server's list of filters.
    ///    *
    ///    * This SHOULD be the same filter list as the root folder's, if the server
    ///    * supports per-folder filters. Furthermore, this list SHOULD be used for all
    ///    * incoming messages.
    ///    *
    ///    * Since the returned nsIMsgFilterList is mutable, it is not necessary to call
    ///    * setFilterList after the filters have been changed.
    ///    *
    ///    * @param aMsgWindow  @ref msgwindow "The standard message window"
    ///    * @return            The list of filters.
    ///    */
    /// ```
    ///

    /// `nsIMsgFilterList getFilterList (in nsIMsgWindow aMsgWindow);`
    #[inline]
    pub unsafe fn GetFilterList(&self, aMsgWindow: *const nsIMsgWindow, _retval: *mut*const nsIMsgFilterList) -> ::nserror::nsresult {
        ((*self.vtable).GetFilterList)(self, aMsgWindow, _retval)
    }


    /// ```text
    /// /**
    ///    * Set the server's list of filters.
    ///    *
    ///    * Note that this does not persist the filter list. To change the contents
    ///    * of the existing filters, use getFilterList and mutate the values as
    ///    * appropriate.
    ///    *
    ///    * @param aFilterList The new list of filters.
    ///    */
    /// ```
    ///

    /// `void setFilterList (in nsIMsgFilterList aFilterList);`
    #[inline]
    pub unsafe fn SetFilterList(&self, aFilterList: *const nsIMsgFilterList) -> ::nserror::nsresult {
        ((*self.vtable).SetFilterList)(self, aFilterList)
    }


    /// ```text
    /// /**
    ///    * Get user editable filter list. This does not have to be the same as
    ///    * the filterlist above, typically depending on the users preferences.
    ///    * The filters in this list are not processed, but only to be edited by
    ///    * the user.
    ///    * @see getFilterList
    ///    *
    ///    * @param aMsgWindow  @ref msgwindow "The standard message window"
    ///    * @return            The list of filters.
    ///    */
    /// ```
    ///

    /// `nsIMsgFilterList getEditableFilterList (in nsIMsgWindow aMsgWindow);`
    #[inline]
    pub unsafe fn GetEditableFilterList(&self, aMsgWindow: *const nsIMsgWindow, _retval: *mut*const nsIMsgFilterList) -> ::nserror::nsresult {
        ((*self.vtable).GetEditableFilterList)(self, aMsgWindow, _retval)
    }


    /// ```text
    /// /**
    ///    * Set user editable filter list.
    ///    * This does not persist the filterlist, @see setFilterList
    ///    * @see getEditableFilterList
    ///    * @see setFilterList
    ///    *
    ///    * @param aFilterList The new list of filters.
    ///    */
    /// ```
    ///

    /// `void setEditableFilterList (in nsIMsgFilterList aFilterList);`
    #[inline]
    pub unsafe fn SetEditableFilterList(&self, aFilterList: *const nsIMsgFilterList) -> ::nserror::nsresult {
        ((*self.vtable).SetEditableFilterList)(self, aFilterList)
    }



    /// `void setDefaultLocalPath (in nsIFile aDefaultLocalPath);`
    #[inline]
    pub unsafe fn SetDefaultLocalPath(&self, aDefaultLocalPath: *const nsIFile) -> ::nserror::nsresult {
        ((*self.vtable).SetDefaultLocalPath)(self, aDefaultLocalPath)
    }


    /// ```text
    /// /**
    ///    * Verify that we can logon
    ///    *
    ///    * @param  aUrlListener - gets called back with success or failure.
    ///    * @param aMsgWindow         nsIMsgWindow to use for notification callbacks.
    ///    * @return - the url that we run.
    ///    */
    /// ```
    ///

    /// `nsIURI verifyLogon (in nsIUrlListener aUrlListener, in nsIMsgWindow aMsgWindow);`
    #[inline]
    pub unsafe fn VerifyLogon(&self, aUrlListener: *const nsIUrlListener, aMsgWindow: *const nsIMsgWindow, _retval: *mut*const nsIURI) -> ::nserror::nsresult {
        ((*self.vtable).VerifyLogon)(self, aUrlListener, aMsgWindow, _retval)
    }



    /// `void performBiff (in nsIMsgWindow aMsgWindow);`
    #[inline]
    pub unsafe fn PerformBiff(&self, aMsgWindow: *const nsIMsgWindow) -> ::nserror::nsresult {
        ((*self.vtable).PerformBiff)(self, aMsgWindow)
    }



    /// `void getNewMessages (in nsIMsgFolder aFolder, in nsIMsgWindow aMsgWindow, in nsIUrlListener aUrlListener);`
    #[inline]
    pub unsafe fn GetNewMessages(&self, aFolder: *const nsIMsgFolder, aMsgWindow: *const nsIMsgWindow, aUrlListener: *const nsIUrlListener) -> ::nserror::nsresult {
        ((*self.vtable).GetNewMessages)(self, aFolder, aMsgWindow, aUrlListener)
    }



    /// `readonly attribute boolean serverRequiresPasswordForBiff;`
    #[inline]
    pub unsafe fn GetServerRequiresPasswordForBiff(&self, aServerRequiresPasswordForBiff: *mut bool) -> ::nserror::nsresult {
        ((*self.vtable).GetServerRequiresPasswordForBiff)(self, aServerRequiresPasswordForBiff)
    }



    /// `void performExpand (in nsIMsgWindow aMsgWindow);`
    #[inline]
    pub unsafe fn PerformExpand(&self, aMsgWindow: *const nsIMsgWindow) -> ::nserror::nsresult {
        ((*self.vtable).PerformExpand)(self, aMsgWindow)
    }



    /// `void writeToFolderCache (in nsIMsgFolderCache folderCache);`
    #[inline]
    pub unsafe fn WriteToFolderCache(&self, folderCache: *const nsIMsgFolderCache) -> ::nserror::nsresult {
        ((*self.vtable).WriteToFolderCache)(self, folderCache)
    }



    /// `void closeCachedConnections ();`
    #[inline]
    pub unsafe fn CloseCachedConnections(&self, ) -> ::nserror::nsresult {
        ((*self.vtable).CloseCachedConnections)(self, )
    }



    /// `void shutdown ();`
    #[inline]
    pub unsafe fn Shutdown(&self, ) -> ::nserror::nsresult {
        ((*self.vtable).Shutdown)(self, )
    }


    /// ```text
    /// /**
    ///    * Get or set the value as determined by the preference tree.
    ///    *
    ///    * These methods MUST NOT fail if the preference is not set, and therefore
    ///    * they MUST have a default value. This default value is provided in practice
    ///    * by use of a default preference tree. The standard format for the pref
    ///    * branches are <tt>mail.server.<i>key</i>.</tt> for per-server preferences,
    ///    * such that the preference is <tt>mail.server.<i>key</i>.<i>attr</i></tt>.
    ///    *
    ///    * The attributes are passed in as strings for ease of access by the C++
    ///    * consumers of this method.
    ///    *
    ///    * @param attr  The value for which the preference should be accessed.
    ///    * @param value The value of the preference to set.
    ///    * @return      The value of the preference.
    ///    * @{
        ///    */
        /// ```
        ///

        /// `boolean getBoolValue (in string attr);`
        #[inline]
        pub unsafe fn GetBoolValue(&self, attr: *const libc::c_char, _retval: *mut bool) -> ::nserror::nsresult {
            ((*self.vtable).GetBoolValue)(self, attr, _retval)
        }



        /// `void setBoolValue (in string attr, in boolean value);`
        #[inline]
        pub unsafe fn SetBoolValue(&self, attr: *const libc::c_char, value: bool) -> ::nserror::nsresult {
            ((*self.vtable).SetBoolValue)(self, attr, value)
        }



        /// `AUTF8String getStringValue (in string attr);`
        #[inline]
        pub unsafe fn GetStringValue(&self, attr: *const libc::c_char, _retval: *mut ::nsstring::nsACString) -> ::nserror::nsresult {
            ((*self.vtable).GetStringValue)(self, attr, _retval)
        }



        /// `void setStringValue (in string attr, in AUTF8String value);`
        #[inline]
        pub unsafe fn SetStringValue(&self, attr: *const libc::c_char, value: *const ::nsstring::nsACString) -> ::nserror::nsresult {
            ((*self.vtable).SetStringValue)(self, attr, value)
        }



        /// `long getIntValue (in string attr);`
        #[inline]
        pub unsafe fn GetIntValue(&self, attr: *const libc::c_char, _retval: *mut i32) -> ::nserror::nsresult {
            ((*self.vtable).GetIntValue)(self, attr, _retval)
        }



        /// `void setIntValue (in string attr, in long value);`
        #[inline]
        pub unsafe fn SetIntValue(&self, attr: *const libc::c_char, value: i32) -> ::nserror::nsresult {
            ((*self.vtable).SetIntValue)(self, attr, value)
        }


        /// ```text
        /// /** @} */
    /// /**
    ///    * Get or set the value as determined by the preference tree.
    ///    *
    ///    * These methods MUST NOT fail if the preference is not set, and therefore
    ///    * they MUST have a default value. This default value is provided in practice
    ///    * by use of a default preference tree. The standard format for the pref
    ///    * branches are <tt>mail.server.<i>key</i>.</tt> for per-server preferences,
    ///    * such that the preference is <tt>mail.server.<i>key</i>.<i>attr</i></tt>.
    ///    *
    ///    * The attributes are passed in as strings for ease of access by the C++
    ///    * consumers of this method.
    ///    *
    ///    * There are two preference names on here for legacy reasons, where the first
    ///    * is the name which will be using a (preferred) relative preference and the
    ///    * second a deprecated absolute preference. Implementations that do not have
    ///    * to worry about supporting legacy preferences can safely ignore this second
    ///    * parameter. Callers must still provide a valid value, though.
    ///    *
    ///    * @param relpref The name of the relative file preference.
    ///    * @param absref  The name of the absolute file preference.
    ///    * @param aValue  The value of the preference to set.
    ///    * @return        The value of the preference.
    ///    * @{
        ///    */
        /// ```
        ///

        /// `nsIFile getFileValue (in string relpref, in string abspref);`
        #[inline]
        pub unsafe fn GetFileValue(&self, relpref: *const libc::c_char, abspref: *const libc::c_char, _retval: *mut*const nsIFile) -> ::nserror::nsresult {
            ((*self.vtable).GetFileValue)(self, relpref, abspref, _retval)
        }



        /// `void setFileValue (in string relpref, in string abspref, in nsIFile aValue);`
        #[inline]
        pub unsafe fn SetFileValue(&self, relpref: *const libc::c_char, abspref: *const libc::c_char, aValue: *const nsIFile) -> ::nserror::nsresult {
            ((*self.vtable).SetFileValue)(self, relpref, abspref, aValue)
        }


        /// ```text
        /// /** @} */
    /// /**
    ///    * this is really dangerous. this destroys all pref values
    ///    * do not call this unless you know what you're doing!
    ///    */
    /// ```
    ///

    /// `void clearAllValues ();`
    #[inline]
    pub unsafe fn ClearAllValues(&self, ) -> ::nserror::nsresult {
        ((*self.vtable).ClearAllValues)(self, )
    }


    /// ```text
    /// /**
    ///    * This is also very dangerous. This will low-level remove the files
    ///    * associated with this server on disk. It does not notify any listeners.
    ///    */
    /// ```
    ///

    /// `void removeFiles ();`
    #[inline]
    pub unsafe fn RemoveFiles(&self, ) -> ::nserror::nsresult {
        ((*self.vtable).RemoveFiles)(self, )
    }



    /// `attribute boolean valid;`
    #[inline]
    pub unsafe fn GetValid(&self, aValid: *mut bool) -> ::nserror::nsresult {
        ((*self.vtable).GetValid)(self, aValid)
    }



    /// `attribute boolean valid;`
    #[inline]
    pub unsafe fn SetValid(&self, aValid: bool) -> ::nserror::nsresult {
        ((*self.vtable).SetValid)(self, aValid)
    }



    /// `AString toString ();`
    #[inline]
    pub unsafe fn ToString(&self, _retval: *mut ::nsstring::nsAString) -> ::nserror::nsresult {
        ((*self.vtable).ToString)(self, _retval)
    }



    /// `boolean equals (in nsIMsgIncomingServer server);`
    #[inline]
    pub unsafe fn Equals(&self, server: *const nsIMsgIncomingServer, _retval: *mut bool) -> ::nserror::nsresult {
        ((*self.vtable).Equals)(self, server, _retval)
    }



    /// `readonly attribute boolean canHaveFilters;`
    #[inline]
    pub unsafe fn GetCanHaveFilters(&self, aCanHaveFilters: *mut bool) -> ::nserror::nsresult {
        ((*self.vtable).GetCanHaveFilters)(self, aCanHaveFilters)
    }



    /// `attribute boolean loginAtStartUp;`
    #[inline]
    pub unsafe fn GetLoginAtStartUp(&self, aLoginAtStartUp: *mut bool) -> ::nserror::nsresult {
        ((*self.vtable).GetLoginAtStartUp)(self, aLoginAtStartUp)
    }



    /// `attribute boolean loginAtStartUp;`
    #[inline]
    pub unsafe fn SetLoginAtStartUp(&self, aLoginAtStartUp: bool) -> ::nserror::nsresult {
        ((*self.vtable).SetLoginAtStartUp)(self, aLoginAtStartUp)
    }



    /// `attribute boolean limitOfflineMessageSize;`
    #[inline]
    pub unsafe fn GetLimitOfflineMessageSize(&self, aLimitOfflineMessageSize: *mut bool) -> ::nserror::nsresult {
        ((*self.vtable).GetLimitOfflineMessageSize)(self, aLimitOfflineMessageSize)
    }



    /// `attribute boolean limitOfflineMessageSize;`
    #[inline]
    pub unsafe fn SetLimitOfflineMessageSize(&self, aLimitOfflineMessageSize: bool) -> ::nserror::nsresult {
        ((*self.vtable).SetLimitOfflineMessageSize)(self, aLimitOfflineMessageSize)
    }



    /// `attribute long maxMessageSize;`
    #[inline]
    pub unsafe fn GetMaxMessageSize(&self, aMaxMessageSize: *mut i32) -> ::nserror::nsresult {
        ((*self.vtable).GetMaxMessageSize)(self, aMaxMessageSize)
    }



    /// `attribute long maxMessageSize;`
    #[inline]
    pub unsafe fn SetMaxMessageSize(&self, aMaxMessageSize: i32) -> ::nserror::nsresult {
        ((*self.vtable).SetMaxMessageSize)(self, aMaxMessageSize)
    }


    /// ```text
    /// /**
    ///    * Where offline downloads are supported, this determines
    ///    * if new folders are marked for offline use or not.
    ///    * Reflects the `offline_download` server pref.
    ///    */
    /// ```
    ///

    /// `attribute boolean offlineDownload;`
    #[inline]
    pub unsafe fn GetOfflineDownload(&self, aOfflineDownload: *mut bool) -> ::nserror::nsresult {
        ((*self.vtable).GetOfflineDownload)(self, aOfflineDownload)
    }


    /// ```text
    /// /**
    ///    * Where offline downloads are supported, this determines
    ///    * if new folders are marked for offline use or not.
    ///    * Reflects the `offline_download` server pref.
    ///    */
    /// ```
    ///

    /// `attribute boolean offlineDownload;`
    #[inline]
    pub unsafe fn SetOfflineDownload(&self, aOfflineDownload: bool) -> ::nserror::nsresult {
        ((*self.vtable).SetOfflineDownload)(self, aOfflineDownload)
    }


    /// ```text
    /// /**
    ///    * Where offline downloads and autosync are supported, this
    ///    * determines if this server will use autosync or not.
    ///    * Reflects the `autosync_offline_stores` server pref.
    ///    */
    /// ```
    ///

    /// `attribute boolean autoSyncOfflineStores;`
    #[inline]
    pub unsafe fn GetAutoSyncOfflineStores(&self, aAutoSyncOfflineStores: *mut bool) -> ::nserror::nsresult {
        ((*self.vtable).GetAutoSyncOfflineStores)(self, aAutoSyncOfflineStores)
    }


    /// ```text
    /// /**
    ///    * Where offline downloads and autosync are supported, this
    ///    * determines if this server will use autosync or not.
    ///    * Reflects the `autosync_offline_stores` server pref.
    ///    */
    /// ```
    ///

    /// `attribute boolean autoSyncOfflineStores;`
    #[inline]
    pub unsafe fn SetAutoSyncOfflineStores(&self, aAutoSyncOfflineStores: bool) -> ::nserror::nsresult {
        ((*self.vtable).SetAutoSyncOfflineStores)(self, aAutoSyncOfflineStores)
    }


    /// ```text
    /// /**
    ///    * Where autosync is being used, this is the maximum age of
    ///    * messages to download for offline use.
    ///    * -1 = no limit.
    ///    * Reflects the `autosync_max_age_days` server pref.
    ///    */
    /// ```
    ///

    /// `attribute long autoSyncMaxAgeDays;`
    #[inline]
    pub unsafe fn GetAutoSyncMaxAgeDays(&self, aAutoSyncMaxAgeDays: *mut i32) -> ::nserror::nsresult {
        ((*self.vtable).GetAutoSyncMaxAgeDays)(self, aAutoSyncMaxAgeDays)
    }


    /// ```text
    /// /**
    ///    * Where autosync is being used, this is the maximum age of
    ///    * messages to download for offline use.
    ///    * -1 = no limit.
    ///    * Reflects the `autosync_max_age_days` server pref.
    ///    */
    /// ```
    ///

    /// `attribute long autoSyncMaxAgeDays;`
    #[inline]
    pub unsafe fn SetAutoSyncMaxAgeDays(&self, aAutoSyncMaxAgeDays: i32) -> ::nserror::nsresult {
        ((*self.vtable).SetAutoSyncMaxAgeDays)(self, aAutoSyncMaxAgeDays)
    }



    /// `attribute nsIMsgRetentionSettings retentionSettings;`
    #[inline]
    pub unsafe fn GetRetentionSettings(&self, aRetentionSettings: *mut*const nsIMsgRetentionSettings) -> ::nserror::nsresult {
        ((*self.vtable).GetRetentionSettings)(self, aRetentionSettings)
    }



    /// `attribute nsIMsgRetentionSettings retentionSettings;`
    #[inline]
    pub unsafe fn SetRetentionSettings(&self, aRetentionSettings: *const nsIMsgRetentionSettings) -> ::nserror::nsresult {
        ((*self.vtable).SetRetentionSettings)(self, aRetentionSettings)
    }



    /// `readonly attribute boolean canBeDefaultServer;`
    #[inline]
    pub unsafe fn GetCanBeDefaultServer(&self, aCanBeDefaultServer: *mut bool) -> ::nserror::nsresult {
        ((*self.vtable).GetCanBeDefaultServer)(self, aCanBeDefaultServer)
    }



    /// `readonly attribute boolean canSearchMessages;`
    #[inline]
    pub unsafe fn GetCanSearchMessages(&self, aCanSearchMessages: *mut bool) -> ::nserror::nsresult {
        ((*self.vtable).GetCanSearchMessages)(self, aCanSearchMessages)
    }


    /// ```text
    /// /**
    ///    * Settings for NNTP downloads.
    ///    */
    /// ```
    ///

    /// `attribute nsIMsgDownloadSettings downloadSettings;`
    #[inline]
    pub unsafe fn GetDownloadSettings(&self, aDownloadSettings: *mut*const nsIMsgDownloadSettings) -> ::nserror::nsresult {
        ((*self.vtable).GetDownloadSettings)(self, aDownloadSettings)
    }


    /// ```text
    /// /**
    ///    * Settings for NNTP downloads.
    ///    */
    /// ```
    ///

    /// `attribute nsIMsgDownloadSettings downloadSettings;`
    #[inline]
    pub unsafe fn SetDownloadSettings(&self, aDownloadSettings: *const nsIMsgDownloadSettings) -> ::nserror::nsresult {
        ((*self.vtable).SetDownloadSettings)(self, aDownloadSettings)
    }



    /// `readonly attribute long offlineSupportLevel;`
    #[inline]
    pub unsafe fn GetOfflineSupportLevel(&self, aOfflineSupportLevel: *mut i32) -> ::nserror::nsresult {
        ((*self.vtable).GetOfflineSupportLevel)(self, aOfflineSupportLevel)
    }


    /// ```text
    /// /**
    ///    * Hide this server/account from the UI - used for smart mailboxes.
    ///    * The server can be retrieved from the account manager by name using the
    ///    * various Find methods, but nsIMsgAccountManager's GetAccounts and
    ///    * GetAllServers methods won't return the server/account.
    ///    */
    /// ```
    ///

    /// `attribute boolean hidden;`
    #[inline]
    pub unsafe fn GetHidden(&self, aHidden: *mut bool) -> ::nserror::nsresult {
        ((*self.vtable).GetHidden)(self, aHidden)
    }


    /// ```text
    /// /**
    ///    * Hide this server/account from the UI - used for smart mailboxes.
    ///    * The server can be retrieved from the account manager by name using the
    ///    * various Find methods, but nsIMsgAccountManager's GetAccounts and
    ///    * GetAllServers methods won't return the server/account.
    ///    */
    /// ```
    ///

    /// `attribute boolean hidden;`
    #[inline]
    pub unsafe fn SetHidden(&self, aHidden: bool) -> ::nserror::nsresult {
        ((*self.vtable).SetHidden)(self, aHidden)
    }


    /// ```text
    /// /**
    ///    * If the server supports Fcc/Sent/etc, default prefs can point to
    ///    * the server. Otherwise, copies and folders prefs should point to
    ///    * Local Folders.
    ///    *
    ///    * By default this value is set to true via global pref 'allows_specialfolders_usage'
    ///    * (mailnews.js). For Nntp, the value is overridden to be false.
    ///    * If ISPs want to modify this value, they should do that in their rdf file
    ///    * by using this attribute. Please look at mozilla/mailnews/base/ispdata/aol.rdf for
    ///    * usage example.
    ///    */
    /// ```
    ///

    /// `attribute boolean defaultCopiesAndFoldersPrefsToServer;`
    #[inline]
    pub unsafe fn GetDefaultCopiesAndFoldersPrefsToServer(&self, aDefaultCopiesAndFoldersPrefsToServer: *mut bool) -> ::nserror::nsresult {
        ((*self.vtable).GetDefaultCopiesAndFoldersPrefsToServer)(self, aDefaultCopiesAndFoldersPrefsToServer)
    }


    /// ```text
    /// /**
    ///    * If the server supports Fcc/Sent/etc, default prefs can point to
    ///    * the server. Otherwise, copies and folders prefs should point to
    ///    * Local Folders.
    ///    *
    ///    * By default this value is set to true via global pref 'allows_specialfolders_usage'
    ///    * (mailnews.js). For Nntp, the value is overridden to be false.
    ///    * If ISPs want to modify this value, they should do that in their rdf file
    ///    * by using this attribute. Please look at mozilla/mailnews/base/ispdata/aol.rdf for
    ///    * usage example.
    ///    */
    /// ```
    ///

    /// `attribute boolean defaultCopiesAndFoldersPrefsToServer;`
    #[inline]
    pub unsafe fn SetDefaultCopiesAndFoldersPrefsToServer(&self, aDefaultCopiesAndFoldersPrefsToServer: bool) -> ::nserror::nsresult {
        ((*self.vtable).SetDefaultCopiesAndFoldersPrefsToServer)(self, aDefaultCopiesAndFoldersPrefsToServer)
    }



    /// `attribute boolean canCreateFoldersOnServer;`
    #[inline]
    pub unsafe fn GetCanCreateFoldersOnServer(&self, aCanCreateFoldersOnServer: *mut bool) -> ::nserror::nsresult {
        ((*self.vtable).GetCanCreateFoldersOnServer)(self, aCanCreateFoldersOnServer)
    }



    /// `attribute boolean canCreateFoldersOnServer;`
    #[inline]
    pub unsafe fn SetCanCreateFoldersOnServer(&self, aCanCreateFoldersOnServer: bool) -> ::nserror::nsresult {
        ((*self.vtable).SetCanCreateFoldersOnServer)(self, aCanCreateFoldersOnServer)
    }



    /// `attribute boolean canFileMessagesOnServer;`
    #[inline]
    pub unsafe fn GetCanFileMessagesOnServer(&self, aCanFileMessagesOnServer: *mut bool) -> ::nserror::nsresult {
        ((*self.vtable).GetCanFileMessagesOnServer)(self, aCanFileMessagesOnServer)
    }



    /// `attribute boolean canFileMessagesOnServer;`
    #[inline]
    pub unsafe fn SetCanFileMessagesOnServer(&self, aCanFileMessagesOnServer: bool) -> ::nserror::nsresult {
        ((*self.vtable).SetCanFileMessagesOnServer)(self, aCanFileMessagesOnServer)
    }



    /// `readonly attribute nsMsgSearchScopeValue filterScope;`
    #[inline]
    pub unsafe fn GetFilterScope(&self, aFilterScope: *mut nsMsgSearchScopeValue) -> ::nserror::nsresult {
        ((*self.vtable).GetFilterScope)(self, aFilterScope)
    }



    /// `readonly attribute nsMsgSearchScopeValue searchScope;`
    #[inline]
    pub unsafe fn GetSearchScope(&self, aSearchScope: *mut nsMsgSearchScopeValue) -> ::nserror::nsresult {
        ((*self.vtable).GetSearchScope)(self, aSearchScope)
    }


    /// ```text
    /// /**
    ///    * If the password for the server is available either via authentication
    ///    * in the current session or from password manager stored entries, return
    ///    * false. Otherwise, return true. If password is obtained from password
    ///    * manager, set the password member variable.
    ///    */
    /// ```
    ///

    /// `readonly attribute boolean passwordPromptRequired;`
    #[inline]
    pub unsafe fn GetPasswordPromptRequired(&self, aPasswordPromptRequired: *mut bool) -> ::nserror::nsresult {
        ((*self.vtable).GetPasswordPromptRequired)(self, aPasswordPromptRequired)
    }


    /// ```text
    /// /**
    ///    * for mail, this configures both the MDN filter, and the server-side
    ///    * spam filter filters, if needed.
    ///    *
    ///    * If we have set up to filter return receipts into
    ///    * our Sent folder, this utility method creates
    ///    * a filter to do that, and adds it to our filterList
    ///    * if it doesn't exist.  If it does, it will enable it.
    ///    *
    ///    * this is not used by news filters (yet).
    ///    */
    /// ```
    ///

    /// `void configureTemporaryFilters (in nsIMsgFilterList filterList);`
    #[inline]
    pub unsafe fn ConfigureTemporaryFilters(&self, filterList: *const nsIMsgFilterList) -> ::nserror::nsresult {
        ((*self.vtable).ConfigureTemporaryFilters)(self, filterList)
    }


    /// ```text
    /// /**
    ///    * If Sent folder pref is changed we need to clear the temporary
    ///    * return receipt filter so that the new return receipt filter can
    ///    * be recreated (by ConfigureTemporaryReturnReceiptsFilter()).
    ///    */
    /// ```
    ///

    /// `void clearTemporaryReturnReceiptsFilter ();`
    #[inline]
    pub unsafe fn ClearTemporaryReturnReceiptsFilter(&self, ) -> ::nserror::nsresult {
        ((*self.vtable).ClearTemporaryReturnReceiptsFilter)(self, )
    }


    /// ```text
    /// /**
    ///    * spam settings
    ///    */
    /// ```
    ///

    /// `readonly attribute nsISpamSettings spamSettings;`
    #[inline]
    pub unsafe fn GetSpamSettings(&self, aSpamSettings: *mut*const nsISpamSettings) -> ::nserror::nsresult {
        ((*self.vtable).GetSpamSettings)(self, aSpamSettings)
    }



    /// `readonly attribute nsIMsgFilterPlugin spamFilterPlugin;`
    #[inline]
    pub unsafe fn GetSpamFilterPlugin(&self, aSpamFilterPlugin: *mut*const nsIMsgFilterPlugin) -> ::nserror::nsresult {
        ((*self.vtable).GetSpamFilterPlugin)(self, aSpamFilterPlugin)
    }



    /// `nsIMsgFolder getMsgFolderFromURI (in nsIMsgFolder aFolderResource, in AUTF8String aURI);`
    #[inline]
    pub unsafe fn GetMsgFolderFromURI(&self, aFolderResource: *const nsIMsgFolder, aURI: *const ::nsstring::nsACString, _retval: *mut*const nsIMsgFolder) -> ::nserror::nsresult {
        ((*self.vtable).GetMsgFolderFromURI)(self, aFolderResource, aURI, _retval)
    }



    /// `readonly attribute boolean isDeferredTo;`
    #[inline]
    pub unsafe fn GetIsDeferredTo(&self, aIsDeferredTo: *mut bool) -> ::nserror::nsresult {
        ((*self.vtable).GetIsDeferredTo)(self, aIsDeferredTo)
    }



    /// `attribute long incomingDuplicateAction;`
    #[inline]
    pub unsafe fn GetIncomingDuplicateAction(&self, aIncomingDuplicateAction: *mut i32) -> ::nserror::nsresult {
        ((*self.vtable).GetIncomingDuplicateAction)(self, aIncomingDuplicateAction)
    }



    /// `attribute long incomingDuplicateAction;`
    #[inline]
    pub unsafe fn SetIncomingDuplicateAction(&self, aIncomingDuplicateAction: i32) -> ::nserror::nsresult {
        ((*self.vtable).SetIncomingDuplicateAction)(self, aIncomingDuplicateAction)
    }



    /// `boolean isNewHdrDuplicate (in nsIMsgDBHdr aNewHdr);`
    #[inline]
    pub unsafe fn IsNewHdrDuplicate(&self, aNewHdr: *const nsIMsgDBHdr, _retval: *mut bool) -> ::nserror::nsresult {
        ((*self.vtable).IsNewHdrDuplicate)(self, aNewHdr, _retval)
    }


}


