// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_GleanJsXpconnectMetrics_h
#define mozilla_GleanJsXpconnectMetrics_h

#include "mozilla/glean/bindings/MetricTypes.h"

namespace mozilla::glean {

namespace javascript_gc {
  /**
   * generated from javascript.gc.animation
   * Time spent running JS GC when animating.
   */
  constexpr impl::TimingDistributionMetric animation(4088);

  /**
   * generated from javascript.gc.budget
   * Requested GC slice budget.
   */
  constexpr impl::TimingDistributionMetric budget(4089);

  /**
   * generated from javascript.gc.budget_overrun
   * How long a GC slice ran over its budget.
   */
  constexpr impl::TimingDistributionMetric budget_overrun(4090);

  /**
   * generated from javascript.gc.budget_was_increased
   */
  enum class BudgetWasIncreasedLabel: uint16_t {
    eFalse = 0,
    eTrue = 1,
    e__Other__,
  };
  /**
   * Whether the budget was increased due to taking too long or approaching the incremental limit
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, BudgetWasIncreasedLabel> budget_was_increased(4091);

  /**
   * generated from javascript.gc.compact_time
   * The time spent in the compact phase. (Migrated from the geckoview metric of the same name.)
   */
  constexpr impl::TimingDistributionMetric compact_time(4092);

  /**
   * generated from javascript.gc.effectiveness
   * GC effectiveness, the amount of memory freed divided by main-thread collection time (MB/s)
   */
  constexpr impl::CustomDistributionMetric effectiveness(4093);

  /**
   * generated from javascript.gc.is_zone_gc
   */
  enum class IsZoneGcLabel: uint16_t {
    eFalse = 0,
    eTrue = 1,
    e__Other__,
  };
  /**
   * Is it a zone GC?
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, IsZoneGcLabel> is_zone_gc(4094);

  /**
   * generated from javascript.gc.mark_gray
   * Time spent marking gray GC objects.
   */
  constexpr impl::TimingDistributionMetric mark_gray(4095);

  /**
   * generated from javascript.gc.mark_rate
   * The number of objects marked per ms during GC.
   */
  constexpr impl::CustomDistributionMetric mark_rate(4096);

  /**
   * generated from javascript.gc.mark_roots_time
   * The time spent marking GC roots. (Migrated from the geckoview metric of the same name.)
   */
  constexpr impl::TimingDistributionMetric mark_roots_time(4097);

  /**
   * generated from javascript.gc.mark_time
   * The time spent in the mark phase. (Migrated from the geckoview metric of the same name.)
   */
  constexpr impl::TimingDistributionMetric mark_time(4098);

  /**
   * generated from javascript.gc.mark_weak
   * Time spent marking GC objects held live through weakmaps.
   */
  constexpr impl::TimingDistributionMetric mark_weak(4099);

  /**
   * generated from javascript.gc.max_pause
   * Longest GC slice in a GC.
   */
  constexpr impl::TimingDistributionMetric max_pause(4100);

  /**
   * generated from javascript.gc.minor_reason
   */
  enum class MinorReasonLabel: uint16_t {
    eApi = 0,
    eEagerAllocTrigger = 1,
    eDestroyRuntime = 2,
    eRootsRemoved = 3,
    eLastDitch = 4,
    eTooMuchMalloc = 5,
    eAllocTrigger = 6,
    eDebugGc = 7,
    eCompartmentRevived = 8,
    eReset = 9,
    eOutOfNursery = 10,
    eEvictNursery = 11,
    eFullCellPtrGetterSetterBuffer = 12,
    eSharedMemoryLimit = 13,
    eEagerNurseryCollection = 14,
    eBgTaskFinished = 15,
    eAbortGc = 16,
    eFullWholeCellBuffer = 17,
    eFullGenericBuffer = 18,
    eFullValueBuffer = 19,
    eFullCellPtrObjBuffer = 20,
    eFullSlotBuffer = 21,
    eFullShapeBuffer = 22,
    eTooMuchWasmMemory = 23,
    eDisableGenerationalGc = 24,
    eFinishGc = 25,
    ePrepareForTracing = 26,
    eFullWasmAnyrefBuffer = 27,
    eFullCellPtrStrBuffer = 28,
    eTooMuchJitCode = 29,
    eFullCellPtrBigintBuffer = 30,
    eNurseryTrailers = 31,
    eNurseryMallocBuffers = 32,
    eDomWindowUtils = 33,
    eComponentUtils = 34,
    eMemPressure = 35,
    eCcFinished = 36,
    eCcForced = 37,
    eLoadEnd = 38,
    eUnused3 = 39,
    ePageHide = 40,
    eNsjscontextDestroy = 41,
    eWorkerShutdown = 42,
    eSetDocShell = 43,
    eDomUtils = 44,
    eDomIpc = 45,
    eDomWorker = 46,
    eInterSliceGc = 47,
    eUnused1 = 48,
    eFullGcTimer = 49,
    eShutdownCc = 50,
    eUnused2 = 51,
    eUserInactive = 52,
    eXpconnectShutdown = 53,
    eDocshell = 54,
    eHtmlParser = 55,
    eDomTestutils = 56,
    ePrepareForPageload = 57,
    e__Other__,
  };
  /**
   * Reason (enum value) for initiating a minor GC
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, MinorReasonLabel> minor_reason(4101);

  /**
   * generated from javascript.gc.minor_reason_long
   */
  enum class MinorReasonLongLabel: uint16_t {
    eApi = 0,
    eEagerAllocTrigger = 1,
    eDestroyRuntime = 2,
    eRootsRemoved = 3,
    eLastDitch = 4,
    eTooMuchMalloc = 5,
    eAllocTrigger = 6,
    eDebugGc = 7,
    eCompartmentRevived = 8,
    eReset = 9,
    eOutOfNursery = 10,
    eEvictNursery = 11,
    eFullCellPtrGetterSetterBuffer = 12,
    eSharedMemoryLimit = 13,
    eEagerNurseryCollection = 14,
    eBgTaskFinished = 15,
    eAbortGc = 16,
    eFullWholeCellBuffer = 17,
    eFullGenericBuffer = 18,
    eFullValueBuffer = 19,
    eFullCellPtrObjBuffer = 20,
    eFullSlotBuffer = 21,
    eFullShapeBuffer = 22,
    eTooMuchWasmMemory = 23,
    eDisableGenerationalGc = 24,
    eFinishGc = 25,
    ePrepareForTracing = 26,
    eFullWasmAnyrefBuffer = 27,
    eFullCellPtrStrBuffer = 28,
    eTooMuchJitCode = 29,
    eFullCellPtrBigintBuffer = 30,
    eNurseryTrailers = 31,
    eNurseryMallocBuffers = 32,
    eDomWindowUtils = 33,
    eComponentUtils = 34,
    eMemPressure = 35,
    eCcFinished = 36,
    eCcForced = 37,
    eLoadEnd = 38,
    eUnused3 = 39,
    ePageHide = 40,
    eNsjscontextDestroy = 41,
    eWorkerShutdown = 42,
    eSetDocShell = 43,
    eDomUtils = 44,
    eDomIpc = 45,
    eDomWorker = 46,
    eInterSliceGc = 47,
    eUnused1 = 48,
    eFullGcTimer = 49,
    eShutdownCc = 50,
    eUnused2 = 51,
    eUserInactive = 52,
    eXpconnectShutdown = 53,
    eDocshell = 54,
    eHtmlParser = 55,
    eDomTestutils = 56,
    ePrepareForPageload = 57,
    e__Other__,
  };
  /**
   * Reason (enum value) that caused a long (>1ms) minor GC
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, MinorReasonLongLabel> minor_reason_long(4102);

  /**
   * generated from javascript.gc.minor_time
   * The time taked by a minor (nursery) collection. (Migrated from the geckoview metric of the same name.)
   */
  constexpr impl::TimingDistributionMetric minor_time(4103);

  /**
   * generated from javascript.gc.mmu_50
   * Minimum percentage of time spent outside GC over any 50ms window.
   */
  constexpr impl::CustomDistributionMetric mmu_50(4104);

  /**
   * generated from javascript.gc.non_incremental
   */
  enum class NonIncrementalLabel: uint16_t {
    eFalse = 0,
    eTrue = 1,
    e__Other__,
  };
  /**
   * Was the GC non-incremental?
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, NonIncrementalLabel> non_incremental(4105);

  /**
   * generated from javascript.gc.non_incremental_reason
   */
  enum class NonIncrementalReasonLabel: uint16_t {
    eNone = 0,
    eNonincrementalrequested = 1,
    eAbortrequested = 2,
    eUnused1 = 3,
    eIncrementaldisabled = 4,
    eModechange = 5,
    eMallocbytestrigger = 6,
    eGcbytestrigger = 7,
    eZonechange = 8,
    eCompartmentrevived = 9,
    eGrayrootbufferingfailed = 10,
    eJitcodebytestrigger = 11,
    e__Other__,
  };
  /**
   * Reason for performing a non-incremental GC (see js::GCAbortReason)
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, NonIncrementalReasonLabel> non_incremental_reason(4106);

  /**
   * generated from javascript.gc.nursery_bytes
   * Size of the GC nursery in bytes.
   */
  constexpr impl::MemoryDistributionMetric nursery_bytes(4107);

  /**
   * generated from javascript.gc.nursery_promotion_rate
   * The percentage of nursery objects that were promoted to the tenured heap.
   */
  constexpr impl::CustomDistributionMetric nursery_promotion_rate(4108);

  /**
   * generated from javascript.gc.parallel_mark_interruptions
   * Number of interruptions/donations per slice during parallel marking.
   */
  constexpr impl::CustomDistributionMetric parallel_mark_interruptions(4109);

  /**
   * generated from javascript.gc.parallel_mark_speedup
   * Ratio of total helper thread time spent marking to main thread time for parallel marking, scaled by 100.
   */
  constexpr impl::CustomDistributionMetric parallel_mark_speedup(4110);

  /**
   * generated from javascript.gc.parallel_mark_used
   */
  enum class ParallelMarkUsedLabel: uint16_t {
    eFalse = 0,
    eTrue = 1,
    e__Other__,
  };
  /**
   * Whether parallel marking was used for this collection
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, ParallelMarkUsedLabel> parallel_mark_used(4111);

  /**
   * generated from javascript.gc.parallel_mark_utilization
   * Ratio of helper thread time spent marking to total helper thread time for parallel marking.
   */
  constexpr impl::CustomDistributionMetric parallel_mark_utilization(4112);

  /**
   * generated from javascript.gc.prepare_time
   * The time spent in the preparation phase. (Migrated from the geckoview metric of the same name.)
   */
  constexpr impl::TimingDistributionMetric prepare_time(4113);

  /**
   * generated from javascript.gc.pretenure_count
   * How many allocation sites were selected for pretenuring by a minor GC
   */
  constexpr impl::CustomDistributionMetric pretenure_count(4114);

  /**
   * generated from javascript.gc.reason
   */
  enum class ReasonLabel: uint16_t {
    eApi = 0,
    eEagerAllocTrigger = 1,
    eDestroyRuntime = 2,
    eRootsRemoved = 3,
    eLastDitch = 4,
    eTooMuchMalloc = 5,
    eAllocTrigger = 6,
    eDebugGc = 7,
    eCompartmentRevived = 8,
    eReset = 9,
    eOutOfNursery = 10,
    eEvictNursery = 11,
    eFullCellPtrGetterSetterBuffer = 12,
    eSharedMemoryLimit = 13,
    eEagerNurseryCollection = 14,
    eBgTaskFinished = 15,
    eAbortGc = 16,
    eFullWholeCellBuffer = 17,
    eFullGenericBuffer = 18,
    eFullValueBuffer = 19,
    eFullCellPtrObjBuffer = 20,
    eFullSlotBuffer = 21,
    eFullShapeBuffer = 22,
    eTooMuchWasmMemory = 23,
    eDisableGenerationalGc = 24,
    eFinishGc = 25,
    ePrepareForTracing = 26,
    eFullWasmAnyrefBuffer = 27,
    eFullCellPtrStrBuffer = 28,
    eTooMuchJitCode = 29,
    eFullCellPtrBigintBuffer = 30,
    eNurseryTrailers = 31,
    eNurseryMallocBuffers = 32,
    eDomWindowUtils = 33,
    eComponentUtils = 34,
    eMemPressure = 35,
    eCcFinished = 36,
    eCcForced = 37,
    eLoadEnd = 38,
    eUnused3 = 39,
    ePageHide = 40,
    eNsjscontextDestroy = 41,
    eWorkerShutdown = 42,
    eSetDocShell = 43,
    eDomUtils = 44,
    eDomIpc = 45,
    eDomWorker = 46,
    eInterSliceGc = 47,
    eUnused1 = 48,
    eFullGcTimer = 49,
    eShutdownCc = 50,
    eUnused2 = 51,
    eUserInactive = 52,
    eXpconnectShutdown = 53,
    eDocshell = 54,
    eHtmlParser = 55,
    eDomTestutils = 56,
    ePrepareForPageload = 57,
    e__Other__,
  };
  /**
   * Reason (enum value) for initiating a GC
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, ReasonLabel> reason(4115);

  /**
   * generated from javascript.gc.reset
   */
  enum class ResetLabel: uint16_t {
    eFalse = 0,
    eTrue = 1,
    e__Other__,
  };
  /**
   * Was an incremental GC canceled?
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, ResetLabel> reset(4116);

  /**
   * generated from javascript.gc.reset_reason
   */
  enum class ResetReasonLabel: uint16_t {
    eNone = 0,
    eNonincrementalrequested = 1,
    eAbortrequested = 2,
    eUnused1 = 3,
    eIncrementaldisabled = 4,
    eModechange = 5,
    eMallocbytestrigger = 6,
    eGcbytestrigger = 7,
    eZonechange = 8,
    eCompartmentrevived = 9,
    eGrayrootbufferingfailed = 10,
    eJitcodebytestrigger = 11,
    e__Other__,
  };
  /**
   * Reason for cancelling an ongoing GC (see js::GCAbortReason)
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, ResetReasonLabel> reset_reason(4117);

  /**
   * generated from javascript.gc.slice_count
   * The number of slices in an incremental GC for the main runtime.
   */
  constexpr impl::CustomDistributionMetric slice_count(4118);

  /**
   * generated from javascript.gc.slice_time
   * The time spent running a GC slice. (Migrated from the geckoview metric of the same name.)
   */
  constexpr impl::TimingDistributionMetric slice_time(4119);

  /**
   * generated from javascript.gc.slice_was_long
   */
  enum class SliceWasLongLabel: uint16_t {
    eFalse = 0,
    eTrue = 1,
    e__Other__,
  };
  /**
   * Whether a GC slice took 1.5 times or 5ms more than its budget
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, SliceWasLongLabel> slice_was_long(4120);

  /**
   * generated from javascript.gc.slow_phase
   */
  enum class SlowPhaseLabel: uint16_t {
    eMutator = 0,
    eGcBegin = 1,
    eMarkCcws = 2,
    eMarkStack = 3,
    eMarkRuntimeData = 4,
    eMarkEmbedding = 5,
    eMarkRoots = 6,
    eEvictNurseryForMajorGc = 7,
    eWaitBackgroundThread = 8,
    eUnmark = 9,
    eUnmarkWeakmaps = 10,
    eMarkDiscardCode = 11,
    eRelazifyFunctions = 12,
    ePurge = 13,
    ePurgePropMapTables = 14,
    ePurgeSourceUrls = 15,
    eJoinParallelTasks = 16,
    ePrepare = 17,
    eMarkDelayed = 18,
    eMarkGrayWeak = 19,
    eMarkWeak = 20,
    eMarkIncomingGray = 21,
    eMarkGray = 22,
    eParallelMarkMark = 23,
    eParallelMarkWait = 24,
    eParallelMarkOther = 25,
    eParallelMark = 26,
    eMark = 27,
    eWeakZonesCallback = 28,
    eWeakCompartmentCallback = 29,
    eFinalizeStart = 30,
    eUpdateAtomsBitmap = 31,
    eSweepAtomsTable = 32,
    eSweepJitScripts = 33,
    eSweepInnerViews = 34,
    eSweepCcWrapper = 35,
    eSweepBaseShape = 36,
    eSweepInitialShape = 37,
    eSweepRegexp = 38,
    eSweepCompression = 39,
    eSweepWeakmaps = 40,
    eSweepUniqueids = 41,
    eSweepWeakPointers = 42,
    eSweepFinalizationObservers = 43,
    eSweepJitData = 44,
    eSweepWeakCaches = 45,
    eSweepMisc = 46,
    eSweepCompartments = 47,
    eSweepPropMap = 48,
    eFinalizeEnd = 49,
    eDestroy = 50,
    eFindDeadCompartments = 51,
    eSweep = 52,
    eCompactMove = 53,
    eCompactUpdateCells = 54,
    eCompactUpdate = 55,
    eCompact = 56,
    eDecommit = 57,
    eGcEnd = 58,
    eMinorGc = 59,
    eEvictNursery = 60,
    eTraceHeap = 61,
    e__Other__,
  };
  /**
   * The longest phase in any slice that goes over 2x the budget. The phase values are defined in js/src/gc/GenerateStatsPhases.py.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, SlowPhaseLabel> slow_phase(4121);

  /**
   * generated from javascript.gc.slow_task
   */
  enum class SlowTaskLabel: uint16_t {
    eMutator = 0,
    eGcBegin = 1,
    eMarkCcws = 2,
    eMarkStack = 3,
    eMarkRuntimeData = 4,
    eMarkEmbedding = 5,
    eMarkRoots = 6,
    eEvictNurseryForMajorGc = 7,
    eWaitBackgroundThread = 8,
    eUnmark = 9,
    eUnmarkWeakmaps = 10,
    eMarkDiscardCode = 11,
    eRelazifyFunctions = 12,
    ePurge = 13,
    ePurgePropMapTables = 14,
    ePurgeSourceUrls = 15,
    eJoinParallelTasks = 16,
    ePrepare = 17,
    eMarkDelayed = 18,
    eMarkGrayWeak = 19,
    eMarkWeak = 20,
    eMarkIncomingGray = 21,
    eMarkGray = 22,
    eParallelMarkMark = 23,
    eParallelMarkWait = 24,
    eParallelMarkOther = 25,
    eParallelMark = 26,
    eMark = 27,
    eWeakZonesCallback = 28,
    eWeakCompartmentCallback = 29,
    eFinalizeStart = 30,
    eUpdateAtomsBitmap = 31,
    eSweepAtomsTable = 32,
    eSweepJitScripts = 33,
    eSweepInnerViews = 34,
    eSweepCcWrapper = 35,
    eSweepBaseShape = 36,
    eSweepInitialShape = 37,
    eSweepRegexp = 38,
    eSweepCompression = 39,
    eSweepWeakmaps = 40,
    eSweepUniqueids = 41,
    eSweepWeakPointers = 42,
    eSweepFinalizationObservers = 43,
    eSweepJitData = 44,
    eSweepWeakCaches = 45,
    eSweepMisc = 46,
    eSweepCompartments = 47,
    eSweepPropMap = 48,
    eFinalizeEnd = 49,
    eDestroy = 50,
    eFindDeadCompartments = 51,
    eSweep = 52,
    eCompactMove = 53,
    eCompactUpdateCells = 54,
    eCompactUpdate = 55,
    eCompact = 56,
    eDecommit = 57,
    eGcEnd = 58,
    eMinorGc = 59,
    eEvictNursery = 60,
    eTraceHeap = 61,
    e__Other__,
  };
  /**
   * The longest parallel task in any slice that goes over 2x the budget. The phase values are defined in js/src/gc/GenerateStatsPhases.py.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, SlowTaskLabel> slow_task(4122);

  /**
   * generated from javascript.gc.sweep_time
   * The time spent in the sweep phase. (Migrated from the geckoview metric of the same name.)
   */
  constexpr impl::TimingDistributionMetric sweep_time(4123);

  /**
   * generated from javascript.gc.task_start_delay
   * Delay between queuing a GC task and the task starting.
   */
  constexpr impl::TimingDistributionMetric task_start_delay(4124);

  /**
   * generated from javascript.gc.tenured_survival_rate
   * The percentage of tenured GC things that survived a collection.
   */
  constexpr impl::CustomDistributionMetric tenured_survival_rate(4125);

  /**
   * generated from javascript.gc.time_between
   * Time spent in between garbage collections for the main runtime.
   */
  constexpr impl::TimingDistributionMetric time_between(4126);

  /**
   * generated from javascript.gc.time_between_minor
   * Time between minor garbage collections (nursery collections) for all runtimes.
   */
  constexpr impl::TimingDistributionMetric time_between_minor(4127);

  /**
   * generated from javascript.gc.time_between_slices
   * Time spent in between garbage collections for the main runtime.
   */
  constexpr impl::TimingDistributionMetric time_between_slices(4128);

  /**
   * generated from javascript.gc.total_time
   * The total time taken by a major collection. (Migrated from the geckoview metric of the same name.)
   */
  constexpr impl::TimingDistributionMetric total_time(4129);

  /**
   * generated from javascript.gc.zone_count
   * Total number of GC zones
   */
  constexpr impl::CustomDistributionMetric zone_count(4130);

  /**
   * generated from javascript.gc.zones_collected
   * Number of zones collected in a zone GC.
   */
  constexpr impl::CustomDistributionMetric zones_collected(4131);
}

namespace javascript_ion {
  /**
   * generated from javascript.ion.compile_time
   * Time in microseconds of an Ion compilation.
   */
  constexpr impl::TimingDistributionMetric compile_time(4132);
}

namespace script_preloader {
  /**
   * generated from script.preloader.mainthread_recompile
   * How many times we ended up recompiling a script from the script preloader on the main thread. This metric was generated to correspond to the Legacy Telemetry scalar script.preloader.mainthread_recompile.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> mainthread_recompile(4133);

  /**
   * generated from script.preloader.requests
   */
  enum class RequestsLabel: uint16_t {
    eHit = 0,
    eHitchild = 1,
    eMiss = 2,
    e__Other__,
  };
  /**
   * Record hits and misses to the script preloader, with categories.
   * This metric was generated to correspond to the Legacy Telemetry categorical histogram SCRIPT_PRELOADER_REQUESTS.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, RequestsLabel> requests(4134);

  /**
   * generated from script.preloader.wait_time
   * Time spent waiting for off-thread compiles in the script preloader.
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram SCRIPT_PRELOADER_WAIT_TIME.
   */
  constexpr impl::TimingDistributionMetric wait_time(4135);
}

namespace slow_script_warning {
  /**
   * generated from slow_script_warning.notify_delay
   * The difference between the js slow script timeout for content set in prefs and the actual time we waited before displaying the notification (msec).
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram SLOW_SCRIPT_NOTIFY_DELAY.
   */
  constexpr impl::TimingDistributionMetric notify_delay(4136);

  /**
   * generated from slow_script_warning.shown_browser
   */
  struct ShownBrowserExtra {
    mozilla::Maybe<nsCString> hangDuration;
    mozilla::Maybe<nsCString> uriType;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (hangDuration) {
        extraKeys.AppendElement()->AssignASCII("hang_duration");
        extraValues.EmplaceBack(hangDuration.value());
      }
      if (uriType) {
        extraKeys.AppendElement()->AssignASCII("uri_type");
        extraValues.EmplaceBack(uriType.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when a slow script hang is resolved. This event was generated to correspond to the Legacy Telemetry event slow_script_warning.shown#browser.
   */
  constexpr impl::EventMetric<ShownBrowserExtra> shown_browser(4137);

  /**
   * generated from slow_script_warning.shown_content
   */
  struct ShownContentExtra {
    mozilla::Maybe<nsCString> endReason;
    mozilla::Maybe<nsCString> hangDuration;
    mozilla::Maybe<uint32_t> nTabDeselect;
    mozilla::Maybe<nsCString> uptime;
    mozilla::Maybe<nsCString> uriType;
    mozilla::Maybe<uint32_t> waitCount;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (endReason) {
        extraKeys.AppendElement()->AssignASCII("end_reason");
        extraValues.EmplaceBack(endReason.value());
      }
      if (hangDuration) {
        extraKeys.AppendElement()->AssignASCII("hang_duration");
        extraValues.EmplaceBack(hangDuration.value());
      }
      if (nTabDeselect) {
        extraKeys.AppendElement()->AssignASCII("n_tab_deselect");
        extraValues.AppendElement()->AppendInt(nTabDeselect.value());
      }
      if (uptime) {
        extraKeys.AppendElement()->AssignASCII("uptime");
        extraValues.EmplaceBack(uptime.value());
      }
      if (uriType) {
        extraKeys.AppendElement()->AssignASCII("uri_type");
        extraValues.EmplaceBack(uriType.value());
      }
      if (waitCount) {
        extraKeys.AppendElement()->AssignASCII("wait_count");
        extraValues.AppendElement()->AppendInt(waitCount.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when a slow script hang is resolved. This event was generated to correspond to the Legacy Telemetry event slow_script_warning.shown#content.
   */
  constexpr impl::EventMetric<ShownContentExtra> shown_content(4138);
}

} // namespace mozilla::glean

#endif // mozilla_GleanJsXpconnectMetrics_h
