const char strict_lua[] =
"-- strict.lua\n"
"-- checks uses of undeclared global variables\n"
"-- All global variables must be 'declared' through a regular assignment\n"
"-- (even assigning nil will do) in a main chunk before being used\n"
"-- anywhere or assigned to inside a function.\n"
"--\n"
"\n"
"local getinfo, error, rawset, rawget = debug.getinfo, error, rawset, rawget\n"
"\n"
"local mt = {}\n"
"\n"
"mt.__declared = {}\n"
"\n"
"local function what ()\n"
"  local d = getinfo(3, \"S\")\n"
"  return d and d.what or \"C\"\n"
"end\n"
"\n"
"mt.__newindex = function (t, n, v)\n"
"  if not mt.__declared[n] then\n"
"    local w = what()\n"
"    if w ~= \"main\" and w ~= \"C\" then\n"
"      error(\"assign to undeclared variable '\"..n..\"'\", 2)\n"
"    end\n"
"    mt.__declared[n] = true\n"
"  end\n"
"  rawset(t, n, v)\n"
"end\n"
"\n"
"mt.__index = function (t, n)\n"
"  if not mt.__declared[n] and what() ~= \"C\" then\n"
"    error(\"variable '\"..n..\"' is not declared\", 2)\n"
"  end\n"
"  return rawget(t, n)\n"
"end\n"
"\n"
"local function off()\n"
"    mt.__declared = {}\n"
"    local m = getmetatable(_G)\n"
"    if m == nil then\n"
"        return\n"
"    end\n"
"    if m == mt then\n"
"        setmetatable(_G, nil)\n"
"    else\n"
"        m.__newindex = nil\n"
"        m.__index = nil\n"
"    end\n"
"end\n"
"\n"
"local function on()\n"
"    local m = getmetatable(_G)\n"
"    if  m == mt then\n"
"        return\n"
"    end\n"
"    if m == nil then\n"
"        setmetatable(_G, mt)\n"
"    else\n"
"        m.__newindex = mt.__newindex\n"
"        m.__index = mt.__index\n"
"    end\n"
"end\n"
"\n"
"on()\n"
"\n"
"return {\n"
"    on = on,\n"
"    off = off,\n"
"}\n"
""
;
