/* DeviceManagerX11.c generated by valac 0.56.18, the Vala compiler
 * generated from DeviceManagerX11.vala, do not modify */

/*
 * Copyright (c) 2019 elementary, Inc. (https://elementary.io)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301 USA.
 */

#include "wacom.h"
#include <gee.h>
#include <glib-object.h>
#include <gdk/gdk.h>
#include <glib.h>
#include <gdk/x11/gdkx.h>
#include <stdlib.h>
#include <string.h>
#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include <X11/Xutil.h>
#include <X11/Xregion.h>
#include <X11/extensions/XInput2.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	WACOM_BACKEND_DEVICE_MANAGER_X11_0_PROPERTY,
	WACOM_BACKEND_DEVICE_MANAGER_X11_NUM_PROPERTIES
};
static GParamSpec* wacom_backend_device_manager_x11_properties[WACOM_BACKEND_DEVICE_MANAGER_X11_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _WacomBackendDeviceManagerX11Private {
	GeeHashMap* devices;
};

static gint WacomBackendDeviceManagerX11_private_offset;
static gpointer wacom_backend_device_manager_x11_parent_class = NULL;

static void wacom_backend_device_manager_x11_add_device (WacomBackendDeviceManagerX11* self,
                                                  GdkDevice* gdk_device);
static void _wacom_backend_device_manager_x11_add_device_gdk_seat_device_added (GdkSeat* _sender,
                                                                         GdkDevice* device,
                                                                         gpointer self);
static void wacom_backend_device_manager_x11_remove_device (WacomBackendDeviceManagerX11* self,
                                                     GdkDevice* gdk_device);
static void _wacom_backend_device_manager_x11_remove_device_gdk_seat_device_removed (GdkSeat* _sender,
                                                                              GdkDevice* device,
                                                                              gpointer self);
static gchar* wacom_backend_device_manager_x11_get_xdevice_node (gint id);
static WacomBackendDevice* wacom_backend_device_manager_x11_create_device (GdkDevice* gdk_device,
                                                                    const gchar* device_file);
static WacomBackendDeviceDeviceType wacom_backend_device_manager_x11_get_device_type (GdkDevice* device);
static GeeArrayList* wacom_backend_device_manager_x11_real_list_devices (WacomBackendDeviceManager* base,
                                                                  WacomBackendDeviceDeviceType type);
static WacomBackendDevice* wacom_backend_device_manager_x11_real_lookup_gdk_device (WacomBackendDeviceManager* base,
                                                                             GdkDevice* device);
static void wacom_backend_device_manager_x11_finalize (GObject * obj);
static GType wacom_backend_device_manager_x11_get_type_once (void);

static inline gpointer
wacom_backend_device_manager_x11_get_instance_private (WacomBackendDeviceManagerX11* self)
{
	return G_STRUCT_MEMBER_P (self, WacomBackendDeviceManagerX11_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_wacom_backend_device_manager_x11_add_device_gdk_seat_device_added (GdkSeat* _sender,
                                                                    GdkDevice* device,
                                                                    gpointer self)
{
	wacom_backend_device_manager_x11_add_device ((WacomBackendDeviceManagerX11*) self, device);
}

static void
_wacom_backend_device_manager_x11_remove_device_gdk_seat_device_removed (GdkSeat* _sender,
                                                                         GdkDevice* device,
                                                                         gpointer self)
{
	wacom_backend_device_manager_x11_remove_device ((WacomBackendDeviceManagerX11*) self, device);
}

WacomBackendDeviceManagerX11*
wacom_backend_device_manager_x11_construct (GType object_type)
{
	WacomBackendDeviceManagerX11 * self = NULL;
	GeeHashMap* _tmp0_;
	GdkSeat* seat = NULL;
	GdkDisplay* _tmp1_;
	GdkSeat* _tmp2_;
	GdkSeat* _tmp3_;
	GdkSeat* _tmp4_;
	GdkSeat* _tmp5_;
	GList* devices = NULL;
	GdkSeat* _tmp6_;
	GList* _tmp7_;
	GList* _tmp8_;
	self = (WacomBackendDeviceManagerX11*) wacom_backend_device_manager_construct (object_type);
	_tmp0_ = gee_hash_map_new (gdk_device_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, WACOM_BACKEND_TYPE_DEVICE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->devices);
	self->priv->devices = _tmp0_;
	_tmp1_ = gdk_display_get_default ();
	_tmp2_ = gdk_display_get_default_seat (_tmp1_);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	seat = _tmp3_;
	_tmp4_ = seat;
	g_signal_connect_object (_tmp4_, "device-added", (GCallback) _wacom_backend_device_manager_x11_add_device_gdk_seat_device_added, self, 0);
	_tmp5_ = seat;
	g_signal_connect_object (_tmp5_, "device-removed", (GCallback) _wacom_backend_device_manager_x11_remove_device_gdk_seat_device_removed, self, 0);
	_tmp6_ = seat;
	_tmp7_ = gdk_seat_get_devices (_tmp6_, GDK_SEAT_CAPABILITY_ALL);
	devices = _tmp7_;
	_tmp8_ = devices;
	{
		GList* device_collection = NULL;
		GList* device_it = NULL;
		device_collection = _tmp8_;
		for (device_it = device_collection; device_it != NULL; device_it = device_it->next) {
			GdkDevice* device = NULL;
			device = (GdkDevice*) device_it->data;
			{
				GdkDevice* _tmp9_;
				_tmp9_ = device;
				wacom_backend_device_manager_x11_add_device (self, _tmp9_);
			}
		}
	}
	(devices == NULL) ? NULL : (devices = (g_list_free (devices), NULL));
	_g_object_unref0 (seat);
	return self;
}

WacomBackendDeviceManagerX11*
wacom_backend_device_manager_x11_new (void)
{
	return wacom_backend_device_manager_x11_construct (WACOM_BACKEND_TYPE_DEVICE_MANAGER_X11);
}

static void
wacom_backend_device_manager_x11_add_device (WacomBackendDeviceManagerX11* self,
                                             GdkDevice* gdk_device)
{
	gint id = 0;
	gchar* device_file = NULL;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	WacomBackendDevice* device = NULL;
	GeeHashMap* _tmp4_;
	gpointer _tmp5_;
	WacomBackendDevice* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (gdk_device != NULL);
	id = -1;
	if (G_TYPE_CHECK_INSTANCE_TYPE (gdk_device, gdk_x11_device_xi2_get_type ())) {
		gint _tmp0_;
		gint _tmp1_;
		g_object_get (G_TYPE_CHECK_INSTANCE_CAST (gdk_device, gdk_x11_device_xi2_get_type (), GdkX11DeviceXI2), "device-id", &_tmp0_, NULL);
		_tmp1_ = _tmp0_;
		id = _tmp1_;
	}
	if (id == -1) {
		return;
	}
	_tmp2_ = wacom_backend_device_manager_x11_get_xdevice_node (id);
	device_file = _tmp2_;
	_tmp3_ = device_file;
	if (_tmp3_ == NULL) {
		_g_free0 (device_file);
		return;
	}
	_tmp4_ = self->priv->devices;
	_tmp5_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp4_, gdk_device);
	device = (WacomBackendDevice*) _tmp5_;
	_tmp6_ = device;
	if (_tmp6_ != NULL) {
		WacomBackendDevice* _tmp7_;
		_tmp7_ = device;
		g_signal_emit_by_name ((WacomBackendDeviceManager*) self, "device-changed", _tmp7_);
	} else {
		const gchar* _tmp8_;
		WacomBackendDevice* _tmp9_;
		GeeHashMap* _tmp10_;
		WacomBackendDevice* _tmp11_;
		WacomBackendDevice* _tmp12_;
		_tmp8_ = device_file;
		_tmp9_ = wacom_backend_device_manager_x11_create_device (gdk_device, _tmp8_);
		_g_object_unref0 (device);
		device = _tmp9_;
		_tmp10_ = self->priv->devices;
		_tmp11_ = device;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp10_, gdk_device, _tmp11_);
		_tmp12_ = device;
		g_signal_emit_by_name ((WacomBackendDeviceManager*) self, "device-added", _tmp12_);
	}
	_g_object_unref0 (device);
	_g_free0 (device_file);
}

static WacomBackendDevice*
wacom_backend_device_manager_x11_create_device (GdkDevice* gdk_device,
                                                const gchar* device_file)
{
	WacomBackendDevice* device = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	WacomBackendDevice* _tmp5_ = NULL;
	WacomBackendDevice* result;
	g_return_val_if_fail (gdk_device != NULL, NULL);
	g_return_val_if_fail (device_file != NULL, NULL);
	_tmp0_ = g_strdup (device_file);
	_tmp1_ = gdk_device_get_vendor_id (gdk_device);
	_tmp2_ = g_strdup (_tmp1_);
	_tmp3_ = gdk_device_get_product_id (gdk_device);
	_tmp4_ = g_strdup (_tmp3_);
	_tmp5_ = wacom_backend_device_new ();
	wacom_backend_device_set_device_file (_tmp5_, _tmp0_);
	_g_free0 (_tmp0_);
	wacom_backend_device_set_vendor_id (_tmp5_, _tmp2_);
	_g_free0 (_tmp2_);
	wacom_backend_device_set_product_id (_tmp5_, _tmp4_);
	_g_free0 (_tmp4_);
	wacom_backend_device_set_dev_type (_tmp5_, wacom_backend_device_manager_x11_get_device_type (gdk_device));
	device = _tmp5_;
	result = device;
	return result;
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static WacomBackendDeviceDeviceType
wacom_backend_device_manager_x11_get_device_type (GdkDevice* device)
{
	GdkInputSource source = 0;
	WacomBackendDeviceDeviceType result;
	g_return_val_if_fail (device != NULL, 0U);
	source = gdk_device_get_source (device);
	switch (source) {
		case GDK_SOURCE_MOUSE:
		case GDK_SOURCE_TRACKPOINT:
		{
			result = WACOM_BACKEND_DEVICE_DEVICE_TYPE_MOUSE;
			return result;
		}
		case GDK_SOURCE_PEN:
		{
			const gchar* _tmp0_;
			const gchar* _tmp1_;
			_tmp0_ = gdk_device_get_name (device);
			_tmp1_ = _tmp0_;
			if (string_contains (_tmp1_, "pad")) {
				result = WACOM_BACKEND_DEVICE_DEVICE_TYPE_TABLET | WACOM_BACKEND_DEVICE_DEVICE_TYPE_PAD;
				return result;
			}
			result = WACOM_BACKEND_DEVICE_DEVICE_TYPE_TABLET;
			return result;
		}
		case GDK_SOURCE_KEYBOARD:
		{
			result = WACOM_BACKEND_DEVICE_DEVICE_TYPE_KEYBOARD;
			return result;
		}
		case GDK_SOURCE_TOUCHSCREEN:
		{
			result = WACOM_BACKEND_DEVICE_DEVICE_TYPE_TOUCHSCREEN;
			return result;
		}
		case GDK_SOURCE_TOUCHPAD:
		{
			result = WACOM_BACKEND_DEVICE_DEVICE_TYPE_TOUCHPAD;
			return result;
		}
		case GDK_SOURCE_TABLET_PAD:
		{
			result = WACOM_BACKEND_DEVICE_DEVICE_TYPE_TABLET | WACOM_BACKEND_DEVICE_DEVICE_TYPE_PAD;
			return result;
		}
		default:
		{
			result = 0;
			return result;
		}
	}
}

static void
wacom_backend_device_manager_x11_remove_device (WacomBackendDeviceManagerX11* self,
                                                GdkDevice* gdk_device)
{
	WacomBackendDevice* device = NULL;
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
	WacomBackendDevice* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (gdk_device != NULL);
	_tmp0_ = self->priv->devices;
	_tmp1_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, gdk_device);
	device = (WacomBackendDevice*) _tmp1_;
	_tmp2_ = device;
	if (_tmp2_ != NULL) {
		WacomBackendDevice* _tmp3_;
		GeeHashMap* _tmp4_;
		_tmp3_ = device;
		g_signal_emit_by_name ((WacomBackendDeviceManager*) self, "device-removed", _tmp3_);
		_tmp4_ = self->priv->devices;
		gee_abstract_map_unset ((GeeAbstractMap*) _tmp4_, gdk_device, NULL);
	}
	_g_object_unref0 (device);
}

static gchar*
wacom_backend_device_manager_x11_get_xdevice_node (gint id)
{
	GdkDisplay* _tmp0_;
	GdkX11Display* display = NULL;
	GdkDisplay* _tmp1_;
	Atom prop = {0};
	GdkX11Display* _tmp2_;
	Atom act_type = {0};
	gint act_format = 0;
	gulong n_items = 0UL;
	gulong bytes_after = 0UL;
	void* data = NULL;
	GdkX11Display* _tmp3_;
	gint ret = 0;
	GdkX11Display* _tmp4_;
	Display* _tmp5_;
	Atom _tmp6_ = {0};
	gint _tmp7_ = 0;
	gulong _tmp8_ = 0UL;
	gulong _tmp9_ = 0UL;
	void* _tmp10_ = NULL;
	gint _tmp11_;
	GdkX11Display* _tmp13_;
	void* _tmp14_;
	gchar* _tmp15_;
	gchar* result;
	_tmp0_ = gdk_display_get_default ();
	gdk_display_sync (_tmp0_);
	_tmp1_ = gdk_display_get_default ();
	display = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gdk_x11_display_get_type (), GdkX11Display);
	_tmp2_ = display;
	prop = gdk_x11_get_xatom_by_name_for_display (_tmp2_, "Device Node");
	_tmp3_ = display;
	gdk_x11_display_error_trap_push (_tmp3_);
	_tmp4_ = display;
	_tmp5_ = gdk_x11_display_get_xdisplay (_tmp4_);
	_tmp11_ = XIGetProperty (_tmp5_, id, prop, (glong) 0, (glong) 1000, FALSE, (Atom) AnyPropertyType, &_tmp6_, &_tmp7_, &_tmp8_, &_tmp9_, (unsigned char **) (&_tmp10_));
	act_type = _tmp6_;
	act_format = _tmp7_;
	n_items = _tmp8_;
	bytes_after = _tmp9_;
	data = _tmp10_;
	ret = _tmp11_;
	if (ret != Success) {
		GdkX11Display* _tmp12_;
		_tmp12_ = display;
		gdk_x11_display_error_trap_pop_ignored (_tmp12_);
		result = NULL;
		return result;
	}
	_tmp13_ = display;
	if (gdk_x11_display_error_trap_pop (_tmp13_) != 0) {
		result = NULL;
		return result;
	}
	if (n_items == ((gulong) 0)) {
		result = NULL;
		return result;
	}
	if (act_type != XA_STRING) {
		result = NULL;
		return result;
	}
	if (act_format != 8) {
		result = NULL;
		return result;
	}
	_tmp14_ = data;
	_tmp15_ = g_strdup ((const gchar*) _tmp14_);
	result = _tmp15_;
	return result;
}

static GeeArrayList*
wacom_backend_device_manager_x11_real_list_devices (WacomBackendDeviceManager* base,
                                                    WacomBackendDeviceDeviceType type)
{
	WacomBackendDeviceManagerX11 * self;
	GeeArrayList* _result_ = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* result;
	self = (WacomBackendDeviceManagerX11*) base;
	_tmp0_ = gee_array_list_new (WACOM_BACKEND_TYPE_DEVICE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_result_ = _tmp0_;
	{
		GeeIterator* _device_it = NULL;
		GeeHashMap* _tmp1_;
		GeeCollection* _tmp2_;
		GeeCollection* _tmp3_;
		GeeCollection* _tmp4_;
		GeeIterator* _tmp5_;
		GeeIterator* _tmp6_;
		_tmp1_ = self->priv->devices;
		_tmp2_ = gee_abstract_map_get_values ((GeeAbstractMap*) _tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = _tmp3_;
		_tmp5_ = gee_iterable_iterator ((GeeIterable*) _tmp4_);
		_tmp6_ = _tmp5_;
		_g_object_unref0 (_tmp4_);
		_device_it = _tmp6_;
		while (TRUE) {
			GeeIterator* _tmp7_;
			WacomBackendDevice* device = NULL;
			GeeIterator* _tmp8_;
			gpointer _tmp9_;
			WacomBackendDevice* _tmp10_;
			WacomBackendDeviceDeviceType _tmp11_;
			WacomBackendDeviceDeviceType _tmp12_;
			_tmp7_ = _device_it;
			if (!gee_iterator_next (_tmp7_)) {
				break;
			}
			_tmp8_ = _device_it;
			_tmp9_ = gee_iterator_get (_tmp8_);
			device = (WacomBackendDevice*) _tmp9_;
			_tmp10_ = device;
			_tmp11_ = wacom_backend_device_get_dev_type (_tmp10_);
			_tmp12_ = _tmp11_;
			if ((_tmp12_ & type) == type) {
				GeeArrayList* _tmp13_;
				WacomBackendDevice* _tmp14_;
				_tmp13_ = _result_;
				_tmp14_ = device;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp13_, _tmp14_);
			}
			_g_object_unref0 (device);
		}
		_g_object_unref0 (_device_it);
	}
	result = _result_;
	return result;
}

static WacomBackendDevice*
wacom_backend_device_manager_x11_real_lookup_gdk_device (WacomBackendDeviceManager* base,
                                                         GdkDevice* device)
{
	WacomBackendDeviceManagerX11 * self;
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
	WacomBackendDevice* result;
	self = (WacomBackendDeviceManagerX11*) base;
	g_return_val_if_fail (device != NULL, NULL);
	_tmp0_ = self->priv->devices;
	_tmp1_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, device);
	result = (WacomBackendDevice*) _tmp1_;
	return result;
}

GdkDeviceToolType
wacom_backend_device_manager_x11_get_tool_type (GdkDevice* device)
{
	GdkDeviceToolType tool_type = 0;
	Atom act_type = {0};
	gint act_format = 0;
	gulong n_items = 0UL;
	gulong bytes_after = 0UL;
	void* data = NULL;
	gint id = 0;
	GdkX11Display* display = NULL;
	GdkDisplay* _tmp2_;
	GdkX11Display* _tmp3_;
	GdkX11Display* _tmp4_;
	gint ret = 0;
	GdkX11Display* _tmp5_;
	Display* _tmp6_;
	GdkX11Display* _tmp7_;
	Atom _tmp8_ = {0};
	gint _tmp9_ = 0;
	gulong _tmp10_ = 0UL;
	gulong _tmp11_ = 0UL;
	void* _tmp12_ = NULL;
	gint _tmp13_;
	GdkX11Display* _tmp14_;
	gboolean _tmp15_ = FALSE;
	gboolean _tmp16_ = FALSE;
	Atom device_type = {0};
	void* _tmp17_;
	gchar* name = NULL;
	GdkX11Display* _tmp18_;
	Display* _tmp19_;
	gchar* _tmp20_;
	const gchar* _tmp21_;
	GdkDeviceToolType result;
	g_return_val_if_fail (device != NULL, 0);
	tool_type = GDK_DEVICE_TOOL_TYPE_UNKNOWN;
	id = -1;
	if (G_TYPE_CHECK_INSTANCE_TYPE (device, gdk_x11_device_xi2_get_type ())) {
		gint _tmp0_;
		gint _tmp1_;
		g_object_get (G_TYPE_CHECK_INSTANCE_CAST (device, gdk_x11_device_xi2_get_type (), GdkX11DeviceXI2), "device-id", &_tmp0_, NULL);
		_tmp1_ = _tmp0_;
		id = _tmp1_;
	}
	_tmp2_ = gdk_device_get_display (device);
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, gdk_x11_display_get_type ()) ? ((GdkX11Display*) _tmp2_) : NULL);
	display = _tmp3_;
	_tmp4_ = display;
	gdk_x11_display_error_trap_push (_tmp4_);
	_tmp5_ = display;
	_tmp6_ = gdk_x11_display_get_xdisplay (_tmp5_);
	_tmp7_ = display;
	_tmp13_ = XIGetProperty (_tmp6_, id, gdk_x11_get_xatom_by_name_for_display (_tmp7_, "Wacom Tool Type"), (glong) 0, (glong) 1, FALSE, XA_ATOM, &_tmp8_, &_tmp9_, &_tmp10_, &_tmp11_, (unsigned char **) (&_tmp12_));
	act_type = _tmp8_;
	act_format = _tmp9_;
	n_items = _tmp10_;
	bytes_after = _tmp11_;
	data = _tmp12_;
	ret = _tmp13_;
	_tmp14_ = display;
	gdk_x11_display_error_trap_pop_ignored (_tmp14_);
	if (ret != Success) {
		result = tool_type;
		_g_object_unref0 (display);
		return result;
	}
	if (act_type != XA_ATOM) {
		_tmp16_ = TRUE;
	} else {
		_tmp16_ = act_format != 32;
	}
	if (_tmp16_) {
		_tmp15_ = TRUE;
	} else {
		_tmp15_ = n_items != ((gulong) 1);
	}
	if (_tmp15_) {
		result = tool_type;
		_g_object_unref0 (display);
		return result;
	}
	_tmp17_ = data;
	device_type = *((Atom*) _tmp17_);
	if (device_type == ((Atom) 0)) {
		result = tool_type;
		_g_object_unref0 (display);
		return result;
	}
	_tmp18_ = display;
	_tmp19_ = gdk_x11_display_get_xdisplay (_tmp18_);
	_tmp20_ = XGetAtomName (_tmp19_, device_type);
	name = _tmp20_;
	_tmp21_ = name;
	if (g_strcmp0 (_tmp21_, "STYLUS") == 0) {
		tool_type = GDK_DEVICE_TOOL_TYPE_PEN;
	} else {
		const gchar* _tmp22_;
		_tmp22_ = name;
		if (g_strcmp0 (_tmp22_, "CURSOR") == 0) {
			tool_type = GDK_DEVICE_TOOL_TYPE_MOUSE;
		} else {
			const gchar* _tmp23_;
			_tmp23_ = name;
			if (g_strcmp0 (_tmp23_, "ERASER") == 0) {
				tool_type = GDK_DEVICE_TOOL_TYPE_ERASER;
			}
		}
	}
	result = tool_type;
	_g_free0 (name);
	_g_object_unref0 (display);
	return result;
}

static void
wacom_backend_device_manager_x11_class_init (WacomBackendDeviceManagerX11Class * klass,
                                             gpointer klass_data)
{
	wacom_backend_device_manager_x11_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &WacomBackendDeviceManagerX11_private_offset);
	((WacomBackendDeviceManagerClass *) klass)->list_devices = (GeeArrayList* (*) (WacomBackendDeviceManager*, WacomBackendDeviceDeviceType)) wacom_backend_device_manager_x11_real_list_devices;
	((WacomBackendDeviceManagerClass *) klass)->lookup_gdk_device = (WacomBackendDevice* (*) (WacomBackendDeviceManager*, GdkDevice*)) wacom_backend_device_manager_x11_real_lookup_gdk_device;
	G_OBJECT_CLASS (klass)->finalize = wacom_backend_device_manager_x11_finalize;
}

static void
wacom_backend_device_manager_x11_instance_init (WacomBackendDeviceManagerX11 * self,
                                                gpointer klass)
{
	self->priv = wacom_backend_device_manager_x11_get_instance_private (self);
	self->priv->devices = NULL;
}

static void
wacom_backend_device_manager_x11_finalize (GObject * obj)
{
	WacomBackendDeviceManagerX11 * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, WACOM_BACKEND_TYPE_DEVICE_MANAGER_X11, WacomBackendDeviceManagerX11);
	_g_object_unref0 (self->priv->devices);
	G_OBJECT_CLASS (wacom_backend_device_manager_x11_parent_class)->finalize (obj);
}

static GType
wacom_backend_device_manager_x11_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (WacomBackendDeviceManagerX11Class), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) wacom_backend_device_manager_x11_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (WacomBackendDeviceManagerX11), 0, (GInstanceInitFunc) wacom_backend_device_manager_x11_instance_init, NULL };
	GType wacom_backend_device_manager_x11_type_id;
	wacom_backend_device_manager_x11_type_id = g_type_register_static (WACOM_BACKEND_TYPE_DEVICE_MANAGER, "WacomBackendDeviceManagerX11", &g_define_type_info, 0);
	WacomBackendDeviceManagerX11_private_offset = g_type_add_instance_private (wacom_backend_device_manager_x11_type_id, sizeof (WacomBackendDeviceManagerX11Private));
	return wacom_backend_device_manager_x11_type_id;
}

GType
wacom_backend_device_manager_x11_get_type (void)
{
	static volatile gsize wacom_backend_device_manager_x11_type_id__once = 0;
	if (g_once_init_enter (&wacom_backend_device_manager_x11_type_id__once)) {
		GType wacom_backend_device_manager_x11_type_id;
		wacom_backend_device_manager_x11_type_id = wacom_backend_device_manager_x11_get_type_once ();
		g_once_init_leave (&wacom_backend_device_manager_x11_type_id__once, wacom_backend_device_manager_x11_type_id);
	}
	return wacom_backend_device_manager_x11_type_id__once;
}

