/* LocaleSetting.c generated by valac 0.56.18, the Vala compiler
 * generated from LocaleSetting.vala, do not modify */

/* Copyright 2011-2018 elementary LLC. (https://elementary.io)
*
* This program is free software: you can redistribute it
* and/or modify it under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation, either version 3 of the
* License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
* Public License for more details.
*
* You should have received a copy of the GNU General Public License along
* with this program. If not, see http://www.gnu.org/licenses/.
*/

#include "io.elementary.settings.locale.h"
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <libgnome-desktop/gnome-languages.h>
#include <switchboard.h>
#include <granite-7.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	SWITCHBOARD_PLUG_LOCALE_WIDGETS_LOCALE_SETTING_0_PROPERTY,
	SWITCHBOARD_PLUG_LOCALE_WIDGETS_LOCALE_SETTING_NUM_PROPERTIES
};
static GParamSpec* switchboard_plug_locale_widgets_locale_setting_properties[SWITCHBOARD_PLUG_LOCALE_WIDGETS_LOCALE_SETTING_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define SWITCHBOARD_PLUG_LOCALE_WIDGETS_LOCALE_SETTING_TYPE_LOCALE (switchboard_plug_locale_widgets_locale_setting_locale_get_type ())
#define SWITCHBOARD_PLUG_LOCALE_WIDGETS_LOCALE_SETTING_LOCALE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SWITCHBOARD_PLUG_LOCALE_WIDGETS_LOCALE_SETTING_TYPE_LOCALE, SwitchboardPlugLocaleWidgetsLocaleSettingLocale))
#define SWITCHBOARD_PLUG_LOCALE_WIDGETS_LOCALE_SETTING_LOCALE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SWITCHBOARD_PLUG_LOCALE_WIDGETS_LOCALE_SETTING_TYPE_LOCALE, SwitchboardPlugLocaleWidgetsLocaleSettingLocaleClass))
#define SWITCHBOARD_PLUG_LOCALE_WIDGETS_LOCALE_SETTING_IS_LOCALE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SWITCHBOARD_PLUG_LOCALE_WIDGETS_LOCALE_SETTING_TYPE_LOCALE))
#define SWITCHBOARD_PLUG_LOCALE_WIDGETS_LOCALE_SETTING_IS_LOCALE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SWITCHBOARD_PLUG_LOCALE_WIDGETS_LOCALE_SETTING_TYPE_LOCALE))
#define SWITCHBOARD_PLUG_LOCALE_WIDGETS_LOCALE_SETTING_LOCALE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SWITCHBOARD_PLUG_LOCALE_WIDGETS_LOCALE_SETTING_TYPE_LOCALE, SwitchboardPlugLocaleWidgetsLocaleSettingLocaleClass))

typedef struct _SwitchboardPlugLocaleWidgetsLocaleSettingLocale SwitchboardPlugLocaleWidgetsLocaleSettingLocale;
typedef struct _SwitchboardPlugLocaleWidgetsLocaleSettingLocaleClass SwitchboardPlugLocaleWidgetsLocaleSettingLocaleClass;
typedef struct _SwitchboardPlugLocaleWidgetsLocaleSettingReloadLocalesData SwitchboardPlugLocaleWidgetsLocaleSettingReloadLocalesData;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _SwitchboardPlugLocaleWidgetsLocaleSettingLocalePrivate SwitchboardPlugLocaleWidgetsLocaleSettingLocalePrivate;
enum  {
	SWITCHBOARD_PLUG_LOCALE_WIDGETS_LOCALE_SETTING_LOCALE_0_PROPERTY,
	SWITCHBOARD_PLUG_LOCALE_WIDGETS_LOCALE_SETTING_LOCALE_NAME_PROPERTY,
	SWITCHBOARD_PLUG_LOCALE_WIDGETS_LOCALE_SETTING_LOCALE_LOCALE_PROPERTY,
	SWITCHBOARD_PLUG_LOCALE_WIDGETS_LOCALE_SETTING_LOCALE_NUM_PROPERTIES
};
static GParamSpec* switchboard_plug_locale_widgets_locale_setting_locale_properties[SWITCHBOARD_PLUG_LOCALE_WIDGETS_LOCALE_SETTING_LOCALE_NUM_PROPERTIES];

#define SWITCHBOARD_PLUG_LOCALE_WIDGETS_LOCALE_SETTING_TYPE_LINK_ROW (switchboard_plug_locale_widgets_locale_setting_link_row_get_type ())
#define SWITCHBOARD_PLUG_LOCALE_WIDGETS_LOCALE_SETTING_LINK_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SWITCHBOARD_PLUG_LOCALE_WIDGETS_LOCALE_SETTING_TYPE_LINK_ROW, SwitchboardPlugLocaleWidgetsLocaleSettingLinkRow))
#define SWITCHBOARD_PLUG_LOCALE_WIDGETS_LOCALE_SETTING_LINK_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SWITCHBOARD_PLUG_LOCALE_WIDGETS_LOCALE_SETTING_TYPE_LINK_ROW, SwitchboardPlugLocaleWidgetsLocaleSettingLinkRowClass))
#define SWITCHBOARD_PLUG_LOCALE_WIDGETS_LOCALE_SETTING_IS_LINK_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SWITCHBOARD_PLUG_LOCALE_WIDGETS_LOCALE_SETTING_TYPE_LINK_ROW))
#define SWITCHBOARD_PLUG_LOCALE_WIDGETS_LOCALE_SETTING_IS_LINK_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SWITCHBOARD_PLUG_LOCALE_WIDGETS_LOCALE_SETTING_TYPE_LINK_ROW))
#define SWITCHBOARD_PLUG_LOCALE_WIDGETS_LOCALE_SETTING_LINK_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SWITCHBOARD_PLUG_LOCALE_WIDGETS_LOCALE_SETTING_TYPE_LINK_ROW, SwitchboardPlugLocaleWidgetsLocaleSettingLinkRowClass))

typedef struct _SwitchboardPlugLocaleWidgetsLocaleSettingLinkRow SwitchboardPlugLocaleWidgetsLocaleSettingLinkRow;
typedef struct _SwitchboardPlugLocaleWidgetsLocaleSettingLinkRowClass SwitchboardPlugLocaleWidgetsLocaleSettingLinkRowClass;
typedef struct _SwitchboardPlugLocaleWidgetsLocaleSettingLinkRowPrivate SwitchboardPlugLocaleWidgetsLocaleSettingLinkRowPrivate;
enum  {
	SWITCHBOARD_PLUG_LOCALE_WIDGETS_LOCALE_SETTING_LINK_ROW_0_PROPERTY,
	SWITCHBOARD_PLUG_LOCALE_WIDGETS_LOCALE_SETTING_LINK_ROW_URI_PROPERTY,
	SWITCHBOARD_PLUG_LOCALE_WIDGETS_LOCALE_SETTING_LINK_ROW_ICON_NAME_PROPERTY,
	SWITCHBOARD_PLUG_LOCALE_WIDGETS_LOCALE_SETTING_LINK_ROW_LABEL_STRING_PROPERTY,
	SWITCHBOARD_PLUG_LOCALE_WIDGETS_LOCALE_SETTING_LINK_ROW_COLOR_PROPERTY,
	SWITCHBOARD_PLUG_LOCALE_WIDGETS_LOCALE_SETTING_LINK_ROW_NUM_PROPERTIES
};
static GParamSpec* switchboard_plug_locale_widgets_locale_setting_link_row_properties[SWITCHBOARD_PLUG_LOCALE_WIDGETS_LOCALE_SETTING_LINK_ROW_NUM_PROPERTIES];
typedef struct _Block6Data Block6Data;
#define _gtk_expression_unref0(var) ((var == NULL) ? NULL : (var = (gtk_expression_unref (var), NULL)))
typedef struct _Block7Data Block7Data;
#define _g_settings_schema_unref0(var) ((var == NULL) ? NULL : (var = (g_settings_schema_unref (var), NULL)))

struct _SwitchboardPlugLocaleWidgetsLocaleSettingPrivate {
	GtkButton* set_button;
	GtkInfoBar* missing_lang_infobar;
	GtkInfoBar* restart_infobar;
	GtkDropDown* format_dropdown;
	GtkDropDown* region_dropdown;
	GListStore* format_list;
	GListStore* locale_list;
	SwitchboardPlugLocaleLocaleManager* lm;
	SwitchboardPlugLocaleWidgetsPreview* preview;
	gchar* language;
};

struct _SwitchboardPlugLocaleWidgetsLocaleSettingReloadLocalesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SwitchboardPlugLocaleWidgetsLocaleSetting* self;
	gchar* language;
	GeeHashSet* locales;
	gchar* _tmp0_;
	gboolean user_locale_found;
	GListStore* _tmp1_;
	GeeHashMap* default_regions;
	GeeHashMap* _tmp2_;
	gchar* user_locale;
	SwitchboardPlugLocaleLocaleManager* _tmp3_;
	gchar* _tmp4_;
	GeeIterator* _locale_it;
	GeeIterator* _tmp5_;
	GeeIterator* _tmp6_;
	gchar* locale;
	GeeIterator* _tmp7_;
	gpointer _tmp8_;
	gchar* code;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	gboolean _tmp11_;
	gchar* region_string;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	SwitchboardPlugLocaleWidgetsLocaleSettingLocale* locale_object;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	SwitchboardPlugLocaleWidgetsLocaleSettingLocale* _tmp17_;
	guint position;
	GListStore* _tmp18_;
	SwitchboardPlugLocaleWidgetsLocaleSettingLocale* _tmp19_;
	const gchar* _tmp20_;
	const gchar* _tmp21_;
	GtkDropDown* _tmp22_;
	gboolean _tmp23_;
	GeeHashMap* _tmp24_;
	const gchar* _tmp25_;
	GeeHashMap* _tmp26_;
	gpointer _tmp27_;
	gchar* _tmp28_;
	GtkDropDown* _tmp29_;
	GtkDropDown* _tmp30_;
	GListStore* _tmp31_;
	guint _tmp32_;
	guint _tmp33_;
};

struct _SwitchboardPlugLocaleWidgetsLocaleSettingLocale {
	GObject parent_instance;
	SwitchboardPlugLocaleWidgetsLocaleSettingLocalePrivate * priv;
};

struct _SwitchboardPlugLocaleWidgetsLocaleSettingLocaleClass {
	GObjectClass parent_class;
};

struct _SwitchboardPlugLocaleWidgetsLocaleSettingLocalePrivate {
	gchar* _name;
	gchar* _locale;
};

struct _SwitchboardPlugLocaleWidgetsLocaleSettingLinkRow {
	GtkListBoxRow parent_instance;
	SwitchboardPlugLocaleWidgetsLocaleSettingLinkRowPrivate * priv;
};

struct _SwitchboardPlugLocaleWidgetsLocaleSettingLinkRowClass {
	GtkListBoxRowClass parent_class;
};

struct _SwitchboardPlugLocaleWidgetsLocaleSettingLinkRowPrivate {
	gchar* _uri;
	gchar* _icon_name;
	gchar* _label_string;
	gchar* _color;
};

struct _Block6Data {
	int _ref_count_;
	SwitchboardPlugLocaleWidgetsLocaleSetting* self;
	SwitchboardPlugLocaleInstallerUbuntuInstaller* installer;
};

struct _Block7Data {
	int _ref_count_;
	Block6Data * _data6_;
	GtkCheckButton* celcius_radio;
	GtkCheckButton* fahrenheit_radio;
	GtkCheckButton* auto_radio;
};

static gint SwitchboardPlugLocaleWidgetsLocaleSetting_private_offset;
static gpointer switchboard_plug_locale_widgets_locale_setting_parent_class = NULL;
static GSettings* switchboard_plug_locale_widgets_locale_setting_temperature_settings;
static GSettings* switchboard_plug_locale_widgets_locale_setting_temperature_settings = NULL;
static gint SwitchboardPlugLocaleWidgetsLocaleSettingLocale_private_offset;
static gpointer switchboard_plug_locale_widgets_locale_setting_locale_parent_class = NULL;
static gint SwitchboardPlugLocaleWidgetsLocaleSettingLinkRow_private_offset;
static gpointer switchboard_plug_locale_widgets_locale_setting_link_row_parent_class = NULL;

static void switchboard_plug_locale_widgets_locale_setting_on_check_missing_finished (SwitchboardPlugLocaleWidgetsLocaleSetting* self,
                                                                               gchar** missing,
                                                                               gint missing_length1);
static GType switchboard_plug_locale_widgets_locale_setting_locale_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static const gchar* switchboard_plug_locale_widgets_locale_setting_locale_get_locale (SwitchboardPlugLocaleWidgetsLocaleSettingLocale* self);
static void switchboard_plug_locale_widgets_locale_setting_on_format_changed (SwitchboardPlugLocaleWidgetsLocaleSetting* self);
static void switchboard_plug_locale_widgets_locale_setting_compare (SwitchboardPlugLocaleWidgetsLocaleSetting* self);
static void switchboard_plug_locale_widgets_locale_setting_reload_locales_data_free (gpointer _data);
static gboolean switchboard_plug_locale_widgets_locale_setting_reload_locales_co (SwitchboardPlugLocaleWidgetsLocaleSettingReloadLocalesData* _data_);
static void switchboard_plug_locale_widgets_locale_setting_reload_locales_ready (GObject* source_object,
                                                                          GAsyncResult* _res_,
                                                                          gpointer _user_data_);
static SwitchboardPlugLocaleWidgetsLocaleSettingLocale* switchboard_plug_locale_widgets_locale_setting_locale_new (const gchar* name,
                                                                                                            const gchar* locale);
static SwitchboardPlugLocaleWidgetsLocaleSettingLocale* switchboard_plug_locale_widgets_locale_setting_locale_construct (GType object_type,
                                                                                                                  const gchar* name,
                                                                                                                  const gchar* locale);
static gint switchboard_plug_locale_widgets_locale_setting_locale_sort_func (SwitchboardPlugLocaleWidgetsLocaleSetting* self,
                                                                      GObject* a,
                                                                      GObject* b);
static gint _switchboard_plug_locale_widgets_locale_setting_locale_sort_func_gcompare_data_func (gconstpointer a,
                                                                                          gconstpointer b,
                                                                                          gpointer self);
static const gchar* switchboard_plug_locale_widgets_locale_setting_locale_get_name (SwitchboardPlugLocaleWidgetsLocaleSettingLocale* self);
static void switchboard_plug_locale_widgets_locale_setting_on_applied_to_system (SwitchboardPlugLocaleWidgetsLocaleSetting* self);
static void __lambda10_ (SwitchboardPlugLocaleWidgetsLocaleSetting* self,
                  GObject* obj,
                  GAsyncResult* res);
static void _gtk_window_destroy_gtk_dialog_response (GtkDialog* _sender,
                                              gint response_id,
                                              gpointer self);
static void ___lambda10__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static void switchboard_plug_locale_widgets_locale_setting_locale_set_name (SwitchboardPlugLocaleWidgetsLocaleSettingLocale* self,
                                                                     const gchar* value);
static void switchboard_plug_locale_widgets_locale_setting_locale_set_locale (SwitchboardPlugLocaleWidgetsLocaleSettingLocale* self,
                                                                       const gchar* value);
static void switchboard_plug_locale_widgets_locale_setting_locale_finalize (GObject * obj);
static GType switchboard_plug_locale_widgets_locale_setting_locale_get_type_once (void);
static void _vala_switchboard_plug_locale_widgets_locale_setting_locale_get_property (GObject * object,
                                                                               guint property_id,
                                                                               GValue * value,
                                                                               GParamSpec * pspec);
static void _vala_switchboard_plug_locale_widgets_locale_setting_locale_set_property (GObject * object,
                                                                               guint property_id,
                                                                               const GValue * value,
                                                                               GParamSpec * pspec);
static GType switchboard_plug_locale_widgets_locale_setting_link_row_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static SwitchboardPlugLocaleWidgetsLocaleSettingLinkRow* switchboard_plug_locale_widgets_locale_setting_link_row_new (const gchar* uri,
                                                                                                               const gchar* label_string,
                                                                                                               const gchar* icon_name,
                                                                                                               const gchar* color);
static SwitchboardPlugLocaleWidgetsLocaleSettingLinkRow* switchboard_plug_locale_widgets_locale_setting_link_row_construct (GType object_type,
                                                                                                                     const gchar* uri,
                                                                                                                     const gchar* label_string,
                                                                                                                     const gchar* icon_name,
                                                                                                                     const gchar* color);
static const gchar* switchboard_plug_locale_widgets_locale_setting_link_row_get_uri (SwitchboardPlugLocaleWidgetsLocaleSettingLinkRow* self);
static void switchboard_plug_locale_widgets_locale_setting_link_row_set_uri (SwitchboardPlugLocaleWidgetsLocaleSettingLinkRow* self,
                                                                      const gchar* value);
static const gchar* switchboard_plug_locale_widgets_locale_setting_link_row_get_icon_name (SwitchboardPlugLocaleWidgetsLocaleSettingLinkRow* self);
static void switchboard_plug_locale_widgets_locale_setting_link_row_set_icon_name (SwitchboardPlugLocaleWidgetsLocaleSettingLinkRow* self,
                                                                            const gchar* value);
static const gchar* switchboard_plug_locale_widgets_locale_setting_link_row_get_label_string (SwitchboardPlugLocaleWidgetsLocaleSettingLinkRow* self);
static void switchboard_plug_locale_widgets_locale_setting_link_row_set_label_string (SwitchboardPlugLocaleWidgetsLocaleSettingLinkRow* self,
                                                                               const gchar* value);
static const gchar* switchboard_plug_locale_widgets_locale_setting_link_row_get_color (SwitchboardPlugLocaleWidgetsLocaleSettingLinkRow* self);
static void switchboard_plug_locale_widgets_locale_setting_link_row_set_color (SwitchboardPlugLocaleWidgetsLocaleSettingLinkRow* self,
                                                                        const gchar* value);
static GObject * switchboard_plug_locale_widgets_locale_setting_link_row_constructor (GType type,
                                                                               guint n_construct_properties,
                                                                               GObjectConstructParam * construct_properties);
static void switchboard_plug_locale_widgets_locale_setting_link_row_finalize (GObject * obj);
static GType switchboard_plug_locale_widgets_locale_setting_link_row_get_type_once (void);
static void _vala_switchboard_plug_locale_widgets_locale_setting_link_row_get_property (GObject * object,
                                                                                 guint property_id,
                                                                                 GValue * value,
                                                                                 GParamSpec * pspec);
static void _vala_switchboard_plug_locale_widgets_locale_setting_link_row_set_property (GObject * object,
                                                                                 guint property_id,
                                                                                 const GValue * value,
                                                                                 GParamSpec * pspec);
static GObject * switchboard_plug_locale_widgets_locale_setting_constructor (GType type,
                                                                      guint n_construct_properties,
                                                                      GObjectConstructParam * construct_properties);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
static void _switchboard_plug_locale_widgets_locale_setting_compare_g_object_notify (GObject* _sender,
                                                                              GParamSpec* pspec,
                                                                              gpointer self);
static void _switchboard_plug_locale_widgets_locale_setting___lambda11_ (SwitchboardPlugLocaleWidgetsLocaleSetting* self);
static void __switchboard_plug_locale_widgets_locale_setting___lambda11__g_object_notify (GObject* _sender,
                                                                                   GParamSpec* pspec,
                                                                                   gpointer self);
static void _vala_GValue_array_free (GValue * array,
                              gssize array_length);
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (void * _userdata_);
static void _switchboard_plug_locale_widgets_locale_setting____lambda12_ (Block7Data* _data7_);
static void __switchboard_plug_locale_widgets_locale_setting____lambda12__gtk_check_button_toggled (GtkCheckButton* _sender,
                                                                                             gpointer self);
static void _switchboard_plug_locale_widgets_locale_setting____lambda13_ (Block7Data* _data7_);
static void __switchboard_plug_locale_widgets_locale_setting____lambda13__gtk_check_button_toggled (GtkCheckButton* _sender,
                                                                                             gpointer self);
static void _switchboard_plug_locale_widgets_locale_setting____lambda14_ (Block7Data* _data7_);
static void __switchboard_plug_locale_widgets_locale_setting____lambda14__gtk_check_button_toggled (GtkCheckButton* _sender,
                                                                                             gpointer self);
static void _switchboard_plug_locale_widgets_locale_setting___lambda15_ (Block6Data* _data6_);
static void __lambda16_ (Block6Data* _data6_,
                  GObject* obj,
                  GAsyncResult* res);
static void ___lambda16__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static void __switchboard_plug_locale_widgets_locale_setting___lambda15__gtk_info_bar_response (GtkInfoBar* _sender,
                                                                                         gint response_id,
                                                                                         gpointer self);
static void _switchboard_plug_locale_widgets_locale_setting___lambda17_ (SwitchboardPlugLocaleWidgetsLocaleSetting* self,
                                                                  GtkListBoxRow* row);
static void __switchboard_plug_locale_widgets_locale_setting___lambda17__gtk_list_box_row_activated (GtkListBox* _sender,
                                                                                              GtkListBoxRow* row,
                                                                                              gpointer self);
static void _switchboard_plug_locale_widgets_locale_setting___lambda18_ (SwitchboardPlugLocaleWidgetsLocaleSetting* self);
static void __switchboard_plug_locale_widgets_locale_setting___lambda18__gtk_button_clicked (GtkButton* _sender,
                                                                                      gpointer self);
static void _switchboard_plug_locale_widgets_locale_setting_on_applied_to_system_gtk_button_clicked (GtkButton* _sender,
                                                                                              gpointer self);
static void _switchboard_plug_locale_widgets_locale_setting_on_check_missing_finished_switchboard_plug_locale_installer_ubuntu_installer_check_missing_finished (SwitchboardPlugLocaleInstallerUbuntuInstaller* _sender,
                                                                                                                                                          gchar** missing,
                                                                                                                                                          gint missing_length1,
                                                                                                                                                          gpointer self);
static void switchboard_plug_locale_widgets_locale_setting_finalize (GObject * obj);
static GType switchboard_plug_locale_widgets_locale_setting_get_type_once (void);

static inline gpointer
switchboard_plug_locale_widgets_locale_setting_get_instance_private (SwitchboardPlugLocaleWidgetsLocaleSetting* self)
{
	return G_STRUCT_MEMBER_P (self, SwitchboardPlugLocaleWidgetsLocaleSetting_private_offset);
}

SwitchboardPlugLocaleWidgetsLocaleSetting*
switchboard_plug_locale_widgets_locale_setting_construct (GType object_type)
{
	SwitchboardPlugLocaleWidgetsLocaleSetting * self = NULL;
	GThemedIcon* _tmp0_;
	GThemedIcon* _tmp1_;
	_tmp0_ = (GThemedIcon*) g_themed_icon_new ("preferences-desktop-locale");
	_tmp1_ = _tmp0_;
	self = (SwitchboardPlugLocaleWidgetsLocaleSetting*) g_object_new (object_type, "icon", _tmp1_, NULL);
	_g_object_unref0 (_tmp1_);
	return self;
}

SwitchboardPlugLocaleWidgetsLocaleSetting*
switchboard_plug_locale_widgets_locale_setting_new (void)
{
	return switchboard_plug_locale_widgets_locale_setting_construct (SWITCHBOARD_PLUG_LOCALE_WIDGETS_TYPE_LOCALE_SETTING);
}

static void
switchboard_plug_locale_widgets_locale_setting_on_check_missing_finished (SwitchboardPlugLocaleWidgetsLocaleSetting* self,
                                                                          gchar** missing,
                                                                          gint missing_length1)
{
	GtkInfoBar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->missing_lang_infobar;
	gtk_info_bar_set_revealed (_tmp0_, missing_length1 > 0);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

gchar*
switchboard_plug_locale_widgets_locale_setting_get_selected_locale (SwitchboardPlugLocaleWidgetsLocaleSetting* self)
{
	SwitchboardPlugLocaleWidgetsLocaleSettingLocale* locale_object = NULL;
	GtkDropDown* _tmp0_;
	GObject* _tmp1_;
	GObject* _tmp2_;
	SwitchboardPlugLocaleWidgetsLocaleSettingLocale* _tmp3_;
	SwitchboardPlugLocaleWidgetsLocaleSettingLocale* _tmp4_;
	SwitchboardPlugLocaleWidgetsLocaleSettingLocale* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->region_dropdown;
	_tmp1_ = gtk_drop_down_get_selected_item (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, SWITCHBOARD_PLUG_LOCALE_WIDGETS_LOCALE_SETTING_TYPE_LOCALE, SwitchboardPlugLocaleWidgetsLocaleSettingLocale));
	locale_object = _tmp3_;
	_tmp4_ = locale_object;
	if (_tmp4_ == NULL) {
		gchar* _tmp5_;
		_tmp5_ = g_strdup ("");
		result = _tmp5_;
		_g_object_unref0 (locale_object);
		return result;
	}
	_tmp6_ = locale_object;
	_tmp7_ = switchboard_plug_locale_widgets_locale_setting_locale_get_locale (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = g_strdup (_tmp8_);
	result = _tmp9_;
	_g_object_unref0 (locale_object);
	return result;
}

gchar*
switchboard_plug_locale_widgets_locale_setting_get_format (SwitchboardPlugLocaleWidgetsLocaleSetting* self)
{
	SwitchboardPlugLocaleWidgetsLocaleSettingLocale* locale_object = NULL;
	GtkDropDown* _tmp0_;
	GObject* _tmp1_;
	GObject* _tmp2_;
	SwitchboardPlugLocaleWidgetsLocaleSettingLocale* _tmp3_;
	SwitchboardPlugLocaleWidgetsLocaleSettingLocale* _tmp4_;
	SwitchboardPlugLocaleWidgetsLocaleSettingLocale* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->format_dropdown;
	_tmp1_ = gtk_drop_down_get_selected_item (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, SWITCHBOARD_PLUG_LOCALE_WIDGETS_LOCALE_SETTING_TYPE_LOCALE, SwitchboardPlugLocaleWidgetsLocaleSettingLocale));
	locale_object = _tmp3_;
	_tmp4_ = locale_object;
	if (_tmp4_ == NULL) {
		gchar* _tmp5_;
		_tmp5_ = g_strdup ("");
		result = _tmp5_;
		_g_object_unref0 (locale_object);
		return result;
	}
	_tmp6_ = locale_object;
	_tmp7_ = switchboard_plug_locale_widgets_locale_setting_locale_get_locale (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = g_strdup (_tmp8_);
	result = _tmp9_;
	_g_object_unref0 (locale_object);
	return result;
}

static void
switchboard_plug_locale_widgets_locale_setting_on_format_changed (SwitchboardPlugLocaleWidgetsLocaleSetting* self)
{
	gchar* format = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = switchboard_plug_locale_widgets_locale_setting_get_format (self);
	format = _tmp0_;
	_tmp1_ = format;
	if (g_strcmp0 (_tmp1_, "") != 0) {
		SwitchboardPlugLocaleWidgetsPreview* _tmp2_;
		const gchar* _tmp3_;
		_tmp2_ = self->priv->preview;
		_tmp3_ = format;
		switchboard_plug_locale_widgets_preview_reload_languages (_tmp2_, _tmp3_);
	}
	_g_free0 (format);
}

static void
switchboard_plug_locale_widgets_locale_setting_compare (SwitchboardPlugLocaleWidgetsLocaleSetting* self)
{
	GtkButton* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->set_button;
	if (_tmp0_ != NULL) {
		gboolean _tmp1_ = FALSE;
		SwitchboardPlugLocaleLocaleManager* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gboolean _tmp7_;
		_tmp2_ = self->priv->lm;
		_tmp3_ = switchboard_plug_locale_locale_manager_get_user_language (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = switchboard_plug_locale_widgets_locale_setting_get_selected_locale (self);
		_tmp6_ = _tmp5_;
		_tmp7_ = g_strcmp0 (_tmp4_, _tmp6_) == 0;
		_g_free0 (_tmp6_);
		_g_free0 (_tmp4_);
		if (_tmp7_) {
			SwitchboardPlugLocaleLocaleManager* _tmp8_;
			gchar* _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
			gchar* _tmp12_;
			_tmp8_ = self->priv->lm;
			_tmp9_ = switchboard_plug_locale_locale_manager_get_user_format (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = switchboard_plug_locale_widgets_locale_setting_get_format (self);
			_tmp12_ = _tmp11_;
			_tmp1_ = g_strcmp0 (_tmp10_, _tmp12_) == 0;
			_g_free0 (_tmp12_);
			_g_free0 (_tmp10_);
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			GtkInfoBar* _tmp13_;
			GtkButton* _tmp14_;
			_tmp13_ = self->priv->restart_infobar;
			gtk_info_bar_set_revealed (_tmp13_, FALSE);
			_tmp14_ = self->priv->set_button;
			gtk_widget_set_sensitive ((GtkWidget*) _tmp14_, FALSE);
		} else {
			GtkButton* _tmp15_;
			_tmp15_ = self->priv->set_button;
			gtk_widget_set_sensitive ((GtkWidget*) _tmp15_, TRUE);
		}
	}
}

static void
switchboard_plug_locale_widgets_locale_setting_reload_locales_data_free (gpointer _data)
{
	SwitchboardPlugLocaleWidgetsLocaleSettingReloadLocalesData* _data_;
	_data_ = _data;
	_g_free0 (_data_->language);
	_g_object_unref0 (_data_->locales);
	_g_object_unref0 (_data_->self);
	g_slice_free (SwitchboardPlugLocaleWidgetsLocaleSettingReloadLocalesData, _data_);
}

void
switchboard_plug_locale_widgets_locale_setting_reload_locales (SwitchboardPlugLocaleWidgetsLocaleSetting* self,
                                                               const gchar* language,
                                                               GeeHashSet* locales,
                                                               GAsyncReadyCallback _callback_,
                                                               gpointer _user_data_)
{
	SwitchboardPlugLocaleWidgetsLocaleSettingReloadLocalesData* _data_;
	SwitchboardPlugLocaleWidgetsLocaleSetting* _tmp0_;
	gchar* _tmp1_;
	GeeHashSet* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (language != NULL);
	g_return_if_fail (locales != NULL);
	_data_ = g_slice_new0 (SwitchboardPlugLocaleWidgetsLocaleSettingReloadLocalesData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, switchboard_plug_locale_widgets_locale_setting_reload_locales_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (language);
	_g_free0 (_data_->language);
	_data_->language = _tmp1_;
	_tmp2_ = _g_object_ref0 (locales);
	_g_object_unref0 (_data_->locales);
	_data_->locales = _tmp2_;
	switchboard_plug_locale_widgets_locale_setting_reload_locales_co (_data_);
}

void
switchboard_plug_locale_widgets_locale_setting_reload_locales_finish (SwitchboardPlugLocaleWidgetsLocaleSetting* self,
                                                                      GAsyncResult* _res_)
{
	SwitchboardPlugLocaleWidgetsLocaleSettingReloadLocalesData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
switchboard_plug_locale_widgets_locale_setting_reload_locales_ready (GObject* source_object,
                                                                     GAsyncResult* _res_,
                                                                     gpointer _user_data_)
{
	SwitchboardPlugLocaleWidgetsLocaleSettingReloadLocalesData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	switchboard_plug_locale_widgets_locale_setting_reload_locales_co (_data_);
}

static gint
_switchboard_plug_locale_widgets_locale_setting_locale_sort_func_gcompare_data_func (gconstpointer a,
                                                                                     gconstpointer b,
                                                                                     gpointer self)
{
	gint result;
	result = switchboard_plug_locale_widgets_locale_setting_locale_sort_func ((SwitchboardPlugLocaleWidgetsLocaleSetting*) self, (GObject*) a, (GObject*) b);
	return result;
}

static gboolean
switchboard_plug_locale_widgets_locale_setting_reload_locales_co (SwitchboardPlugLocaleWidgetsLocaleSettingReloadLocalesData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_strdup (_data_->language);
	_g_free0 (_data_->self->priv->language);
	_data_->self->priv->language = _data_->_tmp0_;
	_data_->user_locale_found = FALSE;
	_data_->_tmp1_ = _data_->self->priv->locale_list;
	g_list_store_remove_all (_data_->_tmp1_);
	_data_->_state_ = 1;
	switchboard_plug_locale_utils_get_default_regions (switchboard_plug_locale_widgets_locale_setting_reload_locales_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp2_ = switchboard_plug_locale_utils_get_default_regions_finish (_data_->_res_);
	_data_->default_regions = _data_->_tmp2_;
	_data_->_tmp3_ = _data_->self->priv->lm;
	_data_->_tmp4_ = switchboard_plug_locale_locale_manager_get_user_language (_data_->_tmp3_);
	_data_->user_locale = _data_->_tmp4_;
	{
		_data_->_tmp5_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _data_->locales);
		_data_->_locale_it = _data_->_tmp5_;
		while (TRUE) {
			_data_->_tmp6_ = _data_->_locale_it;
			if (!gee_iterator_next (_data_->_tmp6_)) {
				break;
			}
			_data_->_tmp7_ = _data_->_locale_it;
			_data_->_tmp8_ = gee_iterator_get (_data_->_tmp7_);
			_data_->locale = (gchar*) _data_->_tmp8_;
			_data_->_tmp9_ = _data_->locale;
			_data_->_tmp10_ = NULL;
			_data_->_tmp11_ = gnome_parse_locale (_data_->_tmp9_, NULL, &_data_->_tmp10_, NULL, NULL);
			_g_free0 (_data_->code);
			_data_->code = _data_->_tmp10_;
			if (!_data_->_tmp11_) {
				_g_free0 (_data_->code);
				_g_free0 (_data_->locale);
				continue;
			}
			_data_->_tmp12_ = _data_->code;
			_data_->_tmp13_ = _data_->locale;
			_data_->_tmp14_ = switchboard_plug_locale_utils_translate_region (_data_->language, _data_->_tmp12_, _data_->_tmp13_);
			_data_->region_string = _data_->_tmp14_;
			_data_->_tmp15_ = _data_->region_string;
			_data_->_tmp16_ = _data_->locale;
			_data_->_tmp17_ = switchboard_plug_locale_widgets_locale_setting_locale_new (_data_->_tmp15_, _data_->_tmp16_);
			_data_->locale_object = _data_->_tmp17_;
			_data_->_tmp18_ = _data_->self->priv->locale_list;
			_data_->_tmp19_ = _data_->locale_object;
			_data_->position = g_list_store_insert_sorted (_data_->_tmp18_, (GObject*) _data_->_tmp19_, _switchboard_plug_locale_widgets_locale_setting_locale_sort_func_gcompare_data_func, _data_->self);
			if (_data_->user_locale_found) {
				_g_object_unref0 (_data_->locale_object);
				_g_free0 (_data_->region_string);
				_g_free0 (_data_->code);
				_g_free0 (_data_->locale);
				continue;
			}
			_data_->_tmp20_ = _data_->user_locale;
			_data_->_tmp21_ = _data_->locale;
			if (g_strcmp0 (_data_->_tmp20_, _data_->_tmp21_) == 0) {
				_data_->_tmp22_ = _data_->self->priv->region_dropdown;
				gtk_drop_down_set_selected (_data_->_tmp22_, _data_->position);
				_data_->user_locale_found = TRUE;
			} else {
				_data_->_tmp24_ = _data_->default_regions;
				if (gee_abstract_map_has_key ((GeeAbstractMap*) _data_->_tmp24_, _data_->language)) {
					_data_->_tmp25_ = _data_->locale;
					_data_->_tmp26_ = _data_->default_regions;
					_data_->_tmp27_ = gee_abstract_map_get ((GeeAbstractMap*) _data_->_tmp26_, _data_->language);
					_data_->_tmp28_ = (gchar*) _data_->_tmp27_;
					_data_->_tmp23_ = g_str_has_prefix (_data_->_tmp25_, _data_->_tmp28_);
					_g_free0 (_data_->_tmp28_);
				} else {
					_data_->_tmp23_ = FALSE;
				}
				if (_data_->_tmp23_) {
					_data_->_tmp29_ = _data_->self->priv->region_dropdown;
					gtk_drop_down_set_selected (_data_->_tmp29_, _data_->position);
				}
			}
			_g_object_unref0 (_data_->locale_object);
			_g_free0 (_data_->region_string);
			_g_free0 (_data_->code);
			_g_free0 (_data_->locale);
		}
		_g_object_unref0 (_data_->_locale_it);
	}
	_data_->_tmp30_ = _data_->self->priv->region_dropdown;
	_data_->_tmp31_ = _data_->self->priv->locale_list;
	g_object_get (_data_->_tmp31_, "n-items", &_data_->_tmp32_, NULL);
	_data_->_tmp33_ = _data_->_tmp32_;
	gtk_widget_set_sensitive ((GtkWidget*) _data_->_tmp30_, _data_->_tmp33_ > ((guint) 1));
	switchboard_plug_locale_widgets_locale_setting_compare (_data_->self);
	_g_free0 (_data_->user_locale);
	_g_object_unref0 (_data_->default_regions);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static gint
switchboard_plug_locale_widgets_locale_setting_locale_sort_func (SwitchboardPlugLocaleWidgetsLocaleSetting* self,
                                                                 GObject* a,
                                                                 GObject* b)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = switchboard_plug_locale_widgets_locale_setting_locale_get_name (G_TYPE_CHECK_INSTANCE_CAST (a, SWITCHBOARD_PLUG_LOCALE_WIDGETS_LOCALE_SETTING_TYPE_LOCALE, SwitchboardPlugLocaleWidgetsLocaleSettingLocale));
	_tmp1_ = _tmp0_;
	_tmp2_ = switchboard_plug_locale_widgets_locale_setting_locale_get_name (G_TYPE_CHECK_INSTANCE_CAST (b, SWITCHBOARD_PLUG_LOCALE_WIDGETS_LOCALE_SETTING_TYPE_LOCALE, SwitchboardPlugLocaleWidgetsLocaleSettingLocale));
	_tmp3_ = _tmp2_;
	result = g_utf8_collate (_tmp1_, _tmp3_);
	return result;
}

void
switchboard_plug_locale_widgets_locale_setting_reload_formats (SwitchboardPlugLocaleWidgetsLocaleSetting* self,
                                                               GeeArrayList* locales)
{
	GListStore* _tmp0_;
	gchar* user_format = NULL;
	SwitchboardPlugLocaleLocaleManager* _tmp1_;
	gchar* _tmp2_;
	GtkDropDown* _tmp21_;
	GListStore* _tmp22_;
	guint _tmp23_;
	guint _tmp24_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->format_list;
	g_list_store_remove_all (_tmp0_);
	_tmp1_ = self->priv->lm;
	_tmp2_ = switchboard_plug_locale_locale_manager_get_user_format (_tmp1_);
	user_format = _tmp2_;
	{
		GeeArrayList* _locale_list = NULL;
		gint _locale_size = 0;
		GeeArrayList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _locale_index = 0;
		_locale_list = locales;
		_tmp3_ = _locale_list;
		_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_locale_size = _tmp5_;
		_locale_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			gchar* locale = NULL;
			GeeArrayList* _tmp8_;
			gpointer _tmp9_;
			gchar* country = NULL;
			const gchar* _tmp10_;
			gchar* _tmp11_;
			const gchar* _tmp12_;
			_locale_index = _locale_index + 1;
			_tmp6_ = _locale_index;
			_tmp7_ = _locale_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _locale_list;
			_tmp9_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _locale_index);
			locale = (gchar*) _tmp9_;
			_tmp10_ = locale;
			_tmp11_ = gnome_get_country_from_locale (_tmp10_, NULL);
			country = _tmp11_;
			_tmp12_ = country;
			if (_tmp12_ != NULL) {
				SwitchboardPlugLocaleWidgetsLocaleSettingLocale* locale_object = NULL;
				const gchar* _tmp13_;
				const gchar* _tmp14_;
				SwitchboardPlugLocaleWidgetsLocaleSettingLocale* _tmp15_;
				guint position = 0U;
				GListStore* _tmp16_;
				SwitchboardPlugLocaleWidgetsLocaleSettingLocale* _tmp17_;
				const gchar* _tmp18_;
				const gchar* _tmp19_;
				_tmp13_ = country;
				_tmp14_ = locale;
				_tmp15_ = switchboard_plug_locale_widgets_locale_setting_locale_new (_tmp13_, _tmp14_);
				locale_object = _tmp15_;
				_tmp16_ = self->priv->format_list;
				_tmp17_ = locale_object;
				position = g_list_store_insert_sorted (_tmp16_, (GObject*) _tmp17_, _switchboard_plug_locale_widgets_locale_setting_locale_sort_func_gcompare_data_func, self);
				_tmp18_ = locale;
				_tmp19_ = user_format;
				if (g_strcmp0 (_tmp18_, _tmp19_) == 0) {
					GtkDropDown* _tmp20_;
					_tmp20_ = self->priv->format_dropdown;
					gtk_drop_down_set_selected (_tmp20_, position);
				}
				_g_object_unref0 (locale_object);
			}
			_g_free0 (country);
			_g_free0 (locale);
		}
	}
	_tmp21_ = self->priv->format_dropdown;
	_tmp22_ = self->priv->format_list;
	g_object_get (_tmp22_, "n-items", &_tmp23_, NULL);
	_tmp24_ = _tmp23_;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp21_, _tmp24_ > ((guint) 1));
	switchboard_plug_locale_widgets_locale_setting_compare (self);
	_g_free0 (user_format);
}

void
switchboard_plug_locale_widgets_locale_setting_reload_labels (SwitchboardPlugLocaleWidgetsLocaleSetting* self,
                                                              const gchar* language_name)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (language_name != NULL);
	switchboard_settings_page_set_title ((SwitchboardSettingsPage*) self, language_name);
}

static void
_gtk_window_destroy_gtk_dialog_response (GtkDialog* _sender,
                                         gint response_id,
                                         gpointer self)
{
	gtk_window_destroy ((GtkWindow*) self);
}

static void
__lambda10_ (SwitchboardPlugLocaleWidgetsLocaleSetting* self,
             GObject* obj,
             GAsyncResult* res)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (res != NULL);
	{
		SwitchboardPlugLocaleLocaleManager* _tmp0_;
		GtkInfoBar* _tmp1_;
		_tmp0_ = self->priv->lm;
		switchboard_plug_locale_locale_manager_apply_to_system_finish (_tmp0_, res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp1_ = self->priv->restart_infobar;
		gtk_info_bar_set_revealed (_tmp1_, TRUE);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_;
		GraniteMessageDialog* dialog = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		GThemedIcon* _tmp5_;
		GThemedIcon* _tmp6_;
		GThemedIcon* _tmp7_;
		GApplication* _tmp8_;
		GtkWindow* _tmp9_;
		GtkWindow* _tmp10_;
		GtkWindow* _tmp11_;
		GraniteMessageDialog* _tmp12_ = NULL;
		GraniteMessageDialog* _tmp13_;
		GraniteMessageDialog* _tmp14_;
		GraniteMessageDialog* _tmp15_;
		GraniteMessageDialog* _tmp16_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = e;
		if (g_error_matches (_tmp2_, g_dbus_error_quark (), G_DBUS_ERROR_ACCESS_DENIED)) {
			_g_error_free0 (e);
			return;
		}
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		_tmp5_ = (GThemedIcon*) g_themed_icon_new ("preferences-desktop-locale");
		_tmp6_ = _tmp5_;
		_tmp7_ = (GThemedIcon*) g_themed_icon_new ("dialog-error");
		_tmp8_ = g_application_get_default ();
		_tmp9_ = gtk_application_get_active_window (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_application_get_type (), GtkApplication));
		_tmp10_ = _tmp9_;
		_tmp11_ = _g_object_ref0 (_tmp10_);
		_tmp12_ = granite_message_dialog_new (_ ("Can't set system locale"), _tmp4_, (GIcon*) _tmp6_, GTK_BUTTONS_CLOSE);
		granite_message_dialog_set_badge_icon (_tmp12_, (GIcon*) _tmp7_);
		_g_object_unref0 (_tmp7_);
		gtk_window_set_modal ((GtkWindow*) _tmp12_, TRUE);
		gtk_window_set_transient_for ((GtkWindow*) _tmp12_, _tmp11_);
		_g_object_unref0 (_tmp11_);
		g_object_ref_sink (_tmp12_);
		_tmp13_ = _tmp12_;
		_g_object_unref0 (_tmp6_);
		dialog = _tmp13_;
		_tmp14_ = dialog;
		gtk_window_present ((GtkWindow*) _tmp14_);
		_tmp15_ = dialog;
		_tmp16_ = dialog;
		g_signal_connect_object ((GtkDialog*) _tmp15_, "response", (GCallback) _gtk_window_destroy_gtk_dialog_response, (GtkWindow*) _tmp16_, 0);
		_g_object_unref0 (dialog);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda10__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda10_ ((SwitchboardPlugLocaleWidgetsLocaleSetting*) self, source_object, res);
	g_object_unref (self);
}

static void
switchboard_plug_locale_widgets_locale_setting_on_applied_to_system (SwitchboardPlugLocaleWidgetsLocaleSetting* self)
{
	gchar* selected_locale = NULL;
	gchar* _tmp0_;
	gchar* selected_format = NULL;
	gchar* _tmp1_;
	SwitchboardPlugLocaleLocaleManager* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = switchboard_plug_locale_widgets_locale_setting_get_selected_locale (self);
	selected_locale = _tmp0_;
	_tmp1_ = switchboard_plug_locale_widgets_locale_setting_get_format (self);
	selected_format = _tmp1_;
	g_debug ("LocaleSetting.vala:400: Setting system language to '%s' and format to " \
"'%s'", selected_locale, selected_format);
	_tmp2_ = self->priv->lm;
	switchboard_plug_locale_locale_manager_apply_to_system (_tmp2_, selected_locale, selected_format, ___lambda10__gasync_ready_callback, g_object_ref (self));
	_g_free0 (selected_format);
	_g_free0 (selected_locale);
}

static inline gpointer
switchboard_plug_locale_widgets_locale_setting_locale_get_instance_private (SwitchboardPlugLocaleWidgetsLocaleSettingLocale* self)
{
	return G_STRUCT_MEMBER_P (self, SwitchboardPlugLocaleWidgetsLocaleSettingLocale_private_offset);
}

static SwitchboardPlugLocaleWidgetsLocaleSettingLocale*
switchboard_plug_locale_widgets_locale_setting_locale_construct (GType object_type,
                                                                 const gchar* name,
                                                                 const gchar* locale)
{
	SwitchboardPlugLocaleWidgetsLocaleSettingLocale * self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (locale != NULL, NULL);
	self = (SwitchboardPlugLocaleWidgetsLocaleSettingLocale*) g_object_new (object_type, "name", name, "locale", locale, NULL);
	return self;
}

static SwitchboardPlugLocaleWidgetsLocaleSettingLocale*
switchboard_plug_locale_widgets_locale_setting_locale_new (const gchar* name,
                                                           const gchar* locale)
{
	return switchboard_plug_locale_widgets_locale_setting_locale_construct (SWITCHBOARD_PLUG_LOCALE_WIDGETS_LOCALE_SETTING_TYPE_LOCALE, name, locale);
}

static const gchar*
switchboard_plug_locale_widgets_locale_setting_locale_get_name (SwitchboardPlugLocaleWidgetsLocaleSettingLocale* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_name;
	result = _tmp0_;
	return result;
}

static void
switchboard_plug_locale_widgets_locale_setting_locale_set_name (SwitchboardPlugLocaleWidgetsLocaleSettingLocale* self,
                                                                const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = switchboard_plug_locale_widgets_locale_setting_locale_get_name (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_name);
		self->priv->_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, switchboard_plug_locale_widgets_locale_setting_locale_properties[SWITCHBOARD_PLUG_LOCALE_WIDGETS_LOCALE_SETTING_LOCALE_NAME_PROPERTY]);
	}
}

static const gchar*
switchboard_plug_locale_widgets_locale_setting_locale_get_locale (SwitchboardPlugLocaleWidgetsLocaleSettingLocale* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_locale;
	result = _tmp0_;
	return result;
}

static void
switchboard_plug_locale_widgets_locale_setting_locale_set_locale (SwitchboardPlugLocaleWidgetsLocaleSettingLocale* self,
                                                                  const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = switchboard_plug_locale_widgets_locale_setting_locale_get_locale (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_locale);
		self->priv->_locale = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, switchboard_plug_locale_widgets_locale_setting_locale_properties[SWITCHBOARD_PLUG_LOCALE_WIDGETS_LOCALE_SETTING_LOCALE_LOCALE_PROPERTY]);
	}
}

static void
switchboard_plug_locale_widgets_locale_setting_locale_class_init (SwitchboardPlugLocaleWidgetsLocaleSettingLocaleClass * klass,
                                                                  gpointer klass_data)
{
	switchboard_plug_locale_widgets_locale_setting_locale_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SwitchboardPlugLocaleWidgetsLocaleSettingLocale_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_switchboard_plug_locale_widgets_locale_setting_locale_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_switchboard_plug_locale_widgets_locale_setting_locale_set_property;
	G_OBJECT_CLASS (klass)->finalize = switchboard_plug_locale_widgets_locale_setting_locale_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SWITCHBOARD_PLUG_LOCALE_WIDGETS_LOCALE_SETTING_LOCALE_NAME_PROPERTY, switchboard_plug_locale_widgets_locale_setting_locale_properties[SWITCHBOARD_PLUG_LOCALE_WIDGETS_LOCALE_SETTING_LOCALE_NAME_PROPERTY] = g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SWITCHBOARD_PLUG_LOCALE_WIDGETS_LOCALE_SETTING_LOCALE_LOCALE_PROPERTY, switchboard_plug_locale_widgets_locale_setting_locale_properties[SWITCHBOARD_PLUG_LOCALE_WIDGETS_LOCALE_SETTING_LOCALE_LOCALE_PROPERTY] = g_param_spec_string ("locale", "locale", "locale", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}

static void
switchboard_plug_locale_widgets_locale_setting_locale_instance_init (SwitchboardPlugLocaleWidgetsLocaleSettingLocale * self,
                                                                     gpointer klass)
{
	self->priv = switchboard_plug_locale_widgets_locale_setting_locale_get_instance_private (self);
}

static void
switchboard_plug_locale_widgets_locale_setting_locale_finalize (GObject * obj)
{
	SwitchboardPlugLocaleWidgetsLocaleSettingLocale * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SWITCHBOARD_PLUG_LOCALE_WIDGETS_LOCALE_SETTING_TYPE_LOCALE, SwitchboardPlugLocaleWidgetsLocaleSettingLocale);
	_g_free0 (self->priv->_name);
	_g_free0 (self->priv->_locale);
	G_OBJECT_CLASS (switchboard_plug_locale_widgets_locale_setting_locale_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
switchboard_plug_locale_widgets_locale_setting_locale_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SwitchboardPlugLocaleWidgetsLocaleSettingLocaleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) switchboard_plug_locale_widgets_locale_setting_locale_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SwitchboardPlugLocaleWidgetsLocaleSettingLocale), 0, (GInstanceInitFunc) switchboard_plug_locale_widgets_locale_setting_locale_instance_init, NULL };
	GType switchboard_plug_locale_widgets_locale_setting_locale_type_id;
	switchboard_plug_locale_widgets_locale_setting_locale_type_id = g_type_register_static (G_TYPE_OBJECT, "SwitchboardPlugLocaleWidgetsLocaleSettingLocale", &g_define_type_info, 0);
	SwitchboardPlugLocaleWidgetsLocaleSettingLocale_private_offset = g_type_add_instance_private (switchboard_plug_locale_widgets_locale_setting_locale_type_id, sizeof (SwitchboardPlugLocaleWidgetsLocaleSettingLocalePrivate));
	return switchboard_plug_locale_widgets_locale_setting_locale_type_id;
}

static GType
switchboard_plug_locale_widgets_locale_setting_locale_get_type (void)
{
	static gsize switchboard_plug_locale_widgets_locale_setting_locale_type_id__once = 0;
	if (g_once_init_enter (&switchboard_plug_locale_widgets_locale_setting_locale_type_id__once)) {
		GType switchboard_plug_locale_widgets_locale_setting_locale_type_id;
		switchboard_plug_locale_widgets_locale_setting_locale_type_id = switchboard_plug_locale_widgets_locale_setting_locale_get_type_once ();
		g_once_init_leave (&switchboard_plug_locale_widgets_locale_setting_locale_type_id__once, switchboard_plug_locale_widgets_locale_setting_locale_type_id);
	}
	return switchboard_plug_locale_widgets_locale_setting_locale_type_id__once;
}

static void
_vala_switchboard_plug_locale_widgets_locale_setting_locale_get_property (GObject * object,
                                                                          guint property_id,
                                                                          GValue * value,
                                                                          GParamSpec * pspec)
{
	SwitchboardPlugLocaleWidgetsLocaleSettingLocale * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SWITCHBOARD_PLUG_LOCALE_WIDGETS_LOCALE_SETTING_TYPE_LOCALE, SwitchboardPlugLocaleWidgetsLocaleSettingLocale);
	switch (property_id) {
		case SWITCHBOARD_PLUG_LOCALE_WIDGETS_LOCALE_SETTING_LOCALE_NAME_PROPERTY:
		g_value_set_string (value, switchboard_plug_locale_widgets_locale_setting_locale_get_name (self));
		break;
		case SWITCHBOARD_PLUG_LOCALE_WIDGETS_LOCALE_SETTING_LOCALE_LOCALE_PROPERTY:
		g_value_set_string (value, switchboard_plug_locale_widgets_locale_setting_locale_get_locale (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_switchboard_plug_locale_widgets_locale_setting_locale_set_property (GObject * object,
                                                                          guint property_id,
                                                                          const GValue * value,
                                                                          GParamSpec * pspec)
{
	SwitchboardPlugLocaleWidgetsLocaleSettingLocale * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SWITCHBOARD_PLUG_LOCALE_WIDGETS_LOCALE_SETTING_TYPE_LOCALE, SwitchboardPlugLocaleWidgetsLocaleSettingLocale);
	switch (property_id) {
		case SWITCHBOARD_PLUG_LOCALE_WIDGETS_LOCALE_SETTING_LOCALE_NAME_PROPERTY:
		switchboard_plug_locale_widgets_locale_setting_locale_set_name (self, g_value_get_string (value));
		break;
		case SWITCHBOARD_PLUG_LOCALE_WIDGETS_LOCALE_SETTING_LOCALE_LOCALE_PROPERTY:
		switchboard_plug_locale_widgets_locale_setting_locale_set_locale (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
switchboard_plug_locale_widgets_locale_setting_link_row_get_instance_private (SwitchboardPlugLocaleWidgetsLocaleSettingLinkRow* self)
{
	return G_STRUCT_MEMBER_P (self, SwitchboardPlugLocaleWidgetsLocaleSettingLinkRow_private_offset);
}

static SwitchboardPlugLocaleWidgetsLocaleSettingLinkRow*
switchboard_plug_locale_widgets_locale_setting_link_row_construct (GType object_type,
                                                                   const gchar* uri,
                                                                   const gchar* label_string,
                                                                   const gchar* icon_name,
                                                                   const gchar* color)
{
	SwitchboardPlugLocaleWidgetsLocaleSettingLinkRow * self = NULL;
	g_return_val_if_fail (uri != NULL, NULL);
	g_return_val_if_fail (label_string != NULL, NULL);
	g_return_val_if_fail (icon_name != NULL, NULL);
	g_return_val_if_fail (color != NULL, NULL);
	self = (SwitchboardPlugLocaleWidgetsLocaleSettingLinkRow*) g_object_new (object_type, "uri", uri, "label-string", label_string, "icon-name", icon_name, "color", color, NULL);
	return self;
}

static SwitchboardPlugLocaleWidgetsLocaleSettingLinkRow*
switchboard_plug_locale_widgets_locale_setting_link_row_new (const gchar* uri,
                                                             const gchar* label_string,
                                                             const gchar* icon_name,
                                                             const gchar* color)
{
	return switchboard_plug_locale_widgets_locale_setting_link_row_construct (SWITCHBOARD_PLUG_LOCALE_WIDGETS_LOCALE_SETTING_TYPE_LINK_ROW, uri, label_string, icon_name, color);
}

static const gchar*
switchboard_plug_locale_widgets_locale_setting_link_row_get_uri (SwitchboardPlugLocaleWidgetsLocaleSettingLinkRow* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_uri;
	result = _tmp0_;
	return result;
}

static void
switchboard_plug_locale_widgets_locale_setting_link_row_set_uri (SwitchboardPlugLocaleWidgetsLocaleSettingLinkRow* self,
                                                                 const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = switchboard_plug_locale_widgets_locale_setting_link_row_get_uri (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_uri);
		self->priv->_uri = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, switchboard_plug_locale_widgets_locale_setting_link_row_properties[SWITCHBOARD_PLUG_LOCALE_WIDGETS_LOCALE_SETTING_LINK_ROW_URI_PROPERTY]);
	}
}

static const gchar*
switchboard_plug_locale_widgets_locale_setting_link_row_get_icon_name (SwitchboardPlugLocaleWidgetsLocaleSettingLinkRow* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_icon_name;
	result = _tmp0_;
	return result;
}

static void
switchboard_plug_locale_widgets_locale_setting_link_row_set_icon_name (SwitchboardPlugLocaleWidgetsLocaleSettingLinkRow* self,
                                                                       const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = switchboard_plug_locale_widgets_locale_setting_link_row_get_icon_name (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_icon_name);
		self->priv->_icon_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, switchboard_plug_locale_widgets_locale_setting_link_row_properties[SWITCHBOARD_PLUG_LOCALE_WIDGETS_LOCALE_SETTING_LINK_ROW_ICON_NAME_PROPERTY]);
	}
}

static const gchar*
switchboard_plug_locale_widgets_locale_setting_link_row_get_label_string (SwitchboardPlugLocaleWidgetsLocaleSettingLinkRow* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_label_string;
	result = _tmp0_;
	return result;
}

static void
switchboard_plug_locale_widgets_locale_setting_link_row_set_label_string (SwitchboardPlugLocaleWidgetsLocaleSettingLinkRow* self,
                                                                          const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = switchboard_plug_locale_widgets_locale_setting_link_row_get_label_string (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_label_string);
		self->priv->_label_string = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, switchboard_plug_locale_widgets_locale_setting_link_row_properties[SWITCHBOARD_PLUG_LOCALE_WIDGETS_LOCALE_SETTING_LINK_ROW_LABEL_STRING_PROPERTY]);
	}
}

static const gchar*
switchboard_plug_locale_widgets_locale_setting_link_row_get_color (SwitchboardPlugLocaleWidgetsLocaleSettingLinkRow* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_color;
	result = _tmp0_;
	return result;
}

static void
switchboard_plug_locale_widgets_locale_setting_link_row_set_color (SwitchboardPlugLocaleWidgetsLocaleSettingLinkRow* self,
                                                                   const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = switchboard_plug_locale_widgets_locale_setting_link_row_get_color (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_color);
		self->priv->_color = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, switchboard_plug_locale_widgets_locale_setting_link_row_properties[SWITCHBOARD_PLUG_LOCALE_WIDGETS_LOCALE_SETTING_LINK_ROW_COLOR_PROPERTY]);
	}
}

static GObject *
switchboard_plug_locale_widgets_locale_setting_link_row_constructor (GType type,
                                                                     guint n_construct_properties,
                                                                     GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SwitchboardPlugLocaleWidgetsLocaleSettingLinkRow * self;
	GtkImage* image = NULL;
	const gchar* _tmp0_;
	GtkImage* _tmp1_ = NULL;
	GtkImage* _tmp2_;
	GtkImage* _tmp3_;
	const gchar* _tmp4_;
	GtkLabel* left_label = NULL;
	const gchar* _tmp5_;
	GtkLabel* _tmp6_ = NULL;
	GtkImage* link_image = NULL;
	GtkImage* _tmp7_;
	GtkBox* box = NULL;
	GtkBox* _tmp8_;
	GtkBox* _tmp9_;
	GtkImage* _tmp10_;
	GtkBox* _tmp11_;
	GtkLabel* _tmp12_;
	GtkBox* _tmp13_;
	GtkImage* _tmp14_;
	GtkBox* _tmp15_;
	parent_class = G_OBJECT_CLASS (switchboard_plug_locale_widgets_locale_setting_link_row_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SWITCHBOARD_PLUG_LOCALE_WIDGETS_LOCALE_SETTING_TYPE_LINK_ROW, SwitchboardPlugLocaleWidgetsLocaleSettingLinkRow);
	_tmp0_ = self->priv->_icon_name;
	_tmp1_ = (GtkImage*) gtk_image_new_from_icon_name (_tmp0_);
	gtk_image_set_pixel_size (_tmp1_, 16);
	g_object_ref_sink (_tmp1_);
	image = _tmp1_;
	_tmp2_ = image;
	gtk_widget_add_css_class ((GtkWidget*) _tmp2_, GRANITE_STYLE_CLASS_ACCENT);
	_tmp3_ = image;
	_tmp4_ = self->priv->_color;
	gtk_widget_add_css_class ((GtkWidget*) _tmp3_, _tmp4_);
	_tmp5_ = self->priv->_label_string;
	_tmp6_ = (GtkLabel*) gtk_label_new (_tmp5_);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp6_, TRUE);
	gtk_label_set_xalign (_tmp6_, (gfloat) 0);
	g_object_ref_sink (_tmp6_);
	left_label = _tmp6_;
	_tmp7_ = (GtkImage*) gtk_image_new_from_icon_name ("adw-external-link-symbolic");
	g_object_ref_sink (_tmp7_);
	link_image = _tmp7_;
	_tmp8_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp8_);
	box = _tmp8_;
	_tmp9_ = box;
	_tmp10_ = image;
	gtk_box_append (_tmp9_, (GtkWidget*) _tmp10_);
	_tmp11_ = box;
	_tmp12_ = left_label;
	gtk_box_append (_tmp11_, (GtkWidget*) _tmp12_);
	_tmp13_ = box;
	_tmp14_ = link_image;
	gtk_box_append (_tmp13_, (GtkWidget*) _tmp14_);
	_tmp15_ = box;
	gtk_list_box_row_set_child ((GtkListBoxRow*) self, (GtkWidget*) _tmp15_);
	gtk_widget_add_css_class ((GtkWidget*) self, "link");
	_g_object_unref0 (box);
	_g_object_unref0 (link_image);
	_g_object_unref0 (left_label);
	_g_object_unref0 (image);
	return obj;
}

static void
switchboard_plug_locale_widgets_locale_setting_link_row_base_init (SwitchboardPlugLocaleWidgetsLocaleSettingLinkRowClass * klass)
{
	gtk_widget_class_set_accessible_role (GTK_WIDGET_CLASS (klass), GTK_ACCESSIBLE_ROLE_LINK);
}

static void
switchboard_plug_locale_widgets_locale_setting_link_row_class_init (SwitchboardPlugLocaleWidgetsLocaleSettingLinkRowClass * klass,
                                                                    gpointer klass_data)
{
	switchboard_plug_locale_widgets_locale_setting_link_row_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SwitchboardPlugLocaleWidgetsLocaleSettingLinkRow_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_switchboard_plug_locale_widgets_locale_setting_link_row_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_switchboard_plug_locale_widgets_locale_setting_link_row_set_property;
	G_OBJECT_CLASS (klass)->constructor = switchboard_plug_locale_widgets_locale_setting_link_row_constructor;
	G_OBJECT_CLASS (klass)->finalize = switchboard_plug_locale_widgets_locale_setting_link_row_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SWITCHBOARD_PLUG_LOCALE_WIDGETS_LOCALE_SETTING_LINK_ROW_URI_PROPERTY, switchboard_plug_locale_widgets_locale_setting_link_row_properties[SWITCHBOARD_PLUG_LOCALE_WIDGETS_LOCALE_SETTING_LINK_ROW_URI_PROPERTY] = g_param_spec_string ("uri", "uri", "uri", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SWITCHBOARD_PLUG_LOCALE_WIDGETS_LOCALE_SETTING_LINK_ROW_ICON_NAME_PROPERTY, switchboard_plug_locale_widgets_locale_setting_link_row_properties[SWITCHBOARD_PLUG_LOCALE_WIDGETS_LOCALE_SETTING_LINK_ROW_ICON_NAME_PROPERTY] = g_param_spec_string ("icon-name", "icon-name", "icon-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SWITCHBOARD_PLUG_LOCALE_WIDGETS_LOCALE_SETTING_LINK_ROW_LABEL_STRING_PROPERTY, switchboard_plug_locale_widgets_locale_setting_link_row_properties[SWITCHBOARD_PLUG_LOCALE_WIDGETS_LOCALE_SETTING_LINK_ROW_LABEL_STRING_PROPERTY] = g_param_spec_string ("label-string", "label-string", "label-string", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SWITCHBOARD_PLUG_LOCALE_WIDGETS_LOCALE_SETTING_LINK_ROW_COLOR_PROPERTY, switchboard_plug_locale_widgets_locale_setting_link_row_properties[SWITCHBOARD_PLUG_LOCALE_WIDGETS_LOCALE_SETTING_LINK_ROW_COLOR_PROPERTY] = g_param_spec_string ("color", "color", "color", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}

static void
switchboard_plug_locale_widgets_locale_setting_link_row_instance_init (SwitchboardPlugLocaleWidgetsLocaleSettingLinkRow * self,
                                                                       gpointer klass)
{
	self->priv = switchboard_plug_locale_widgets_locale_setting_link_row_get_instance_private (self);
}

static void
switchboard_plug_locale_widgets_locale_setting_link_row_finalize (GObject * obj)
{
	SwitchboardPlugLocaleWidgetsLocaleSettingLinkRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SWITCHBOARD_PLUG_LOCALE_WIDGETS_LOCALE_SETTING_TYPE_LINK_ROW, SwitchboardPlugLocaleWidgetsLocaleSettingLinkRow);
	_g_free0 (self->priv->_uri);
	_g_free0 (self->priv->_icon_name);
	_g_free0 (self->priv->_label_string);
	_g_free0 (self->priv->_color);
	G_OBJECT_CLASS (switchboard_plug_locale_widgets_locale_setting_link_row_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
switchboard_plug_locale_widgets_locale_setting_link_row_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SwitchboardPlugLocaleWidgetsLocaleSettingLinkRowClass), (GBaseInitFunc) switchboard_plug_locale_widgets_locale_setting_link_row_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) switchboard_plug_locale_widgets_locale_setting_link_row_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SwitchboardPlugLocaleWidgetsLocaleSettingLinkRow), 0, (GInstanceInitFunc) switchboard_plug_locale_widgets_locale_setting_link_row_instance_init, NULL };
	GType switchboard_plug_locale_widgets_locale_setting_link_row_type_id;
	switchboard_plug_locale_widgets_locale_setting_link_row_type_id = g_type_register_static (gtk_list_box_row_get_type (), "SwitchboardPlugLocaleWidgetsLocaleSettingLinkRow", &g_define_type_info, 0);
	SwitchboardPlugLocaleWidgetsLocaleSettingLinkRow_private_offset = g_type_add_instance_private (switchboard_plug_locale_widgets_locale_setting_link_row_type_id, sizeof (SwitchboardPlugLocaleWidgetsLocaleSettingLinkRowPrivate));
	return switchboard_plug_locale_widgets_locale_setting_link_row_type_id;
}

static GType
switchboard_plug_locale_widgets_locale_setting_link_row_get_type (void)
{
	static gsize switchboard_plug_locale_widgets_locale_setting_link_row_type_id__once = 0;
	if (g_once_init_enter (&switchboard_plug_locale_widgets_locale_setting_link_row_type_id__once)) {
		GType switchboard_plug_locale_widgets_locale_setting_link_row_type_id;
		switchboard_plug_locale_widgets_locale_setting_link_row_type_id = switchboard_plug_locale_widgets_locale_setting_link_row_get_type_once ();
		g_once_init_leave (&switchboard_plug_locale_widgets_locale_setting_link_row_type_id__once, switchboard_plug_locale_widgets_locale_setting_link_row_type_id);
	}
	return switchboard_plug_locale_widgets_locale_setting_link_row_type_id__once;
}

static void
_vala_switchboard_plug_locale_widgets_locale_setting_link_row_get_property (GObject * object,
                                                                            guint property_id,
                                                                            GValue * value,
                                                                            GParamSpec * pspec)
{
	SwitchboardPlugLocaleWidgetsLocaleSettingLinkRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SWITCHBOARD_PLUG_LOCALE_WIDGETS_LOCALE_SETTING_TYPE_LINK_ROW, SwitchboardPlugLocaleWidgetsLocaleSettingLinkRow);
	switch (property_id) {
		case SWITCHBOARD_PLUG_LOCALE_WIDGETS_LOCALE_SETTING_LINK_ROW_URI_PROPERTY:
		g_value_set_string (value, switchboard_plug_locale_widgets_locale_setting_link_row_get_uri (self));
		break;
		case SWITCHBOARD_PLUG_LOCALE_WIDGETS_LOCALE_SETTING_LINK_ROW_ICON_NAME_PROPERTY:
		g_value_set_string (value, switchboard_plug_locale_widgets_locale_setting_link_row_get_icon_name (self));
		break;
		case SWITCHBOARD_PLUG_LOCALE_WIDGETS_LOCALE_SETTING_LINK_ROW_LABEL_STRING_PROPERTY:
		g_value_set_string (value, switchboard_plug_locale_widgets_locale_setting_link_row_get_label_string (self));
		break;
		case SWITCHBOARD_PLUG_LOCALE_WIDGETS_LOCALE_SETTING_LINK_ROW_COLOR_PROPERTY:
		g_value_set_string (value, switchboard_plug_locale_widgets_locale_setting_link_row_get_color (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_switchboard_plug_locale_widgets_locale_setting_link_row_set_property (GObject * object,
                                                                            guint property_id,
                                                                            const GValue * value,
                                                                            GParamSpec * pspec)
{
	SwitchboardPlugLocaleWidgetsLocaleSettingLinkRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SWITCHBOARD_PLUG_LOCALE_WIDGETS_LOCALE_SETTING_TYPE_LINK_ROW, SwitchboardPlugLocaleWidgetsLocaleSettingLinkRow);
	switch (property_id) {
		case SWITCHBOARD_PLUG_LOCALE_WIDGETS_LOCALE_SETTING_LINK_ROW_URI_PROPERTY:
		switchboard_plug_locale_widgets_locale_setting_link_row_set_uri (self, g_value_get_string (value));
		break;
		case SWITCHBOARD_PLUG_LOCALE_WIDGETS_LOCALE_SETTING_LINK_ROW_ICON_NAME_PROPERTY:
		switchboard_plug_locale_widgets_locale_setting_link_row_set_icon_name (self, g_value_get_string (value));
		break;
		case SWITCHBOARD_PLUG_LOCALE_WIDGETS_LOCALE_SETTING_LINK_ROW_LABEL_STRING_PROPERTY:
		switchboard_plug_locale_widgets_locale_setting_link_row_set_label_string (self, g_value_get_string (value));
		break;
		case SWITCHBOARD_PLUG_LOCALE_WIDGETS_LOCALE_SETTING_LINK_ROW_COLOR_PROPERTY:
		switchboard_plug_locale_widgets_locale_setting_link_row_set_color (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static Block6Data*
block6_data_ref (Block6Data* _data6_)
{
	g_atomic_int_inc (&_data6_->_ref_count_);
	return _data6_;
}

static void
block6_data_unref (void * _userdata_)
{
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
		SwitchboardPlugLocaleWidgetsLocaleSetting* self;
		self = _data6_->self;
		_g_object_unref0 (self);
		g_slice_free (Block6Data, _data6_);
	}
}

static gpointer
_gtk_expression_ref0 (gpointer self)
{
	return self ? gtk_expression_ref (self) : NULL;
}

static void
_switchboard_plug_locale_widgets_locale_setting_compare_g_object_notify (GObject* _sender,
                                                                         GParamSpec* pspec,
                                                                         gpointer self)
{
	switchboard_plug_locale_widgets_locale_setting_compare ((SwitchboardPlugLocaleWidgetsLocaleSetting*) self);
}

static void
_switchboard_plug_locale_widgets_locale_setting___lambda11_ (SwitchboardPlugLocaleWidgetsLocaleSetting* self)
{
	switchboard_plug_locale_widgets_locale_setting_on_format_changed (self);
	switchboard_plug_locale_widgets_locale_setting_compare (self);
}

static void
__switchboard_plug_locale_widgets_locale_setting___lambda11__g_object_notify (GObject* _sender,
                                                                              GParamSpec* pspec,
                                                                              gpointer self)
{
	_switchboard_plug_locale_widgets_locale_setting___lambda11_ ((SwitchboardPlugLocaleWidgetsLocaleSetting*) self);
}

static void
_vala_GValue_array_free (GValue * array,
                         gssize array_length)
{
	if (array != NULL) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			g_value_unset (&array[i]);
		}
	}
	g_free (array);
}

static Block7Data*
block7_data_ref (Block7Data* _data7_)
{
	g_atomic_int_inc (&_data7_->_ref_count_);
	return _data7_;
}

static void
block7_data_unref (void * _userdata_)
{
	Block7Data* _data7_;
	_data7_ = (Block7Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
		SwitchboardPlugLocaleWidgetsLocaleSetting* self;
		self = _data7_->_data6_->self;
		_g_object_unref0 (_data7_->auto_radio);
		_g_object_unref0 (_data7_->fahrenheit_radio);
		_g_object_unref0 (_data7_->celcius_radio);
		block6_data_unref (_data7_->_data6_);
		_data7_->_data6_ = NULL;
		g_slice_free (Block7Data, _data7_);
	}
}

static void
_switchboard_plug_locale_widgets_locale_setting____lambda12_ (Block7Data* _data7_)
{
	Block6Data* _data6_;
	SwitchboardPlugLocaleWidgetsLocaleSetting* self;
	GtkCheckButton* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	_data6_ = _data7_->_data6_;
	self = _data6_->self;
	_tmp0_ = _data7_->auto_radio;
	_tmp1_ = gtk_check_button_get_active (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		GSettings* _tmp3_;
		_tmp3_ = switchboard_plug_locale_widgets_locale_setting_temperature_settings;
		g_settings_set_string (_tmp3_, "temperature-unit", "default");
	}
}

static void
__switchboard_plug_locale_widgets_locale_setting____lambda12__gtk_check_button_toggled (GtkCheckButton* _sender,
                                                                                        gpointer self)
{
	_switchboard_plug_locale_widgets_locale_setting____lambda12_ (self);
}

static void
_switchboard_plug_locale_widgets_locale_setting____lambda13_ (Block7Data* _data7_)
{
	Block6Data* _data6_;
	SwitchboardPlugLocaleWidgetsLocaleSetting* self;
	GtkCheckButton* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	_data6_ = _data7_->_data6_;
	self = _data6_->self;
	_tmp0_ = _data7_->celcius_radio;
	_tmp1_ = gtk_check_button_get_active (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		GSettings* _tmp3_;
		_tmp3_ = switchboard_plug_locale_widgets_locale_setting_temperature_settings;
		g_settings_set_string (_tmp3_, "temperature-unit", "centigrade");
	}
}

static void
__switchboard_plug_locale_widgets_locale_setting____lambda13__gtk_check_button_toggled (GtkCheckButton* _sender,
                                                                                        gpointer self)
{
	_switchboard_plug_locale_widgets_locale_setting____lambda13_ (self);
}

static void
_switchboard_plug_locale_widgets_locale_setting____lambda14_ (Block7Data* _data7_)
{
	Block6Data* _data6_;
	SwitchboardPlugLocaleWidgetsLocaleSetting* self;
	GtkCheckButton* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	_data6_ = _data7_->_data6_;
	self = _data6_->self;
	_tmp0_ = _data7_->fahrenheit_radio;
	_tmp1_ = gtk_check_button_get_active (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		GSettings* _tmp3_;
		_tmp3_ = switchboard_plug_locale_widgets_locale_setting_temperature_settings;
		g_settings_set_string (_tmp3_, "temperature-unit", "fahrenheit");
	}
}

static void
__switchboard_plug_locale_widgets_locale_setting____lambda14__gtk_check_button_toggled (GtkCheckButton* _sender,
                                                                                        gpointer self)
{
	_switchboard_plug_locale_widgets_locale_setting____lambda14_ (self);
}

static void
__lambda16_ (Block6Data* _data6_,
             GObject* obj,
             GAsyncResult* res)
{
	SwitchboardPlugLocaleWidgetsLocaleSetting* self;
	GError* _inner_error0_ = NULL;
	self = _data6_->self;
	g_return_if_fail (res != NULL);
	{
		SwitchboardPlugLocaleInstallerUbuntuInstaller* _tmp0_;
		_tmp0_ = _data6_->installer;
		switchboard_plug_locale_installer_ubuntu_installer_install_missing_languages_finish (_tmp0_, res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GtkInfoBar* _tmp1_;
		GError* _tmp2_;
		GraniteMessageDialog* dialog = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		GThemedIcon* _tmp5_;
		GThemedIcon* _tmp6_;
		GThemedIcon* _tmp7_;
		GApplication* _tmp8_;
		GtkWindow* _tmp9_;
		GtkWindow* _tmp10_;
		GtkWindow* _tmp11_;
		GraniteMessageDialog* _tmp12_ = NULL;
		GraniteMessageDialog* _tmp13_;
		GraniteMessageDialog* _tmp14_;
		GraniteMessageDialog* _tmp15_;
		GraniteMessageDialog* _tmp16_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = self->priv->missing_lang_infobar;
		gtk_info_bar_set_revealed (_tmp1_, TRUE);
		_tmp2_ = e;
		if (g_error_matches (_tmp2_, g_dbus_error_quark (), G_DBUS_ERROR_ACCESS_DENIED)) {
			_g_error_free0 (e);
			return;
		}
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		_tmp5_ = (GThemedIcon*) g_themed_icon_new ("preferences-desktop-locale");
		_tmp6_ = _tmp5_;
		_tmp7_ = (GThemedIcon*) g_themed_icon_new ("dialog-error");
		_tmp8_ = g_application_get_default ();
		_tmp9_ = gtk_application_get_active_window (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_application_get_type (), GtkApplication));
		_tmp10_ = _tmp9_;
		_tmp11_ = _g_object_ref0 (_tmp10_);
		_tmp12_ = granite_message_dialog_new (_ ("Couldn't install missing language packs"), _tmp4_, (GIcon*) _tmp6_, GTK_BUTTONS_CLOSE);
		granite_message_dialog_set_badge_icon (_tmp12_, (GIcon*) _tmp7_);
		_g_object_unref0 (_tmp7_);
		gtk_window_set_modal ((GtkWindow*) _tmp12_, TRUE);
		gtk_window_set_transient_for ((GtkWindow*) _tmp12_, _tmp11_);
		_g_object_unref0 (_tmp11_);
		g_object_ref_sink (_tmp12_);
		_tmp13_ = _tmp12_;
		_g_object_unref0 (_tmp6_);
		dialog = _tmp13_;
		_tmp14_ = dialog;
		gtk_window_present ((GtkWindow*) _tmp14_);
		_tmp15_ = dialog;
		_tmp16_ = dialog;
		g_signal_connect_object ((GtkDialog*) _tmp15_, "response", (GCallback) _gtk_window_destroy_gtk_dialog_response, (GtkWindow*) _tmp16_, 0);
		_g_object_unref0 (dialog);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda16__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda16_ (self, source_object, res);
	block6_data_unref (self);
}

static void
_switchboard_plug_locale_widgets_locale_setting___lambda15_ (Block6Data* _data6_)
{
	SwitchboardPlugLocaleWidgetsLocaleSetting* self;
	GtkInfoBar* _tmp0_;
	SwitchboardPlugLocaleInstallerUbuntuInstaller* _tmp1_;
	self = _data6_->self;
	_tmp0_ = self->priv->missing_lang_infobar;
	gtk_info_bar_set_revealed (_tmp0_, FALSE);
	_tmp1_ = _data6_->installer;
	switchboard_plug_locale_installer_ubuntu_installer_install_missing_languages (_tmp1_, ___lambda16__gasync_ready_callback, block6_data_ref (_data6_));
}

static void
__switchboard_plug_locale_widgets_locale_setting___lambda15__gtk_info_bar_response (GtkInfoBar* _sender,
                                                                                    gint response_id,
                                                                                    gpointer self)
{
	_switchboard_plug_locale_widgets_locale_setting___lambda15_ (self);
}

static void
_switchboard_plug_locale_widgets_locale_setting___lambda17_ (SwitchboardPlugLocaleWidgetsLocaleSetting* self,
                                                             GtkListBoxRow* row)
{
	GtkUriLauncher* uri_launcher = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GtkUriLauncher* _tmp2_;
	GtkUriLauncher* _tmp3_;
	GApplication* _tmp4_;
	GtkWindow* _tmp5_;
	GtkWindow* _tmp6_;
	g_return_if_fail (row != NULL);
	_tmp0_ = switchboard_plug_locale_widgets_locale_setting_link_row_get_uri (G_TYPE_CHECK_INSTANCE_CAST (row, SWITCHBOARD_PLUG_LOCALE_WIDGETS_LOCALE_SETTING_TYPE_LINK_ROW, SwitchboardPlugLocaleWidgetsLocaleSettingLinkRow));
	_tmp1_ = _tmp0_;
	_tmp2_ = gtk_uri_launcher_new (_tmp1_);
	uri_launcher = _tmp2_;
	_tmp3_ = uri_launcher;
	_tmp4_ = g_application_get_default ();
	_tmp5_ = gtk_application_get_active_window (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_application_get_type (), GtkApplication));
	_tmp6_ = _tmp5_;
	gtk_uri_launcher_launch (_tmp3_, _tmp6_, NULL, NULL, NULL);
	_g_object_unref0 (uri_launcher);
}

static void
__switchboard_plug_locale_widgets_locale_setting___lambda17__gtk_list_box_row_activated (GtkListBox* _sender,
                                                                                         GtkListBoxRow* row,
                                                                                         gpointer self)
{
	_switchboard_plug_locale_widgets_locale_setting___lambda17_ ((SwitchboardPlugLocaleWidgetsLocaleSetting*) self, row);
}

static void
_switchboard_plug_locale_widgets_locale_setting___lambda18_ (SwitchboardPlugLocaleWidgetsLocaleSetting* self)
{
	gchar* locale = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	SwitchboardPlugLocaleLocaleManager* _tmp2_;
	const gchar* _tmp3_;
	gchar* format = NULL;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	SwitchboardPlugLocaleLocaleManager* _tmp6_;
	const gchar* _tmp7_;
	GtkInfoBar* _tmp8_;
	_tmp0_ = switchboard_plug_locale_widgets_locale_setting_get_selected_locale (self);
	locale = _tmp0_;
	_tmp1_ = locale;
	g_debug ("LocaleSetting.vala:256: Setting user language to '%s'", _tmp1_);
	_tmp2_ = self->priv->lm;
	_tmp3_ = locale;
	switchboard_plug_locale_locale_manager_set_user_language (_tmp2_, _tmp3_);
	switchboard_plug_locale_widgets_locale_setting_compare (self);
	_tmp4_ = switchboard_plug_locale_widgets_locale_setting_get_format (self);
	format = _tmp4_;
	_tmp5_ = format;
	g_debug ("LocaleSetting.vala:262: Setting user format to '%s'", _tmp5_);
	_tmp6_ = self->priv->lm;
	_tmp7_ = format;
	switchboard_plug_locale_locale_manager_set_user_format (_tmp6_, _tmp7_);
	_tmp8_ = self->priv->restart_infobar;
	gtk_info_bar_set_revealed (_tmp8_, TRUE);
	_g_free0 (format);
	_g_free0 (locale);
}

static void
__switchboard_plug_locale_widgets_locale_setting___lambda18__gtk_button_clicked (GtkButton* _sender,
                                                                                 gpointer self)
{
	_switchboard_plug_locale_widgets_locale_setting___lambda18_ ((SwitchboardPlugLocaleWidgetsLocaleSetting*) self);
}

static void
_switchboard_plug_locale_widgets_locale_setting_on_applied_to_system_gtk_button_clicked (GtkButton* _sender,
                                                                                         gpointer self)
{
	switchboard_plug_locale_widgets_locale_setting_on_applied_to_system ((SwitchboardPlugLocaleWidgetsLocaleSetting*) self);
}

static void
_switchboard_plug_locale_widgets_locale_setting_on_check_missing_finished_switchboard_plug_locale_installer_ubuntu_installer_check_missing_finished (SwitchboardPlugLocaleInstallerUbuntuInstaller* _sender,
                                                                                                                                                     gchar** missing,
                                                                                                                                                     gint missing_length1,
                                                                                                                                                     gpointer self)
{
	switchboard_plug_locale_widgets_locale_setting_on_check_missing_finished ((SwitchboardPlugLocaleWidgetsLocaleSetting*) self, missing, missing_length1);
}

static GObject *
switchboard_plug_locale_widgets_locale_setting_constructor (GType type,
                                                            guint n_construct_properties,
                                                            GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SwitchboardPlugLocaleWidgetsLocaleSetting * self;
	Block6Data* _data6_;
	SwitchboardPlugLocaleLocaleManager* _tmp0_;
	SwitchboardPlugLocaleLocaleManager* _tmp1_;
	GListStore* _tmp2_;
	GListStore* _tmp3_;
	GtkPropertyExpression* expression = NULL;
	GtkPropertyExpression* _tmp4_;
	GListStore* _tmp5_;
	GListModel* _tmp6_;
	GtkPropertyExpression* _tmp7_;
	GtkExpression* _tmp8_;
	GtkDropDown* _tmp9_ = NULL;
	GtkDropDown* _tmp10_;
	GListStore* _tmp11_;
	GListModel* _tmp12_;
	GtkPropertyExpression* _tmp13_;
	GtkExpression* _tmp14_;
	GtkDropDown* _tmp15_ = NULL;
	GtkDropDown* _tmp16_;
	GraniteHeaderLabel* region_endlabel = NULL;
	GraniteHeaderLabel* _tmp17_;
	GtkDropDown* _tmp18_;
	GtkAccessibleProperty* _tmp19_;
	GtkAccessibleProperty* _tmp20_;
	gint _tmp20__length1;
	GraniteHeaderLabel* _tmp21_;
	const gchar* _tmp22_;
	const gchar* _tmp23_;
	GValue _tmp24_ = {0};
	GValue* _tmp25_;
	GValue* _tmp26_;
	gint _tmp26__length1;
	GraniteHeaderLabel* formats_label = NULL;
	GraniteHeaderLabel* _tmp27_;
	GtkDropDown* _tmp28_;
	GtkAccessibleProperty* _tmp29_;
	GtkAccessibleProperty* _tmp30_;
	gint _tmp30__length1;
	GraniteHeaderLabel* _tmp31_;
	const gchar* _tmp32_;
	const gchar* _tmp33_;
	GValue _tmp34_ = {0};
	GValue* _tmp35_;
	GValue* _tmp36_;
	gint _tmp36__length1;
	GtkBox* region_formats_box = NULL;
	GtkBox* _tmp37_;
	GtkBox* _tmp38_;
	GraniteHeaderLabel* _tmp39_;
	GtkBox* _tmp40_;
	GtkDropDown* _tmp41_;
	GtkBox* _tmp42_;
	GraniteHeaderLabel* _tmp43_;
	GtkBox* _tmp44_;
	GtkDropDown* _tmp45_;
	SwitchboardPlugLocaleWidgetsLocaleSettingLinkRow* layout_link = NULL;
	SwitchboardPlugLocaleWidgetsLocaleSettingLinkRow* _tmp46_;
	SwitchboardPlugLocaleWidgetsLocaleSettingLinkRow* datetime_link = NULL;
	SwitchboardPlugLocaleWidgetsLocaleSettingLinkRow* _tmp47_;
	GtkListBox* links_list = NULL;
	GtkListBox* _tmp48_ = NULL;
	GtkListBox* _tmp49_;
	GtkListBox* _tmp50_;
	GtkListBox* _tmp51_;
	SwitchboardPlugLocaleWidgetsLocaleSettingLinkRow* _tmp52_;
	GtkListBox* _tmp53_;
	SwitchboardPlugLocaleWidgetsLocaleSettingLinkRow* _tmp54_;
	SwitchboardPlugLocaleWidgetsPreview* _tmp55_ = NULL;
	SwitchboardPlugLocaleWidgetsPreview* _tmp56_;
	SwitchboardPlugLocaleWidgetsPreview* _tmp57_;
	GraniteHeaderLabel* preview_label = NULL;
	GraniteHeaderLabel* _tmp58_;
	GtkBox* preview_box = NULL;
	GtkBox* _tmp59_ = NULL;
	GtkBox* _tmp60_;
	GraniteHeaderLabel* _tmp61_;
	GtkBox* _tmp62_;
	SwitchboardPlugLocaleWidgetsPreview* _tmp63_;
	GtkLabel* missing_label = NULL;
	GtkLabel* _tmp64_;
	GtkInfoBar* _tmp65_ = NULL;
	GtkInfoBar* _tmp66_;
	GtkInfoBar* _tmp67_;
	GtkLabel* _tmp68_;
	GtkInfoBar* _tmp69_;
	GtkInfoBar* _tmp70_;
	GtkInfoBar* _tmp71_ = NULL;
	GtkInfoBar* _tmp72_;
	GtkLabel* _tmp73_;
	GtkLabel* _tmp74_;
	GtkInfoBar* _tmp75_;
	GtkInfoBar* _tmp76_;
	GtkBox* content_box = NULL;
	GtkBox* _tmp77_;
	GtkBox* _tmp78_;
	GtkInfoBar* _tmp79_;
	GtkBox* _tmp80_;
	GtkInfoBar* _tmp81_;
	GtkBox* _tmp82_;
	GtkBox* _tmp83_;
	GSettings* _tmp84_;
	GtkBox* _tmp144_;
	GtkListBox* _tmp145_;
	GtkBox* _tmp146_;
	GtkBox* _tmp147_;
	GtkBox* _tmp148_;
	GtkButton* _tmp149_;
	GtkButton* _tmp150_;
	GtkButton* _tmp151_;
	GtkButton* set_system_button = NULL;
	GtkButton* _tmp152_;
	GtkButton* _tmp153_;
	SwitchboardPlugLocaleInstallerUbuntuInstaller* _tmp154_;
	GtkInfoBar* _tmp155_;
	GtkListBox* _tmp156_;
	GtkButton* _tmp157_;
	GtkButton* _tmp158_;
	SwitchboardPlugLocaleInstallerUbuntuInstaller* _tmp159_;
	parent_class = G_OBJECT_CLASS (switchboard_plug_locale_widgets_locale_setting_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SWITCHBOARD_PLUG_LOCALE_WIDGETS_TYPE_LOCALE_SETTING, SwitchboardPlugLocaleWidgetsLocaleSetting);
	_data6_ = g_slice_new0 (Block6Data);
	_data6_->_ref_count_ = 1;
	_data6_->self = g_object_ref (self);
	gtk_widget_add_css_class ((GtkWidget*) self, "locale-setting");
	_tmp0_ = switchboard_plug_locale_locale_manager_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->lm);
	self->priv->lm = _tmp1_;
	_tmp2_ = g_list_store_new (SWITCHBOARD_PLUG_LOCALE_WIDGETS_LOCALE_SETTING_TYPE_LOCALE);
	_g_object_unref0 (self->priv->format_list);
	self->priv->format_list = _tmp2_;
	_tmp3_ = g_list_store_new (SWITCHBOARD_PLUG_LOCALE_WIDGETS_LOCALE_SETTING_TYPE_LOCALE);
	_g_object_unref0 (self->priv->locale_list);
	self->priv->locale_list = _tmp3_;
	_tmp4_ = (GtkPropertyExpression*) gtk_property_expression_new (SWITCHBOARD_PLUG_LOCALE_WIDGETS_LOCALE_SETTING_TYPE_LOCALE, NULL, "name");
	expression = _tmp4_;
	_tmp5_ = self->priv->locale_list;
	_tmp6_ = _g_object_ref0 ((GListModel*) _tmp5_);
	_tmp7_ = expression;
	_tmp8_ = _gtk_expression_ref0 ((GtkExpression*) _tmp7_);
	_tmp9_ = (GtkDropDown*) gtk_drop_down_new (_tmp6_, NULL);
	gtk_drop_down_set_enable_search (_tmp9_, TRUE);
	gtk_drop_down_set_expression (_tmp9_, _tmp8_);
	_gtk_expression_unref0 (_tmp8_);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp9_, TRUE);
	gtk_drop_down_set_search_match_mode (_tmp9_, GTK_STRING_FILTER_MATCH_MODE_SUBSTRING);
	g_object_ref_sink (_tmp9_);
	_g_object_unref0 (self->priv->region_dropdown);
	self->priv->region_dropdown = _tmp9_;
	_tmp10_ = self->priv->region_dropdown;
	g_signal_connect_object ((GObject*) _tmp10_, "notify::selected", (GCallback) _switchboard_plug_locale_widgets_locale_setting_compare_g_object_notify, self, 0);
	_tmp11_ = self->priv->format_list;
	_tmp12_ = _g_object_ref0 ((GListModel*) _tmp11_);
	_tmp13_ = expression;
	_tmp14_ = _gtk_expression_ref0 ((GtkExpression*) _tmp13_);
	_tmp15_ = (GtkDropDown*) gtk_drop_down_new (_tmp12_, NULL);
	gtk_drop_down_set_enable_search (_tmp15_, TRUE);
	gtk_drop_down_set_expression (_tmp15_, _tmp14_);
	_gtk_expression_unref0 (_tmp14_);
	gtk_drop_down_set_search_match_mode (_tmp15_, GTK_STRING_FILTER_MATCH_MODE_SUBSTRING);
	g_object_ref_sink (_tmp15_);
	_g_object_unref0 (self->priv->format_dropdown);
	self->priv->format_dropdown = _tmp15_;
	_tmp16_ = self->priv->format_dropdown;
	g_signal_connect_object ((GObject*) _tmp16_, "notify::selected", (GCallback) __switchboard_plug_locale_widgets_locale_setting___lambda11__g_object_notify, self, 0);
	_tmp17_ = granite_header_label_new (_ ("Region"));
	g_object_ref_sink (_tmp17_);
	region_endlabel = _tmp17_;
	_tmp18_ = self->priv->region_dropdown;
	_tmp19_ = g_new0 (GtkAccessibleProperty, 1);
	_tmp19_[0] = GTK_ACCESSIBLE_PROPERTY_DESCRIPTION;
	_tmp20_ = _tmp19_;
	_tmp20__length1 = 1;
	_tmp21_ = region_endlabel;
	_tmp22_ = granite_header_label_get_label (_tmp21_);
	_tmp23_ = _tmp22_;
	g_value_init (&_tmp24_, G_TYPE_STRING);
	g_value_set_string (&_tmp24_, _tmp23_);
	_tmp25_ = g_new0 (GValue, 1);
	_tmp25_[0] = _tmp24_;
	_tmp26_ = _tmp25_;
	_tmp26__length1 = 1;
	gtk_accessible_update_property_value ((GtkAccessible*) _tmp18_, (gint) 1, _tmp20_, _tmp26_);
	_tmp26_ = (_vala_GValue_array_free (_tmp26_, _tmp26__length1), NULL);
	_tmp20_ = (g_free (_tmp20_), NULL);
	_tmp27_ = granite_header_label_new (_ ("Formats"));
	g_object_ref_sink (_tmp27_);
	formats_label = _tmp27_;
	_tmp28_ = self->priv->format_dropdown;
	_tmp29_ = g_new0 (GtkAccessibleProperty, 1);
	_tmp29_[0] = GTK_ACCESSIBLE_PROPERTY_DESCRIPTION;
	_tmp30_ = _tmp29_;
	_tmp30__length1 = 1;
	_tmp31_ = formats_label;
	_tmp32_ = granite_header_label_get_label (_tmp31_);
	_tmp33_ = _tmp32_;
	g_value_init (&_tmp34_, G_TYPE_STRING);
	g_value_set_string (&_tmp34_, _tmp33_);
	_tmp35_ = g_new0 (GValue, 1);
	_tmp35_[0] = _tmp34_;
	_tmp36_ = _tmp35_;
	_tmp36__length1 = 1;
	gtk_accessible_update_property_value ((GtkAccessible*) _tmp28_, (gint) 1, _tmp30_, _tmp36_);
	_tmp36_ = (_vala_GValue_array_free (_tmp36_, _tmp36__length1), NULL);
	_tmp30_ = (g_free (_tmp30_), NULL);
	_tmp37_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 6);
	g_object_ref_sink (_tmp37_);
	region_formats_box = _tmp37_;
	_tmp38_ = region_formats_box;
	_tmp39_ = region_endlabel;
	gtk_box_append (_tmp38_, (GtkWidget*) _tmp39_);
	_tmp40_ = region_formats_box;
	_tmp41_ = self->priv->region_dropdown;
	gtk_box_append (_tmp40_, (GtkWidget*) _tmp41_);
	_tmp42_ = region_formats_box;
	_tmp43_ = formats_label;
	gtk_box_append (_tmp42_, (GtkWidget*) _tmp43_);
	_tmp44_ = region_formats_box;
	_tmp45_ = self->priv->format_dropdown;
	gtk_box_append (_tmp44_, (GtkWidget*) _tmp45_);
	_tmp46_ = switchboard_plug_locale_widgets_locale_setting_link_row_new ("settings://input/keyboard/layout", _ ("Keyboard layout settings…"), "preferences-desktop-keyboard-symbolic", "slate");
	g_object_ref_sink (_tmp46_);
	layout_link = _tmp46_;
	_tmp47_ = switchboard_plug_locale_widgets_locale_setting_link_row_new ("settings://time", _ ("Time format settings…"), "preferences-system-time-symbolic", "slate");
	g_object_ref_sink (_tmp47_);
	datetime_link = _tmp47_;
	_tmp48_ = (GtkListBox*) gtk_list_box_new ();
	gtk_widget_set_margin_top ((GtkWidget*) _tmp48_, 24);
	gtk_widget_set_valign ((GtkWidget*) _tmp48_, GTK_ALIGN_CENTER);
	gtk_list_box_set_show_separators (_tmp48_, TRUE);
	gtk_list_box_set_selection_mode (_tmp48_, GTK_SELECTION_NONE);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp48_, TRUE);
	g_object_ref_sink (_tmp48_);
	links_list = _tmp48_;
	_tmp49_ = links_list;
	gtk_widget_add_css_class ((GtkWidget*) _tmp49_, "boxed-list");
	_tmp50_ = links_list;
	gtk_widget_add_css_class ((GtkWidget*) _tmp50_, GRANITE_STYLE_CLASS_RICH_LIST);
	_tmp51_ = links_list;
	_tmp52_ = layout_link;
	gtk_list_box_append (_tmp51_, (GtkWidget*) _tmp52_);
	_tmp53_ = links_list;
	_tmp54_ = datetime_link;
	gtk_list_box_append (_tmp53_, (GtkWidget*) _tmp54_);
	_tmp55_ = switchboard_plug_locale_widgets_preview_new ();
	gtk_widget_set_halign ((GtkWidget*) _tmp55_, GTK_ALIGN_CENTER);
	g_object_ref_sink (_tmp55_);
	_g_object_unref0 (self->priv->preview);
	self->priv->preview = _tmp55_;
	_tmp56_ = self->priv->preview;
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp56_, 12);
	_tmp57_ = self->priv->preview;
	gtk_widget_set_margin_top ((GtkWidget*) _tmp57_, 12);
	_tmp58_ = granite_header_label_new (_ ("Preview"));
	g_object_ref_sink (_tmp58_);
	preview_label = _tmp58_;
	_tmp59_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 6);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp59_, 24);
	g_object_ref_sink (_tmp59_);
	preview_box = _tmp59_;
	_tmp60_ = preview_box;
	_tmp61_ = preview_label;
	gtk_box_append (_tmp60_, (GtkWidget*) _tmp61_);
	_tmp62_ = preview_box;
	_tmp63_ = self->priv->preview;
	gtk_box_append (_tmp62_, (GtkWidget*) _tmp63_);
	_tmp64_ = (GtkLabel*) gtk_label_new (_ ("Language support is not installed completely"));
	g_object_ref_sink (_tmp64_);
	missing_label = _tmp64_;
	_tmp65_ = (GtkInfoBar*) gtk_info_bar_new ();
	gtk_info_bar_set_message_type (_tmp65_, GTK_MESSAGE_WARNING);
	gtk_info_bar_set_revealed (_tmp65_, FALSE);
	g_object_ref_sink (_tmp65_);
	_g_object_unref0 (self->priv->missing_lang_infobar);
	self->priv->missing_lang_infobar = _tmp65_;
	_tmp66_ = self->priv->missing_lang_infobar;
	gtk_info_bar_add_button (_tmp66_, _ ("Complete Installation"), 0);
	_tmp67_ = self->priv->missing_lang_infobar;
	_tmp68_ = missing_label;
	gtk_info_bar_add_child (_tmp67_, (GtkWidget*) _tmp68_);
	_tmp69_ = self->priv->missing_lang_infobar;
	gtk_widget_add_css_class ((GtkWidget*) _tmp69_, GRANITE_STYLE_CLASS_FRAME);
	_tmp70_ = self->priv->missing_lang_infobar;
	gtk_widget_add_css_class ((GtkWidget*) _tmp70_, "infobar-margin");
	_tmp71_ = (GtkInfoBar*) gtk_info_bar_new ();
	gtk_info_bar_set_message_type (_tmp71_, GTK_MESSAGE_WARNING);
	gtk_info_bar_set_revealed (_tmp71_, FALSE);
	g_object_ref_sink (_tmp71_);
	_g_object_unref0 (self->priv->restart_infobar);
	self->priv->restart_infobar = _tmp71_;
	_tmp72_ = self->priv->restart_infobar;
	_tmp73_ = (GtkLabel*) gtk_label_new (_ ("Some changes will not take effect until you log out"));
	g_object_ref_sink (_tmp73_);
	_tmp74_ = _tmp73_;
	gtk_info_bar_add_child (_tmp72_, (GtkWidget*) _tmp74_);
	_g_object_unref0 (_tmp74_);
	_tmp75_ = self->priv->restart_infobar;
	gtk_widget_add_css_class ((GtkWidget*) _tmp75_, GRANITE_STYLE_CLASS_FRAME);
	_tmp76_ = self->priv->restart_infobar;
	gtk_widget_add_css_class ((GtkWidget*) _tmp76_, "infobar-margin");
	_tmp77_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp77_);
	content_box = _tmp77_;
	_tmp78_ = content_box;
	_tmp79_ = self->priv->missing_lang_infobar;
	gtk_box_append (_tmp78_, (GtkWidget*) _tmp79_);
	_tmp80_ = content_box;
	_tmp81_ = self->priv->restart_infobar;
	gtk_box_append (_tmp80_, (GtkWidget*) _tmp81_);
	_tmp82_ = content_box;
	_tmp83_ = region_formats_box;
	gtk_box_append (_tmp82_, (GtkWidget*) _tmp83_);
	_tmp84_ = switchboard_plug_locale_widgets_locale_setting_temperature_settings;
	if (_tmp84_ != NULL) {
		Block7Data* _data7_;
		GraniteHeaderLabel* temperature_label = NULL;
		GraniteHeaderLabel* _tmp85_;
		GtkCheckButton* _tmp86_;
		GtkCheckButton* _tmp87_;
		GtkAccessibleProperty* _tmp88_;
		GtkAccessibleProperty* _tmp89_;
		gint _tmp89__length1;
		GraniteHeaderLabel* _tmp90_;
		const gchar* _tmp91_;
		const gchar* _tmp92_;
		GValue _tmp93_ = {0};
		GValue* _tmp94_;
		GValue* _tmp95_;
		gint _tmp95__length1;
		GtkCheckButton* _tmp96_;
		GtkCheckButton* _tmp97_;
		GtkCheckButton* _tmp98_ = NULL;
		GtkCheckButton* _tmp99_;
		GtkAccessibleProperty* _tmp100_;
		GtkAccessibleProperty* _tmp101_;
		gint _tmp101__length1;
		GraniteHeaderLabel* _tmp102_;
		const gchar* _tmp103_;
		const gchar* _tmp104_;
		GValue _tmp105_ = {0};
		GValue* _tmp106_;
		GValue* _tmp107_;
		gint _tmp107__length1;
		GtkCheckButton* _tmp108_;
		GtkCheckButton* _tmp109_;
		GtkCheckButton* _tmp110_ = NULL;
		GtkCheckButton* _tmp111_;
		GtkAccessibleProperty* _tmp112_;
		GtkAccessibleProperty* _tmp113_;
		gint _tmp113__length1;
		GraniteHeaderLabel* _tmp114_;
		const gchar* _tmp115_;
		const gchar* _tmp116_;
		GValue _tmp117_ = {0};
		GValue* _tmp118_;
		GValue* _tmp119_;
		gint _tmp119__length1;
		GtkBox* temperature_radio_box = NULL;
		GtkBox* _tmp120_;
		GtkBox* _tmp121_;
		GtkCheckButton* _tmp122_;
		GtkBox* _tmp123_;
		GtkCheckButton* _tmp124_;
		GtkBox* _tmp125_;
		GtkCheckButton* _tmp126_;
		GtkBox* temperature_box = NULL;
		GtkBox* _tmp127_ = NULL;
		GtkBox* _tmp128_;
		GraniteHeaderLabel* _tmp129_;
		GtkBox* _tmp130_;
		GtkBox* _tmp131_;
		GtkBox* _tmp132_;
		GtkBox* _tmp133_;
		gchar* temp_setting = NULL;
		GSettings* _tmp134_;
		gchar* _tmp135_;
		const gchar* _tmp136_;
		GtkCheckButton* _tmp141_;
		GtkCheckButton* _tmp142_;
		GtkCheckButton* _tmp143_;
		_data7_ = g_slice_new0 (Block7Data);
		_data7_->_ref_count_ = 1;
		_data7_->_data6_ = block6_data_ref (_data6_);
		_tmp85_ = granite_header_label_new (_ ("Temperature"));
		g_object_ref_sink (_tmp85_);
		temperature_label = _tmp85_;
		_tmp86_ = (GtkCheckButton*) gtk_check_button_new_with_label (_ ("Celsius"));
		g_object_ref_sink (_tmp86_);
		_data7_->celcius_radio = _tmp86_;
		_tmp87_ = _data7_->celcius_radio;
		_tmp88_ = g_new0 (GtkAccessibleProperty, 1);
		_tmp88_[0] = GTK_ACCESSIBLE_PROPERTY_DESCRIPTION;
		_tmp89_ = _tmp88_;
		_tmp89__length1 = 1;
		_tmp90_ = temperature_label;
		_tmp91_ = granite_header_label_get_label (_tmp90_);
		_tmp92_ = _tmp91_;
		g_value_init (&_tmp93_, G_TYPE_STRING);
		g_value_set_string (&_tmp93_, _tmp92_);
		_tmp94_ = g_new0 (GValue, 1);
		_tmp94_[0] = _tmp93_;
		_tmp95_ = _tmp94_;
		_tmp95__length1 = 1;
		gtk_accessible_update_property_value ((GtkAccessible*) _tmp87_, (gint) 1, _tmp89_, _tmp95_);
		_tmp95_ = (_vala_GValue_array_free (_tmp95_, _tmp95__length1), NULL);
		_tmp89_ = (g_free (_tmp89_), NULL);
		_tmp96_ = _data7_->celcius_radio;
		_tmp97_ = _g_object_ref0 (_tmp96_);
		_tmp98_ = (GtkCheckButton*) gtk_check_button_new_with_label (_ ("Fahrenheit"));
		gtk_check_button_set_group (_tmp98_, _tmp97_);
		_g_object_unref0 (_tmp97_);
		g_object_ref_sink (_tmp98_);
		_data7_->fahrenheit_radio = _tmp98_;
		_tmp99_ = _data7_->fahrenheit_radio;
		_tmp100_ = g_new0 (GtkAccessibleProperty, 1);
		_tmp100_[0] = GTK_ACCESSIBLE_PROPERTY_DESCRIPTION;
		_tmp101_ = _tmp100_;
		_tmp101__length1 = 1;
		_tmp102_ = temperature_label;
		_tmp103_ = granite_header_label_get_label (_tmp102_);
		_tmp104_ = _tmp103_;
		g_value_init (&_tmp105_, G_TYPE_STRING);
		g_value_set_string (&_tmp105_, _tmp104_);
		_tmp106_ = g_new0 (GValue, 1);
		_tmp106_[0] = _tmp105_;
		_tmp107_ = _tmp106_;
		_tmp107__length1 = 1;
		gtk_accessible_update_property_value ((GtkAccessible*) _tmp99_, (gint) 1, _tmp101_, _tmp107_);
		_tmp107_ = (_vala_GValue_array_free (_tmp107_, _tmp107__length1), NULL);
		_tmp101_ = (g_free (_tmp101_), NULL);
		_tmp108_ = _data7_->celcius_radio;
		_tmp109_ = _g_object_ref0 (_tmp108_);
		_tmp110_ = (GtkCheckButton*) gtk_check_button_new_with_label (_ ("Automatic, based on locale"));
		gtk_check_button_set_group (_tmp110_, _tmp109_);
		_g_object_unref0 (_tmp109_);
		g_object_ref_sink (_tmp110_);
		_data7_->auto_radio = _tmp110_;
		_tmp111_ = _data7_->auto_radio;
		_tmp112_ = g_new0 (GtkAccessibleProperty, 1);
		_tmp112_[0] = GTK_ACCESSIBLE_PROPERTY_DESCRIPTION;
		_tmp113_ = _tmp112_;
		_tmp113__length1 = 1;
		_tmp114_ = temperature_label;
		_tmp115_ = granite_header_label_get_label (_tmp114_);
		_tmp116_ = _tmp115_;
		g_value_init (&_tmp117_, G_TYPE_STRING);
		g_value_set_string (&_tmp117_, _tmp116_);
		_tmp118_ = g_new0 (GValue, 1);
		_tmp118_[0] = _tmp117_;
		_tmp119_ = _tmp118_;
		_tmp119__length1 = 1;
		gtk_accessible_update_property_value ((GtkAccessible*) _tmp111_, (gint) 1, _tmp113_, _tmp119_);
		_tmp119_ = (_vala_GValue_array_free (_tmp119_, _tmp119__length1), NULL);
		_tmp113_ = (g_free (_tmp113_), NULL);
		_tmp120_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 6);
		g_object_ref_sink (_tmp120_);
		temperature_radio_box = _tmp120_;
		_tmp121_ = temperature_radio_box;
		_tmp122_ = _data7_->auto_radio;
		gtk_box_append (_tmp121_, (GtkWidget*) _tmp122_);
		_tmp123_ = temperature_radio_box;
		_tmp124_ = _data7_->celcius_radio;
		gtk_box_append (_tmp123_, (GtkWidget*) _tmp124_);
		_tmp125_ = temperature_radio_box;
		_tmp126_ = _data7_->fahrenheit_radio;
		gtk_box_append (_tmp125_, (GtkWidget*) _tmp126_);
		_tmp127_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 6);
		gtk_widget_set_margin_top ((GtkWidget*) _tmp127_, 24);
		g_object_ref_sink (_tmp127_);
		temperature_box = _tmp127_;
		_tmp128_ = temperature_box;
		_tmp129_ = temperature_label;
		gtk_box_append (_tmp128_, (GtkWidget*) _tmp129_);
		_tmp130_ = temperature_box;
		_tmp131_ = temperature_radio_box;
		gtk_box_append (_tmp130_, (GtkWidget*) _tmp131_);
		_tmp132_ = content_box;
		_tmp133_ = temperature_box;
		gtk_box_append (_tmp132_, (GtkWidget*) _tmp133_);
		_tmp134_ = switchboard_plug_locale_widgets_locale_setting_temperature_settings;
		_tmp135_ = g_settings_get_string (_tmp134_, "temperature-unit");
		temp_setting = _tmp135_;
		_tmp136_ = temp_setting;
		if (g_strcmp0 (_tmp136_, "centigrade") == 0) {
			GtkCheckButton* _tmp137_;
			_tmp137_ = _data7_->celcius_radio;
			gtk_check_button_set_active (_tmp137_, TRUE);
		} else {
			const gchar* _tmp138_;
			_tmp138_ = temp_setting;
			if (g_strcmp0 (_tmp138_, "fahrenheit") == 0) {
				GtkCheckButton* _tmp139_;
				_tmp139_ = _data7_->fahrenheit_radio;
				gtk_check_button_set_active (_tmp139_, TRUE);
			} else {
				GtkCheckButton* _tmp140_;
				_tmp140_ = _data7_->auto_radio;
				gtk_check_button_set_active (_tmp140_, TRUE);
			}
		}
		_tmp141_ = _data7_->auto_radio;
		g_signal_connect_data (_tmp141_, "toggled", (GCallback) __switchboard_plug_locale_widgets_locale_setting____lambda12__gtk_check_button_toggled, block7_data_ref (_data7_), (GClosureNotify) block7_data_unref, 0);
		_tmp142_ = _data7_->celcius_radio;
		g_signal_connect_data (_tmp142_, "toggled", (GCallback) __switchboard_plug_locale_widgets_locale_setting____lambda13__gtk_check_button_toggled, block7_data_ref (_data7_), (GClosureNotify) block7_data_unref, 0);
		_tmp143_ = _data7_->fahrenheit_radio;
		g_signal_connect_data (_tmp143_, "toggled", (GCallback) __switchboard_plug_locale_widgets_locale_setting____lambda14__gtk_check_button_toggled, block7_data_ref (_data7_), (GClosureNotify) block7_data_unref, 0);
		_g_free0 (temp_setting);
		_g_object_unref0 (temperature_box);
		_g_object_unref0 (temperature_radio_box);
		_g_object_unref0 (temperature_label);
		block7_data_unref (_data7_);
		_data7_ = NULL;
	}
	_tmp144_ = content_box;
	_tmp145_ = links_list;
	gtk_box_append (_tmp144_, (GtkWidget*) _tmp145_);
	_tmp146_ = content_box;
	_tmp147_ = preview_box;
	gtk_box_append (_tmp146_, (GtkWidget*) _tmp147_);
	_tmp148_ = content_box;
	switchboard_settings_page_set_child ((SwitchboardSettingsPage*) self, (GtkWidget*) _tmp148_);
	switchboard_settings_page_set_show_end_title_buttons ((SwitchboardSettingsPage*) self, TRUE);
	_tmp149_ = switchboard_settings_page_add_button ((SwitchboardSettingsPage*) self, _ ("Set Language"));
	_g_object_unref0 (self->priv->set_button);
	self->priv->set_button = _tmp149_;
	_tmp150_ = self->priv->set_button;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp150_, FALSE);
	_tmp151_ = self->priv->set_button;
	gtk_widget_add_css_class ((GtkWidget*) _tmp151_, GRANITE_STYLE_CLASS_SUGGESTED_ACTION);
	_tmp152_ = switchboard_settings_page_add_button ((SwitchboardSettingsPage*) self, _ ("Set System Language"));
	set_system_button = _tmp152_;
	_tmp153_ = set_system_button;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp153_, _ ("Set language for login screen, guest account and new user accounts"));
	_tmp154_ = switchboard_plug_locale_installer_ubuntu_installer_get_default ();
	_data6_->installer = _tmp154_;
	_tmp155_ = self->priv->missing_lang_infobar;
	g_signal_connect_data (_tmp155_, "response", (GCallback) __switchboard_plug_locale_widgets_locale_setting___lambda15__gtk_info_bar_response, block6_data_ref (_data6_), (GClosureNotify) block6_data_unref, 0);
	_tmp156_ = links_list;
	g_signal_connect_object (_tmp156_, "row-activated", (GCallback) __switchboard_plug_locale_widgets_locale_setting___lambda17__gtk_list_box_row_activated, self, 0);
	_tmp157_ = self->priv->set_button;
	g_signal_connect_object (_tmp157_, "clicked", (GCallback) __switchboard_plug_locale_widgets_locale_setting___lambda18__gtk_button_clicked, self, 0);
	_tmp158_ = set_system_button;
	g_signal_connect_object (_tmp158_, "clicked", (GCallback) _switchboard_plug_locale_widgets_locale_setting_on_applied_to_system_gtk_button_clicked, self, 0);
	_tmp159_ = _data6_->installer;
	g_signal_connect_object (_tmp159_, "check-missing-finished", (GCallback) _switchboard_plug_locale_widgets_locale_setting_on_check_missing_finished_switchboard_plug_locale_installer_ubuntu_installer_check_missing_finished, self, 0);
	_g_object_unref0 (set_system_button);
	_g_object_unref0 (content_box);
	_g_object_unref0 (missing_label);
	_g_object_unref0 (preview_box);
	_g_object_unref0 (preview_label);
	_g_object_unref0 (links_list);
	_g_object_unref0 (datetime_link);
	_g_object_unref0 (layout_link);
	_g_object_unref0 (region_formats_box);
	_g_object_unref0 (formats_label);
	_g_object_unref0 (region_endlabel);
	_gtk_expression_unref0 (expression);
	block6_data_unref (_data6_);
	_data6_ = NULL;
	return obj;
}

static void
switchboard_plug_locale_widgets_locale_setting_class_init (SwitchboardPlugLocaleWidgetsLocaleSettingClass * klass,
                                                           gpointer klass_data)
{
	GSettingsSchemaSource* _tmp0_;
	GSettingsSchema* _tmp1_;
	GSettingsSchema* _tmp2_;
	gboolean _tmp3_;
	GtkCssProvider* provider = NULL;
	GtkCssProvider* _tmp10_;
	GtkCssProvider* _tmp11_;
	GdkDisplay* _tmp12_;
	GtkCssProvider* _tmp13_;
	switchboard_plug_locale_widgets_locale_setting_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SwitchboardPlugLocaleWidgetsLocaleSetting_private_offset);
	G_OBJECT_CLASS (klass)->constructor = switchboard_plug_locale_widgets_locale_setting_constructor;
	G_OBJECT_CLASS (klass)->finalize = switchboard_plug_locale_widgets_locale_setting_finalize;
	_tmp0_ = g_settings_schema_source_get_default ();
	_tmp1_ = g_settings_schema_source_lookup (_tmp0_, "org.gnome.GWeather4", TRUE);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_ != NULL;
	_g_settings_schema_unref0 (_tmp2_);
	if (_tmp3_) {
		GSettings* _tmp4_;
		_tmp4_ = g_settings_new ("org.gnome.GWeather4");
		_g_object_unref0 (switchboard_plug_locale_widgets_locale_setting_temperature_settings);
		switchboard_plug_locale_widgets_locale_setting_temperature_settings = _tmp4_;
	} else {
		GSettingsSchemaSource* _tmp5_;
		GSettingsSchema* _tmp6_;
		GSettingsSchema* _tmp7_;
		gboolean _tmp8_;
		_tmp5_ = g_settings_schema_source_get_default ();
		_tmp6_ = g_settings_schema_source_lookup (_tmp5_, "org.gnome.GWeather", TRUE);
		_tmp7_ = _tmp6_;
		_tmp8_ = _tmp7_ != NULL;
		_g_settings_schema_unref0 (_tmp7_);
		if (_tmp8_) {
			GSettings* _tmp9_;
			_tmp9_ = g_settings_new ("org.gnome.GWeather");
			_g_object_unref0 (switchboard_plug_locale_widgets_locale_setting_temperature_settings);
			switchboard_plug_locale_widgets_locale_setting_temperature_settings = _tmp9_;
		}
	}
	_tmp10_ = gtk_css_provider_new ();
	provider = _tmp10_;
	_tmp11_ = provider;
	gtk_css_provider_load_from_resource (_tmp11_, "io/elementary/settings/locale/Plug.css");
	_tmp12_ = gdk_display_get_default ();
	_tmp13_ = provider;
	gtk_style_context_add_provider_for_display (_tmp12_, (GtkStyleProvider*) _tmp13_, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
	_g_object_unref0 (provider);
}

static void
switchboard_plug_locale_widgets_locale_setting_instance_init (SwitchboardPlugLocaleWidgetsLocaleSetting * self,
                                                              gpointer klass)
{
	self->priv = switchboard_plug_locale_widgets_locale_setting_get_instance_private (self);
}

static void
switchboard_plug_locale_widgets_locale_setting_finalize (GObject * obj)
{
	SwitchboardPlugLocaleWidgetsLocaleSetting * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SWITCHBOARD_PLUG_LOCALE_WIDGETS_TYPE_LOCALE_SETTING, SwitchboardPlugLocaleWidgetsLocaleSetting);
	_g_object_unref0 (self->priv->set_button);
	_g_object_unref0 (self->priv->missing_lang_infobar);
	_g_object_unref0 (self->priv->restart_infobar);
	_g_object_unref0 (self->priv->format_dropdown);
	_g_object_unref0 (self->priv->region_dropdown);
	_g_object_unref0 (self->priv->format_list);
	_g_object_unref0 (self->priv->locale_list);
	_g_object_unref0 (self->priv->lm);
	_g_object_unref0 (self->priv->preview);
	_g_free0 (self->priv->language);
	G_OBJECT_CLASS (switchboard_plug_locale_widgets_locale_setting_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
switchboard_plug_locale_widgets_locale_setting_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SwitchboardPlugLocaleWidgetsLocaleSettingClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) switchboard_plug_locale_widgets_locale_setting_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SwitchboardPlugLocaleWidgetsLocaleSetting), 0, (GInstanceInitFunc) switchboard_plug_locale_widgets_locale_setting_instance_init, NULL };
	GType switchboard_plug_locale_widgets_locale_setting_type_id;
	switchboard_plug_locale_widgets_locale_setting_type_id = g_type_register_static (SWITCHBOARD_TYPE_SETTINGS_PAGE, "SwitchboardPlugLocaleWidgetsLocaleSetting", &g_define_type_info, 0);
	SwitchboardPlugLocaleWidgetsLocaleSetting_private_offset = g_type_add_instance_private (switchboard_plug_locale_widgets_locale_setting_type_id, sizeof (SwitchboardPlugLocaleWidgetsLocaleSettingPrivate));
	return switchboard_plug_locale_widgets_locale_setting_type_id;
}

GType
switchboard_plug_locale_widgets_locale_setting_get_type (void)
{
	static gsize switchboard_plug_locale_widgets_locale_setting_type_id__once = 0;
	if (g_once_init_enter (&switchboard_plug_locale_widgets_locale_setting_type_id__once)) {
		GType switchboard_plug_locale_widgets_locale_setting_type_id;
		switchboard_plug_locale_widgets_locale_setting_type_id = switchboard_plug_locale_widgets_locale_setting_get_type_once ();
		g_once_init_leave (&switchboard_plug_locale_widgets_locale_setting_type_id__once, switchboard_plug_locale_widgets_locale_setting_type_id);
	}
	return switchboard_plug_locale_widgets_locale_setting_type_id__once;
}

