
#include <sbkpep.h>
#include <shiboken.h>
#include <sbkbindingutils.h>
#include <algorithm>
#include <signature.h>
#include <sbkcontainer.h>
#include <sbkstaticstrings.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysidecleanup.h>
#include <pysideqenum.h>
#include <feature_select.h>
#include <pysidestaticstrings.h>
#include "cutterbindings_python.h"

#include <QHash>
#include <QList>
#include <QMap>
#include <QString>
#include <qcolor.h>
#include <qvariant.h>


// Current module's type array.
Shiboken::Module::TypeInitStruct *SbkCutterBindingsTypeStructs = nullptr;
// Backwards compatible structure with identical indexing.
PyTypeObject **SbkCutterBindingsTypes = nullptr;
// Current module's converter array.
SbkConverter **SbkCutterBindingsTypeConverters = nullptr;

void cleanTypesAttributes() {
    static PyObject *attrName = Shiboken::PyName::qtStaticMetaObject();
    const int imax = SBK_CutterBindings_IDX_COUNT;
    for (int i = 0; i < imax && SbkCutterBindingsTypeStructs[i].fullName != nullptr; ++i) {
        auto *pyType = reinterpret_cast<PyObject *>(SbkCutterBindingsTypeStructs[i].type);
        if (pyType != nullptr && PyObject_HasAttr(pyType, attrName))
            PyObject_SetAttr(pyType, attrName, Py_None);
    }
}

// Global functions ------------------------------------------------------------

static PyMethodDef CutterBindingsMethods[] = {
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

// Classes initialization functions ------------------------------------------------------------
PyTypeObject *init_MainWindow(PyObject *enclosing);
PyTypeObject *init_CutterPlugin(PyObject *enclosing);
PyTypeObject *init_CutterDockWidget(PyObject *enclosing);
PyTypeObject *init_CutterCore(PyObject *enclosing);
PyTypeObject *init_Configuration(PyObject *enclosing);
PyTypeObject *init_BasicInstructionHighlighter(PyObject *enclosing);
PyTypeObject *init_BasicBlockHighlighter(PyObject *enclosing);
PyTypeObject *init_AddressableItemContextMenu(PyObject *enclosing);

// Required modules' type and converter arrays.
Shiboken::Module::TypeInitStruct *SbkPySide6_QtCoreTypeStructs;
SbkConverter **SbkPySide6_QtCoreTypeConverters;
Shiboken::Module::TypeInitStruct *SbkPySide6_QtGuiTypeStructs;
SbkConverter **SbkPySide6_QtGuiTypeConverters;
Shiboken::Module::TypeInitStruct *SbkPySide6_QtWidgetsTypeStructs;
SbkConverter **SbkPySide6_QtWidgetsTypeConverters;

// Module initialization ------------------------------------------------------------
// Container Type converters.

// C++ to Python conversion for container type 'QList<int>'.
static PyObject *_QList_int__CppToPython_PyList(const void *cppIn)
{
    const auto &cppInRef = *reinterpret_cast<const ::QList<int> *>(cppIn);
    // TEMPLATE - shiboken_conversion_cppsequence_to_pylist - START
    PyObject *pyOut = PyList_New(Py_ssize_t(cppInRef.size()));
    Py_ssize_t idx = 0;
    for (auto it = std::cbegin(cppInRef), end = std::cend(cppInRef); it != end; ++it, ++idx) {
        const auto &cppItem = *it;
        PyList_SetItem(pyOut, idx, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppItem));
    }
    return pyOut;
    // TEMPLATE - shiboken_conversion_cppsequence_to_pylist - END

}
static void PySequence_PythonToCpp__QList_int_(PyObject *pyIn, void *cppOut)
{
    auto &cppOutRef = *reinterpret_cast<::QList<int> *>(cppOut);
    // TEMPLATE - shiboken_conversion_pyiterable_to_cppsequentialcontainer_reserve - START
    (cppOutRef).clear();
    if (PyList_Check(pyIn)) {
        const Py_ssize_t size = PySequence_Size(pyIn);
        if (size > 10)
            (cppOutRef).reserve(size);
    }

    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    while (true) {
        Shiboken::AutoDecRef pyItem(PyIter_Next(it.object()));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        int cppItem;
    Shiboken::Conversions::pythonToCppCopy(Shiboken::Conversions::PrimitiveTypeConverter<int>(), pyItem, &(cppItem));
        (cppOutRef).push_back(cppItem);
    }
    // TEMPLATE - shiboken_conversion_pyiterable_to_cppsequentialcontainer_reserve - END

}
static PythonToCppFunc is_PySequence_PythonToCpp__QList_int__Convertible(PyObject *pyIn)
{
    if (Shiboken::Conversions::convertibleSequenceTypes(Shiboken::Conversions::PrimitiveTypeConverter<int>(), pyIn))
        return PySequence_PythonToCpp__QList_int_;
    return {};
}


// Binding for QList<int>

template <>
struct ShibokenContainerValueConverter<int>
{
    static bool checkValue(PyObject *pyArg)
    {
        return PyLong_Check(pyArg);
    }

    static PyObject *convertValueToPython(int cppArg)
    {
        return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppArg);
    }

    static std::optional<int> convertValueToCpp(PyObject *pyArg)
    {
        Shiboken::Conversions::PythonToCppConversion pythonToCpp;
        if (!(PyLong_Check(pyArg) && (pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg))))) {
            Shiboken::Errors::setWrongContainerType();
            return {};
        }
        int cppArg;
        pythonToCpp(pyArg, &cppArg);
        return cppArg;
    }
};

static PyMethodDef QIntList_methods[] = {
    {"push_back", reinterpret_cast<PyCFunction>(ShibokenSequenceContainerPrivate<QList<int>>::push_back), METH_O, "push_back"},
    {"append", reinterpret_cast<PyCFunction>(ShibokenSequenceContainerPrivate<QList<int>>::push_back), METH_O, "append"},
    {"clear", reinterpret_cast<PyCFunction>(ShibokenSequenceContainerPrivate<QList<int>>::clear), METH_NOARGS, "clear"},
    {"pop_back", reinterpret_cast<PyCFunction>(ShibokenSequenceContainerPrivate<QList<int>>::pop_back), METH_NOARGS, "pop_back"},
    {"removeLast", reinterpret_cast<PyCFunction>(ShibokenSequenceContainerPrivate<QList<int>>::pop_back), METH_NOARGS, "removeLast"},
    {"push_front", reinterpret_cast<PyCFunction>(ShibokenSequenceContainerPrivate<QList<int>>::push_front), METH_O, "push_front"},
    {"prepend", reinterpret_cast<PyCFunction>(ShibokenSequenceContainerPrivate<QList<int>>::push_front), METH_O, "prepend"},
    {"pop_front", reinterpret_cast<PyCFunction>(ShibokenSequenceContainerPrivate<QList<int>>::pop_front), METH_NOARGS, "pop_front"},
    {"removeFirst", reinterpret_cast<PyCFunction>(ShibokenSequenceContainerPrivate<QList<int>>::pop_front), METH_O, "removeFirst"},
    {"reserve", reinterpret_cast<PyCFunction>(ShibokenSequenceContainerPrivate<QList<int>>::reserve), METH_O, "reserve"},
    {"capacity", reinterpret_cast<PyCFunction>(ShibokenSequenceContainerPrivate<QList<int>>::capacity), METH_NOARGS, "capacity"},
    {"data", reinterpret_cast<PyCFunction>(ShibokenSequenceContainerPrivate<QList<int>>::data), METH_NOARGS, "data"},
    {"constData", reinterpret_cast<PyCFunction>(ShibokenSequenceContainerPrivate<QList<int>>::constData), METH_NOARGS, "constData"},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static PyType_Slot QIntList_slots[] = {
    {Py_tp_init, reinterpret_cast<void *>(ShibokenSequenceContainerPrivate<QList<int>>::tpInit)},
    {Py_tp_new, reinterpret_cast<void *>(ShibokenSequenceContainerPrivate<QList<int>>::tpNew)},
    {Py_tp_free, reinterpret_cast<void *>(ShibokenSequenceContainerPrivate<QList<int>>::tpFree)},
    {Py_tp_dealloc, reinterpret_cast<void *>(Sbk_object_dealloc)},
    {Py_tp_methods, reinterpret_cast<void *>(QIntList_methods)},
    {Py_sq_ass_item, reinterpret_cast<void *>(ShibokenSequenceContainerPrivate<QList<int>>::sqSetItem)},
    {Py_sq_length, reinterpret_cast<void *>(ShibokenSequenceContainerPrivate<QList<int>>::sqLen)},
    {Py_sq_item, reinterpret_cast<void *>(ShibokenSequenceContainerPrivate<QList<int>>::sqGetItem)},
    {0, nullptr}
};

static PyType_Spec QIntList_spec = {
    "1:CutterBindings.QIntList",
    sizeof(ShibokenContainer),
    0,
    Py_TPFLAGS_DEFAULT,
    QIntList_slots
};

static inline PyTypeObject *createQIntListType()
{
    auto *result = SbkType_FromSpec(&QIntList_spec);
    Py_INCREF(Py_True);
    Shiboken::AutoDecRef tpDict(PepType_GetDict(result));
    PyDict_SetItem(tpDict.object(), Shiboken::PyMagicName::opaque_container(), Py_True);
    return result;
}

static PyTypeObject *QIntList_TypeF()
{
    static PyTypeObject *type = createQIntListType();
    return type;
}

extern "C" PyObject *createQIntList(QList<int>* ct)
{
    auto *container = PyObject_New(ShibokenContainer, QIntList_TypeF());
    auto *d = new ShibokenSequenceContainerPrivate<QList<int>>();
    d->m_list = ct;
    container->d = d;
    return reinterpret_cast<PyObject *>(container);
}

extern "C" PyObject *createConstQIntList(const QList<int>* ct)
{
    auto *container = PyObject_New(ShibokenContainer, QIntList_TypeF());
    auto *d = new ShibokenSequenceContainerPrivate<QList<int>>();
    d->m_list = const_cast<QList<int> *>(ct);
    d->m_const = true;
    container->d = d;
    return reinterpret_cast<PyObject *>(container);
}

extern "C" int QIntList_Check(PyObject *pyArg)
{
    return pyArg != nullptr && pyArg != Py_None && pyArg->ob_type == QIntList_TypeF();
}

extern "C" void PythonToCppQIntList(PyObject *pyArg, void *cppOut)
{
    auto *d = ShibokenSequenceContainerPrivate<QList<int>>::get(pyArg);
    *reinterpret_cast<QList<int>**>(cppOut) = d->m_list;
}

extern "C" PythonToCppFunc isQIntListPythonToCppConvertible(PyObject *pyArg)
{
    if (QIntList_Check(pyArg))
        return PythonToCppQIntList;
    return {};
}

extern "C" void PythonToQVariantQIntList(PyObject *pyArg, void *cppOut)
{
    auto *d = ShibokenSequenceContainerPrivate<QList<int>>::get(pyArg);
    *reinterpret_cast<QVariant *>(cppOut) = QVariant::fromValue(*d->m_list);
}

extern "C" PythonToCppFunc isQIntListPythonToQVariantConvertible(PyObject *pyArg)
{
    if (QIntList_Check(pyArg))
        return PythonToQVariantQIntList;
    return {};
}

// C++ to Python conversion for container type 'QMap<QString,QVariant>'.
static PyObject *_QMap_QString_QVariant__CppToPython_PyDict(const void *cppIn)
{
    const auto &cppInRef = *reinterpret_cast<const ::QMap<QString,QVariant> *>(cppIn);
    // TEMPLATE - shiboken_conversion_qmap_to_pydict - START
    PyObject *pyOut = PyDict_New();
    for (auto it = std::cbegin(cppInRef), end = std::cend(cppInRef); it != end; ++it) {
        const auto &key = it.key();
        const auto &value = it.value();
        PyObject *pyKey = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &key);
        PyObject *pyValue = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QVariant_IDX], &value);
        PyDict_SetItem(pyOut, pyKey, pyValue);
        Py_DECREF(pyKey);
        Py_DECREF(pyValue);
    }
    return pyOut;
    // TEMPLATE - shiboken_conversion_qmap_to_pydict - END

}
static void PyDict_PythonToCpp__QMap_QString_QVariant_(PyObject *pyIn, void *cppOut)
{
    auto &cppOutRef = *reinterpret_cast<::QMap<QString,QVariant> *>(cppOut);
    // TEMPLATE - shiboken_conversion_pydict_to_qmap - START
    PyObject *key{};
    PyObject *value{};
    cppOutRef.clear();
    Py_ssize_t pos = 0;
    while (PyDict_Next(pyIn, &pos, &key, &value)) {
        ::QString cppKey;
    Shiboken::Conversions::pythonToCppCopy(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], key, &(cppKey));
        ::QVariant cppValue;
    Shiboken::Conversions::pythonToCppCopy(SbkPySide6_QtCoreTypeConverters[SBK_QVariant_IDX], value, &(cppValue));
        cppOutRef.insert(cppKey, cppValue);
    }
    // TEMPLATE - shiboken_conversion_pydict_to_qmap - END

}
static PythonToCppFunc is_PyDict_PythonToCpp__QMap_QString_QVariant__Convertible(PyObject *pyIn)
{
    if (Shiboken::Conversions::convertibleDictTypes(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], false, SbkPySide6_QtCoreTypeConverters[SBK_QVariant_IDX], false, pyIn))
        return PyDict_PythonToCpp__QMap_QString_QVariant_;
    return {};
}

// C++ to Python conversion for container type 'QList<QString>'.
static PyObject *_QList_QString__CppToPython_PyList(const void *cppIn)
{
    const auto &cppInRef = *reinterpret_cast<const ::QList<QString> *>(cppIn);
    // TEMPLATE - shiboken_conversion_cppsequence_to_pylist - START
    PyObject *pyOut = PyList_New(Py_ssize_t(cppInRef.size()));
    Py_ssize_t idx = 0;
    for (auto it = std::cbegin(cppInRef), end = std::cend(cppInRef); it != end; ++it, ++idx) {
        const auto &cppItem = *it;
        PyList_SetItem(pyOut, idx, Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppItem));
    }
    return pyOut;
    // TEMPLATE - shiboken_conversion_cppsequence_to_pylist - END

}
static void PySequence_PythonToCpp__QList_QString_(PyObject *pyIn, void *cppOut)
{
    auto &cppOutRef = *reinterpret_cast<::QList<QString> *>(cppOut);
    // TEMPLATE - shiboken_conversion_pyiterable_to_cppsequentialcontainer_reserve - START
    (cppOutRef).clear();
    if (PyList_Check(pyIn)) {
        const Py_ssize_t size = PySequence_Size(pyIn);
        if (size > 10)
            (cppOutRef).reserve(size);
    }

    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    while (true) {
        Shiboken::AutoDecRef pyItem(PyIter_Next(it.object()));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QString cppItem;
    Shiboken::Conversions::pythonToCppCopy(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], pyItem, &(cppItem));
        (cppOutRef).push_back(cppItem);
    }
    // TEMPLATE - shiboken_conversion_pyiterable_to_cppsequentialcontainer_reserve - END

}
static PythonToCppFunc is_PySequence_PythonToCpp__QList_QString__Convertible(PyObject *pyIn)
{
    if (Shiboken::Conversions::convertibleSequenceTypes(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], pyIn))
        return PySequence_PythonToCpp__QList_QString_;
    return {};
}

// C++ to Python conversion for container type 'QList<unsigned long long>'.
static PyObject *_QList_unsignedlonglong__CppToPython_PyList(const void *cppIn)
{
    const auto &cppInRef = *reinterpret_cast<const ::QList<unsigned long long> *>(cppIn);
    // TEMPLATE - shiboken_conversion_cppsequence_to_pylist - START
    PyObject *pyOut = PyList_New(Py_ssize_t(cppInRef.size()));
    Py_ssize_t idx = 0;
    for (auto it = std::cbegin(cppInRef), end = std::cend(cppInRef); it != end; ++it, ++idx) {
        const auto &cppItem = *it;
        PyList_SetItem(pyOut, idx, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long long>(), &cppItem));
    }
    return pyOut;
    // TEMPLATE - shiboken_conversion_cppsequence_to_pylist - END

}
static void PySequence_PythonToCpp__QList_unsignedlonglong_(PyObject *pyIn, void *cppOut)
{
    auto &cppOutRef = *reinterpret_cast<::QList<unsigned long long> *>(cppOut);
    // TEMPLATE - shiboken_conversion_pyiterable_to_cppsequentialcontainer_reserve - START
    (cppOutRef).clear();
    if (PyList_Check(pyIn)) {
        const Py_ssize_t size = PySequence_Size(pyIn);
        if (size > 10)
            (cppOutRef).reserve(size);
    }

    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    while (true) {
        Shiboken::AutoDecRef pyItem(PyIter_Next(it.object()));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        unsigned long long cppItem;
    Shiboken::Conversions::pythonToCppCopy(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long long>(), pyItem, &(cppItem));
        (cppOutRef).push_back(cppItem);
    }
    // TEMPLATE - shiboken_conversion_pyiterable_to_cppsequentialcontainer_reserve - END

}
static PythonToCppFunc is_PySequence_PythonToCpp__QList_unsignedlonglong__Convertible(PyObject *pyIn)
{
    if (Shiboken::Conversions::convertibleSequenceTypes(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long long>(), pyIn))
        return PySequence_PythonToCpp__QList_unsignedlonglong_;
    return {};
}

// C++ to Python conversion for container type 'QHash<QString,QColor>'.
static PyObject *_QHash_QString_QColor__CppToPython_PyDict(const void *cppIn)
{
    const auto &cppInRef = *reinterpret_cast<const ::QHash<QString,QColor> *>(cppIn);
    // TEMPLATE - shiboken_conversion_qmap_to_pydict - START
    PyObject *pyOut = PyDict_New();
    for (auto it = std::cbegin(cppInRef), end = std::cend(cppInRef); it != end; ++it) {
        const auto &key = it.key();
        const auto &value = it.value();
        PyObject *pyKey = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &key);
        PyObject *pyValue = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QColor_IDX]), &value);
        PyDict_SetItem(pyOut, pyKey, pyValue);
        Py_DECREF(pyKey);
        Py_DECREF(pyValue);
    }
    return pyOut;
    // TEMPLATE - shiboken_conversion_qmap_to_pydict - END

}
static void PyDict_PythonToCpp__QHash_QString_QColor_(PyObject *pyIn, void *cppOut)
{
    auto &cppOutRef = *reinterpret_cast<::QHash<QString,QColor> *>(cppOut);
    // TEMPLATE - shiboken_conversion_pydict_to_qmap - START
    PyObject *key{};
    PyObject *value{};
    cppOutRef.clear();
    Py_ssize_t pos = 0;
    while (PyDict_Next(pyIn, &pos, &key, &value)) {
        ::QString cppKey;
    Shiboken::Conversions::pythonToCppCopy(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], key, &(cppKey));
        ::QColor cppValue;
    Shiboken::Conversions::pythonToCppCopy(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QColor_IDX]), value, &(cppValue));
        cppOutRef.insert(cppKey, cppValue);
    }
    // TEMPLATE - shiboken_conversion_pydict_to_qmap - END

}
static PythonToCppFunc is_PyDict_PythonToCpp__QHash_QString_QColor__Convertible(PyObject *pyIn)
{
    if (Shiboken::Conversions::convertibleDictTypes(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], false, PepType_SOTP(reinterpret_cast<PyTypeObject *>(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QColor_IDX])))->converter, false, pyIn))
        return PyDict_PythonToCpp__QHash_QString_QColor_;
    return {};
}

// C++ to Python conversion for container type 'QList<QVariant>'.
static PyObject *_QList_QVariant__CppToPython_PyList(const void *cppIn)
{
    const auto &cppInRef = *reinterpret_cast<const ::QList<QVariant> *>(cppIn);
    // TEMPLATE - shiboken_conversion_cppsequence_to_pylist - START
    PyObject *pyOut = PyList_New(Py_ssize_t(cppInRef.size()));
    Py_ssize_t idx = 0;
    for (auto it = std::cbegin(cppInRef), end = std::cend(cppInRef); it != end; ++it, ++idx) {
        const auto &cppItem = *it;
        PyList_SetItem(pyOut, idx, Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QVariant_IDX], &cppItem));
    }
    return pyOut;
    // TEMPLATE - shiboken_conversion_cppsequence_to_pylist - END

}
static void PySequence_PythonToCpp__QList_QVariant_(PyObject *pyIn, void *cppOut)
{
    auto &cppOutRef = *reinterpret_cast<::QList<QVariant> *>(cppOut);
    // TEMPLATE - shiboken_conversion_pyiterable_to_cppsequentialcontainer_reserve - START
    (cppOutRef).clear();
    if (PyList_Check(pyIn)) {
        const Py_ssize_t size = PySequence_Size(pyIn);
        if (size > 10)
            (cppOutRef).reserve(size);
    }

    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    while (true) {
        Shiboken::AutoDecRef pyItem(PyIter_Next(it.object()));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QVariant cppItem;
    Shiboken::Conversions::pythonToCppCopy(SbkPySide6_QtCoreTypeConverters[SBK_QVariant_IDX], pyItem, &(cppItem));
        (cppOutRef).push_back(cppItem);
    }
    // TEMPLATE - shiboken_conversion_pyiterable_to_cppsequentialcontainer_reserve - END

}
static PythonToCppFunc is_PySequence_PythonToCpp__QList_QVariant__Convertible(PyObject *pyIn)
{
    if (Shiboken::Conversions::convertibleSequenceTypes(SbkPySide6_QtCoreTypeConverters[SBK_QVariant_IDX], pyIn))
        return PySequence_PythonToCpp__QList_QVariant_;
    return {};
}


// The signatures string for the global functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *CutterBindings_SignatureStrings[] = {
    nullptr}; // Sentinel
#else
static constexpr size_t CutterBindings_SignatureByteSize = 0;
static constexpr uint8_t CutterBindings_SignatureBytes[1] = {
    0x00
};
#endif

static void initInheritance()
{
    auto &bm = Shiboken::BindingManager::instance();
    SBK_UNUSED(bm)
    bm.addClassInheritance(&SbkPySide6_QtWidgetsTypeStructs[SBK_QMainWindow_IDX],
                           &SbkCutterBindingsTypeStructs[SBK_MainWindow_IDX]);
    bm.addClassInheritance(&SbkPySide6_QtWidgetsTypeStructs[SBK_QDockWidget_IDX],
                           &SbkCutterBindingsTypeStructs[SBK_CutterDockWidget_IDX]);
    bm.addClassInheritance(&SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX],
                           &SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]);
    bm.addClassInheritance(&SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX],
                           &SbkCutterBindingsTypeStructs[SBK_Configuration_IDX]);
    bm.addClassInheritance(&SbkPySide6_QtWidgetsTypeStructs[SBK_QMenu_IDX],
                           &SbkCutterBindingsTypeStructs[SBK_AddressableItemContextMenu_IDX]);
}

static void initConverters_CutterBindings()
{
    // Register primitive types converters.
    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "ASN1_BOOLEAN");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "ASN1_NULL");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "BufferOp");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<char>(), "DWARF_RegisterMapping");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long long>(), "DebugInfoOffset");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "FREE_XTR");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), "HtPPCalcSizeK");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), "HtPPCalcSizeV");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "HtPPComparator");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), "HtPPForeachCallback");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), "HtPPHashFunction");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), "HtPUCalcSizeK");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), "HtPUCalcSizeV");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "HtPUComparator");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long long>(), "HtPUDupValue");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), "HtPUForeachCallback");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), "HtPUHashFunction");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), "HtSPCalcSizeK");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), "HtSPCalcSizeV");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "HtSPComparator");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<char>(), "HtSPDupKey");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), "HtSPForeachCallback");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), "HtSPHashFunction");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), "HtSSCalcSizeK");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), "HtSSCalcSizeV");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "HtSSComparator");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<char>(), "HtSSDupKey");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<char>(), "HtSSDupValue");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), "HtSSForeachCallback");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), "HtSSHashFunction");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), "HtSUCalcSizeK");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), "HtSUCalcSizeV");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "HtSUComparator");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<char>(), "HtSUDupKey");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long long>(), "HtSUDupValue");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), "HtSUForeachCallback");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), "HtSUHashFunction");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), "HtUPCalcSizeK");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), "HtUPCalcSizeV");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "HtUPComparator");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long long>(), "HtUPDupKey");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), "HtUPForeachCallback");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), "HtUPHashFunction");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), "HtUUCalcSizeK");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), "HtUUCalcSizeV");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "HtUUComparator");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long long>(), "HtUUDupKey");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long long>(), "HtUUDupValue");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), "HtUUForeachCallback");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), "HtUUHashFunction");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), "PDBSymbolIndex");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned short>(), "PDBSymbolKind");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), "PDBTypeIndex");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<char>(), "PrintItemCallback");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "PrintfCallback");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), "QRgb");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "RBComparator");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "RContRBCmp");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), "ROIDStorageCompareCb");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long long>(), "RVA");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), "RzAnalysisAddrCb");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), "RzAnalysisAddrHintRecordsCb");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), "RzAnalysisArchHintCb");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), "RzAnalysisBitsHintCb");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), "RzAnalysisBlockCb");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "RzAnalysisEsilCB");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "RzAnalysisEsilHookRegWriteCB");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), "RzAnalysisEsilInterruptCB");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "RzAnalysisEsilLoopCB");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), "RzAnalysisEsilOpCb");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "RzAnalysisEsilTrapCB");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "RzAnalysisFPBBCallback");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "RzAnalysisFPFcnCallback");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), "RzAnalysisILVMCondCallback");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<char>(), "RzAnalysisLabelAt");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), "RzAnalysisMatchThreadInfoCb");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "RzAnalysisOpCallback");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), "RzAnalysisRefCmp");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), "RzAnalysisRegProfCallback");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<char>(), "RzAnalysisRegProfGetCallback");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), "RzBaseFindThreadInfoCb");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<char>(), "RzBinDemangle");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<char>(), "RzBinGetName");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long long>(), "RzBinGetOffset");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "RzBreakpointCallback");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), "RzBufferFini");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long long>(), "RzBufferFwdScan");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long long>(), "RzBufferGetSize");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), "RzBufferGetWholeBuf");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), "RzBufferInit");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long long>(), "RzBufferRead");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), "RzBufferResize");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long long>(), "RzBufferSeek");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long long>(), "RzBufferWrite");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<char>(), "RzCmdArgChoiceCb");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "RzCmdCb");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), "RzCmdForeachMacroCb");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), "RzCmdForeachNameCb");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "RzCmdNullCb");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), "RzCmdRegSync");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), "RzCodePoint");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), "RzConfigCallback");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "RzConsClickCallback");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<char>(), "RzConsEditorCallback");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "RzConsGetCursor");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "RzConsGetSize");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), "RzConsIsBreaked");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), "RzCoreBinApplyInfo");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "RzCoreCmd");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "RzCoreCmdF");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<char>(), "RzCoreCmdStr");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<char>(), "RzCoreCmdStrCallback");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<char>(), "RzCoreCmdStrF");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "RzCoreCmdfCallback");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<char>(), "RzCoreConfigGet");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long long>(), "RzCoreConfigGetI");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), "RzCoreConfigSet");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), "RzCoreConfigSetI");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "RzCoreDebugBpHit");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<char>(), "RzCoreGetName");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<char>(), "RzCoreGetNameDelta");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long long>(), "RzCoreNumGet");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), "RzCorePluginCallback");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "RzCoreSearchCallback");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long long>(), "RzCryptoSelector");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), "RzDemanglerIter");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<char>(), "RzDemanglerPluginCb");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), "RzDiffIgnoreByte");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), "RzDiffIgnoreLine");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "RzDiffMethodCompare");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), "RzDiffMethodElemHash");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), "RzDiffMethodIgnore");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), "RzFlagExistAt");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), "RzFlagItemCb");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), "RzFlagPopSpace");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), "RzFlagPushSpace");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "RzFlagRename");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), "RzFlagUnset");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), "RzFlagUnsetName");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), "RzFlagUnsetOff");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), "RzHashSize");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), "RzIDStorageForeachCb");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), "RzILMemIndex");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), "RzILOpEffectHandler");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<char>(), "RzILValidateReport");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), "RzIOAddrIsMapped");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), "RzIOClose");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long long>(), "RzIODescSize");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), "RzIODescUse");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), "RzIOFdClose");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), "RzIOFdGetBuf");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<char>(), "RzIOFdGetName");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), "RzIOFdIsDbg");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "RzIOFdOpen");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "RzIOFdRead");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "RzIOFdReadAt");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), "RzIOFdRemap");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), "RzIOFdResize");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long long>(), "RzIOFdSeek");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long long>(), "RzIOFdSize");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "RzIOFdWrite");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "RzIOFdWriteAt");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "RzIOGetCurrentFd");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), "RzIOIsValidOff");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long long>(), "RzIOP2V");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "RzIOPtraceFn");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), "RzIOReadAt");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<char>(), "RzIOSystem");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long long>(), "RzIOV2P");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), "RzIOWriteAt");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), "RzIntervalIterCb");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), "RzLibCallback");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "RzLineCompletionCb");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<char>(), "RzLineEditorCb");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "RzLineHistoryDownCb");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "RzLineHistoryUpCb");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "RzListComparator");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "RzMainCallback");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long long>(), "RzNumCallback");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<char>(), "RzNumCallback2");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "RzPVectorComparator");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<char>(), "RzPrintColorFor");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<char>(), "RzPrintCommentCallback");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<char>(), "RzPrintHasRefs");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), "RzPrintIsInterruptedCallback");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<char>(), "RzPrintNameCallback");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<char>(), "RzPrintSectionGet");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "RzPrintSizeCallback");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "RzRef");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), "RzRegexFlags");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), "RzRegexPattern");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<size_t>(), "RzRegexSize");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "RzRegexStatus");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "RzSearchCallback");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), "RzSearchCancelCallback");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long long>(), "RzStackAddr");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "RzStrRangeCallback");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), "RzThreadIterator");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long long>(), "RzTypeAttribute");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "RzVectorComparator");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), "SdbForeachCallback");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long long>(), "UnitOffset");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), "VALUE_EQ_F");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "__blkcnt64_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "__blkcnt_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "__blksize_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<char>(), "__caddr_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "__clock_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "__clockid_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "__compar_d_fn_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "__compar_fn_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "__daddr_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "__dev_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "__fsblkcnt64_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "__fsblkcnt_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "__fsfilcnt64_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "__fsfilcnt_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "__fsword_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), "__gid_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), "__id_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "__ino64_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "__ino_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<short>(), "__int16_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "__int32_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "__int64_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<signed char>(), "__int8_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<short>(), "__int_least16_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "__int_least32_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "__int_least64_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<signed char>(), "__int_least8_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "__intmax_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "__intptr_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "__key_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "__loff_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), "__mode_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "__nlink_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "__off64_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "__off_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "__pid_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "__quad_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "__rlim64_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "__rlim_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "__sig_atomic_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), "__socklen_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "__ssize_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "__suseconds64_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "__suseconds_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "__syscall_slong_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "__syscall_ulong_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "__time_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), "__u_char");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), "__u_int");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "__u_long");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "__u_quad_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned short>(), "__u_short");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), "__uid_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned short>(), "__uint16_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), "__uint32_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "__uint64_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), "__uint8_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned short>(), "__uint_least16_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), "__uint_least32_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "__uint_least64_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), "__uint_least8_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "__uintmax_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), "__useconds_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "blkcnt64_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "blkcnt_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "blksize_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<char>(), "caddr_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "comparison_fn_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "daddr_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "dev_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "fsblkcnt64_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "fsblkcnt_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "fsfilcnt64_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "fsfilcnt_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), "gid_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), "id_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "ino64_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "ino_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "int_fast16_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "int_fast32_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "int_fast64_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<signed char>(), "int_fast8_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "intmax_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "key_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "loff_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), "mode_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "nlink_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "off64_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "off_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<int>(), "pid_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), "qInternalCallback");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "quad_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "register_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "ssize_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<long>(), "suseconds_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), "u_char");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), "u_int");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned short>(), "u_int16_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), "u_int32_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "u_int64_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), "u_int8_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "u_long");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "u_quad_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned short>(), "u_short");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), "uid_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "uint_fast16_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "uint_fast32_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "uint_fast64_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), "uint_fast8_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), "uintmax_t");

    Shiboken::Conversions::registerConverterAlias(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), "useconds_t");

}

static void initContainerConverters_CutterBindings()
{
    // Register converter for type 'QList<int>'.
    SbkCutterBindingsTypeConverters[SBK_CutterBindings_QList_int_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_int__CppToPython_PyList);
    Shiboken::Conversions::registerConverterName(SbkCutterBindingsTypeConverters[SBK_CutterBindings_QList_int_IDX], "QList<int>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkCutterBindingsTypeConverters[SBK_CutterBindings_QList_int_IDX],
        PySequence_PythonToCpp__QList_int_,
        is_PySequence_PythonToCpp__QList_int__Convertible);
    Shiboken::Conversions::setPythonToCppPointerFunctions(SbkCutterBindingsTypeConverters[SBK_CutterBindings_QList_int_IDX],
        PythonToCppQIntList,
        isQIntListPythonToCppConvertible);

    // Register converter for type 'QMap<QString,QVariant>'.
    SbkCutterBindingsTypeConverters[SBK_CutterBindings_QMap_QString_QVariant_IDX] = Shiboken::Conversions::createConverter(&PyDict_Type, _QMap_QString_QVariant__CppToPython_PyDict);
    Shiboken::Conversions::registerConverterName(SbkCutterBindingsTypeConverters[SBK_CutterBindings_QMap_QString_QVariant_IDX], "QMap<QString,QVariant>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkCutterBindingsTypeConverters[SBK_CutterBindings_QMap_QString_QVariant_IDX],
        PyDict_PythonToCpp__QMap_QString_QVariant_,
        is_PyDict_PythonToCpp__QMap_QString_QVariant__Convertible);
    // Register converters for type aliases of QMap<QString,QVariant>'.
    Shiboken::Conversions::registerConverterName(SbkCutterBindingsTypeConverters[SBK_CutterBindings_QMap_QString_QVariant_IDX], "QVariantMap");
    Shiboken::Conversions::registerConverterName(SbkCutterBindingsTypeConverters[SBK_CutterBindings_QMap_QString_QVariant_IDX], "QSettings::SettingsMap");

    // Register converter for type 'QList<QString>'.
    SbkCutterBindingsTypeConverters[SBK_CutterBindings_QList_QString_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QString__CppToPython_PyList);
    Shiboken::Conversions::registerConverterName(SbkCutterBindingsTypeConverters[SBK_CutterBindings_QList_QString_IDX], "QList<QString>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkCutterBindingsTypeConverters[SBK_CutterBindings_QList_QString_IDX],
        PySequence_PythonToCpp__QList_QString_,
        is_PySequence_PythonToCpp__QList_QString__Convertible);
    // Register converters for type aliases of QList<QString>'.

    // Register converter for type 'QList<unsigned long long>'.
    SbkCutterBindingsTypeConverters[SBK_CutterBindings_QList_unsignedlonglong_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_unsignedlonglong__CppToPython_PyList);
    Shiboken::Conversions::registerConverterName(SbkCutterBindingsTypeConverters[SBK_CutterBindings_QList_unsignedlonglong_IDX], "QList<unsigned long long>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkCutterBindingsTypeConverters[SBK_CutterBindings_QList_unsignedlonglong_IDX],
        PySequence_PythonToCpp__QList_unsignedlonglong_,
        is_PySequence_PythonToCpp__QList_unsignedlonglong__Convertible);

    // Register converter for type 'QHash<QString,QColor>'.
    SbkCutterBindingsTypeConverters[SBK_CutterBindings_QHash_QString_QColor_IDX] = Shiboken::Conversions::createConverter(&PyDict_Type, _QHash_QString_QColor__CppToPython_PyDict);
    Shiboken::Conversions::registerConverterName(SbkCutterBindingsTypeConverters[SBK_CutterBindings_QHash_QString_QColor_IDX], "QHash<QString,QColor>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkCutterBindingsTypeConverters[SBK_CutterBindings_QHash_QString_QColor_IDX],
        PyDict_PythonToCpp__QHash_QString_QColor_,
        is_PyDict_PythonToCpp__QHash_QString_QColor__Convertible);

    // Register converter for type 'QList<QVariant>'.
    SbkCutterBindingsTypeConverters[SBK_CutterBindings_QList_QVariant_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QVariant__CppToPython_PyList);
    Shiboken::Conversions::registerConverterName(SbkCutterBindingsTypeConverters[SBK_CutterBindings_QList_QVariant_IDX], "QList<QVariant>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkCutterBindingsTypeConverters[SBK_CutterBindings_QList_QVariant_IDX],
        PySequence_PythonToCpp__QList_QVariant_,
        is_PySequence_PythonToCpp__QList_QVariant__Convertible);
    // Register converters for type aliases of QList<QVariant>'.
    Shiboken::Conversions::registerConverterName(SbkCutterBindingsTypeConverters[SBK_CutterBindings_QList_QVariant_IDX], "QVariantList");

}

static void registerOpaqueContainers_CutterBindings(PyObject *module)
{
    PyTypeObject *pyType{};
    auto *qVariantConverter = Shiboken::Conversions::getConverter("QVariant");
    Q_ASSERT(qVariantConverter != nullptr);
    pyType = QIntList_TypeF();
    Py_XINCREF(reinterpret_cast<PyObject *>(pyType));
    PepModule_AddType(module, pyType);
    if constexpr (QMetaTypeId2<int>::Defined) {
        Shiboken::Conversions::prependPythonToCppValueConversion(qVariantConverter,
            PythonToQVariantQIntList, isQIntListPythonToQVariantConvertible);
    }
}

extern "C" {
static int exec_CutterBindings(PyObject *module)
{
    Shiboken::Module::exec(module);

    // Initialize classes in the type system
    Shiboken::Module::AddTypeCreationFunction(module, "MainWindow", init_MainWindow);
    Shiboken::Module::AddTypeCreationFunction(module, "CutterPlugin", init_CutterPlugin);
    Shiboken::Module::AddTypeCreationFunction(module, "CutterDockWidget", init_CutterDockWidget);
    Shiboken::Module::AddTypeCreationFunction(module, "CutterCore", init_CutterCore);
    Shiboken::Module::AddTypeCreationFunction(module, "Configuration", init_Configuration);
    Shiboken::Module::AddTypeCreationFunction(module, "BasicInstructionHighlighter", init_BasicInstructionHighlighter);
    Shiboken::Module::AddTypeCreationFunction(module, "BasicBlockHighlighter", init_BasicBlockHighlighter);
    Shiboken::Module::AddTypeCreationFunction(module, "AddressableItemContextMenu", init_AddressableItemContextMenu);

    registerOpaqueContainers_CutterBindings(module);

    Shiboken::Module::registerTypes(module, SbkCutterBindingsTypeStructs);
    Shiboken::Module::registerTypeConverters(module, SbkCutterBindingsTypeConverters);

    initInheritance();

    if (Shiboken::Errors::occurred() != nullptr) {
        PyErr_Print();
        Py_FatalError("shiboken: can't initialize module CutterBindings");
    }
    PySide::registerCleanupFunction(cleanTypesAttributes);

#if PYSIDE6_COMOPT_COMPRESS == 0
    FinishSignatureInitialization(module, CutterBindings_SignatureStrings);
#else
    if (FinishSignatureInitBytes(module, CutterBindings_SignatureBytes, CutterBindings_SignatureByteSize) < 0)
        return -1;
#endif

    return 0;
}
} // extern "C"

static PyModuleDef_Slot CutterBindingsModuleSlots[] = {
    {Py_mod_exec, reinterpret_cast<void *>(exec_CutterBindings)},
#if !defined(PYPY_VERSION) && ((!defined(Py_LIMITED_API) && PY_VERSION_HEX >= 0x030C0000) || (defined(Py_LIMITED_API) && Py_LIMITED_API >= 0x030C0000))
    {Py_mod_multiple_interpreters, Py_MOD_MULTIPLE_INTERPRETERS_NOT_SUPPORTED},
#endif
#ifdef Py_GIL_DISABLED
    {Py_mod_gil, Py_MOD_GIL_USED},
#endif
    {0, nullptr}
};

static struct PyModuleDef CutterBindingsModuleDef = {
    /* m_base     */ PyModuleDef_HEAD_INIT,
    /* m_name     */ "CutterBindings",
    /* m_doc      */ nullptr,
    /* m_size     */ 0,
    /* m_methods  */ CutterBindingsMethods,
    /* m_slots    */ CutterBindingsModuleSlots,
    /* m_traverse */ nullptr,
    /* m_clear    */ nullptr,
    /* m_free     */ nullptr
};

extern "C" LIBSHIBOKEN_EXPORT PyObject *PyInit_CutterBindings()
{
    Shiboken::init();

    // Create an array of wrapper types/names for the current module.
    static Shiboken::Module::TypeInitStruct cppApi[] = {
        {nullptr, "CutterBindings.AddressableItemContextMenu"},
        {nullptr, "CutterBindings.BasicBlockHighlighter"},
        {nullptr, "CutterBindings.BasicInstructionHighlighter"},
        {nullptr, "CutterBindings.Configuration"},
        {nullptr, "CutterBindings.CutterCore"},
        {nullptr, "CutterBindings.CutterDockWidget"},
        {nullptr, "CutterBindings.CutterPlugin"},
        {nullptr, "CutterBindings.MainWindow"},
        {nullptr, "CutterBindings.MainWindow.ContextMenuType"},
        {nullptr, "CutterBindings.MainWindow.MenuType"},
        {nullptr, nullptr}
    };
    // The new global structure consisting of (type, name) pairs.
    SbkCutterBindingsTypeStructs = cppApi;
    QT_WARNING_PUSH
    QT_WARNING_DISABLE_DEPRECATED
    // The backward compatible alias with upper case indexes.
    SbkCutterBindingsTypes = reinterpret_cast<PyTypeObject **>(cppApi);
    QT_WARNING_POP

    // Create an array of primitive type converters for the current module.
    static SbkConverter *sbkConverters[SBK_CutterBindings_CONVERTERS_IDX_COUNT];
    SbkCutterBindingsTypeConverters = sbkConverters;

    {
        Shiboken::AutoDecRef requiredModule(Shiboken::Module::import("PySide6.QtCore"));
        if (requiredModule.isNull())
            return nullptr;
        SbkPySide6_QtCoreTypeStructs = Shiboken::Module::getTypes(requiredModule);
        SbkPySide6_QtCoreTypeConverters = Shiboken::Module::getTypeConverters(requiredModule);
    }

    {
        Shiboken::AutoDecRef requiredModule(Shiboken::Module::import("PySide6.QtGui"));
        if (requiredModule.isNull())
            return nullptr;
        SbkPySide6_QtGuiTypeStructs = Shiboken::Module::getTypes(requiredModule);
        SbkPySide6_QtGuiTypeConverters = Shiboken::Module::getTypeConverters(requiredModule);
    }

    {
        Shiboken::AutoDecRef requiredModule(Shiboken::Module::import("PySide6.QtWidgets"));
        if (requiredModule.isNull())
            return nullptr;
        SbkPySide6_QtWidgetsTypeStructs = Shiboken::Module::getTypes(requiredModule);
        SbkPySide6_QtWidgetsTypeConverters = Shiboken::Module::getTypeConverters(requiredModule);
    }

    initConverters_CutterBindings();
    initContainerConverters_CutterBindings();

    PyObject *module = nullptr;
    if (Shiboken::isCompiled()) {
        CutterBindingsModuleDef.m_size = -1;
        CutterBindingsModuleDef.m_slots = nullptr;
        module = Shiboken::Module::createOnly("CutterBindings", &CutterBindingsModuleDef);
        if (module == nullptr)
            return nullptr;
#ifdef Py_GIL_DISABLED
        PyUnstable_Module_SetGIL(module, Py_MOD_GIL_NOT_USED);
#endif
        if (exec_CutterBindings(module) != 0)
            return nullptr;
    } else {
        module = PyModuleDef_Init(&CutterBindingsModuleDef);
    }
    return module;
}

