// ui/gfx/mojom/buffer_types.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_GFX_MOJOM_BUFFER_TYPES_MOJOM_SHARED_H_
#define UI_GFX_MOJOM_BUFFER_TYPES_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <ostream>
#include <type_traits>
#include <utility>

#include "base/compiler_specific.h"
#include "base/containers/flat_map.h"
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "ui/gfx/mojom/buffer_types.mojom-shared-internal.h"
#include "ui/gfx/mojom/native_handle_types.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"






namespace gfx {
namespace mojom {
class BufferUsageAndFormatDataView;

class GpuMemoryBufferIdDataView;

class GpuMemoryBufferHandleDataView;



}  // namespace mojom
}  // namespace gfx

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::gfx::mojom::BufferUsageAndFormatDataView> {
  using Data = ::gfx::mojom::internal::BufferUsageAndFormat_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::gfx::mojom::GpuMemoryBufferIdDataView> {
  using Data = ::gfx::mojom::internal::GpuMemoryBufferId_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::gfx::mojom::GpuMemoryBufferHandleDataView> {
  using Data = ::gfx::mojom::internal::GpuMemoryBufferHandle_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace gfx {
namespace mojom {


enum class BufferFormat : int32_t {
  
  R_8 = 0,
  
  R_16 = 1,
  
  RG_88 = 2,
  
  BGR_565 = 3,
  
  RGBA_4444 = 4,
  
  RGBX_8888 = 5,
  
  RGBA_8888 = 6,
  
  BGRX_8888 = 7,
  
  BGRA_1010102 = 8,
  
  RGBA_1010102 = 9,
  
  BGRA_8888 = 10,
  
  RGBA_F16 = 11,
  
  YVU_420 = 12,
  
  YUV_420_BIPLANAR = 13,
  
  P010 = 14,
  kMinValue = 0,
  kMaxValue = 14,
};

 std::ostream& operator<<(std::ostream& os, BufferFormat value);
inline bool IsKnownEnumValue(BufferFormat value) {
  return internal::BufferFormat_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class BufferUsage : int32_t {
  
  GPU_READ = 0,
  
  SCANOUT = 1,
  
  SCANOUT_CAMERA_READ_WRITE = 2,
  
  CAMERA_AND_CPU_READ_WRITE = 3,
  
  SCANOUT_CPU_READ_WRITE = 4,
  
  SCANOUT_VDA_WRITE = 5,
  
  GPU_READ_CPU_READ_WRITE = 6,
  
  SCANOUT_VEA_READ_CAMERA_AND_CPU_READ_WRITE = 7,
  kMinValue = 0,
  kMaxValue = 7,
};

 std::ostream& operator<<(std::ostream& os, BufferUsage value);
inline bool IsKnownEnumValue(BufferUsage value) {
  return internal::BufferUsage_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class BufferUsageAndFormatDataView {
 public:
  BufferUsageAndFormatDataView() {}

  BufferUsageAndFormatDataView(
      internal::BufferUsageAndFormat_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadUsage(UserType* output) const {
    auto data_value = data_->usage;
    return mojo::internal::Deserialize<::gfx::mojom::BufferUsage>(
        data_value, output);
  }

  BufferUsage usage() const {
    return static_cast<BufferUsage>(data_->usage);
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadFormat(UserType* output) const {
    auto data_value = data_->format;
    return mojo::internal::Deserialize<::gfx::mojom::BufferFormat>(
        data_value, output);
  }

  BufferFormat format() const {
    return static_cast<BufferFormat>(data_->format);
  }
 private:
  internal::BufferUsageAndFormat_Data* data_ = nullptr;
};



class GpuMemoryBufferIdDataView {
 public:
  GpuMemoryBufferIdDataView() {}

  GpuMemoryBufferIdDataView(
      internal::GpuMemoryBufferId_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
  int32_t id() const {
    return data_->id;
  }
 private:
  internal::GpuMemoryBufferId_Data* data_ = nullptr;
};



class GpuMemoryBufferHandleDataView {
 public:
  GpuMemoryBufferHandleDataView() {}

  GpuMemoryBufferHandleDataView(
      internal::GpuMemoryBufferHandle_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetIdDataView(
      GpuMemoryBufferIdDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadId(UserType* output) {
    
    auto* pointer = data_->id.Get();
    return mojo::internal::Deserialize<::gfx::mojom::GpuMemoryBufferIdDataView>(
        pointer, output, context_);
  }
  uint32_t offset() const {
    return data_->offset;
  }
  uint32_t stride() const {
    return data_->stride;
  }
  inline void GetPlatformHandleDataView(
      ::gfx::mojom::GpuMemoryBufferPlatformHandleDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadPlatformHandle(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::gfx::mojom::GpuMemoryBufferPlatformHandleDataView, UserType>(),
    "Attempting to read the optional `platform_handle` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadPlatformHandle` instead "
    "of `ReadPlatformHandle if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = !data_->platform_handle.is_null() ? &data_->platform_handle : nullptr;
    return mojo::internal::Deserialize<::gfx::mojom::GpuMemoryBufferPlatformHandleDataView>(
        pointer, output, context_);
  }
 private:
  internal::GpuMemoryBufferHandle_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



}  // namespace mojom
}  // namespace gfx

namespace std {

template <>
struct hash<::gfx::mojom::BufferFormat>
    : public mojo::internal::EnumHashImpl<::gfx::mojom::BufferFormat> {};

template <>
struct hash<::gfx::mojom::BufferUsage>
    : public mojo::internal::EnumHashImpl<::gfx::mojom::BufferUsage> {};

}  // namespace std

namespace mojo {


template <>
struct EnumTraits<::gfx::mojom::BufferFormat, ::gfx::mojom::BufferFormat> {
  static ::gfx::mojom::BufferFormat ToMojom(::gfx::mojom::BufferFormat input) { return input; }
  static bool FromMojom(::gfx::mojom::BufferFormat input, ::gfx::mojom::BufferFormat* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gfx::mojom::BufferFormat, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::gfx::mojom::BufferFormat, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::gfx::mojom::BufferFormat>(input), output);
  }
};

}  // namespace internal


template <>
struct EnumTraits<::gfx::mojom::BufferUsage, ::gfx::mojom::BufferUsage> {
  static ::gfx::mojom::BufferUsage ToMojom(::gfx::mojom::BufferUsage input) { return input; }
  static bool FromMojom(::gfx::mojom::BufferUsage input, ::gfx::mojom::BufferUsage* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gfx::mojom::BufferUsage, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::gfx::mojom::BufferUsage, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::gfx::mojom::BufferUsage>(input), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gfx::mojom::BufferUsageAndFormatDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gfx::mojom::BufferUsageAndFormatDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::gfx::mojom::internal::BufferUsageAndFormat_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    mojo::internal::Serialize<::gfx::mojom::BufferUsage>(
        Traits::usage(input), &(*output)->usage);
    mojo::internal::Serialize<::gfx::mojom::BufferFormat>(
        Traits::format(input), &(*output)->format);
  }

  static bool Deserialize(::gfx::mojom::internal::BufferUsageAndFormat_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::gfx::mojom::BufferUsageAndFormatDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gfx::mojom::GpuMemoryBufferIdDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gfx::mojom::GpuMemoryBufferIdDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::gfx::mojom::internal::GpuMemoryBufferId_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    (*output)->id = Traits::id(input);
  }

  static bool Deserialize(::gfx::mojom::internal::GpuMemoryBufferId_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::gfx::mojom::GpuMemoryBufferIdDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gfx::mojom::GpuMemoryBufferHandleDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gfx::mojom::GpuMemoryBufferHandleDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::gfx::mojom::internal::GpuMemoryBufferHandle_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::id(input)) in_id = Traits::id(input);
    typename decltype((*output)->id)::BaseType::BufferWriter
        id_writer;
    mojo::internal::Serialize<::gfx::mojom::GpuMemoryBufferIdDataView>(
        in_id, buffer, &id_writer, context);
    (*output)->id.Set(
        id_writer.is_null() ? nullptr : id_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->id.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null id in GpuMemoryBufferHandle struct");
    (*output)->offset = Traits::offset(input);
    (*output)->stride = Traits::stride(input);
    decltype(Traits::platform_handle(input)) in_platform_handle = Traits::platform_handle(input);
    typename decltype((*output)->platform_handle)::BufferWriter platform_handle_writer;
    platform_handle_writer.AllocateInline(buffer, &(*output)->platform_handle);
    mojo::internal::Serialize<::gfx::mojom::GpuMemoryBufferPlatformHandleDataView>(
        in_platform_handle, buffer, &platform_handle_writer, true, context);
  }

  static bool Deserialize(::gfx::mojom::internal::GpuMemoryBufferHandle_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::gfx::mojom::GpuMemoryBufferHandleDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace gfx {
namespace mojom {





inline void GpuMemoryBufferHandleDataView::GetIdDataView(
    GpuMemoryBufferIdDataView* output) {
  auto pointer = data_->id.Get();
  *output = GpuMemoryBufferIdDataView(pointer, context_);
}
inline void GpuMemoryBufferHandleDataView::GetPlatformHandleDataView(
    ::gfx::mojom::GpuMemoryBufferPlatformHandleDataView* output) {
  auto pointer = &data_->platform_handle;
  *output = ::gfx::mojom::GpuMemoryBufferPlatformHandleDataView(pointer, context_);
}



}  // namespace mojom
}  // namespace gfx

#endif  // UI_GFX_MOJOM_BUFFER_TYPES_MOJOM_SHARED_H_