// services/tracing/public/mojom/background_tracing_agent.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_TRACING_PUBLIC_MOJOM_BACKGROUND_TRACING_AGENT_MOJOM_H_
#define SERVICES_TRACING_PUBLIC_MOJOM_BACKGROUND_TRACING_AGENT_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "services/tracing/public/mojom/background_tracing_agent.mojom-shared.h"
#include "services/tracing/public/mojom/background_tracing_agent.mojom-forward.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"


#include "base/component_export.h"



// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace tracing {
namespace mojom {

class BackgroundTracingAgentClientProxy;

template <typename ImplRefTraits>
class BackgroundTracingAgentClientStub;

class BackgroundTracingAgentClientRequestValidator;


class COMPONENT_EXPORT(TRACING_MOJOM) BackgroundTracingAgentClient
    : public BackgroundTracingAgentClientInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = BackgroundTracingAgentClientInterfaceBase;
  using Proxy_ = BackgroundTracingAgentClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = BackgroundTracingAgentClientStub<ImplRefTraits>;

  using RequestValidator_ = BackgroundTracingAgentClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnInitializedMinVersion = 0,
    kOnTriggerBackgroundTraceMinVersion = 0,
    kOnAbortBackgroundTraceMinVersion = 0,
  };
  virtual ~BackgroundTracingAgentClient() {}

  
  virtual void OnInitialized() = 0;

  
  virtual void OnTriggerBackgroundTrace(const std::string& histogram_name) = 0;

  
  virtual void OnAbortBackgroundTrace() = 0;
};

class BackgroundTracingAgentProxy;

template <typename ImplRefTraits>
class BackgroundTracingAgentStub;

class BackgroundTracingAgentRequestValidator;


class COMPONENT_EXPORT(TRACING_MOJOM) BackgroundTracingAgent
    : public BackgroundTracingAgentInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = BackgroundTracingAgentInterfaceBase;
  using Proxy_ = BackgroundTracingAgentProxy;

  template <typename ImplRefTraits>
  using Stub_ = BackgroundTracingAgentStub<ImplRefTraits>;

  using RequestValidator_ = BackgroundTracingAgentRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kSetUMACallbackMinVersion = 0,
    kClearUMACallbackMinVersion = 0,
  };
  virtual ~BackgroundTracingAgent() {}

  
  virtual void SetUMACallback(const std::string& histogram_name, int32_t histogram_lower_value, int32_t histogram_upper_value, bool repeat) = 0;

  
  virtual void ClearUMACallback(const std::string& histogram_name) = 0;
};

class BackgroundTracingAgentProviderProxy;

template <typename ImplRefTraits>
class BackgroundTracingAgentProviderStub;

class BackgroundTracingAgentProviderRequestValidator;


class COMPONENT_EXPORT(TRACING_MOJOM) BackgroundTracingAgentProvider
    : public BackgroundTracingAgentProviderInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = BackgroundTracingAgentProviderInterfaceBase;
  using Proxy_ = BackgroundTracingAgentProviderProxy;

  template <typename ImplRefTraits>
  using Stub_ = BackgroundTracingAgentProviderStub<ImplRefTraits>;

  using RequestValidator_ = BackgroundTracingAgentProviderRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kCreateMinVersion = 0,
  };
  virtual ~BackgroundTracingAgentProvider() {}

  
  virtual void Create(uint64_t tracing_process_id, ::mojo::PendingRemote<BackgroundTracingAgentClient> client, ::mojo::PendingReceiver<BackgroundTracingAgent> agent) = 0;
};



class COMPONENT_EXPORT(TRACING_MOJOM) BackgroundTracingAgentClientProxy
    : public BackgroundTracingAgentClient {
 public:
  using InterfaceType = BackgroundTracingAgentClient;

  explicit BackgroundTracingAgentClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnInitialized() final;
  
  void OnTriggerBackgroundTrace(const std::string& histogram_name) final;
  
  void OnAbortBackgroundTrace() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class COMPONENT_EXPORT(TRACING_MOJOM) BackgroundTracingAgentProxy
    : public BackgroundTracingAgent {
 public:
  using InterfaceType = BackgroundTracingAgent;

  explicit BackgroundTracingAgentProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SetUMACallback(const std::string& histogram_name, int32_t histogram_lower_value, int32_t histogram_upper_value, bool repeat) final;
  
  void ClearUMACallback(const std::string& histogram_name) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class COMPONENT_EXPORT(TRACING_MOJOM) BackgroundTracingAgentProviderProxy
    : public BackgroundTracingAgentProvider {
 public:
  using InterfaceType = BackgroundTracingAgentProvider;

  explicit BackgroundTracingAgentProviderProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Create(uint64_t tracing_process_id, ::mojo::PendingRemote<BackgroundTracingAgentClient> client, ::mojo::PendingReceiver<BackgroundTracingAgent> agent) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class COMPONENT_EXPORT(TRACING_MOJOM) BackgroundTracingAgentClientStubDispatch {
 public:
  static bool Accept(BackgroundTracingAgentClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      BackgroundTracingAgentClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<BackgroundTracingAgentClient>>
class BackgroundTracingAgentClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  BackgroundTracingAgentClientStub() {}
  ~BackgroundTracingAgentClientStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return BackgroundTracingAgentClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return BackgroundTracingAgentClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class COMPONENT_EXPORT(TRACING_MOJOM) BackgroundTracingAgentStubDispatch {
 public:
  static bool Accept(BackgroundTracingAgent* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      BackgroundTracingAgent* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<BackgroundTracingAgent>>
class BackgroundTracingAgentStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  BackgroundTracingAgentStub() {}
  ~BackgroundTracingAgentStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return BackgroundTracingAgentStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return BackgroundTracingAgentStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class COMPONENT_EXPORT(TRACING_MOJOM) BackgroundTracingAgentProviderStubDispatch {
 public:
  static bool Accept(BackgroundTracingAgentProvider* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      BackgroundTracingAgentProvider* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<BackgroundTracingAgentProvider>>
class BackgroundTracingAgentProviderStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  BackgroundTracingAgentProviderStub() {}
  ~BackgroundTracingAgentProviderStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return BackgroundTracingAgentProviderStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return BackgroundTracingAgentProviderStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class COMPONENT_EXPORT(TRACING_MOJOM) BackgroundTracingAgentClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class COMPONENT_EXPORT(TRACING_MOJOM) BackgroundTracingAgentRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class COMPONENT_EXPORT(TRACING_MOJOM) BackgroundTracingAgentProviderRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // namespace mojom
}  // namespace tracing

namespace mojo {

}  // namespace mojo

#endif  // SERVICES_TRACING_PUBLIC_MOJOM_BACKGROUND_TRACING_AGENT_MOJOM_H_