// services/network/public/mojom/source_location.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/network/public/mojom/source_location.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "services/network/public/mojom/source_location.mojom-params-data.h"
#include "services/network/public/mojom/source_location.mojom-shared-message-ids.h"

#include "services/network/public/mojom/source_location.mojom-blink-import-headers.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_SOURCE_LOCATION_MOJOM_BLINK_JUMBO_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_SOURCE_LOCATION_MOJOM_BLINK_JUMBO_H_
#endif
namespace network {
namespace mojom {
namespace blink {
SourceLocation::SourceLocation()
    : url(),
      line(0U),
      column(0U) {}

SourceLocation::SourceLocation(
    const WTF::String& url_in,
    uint32_t line_in,
    uint32_t column_in)
    : url(std::move(url_in)),
      line(std::move(line_in)),
      column(std::move(column_in)) {}

SourceLocation::~SourceLocation() = default;
size_t SourceLocation::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->url);
  seed = mojo::internal::WTFHash(seed, this->line);
  seed = mojo::internal::WTFHash(seed, this->column);
  return seed;
}

void SourceLocation::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetString("url", this->url.Utf8());
  value->SetString("line", base::NumberToString(this->line));
  value->SetString("column", base::NumberToString(this->column));
}

bool SourceLocation::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
}  // namespace blink
}  // namespace mojom
}  // namespace network

namespace mojo {


// static
bool StructTraits<::network::mojom::blink::SourceLocation::DataView, ::network::mojom::blink::SourceLocationPtr>::Read(
    ::network::mojom::blink::SourceLocation::DataView input,
    ::network::mojom::blink::SourceLocationPtr* output) {
  bool success = true;
  ::network::mojom::blink::SourceLocationPtr result(::network::mojom::blink::SourceLocation::New());
  
      if (success && !input.ReadUrl(&result->url))
        success = false;
      if (success)
        result->line = input.line();
      if (success)
        result->column = input.column();
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif