// services/network/public/mojom/cert_verifier_service.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_CERT_VERIFIER_SERVICE_MOJOM_SHARED_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_CERT_VERIFIER_SERVICE_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <ostream>
#include <type_traits>
#include <utility>

#include "base/compiler_specific.h"
#include "base/containers/flat_map.h"
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "services/network/public/mojom/cert_verifier_service.mojom-shared-internal.h"
#include "mojo/public/mojom/base/big_buffer.mojom-shared.h"
#include "services/network/public/mojom/network_param.mojom-shared.h"
#include "services/network/public/mojom/url_loader_factory.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"


#include "mojo/public/cpp/bindings/native_enum.h"
#include "mojo/public/cpp/bindings/lib/native_struct_serialization.h"




namespace cert_verifier {
namespace mojom {
class RequestParamsDataView;

class CertVerifierConfigDataView;



}  // namespace mojom
}  // namespace cert_verifier

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::cert_verifier::mojom::RequestParamsDataView> {
  using Data = ::cert_verifier::mojom::internal::RequestParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::cert_verifier::mojom::CertVerifierConfigDataView> {
  using Data = ::cert_verifier::mojom::internal::CertVerifierConfig_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace cert_verifier {
namespace mojom {
// Interface base classes. They are used for type safety check.
class URLLoaderFactoryConnectorInterfaceBase {};

using URLLoaderFactoryConnectorPtrDataView =
    mojo::InterfacePtrDataView<URLLoaderFactoryConnectorInterfaceBase>;
using URLLoaderFactoryConnectorRequestDataView =
    mojo::InterfaceRequestDataView<URLLoaderFactoryConnectorInterfaceBase>;
using URLLoaderFactoryConnectorAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<URLLoaderFactoryConnectorInterfaceBase>;
using URLLoaderFactoryConnectorAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<URLLoaderFactoryConnectorInterfaceBase>;
class CertVerifierServiceInterfaceBase {};

using CertVerifierServicePtrDataView =
    mojo::InterfacePtrDataView<CertVerifierServiceInterfaceBase>;
using CertVerifierServiceRequestDataView =
    mojo::InterfaceRequestDataView<CertVerifierServiceInterfaceBase>;
using CertVerifierServiceAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<CertVerifierServiceInterfaceBase>;
using CertVerifierServiceAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<CertVerifierServiceInterfaceBase>;
class CertVerifierRequestInterfaceBase {};

using CertVerifierRequestPtrDataView =
    mojo::InterfacePtrDataView<CertVerifierRequestInterfaceBase>;
using CertVerifierRequestRequestDataView =
    mojo::InterfaceRequestDataView<CertVerifierRequestInterfaceBase>;
using CertVerifierRequestAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<CertVerifierRequestInterfaceBase>;
using CertVerifierRequestAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<CertVerifierRequestInterfaceBase>;


class RequestParamsDataView {
 public:
  RequestParamsDataView() {}

  RequestParamsDataView(
      internal::RequestParams_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetCertificateDataView(
      ::network::mojom::X509CertificateDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadCertificate(UserType* output) {
    
    auto* pointer = data_->certificate.Get();
    return mojo::internal::Deserialize<::network::mojom::X509CertificateDataView>(
        pointer, output, context_);
  }
  inline void GetHostnameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadHostname(UserType* output) {
    
    auto* pointer = data_->hostname.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
  int32_t flags() const {
    return data_->flags;
  }
  inline void GetOcspResponseDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadOcspResponse(UserType* output) {
    
    auto* pointer = data_->ocsp_response.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
  inline void GetSctListDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadSctList(UserType* output) {
    
    auto* pointer = data_->sct_list.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
 private:
  internal::RequestParams_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class CertVerifierConfigDataView {
 public:
  CertVerifierConfigDataView() {}

  CertVerifierConfigDataView(
      internal::CertVerifierConfig_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  bool enable_rev_checking() const {
    return data_->enable_rev_checking;
  }
  bool require_rev_checking_local_anchors() const {
    return data_->require_rev_checking_local_anchors;
  }
  bool enable_sha1_local_anchors() const {
    return data_->enable_sha1_local_anchors;
  }
  bool disable_symantec_enforcement() const {
    return data_->disable_symantec_enforcement;
  }
  inline void GetCrlSetDataView(
      ::mojo_base::mojom::BigBufferDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadCrlSet(UserType* output) {
    
    auto* pointer = !data_->crl_set.is_null() ? &data_->crl_set : nullptr;
    return mojo::internal::Deserialize<::mojo_base::mojom::BigBufferDataView>(
        pointer, output, context_);
  }
  inline void GetAdditionalTrustAnchorsDataView(
      mojo::ArrayDataView<::network::mojom::X509CertificateDataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadAdditionalTrustAnchors(UserType* output) {
    
    auto* pointer = data_->additional_trust_anchors.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::network::mojom::X509CertificateDataView>>(
        pointer, output, context_);
  }
  inline void GetAdditionalUntrustedAuthoritiesDataView(
      mojo::ArrayDataView<::network::mojom::X509CertificateDataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadAdditionalUntrustedAuthorities(UserType* output) {
    
    auto* pointer = data_->additional_untrusted_authorities.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::network::mojom::X509CertificateDataView>>(
        pointer, output, context_);
  }
 private:
  internal::CertVerifierConfig_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



}  // namespace mojom
}  // namespace cert_verifier

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::cert_verifier::mojom::RequestParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::cert_verifier::mojom::RequestParamsDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::cert_verifier::mojom::internal::RequestParams_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::certificate(input)) in_certificate = Traits::certificate(input);
    typename decltype((*output)->certificate)::BaseType::BufferWriter
        certificate_writer;
    mojo::internal::Serialize<::network::mojom::X509CertificateDataView>(
        in_certificate, buffer, &certificate_writer, context);
    (*output)->certificate.Set(
        certificate_writer.is_null() ? nullptr : certificate_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->certificate.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null certificate in RequestParams struct");
    decltype(Traits::hostname(input)) in_hostname = Traits::hostname(input);
    typename decltype((*output)->hostname)::BaseType::BufferWriter
        hostname_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_hostname, buffer, &hostname_writer, context);
    (*output)->hostname.Set(
        hostname_writer.is_null() ? nullptr : hostname_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->hostname.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null hostname in RequestParams struct");
    (*output)->flags = Traits::flags(input);
    decltype(Traits::ocsp_response(input)) in_ocsp_response = Traits::ocsp_response(input);
    typename decltype((*output)->ocsp_response)::BaseType::BufferWriter
        ocsp_response_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_ocsp_response, buffer, &ocsp_response_writer, context);
    (*output)->ocsp_response.Set(
        ocsp_response_writer.is_null() ? nullptr : ocsp_response_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->ocsp_response.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null ocsp_response in RequestParams struct");
    decltype(Traits::sct_list(input)) in_sct_list = Traits::sct_list(input);
    typename decltype((*output)->sct_list)::BaseType::BufferWriter
        sct_list_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_sct_list, buffer, &sct_list_writer, context);
    (*output)->sct_list.Set(
        sct_list_writer.is_null() ? nullptr : sct_list_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->sct_list.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null sct_list in RequestParams struct");
  }

  static bool Deserialize(::cert_verifier::mojom::internal::RequestParams_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::cert_verifier::mojom::RequestParamsDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::cert_verifier::mojom::CertVerifierConfigDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::cert_verifier::mojom::CertVerifierConfigDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::cert_verifier::mojom::internal::CertVerifierConfig_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    (*output)->enable_rev_checking = Traits::enable_rev_checking(input);
    (*output)->require_rev_checking_local_anchors = Traits::require_rev_checking_local_anchors(input);
    (*output)->enable_sha1_local_anchors = Traits::enable_sha1_local_anchors(input);
    (*output)->disable_symantec_enforcement = Traits::disable_symantec_enforcement(input);
    decltype(Traits::crl_set(input)) in_crl_set = Traits::crl_set(input);
    typename decltype((*output)->crl_set)::BufferWriter crl_set_writer;
    crl_set_writer.AllocateInline(buffer, &(*output)->crl_set);
    mojo::internal::Serialize<::mojo_base::mojom::BigBufferDataView>(
        in_crl_set, buffer, &crl_set_writer, true, context);
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->crl_set.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null crl_set in CertVerifierConfig struct");
    decltype(Traits::additional_trust_anchors(input)) in_additional_trust_anchors = Traits::additional_trust_anchors(input);
    typename decltype((*output)->additional_trust_anchors)::BaseType::BufferWriter
        additional_trust_anchors_writer;
    const mojo::internal::ContainerValidateParams additional_trust_anchors_validate_params(
        0, false, nullptr);
    mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::X509CertificateDataView>>(
        in_additional_trust_anchors, buffer, &additional_trust_anchors_writer, &additional_trust_anchors_validate_params,
        context);
    (*output)->additional_trust_anchors.Set(
        additional_trust_anchors_writer.is_null() ? nullptr : additional_trust_anchors_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->additional_trust_anchors.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null additional_trust_anchors in CertVerifierConfig struct");
    decltype(Traits::additional_untrusted_authorities(input)) in_additional_untrusted_authorities = Traits::additional_untrusted_authorities(input);
    typename decltype((*output)->additional_untrusted_authorities)::BaseType::BufferWriter
        additional_untrusted_authorities_writer;
    const mojo::internal::ContainerValidateParams additional_untrusted_authorities_validate_params(
        0, false, nullptr);
    mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::X509CertificateDataView>>(
        in_additional_untrusted_authorities, buffer, &additional_untrusted_authorities_writer, &additional_untrusted_authorities_validate_params,
        context);
    (*output)->additional_untrusted_authorities.Set(
        additional_untrusted_authorities_writer.is_null() ? nullptr : additional_untrusted_authorities_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->additional_untrusted_authorities.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null additional_untrusted_authorities in CertVerifierConfig struct");
  }

  static bool Deserialize(::cert_verifier::mojom::internal::CertVerifierConfig_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::cert_verifier::mojom::CertVerifierConfigDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace cert_verifier {
namespace mojom {

inline void RequestParamsDataView::GetCertificateDataView(
    ::network::mojom::X509CertificateDataView* output) {
  auto pointer = data_->certificate.Get();
  *output = ::network::mojom::X509CertificateDataView(pointer, context_);
}
inline void RequestParamsDataView::GetHostnameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->hostname.Get();
  *output = mojo::StringDataView(pointer, context_);
}
inline void RequestParamsDataView::GetOcspResponseDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->ocsp_response.Get();
  *output = mojo::StringDataView(pointer, context_);
}
inline void RequestParamsDataView::GetSctListDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->sct_list.Get();
  *output = mojo::StringDataView(pointer, context_);
}


inline void CertVerifierConfigDataView::GetCrlSetDataView(
    ::mojo_base::mojom::BigBufferDataView* output) {
  auto pointer = &data_->crl_set;
  *output = ::mojo_base::mojom::BigBufferDataView(pointer, context_);
}
inline void CertVerifierConfigDataView::GetAdditionalTrustAnchorsDataView(
    mojo::ArrayDataView<::network::mojom::X509CertificateDataView>* output) {
  auto pointer = data_->additional_trust_anchors.Get();
  *output = mojo::ArrayDataView<::network::mojom::X509CertificateDataView>(pointer, context_);
}
inline void CertVerifierConfigDataView::GetAdditionalUntrustedAuthoritiesDataView(
    mojo::ArrayDataView<::network::mojom::X509CertificateDataView>* output) {
  auto pointer = data_->additional_untrusted_authorities.Get();
  *output = mojo::ArrayDataView<::network::mojom::X509CertificateDataView>(pointer, context_);
}



}  // namespace mojom
}  // namespace cert_verifier

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_CERT_VERIFIER_SERVICE_MOJOM_SHARED_H_