// services/data_decoder/public/mojom/json_parser.mojom-params-data.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_DATA_DECODER_PUBLIC_MOJOM_JSON_PARSER_MOJOM_PARAMS_DATA_H_
#define SERVICES_DATA_DECODER_PUBLIC_MOJOM_JSON_PARSER_MOJOM_PARAMS_DATA_H_

#include "base/macros.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif
namespace data_decoder {
namespace mojom {
namespace internal {
class  JsonParser_Parse_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(JsonParser_Parse_Params_Data));
      new (data()) JsonParser_Parse_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    JsonParser_Parse_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<JsonParser_Parse_Params_Data>(index_);
    }
    JsonParser_Parse_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> json;

 private:
  JsonParser_Parse_Params_Data();
  ~JsonParser_Parse_Params_Data() = delete;
};
static_assert(sizeof(JsonParser_Parse_Params_Data) == 16,
              "Bad sizeof(JsonParser_Parse_Params_Data)");
class  JsonParser_Parse_ResponseParams_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(JsonParser_Parse_ResponseParams_Data));
      new (data()) JsonParser_Parse_ResponseParams_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    JsonParser_Parse_ResponseParams_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<JsonParser_Parse_ResponseParams_Data>(index_);
    }
    JsonParser_Parse_ResponseParams_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  ::mojo_base::mojom::internal::Value_Data result;
  mojo::internal::Pointer<mojo::internal::String_Data> error;

 private:
  JsonParser_Parse_ResponseParams_Data();
  ~JsonParser_Parse_ResponseParams_Data() = delete;
};
static_assert(sizeof(JsonParser_Parse_ResponseParams_Data) == 32,
              "Bad sizeof(JsonParser_Parse_ResponseParams_Data)");

}  // namespace internal


class JsonParser_Parse_ParamsDataView {
 public:
  JsonParser_Parse_ParamsDataView() {}

  JsonParser_Parse_ParamsDataView(
      internal::JsonParser_Parse_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetJsonDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadJson(UserType* output) {
    
    auto* pointer = data_->json.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
 private:
  internal::JsonParser_Parse_Params_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class JsonParser_Parse_ResponseParamsDataView {
 public:
  JsonParser_Parse_ResponseParamsDataView() {}

  JsonParser_Parse_ResponseParamsDataView(
      internal::JsonParser_Parse_ResponseParams_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetResultDataView(
      ::mojo_base::mojom::ValueDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadResult(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::ValueDataView, UserType>(),
    "Attempting to read the optional `result` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadResult` instead "
    "of `ReadResult if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = !data_->result.is_null() ? &data_->result : nullptr;
    return mojo::internal::Deserialize<::mojo_base::mojom::ValueDataView>(
        pointer, output, context_);
  }
  inline void GetErrorDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadError(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `error` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadError` instead "
    "of `ReadError if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->error.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
 private:
  internal::JsonParser_Parse_ResponseParams_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};


inline void JsonParser_Parse_ParamsDataView::GetJsonDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->json.Get();
  *output = mojo::StringDataView(pointer, context_);
}


inline void JsonParser_Parse_ResponseParamsDataView::GetResultDataView(
    ::mojo_base::mojom::ValueDataView* output) {
  auto pointer = &data_->result;
  *output = ::mojo_base::mojom::ValueDataView(pointer, context_);
}
inline void JsonParser_Parse_ResponseParamsDataView::GetErrorDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->error.Get();
  *output = mojo::StringDataView(pointer, context_);
}

}  // namespace mojom
}  // namespace data_decoder

#if defined(__clang__)
#pragma clang diagnostic pop
#endif

#endif  // SERVICES_DATA_DECODER_PUBLIC_MOJOM_JSON_PARSER_MOJOM_PARAMS_DATA_H_