// media/mojo/mojom/video_encode_accelerator.mojom-shared-internal.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MOJO_MOJOM_VIDEO_ENCODE_ACCELERATOR_MOJOM_SHARED_INTERNAL_H_
#define MEDIA_MOJO_MOJOM_VIDEO_ENCODE_ACCELERATOR_MOJOM_SHARED_INTERNAL_H_

#include "mojo/public/cpp/bindings/lib/array_internal.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/map_data_internal.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"
#include "media/mojo/mojom/media_types.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared-internal.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared-internal.h"
#include "media/mojo/mojom/video_encoder_info.mojom-shared-internal.h"
#include "mojo/public/cpp/bindings/lib/native_enum_data.h"
#include "mojo/public/interfaces/bindings/native_struct.mojom-shared-internal.h"



namespace mojo {
namespace internal {
class ValidationContext;
}
}
namespace media {
namespace mojom {
namespace internal {
class VideoEncodeAcceleratorSupportedProfile_Data;
class VideoBitrateAllocation_Data;
class SpatialLayer_Data;
class VideoEncodeAcceleratorConfig_Data;
class Vp8Metadata_Data;
class Vp9Metadata_Data;
class BitstreamBufferMetadata_Data;
class CodecMetadata_Data;

struct VideoEncodeAcceleratorConfig_ContentType_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
      case 1:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

struct VideoEncodeAcceleratorConfig_StorageType_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
      case 1:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

struct VideoEncodeAccelerator_Error_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
      case 1:
      case 2:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

#pragma pack(push, 1)


class  CodecMetadata_Data {
 public:
  // Used to identify Mojom Union Data Classes.
  typedef void MojomUnionDataType;

  CodecMetadata_Data() {}
  // Do nothing in the destructor since it won't be called when it is a
  // non-inlined union.
  ~CodecMetadata_Data() {}

  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(CodecMetadata_Data));
      new (data()) CodecMetadata_Data();
    }

    void AllocateInline(mojo::internal::Buffer* serialization_buffer,
                        void* ptr) {
      const char* start = static_cast<const char*>(
          serialization_buffer->data());
      const char* slot = static_cast<const char*>(ptr);
      DCHECK_GT(slot, start);
      serialization_buffer_ = serialization_buffer;
      index_ = slot - start;
      new (data()) CodecMetadata_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    CodecMetadata_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<CodecMetadata_Data>(index_);
    }
    CodecMetadata_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context,
                       bool inlined);

  bool is_null() const { return size == 0; }

  void set_null() {
    size = 0U;
    tag = static_cast<CodecMetadata_Tag>(0);
    data.unknown = 0U;
  }

  enum class CodecMetadata_Tag : uint32_t {

    
    VP8,
    
    VP9,
  };

  // A note on layout:
  // "Each non-static data member is allocated as if it were the sole member of
  // a struct." - Section 9.5.2 ISO/IEC 14882:2011 (The C++ Spec)
  union MOJO_ALIGNAS(8) Union_ {
    Union_() : unknown(0) {}
    mojo::internal::Pointer<internal::Vp8Metadata_Data> f_vp8;
    mojo::internal::Pointer<internal::Vp9Metadata_Data> f_vp9;
    uint64_t unknown;
  };

  uint32_t size;
  CodecMetadata_Tag tag;
  Union_ data;
};
static_assert(sizeof(CodecMetadata_Data) == mojo::internal::kUnionDataSize,
              "Bad sizeof(CodecMetadata_Data)");
class  VideoEncodeAcceleratorSupportedProfile_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(VideoEncodeAcceleratorSupportedProfile_Data));
      new (data()) VideoEncodeAcceleratorSupportedProfile_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    VideoEncodeAcceleratorSupportedProfile_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<VideoEncodeAcceleratorSupportedProfile_Data>(index_);
    }
    VideoEncodeAcceleratorSupportedProfile_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t profile;
  uint32_t max_framerate_numerator;
  mojo::internal::Pointer<::gfx::mojom::internal::Size_Data> min_resolution;
  mojo::internal::Pointer<::gfx::mojom::internal::Size_Data> max_resolution;
  uint32_t max_framerate_denominator;
  uint8_t padfinal_[4];

 private:
  VideoEncodeAcceleratorSupportedProfile_Data();
  ~VideoEncodeAcceleratorSupportedProfile_Data() = delete;
};
static_assert(sizeof(VideoEncodeAcceleratorSupportedProfile_Data) == 40,
              "Bad sizeof(VideoEncodeAcceleratorSupportedProfile_Data)");
// Used by VideoEncodeAcceleratorSupportedProfile::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct VideoEncodeAcceleratorSupportedProfile_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  VideoEncodeAcceleratorSupportedProfile_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~VideoEncodeAcceleratorSupportedProfile_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::internal::SerializationContext* context,
                 mojo::internal::Buffer* buffer) override {
    VideoEncodeAcceleratorSupportedProfile_Data::BufferWriter writer;
    mojo::internal::Serialize<DataView>(user_data_, buffer, &writer, context);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    VideoEncodeAcceleratorSupportedProfile_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  VideoBitrateAllocation_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(VideoBitrateAllocation_Data));
      new (data()) VideoBitrateAllocation_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    VideoBitrateAllocation_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<VideoBitrateAllocation_Data>(index_);
    }
    VideoBitrateAllocation_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::Array_Data<int32_t>> bitrates;

 private:
  VideoBitrateAllocation_Data();
  ~VideoBitrateAllocation_Data() = delete;
};
static_assert(sizeof(VideoBitrateAllocation_Data) == 16,
              "Bad sizeof(VideoBitrateAllocation_Data)");
// Used by VideoBitrateAllocation::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct VideoBitrateAllocation_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  VideoBitrateAllocation_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~VideoBitrateAllocation_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::internal::SerializationContext* context,
                 mojo::internal::Buffer* buffer) override {
    VideoBitrateAllocation_Data::BufferWriter writer;
    mojo::internal::Serialize<DataView>(user_data_, buffer, &writer, context);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    VideoBitrateAllocation_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  SpatialLayer_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(SpatialLayer_Data));
      new (data()) SpatialLayer_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    SpatialLayer_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<SpatialLayer_Data>(index_);
    }
    SpatialLayer_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t width;
  int32_t height;
  uint32_t bitrate_bps;
  uint32_t framerate;
  uint8_t max_qp;
  uint8_t num_of_temporal_layers;
  uint8_t padfinal_[6];

 private:
  SpatialLayer_Data();
  ~SpatialLayer_Data() = delete;
};
static_assert(sizeof(SpatialLayer_Data) == 32,
              "Bad sizeof(SpatialLayer_Data)");
// Used by SpatialLayer::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct SpatialLayer_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  SpatialLayer_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~SpatialLayer_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::internal::SerializationContext* context,
                 mojo::internal::Buffer* buffer) override {
    SpatialLayer_Data::BufferWriter writer;
    mojo::internal::Serialize<DataView>(user_data_, buffer, &writer, context);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    SpatialLayer_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  VideoEncodeAcceleratorConfig_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(VideoEncodeAcceleratorConfig_Data));
      new (data()) VideoEncodeAcceleratorConfig_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    VideoEncodeAcceleratorConfig_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<VideoEncodeAcceleratorConfig_Data>(index_);
    }
    VideoEncodeAcceleratorConfig_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t input_format;
  int32_t output_profile;
  mojo::internal::Pointer<::gfx::mojom::internal::Size_Data> input_visible_size;
  uint32_t initial_bitrate;
  uint32_t initial_framerate;
  uint8_t has_initial_framerate : 1;
  uint8_t has_gop_length : 1;
  uint8_t has_h264_output_level : 1;
  uint8_t is_constrained_h264 : 1;
  uint8_t has_storage_type : 1;
  uint8_t h264_output_level;
  uint8_t pad10_[2];
  uint32_t gop_length;
  int32_t storage_type;
  int32_t content_type;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<internal::SpatialLayer_Data>>> spatial_layers;

 private:
  VideoEncodeAcceleratorConfig_Data();
  ~VideoEncodeAcceleratorConfig_Data() = delete;
};
static_assert(sizeof(VideoEncodeAcceleratorConfig_Data) == 56,
              "Bad sizeof(VideoEncodeAcceleratorConfig_Data)");
// Used by VideoEncodeAcceleratorConfig::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct VideoEncodeAcceleratorConfig_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  VideoEncodeAcceleratorConfig_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~VideoEncodeAcceleratorConfig_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::internal::SerializationContext* context,
                 mojo::internal::Buffer* buffer) override {
    VideoEncodeAcceleratorConfig_Data::BufferWriter writer;
    mojo::internal::Serialize<DataView>(user_data_, buffer, &writer, context);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    VideoEncodeAcceleratorConfig_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  Vp8Metadata_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(Vp8Metadata_Data));
      new (data()) Vp8Metadata_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    Vp8Metadata_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<Vp8Metadata_Data>(index_);
    }
    Vp8Metadata_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t non_reference : 1;
  uint8_t layer_sync : 1;
  uint8_t temporal_idx;
  uint8_t padfinal_[6];

 private:
  Vp8Metadata_Data();
  ~Vp8Metadata_Data() = delete;
};
static_assert(sizeof(Vp8Metadata_Data) == 16,
              "Bad sizeof(Vp8Metadata_Data)");
// Used by Vp8Metadata::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct Vp8Metadata_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  Vp8Metadata_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~Vp8Metadata_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::internal::SerializationContext* context,
                 mojo::internal::Buffer* buffer) override {
    Vp8Metadata_Data::BufferWriter writer;
    mojo::internal::Serialize<DataView>(user_data_, buffer, &writer, context);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    Vp8Metadata_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  Vp9Metadata_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(Vp9Metadata_Data));
      new (data()) Vp9Metadata_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    Vp9Metadata_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<Vp9Metadata_Data>(index_);
    }
    Vp9Metadata_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t has_reference : 1;
  uint8_t temporal_up_switch : 1;
  uint8_t temporal_idx;
  uint8_t pad2_[6];
  mojo::internal::Pointer<mojo::internal::Array_Data<uint8_t>> p_diffs;

 private:
  Vp9Metadata_Data();
  ~Vp9Metadata_Data() = delete;
};
static_assert(sizeof(Vp9Metadata_Data) == 24,
              "Bad sizeof(Vp9Metadata_Data)");
// Used by Vp9Metadata::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct Vp9Metadata_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  Vp9Metadata_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~Vp9Metadata_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::internal::SerializationContext* context,
                 mojo::internal::Buffer* buffer) override {
    Vp9Metadata_Data::BufferWriter writer;
    mojo::internal::Serialize<DataView>(user_data_, buffer, &writer, context);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    Vp9Metadata_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  BitstreamBufferMetadata_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(BitstreamBufferMetadata_Data));
      new (data()) BitstreamBufferMetadata_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    BitstreamBufferMetadata_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<BitstreamBufferMetadata_Data>(index_);
    }
    BitstreamBufferMetadata_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint32_t payload_size_bytes;
  uint8_t key_frame : 1;
  uint8_t pad1_[3];
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeDelta_Data> timestamp;
  internal::CodecMetadata_Data codec_metadata;

 private:
  BitstreamBufferMetadata_Data();
  ~BitstreamBufferMetadata_Data() = delete;
};
static_assert(sizeof(BitstreamBufferMetadata_Data) == 40,
              "Bad sizeof(BitstreamBufferMetadata_Data)");
// Used by BitstreamBufferMetadata::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct BitstreamBufferMetadata_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  BitstreamBufferMetadata_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~BitstreamBufferMetadata_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::internal::SerializationContext* context,
                 mojo::internal::Buffer* buffer) override {
    BitstreamBufferMetadata_Data::BufferWriter writer;
    mojo::internal::Serialize<DataView>(user_data_, buffer, &writer, context);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    BitstreamBufferMetadata_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};

#pragma pack(pop)

}  // namespace internal
}  // namespace mojom
}  // namespace media

#endif  // MEDIA_MOJO_MOJOM_VIDEO_ENCODE_ACCELERATOR_MOJOM_SHARED_INTERNAL_H_