// content/common/navigation_client.mojom-params-data.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_COMMON_NAVIGATION_CLIENT_MOJOM_PARAMS_DATA_H_
#define CONTENT_COMMON_NAVIGATION_CLIENT_MOJOM_PARAMS_DATA_H_

#include "base/macros.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif
namespace content {
namespace mojom {
namespace internal {
class COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) NavigationClient_CommitNavigation_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(NavigationClient_CommitNavigation_Params_Data));
      new (data()) NavigationClient_CommitNavigation_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    NavigationClient_CommitNavigation_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<NavigationClient_CommitNavigation_Params_Data>(index_);
    }
    NavigationClient_CommitNavigation_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::content::mojom::internal::CommonNavigationParams_Data> common_params;
  mojo::internal::Pointer<::content::mojom::internal::CommitNavigationParams_Data> request_params;
  mojo::internal::Pointer<::network::mojom::internal::URLResponseHead_Data> response_head;
  mojo::internal::Handle_Data response_body;
  uint8_t pad3_[4];
  mojo::internal::Pointer<::network::mojom::internal::URLLoaderClientEndpoints_Data> url_loader_client_endpoints;
  mojo::internal::Pointer<::blink::mojom::internal::URLLoaderFactoryBundle_Data> subresource_loader_factories;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<::blink::mojom::internal::TransferrableURLLoader_Data>>> subresource_overrides;
  mojo::internal::Pointer<::blink::mojom::internal::ControllerServiceWorkerInfo_Data> controller_service_worker_info;
  mojo::internal::Pointer<::blink::mojom::internal::ServiceWorkerContainerInfoForClient_Data> container_info;
  mojo::internal::Interface_Data prefetch_loader_factory;
  mojo::internal::Pointer<::mojo_base::mojom::internal::UnguessableToken_Data> devtools_navigation_token;

 private:
  NavigationClient_CommitNavigation_Params_Data();
  ~NavigationClient_CommitNavigation_Params_Data() = delete;
};
static_assert(sizeof(NavigationClient_CommitNavigation_Params_Data) == 96,
              "Bad sizeof(NavigationClient_CommitNavigation_Params_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) NavigationClient_CommitNavigation_ResponseParams_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(NavigationClient_CommitNavigation_ResponseParams_Data));
      new (data()) NavigationClient_CommitNavigation_ResponseParams_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    NavigationClient_CommitNavigation_ResponseParams_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<NavigationClient_CommitNavigation_ResponseParams_Data>(index_);
    }
    NavigationClient_CommitNavigation_ResponseParams_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::content::mojom::internal::DidCommitProvisionalLoadParams_Data> params;
  mojo::internal::Pointer<::content::mojom::internal::DidCommitProvisionalLoadInterfaceParams_Data> interface_params;

 private:
  NavigationClient_CommitNavigation_ResponseParams_Data();
  ~NavigationClient_CommitNavigation_ResponseParams_Data() = delete;
};
static_assert(sizeof(NavigationClient_CommitNavigation_ResponseParams_Data) == 24,
              "Bad sizeof(NavigationClient_CommitNavigation_ResponseParams_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) NavigationClient_CommitFailedNavigation_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(NavigationClient_CommitFailedNavigation_Params_Data));
      new (data()) NavigationClient_CommitFailedNavigation_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    NavigationClient_CommitFailedNavigation_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<NavigationClient_CommitFailedNavigation_Params_Data>(index_);
    }
    NavigationClient_CommitFailedNavigation_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::content::mojom::internal::CommonNavigationParams_Data> common_params;
  mojo::internal::Pointer<::content::mojom::internal::CommitNavigationParams_Data> request_params;
  uint8_t has_stale_copy_in_cache : 1;
  uint8_t pad2_[3];
  int32_t error_code;
  mojo::internal::Pointer<::network::mojom::internal::ResolveErrorInfo_Data> resolve_error_info;
  mojo::internal::Pointer<mojo::internal::String_Data> error_page_content;
  mojo::internal::Pointer<::blink::mojom::internal::URLLoaderFactoryBundle_Data> subresource_loader_factories;

 private:
  NavigationClient_CommitFailedNavigation_Params_Data();
  ~NavigationClient_CommitFailedNavigation_Params_Data() = delete;
};
static_assert(sizeof(NavigationClient_CommitFailedNavigation_Params_Data) == 56,
              "Bad sizeof(NavigationClient_CommitFailedNavigation_Params_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) NavigationClient_CommitFailedNavigation_ResponseParams_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(NavigationClient_CommitFailedNavigation_ResponseParams_Data));
      new (data()) NavigationClient_CommitFailedNavigation_ResponseParams_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    NavigationClient_CommitFailedNavigation_ResponseParams_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<NavigationClient_CommitFailedNavigation_ResponseParams_Data>(index_);
    }
    NavigationClient_CommitFailedNavigation_ResponseParams_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::content::mojom::internal::DidCommitProvisionalLoadParams_Data> params;
  mojo::internal::Pointer<::content::mojom::internal::DidCommitProvisionalLoadInterfaceParams_Data> interface_params;

 private:
  NavigationClient_CommitFailedNavigation_ResponseParams_Data();
  ~NavigationClient_CommitFailedNavigation_ResponseParams_Data() = delete;
};
static_assert(sizeof(NavigationClient_CommitFailedNavigation_ResponseParams_Data) == 24,
              "Bad sizeof(NavigationClient_CommitFailedNavigation_ResponseParams_Data)");

}  // namespace internal


class NavigationClient_CommitNavigation_ParamsDataView {
 public:
  NavigationClient_CommitNavigation_ParamsDataView() {}

  NavigationClient_CommitNavigation_ParamsDataView(
      internal::NavigationClient_CommitNavigation_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetCommonParamsDataView(
      ::content::mojom::CommonNavigationParamsDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadCommonParams(UserType* output) {
    
    auto* pointer = data_->common_params.Get();
    return mojo::internal::Deserialize<::content::mojom::CommonNavigationParamsDataView>(
        pointer, output, context_);
  }
  inline void GetRequestParamsDataView(
      ::content::mojom::CommitNavigationParamsDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadRequestParams(UserType* output) {
    
    auto* pointer = data_->request_params.Get();
    return mojo::internal::Deserialize<::content::mojom::CommitNavigationParamsDataView>(
        pointer, output, context_);
  }
  inline void GetResponseHeadDataView(
      ::network::mojom::URLResponseHeadDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadResponseHead(UserType* output) {
    
    auto* pointer = data_->response_head.Get();
    return mojo::internal::Deserialize<::network::mojom::URLResponseHeadDataView>(
        pointer, output, context_);
  }
  mojo::ScopedDataPipeConsumerHandle TakeResponseBody() {
    mojo::ScopedDataPipeConsumerHandle result;
    bool ret =
        mojo::internal::Deserialize<mojo::ScopedDataPipeConsumerHandle>(
            &data_->response_body, &result, context_);
    DCHECK(ret);
    return result;
  }
  inline void GetUrlLoaderClientEndpointsDataView(
      ::network::mojom::URLLoaderClientEndpointsDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadUrlLoaderClientEndpoints(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::network::mojom::URLLoaderClientEndpointsDataView, UserType>(),
    "Attempting to read the optional `url_loader_client_endpoints` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadUrlLoaderClientEndpoints` instead "
    "of `ReadUrlLoaderClientEndpoints if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->url_loader_client_endpoints.Get();
    return mojo::internal::Deserialize<::network::mojom::URLLoaderClientEndpointsDataView>(
        pointer, output, context_);
  }
  inline void GetSubresourceLoaderFactoriesDataView(
      ::blink::mojom::URLLoaderFactoryBundleDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadSubresourceLoaderFactories(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::URLLoaderFactoryBundleDataView, UserType>(),
    "Attempting to read the optional `subresource_loader_factories` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadSubresourceLoaderFactories` instead "
    "of `ReadSubresourceLoaderFactories if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->subresource_loader_factories.Get();
    return mojo::internal::Deserialize<::blink::mojom::URLLoaderFactoryBundleDataView>(
        pointer, output, context_);
  }
  inline void GetSubresourceOverridesDataView(
      mojo::ArrayDataView<::blink::mojom::TransferrableURLLoaderDataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadSubresourceOverrides(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<::blink::mojom::TransferrableURLLoaderDataView>, UserType>(),
    "Attempting to read the optional `subresource_overrides` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadSubresourceOverrides` instead "
    "of `ReadSubresourceOverrides if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->subresource_overrides.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::TransferrableURLLoaderDataView>>(
        pointer, output, context_);
  }
  inline void GetControllerServiceWorkerInfoDataView(
      ::blink::mojom::ControllerServiceWorkerInfoDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadControllerServiceWorkerInfo(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::ControllerServiceWorkerInfoDataView, UserType>(),
    "Attempting to read the optional `controller_service_worker_info` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadControllerServiceWorkerInfo` instead "
    "of `ReadControllerServiceWorkerInfo if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->controller_service_worker_info.Get();
    return mojo::internal::Deserialize<::blink::mojom::ControllerServiceWorkerInfoDataView>(
        pointer, output, context_);
  }
  inline void GetContainerInfoDataView(
      ::blink::mojom::ServiceWorkerContainerInfoForClientDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadContainerInfo(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::ServiceWorkerContainerInfoForClientDataView, UserType>(),
    "Attempting to read the optional `container_info` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadContainerInfo` instead "
    "of `ReadContainerInfo if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->container_info.Get();
    return mojo::internal::Deserialize<::blink::mojom::ServiceWorkerContainerInfoForClientDataView>(
        pointer, output, context_);
  }
  template <typename UserType>
  UserType TakePrefetchLoaderFactory() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::network::mojom::URLLoaderFactoryInterfaceBase>>(
            &data_->prefetch_loader_factory, &result, context_);
    DCHECK(ret);
    return result;
  }
  inline void GetDevtoolsNavigationTokenDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadDevtoolsNavigationToken(UserType* output) {
    
    auto* pointer = data_->devtools_navigation_token.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, context_);
  }
 private:
  internal::NavigationClient_CommitNavigation_Params_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class NavigationClient_CommitNavigation_ResponseParamsDataView {
 public:
  NavigationClient_CommitNavigation_ResponseParamsDataView() {}

  NavigationClient_CommitNavigation_ResponseParamsDataView(
      internal::NavigationClient_CommitNavigation_ResponseParams_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetParamsDataView(
      ::content::mojom::DidCommitProvisionalLoadParamsDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadParams(UserType* output) {
    
    auto* pointer = data_->params.Get();
    return mojo::internal::Deserialize<::content::mojom::DidCommitProvisionalLoadParamsDataView>(
        pointer, output, context_);
  }
  inline void GetInterfaceParamsDataView(
      ::content::mojom::DidCommitProvisionalLoadInterfaceParamsDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadInterfaceParams(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::content::mojom::DidCommitProvisionalLoadInterfaceParamsDataView, UserType>(),
    "Attempting to read the optional `interface_params` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadInterfaceParams` instead "
    "of `ReadInterfaceParams if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->interface_params.Get();
    return mojo::internal::Deserialize<::content::mojom::DidCommitProvisionalLoadInterfaceParamsDataView>(
        pointer, output, context_);
  }
 private:
  internal::NavigationClient_CommitNavigation_ResponseParams_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class NavigationClient_CommitFailedNavigation_ParamsDataView {
 public:
  NavigationClient_CommitFailedNavigation_ParamsDataView() {}

  NavigationClient_CommitFailedNavigation_ParamsDataView(
      internal::NavigationClient_CommitFailedNavigation_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetCommonParamsDataView(
      ::content::mojom::CommonNavigationParamsDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadCommonParams(UserType* output) {
    
    auto* pointer = data_->common_params.Get();
    return mojo::internal::Deserialize<::content::mojom::CommonNavigationParamsDataView>(
        pointer, output, context_);
  }
  inline void GetRequestParamsDataView(
      ::content::mojom::CommitNavigationParamsDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadRequestParams(UserType* output) {
    
    auto* pointer = data_->request_params.Get();
    return mojo::internal::Deserialize<::content::mojom::CommitNavigationParamsDataView>(
        pointer, output, context_);
  }
  bool has_stale_copy_in_cache() const {
    return data_->has_stale_copy_in_cache;
  }
  int32_t error_code() const {
    return data_->error_code;
  }
  inline void GetResolveErrorInfoDataView(
      ::network::mojom::ResolveErrorInfoDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadResolveErrorInfo(UserType* output) {
    
    auto* pointer = data_->resolve_error_info.Get();
    return mojo::internal::Deserialize<::network::mojom::ResolveErrorInfoDataView>(
        pointer, output, context_);
  }
  inline void GetErrorPageContentDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadErrorPageContent(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `error_page_content` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadErrorPageContent` instead "
    "of `ReadErrorPageContent if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->error_page_content.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
  inline void GetSubresourceLoaderFactoriesDataView(
      ::blink::mojom::URLLoaderFactoryBundleDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadSubresourceLoaderFactories(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::URLLoaderFactoryBundleDataView, UserType>(),
    "Attempting to read the optional `subresource_loader_factories` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadSubresourceLoaderFactories` instead "
    "of `ReadSubresourceLoaderFactories if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->subresource_loader_factories.Get();
    return mojo::internal::Deserialize<::blink::mojom::URLLoaderFactoryBundleDataView>(
        pointer, output, context_);
  }
 private:
  internal::NavigationClient_CommitFailedNavigation_Params_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class NavigationClient_CommitFailedNavigation_ResponseParamsDataView {
 public:
  NavigationClient_CommitFailedNavigation_ResponseParamsDataView() {}

  NavigationClient_CommitFailedNavigation_ResponseParamsDataView(
      internal::NavigationClient_CommitFailedNavigation_ResponseParams_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetParamsDataView(
      ::content::mojom::DidCommitProvisionalLoadParamsDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadParams(UserType* output) {
    
    auto* pointer = data_->params.Get();
    return mojo::internal::Deserialize<::content::mojom::DidCommitProvisionalLoadParamsDataView>(
        pointer, output, context_);
  }
  inline void GetInterfaceParamsDataView(
      ::content::mojom::DidCommitProvisionalLoadInterfaceParamsDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadInterfaceParams(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::content::mojom::DidCommitProvisionalLoadInterfaceParamsDataView, UserType>(),
    "Attempting to read the optional `interface_params` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadInterfaceParams` instead "
    "of `ReadInterfaceParams if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->interface_params.Get();
    return mojo::internal::Deserialize<::content::mojom::DidCommitProvisionalLoadInterfaceParamsDataView>(
        pointer, output, context_);
  }
 private:
  internal::NavigationClient_CommitFailedNavigation_ResponseParams_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};


inline void NavigationClient_CommitNavigation_ParamsDataView::GetCommonParamsDataView(
    ::content::mojom::CommonNavigationParamsDataView* output) {
  auto pointer = data_->common_params.Get();
  *output = ::content::mojom::CommonNavigationParamsDataView(pointer, context_);
}
inline void NavigationClient_CommitNavigation_ParamsDataView::GetRequestParamsDataView(
    ::content::mojom::CommitNavigationParamsDataView* output) {
  auto pointer = data_->request_params.Get();
  *output = ::content::mojom::CommitNavigationParamsDataView(pointer, context_);
}
inline void NavigationClient_CommitNavigation_ParamsDataView::GetResponseHeadDataView(
    ::network::mojom::URLResponseHeadDataView* output) {
  auto pointer = data_->response_head.Get();
  *output = ::network::mojom::URLResponseHeadDataView(pointer, context_);
}
inline void NavigationClient_CommitNavigation_ParamsDataView::GetUrlLoaderClientEndpointsDataView(
    ::network::mojom::URLLoaderClientEndpointsDataView* output) {
  auto pointer = data_->url_loader_client_endpoints.Get();
  *output = ::network::mojom::URLLoaderClientEndpointsDataView(pointer, context_);
}
inline void NavigationClient_CommitNavigation_ParamsDataView::GetSubresourceLoaderFactoriesDataView(
    ::blink::mojom::URLLoaderFactoryBundleDataView* output) {
  auto pointer = data_->subresource_loader_factories.Get();
  *output = ::blink::mojom::URLLoaderFactoryBundleDataView(pointer, context_);
}
inline void NavigationClient_CommitNavigation_ParamsDataView::GetSubresourceOverridesDataView(
    mojo::ArrayDataView<::blink::mojom::TransferrableURLLoaderDataView>* output) {
  auto pointer = data_->subresource_overrides.Get();
  *output = mojo::ArrayDataView<::blink::mojom::TransferrableURLLoaderDataView>(pointer, context_);
}
inline void NavigationClient_CommitNavigation_ParamsDataView::GetControllerServiceWorkerInfoDataView(
    ::blink::mojom::ControllerServiceWorkerInfoDataView* output) {
  auto pointer = data_->controller_service_worker_info.Get();
  *output = ::blink::mojom::ControllerServiceWorkerInfoDataView(pointer, context_);
}
inline void NavigationClient_CommitNavigation_ParamsDataView::GetContainerInfoDataView(
    ::blink::mojom::ServiceWorkerContainerInfoForClientDataView* output) {
  auto pointer = data_->container_info.Get();
  *output = ::blink::mojom::ServiceWorkerContainerInfoForClientDataView(pointer, context_);
}
inline void NavigationClient_CommitNavigation_ParamsDataView::GetDevtoolsNavigationTokenDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->devtools_navigation_token.Get();
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, context_);
}


inline void NavigationClient_CommitNavigation_ResponseParamsDataView::GetParamsDataView(
    ::content::mojom::DidCommitProvisionalLoadParamsDataView* output) {
  auto pointer = data_->params.Get();
  *output = ::content::mojom::DidCommitProvisionalLoadParamsDataView(pointer, context_);
}
inline void NavigationClient_CommitNavigation_ResponseParamsDataView::GetInterfaceParamsDataView(
    ::content::mojom::DidCommitProvisionalLoadInterfaceParamsDataView* output) {
  auto pointer = data_->interface_params.Get();
  *output = ::content::mojom::DidCommitProvisionalLoadInterfaceParamsDataView(pointer, context_);
}


inline void NavigationClient_CommitFailedNavigation_ParamsDataView::GetCommonParamsDataView(
    ::content::mojom::CommonNavigationParamsDataView* output) {
  auto pointer = data_->common_params.Get();
  *output = ::content::mojom::CommonNavigationParamsDataView(pointer, context_);
}
inline void NavigationClient_CommitFailedNavigation_ParamsDataView::GetRequestParamsDataView(
    ::content::mojom::CommitNavigationParamsDataView* output) {
  auto pointer = data_->request_params.Get();
  *output = ::content::mojom::CommitNavigationParamsDataView(pointer, context_);
}
inline void NavigationClient_CommitFailedNavigation_ParamsDataView::GetResolveErrorInfoDataView(
    ::network::mojom::ResolveErrorInfoDataView* output) {
  auto pointer = data_->resolve_error_info.Get();
  *output = ::network::mojom::ResolveErrorInfoDataView(pointer, context_);
}
inline void NavigationClient_CommitFailedNavigation_ParamsDataView::GetErrorPageContentDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->error_page_content.Get();
  *output = mojo::StringDataView(pointer, context_);
}
inline void NavigationClient_CommitFailedNavigation_ParamsDataView::GetSubresourceLoaderFactoriesDataView(
    ::blink::mojom::URLLoaderFactoryBundleDataView* output) {
  auto pointer = data_->subresource_loader_factories.Get();
  *output = ::blink::mojom::URLLoaderFactoryBundleDataView(pointer, context_);
}


inline void NavigationClient_CommitFailedNavigation_ResponseParamsDataView::GetParamsDataView(
    ::content::mojom::DidCommitProvisionalLoadParamsDataView* output) {
  auto pointer = data_->params.Get();
  *output = ::content::mojom::DidCommitProvisionalLoadParamsDataView(pointer, context_);
}
inline void NavigationClient_CommitFailedNavigation_ResponseParamsDataView::GetInterfaceParamsDataView(
    ::content::mojom::DidCommitProvisionalLoadInterfaceParamsDataView* output) {
  auto pointer = data_->interface_params.Get();
  *output = ::content::mojom::DidCommitProvisionalLoadInterfaceParamsDataView(pointer, context_);
}

}  // namespace mojom
}  // namespace content

#if defined(__clang__)
#pragma clang diagnostic pop
#endif

#endif  // CONTENT_COMMON_NAVIGATION_CLIENT_MOJOM_PARAMS_DATA_H_