// content/browser/conversions/conversion_internals.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_BROWSER_CONVERSIONS_CONVERSION_INTERNALS_MOJOM_H_
#define CONTENT_BROWSER_CONVERSIONS_CONVERSION_INTERNALS_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "content/browser/conversions/conversion_internals.mojom-shared.h"
#include "content/browser/conversions/conversion_internals.mojom-forward.h"
#include "url/mojom/origin.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"





// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace mojom {

class ConversionInternalsHandlerProxy;

template <typename ImplRefTraits>
class ConversionInternalsHandlerStub;

class ConversionInternalsHandlerRequestValidator;
class ConversionInternalsHandlerResponseValidator;


class  ConversionInternalsHandler
    : public ConversionInternalsHandlerInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = ConversionInternalsHandlerInterfaceBase;
  using Proxy_ = ConversionInternalsHandlerProxy;

  template <typename ImplRefTraits>
  using Stub_ = ConversionInternalsHandlerStub<ImplRefTraits>;

  using RequestValidator_ = ConversionInternalsHandlerRequestValidator;
  using ResponseValidator_ = ConversionInternalsHandlerResponseValidator;
  enum MethodMinVersions : uint32_t {
    kIsMeasurementEnabledMinVersion = 0,
    kGetActiveImpressionsMinVersion = 0,
    kGetPendingReportsMinVersion = 0,
    kSendPendingReportsMinVersion = 0,
    kClearStorageMinVersion = 0,
  };
  virtual ~ConversionInternalsHandler() {}


  using IsMeasurementEnabledCallback = base::OnceCallback<void(bool)>;
  
  virtual void IsMeasurementEnabled(IsMeasurementEnabledCallback callback) = 0;


  using GetActiveImpressionsCallback = base::OnceCallback<void(std::vector<WebUIImpressionPtr>)>;
  
  virtual void GetActiveImpressions(GetActiveImpressionsCallback callback) = 0;


  using GetPendingReportsCallback = base::OnceCallback<void(std::vector<WebUIConversionReportPtr>)>;
  
  virtual void GetPendingReports(GetPendingReportsCallback callback) = 0;


  using SendPendingReportsCallback = base::OnceCallback<void()>;
  
  virtual void SendPendingReports(SendPendingReportsCallback callback) = 0;


  using ClearStorageCallback = base::OnceCallback<void()>;
  
  virtual void ClearStorage(ClearStorageCallback callback) = 0;
};



class  ConversionInternalsHandlerProxy
    : public ConversionInternalsHandler {
 public:
  using InterfaceType = ConversionInternalsHandler;

  explicit ConversionInternalsHandlerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void IsMeasurementEnabled(IsMeasurementEnabledCallback callback) final;
  
  void GetActiveImpressions(GetActiveImpressionsCallback callback) final;
  
  void GetPendingReports(GetPendingReportsCallback callback) final;
  
  void SendPendingReports(SendPendingReportsCallback callback) final;
  
  void ClearStorage(ClearStorageCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  ConversionInternalsHandlerStubDispatch {
 public:
  static bool Accept(ConversionInternalsHandler* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ConversionInternalsHandler* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ConversionInternalsHandler>>
class ConversionInternalsHandlerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ConversionInternalsHandlerStub() {}
  ~ConversionInternalsHandlerStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ConversionInternalsHandlerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ConversionInternalsHandlerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  ConversionInternalsHandlerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  ConversionInternalsHandlerResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};









class  WebUIConversionReport {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<WebUIConversionReport, T>::value>;
  using DataView = WebUIConversionReportDataView;
  using Data_ = internal::WebUIConversionReport_Data;

  template <typename... Args>
  static WebUIConversionReportPtr New(Args&&... args) {
    return WebUIConversionReportPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static WebUIConversionReportPtr From(const U& u) {
    return mojo::TypeConverter<WebUIConversionReportPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, WebUIConversionReport>::Convert(*this);
  }


  WebUIConversionReport();

  WebUIConversionReport(
      const std::string& impression_data,
      const std::string& conversion_data,
      const ::url::Origin& conversion_origin,
      const ::url::Origin& reporting_origin,
      double report_time,
      int32_t attribution_credit);

  ~WebUIConversionReport();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = WebUIConversionReportPtr>
  WebUIConversionReportPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, WebUIConversionReport::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebUIConversionReport::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        WebUIConversionReport::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::WebUIConversionReport_UnserializedMessageContext<
            UserType, WebUIConversionReport::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<WebUIConversionReport::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return WebUIConversionReport::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::WebUIConversionReport_UnserializedMessageContext<
            UserType, WebUIConversionReport::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<WebUIConversionReport::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  std::string impression_data;
  
  std::string conversion_data;
  
  ::url::Origin conversion_origin;
  
  ::url::Origin reporting_origin;
  
  double report_time;
  
  int32_t attribution_credit;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, WebUIConversionReport::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, WebUIConversionReport::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, WebUIConversionReport::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, WebUIConversionReport::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  WebUIImpression {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<WebUIImpression, T>::value>;
  using DataView = WebUIImpressionDataView;
  using Data_ = internal::WebUIImpression_Data;

  template <typename... Args>
  static WebUIImpressionPtr New(Args&&... args) {
    return WebUIImpressionPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static WebUIImpressionPtr From(const U& u) {
    return mojo::TypeConverter<WebUIImpressionPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, WebUIImpression>::Convert(*this);
  }


  WebUIImpression();

  WebUIImpression(
      const std::string& impression_data,
      const ::url::Origin& impression_origin,
      const ::url::Origin& conversion_destination,
      const ::url::Origin& reporting_origin,
      double impression_time,
      double expiry_time);

  ~WebUIImpression();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = WebUIImpressionPtr>
  WebUIImpressionPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, WebUIImpression::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebUIImpression::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        WebUIImpression::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::WebUIImpression_UnserializedMessageContext<
            UserType, WebUIImpression::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<WebUIImpression::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return WebUIImpression::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::WebUIImpression_UnserializedMessageContext<
            UserType, WebUIImpression::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<WebUIImpression::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  std::string impression_data;
  
  ::url::Origin impression_origin;
  
  ::url::Origin conversion_destination;
  
  ::url::Origin reporting_origin;
  
  double impression_time;
  
  double expiry_time;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, WebUIImpression::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, WebUIImpression::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, WebUIImpression::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, WebUIImpression::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
WebUIConversionReportPtr WebUIConversionReport::Clone() const {
  return New(
      mojo::Clone(impression_data),
      mojo::Clone(conversion_data),
      mojo::Clone(conversion_origin),
      mojo::Clone(reporting_origin),
      mojo::Clone(report_time),
      mojo::Clone(attribution_credit)
  );
}

template <typename T, WebUIConversionReport::EnableIfSame<T>*>
bool WebUIConversionReport::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->impression_data, other_struct.impression_data))
    return false;
  if (!mojo::Equals(this->conversion_data, other_struct.conversion_data))
    return false;
  if (!mojo::Equals(this->conversion_origin, other_struct.conversion_origin))
    return false;
  if (!mojo::Equals(this->reporting_origin, other_struct.reporting_origin))
    return false;
  if (!mojo::Equals(this->report_time, other_struct.report_time))
    return false;
  if (!mojo::Equals(this->attribution_credit, other_struct.attribution_credit))
    return false;
  return true;
}

template <typename T, WebUIConversionReport::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.impression_data, rhs.impression_data))
    return true;
  if (std::less<>{}(rhs.impression_data, lhs.impression_data))
    return false;
  if (std::less<>{}(lhs.conversion_data, rhs.conversion_data))
    return true;
  if (std::less<>{}(rhs.conversion_data, lhs.conversion_data))
    return false;
  if (std::less<>{}(lhs.conversion_origin, rhs.conversion_origin))
    return true;
  if (std::less<>{}(rhs.conversion_origin, lhs.conversion_origin))
    return false;
  if (std::less<>{}(lhs.reporting_origin, rhs.reporting_origin))
    return true;
  if (std::less<>{}(rhs.reporting_origin, lhs.reporting_origin))
    return false;
  if (std::less<>{}(lhs.report_time, rhs.report_time))
    return true;
  if (std::less<>{}(rhs.report_time, lhs.report_time))
    return false;
  if (std::less<>{}(lhs.attribution_credit, rhs.attribution_credit))
    return true;
  if (std::less<>{}(rhs.attribution_credit, lhs.attribution_credit))
    return false;
  return false;
}
template <typename StructPtrType>
WebUIImpressionPtr WebUIImpression::Clone() const {
  return New(
      mojo::Clone(impression_data),
      mojo::Clone(impression_origin),
      mojo::Clone(conversion_destination),
      mojo::Clone(reporting_origin),
      mojo::Clone(impression_time),
      mojo::Clone(expiry_time)
  );
}

template <typename T, WebUIImpression::EnableIfSame<T>*>
bool WebUIImpression::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->impression_data, other_struct.impression_data))
    return false;
  if (!mojo::Equals(this->impression_origin, other_struct.impression_origin))
    return false;
  if (!mojo::Equals(this->conversion_destination, other_struct.conversion_destination))
    return false;
  if (!mojo::Equals(this->reporting_origin, other_struct.reporting_origin))
    return false;
  if (!mojo::Equals(this->impression_time, other_struct.impression_time))
    return false;
  if (!mojo::Equals(this->expiry_time, other_struct.expiry_time))
    return false;
  return true;
}

template <typename T, WebUIImpression::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.impression_data, rhs.impression_data))
    return true;
  if (std::less<>{}(rhs.impression_data, lhs.impression_data))
    return false;
  if (std::less<>{}(lhs.impression_origin, rhs.impression_origin))
    return true;
  if (std::less<>{}(rhs.impression_origin, lhs.impression_origin))
    return false;
  if (std::less<>{}(lhs.conversion_destination, rhs.conversion_destination))
    return true;
  if (std::less<>{}(rhs.conversion_destination, lhs.conversion_destination))
    return false;
  if (std::less<>{}(lhs.reporting_origin, rhs.reporting_origin))
    return true;
  if (std::less<>{}(rhs.reporting_origin, lhs.reporting_origin))
    return false;
  if (std::less<>{}(lhs.impression_time, rhs.impression_time))
    return true;
  if (std::less<>{}(rhs.impression_time, lhs.impression_time))
    return false;
  if (std::less<>{}(lhs.expiry_time, rhs.expiry_time))
    return true;
  if (std::less<>{}(rhs.expiry_time, lhs.expiry_time))
    return false;
  return false;
}


}  // namespace mojom

namespace mojo {


template <>
struct  StructTraits<::mojom::WebUIConversionReport::DataView,
                                         ::mojom::WebUIConversionReportPtr> {
  static bool IsNull(const ::mojom::WebUIConversionReportPtr& input) { return !input; }
  static void SetToNull(::mojom::WebUIConversionReportPtr* output) { output->reset(); }

  static const decltype(::mojom::WebUIConversionReport::impression_data)& impression_data(
      const ::mojom::WebUIConversionReportPtr& input) {
    return input->impression_data;
  }

  static const decltype(::mojom::WebUIConversionReport::conversion_data)& conversion_data(
      const ::mojom::WebUIConversionReportPtr& input) {
    return input->conversion_data;
  }

  static const decltype(::mojom::WebUIConversionReport::conversion_origin)& conversion_origin(
      const ::mojom::WebUIConversionReportPtr& input) {
    return input->conversion_origin;
  }

  static const decltype(::mojom::WebUIConversionReport::reporting_origin)& reporting_origin(
      const ::mojom::WebUIConversionReportPtr& input) {
    return input->reporting_origin;
  }

  static decltype(::mojom::WebUIConversionReport::report_time) report_time(
      const ::mojom::WebUIConversionReportPtr& input) {
    return input->report_time;
  }

  static decltype(::mojom::WebUIConversionReport::attribution_credit) attribution_credit(
      const ::mojom::WebUIConversionReportPtr& input) {
    return input->attribution_credit;
  }

  static bool Read(::mojom::WebUIConversionReport::DataView input, ::mojom::WebUIConversionReportPtr* output);
};


template <>
struct  StructTraits<::mojom::WebUIImpression::DataView,
                                         ::mojom::WebUIImpressionPtr> {
  static bool IsNull(const ::mojom::WebUIImpressionPtr& input) { return !input; }
  static void SetToNull(::mojom::WebUIImpressionPtr* output) { output->reset(); }

  static const decltype(::mojom::WebUIImpression::impression_data)& impression_data(
      const ::mojom::WebUIImpressionPtr& input) {
    return input->impression_data;
  }

  static const decltype(::mojom::WebUIImpression::impression_origin)& impression_origin(
      const ::mojom::WebUIImpressionPtr& input) {
    return input->impression_origin;
  }

  static const decltype(::mojom::WebUIImpression::conversion_destination)& conversion_destination(
      const ::mojom::WebUIImpressionPtr& input) {
    return input->conversion_destination;
  }

  static const decltype(::mojom::WebUIImpression::reporting_origin)& reporting_origin(
      const ::mojom::WebUIImpressionPtr& input) {
    return input->reporting_origin;
  }

  static decltype(::mojom::WebUIImpression::impression_time) impression_time(
      const ::mojom::WebUIImpressionPtr& input) {
    return input->impression_time;
  }

  static decltype(::mojom::WebUIImpression::expiry_time) expiry_time(
      const ::mojom::WebUIImpressionPtr& input) {
    return input->expiry_time;
  }

  static bool Read(::mojom::WebUIImpression::DataView input, ::mojom::WebUIImpressionPtr* output);
};

}  // namespace mojo

#endif  // CONTENT_BROWSER_CONVERSIONS_CONVERSION_INTERNALS_MOJOM_H_