// components/services/storage/public/mojom/service_worker_database.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_SERVICE_WORKER_DATABASE_MOJOM_SHARED_H_
#define COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_SERVICE_WORKER_DATABASE_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <ostream>
#include <type_traits>
#include <utility>

#include "base/compiler_specific.h"
#include "base/containers/flat_map.h"
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "components/services/storage/public/mojom/service_worker_database.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "services/network/public/mojom/cross_origin_embedder_policy.mojom-shared.h"
#include "third_party/blink/public/mojom/script/script_type.mojom-shared.h"
#include "third_party/blink/public/mojom/service_worker/navigation_preload_state.mojom-shared.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_database.mojom-shared.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_registration_options.mojom-shared.h"
#include "third_party/blink/public/mojom/web_feature/web_feature.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"







namespace storage {
namespace mojom {
class ServiceWorkerRegistrationDataDataView;

class ServiceWorkerResourceRecordDataView;



}  // namespace mojom
}  // namespace storage

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::storage::mojom::ServiceWorkerRegistrationDataDataView> {
  using Data = ::storage::mojom::internal::ServiceWorkerRegistrationData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::storage::mojom::ServiceWorkerResourceRecordDataView> {
  using Data = ::storage::mojom::internal::ServiceWorkerResourceRecord_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace storage {
namespace mojom {


enum class ServiceWorkerDatabaseStatus : int32_t {
  
  kOk = 0,
  
  kErrorNotFound = 1,
  
  kErrorIOError = 2,
  
  kErrorCorrupted = 3,
  
  kErrorFailed = 4,
  
  kErrorNotSupported = 5,
  
  kErrorDisabled = 6,
  kMinValue = 0,
  kMaxValue = 6,
};

 std::ostream& operator<<(std::ostream& os, ServiceWorkerDatabaseStatus value);
inline bool IsKnownEnumValue(ServiceWorkerDatabaseStatus value) {
  return internal::ServiceWorkerDatabaseStatus_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class ServiceWorkerRegistrationDataDataView {
 public:
  ServiceWorkerRegistrationDataDataView() {}

  ServiceWorkerRegistrationDataDataView(
      internal::ServiceWorkerRegistrationData_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  int64_t registration_id() const {
    return data_->registration_id;
  }
  inline void GetScopeDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadScope(UserType* output) {
    
    auto* pointer = data_->scope.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, context_);
  }
  inline void GetScriptDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadScript(UserType* output) {
    
    auto* pointer = data_->script.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, context_);
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadScriptType(UserType* output) const {
    auto data_value = data_->script_type;
    return mojo::internal::Deserialize<::blink::mojom::ScriptType>(
        data_value, output);
  }

  ::blink::mojom::ScriptType script_type() const {
    return static_cast<::blink::mojom::ScriptType>(data_->script_type);
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadUpdateViaCache(UserType* output) const {
    auto data_value = data_->update_via_cache;
    return mojo::internal::Deserialize<::blink::mojom::ServiceWorkerUpdateViaCache>(
        data_value, output);
  }

  ::blink::mojom::ServiceWorkerUpdateViaCache update_via_cache() const {
    return static_cast<::blink::mojom::ServiceWorkerUpdateViaCache>(data_->update_via_cache);
  }
  int64_t version_id() const {
    return data_->version_id;
  }
  bool is_active() const {
    return data_->is_active;
  }
  bool has_fetch_handler() const {
    return data_->has_fetch_handler;
  }
  inline void GetLastUpdateCheckDataView(
      ::mojo_base::mojom::TimeDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadLastUpdateCheck(UserType* output) {
    
    auto* pointer = data_->last_update_check.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDataView>(
        pointer, output, context_);
  }
  inline void GetScriptResponseTimeDataView(
      ::mojo_base::mojom::TimeDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadScriptResponseTime(UserType* output) {
    
    auto* pointer = data_->script_response_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDataView>(
        pointer, output, context_);
  }
  inline void GetOriginTrialTokensDataView(
      mojo::MapDataView<mojo::StringDataView, mojo::ArrayDataView<mojo::StringDataView>>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadOriginTrialTokens(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::MapDataView<mojo::StringDataView, mojo::ArrayDataView<mojo::StringDataView>>, UserType>(),
    "Attempting to read the optional `origin_trial_tokens` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadOriginTrialTokens` instead "
    "of `ReadOriginTrialTokens if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->origin_trial_tokens.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<mojo::StringDataView, mojo::ArrayDataView<mojo::StringDataView>>>(
        pointer, output, context_);
  }
  inline void GetNavigationPreloadStateDataView(
      ::blink::mojom::NavigationPreloadStateDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadNavigationPreloadState(UserType* output) {
    
    auto* pointer = data_->navigation_preload_state.Get();
    return mojo::internal::Deserialize<::blink::mojom::NavigationPreloadStateDataView>(
        pointer, output, context_);
  }
  inline void GetUsedFeaturesDataView(
      mojo::ArrayDataView<::blink::mojom::WebFeature>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadUsedFeatures(UserType* output) {
    
    auto* pointer = data_->used_features.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::WebFeature>>(
        pointer, output, context_);
  }
  int64_t resources_total_size_bytes() const {
    return data_->resources_total_size_bytes;
  }
  inline void GetCrossOriginEmbedderPolicyDataView(
      ::network::mojom::CrossOriginEmbedderPolicyDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadCrossOriginEmbedderPolicy(UserType* output) {
    
    auto* pointer = data_->cross_origin_embedder_policy.Get();
    return mojo::internal::Deserialize<::network::mojom::CrossOriginEmbedderPolicyDataView>(
        pointer, output, context_);
  }
 private:
  internal::ServiceWorkerRegistrationData_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class ServiceWorkerResourceRecordDataView {
 public:
  ServiceWorkerResourceRecordDataView() {}

  ServiceWorkerResourceRecordDataView(
      internal::ServiceWorkerResourceRecord_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  int64_t resource_id() const {
    return data_->resource_id;
  }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, context_);
  }
  int64_t size_bytes() const {
    return data_->size_bytes;
  }
 private:
  internal::ServiceWorkerResourceRecord_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



}  // namespace mojom
}  // namespace storage

namespace std {

template <>
struct hash<::storage::mojom::ServiceWorkerDatabaseStatus>
    : public mojo::internal::EnumHashImpl<::storage::mojom::ServiceWorkerDatabaseStatus> {};

}  // namespace std

namespace mojo {


template <>
struct EnumTraits<::storage::mojom::ServiceWorkerDatabaseStatus, ::storage::mojom::ServiceWorkerDatabaseStatus> {
  static ::storage::mojom::ServiceWorkerDatabaseStatus ToMojom(::storage::mojom::ServiceWorkerDatabaseStatus input) { return input; }
  static bool FromMojom(::storage::mojom::ServiceWorkerDatabaseStatus input, ::storage::mojom::ServiceWorkerDatabaseStatus* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::storage::mojom::ServiceWorkerDatabaseStatus, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::storage::mojom::ServiceWorkerDatabaseStatus, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::storage::mojom::ServiceWorkerDatabaseStatus>(input), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::storage::mojom::ServiceWorkerRegistrationDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::storage::mojom::ServiceWorkerRegistrationDataDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::storage::mojom::internal::ServiceWorkerRegistrationData_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    (*output)->registration_id = Traits::registration_id(input);
    decltype(Traits::scope(input)) in_scope = Traits::scope(input);
    typename decltype((*output)->scope)::BaseType::BufferWriter
        scope_writer;
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
        in_scope, buffer, &scope_writer, context);
    (*output)->scope.Set(
        scope_writer.is_null() ? nullptr : scope_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->scope.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null scope in ServiceWorkerRegistrationData struct");
    decltype(Traits::script(input)) in_script = Traits::script(input);
    typename decltype((*output)->script)::BaseType::BufferWriter
        script_writer;
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
        in_script, buffer, &script_writer, context);
    (*output)->script.Set(
        script_writer.is_null() ? nullptr : script_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->script.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null script in ServiceWorkerRegistrationData struct");
    mojo::internal::Serialize<::blink::mojom::ScriptType>(
        Traits::script_type(input), &(*output)->script_type);
    mojo::internal::Serialize<::blink::mojom::ServiceWorkerUpdateViaCache>(
        Traits::update_via_cache(input), &(*output)->update_via_cache);
    (*output)->version_id = Traits::version_id(input);
    (*output)->is_active = Traits::is_active(input);
    (*output)->has_fetch_handler = Traits::has_fetch_handler(input);
    decltype(Traits::last_update_check(input)) in_last_update_check = Traits::last_update_check(input);
    typename decltype((*output)->last_update_check)::BaseType::BufferWriter
        last_update_check_writer;
    mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
        in_last_update_check, buffer, &last_update_check_writer, context);
    (*output)->last_update_check.Set(
        last_update_check_writer.is_null() ? nullptr : last_update_check_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->last_update_check.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null last_update_check in ServiceWorkerRegistrationData struct");
    decltype(Traits::script_response_time(input)) in_script_response_time = Traits::script_response_time(input);
    typename decltype((*output)->script_response_time)::BaseType::BufferWriter
        script_response_time_writer;
    mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
        in_script_response_time, buffer, &script_response_time_writer, context);
    (*output)->script_response_time.Set(
        script_response_time_writer.is_null() ? nullptr : script_response_time_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->script_response_time.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null script_response_time in ServiceWorkerRegistrationData struct");
    decltype(Traits::origin_trial_tokens(input)) in_origin_trial_tokens = Traits::origin_trial_tokens(input);
    typename decltype((*output)->origin_trial_tokens)::BaseType::BufferWriter
        origin_trial_tokens_writer;
    const mojo::internal::ContainerValidateParams origin_trial_tokens_validate_params(
        new mojo::internal::ContainerValidateParams(0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr)), new mojo::internal::ContainerValidateParams(0, false, new mojo::internal::ContainerValidateParams(0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr))));
    mojo::internal::Serialize<mojo::MapDataView<mojo::StringDataView, mojo::ArrayDataView<mojo::StringDataView>>>(
        in_origin_trial_tokens, buffer, &origin_trial_tokens_writer, &origin_trial_tokens_validate_params,
        context);
    (*output)->origin_trial_tokens.Set(
        origin_trial_tokens_writer.is_null() ? nullptr : origin_trial_tokens_writer.data());
    decltype(Traits::navigation_preload_state(input)) in_navigation_preload_state = Traits::navigation_preload_state(input);
    typename decltype((*output)->navigation_preload_state)::BaseType::BufferWriter
        navigation_preload_state_writer;
    mojo::internal::Serialize<::blink::mojom::NavigationPreloadStateDataView>(
        in_navigation_preload_state, buffer, &navigation_preload_state_writer, context);
    (*output)->navigation_preload_state.Set(
        navigation_preload_state_writer.is_null() ? nullptr : navigation_preload_state_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->navigation_preload_state.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null navigation_preload_state in ServiceWorkerRegistrationData struct");
    decltype(Traits::used_features(input)) in_used_features = Traits::used_features(input);
    typename decltype((*output)->used_features)::BaseType::BufferWriter
        used_features_writer;
    const mojo::internal::ContainerValidateParams used_features_validate_params(
        0, ::blink::mojom::internal::WebFeature_Data::Validate);
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::WebFeature>>(
        in_used_features, buffer, &used_features_writer, &used_features_validate_params,
        context);
    (*output)->used_features.Set(
        used_features_writer.is_null() ? nullptr : used_features_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->used_features.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null used_features in ServiceWorkerRegistrationData struct");
    (*output)->resources_total_size_bytes = Traits::resources_total_size_bytes(input);
    decltype(Traits::cross_origin_embedder_policy(input)) in_cross_origin_embedder_policy = Traits::cross_origin_embedder_policy(input);
    typename decltype((*output)->cross_origin_embedder_policy)::BaseType::BufferWriter
        cross_origin_embedder_policy_writer;
    mojo::internal::Serialize<::network::mojom::CrossOriginEmbedderPolicyDataView>(
        in_cross_origin_embedder_policy, buffer, &cross_origin_embedder_policy_writer, context);
    (*output)->cross_origin_embedder_policy.Set(
        cross_origin_embedder_policy_writer.is_null() ? nullptr : cross_origin_embedder_policy_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->cross_origin_embedder_policy.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null cross_origin_embedder_policy in ServiceWorkerRegistrationData struct");
  }

  static bool Deserialize(::storage::mojom::internal::ServiceWorkerRegistrationData_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::storage::mojom::ServiceWorkerRegistrationDataDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::storage::mojom::ServiceWorkerResourceRecordDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::storage::mojom::ServiceWorkerResourceRecordDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::storage::mojom::internal::ServiceWorkerResourceRecord_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    (*output)->resource_id = Traits::resource_id(input);
    decltype(Traits::url(input)) in_url = Traits::url(input);
    typename decltype((*output)->url)::BaseType::BufferWriter
        url_writer;
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
        in_url, buffer, &url_writer, context);
    (*output)->url.Set(
        url_writer.is_null() ? nullptr : url_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->url.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null url in ServiceWorkerResourceRecord struct");
    (*output)->size_bytes = Traits::size_bytes(input);
  }

  static bool Deserialize(::storage::mojom::internal::ServiceWorkerResourceRecord_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::storage::mojom::ServiceWorkerResourceRecordDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace storage {
namespace mojom {

inline void ServiceWorkerRegistrationDataDataView::GetScopeDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->scope.Get();
  *output = ::url::mojom::UrlDataView(pointer, context_);
}
inline void ServiceWorkerRegistrationDataDataView::GetScriptDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->script.Get();
  *output = ::url::mojom::UrlDataView(pointer, context_);
}
inline void ServiceWorkerRegistrationDataDataView::GetLastUpdateCheckDataView(
    ::mojo_base::mojom::TimeDataView* output) {
  auto pointer = data_->last_update_check.Get();
  *output = ::mojo_base::mojom::TimeDataView(pointer, context_);
}
inline void ServiceWorkerRegistrationDataDataView::GetScriptResponseTimeDataView(
    ::mojo_base::mojom::TimeDataView* output) {
  auto pointer = data_->script_response_time.Get();
  *output = ::mojo_base::mojom::TimeDataView(pointer, context_);
}
inline void ServiceWorkerRegistrationDataDataView::GetOriginTrialTokensDataView(
    mojo::MapDataView<mojo::StringDataView, mojo::ArrayDataView<mojo::StringDataView>>* output) {
  auto pointer = data_->origin_trial_tokens.Get();
  *output = mojo::MapDataView<mojo::StringDataView, mojo::ArrayDataView<mojo::StringDataView>>(pointer, context_);
}
inline void ServiceWorkerRegistrationDataDataView::GetNavigationPreloadStateDataView(
    ::blink::mojom::NavigationPreloadStateDataView* output) {
  auto pointer = data_->navigation_preload_state.Get();
  *output = ::blink::mojom::NavigationPreloadStateDataView(pointer, context_);
}
inline void ServiceWorkerRegistrationDataDataView::GetUsedFeaturesDataView(
    mojo::ArrayDataView<::blink::mojom::WebFeature>* output) {
  auto pointer = data_->used_features.Get();
  *output = mojo::ArrayDataView<::blink::mojom::WebFeature>(pointer, context_);
}
inline void ServiceWorkerRegistrationDataDataView::GetCrossOriginEmbedderPolicyDataView(
    ::network::mojom::CrossOriginEmbedderPolicyDataView* output) {
  auto pointer = data_->cross_origin_embedder_policy.Get();
  *output = ::network::mojom::CrossOriginEmbedderPolicyDataView(pointer, context_);
}


inline void ServiceWorkerResourceRecordDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, context_);
}



}  // namespace mojom
}  // namespace storage

#endif  // COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_SERVICE_WORKER_DATABASE_MOJOM_SHARED_H_