/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.13.1
 *
 * Copyright (c) 2025 Riverbank Computing Limited <info@riverbankcomputing.com>
 * 
 * This file is part of PyQt6.
 * 
 * This file may be used under the terms of the GNU General Public License
 * version 3.0 as published by the Free Software Foundation and appearing in
 * the file LICENSE included in the packaging of this file.  Please review the
 * following information to ensure the GNU General Public License version 3.0
 * requirements will be met: http://www.gnu.org/copyleft/gpl.html.
 * 
 * If you do not wish to use this file under the terms of the GPL version 3.0
 * then you may purchase a commercial license.  For more information contact
 * info@riverbankcomputing.com.
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#include "sipAPIQtGui.h"

#line 28 "/build/pyqt6/src/pyqt6-6.10.0/sip/QtCore/qpycore_qlist.sip"
#include <qlist.h>
#line 29 "/build/pyqt6/src/pyqt6-6.10.0/build/QtGui/sipQtGuiQList0100QKeySequence.cpp"

#line 26 "/build/pyqt6/src/pyqt6-6.10.0/sip/QtGui/qkeysequence.sip"
#include <qkeysequence.h>
#line 33 "/build/pyqt6/src/pyqt6-6.10.0/build/QtGui/sipQtGuiQList0100QKeySequence.cpp"


extern "C" {static void assign_QList_0100QKeySequence(void *, Py_ssize_t, void *);}
static void assign_QList_0100QKeySequence(void *sipDst, Py_ssize_t sipDstIdx, void *sipSrc)
{
    reinterpret_cast<QList< ::QKeySequence> *>(sipDst)[sipDstIdx] = *reinterpret_cast<QList< ::QKeySequence> *>(sipSrc);
}


extern "C" {static void *array_QList_0100QKeySequence(Py_ssize_t);}
static void *array_QList_0100QKeySequence(Py_ssize_t sipNrElem)
{
    return new QList< ::QKeySequence>[sipNrElem];
}


extern "C" {static void *copy_QList_0100QKeySequence(const void *, Py_ssize_t);}
static void *copy_QList_0100QKeySequence(const void *sipSrc, Py_ssize_t sipSrcIdx)
{
    return new QList< ::QKeySequence>(reinterpret_cast<const QList< ::QKeySequence> *>(sipSrc)[sipSrcIdx]);
}


/* Call the mapped type's destructor. */
extern "C" {static void release_QList_0100QKeySequence(void *, int, void *);}
static void release_QList_0100QKeySequence(void *sipCppV, int, void *)
{
    QList< ::QKeySequence> *sipCpp = reinterpret_cast<QList< ::QKeySequence> *>(sipCppV);
    delete sipCpp;
}



extern "C" {static int convertTo_QList_0100QKeySequence(PyObject *, void **, int *, PyObject *, void **);}
static int convertTo_QList_0100QKeySequence(PyObject *sipPy, void **sipCppPtrV, int *sipIsErr, PyObject *sipTransferObj, void **)
{
    QList< ::QKeySequence> **sipCppPtr = reinterpret_cast<QList< ::QKeySequence> **>(sipCppPtrV);

#line 58 "/build/pyqt6/src/pyqt6-6.10.0/sip/QtCore/qpycore_qlist.sip"
    PyObject *iter = PyObject_GetIter(sipPy);

    if (!sipIsErr)
    {
        PyErr_Clear();
        Py_XDECREF(iter);

        return (iter && !PyBytes_Check(sipPy) && !PyUnicode_Check(sipPy));
    }

    if (!iter)
    {
        *sipIsErr = 1;

        return 0;
    }

    QList<QKeySequence> *ql = new QList<QKeySequence>;
 
    for (Py_ssize_t i = 0; ; ++i)
    {
        PyErr_Clear();
        PyObject *itm = PyIter_Next(iter);

        if (!itm)
        {
            if (PyErr_Occurred())
            {
                delete ql;
                Py_DECREF(iter);
                *sipIsErr = 1;

                return 0;
            }

            break;
        }

        int state;
        QKeySequence *t = reinterpret_cast<QKeySequence *>(
                sipForceConvertToType(itm, sipType_QKeySequence, sipTransferObj,
                        SIP_NOT_NONE, &state, sipIsErr));

        if (*sipIsErr)
        {
            PyErr_Format(PyExc_TypeError,
                    "index %zd has type '%s' but 'QKeySequence' is expected", i,
                    sipPyTypeName(Py_TYPE(itm)));

            Py_DECREF(itm);
            delete ql;
            Py_DECREF(iter);

            return 0;
        }

        ql->append(*t);

        sipReleaseType(t, sipType_QKeySequence, state);
        Py_DECREF(itm);
    }
 
    Py_DECREF(iter);

    *sipCppPtr = ql;
 
    return sipGetState(sipTransferObj);
#line 140 "/build/pyqt6/src/pyqt6-6.10.0/build/QtGui/sipQtGuiQList0100QKeySequence.cpp"
}


extern "C" {static PyObject *convertFrom_QList_0100QKeySequence(void *, PyObject *);}
static PyObject *convertFrom_QList_0100QKeySequence(void *sipCppV, PyObject *sipTransferObj)
{
    QList< ::QKeySequence> *sipCpp = reinterpret_cast<QList< ::QKeySequence> *>(sipCppV);

#line 32 "/build/pyqt6/src/pyqt6-6.10.0/sip/QtCore/qpycore_qlist.sip"
    PyObject *l = PyList_New(sipCpp->size());

    if (!l)
        return 0;

    for (int i = 0; i < sipCpp->size(); ++i)
    {
        QKeySequence *t = new QKeySequence(sipCpp->at(i));
        PyObject *tobj = sipConvertFromNewType(t, sipType_QKeySequence,
                sipTransferObj);

        if (!tobj)
        {
            delete t;
            Py_DECREF(l);

            return 0;
        }

        PyList_SetItem(l, i, tobj);
    }

    return l;
#line 173 "/build/pyqt6/src/pyqt6-6.10.0/build/QtGui/sipQtGuiQList0100QKeySequence.cpp"
}


sipMappedTypeDef sipTypeDef_QtGui_QList_0100QKeySequence = {
    {
        SIP_NULLPTR,
        SIP_TYPE_MAPPED,
        sipNameNr_12381,
        SIP_NULLPTR,
        SIP_NULLPTR,
    },
    {
        -1,
        {0, 0, 1},
        0, SIP_NULLPTR,
        0, SIP_NULLPTR,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR}
    },
    assign_QList_0100QKeySequence,
    array_QList_0100QKeySequence,
    copy_QList_0100QKeySequence,
    release_QList_0100QKeySequence,
    convertTo_QList_0100QKeySequence,
    convertFrom_QList_0100QKeySequence
};
