/* ZoomOverlay.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from ZoomOverlay.vala, do not modify */

/*
 * SPDX-License-Identifier: GPL-3.0-or-later
 * SPDX-FileCopyrightText: 2024 elementary, Inc. (https://elementary.io)
 */

#include <granite.h>
#include <glib-object.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <float.h>
#include <math.h>
#include <glib/gi18n-lib.h>
#include <stdlib.h>
#include <string.h>

#define TERMINAL_WIDGETS_ZOOM_OVERLAY_VISIBLE_DURATION ((guint) 1500)
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TERMINAL_WIDGETS_TYPE_ZOOM_OVERLAY (terminal_widgets_zoom_overlay_get_type ())
#define TERMINAL_WIDGETS_ZOOM_OVERLAY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TERMINAL_WIDGETS_TYPE_ZOOM_OVERLAY, TerminalWidgetsZoomOverlay))
#define TERMINAL_WIDGETS_ZOOM_OVERLAY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TERMINAL_WIDGETS_TYPE_ZOOM_OVERLAY, TerminalWidgetsZoomOverlayClass))
#define TERMINAL_WIDGETS_IS_ZOOM_OVERLAY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TERMINAL_WIDGETS_TYPE_ZOOM_OVERLAY))
#define TERMINAL_WIDGETS_IS_ZOOM_OVERLAY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TERMINAL_WIDGETS_TYPE_ZOOM_OVERLAY))
#define TERMINAL_WIDGETS_ZOOM_OVERLAY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TERMINAL_WIDGETS_TYPE_ZOOM_OVERLAY, TerminalWidgetsZoomOverlayClass))

typedef struct _TerminalWidgetsZoomOverlay TerminalWidgetsZoomOverlay;
typedef struct _TerminalWidgetsZoomOverlayClass TerminalWidgetsZoomOverlayClass;
typedef struct _TerminalWidgetsZoomOverlayPrivate TerminalWidgetsZoomOverlayPrivate;
enum  {
	TERMINAL_WIDGETS_ZOOM_OVERLAY_0_PROPERTY,
	TERMINAL_WIDGETS_ZOOM_OVERLAY_NUM_PROPERTIES
};
static GParamSpec* terminal_widgets_zoom_overlay_properties[TERMINAL_WIDGETS_ZOOM_OVERLAY_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))

struct _TerminalWidgetsZoomOverlay {
	GraniteWidgetsOverlayBar parent_instance;
	TerminalWidgetsZoomOverlayPrivate * priv;
};

struct _TerminalWidgetsZoomOverlayClass {
	GraniteWidgetsOverlayBarClass parent_class;
};

struct _TerminalWidgetsZoomOverlayPrivate {
	guint timer_id;
};

static gint TerminalWidgetsZoomOverlay_private_offset;
static gpointer terminal_widgets_zoom_overlay_parent_class = NULL;

VALA_EXTERN GType terminal_widgets_zoom_overlay_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TerminalWidgetsZoomOverlay, g_object_unref)
VALA_EXTERN TerminalWidgetsZoomOverlay* terminal_widgets_zoom_overlay_new (GtkOverlay* overlay);
VALA_EXTERN TerminalWidgetsZoomOverlay* terminal_widgets_zoom_overlay_construct (GType object_type,
                                                                     GtkOverlay* overlay);
VALA_EXTERN void terminal_widgets_zoom_overlay_show_zoom_level (TerminalWidgetsZoomOverlay* self,
                                                    gdouble zoom_level);
static void terminal_widgets_zoom_overlay_cancel_timer (TerminalWidgetsZoomOverlay* self);
static gboolean __lambda12_ (TerminalWidgetsZoomOverlay* self);
VALA_EXTERN void terminal_widgets_zoom_overlay_hide_zoom_level (TerminalWidgetsZoomOverlay* self);
static gboolean ___lambda12__gsource_func (gpointer self);
static void terminal_widgets_zoom_overlay_finalize (GObject * obj);
static GType terminal_widgets_zoom_overlay_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
terminal_widgets_zoom_overlay_get_instance_private (TerminalWidgetsZoomOverlay* self)
{
	return G_STRUCT_MEMBER_P (self, TerminalWidgetsZoomOverlay_private_offset);
}

TerminalWidgetsZoomOverlay*
terminal_widgets_zoom_overlay_construct (GType object_type,
                                         GtkOverlay* overlay)
{
	TerminalWidgetsZoomOverlay * self = NULL;
	g_return_val_if_fail (overlay != NULL, NULL);
	self = (TerminalWidgetsZoomOverlay*) granite_widgets_overlay_bar_construct (object_type, overlay);
	return self;
}

TerminalWidgetsZoomOverlay*
terminal_widgets_zoom_overlay_new (GtkOverlay* overlay)
{
	return terminal_widgets_zoom_overlay_construct (TERMINAL_WIDGETS_TYPE_ZOOM_OVERLAY, overlay);
}

static gboolean
__lambda12_ (TerminalWidgetsZoomOverlay* self)
{
	gboolean result;
	terminal_widgets_zoom_overlay_hide_zoom_level (self);
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda12__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda12_ ((TerminalWidgetsZoomOverlay*) self);
	return result;
}

void
terminal_widgets_zoom_overlay_show_zoom_level (TerminalWidgetsZoomOverlay* self,
                                               gdouble zoom_level)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup_printf (_ ("Zoom: %.0f%%"), zoom_level * 100);
	_tmp1_ = _tmp0_;
	granite_widgets_overlay_bar_set_label ((GraniteWidgetsOverlayBar*) self, _tmp1_);
	_g_free0 (_tmp1_);
	gtk_widget_show ((GtkWidget*) self);
	terminal_widgets_zoom_overlay_cancel_timer (self);
	self->priv->timer_id = g_timeout_add_full (G_PRIORITY_DEFAULT, TERMINAL_WIDGETS_ZOOM_OVERLAY_VISIBLE_DURATION, ___lambda12__gsource_func, g_object_ref (self), g_object_unref);
}

void
terminal_widgets_zoom_overlay_hide_zoom_level (TerminalWidgetsZoomOverlay* self)
{
	g_return_if_fail (self != NULL);
	gtk_widget_hide ((GtkWidget*) self);
	terminal_widgets_zoom_overlay_cancel_timer (self);
}

static void
terminal_widgets_zoom_overlay_cancel_timer (TerminalWidgetsZoomOverlay* self)
{
	g_return_if_fail (self != NULL);
	if (self->priv->timer_id > ((guint) 0)) {
		g_source_remove (self->priv->timer_id);
		self->priv->timer_id = (guint) 0;
	}
}

static void
terminal_widgets_zoom_overlay_class_init (TerminalWidgetsZoomOverlayClass * klass,
                                          gpointer klass_data)
{
	terminal_widgets_zoom_overlay_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &TerminalWidgetsZoomOverlay_private_offset);
	G_OBJECT_CLASS (klass)->finalize = terminal_widgets_zoom_overlay_finalize;
}

static void
terminal_widgets_zoom_overlay_instance_init (TerminalWidgetsZoomOverlay * self,
                                             gpointer klass)
{
	self->priv = terminal_widgets_zoom_overlay_get_instance_private (self);
}

static void
terminal_widgets_zoom_overlay_finalize (GObject * obj)
{
	TerminalWidgetsZoomOverlay * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TERMINAL_WIDGETS_TYPE_ZOOM_OVERLAY, TerminalWidgetsZoomOverlay);
	G_OBJECT_CLASS (terminal_widgets_zoom_overlay_parent_class)->finalize (obj);
}

static GType
terminal_widgets_zoom_overlay_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (TerminalWidgetsZoomOverlayClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) terminal_widgets_zoom_overlay_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TerminalWidgetsZoomOverlay), 0, (GInstanceInitFunc) terminal_widgets_zoom_overlay_instance_init, NULL };
	GType terminal_widgets_zoom_overlay_type_id;
	terminal_widgets_zoom_overlay_type_id = g_type_register_static (GRANITE_WIDGETS_TYPE_OVERLAY_BAR, "TerminalWidgetsZoomOverlay", &g_define_type_info, 0);
	TerminalWidgetsZoomOverlay_private_offset = g_type_add_instance_private (terminal_widgets_zoom_overlay_type_id, sizeof (TerminalWidgetsZoomOverlayPrivate));
	return terminal_widgets_zoom_overlay_type_id;
}

GType
terminal_widgets_zoom_overlay_get_type (void)
{
	static volatile gsize terminal_widgets_zoom_overlay_type_id__once = 0;
	if (g_once_init_enter (&terminal_widgets_zoom_overlay_type_id__once)) {
		GType terminal_widgets_zoom_overlay_type_id;
		terminal_widgets_zoom_overlay_type_id = terminal_widgets_zoom_overlay_get_type_once ();
		g_once_init_leave (&terminal_widgets_zoom_overlay_type_id__once, terminal_widgets_zoom_overlay_type_id);
	}
	return terminal_widgets_zoom_overlay_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

