/* Directory.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from Directory.vala, do not modify */

#include "pantheon-files-core.h"
#include <glib.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <unistd.h>
#include <sys/types.h>
#include <glib/gi18n-lib.h>

#define FILES_DIRECTORY_CONNECT_SOCKET_TIMEOUT_SEC 30
#define FILES_DIRECTORY_ENUMERATE_TIMEOUT_SEC 30
#define FILES_DIRECTORY_QUERY_INFO_TIMEOUT_SEC 20
#define FILES_DIRECTORY_MOUNT_TIMEOUT_SEC 60
#define FILES_DIRECTORY_FCHANGES_MAX ((guint) 20)
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define FILES_DIRECTORY_TYPE_FCHANGES (files_directory_fchanges_get_type ())
typedef struct _FilesDirectoryFChanges FilesDirectoryFChanges;
enum  {
	FILES_DIRECTORY_0_PROPERTY,
	FILES_DIRECTORY_CREATION_KEY_PROPERTY,
	FILES_DIRECTORY_LOCATION_PROPERTY,
	FILES_DIRECTORY_SELECTED_FILE_PROPERTY,
	FILES_DIRECTORY_FILE_PROPERTY,
	FILES_DIRECTORY_STATE_PROPERTY,
	FILES_DIRECTORY_DISPLAYED_FILES_COUNT_PROPERTY,
	FILES_DIRECTORY_SCHEME_PROPERTY,
	FILES_DIRECTORY_IS_LOCAL_PROPERTY,
	FILES_DIRECTORY_IS_TRASH_PROPERTY,
	FILES_DIRECTORY_IS_NETWORK_PROPERTY,
	FILES_DIRECTORY_IS_RECENT_PROPERTY,
	FILES_DIRECTORY_IS_ADMIN_PROPERTY,
	FILES_DIRECTORY_IS_NO_INFO_PROPERTY,
	FILES_DIRECTORY_HAS_MOUNTS_PROPERTY,
	FILES_DIRECTORY_HAS_TRASH_DIRS_PROPERTY,
	FILES_DIRECTORY_CAN_LOAD_PROPERTY,
	FILES_DIRECTORY_CAN_OPEN_FILES_PROPERTY,
	FILES_DIRECTORY_CAN_STREAM_FILES_PROPERTY,
	FILES_DIRECTORY_ALLOW_USER_INTERACTION_PROPERTY,
	FILES_DIRECTORY_IS_CANCELLED_PROPERTY,
	FILES_DIRECTORY_LAST_ERROR_MESSAGE_PROPERTY,
	FILES_DIRECTORY_LOADED_FROM_CACHE_PROPERTY,
	FILES_DIRECTORY_FREEZE_UPDATE_PROPERTY,
	FILES_DIRECTORY_NUM_PROPERTIES
};
static GParamSpec* files_directory_properties[FILES_DIRECTORY_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _FilesDirectoryPrepareDirectoryData FilesDirectoryPrepareDirectoryData;
typedef struct _FilesDirectoryGetFileInfoData FilesDirectoryGetFileInfoData;
typedef struct _Block5Data Block5Data;
typedef struct _FilesDirectoryTryQueryInfoData FilesDirectoryTryQueryInfoData;
typedef struct _Block6Data Block6Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _FilesDirectoryMountMountableData FilesDirectoryMountMountableData;
typedef struct _FilesDirectoryCheckNetworkData FilesDirectoryCheckNetworkData;
typedef struct _FilesDirectoryMakeReadyData FilesDirectoryMakeReadyData;
typedef struct _FilesDirectoryListDirectoryAsyncData FilesDirectoryListDirectoryAsyncData;
typedef struct _FilesDirectoryQueryInfoAsyncData FilesDirectoryQueryInfoAsyncData;
typedef struct _Block7Data Block7Data;
typedef struct _Block8Data Block8Data;
#define _files_directory_fchanges_free0(var) ((var == NULL) ? NULL : (var = (files_directory_fchanges_free (var), NULL)))
typedef void (*FilesDirectoryfunc_query_info) (FilesFile* gof, gpointer user_data);
enum  {
	FILES_DIRECTORY_FILE_LOADED_SIGNAL,
	FILES_DIRECTORY_FILE_ADDED_SIGNAL,
	FILES_DIRECTORY_FILE_CHANGED_SIGNAL,
	FILES_DIRECTORY_FILE_DELETED_SIGNAL,
	FILES_DIRECTORY_ICON_CHANGED_SIGNAL,
	FILES_DIRECTORY_DONE_LOADING_SIGNAL,
	FILES_DIRECTORY_THUMBS_LOADED_SIGNAL,
	FILES_DIRECTORY_NEED_RELOAD_SIGNAL,
	FILES_DIRECTORY_NUM_SIGNALS
};
static guint files_directory_signals[FILES_DIRECTORY_NUM_SIGNALS] = {0};
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _FilesDirectoryFChanges {
	GFile* file;
	GFileMonitorEvent event;
};

struct _FilesDirectoryPrivate {
	guint load_timeout_id;
	guint mount_timeout_id;
	GFile* _creation_key;
	GFile* _location;
	GFile* _selected_file;
	FilesFile* _file;
	FilesDirectoryState _state;
	GHashTable* file_hash;
	guint _displayed_files_count;
	GCancellable* cancellable;
	GFileMonitor* monitor;
	GList* sorted_dirs;
	guint idle_consume_changes_id;
	gboolean removed_from_cache;
	gboolean monitor_blocked;
	gchar* _scheme;
	gboolean _is_local;
	gboolean _is_trash;
	gboolean _is_network;
	gboolean _is_recent;
	gboolean _is_admin;
	gboolean _is_no_info;
	gboolean _has_mounts;
	gboolean _has_trash_dirs;
	gboolean _can_load;
	gboolean _can_open_files;
	gboolean _can_stream_files;
	gboolean _allow_user_interaction;
	gboolean is_ready;
	gchar* _last_error_message;
	gboolean _loaded_from_cache;
	GList* list_fchanges;
	guint list_fchanges_count;
	gboolean _freeze_update;
};

struct _FilesDirectoryPrepareDirectoryData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	FilesDirectory* self;
	FilesDirectoryFileLoadedFunc file_loaded_func;
	gpointer file_loaded_func_target;
	FilesDirectoryDoneLoadingFunc done_loading_func;
	gpointer done_loading_func_target;
	FilesFile* _tmp0_;
	gboolean success;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	FilesFile* _tmp4_;
	FilesFile* _tmp5_;
	GFile* _tmp6_;
	FilesFile* _tmp7_;
	GFile* _tmp8_;
	GFile* _tmp9_;
	GFile* parent;
	GFile* _tmp10_;
	GFile* _tmp11_;
	GFile* _tmp12_;
	FilesFile* _tmp13_;
	FilesFile* _tmp14_;
	GFile* _tmp15_;
	GFile* _tmp16_;
	FilesFile* _tmp17_;
	const gchar* _tmp18_;
	const gchar* _tmp19_;
	FilesFile* _tmp20_;
	gchar* _tmp21_;
	FilesFile* _tmp22_;
	GMount* _tmp23_;
	FilesFile* _tmp24_;
	GMount* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	FilesFile* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	gboolean _tmp33_;
	gboolean _tmp34_;
};

struct _FilesDirectoryGetFileInfoData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	FilesDirectory* self;
	gboolean result;
	gboolean _tmp0_;
	gboolean _tmp1_;
	FilesFile* _tmp2_;
	FilesFile* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	FilesFile* _tmp6_;
	gboolean _tmp7_;
	gboolean _tmp8_;
	FilesFile* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
};

struct _Block5Data {
	int _ref_count_;
	FilesDirectory* self;
	gboolean querying;
	gpointer _async_data_;
};

struct _FilesDirectoryTryQueryInfoData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	FilesDirectory* self;
	gboolean result;
	Block5Data* _data5_;
	GCancellable* _tmp0_;
	gboolean success;
	FilesFile* _tmp1_;
	GCancellable* _tmp2_;
	GCancellable* _tmp3_;
	FilesFile* _tmp4_;
	FilesFile* _tmp5_;
	gchar* _tmp6_;
	FilesFile* _tmp7_;
	GMount* _tmp8_;
	FilesFile* _tmp9_;
	GMount* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	FilesFile* _tmp15_;
	const gchar* _tmp16_;
	const gchar* _tmp17_;
};

struct _Block6Data {
	int _ref_count_;
	FilesDirectory* self;
	gboolean mounting;
	gboolean asking_password;
};

struct _FilesDirectoryMountMountableData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	FilesDirectory* self;
	gboolean result;
	gboolean res;
	GtkMountOperation* mount_op;
	GCancellable* _tmp0_;
	Block6Data* _data6_;
	gboolean _tmp1_;
	GtkMountOperation* _tmp2_;
	GtkMountOperation* _tmp3_;
	GtkMountOperation* _tmp4_;
	gboolean _tmp5_;
	GFile* _tmp6_;
	GtkMountOperation* _tmp7_;
	GCancellable* _tmp8_;
	GError* e;
	GError* _tmp9_;
	const gchar* _tmp10_;
	GError* _tmp11_;
	FilesFile* _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	FilesFile* _tmp15_;
	GError* _tmp16_;
	FilesFile* _tmp17_;
	const gchar* _tmp18_;
	const gchar* _tmp19_;
	GFile* _tmp20_;
	GtkMountOperation* _tmp21_;
	GCancellable* _tmp22_;
	GFile* _tmp23_;
	GFile* _tmp24_;
	GError* e2;
	GError* _tmp25_;
	const gchar* _tmp26_;
	FilesFile* _tmp27_;
	FilesFile* _tmp28_;
	FilesFile* _tmp29_;
	GError* _tmp30_;
	const gchar* _tmp31_;
	gboolean _tmp32_;
	GError* _tmp33_;
	GError* _tmp34_;
	GError* _inner_error1_;
	gchar* _tmp35_;
	FilesFile* _tmp36_;
	GMount* _tmp37_;
	FilesFile* _tmp38_;
	GMount* _tmp39_;
	gchar* _tmp40_;
	gchar* _tmp41_;
	gchar* _tmp42_;
	gchar* _tmp43_;
	GError* _inner_error0_;
};

struct _FilesDirectoryCheckNetworkData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	FilesDirectory* self;
	gboolean result;
	GNetworkMonitor* net_mon;
	GNetworkMonitor* _tmp0_;
	GNetworkMonitor* _tmp1_;
	gboolean success;
	FilesFile* _tmp2_;
	const gchar* _tmp3_;
	GSocketClient* scl;
	GSocketClient* _tmp4_;
	GSocketClient* _tmp5_;
	GSocketClient* _tmp6_;
	const gchar* _tmp7_;
	guint16 default_port;
	const gchar* _tmp8_;
	GSocketConnection* sc;
	GSocketClient* _tmp9_;
	FilesFile* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	GCancellable* _tmp13_;
	GSocketConnection* _tmp14_;
	gboolean _tmp15_;
	GSocketConnection* _tmp16_;
	GSocketConnection* _tmp17_;
	const gchar* _tmp18_;
	GSocketConnection* _tmp19_;
	const gchar* _tmp20_;
	GSocketConnection* _tmp21_;
	GError* e;
	GError* _tmp22_;
	const gchar* _tmp23_;
	FilesFile* _tmp24_;
	const gchar* _tmp25_;
	const gchar* _tmp26_;
	GError* _tmp27_;
	const gchar* _tmp28_;
	const gchar* _tmp29_;
	FilesFile* _tmp30_;
	const gchar* _tmp31_;
	const gchar* _tmp32_;
	GError* _inner_error0_;
};

struct _FilesDirectoryMakeReadyData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	FilesDirectory* self;
	gboolean ready;
	FilesDirectoryFileLoadedFunc file_loaded_func;
	gpointer file_loaded_func_target;
	FilesDirectoryDoneLoadingFunc done_loading_func;
	gpointer done_loading_func_target;
	gboolean _tmp0_;
	FilesPreferences* _tmp1_;
	FilesPreferences* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	FilesFile* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	FilesFile* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	FilesFile* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	FilesFile* _tmp16_;
	gboolean _tmp17_;
	gboolean _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	GHashTable* _tmp21_;
	GFile* _tmp22_;
	GHashTable* _tmp23_;
	GFile* _tmp24_;
	GFile* _tmp25_;
	GFile* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	GFile* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	GHashTable* _tmp32_;
	GFile* _tmp33_;
	GHashTable* _tmp34_;
	GFile* _tmp35_;
	gconstpointer _tmp36_;
	GHashTable* _tmp37_;
	GFile* _tmp38_;
	FilesDirectory* _tmp39_;
	GHashTable* _tmp40_;
	FilesFile* _tmp41_;
	GMount* _tmp42_;
	GList* trash_dirs;
	FilesFile* _tmp43_;
	GMount* _tmp44_;
	GList* _tmp45_;
	GList* _tmp46_;
	gboolean _tmp47_;
	gboolean _tmp48_;
	gboolean _tmp49_;
	gboolean _tmp50_;
	gboolean _tmp51_;
	GFileMonitor* _tmp52_;
	GFile* _tmp53_;
	GFileMonitor* _tmp54_;
	GFileMonitor* _tmp55_;
	GFileMonitor* _tmp56_;
	GFileMonitor* _tmp57_;
	GError* e;
	GError* _tmp58_;
	const gchar* _tmp59_;
	GError* _tmp60_;
	GError* _tmp61_;
	const gchar* _tmp62_;
	FilesFile* _tmp63_;
	const gchar* _tmp64_;
	const gchar* _tmp65_;
	gboolean _tmp66_;
	GError* _inner_error0_;
};

struct _FilesDirectoryListDirectoryAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	FilesDirectory* self;
	FilesDirectoryFileLoadedFunc file_loaded_func;
	gpointer file_loaded_func_target;
	FilesDirectoryDoneLoadingFunc done_loading_func;
	gpointer done_loading_func_target;
	gboolean _tmp0_;
	GHashTable* _tmp1_;
	gboolean _tmp2_;
	FilesDirectoryState _tmp3_;
	GCancellable* _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	FilesPreferences* _tmp7_;
	FilesPreferences* _tmp8_;
	gboolean _tmp9_;
	gboolean _tmp10_;
	gboolean show_hidden;
	GFileEnumerator* e;
	GFile* _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	GCancellable* _tmp14_;
	GFileEnumerator* _tmp15_;
	GFile* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	FilesFile* gof;
	GFile* loc;
	GCancellable* _tmp19_;
	GList* files;
	GFileEnumerator* _tmp20_;
	GCancellable* _tmp21_;
	GList* _tmp22_;
	GList* _tmp23_;
	GList* _tmp24_;
	GList* file_info_collection;
	GList* file_info_it;
	GFileInfo* file_info;
	GFile* _tmp25_;
	GFileInfo* _tmp26_;
	const gchar* _tmp27_;
	GFile* _tmp28_;
	GFile* _tmp29_;
	GFile* _tmp30_;
	FilesFile* _tmp31_;
	FilesFile* _tmp32_;
	GFile* _tmp33_;
	GFile* _tmp34_;
	FilesFile* _tmp35_;
	FilesFile* _tmp36_;
	GFileInfo* _tmp37_;
	GFileInfo* _tmp38_;
	FilesFile* _tmp39_;
	GHashTable* _tmp40_;
	FilesFile* _tmp41_;
	GFile* _tmp42_;
	GFile* _tmp43_;
	GFile* _tmp44_;
	FilesFile* _tmp45_;
	FilesFile* _tmp46_;
	FilesFile* _tmp47_;
	GError* _vala1_e;
	FilesDirectoryState _tmp48_;
	GError* _tmp49_;
	const gchar* _tmp50_;
	GError* _tmp51_;
	const gchar* _tmp52_;
	GCancellable* _tmp53_;
	GError* err;
	const gchar* _tmp54_;
	GError* _tmp55_;
	const gchar* _tmp56_;
	FilesFile* _tmp57_;
	const gchar* _tmp58_;
	const gchar* _tmp59_;
	gboolean _tmp60_;
	GError* _tmp61_;
	GError* _tmp62_;
	FilesFile* _tmp63_;
	GError* _tmp64_;
	GError* _tmp65_;
	FilesFile* _tmp66_;
	FilesFile* _tmp67_;
	GError* _inner_error1_;
	GError* _inner_error0_;
};

struct _FilesDirectoryQueryInfoAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	FilesDirectory* self;
	FilesFile* gof;
	GCancellable* cancellable;
	gboolean result;
	GFileInfo* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	GFileInfo* _tmp5_;
	GFileInfo* _tmp6_;
	GError* err;
	GError* _tmp7_;
	const gchar* _tmp8_;
	GError* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	GError* _tmp13_;
	GFileInfo* _tmp14_;
	GError* _inner_error0_;
};

struct _Block7Data {
	int _ref_count_;
	FilesDirectory* self;
	FilesFile* gof;
};

struct _Block8Data {
	int _ref_count_;
	FilesDirectory* self;
	FilesFile* gof;
};

static gint FilesDirectory_private_offset;
static gpointer files_directory_parent_class = NULL;
static GHashTable* files_directory_directory_cache;
static GRecMutex __lock_files_directory_files_directory_directory_cache = {0};
static GHashTable* files_directory_directory_cache = NULL;
static GMutex files_directory_dir_cache_lock;
static GMutex files_directory_dir_cache_lock = {0};

static GType files_directory_fchanges_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static FilesDirectoryFChanges* files_directory_fchanges_dup (const FilesDirectoryFChanges* self);
static void files_directory_fchanges_free (FilesDirectoryFChanges* self);
static void files_directory_fchanges_copy (const FilesDirectoryFChanges* self,
                                    FilesDirectoryFChanges* dest);
static void files_directory_fchanges_destroy (FilesDirectoryFChanges* self);
static void files_directory_disconnect_volume_monitor_signals (FilesDirectory* self);
static void _files_directory_fchanges_free0_ (gpointer var);
static inline void _g_list_free__files_directory_fchanges_free0_ (GList* self);
static FilesDirectory* files_directory_new (GFile* _file);
static FilesDirectory* files_directory_construct (GType object_type,
                                           GFile* _file);
static void files_directory_set_selected_file (FilesDirectory* self,
                                        GFile* value);
static void files_directory_set_location (FilesDirectory* self,
                                   GFile* value);
static void files_directory_set_file (FilesDirectory* self,
                               FilesFile* value);
static void files_directory_set_state (FilesDirectory* self,
                                FilesDirectoryState value);
static void files_directory_set_can_load (FilesDirectory* self,
                                   gboolean value);
static void files_directory_set_scheme (FilesDirectory* self,
                                 const gchar* value);
static void files_directory_set_is_trash (FilesDirectory* self,
                                   gboolean value);
static void files_directory_set_is_recent (FilesDirectory* self,
                                    gboolean value);
static void files_directory_set_is_admin (FilesDirectory* self,
                                   gboolean value);
static void files_directory_set_is_no_info (FilesDirectory* self,
                                     gboolean value);
static void files_directory_set_is_local (FilesDirectory* self,
                                   gboolean value);
static void files_directory_set_is_network (FilesDirectory* self,
                                     gboolean value);
static void files_directory_set_can_open_files (FilesDirectory* self,
                                         gboolean value);
static void files_directory_set_can_stream_files (FilesDirectory* self,
                                           gboolean value);
static guint _g_file_hash_ghash_func (gconstpointer key);
static gboolean _g_file_equal_gequal_func (gconstpointer a,
                                    gconstpointer b);
static void _g_object_unref0_ (gpointer var);
static void ___lambda10_ (FilesDirectory* self);
static void ____lambda10__g_object_notify (GObject* _sender,
                                    GParamSpec* pspec,
                                    gpointer self);
static void files_directory_set_loaded_from_cache (FilesDirectory* self,
                                            gboolean value);
static void files_directory_list_cached_files (FilesDirectory* self,
                                        FilesDirectoryFileLoadedFunc file_loaded_func,
                                        gpointer file_loaded_func_target,
                                        FilesDirectoryDoneLoadingFunc done_loading_func,
                                        gpointer done_loading_func_target);
static void files_directory_prepare_directory (FilesDirectory* self,
                                        FilesDirectoryFileLoadedFunc file_loaded_func,
                                        gpointer file_loaded_func_target,
                                        FilesDirectoryDoneLoadingFunc done_loading_func,
                                        gpointer done_loading_func_target,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_);
static void files_directory_prepare_directory_finish (FilesDirectory* self,
                                               GAsyncResult* _res_);
static void files_directory_prepare_directory_data_free (gpointer _data);
static gboolean files_directory_prepare_directory_co (FilesDirectoryPrepareDirectoryData* _data_);
static void files_directory_get_file_info (FilesDirectory* self,
                                    GAsyncReadyCallback _callback_,
                                    gpointer _user_data_);
static gboolean files_directory_get_file_info_finish (FilesDirectory* self,
                                               GAsyncResult* _res_);
static void files_directory_prepare_directory_ready (GObject* source_object,
                                              GAsyncResult* _res_,
                                              gpointer _user_data_);
static void files_directory_make_ready (FilesDirectory* self,
                                 gboolean ready,
                                 FilesDirectoryFileLoadedFunc file_loaded_func,
                                 gpointer file_loaded_func_target,
                                 FilesDirectoryDoneLoadingFunc done_loading_func,
                                 gpointer done_loading_func_target,
                                 GAsyncReadyCallback _callback_,
                                 gpointer _user_data_);
static void files_directory_make_ready_finish (FilesDirectory* self,
                                        GAsyncResult* _res_);
static void files_directory_get_file_info_data_free (gpointer _data);
static gboolean files_directory_get_file_info_co (FilesDirectoryGetFileInfoData* _data_);
static void files_directory_get_file_info_ready (GObject* source_object,
                                          GAsyncResult* _res_,
                                          gpointer _user_data_);
static void files_directory_try_query_info (FilesDirectory* self,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_);
static gboolean files_directory_try_query_info_finish (FilesDirectory* self,
                                                GAsyncResult* _res_);
static void files_directory_mount_mountable (FilesDirectory* self,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_);
static gboolean files_directory_mount_mountable_finish (FilesDirectory* self,
                                                 GAsyncResult* _res_);
static void files_directory_try_query_info_data_free (gpointer _data);
static gboolean files_directory_try_query_info_co (FilesDirectoryTryQueryInfoData* _data_);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static gboolean __lambda14_ (Block5Data* _data5_);
static void files_directory_set_last_error_message (FilesDirectory* self,
                                             const gchar* value);
static gboolean ___lambda14__gsource_func (gpointer self);
static void files_directory_query_info_async (FilesDirectory* self,
                                       FilesFile* gof,
                                       GCancellable* cancellable,
                                       GAsyncReadyCallback _callback_,
                                       gpointer _user_data_);
static gboolean files_directory_query_info_finish (FilesDirectory* self,
                                            GAsyncResult* _res_);
static void files_directory_try_query_info_ready (GObject* source_object,
                                           GAsyncResult* _res_,
                                           gpointer _user_data_);
static gboolean files_directory_cancel_timeout (FilesDirectory* self,
                                         guint* id);
static void files_directory_mount_mountable_data_free (gpointer _data);
static gboolean files_directory_mount_mountable_co (FilesDirectoryMountMountableData* _data_);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
static gboolean ___lambda15_ (Block6Data* _data6_);
static gboolean ____lambda15__gsource_func (gpointer self);
static void ____lambda16_ (Block6Data* _data6_);
static void _____lambda16__g_mount_operation_ask_password (GMountOperation* _sender,
                                                    const gchar* message,
                                                    const gchar* default_user,
                                                    const gchar* default_domain,
                                                    GAskPasswordFlags flags,
                                                    gpointer self);
static void ____lambda17_ (Block6Data* _data6_);
static void _____lambda17__g_mount_operation_reply (GMountOperation* _sender,
                                             GMountOperationResult _result_,
                                             gpointer self);
static void files_directory_mount_mountable_ready (GObject* source_object,
                                            GAsyncResult* _res_,
                                            gpointer _user_data_);
static void files_directory_check_network_data_free (gpointer _data);
static gboolean files_directory_check_network_co (FilesDirectoryCheckNetworkData* _data_);
static void files_directory_check_network_ready (GObject* source_object,
                                          GAsyncResult* _res_,
                                          gpointer _user_data_);
static void files_directory_make_ready_data_free (gpointer _data);
static gboolean files_directory_make_ready_co (FilesDirectoryMakeReadyData* _data_);
static void files_directory_after_loading (FilesDirectory* self,
                                    FilesDirectoryDoneLoadingFunc done_loading_func,
                                    gpointer done_loading_func_target);
static void files_directory_toggle_ref_notify (void* data,
                                        GObject* object,
                                        gboolean is_last);
static void files_directory_set_has_trash_dirs (FilesDirectory* self,
                                         gboolean value);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void files_directory_set_confirm_trash (FilesDirectory* self);
static void files_directory_directory_changed (FilesDirectory* self,
                                        GFile* _file,
                                        GFile* other_file,
                                        GFileMonitorEvent event);
static void _files_directory_directory_changed_g_file_monitor_changed (GFileMonitor* _sender,
                                                                GFile* file,
                                                                GFile* other_file,
                                                                GFileMonitorEvent event_type,
                                                                gpointer self);
static void files_directory_connect_volume_monitor_signals (FilesDirectory* self);
static void files_directory_list_directory_async (FilesDirectory* self,
                                           FilesDirectoryFileLoadedFunc file_loaded_func,
                                           gpointer file_loaded_func_target,
                                           FilesDirectoryDoneLoadingFunc done_loading_func,
                                           gpointer done_loading_func_target,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_);
static void files_directory_list_directory_finish (FilesDirectory* self,
                                            GAsyncResult* _res_);
static void files_directory_make_ready_ready (GObject* source_object,
                                       GAsyncResult* _res_,
                                       gpointer _user_data_);
static void files_directory_on_mount_changed (FilesDirectory* self,
                                       GVolumeMonitor* vm,
                                       GMount* mount);
static void _files_directory_on_mount_changed_g_volume_monitor_mount_changed (GVolumeMonitor* _sender,
                                                                       GMount* mount,
                                                                       gpointer self);
static void _files_directory_on_mount_changed_g_volume_monitor_mount_added (GVolumeMonitor* _sender,
                                                                     GMount* mount,
                                                                     gpointer self);
static void files_directory_cancel_timeouts (FilesDirectory* self);
static void files_directory_clear_directory_info (FilesDirectory* self);
static void files_directory_set_displayed_files_count (FilesDirectory* self,
                                                guint value);
static void files_directory_after_load_file (FilesDirectory* self,
                                      FilesFile* gof,
                                      gboolean show_hidden,
                                      FilesDirectoryFileLoadedFunc file_loaded_func,
                                      gpointer file_loaded_func_target);
static void files_directory_list_directory_async_data_free (gpointer _data);
static gboolean files_directory_list_directory_async_co (FilesDirectoryListDirectoryAsyncData* _data_);
static const gchar* files_directory_get_gio_attrs (FilesDirectory* self);
static void files_directory_list_directory_async_ready (GObject* source_object,
                                                 GAsyncResult* _res_,
                                                 gpointer _user_data_);
static gboolean _____lambda18_ (FilesDirectory* self);
static gboolean ______lambda18__gsource_func (gpointer self);
static FilesFile* files_directory_file_cache_find_or_insert (FilesDirectory* self,
                                                      GFile* file,
                                                      gboolean* was_in_hash,
                                                      gboolean update_hash);
static void files_directory_query_info_async_data_free (gpointer _data);
static gboolean files_directory_query_info_async_co (FilesDirectoryQueryInfoAsyncData* _data_);
static void files_directory_query_info_async_ready (GObject* source_object,
                                             GAsyncResult* _res_,
                                             gpointer _user_data_);
static void files_directory_changed_and_refresh (FilesDirectory* self,
                                          FilesFile* gof);
static void files_directory_notify_file_added (FilesDirectory* self,
                                        FilesFile* gof,
                                        gboolean is_internal);
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (void * _userdata_);
static void __lambda12_ (Block7Data* _data7_,
                  GObject* obj,
                  GAsyncResult* res);
static gint _files_file_compare_by_display_name_gcompare_func (gconstpointer a,
                                                        gconstpointer b);
static void ___lambda12__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static void files_directory_notify_file_changed (FilesDirectory* self,
                                          FilesFile* gof);
static Block8Data* block8_data_ref (Block8Data* _data8_);
static void block8_data_unref (void * _userdata_);
static void __lambda13_ (Block8Data* _data8_);
static void ___lambda13__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static void files_directory_notify_file_removed (FilesDirectory* self,
                                          FilesFile* gof);
static void files_directory_real_directory_changed (FilesDirectory* self,
                                             GFile* _file,
                                             GFile* other_file,
                                             GFileMonitorEvent event);
static gboolean ___lambda11_ (FilesDirectory* self);
static gboolean ____lambda11__gsource_func (gpointer self);
static void files_directory_set_has_mounts (FilesDirectory* self,
                                     gboolean value);
static void g_cclosure_user_marshal_VOID__OBJECT_BOOLEAN (GClosure * closure,
                                                   GValue * return_value,
                                                   guint n_param_values,
                                                   const GValue * param_values,
                                                   gpointer invocation_hint,
                                                   gpointer marshal_data);
static void files_directory_finalize (GObject * obj);
static GType files_directory_get_type_once (void);
static void _vala_files_directory_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec);
static void _vala_files_directory_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec);
static void _vala_clear_GMutex (GMutex * mutex);
static void _vala_clear_GRecMutex (GRecMutex * mutex);
static void _vala_clear_GRWLock (GRWLock * mutex);
static void _vala_clear_GCond (GCond * mutex);

static inline gpointer
files_directory_get_instance_private (FilesDirectory* self)
{
	return G_STRUCT_MEMBER_P (self, FilesDirectory_private_offset);
}

 G_GNUC_NO_INLINE static GType
files_directory_state_get_type_once (void)
{
	static const GEnumValue values[] = {{FILES_DIRECTORY_STATE_NOT_LOADED, "FILES_DIRECTORY_STATE_NOT_LOADED", "not-loaded"}, {FILES_DIRECTORY_STATE_LOADING, "FILES_DIRECTORY_STATE_LOADING", "loading"}, {FILES_DIRECTORY_STATE_LOADED, "FILES_DIRECTORY_STATE_LOADED", "loaded"}, {FILES_DIRECTORY_STATE_TIMED_OUT, "FILES_DIRECTORY_STATE_TIMED_OUT", "timed-out"}, {0, NULL, NULL}};
	GType files_directory_state_type_id;
	files_directory_state_type_id = g_enum_register_static ("FilesDirectoryState", values);
	return files_directory_state_type_id;
}

GType
files_directory_state_get_type (void)
{
	static volatile gsize files_directory_state_type_id__once = 0;
	if (g_once_init_enter (&files_directory_state_type_id__once)) {
		GType files_directory_state_type_id;
		files_directory_state_type_id = files_directory_state_get_type_once ();
		g_once_init_leave (&files_directory_state_type_id__once, files_directory_state_type_id);
	}
	return files_directory_state_type_id__once;
}

static void
_files_directory_fchanges_free0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (files_directory_fchanges_free (var), NULL));
}

static inline void
_g_list_free__files_directory_fchanges_free0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _files_directory_fchanges_free0_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

FilesDirectory*
files_directory_from_gfile (GFile* file)
{
	gchar* escaped_uri = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* scheme = NULL;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	GFile* gfile = NULL;
	const gchar* _tmp11_;
	GFile* _tmp12_;
	GFile* creation_key = NULL;
	GFile* _tmp13_;
	GFile* _tmp14_;
	gboolean _tmp15_ = FALSE;
	gboolean _tmp16_ = FALSE;
	GFile* _tmp17_;
	FilesDirectory* dir = NULL;
	GFile* _tmp23_;
	FilesDirectory* _tmp24_;
	FilesDirectory* _tmp25_;
	GFile* _tmp34_;
	GFile* _tmp35_;
	GError* _inner_error0_ = NULL;
	FilesDirectory* result;
	g_return_val_if_fail (file != NULL, NULL);
	_tmp0_ = g_file_get_uri (file);
	_tmp1_ = _tmp0_;
	_tmp2_ = files_file_utils_escape_uri (_tmp1_, TRUE, TRUE);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	escaped_uri = _tmp3_;
	_tmp4_ = escaped_uri;
	_tmp5_ = g_uri_parse_scheme (_tmp4_);
	scheme = _tmp5_;
	_tmp6_ = scheme;
	if (_tmp6_ == NULL) {
		gchar* _tmp7_;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp7_ = g_strdup (FILES_ROOT_FS_URI);
		_g_free0 (scheme);
		scheme = _tmp7_;
		_tmp8_ = scheme;
		_tmp9_ = escaped_uri;
		_tmp10_ = g_strconcat (_tmp8_, _tmp9_, NULL);
		_g_free0 (escaped_uri);
		escaped_uri = _tmp10_;
	}
	_tmp11_ = escaped_uri;
	_tmp12_ = g_file_new_for_uri (_tmp11_);
	gfile = _tmp12_;
	_tmp13_ = gfile;
	_tmp14_ = _g_object_ref0 (_tmp13_);
	creation_key = _tmp14_;
	_tmp17_ = gfile;
	if (g_file_query_exists (_tmp17_, NULL)) {
		GFile* _tmp18_;
		_tmp18_ = gfile;
		_tmp16_ = g_file_is_native (_tmp18_);
	} else {
		_tmp16_ = FALSE;
	}
	if (_tmp16_) {
		GFile* _tmp19_;
		_tmp19_ = gfile;
		_tmp15_ = g_file_has_parent (_tmp19_, NULL);
	} else {
		_tmp15_ = FALSE;
	}
	if (_tmp15_) {
		GFileType ftype = 0;
		GFile* _tmp20_;
		_tmp20_ = gfile;
		ftype = g_file_query_file_type (_tmp20_, 0, NULL);
		if (ftype != G_FILE_TYPE_DIRECTORY) {
			GFile* _tmp21_;
			GFile* _tmp22_;
			_tmp21_ = gfile;
			_tmp22_ = g_file_get_parent (_tmp21_);
			_g_object_unref0 (creation_key);
			creation_key = _tmp22_;
		}
	}
	_tmp23_ = creation_key;
	_tmp24_ = files_directory_cache_lookup (_tmp23_);
	dir = _tmp24_;
	_tmp25_ = dir;
	if (_tmp25_ == NULL) {
		GFile* _tmp26_;
		FilesDirectory* _tmp27_;
		_tmp26_ = creation_key;
		_tmp27_ = files_directory_new (_tmp26_);
		_g_object_unref0 (dir);
		dir = _tmp27_;
		{
			GHashTable* _tmp28_;
			_tmp28_ = files_directory_directory_cache;
			g_rec_mutex_lock (&__lock_files_directory_files_directory_directory_cache);
			{
				GHashTable* _tmp29_;
				GFile* _tmp30_;
				FilesDirectory* _tmp31_;
				FilesDirectory* _tmp32_;
				_tmp29_ = files_directory_directory_cache;
				_tmp30_ = creation_key;
				_tmp31_ = dir;
				_tmp32_ = _g_object_ref0 (_tmp31_);
				g_hash_table_insert (_tmp29_, _tmp30_, _tmp32_);
			}
			__finally0:
			{
				GHashTable* _tmp33_;
				_tmp33_ = files_directory_directory_cache;
				g_rec_mutex_unlock (&__lock_files_directory_files_directory_directory_cache);
			}
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (dir);
				_g_object_unref0 (creation_key);
				_g_object_unref0 (gfile);
				_g_free0 (scheme);
				_g_free0 (escaped_uri);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
	}
	_tmp34_ = creation_key;
	_tmp35_ = gfile;
	if (!g_file_equal (_tmp34_, _tmp35_)) {
		FilesDirectory* _tmp36_;
		_tmp36_ = dir;
		files_directory_set_selected_file (_tmp36_, file);
	}
	result = dir;
	_g_object_unref0 (creation_key);
	_g_object_unref0 (gfile);
	_g_free0 (scheme);
	_g_free0 (escaped_uri);
	return result;
}

FilesDirectory*
files_directory_from_file (FilesFile* gof)
{
	FilesDirectory* result;
	g_return_val_if_fail (gof != NULL, NULL);
	if (files_file_is_trashed (gof)) {
		GFile* _tmp0_;
		GFile* _tmp1_;
		FilesDirectory* _tmp2_;
		_tmp0_ = files_file_get_location (gof);
		_tmp1_ = _tmp0_;
		_tmp2_ = files_directory_from_gfile (_tmp1_);
		result = _tmp2_;
		return result;
	} else {
		GFile* _tmp3_;
		FilesDirectory* _tmp4_;
		_tmp3_ = files_file_get_target_location (gof);
		_tmp4_ = files_directory_from_gfile (_tmp3_);
		result = _tmp4_;
		return result;
	}
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static guint
_g_file_hash_ghash_func (gconstpointer key)
{
	guint result;
	result = g_file_hash (key);
	return result;
}

static gboolean
_g_file_equal_gequal_func (gconstpointer a,
                           gconstpointer b)
{
	gboolean result;
	result = g_file_equal (a, (GFile*) b);
	return result;
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static void
___lambda10_ (FilesDirectory* self)
{
	g_signal_emit (self, files_directory_signals[FILES_DIRECTORY_NEED_RELOAD_SIGNAL], 0, TRUE);
}

static void
____lambda10__g_object_notify (GObject* _sender,
                               GParamSpec* pspec,
                               gpointer self)
{
	___lambda10_ ((FilesDirectory*) self);
}

static FilesDirectory*
files_directory_construct (GType object_type,
                           GFile* _file)
{
	FilesDirectory * self = NULL;
	GFile* _tmp0_;
	FilesFile* _tmp1_;
	FilesFile* _tmp2_;
	GCancellable* _tmp3_;
	GFile* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	GFile* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	gboolean _tmp11_ = FALSE;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_;
	gboolean _tmp16_ = FALSE;
	gboolean _tmp17_;
	const gchar* _tmp19_;
	GHashTable* _tmp20_;
	gboolean _tmp21_;
	g_return_val_if_fail (_file != NULL, NULL);
	self = (FilesDirectory*) g_object_new (object_type, "creation-key", _file, NULL);
	files_directory_set_location (self, _file);
	_tmp0_ = self->priv->_location;
	_tmp1_ = files_file_get (_tmp0_);
	_tmp2_ = _tmp1_;
	files_directory_set_file (self, _tmp2_);
	_g_object_unref0 (_tmp2_);
	files_directory_set_selected_file (self, NULL);
	_tmp3_ = g_cancellable_new ();
	_g_object_unref0 (self->priv->cancellable);
	self->priv->cancellable = _tmp3_;
	files_directory_set_state (self, FILES_DIRECTORY_STATE_NOT_LOADED);
	files_directory_set_can_load (self, FALSE);
	_tmp4_ = self->priv->_location;
	_tmp5_ = g_file_get_uri_scheme (_tmp4_);
	_tmp6_ = _tmp5_;
	files_directory_set_scheme (self, _tmp6_);
	_g_free0 (_tmp6_);
	_tmp7_ = self->priv->_location;
	files_directory_set_is_trash (self, files_file_utils_location_is_in_trash (_tmp7_));
	_tmp8_ = self->priv->_scheme;
	files_directory_set_is_recent (self, g_strcmp0 (_tmp8_, "recent") == 0);
	_tmp9_ = self->priv->_scheme;
	files_directory_set_is_admin (self, g_strcmp0 (_tmp9_, "admin") == 0);
	_tmp10_ = self->priv->_scheme;
	files_directory_set_is_no_info (self, string_contains ("cdda mtp gphoto2 ssh sftp afp afc dav davs", _tmp10_));
	_tmp13_ = self->priv->_is_trash;
	if (_tmp13_) {
		_tmp12_ = TRUE;
	} else {
		gboolean _tmp14_;
		_tmp14_ = self->priv->_is_recent;
		_tmp12_ = _tmp14_;
	}
	if (_tmp12_) {
		_tmp11_ = TRUE;
	} else {
		const gchar* _tmp15_;
		_tmp15_ = self->priv->_scheme;
		_tmp11_ = g_strcmp0 (_tmp15_, "file") == 0;
	}
	files_directory_set_is_local (self, _tmp11_);
	_tmp17_ = self->priv->_is_local;
	if (!_tmp17_) {
		const gchar* _tmp18_;
		_tmp18_ = self->priv->_scheme;
		_tmp16_ = string_contains ("smb ftp sftp afp dav davs", _tmp18_);
	} else {
		_tmp16_ = FALSE;
	}
	files_directory_set_is_network (self, _tmp16_);
	files_directory_set_can_open_files (self, TRUE);
	_tmp19_ = self->priv->_scheme;
	files_directory_set_can_stream_files (self, !string_contains ("ftp sftp", _tmp19_));
	_tmp20_ = g_hash_table_new_full (_g_file_hash_ghash_func, _g_file_equal_gequal_func, _g_object_unref0_, _g_object_unref0_);
	_g_hash_table_unref0 (self->priv->file_hash);
	self->priv->file_hash = _tmp20_;
	_tmp21_ = self->priv->_is_recent;
	if (_tmp21_) {
		FilesPreferences* _tmp22_;
		FilesPreferences* _tmp23_;
		_tmp22_ = files_preferences_get_default ();
		_tmp23_ = _tmp22_;
		g_signal_connect_object ((GObject*) _tmp23_, "notify::remember-history", (GCallback) ____lambda10__g_object_notify, self, 0);
		_g_object_unref0 (_tmp23_);
	}
	return self;
}

static FilesDirectory*
files_directory_new (GFile* _file)
{
	return files_directory_construct (FILES_TYPE_DIRECTORY, _file);
}

/** Views call the following function with null parameter - file_loaded and done_loading
      * signals are emitted and cause the view and view container to update.
      *
      * LocationBar calls this function, with a callback, on its own Directory instances in order
      * to perform filename completion.- Emitting a done_loaded signal in that case would cause
      * the premature ending of text entry.
     **/
void
files_directory_init (FilesDirectory* self,
                      FilesDirectoryFileLoadedFunc file_loaded_func,
                      gpointer file_loaded_func_target,
                      FilesDirectoryDoneLoadingFunc done_loading_func,
                      gpointer done_loading_func_target)
{
	FilesDirectoryState _tmp0_;
	FilesDirectoryState previous_state = 0;
	FilesDirectoryState _tmp1_;
	GCancellable* _tmp2_;
	GCancellable* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_state;
	if (_tmp0_ == FILES_DIRECTORY_STATE_LOADING) {
		g_debug ("Directory.vala:225: Directory Init re-entered - already loading");
		return;
	}
	_tmp1_ = self->priv->_state;
	previous_state = _tmp1_;
	files_directory_set_loaded_from_cache (self, FALSE);
	_tmp2_ = self->priv->cancellable;
	g_cancellable_cancel (_tmp2_);
	_tmp3_ = g_cancellable_new ();
	_g_object_unref0 (self->priv->cancellable);
	self->priv->cancellable = _tmp3_;
	if (previous_state == FILES_DIRECTORY_STATE_LOADED) {
		files_directory_list_cached_files (self, file_loaded_func, file_loaded_func_target, done_loading_func, done_loading_func_target);
	} else {
		files_directory_set_state (self, FILES_DIRECTORY_STATE_LOADING);
		files_directory_prepare_directory (self, file_loaded_func, file_loaded_func_target, done_loading_func, done_loading_func_target, NULL, NULL);
	}
}

static void
files_directory_prepare_directory_data_free (gpointer _data)
{
	FilesDirectoryPrepareDirectoryData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (FilesDirectoryPrepareDirectoryData, _data_);
}

static void
files_directory_prepare_directory (FilesDirectory* self,
                                   FilesDirectoryFileLoadedFunc file_loaded_func,
                                   gpointer file_loaded_func_target,
                                   FilesDirectoryDoneLoadingFunc done_loading_func,
                                   gpointer done_loading_func_target,
                                   GAsyncReadyCallback _callback_,
                                   gpointer _user_data_)
{
	FilesDirectoryPrepareDirectoryData* _data_;
	FilesDirectory* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (FilesDirectoryPrepareDirectoryData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, files_directory_prepare_directory_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_data_->file_loaded_func = file_loaded_func;
	_data_->file_loaded_func_target = file_loaded_func_target;
	_data_->done_loading_func = done_loading_func;
	_data_->done_loading_func_target = done_loading_func_target;
	files_directory_prepare_directory_co (_data_);
}

static void
files_directory_prepare_directory_finish (FilesDirectory* self,
                                          GAsyncResult* _res_)
{
	FilesDirectoryPrepareDirectoryData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
files_directory_prepare_directory_ready (GObject* source_object,
                                         GAsyncResult* _res_,
                                         gpointer _user_data_)
{
	FilesDirectoryPrepareDirectoryData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	files_directory_prepare_directory_co (_data_);
}

static gchar*
bool_to_string (gboolean self)
{
	gchar* result;
	if (self) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("true");
		result = _tmp0_;
		return result;
	} else {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("false");
		result = _tmp1_;
		return result;
	}
}

static gboolean
files_directory_prepare_directory_co (FilesDirectoryPrepareDirectoryData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	g_debug ("Directory.vala:250: Preparing directory for loading");
	_data_->_tmp0_ = _data_->self->priv->_file;
	_g_object_unref0 (_data_->_tmp0_->info);
	_data_->_tmp0_->info = NULL;
	_data_->_state_ = 1;
	files_directory_get_file_info (_data_->self, files_directory_prepare_directory_ready, _data_);
	return FALSE;
	_state_1:
	_data_->success = files_directory_get_file_info_finish (_data_->self, _data_->_res_);
	if (_data_->success) {
		_data_->_tmp3_ = _data_->self->priv->_is_no_info;
		if (!_data_->_tmp3_) {
			_data_->_tmp4_ = _data_->self->priv->_file;
			_data_->_tmp2_ = !files_file_is_folder (_data_->_tmp4_);
		} else {
			_data_->_tmp2_ = FALSE;
		}
		if (_data_->_tmp2_) {
			_data_->_tmp5_ = _data_->self->priv->_file;
			_data_->_tmp1_ = !files_file_is_root_network_folder (_data_->_tmp5_);
		} else {
			_data_->_tmp1_ = FALSE;
		}
		if (_data_->_tmp1_) {
			g_critical ("Directory.vala:259: Trying to load a non-folder - finding parent");
			_data_->_tmp7_ = _data_->self->priv->_file;
			if (_data_->_tmp7_->is_connected) {
				_data_->_tmp8_ = _data_->self->priv->_location;
				_data_->_tmp9_ = g_file_get_parent (_data_->_tmp8_);
				_g_object_unref0 (_data_->_tmp6_);
				_data_->_tmp6_ = _data_->_tmp9_;
			} else {
				_g_object_unref0 (_data_->_tmp6_);
				_data_->_tmp6_ = NULL;
			}
			_data_->_tmp10_ = _g_object_ref0 (_data_->_tmp6_);
			_data_->parent = _data_->_tmp10_;
			_data_->_tmp11_ = _data_->parent;
			if (_data_->_tmp11_ != NULL) {
				_data_->_tmp12_ = _data_->parent;
				_data_->_tmp13_ = files_file_get (_data_->_tmp12_);
				_data_->_tmp14_ = _data_->_tmp13_;
				files_directory_set_file (_data_->self, _data_->_tmp14_);
				_g_object_unref0 (_data_->_tmp14_);
				_data_->_tmp15_ = _data_->self->priv->_location;
				files_directory_set_selected_file (_data_->self, _data_->_tmp15_);
				_data_->_tmp16_ = _data_->parent;
				files_directory_set_location (_data_->self, _data_->_tmp16_);
				_data_->_state_ = 2;
				files_directory_get_file_info (_data_->self, files_directory_prepare_directory_ready, _data_);
				return FALSE;
				_state_2:
				_data_->success = files_directory_get_file_info_finish (_data_->self, _data_->_res_);
			} else {
				_data_->_tmp17_ = _data_->self->priv->_file;
				_data_->_tmp18_ = files_file_get_uri (_data_->_tmp17_);
				_data_->_tmp19_ = _data_->_tmp18_;
				g_debug ("Directory.vala:267: Parent is null for file %s", _data_->_tmp19_);
				_data_->success = FALSE;
			}
			_g_object_unref0 (_data_->parent);
			_g_object_unref0 (_data_->_tmp6_);
		}
	}
	if (_data_->success) {
		_data_->_tmp20_ = _data_->self->priv->_file;
		files_file_update (_data_->_tmp20_);
	}
	_data_->_tmp22_ = _data_->self->priv->_file;
	_data_->_tmp23_ = _data_->_tmp22_->mount;
	if (_data_->_tmp23_ != NULL) {
		_data_->_tmp24_ = _data_->self->priv->_file;
		_data_->_tmp25_ = _data_->_tmp24_->mount;
		_data_->_tmp26_ = g_mount_get_name (_data_->_tmp25_);
		_g_free0 (_data_->_tmp21_);
		_data_->_tmp21_ = _data_->_tmp26_;
	} else {
		_data_->_tmp27_ = g_strdup ("null");
		_g_free0 (_data_->_tmp21_);
		_data_->_tmp21_ = _data_->_tmp27_;
	}
	_data_->_tmp28_ = _data_->self->priv->_file;
	_data_->_tmp29_ = bool_to_string (_data_->_tmp28_->is_connected);
	_data_->_tmp30_ = _data_->_tmp29_;
	_data_->_tmp31_ = bool_to_string (_data_->success);
	_data_->_tmp32_ = _data_->_tmp31_;
	g_debug ("Directory.vala:277: is connected %s, success %s; enclosing mount %s", _data_->_tmp30_, _data_->_tmp32_, _data_->_tmp21_);
	_g_free0 (_data_->_tmp32_);
	_g_free0 (_data_->_tmp30_);
	_data_->_tmp34_ = _data_->self->priv->_is_no_info;
	if (_data_->_tmp34_) {
		_data_->_tmp33_ = TRUE;
	} else {
		_data_->_tmp33_ = _data_->success;
	}
	_data_->_state_ = 3;
	files_directory_make_ready (_data_->self, _data_->_tmp33_, _data_->file_loaded_func, _data_->file_loaded_func_target, _data_->done_loading_func, _data_->done_loading_func_target, files_directory_prepare_directory_ready, _data_);
	return FALSE;
	_state_3:
	files_directory_make_ready_finish (_data_->self, _data_->_res_);
	_g_free0 (_data_->_tmp21_);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
files_directory_get_file_info_data_free (gpointer _data)
{
	FilesDirectoryGetFileInfoData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (FilesDirectoryGetFileInfoData, _data_);
}

static void
files_directory_get_file_info (FilesDirectory* self,
                               GAsyncReadyCallback _callback_,
                               gpointer _user_data_)
{
	FilesDirectoryGetFileInfoData* _data_;
	FilesDirectory* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (FilesDirectoryGetFileInfoData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, files_directory_get_file_info_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	files_directory_get_file_info_co (_data_);
}

static gboolean
files_directory_get_file_info_finish (FilesDirectory* self,
                                      GAsyncResult* _res_)
{
	gboolean result;
	FilesDirectoryGetFileInfoData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	return result;
}

/*** Returns false if should be able to get info but were unable to ***/
static void
files_directory_get_file_info_ready (GObject* source_object,
                                     GAsyncResult* _res_,
                                     gpointer _user_data_)
{
	FilesDirectoryGetFileInfoData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	files_directory_get_file_info_co (_data_);
}

static gboolean
files_directory_get_file_info_co (FilesDirectoryGetFileInfoData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		case 4:
		goto _state_4;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	g_debug ("Directory.vala:290: get_file_info");
	_data_->_tmp1_ = _data_->self->priv->_is_network;
	if (_data_->_tmp1_) {
		_data_->_state_ = 1;
		files_directory_check_network (_data_->self, files_directory_get_file_info_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp0_ = !files_directory_check_network_finish (_data_->self, _data_->_res_);
	} else {
		_data_->_tmp0_ = FALSE;
	}
	if (_data_->_tmp0_) {
		g_debug ("Directory.vala:293: No network found");
		_data_->_tmp2_ = _data_->self->priv->_file;
		_data_->_tmp2_->is_connected = FALSE;
		_data_->result = FALSE;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_state_ = 2;
	files_directory_try_query_info (_data_->self, files_directory_get_file_info_ready, _data_);
	return FALSE;
	_state_2:
	if (!files_directory_try_query_info_finish (_data_->self, _data_->_res_)) {
		g_debug ("Directory.vala:302: try query info failed - trying to mount");
		_data_->_state_ = 3;
		files_directory_mount_mountable (_data_->self, files_directory_get_file_info_ready, _data_);
		return FALSE;
		_state_3:
		if (files_directory_mount_mountable_finish (_data_->self, _data_->_res_)) {
			_data_->_tmp3_ = _data_->self->priv->_file;
			_data_->_tmp4_ = files_file_get_uri (_data_->_tmp3_);
			_data_->_tmp5_ = _data_->_tmp4_;
			g_debug ("Directory.vala:308: successful mount %s", _data_->_tmp5_);
			_data_->_tmp6_ = _data_->self->priv->_file;
			_data_->_tmp6_->is_mounted = TRUE;
			_data_->_state_ = 4;
			files_directory_try_query_info (_data_->self, files_directory_get_file_info_ready, _data_);
			return FALSE;
			_state_4:
			if (files_directory_try_query_info_finish (_data_->self, _data_->_res_)) {
				_data_->_tmp7_ = TRUE;
			} else {
				_data_->_tmp8_ = _data_->self->priv->_is_no_info;
				_data_->_tmp7_ = _data_->_tmp8_;
			}
			_data_->result = _data_->_tmp7_;
			g_task_return_pointer (_data_->_async_result, _data_, NULL);
			if (_data_->_state_ != 0) {
				while (!g_task_get_completed (_data_->_async_result)) {
					g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
				}
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_data_->_tmp9_ = _data_->self->priv->_file;
			_data_->_tmp10_ = files_file_get_uri (_data_->_tmp9_);
			_data_->_tmp11_ = _data_->_tmp10_;
			g_debug ("Directory.vala:312: failed mount %s", _data_->_tmp11_);
			_data_->result = FALSE;
			g_task_return_pointer (_data_->_async_result, _data_, NULL);
			if (_data_->_state_ != 0) {
				while (!g_task_get_completed (_data_->_async_result)) {
					g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
				}
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	} else {
		_data_->result = TRUE;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
}

static void
files_directory_try_query_info_data_free (gpointer _data)
{
	FilesDirectoryTryQueryInfoData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (FilesDirectoryTryQueryInfoData, _data_);
}

static void
files_directory_try_query_info (FilesDirectory* self,
                                GAsyncReadyCallback _callback_,
                                gpointer _user_data_)
{
	FilesDirectoryTryQueryInfoData* _data_;
	FilesDirectory* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (FilesDirectoryTryQueryInfoData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, files_directory_try_query_info_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	files_directory_try_query_info_co (_data_);
}

static gboolean
files_directory_try_query_info_finish (FilesDirectory* self,
                                       GAsyncResult* _res_)
{
	gboolean result;
	FilesDirectoryTryQueryInfoData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	return result;
}

static Block5Data*
block5_data_ref (Block5Data* _data5_)
{
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}

static void
block5_data_unref (void * _userdata_)
{
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		FilesDirectory* self;
		self = _data5_->self;
		_g_object_unref0 (self);
		g_slice_free (Block5Data, _data5_);
	}
}

static gboolean
__lambda14_ (Block5Data* _data5_)
{
	FilesDirectory* self;
	gboolean result;
	self = _data5_->self;
	if (_data5_->querying) {
		FilesFile* _tmp0_;
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		GCancellable* _tmp3_;
		_tmp0_ = self->priv->_file;
		_tmp1_ = files_file_get_uri (_tmp0_);
		_tmp2_ = _tmp1_;
		g_debug ("Directory.vala:327: Cancelled after timeout in query info async %s", _tmp2_);
		_tmp3_ = self->priv->cancellable;
		g_cancellable_cancel (_tmp3_);
		files_directory_set_last_error_message (self, "Timed out while querying file info");
	}
	self->priv->load_timeout_id = (guint) 0;
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda14__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda14_ (self);
	return result;
}

static void
files_directory_try_query_info_ready (GObject* source_object,
                                      GAsyncResult* _res_,
                                      gpointer _user_data_)
{
	FilesDirectoryTryQueryInfoData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	files_directory_try_query_info_co (_data_);
}

static gboolean
files_directory_try_query_info_co (FilesDirectoryTryQueryInfoData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data5_ = g_slice_new0 (Block5Data);
	_data_->_data5_->_ref_count_ = 1;
	_data_->_data5_->self = g_object_ref (_data_->self);
	_data_->_data5_->_async_data_ = _data_;
	g_debug ("Directory.vala:321: try_query_info");
	_data_->_tmp0_ = g_cancellable_new ();
	_g_object_unref0 (_data_->self->priv->cancellable);
	_data_->self->priv->cancellable = _data_->_tmp0_;
	_data_->_data5_->querying = TRUE;
	_vala_assert (_data_->self->priv->load_timeout_id == ((guint) 0), "load_timeout_id == 0");
	_data_->self->priv->load_timeout_id = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) FILES_DIRECTORY_QUERY_INFO_TIMEOUT_SEC, ___lambda14__gsource_func, block5_data_ref (_data_->_data5_), block5_data_unref);
	_data_->_tmp1_ = _data_->self->priv->_file;
	_data_->_tmp2_ = _data_->self->priv->cancellable;
	_data_->_state_ = 1;
	files_directory_query_info_async (_data_->self, _data_->_tmp1_, _data_->_tmp2_, files_directory_try_query_info_ready, _data_);
	return FALSE;
	_state_1:
	_data_->success = files_directory_query_info_finish (_data_->self, _data_->_res_);
	_data_->_data5_->querying = FALSE;
	files_directory_cancel_timeout (_data_->self, &_data_->self->priv->load_timeout_id);
	_data_->_tmp3_ = _data_->self->priv->cancellable;
	if (g_cancellable_is_cancelled (_data_->_tmp3_)) {
		g_debug ("Directory.vala:340: Failed to get info - timed out and cancelled");
		_data_->_tmp4_ = _data_->self->priv->_file;
		_data_->_tmp4_->is_connected = FALSE;
		_data_->result = FALSE;
		block5_data_unref (_data_->_data5_);
		_data_->_data5_ = NULL;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	if (_data_->success) {
		g_debug ("Directory.vala:346: got file info - updating");
		_data_->_tmp5_ = _data_->self->priv->_file;
		files_file_update (_data_->_tmp5_);
		_data_->_tmp7_ = _data_->self->priv->_file;
		_data_->_tmp8_ = _data_->_tmp7_->mount;
		if (_data_->_tmp8_ != NULL) {
			_data_->_tmp9_ = _data_->self->priv->_file;
			_data_->_tmp10_ = _data_->_tmp9_->mount;
			_data_->_tmp11_ = g_mount_get_name (_data_->_tmp10_);
			_g_free0 (_data_->_tmp6_);
			_data_->_tmp6_ = _data_->_tmp11_;
		} else {
			_data_->_tmp12_ = g_strdup ("null");
			_g_free0 (_data_->_tmp6_);
			_data_->_tmp6_ = _data_->_tmp12_;
		}
		_data_->_tmp13_ = bool_to_string (_data_->success);
		_data_->_tmp14_ = _data_->_tmp13_;
		g_debug ("Directory.vala:348: success %s; enclosing mount %s", _data_->_tmp14_, _data_->_tmp6_);
		_g_free0 (_data_->_tmp14_);
		_data_->result = TRUE;
		_g_free0 (_data_->_tmp6_);
		block5_data_unref (_data_->_data5_);
		_data_->_data5_ = NULL;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	} else {
		_data_->_tmp15_ = _data_->self->priv->_file;
		_data_->_tmp16_ = files_file_get_uri (_data_->_tmp15_);
		_data_->_tmp17_ = _data_->_tmp16_;
		g_debug ("Directory.vala:352: Failed to get file info for %s", _data_->_tmp17_);
		_data_->result = FALSE;
		block5_data_unref (_data_->_data5_);
		_data_->_data5_ = NULL;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
}

static void
files_directory_mount_mountable_data_free (gpointer _data)
{
	FilesDirectoryMountMountableData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (FilesDirectoryMountMountableData, _data_);
}

static void
files_directory_mount_mountable (FilesDirectory* self,
                                 GAsyncReadyCallback _callback_,
                                 gpointer _user_data_)
{
	FilesDirectoryMountMountableData* _data_;
	FilesDirectory* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (FilesDirectoryMountMountableData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, files_directory_mount_mountable_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	files_directory_mount_mountable_co (_data_);
}

static gboolean
files_directory_mount_mountable_finish (FilesDirectory* self,
                                        GAsyncResult* _res_)
{
	gboolean result;
	FilesDirectoryMountMountableData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	return result;
}

static Block6Data*
block6_data_ref (Block6Data* _data6_)
{
	g_atomic_int_inc (&_data6_->_ref_count_);
	return _data6_;
}

static void
block6_data_unref (void * _userdata_)
{
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
		FilesDirectory* self;
		self = _data6_->self;
		_g_object_unref0 (self);
		g_slice_free (Block6Data, _data6_);
	}
}

static gboolean
___lambda15_ (Block6Data* _data6_)
{
	FilesDirectory* self;
	gboolean _tmp0_ = FALSE;
	gboolean result;
	self = _data6_->self;
	if (_data6_->mounting) {
		_tmp0_ = !_data6_->asking_password;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		FilesFile* _tmp1_;
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		FilesFile* _tmp4_;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		GCancellable* _tmp9_;
		self->priv->mount_timeout_id = (guint) 0;
		_tmp1_ = self->priv->_file;
		_tmp2_ = files_file_get_uri (_tmp1_);
		_tmp3_ = _tmp2_;
		g_debug ("Directory.vala:371: Cancelled after timeout in mount mountable %s", _tmp3_);
		_tmp4_ = self->priv->_file;
		_tmp5_ = files_file_get_uri (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = g_strdup_printf ("Timed out when trying to mount %s", _tmp6_);
		_tmp8_ = _tmp7_;
		files_directory_set_last_error_message (self, _tmp8_);
		_g_free0 (_tmp8_);
		files_directory_set_state (self, FILES_DIRECTORY_STATE_TIMED_OUT);
		_tmp9_ = self->priv->cancellable;
		g_cancellable_cancel (_tmp9_);
		result = G_SOURCE_REMOVE;
		return result;
	} else {
		result = G_SOURCE_CONTINUE;
		return result;
	}
}

static gboolean
____lambda15__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda15_ (self);
	return result;
}

static void
____lambda16_ (Block6Data* _data6_)
{
	FilesDirectory* self;
	self = _data6_->self;
	g_debug ("Directory.vala:386: Asking for password");
	_data6_->asking_password = TRUE;
}

static void
_____lambda16__g_mount_operation_ask_password (GMountOperation* _sender,
                                               const gchar* message,
                                               const gchar* default_user,
                                               const gchar* default_domain,
                                               GAskPasswordFlags flags,
                                               gpointer self)
{
	____lambda16_ (self);
}

static void
____lambda17_ (Block6Data* _data6_)
{
	FilesDirectory* self;
	self = _data6_->self;
	g_debug ("Directory.vala:391: Password dialog finished");
	_data6_->asking_password = FALSE;
}

static void
_____lambda17__g_mount_operation_reply (GMountOperation* _sender,
                                        GMountOperationResult _result_,
                                        gpointer self)
{
	____lambda17_ (self);
}

static void
files_directory_mount_mountable_ready (GObject* source_object,
                                       GAsyncResult* _res_,
                                       gpointer _user_data_)
{
	FilesDirectoryMountMountableData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	files_directory_mount_mountable_co (_data_);
}

static gboolean
files_directory_mount_mountable_co (FilesDirectoryMountMountableData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	g_debug ("Directory.vala:358: mount_mountable");
	_data_->res = FALSE;
	_data_->mount_op = NULL;
	_data_->_tmp0_ = g_cancellable_new ();
	_g_object_unref0 (_data_->self->priv->cancellable);
	_data_->self->priv->cancellable = _data_->_tmp0_;
	{
		_data_->_data6_ = g_slice_new0 (Block6Data);
		_data_->_data6_->_ref_count_ = 1;
		_data_->_data6_->self = g_object_ref (_data_->self);
		_data_->_data6_->mounting = TRUE;
		_data_->_data6_->asking_password = FALSE;
		_vala_assert (_data_->self->priv->mount_timeout_id == ((guint) 0), "mount_timeout_id == 0");
		_data_->self->priv->mount_timeout_id = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) FILES_DIRECTORY_MOUNT_TIMEOUT_SEC, ____lambda15__gsource_func, block6_data_ref (_data_->_data6_), block6_data_unref);
		_data_->_tmp1_ = _data_->self->priv->_allow_user_interaction;
		if (_data_->_tmp1_) {
			_data_->_tmp2_ = (GtkMountOperation*) gtk_mount_operation_new (NULL);
			_g_object_unref0 (_data_->mount_op);
			_data_->mount_op = _data_->_tmp2_;
			_data_->_tmp3_ = _data_->mount_op;
			g_signal_connect_data ((GMountOperation*) _data_->_tmp3_, "ask-password", (GCallback) _____lambda16__g_mount_operation_ask_password, block6_data_ref (_data_->_data6_), (GClosureNotify) block6_data_unref, 0);
			_data_->_tmp4_ = _data_->mount_op;
			g_signal_connect_data ((GMountOperation*) _data_->_tmp4_, "reply", (GCallback) _____lambda17__g_mount_operation_reply, block6_data_ref (_data_->_data6_), (GClosureNotify) block6_data_unref, 0);
		}
		g_debug ("Directory.vala:396: mounting…");
		_data_->_tmp6_ = _data_->self->priv->_location;
		_data_->_tmp7_ = _data_->mount_op;
		_data_->_tmp8_ = _data_->self->priv->cancellable;
		_data_->_state_ = 1;
		g_file_mount_enclosing_volume (_data_->_tmp6_, G_MOUNT_MOUNT_NONE, (GMountOperation*) _data_->_tmp7_, _data_->_tmp8_, files_directory_mount_mountable_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp5_ = g_file_mount_enclosing_volume_finish (_data_->_tmp6_, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			block6_data_unref (_data_->_data6_);
			_data_->_data6_ = NULL;
			goto __catch0_g_error;
		}
		_data_->res = _data_->_tmp5_;
		block6_data_unref (_data_->_data6_);
		_data_->_data6_ = NULL;
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp9_ = _data_->e;
		_data_->_tmp10_ = _data_->_tmp9_->message;
		files_directory_set_last_error_message (_data_->self, _data_->_tmp10_);
		_data_->_tmp11_ = _data_->e;
		if (g_error_matches (_data_->_tmp11_, G_IO_ERROR, G_IO_ERROR_ALREADY_MOUNTED)) {
			_data_->_tmp12_ = _data_->self->priv->_file;
			_data_->_tmp13_ = files_file_get_uri (_data_->_tmp12_);
			_data_->_tmp14_ = _data_->_tmp13_;
			g_debug ("Directory.vala:401: Already mounted %s", _data_->_tmp14_);
			_data_->_tmp15_ = _data_->self->priv->_file;
			_data_->_tmp15_->is_connected = TRUE;
			_data_->res = TRUE;
		} else {
			_data_->_tmp16_ = _data_->e;
			if (g_error_matches (_data_->_tmp16_, G_IO_ERROR, G_IO_ERROR_NOT_FOUND)) {
				_data_->_tmp17_ = _data_->self->priv->_file;
				_data_->_tmp18_ = files_file_get_uri (_data_->_tmp17_);
				_data_->_tmp19_ = _data_->_tmp18_;
				g_debug ("Directory.vala:405: Enclosing mount not found %s (may be remote share)", _data_->_tmp19_);
				{
					_data_->_tmp20_ = _data_->self->priv->_location;
					_data_->_tmp21_ = _data_->mount_op;
					_data_->_tmp22_ = _data_->self->priv->cancellable;
					_data_->_state_ = 2;
					g_file_mount_mountable (_data_->_tmp20_, G_MOUNT_MOUNT_NONE, (GMountOperation*) _data_->_tmp21_, _data_->_tmp22_, files_directory_mount_mountable_ready, _data_);
					return FALSE;
					_state_2:
					_data_->_tmp23_ = g_file_mount_mountable_finish (_data_->_tmp20_, _data_->_res_, &_data_->_inner_error0_);
					_data_->_tmp24_ = _data_->_tmp23_;
					_g_object_unref0 (_data_->_tmp24_);
					if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
						goto __catch1_g_error;
					}
					_data_->res = TRUE;
				}
				goto __finally1;
				__catch1_g_error:
				{
					_data_->e2 = _data_->_inner_error0_;
					_data_->_inner_error0_ = NULL;
					_data_->_tmp25_ = _data_->e2;
					_data_->_tmp26_ = _data_->_tmp25_->message;
					files_directory_set_last_error_message (_data_->self, _data_->_tmp26_);
					g_debug ("Directory.vala:412: Unable to mount mountable");
					_data_->res = FALSE;
					_g_error_free0 (_data_->e2);
				}
				__finally1:
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					_g_error_free0 (_data_->e);
					_g_object_unref0 (_data_->mount_op);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
					g_clear_error (&_data_->_inner_error0_);
					g_object_unref (_data_->_async_result);
					return FALSE;
				}
			} else {
				_data_->_tmp27_ = _data_->self->priv->_file;
				_data_->_tmp27_->is_connected = FALSE;
				_data_->_tmp28_ = _data_->self->priv->_file;
				_data_->_tmp28_->is_mounted = FALSE;
				g_debug ("Directory.vala:419: Setting mount null 1");
				_data_->_tmp29_ = _data_->self->priv->_file;
				_g_object_unref0 (_data_->_tmp29_->mount);
				_data_->_tmp29_->mount = NULL;
				_data_->_tmp30_ = _data_->e;
				_data_->_tmp31_ = _data_->_tmp30_->message;
				g_debug ("Directory.vala:421: Mount_mountable failed: %s", _data_->_tmp31_);
				_data_->_tmp33_ = _data_->e;
				if (g_error_matches (_data_->_tmp33_, G_IO_ERROR, G_IO_ERROR_PERMISSION_DENIED)) {
					_data_->_tmp32_ = TRUE;
				} else {
					_data_->_tmp34_ = _data_->e;
					_data_->_tmp32_ = g_error_matches (_data_->_tmp34_, G_IO_ERROR, G_IO_ERROR_FAILED_HANDLED);
				}
				if (_data_->_tmp32_) {
					_data_->self->permission_denied = TRUE;
				}
			}
		}
		_g_error_free0 (_data_->e);
	}
	__finally0:
	{
		files_directory_cancel_timeout (_data_->self, &_data_->self->priv->mount_timeout_id);
	}
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_g_object_unref0 (_data_->mount_op);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp36_ = _data_->self->priv->_file;
	_data_->_tmp37_ = _data_->_tmp36_->mount;
	if (_data_->_tmp37_ != NULL) {
		_data_->_tmp38_ = _data_->self->priv->_file;
		_data_->_tmp39_ = _data_->_tmp38_->mount;
		_data_->_tmp40_ = g_mount_get_name (_data_->_tmp39_);
		_g_free0 (_data_->_tmp35_);
		_data_->_tmp35_ = _data_->_tmp40_;
	} else {
		_data_->_tmp41_ = g_strdup ("null");
		_g_free0 (_data_->_tmp35_);
		_data_->_tmp35_ = _data_->_tmp41_;
	}
	_data_->_tmp42_ = bool_to_string (_data_->res);
	_data_->_tmp43_ = _data_->_tmp42_;
	g_debug ("Directory.vala:430: success %s; enclosing mount %s", _data_->_tmp43_, _data_->_tmp35_);
	_g_free0 (_data_->_tmp43_);
	_data_->result = _data_->res;
	_g_free0 (_data_->_tmp35_);
	_g_object_unref0 (_data_->mount_op);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
files_directory_check_network_data_free (gpointer _data)
{
	FilesDirectoryCheckNetworkData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (FilesDirectoryCheckNetworkData, _data_);
}

void
files_directory_check_network (FilesDirectory* self,
                               GAsyncReadyCallback _callback_,
                               gpointer _user_data_)
{
	FilesDirectoryCheckNetworkData* _data_;
	FilesDirectory* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (FilesDirectoryCheckNetworkData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, files_directory_check_network_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	files_directory_check_network_co (_data_);
}

gboolean
files_directory_check_network_finish (FilesDirectory* self,
                                      GAsyncResult* _res_)
{
	gboolean result;
	FilesDirectoryCheckNetworkData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	return result;
}

static void
files_directory_check_network_ready (GObject* source_object,
                                     GAsyncResult* _res_,
                                     gpointer _user_data_)
{
	FilesDirectoryCheckNetworkData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	files_directory_check_network_co (_data_);
}

static gboolean
files_directory_check_network_co (FilesDirectoryCheckNetworkData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	g_debug ("Directory.vala:436: check network");
	_data_->_tmp0_ = g_network_monitor_get_default ();
	_data_->net_mon = _data_->_tmp0_;
	_data_->_tmp1_ = _data_->net_mon;
	_data_->self->network_available = g_network_monitor_get_network_available (_data_->_tmp1_);
	_data_->success = FALSE;
	if (_data_->self->network_available) {
		_data_->_tmp2_ = _data_->self->priv->_file;
		if (!_data_->_tmp2_->is_mounted) {
			g_debug ("Directory.vala:444: Network is available");
			_data_->_tmp3_ = _data_->self->priv->_scheme;
			if (g_strcmp0 (_data_->_tmp3_, "smb") != 0) {
				{
					_data_->_tmp4_ = g_socket_client_new ();
					_data_->scl = _data_->_tmp4_;
					_data_->_tmp5_ = _data_->scl;
					g_socket_client_set_timeout (_data_->_tmp5_, (guint) FILES_DIRECTORY_CONNECT_SOCKET_TIMEOUT_SEC);
					_data_->_tmp6_ = _data_->scl;
					_data_->_tmp7_ = _data_->self->priv->_scheme;
					g_socket_client_set_tls (_data_->_tmp6_, files_file_utils_get_is_tls_for_protocol (_data_->_tmp7_));
					g_debug ("Directory.vala:451: Trying to connect to connectable");
					_data_->_tmp8_ = _data_->self->priv->_scheme;
					_data_->default_port = files_file_utils_get_default_port_for_protocol (_data_->_tmp8_);
					_data_->_tmp9_ = _data_->scl;
					_data_->_tmp10_ = _data_->self->priv->_file;
					_data_->_tmp11_ = files_file_get_uri (_data_->_tmp10_);
					_data_->_tmp12_ = _data_->_tmp11_;
					_data_->_tmp13_ = _data_->self->priv->cancellable;
					_data_->_state_ = 1;
					g_socket_client_connect_to_uri_async (_data_->_tmp9_, _data_->_tmp12_, _data_->default_port, _data_->_tmp13_, files_directory_check_network_ready, _data_);
					return FALSE;
					_state_1:
					_data_->_tmp14_ = g_socket_client_connect_to_uri_finish (_data_->_tmp9_, _data_->_res_, &_data_->_inner_error0_);
					_data_->sc = _data_->_tmp14_;
					if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
						_g_object_unref0 (_data_->scl);
						goto __catch0_g_error;
					}
					_data_->_tmp16_ = _data_->sc;
					if (_data_->_tmp16_ != NULL) {
						_data_->_tmp17_ = _data_->sc;
						_data_->_tmp15_ = g_socket_connection_is_connected (_data_->_tmp17_);
					} else {
						_data_->_tmp15_ = FALSE;
					}
					_data_->success = _data_->_tmp15_;
					_data_->_tmp19_ = _data_->sc;
					if (_data_->_tmp19_ == NULL) {
						_data_->_tmp18_ = "null";
					} else {
						_data_->_tmp21_ = _data_->sc;
						if (g_socket_connection_is_connected (_data_->_tmp21_)) {
							_data_->_tmp20_ = "connected";
						} else {
							_data_->_tmp20_ = "not connected";
						}
						_data_->_tmp18_ = _data_->_tmp20_;
					}
					g_debug ("Directory.vala:455: Socketclient is %s", _data_->_tmp18_);
					_g_object_unref0 (_data_->sc);
					_g_object_unref0 (_data_->scl);
				}
				goto __finally0;
				__catch0_g_error:
				{
					_data_->e = _data_->_inner_error0_;
					_data_->_inner_error0_ = NULL;
					_data_->_tmp22_ = _data_->e;
					_data_->_tmp23_ = _data_->_tmp22_->message;
					files_directory_set_last_error_message (_data_->self, _data_->_tmp23_);
					_data_->_tmp24_ = _data_->self->priv->_file;
					_data_->_tmp25_ = files_file_get_uri (_data_->_tmp24_);
					_data_->_tmp26_ = _data_->_tmp25_;
					_data_->_tmp27_ = _data_->e;
					_data_->_tmp28_ = _data_->_tmp27_->message;
					g_warning ("Directory.vala:460: Error: could not connect to connectable %s: %s", _data_->_tmp26_, _data_->_tmp28_);
					_data_->result = FALSE;
					_g_error_free0 (_data_->e);
					g_task_return_pointer (_data_->_async_result, _data_, NULL);
					if (_data_->_state_ != 0) {
						while (!g_task_get_completed (_data_->_async_result)) {
							g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
						}
					}
					g_object_unref (_data_->_async_result);
					return FALSE;
				}
				__finally0:
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
					g_clear_error (&_data_->_inner_error0_);
					g_object_unref (_data_->_async_result);
					return FALSE;
				}
			} else {
				_data_->success = TRUE;
			}
		} else {
			g_debug ("Directory.vala:467: File is already mounted - not reconnecting");
			_data_->success = TRUE;
		}
	} else {
		g_warning ("Directory.vala:471: No network available");
	}
	if (_data_->success) {
		_data_->_tmp29_ = "succeeded";
	} else {
		_data_->_tmp29_ = "failed";
	}
	_data_->_tmp30_ = _data_->self->priv->_file;
	_data_->_tmp31_ = files_file_get_uri (_data_->_tmp30_);
	_data_->_tmp32_ = _data_->_tmp31_;
	g_debug ("Directory.vala:475: Attempt to connect to %s %s", _data_->_tmp32_, _data_->_tmp29_);
	_data_->result = _data_->success;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
files_directory_make_ready_data_free (gpointer _data)
{
	FilesDirectoryMakeReadyData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (FilesDirectoryMakeReadyData, _data_);
}

static void
files_directory_make_ready (FilesDirectory* self,
                            gboolean ready,
                            FilesDirectoryFileLoadedFunc file_loaded_func,
                            gpointer file_loaded_func_target,
                            FilesDirectoryDoneLoadingFunc done_loading_func,
                            gpointer done_loading_func_target,
                            GAsyncReadyCallback _callback_,
                            gpointer _user_data_)
{
	FilesDirectoryMakeReadyData* _data_;
	FilesDirectory* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (FilesDirectoryMakeReadyData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, files_directory_make_ready_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_data_->ready = ready;
	_data_->file_loaded_func = file_loaded_func;
	_data_->file_loaded_func_target = file_loaded_func_target;
	_data_->done_loading_func = done_loading_func;
	_data_->done_loading_func_target = done_loading_func_target;
	files_directory_make_ready_co (_data_);
}

static void
files_directory_make_ready_finish (FilesDirectory* self,
                                   GAsyncResult* _res_)
{
	FilesDirectoryMakeReadyData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static void
_files_directory_directory_changed_g_file_monitor_changed (GFileMonitor* _sender,
                                                           GFile* file,
                                                           GFile* other_file,
                                                           GFileMonitorEvent event_type,
                                                           gpointer self)
{
	files_directory_directory_changed ((FilesDirectory*) self, file, other_file, event_type);
}

static void
files_directory_make_ready_ready (GObject* source_object,
                                  GAsyncResult* _res_,
                                  gpointer _user_data_)
{
	FilesDirectoryMakeReadyData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	files_directory_make_ready_co (_data_);
}

static gboolean
files_directory_make_ready_co (FilesDirectoryMakeReadyData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	g_debug ("Directory.vala:481: make ready");
	files_directory_set_can_load (_data_->self, _data_->ready);
	_data_->_tmp0_ = _data_->self->priv->_is_recent;
	if (_data_->_tmp0_) {
		_data_->_tmp1_ = files_preferences_get_default ();
		_data_->_tmp2_ = _data_->_tmp1_;
		_data_->_tmp3_ = files_preferences_get_remember_history (_data_->_tmp2_);
		_data_->_tmp4_ = _data_->_tmp3_;
		_data_->_tmp5_ = !_data_->_tmp4_;
		_g_object_unref0 (_data_->_tmp2_);
		if (_data_->_tmp5_) {
			files_directory_set_state (_data_->self, FILES_DIRECTORY_STATE_NOT_LOADED);
			files_directory_set_can_load (_data_->self, FALSE);
		}
	}
	_data_->_tmp6_ = _data_->self->priv->_can_load;
	if (!_data_->_tmp6_) {
		_data_->_tmp7_ = _data_->self->priv->_file;
		_data_->_tmp8_ = files_file_get_uri (_data_->_tmp7_);
		_data_->_tmp9_ = _data_->_tmp8_;
		_data_->_tmp10_ = _data_->self->priv->_file;
		_data_->_tmp11_ = bool_to_string (_data_->_tmp10_->is_connected);
		_data_->_tmp12_ = _data_->_tmp11_;
		_data_->_tmp13_ = _data_->self->priv->_file;
		_data_->_tmp14_ = bool_to_string (_data_->_tmp13_->is_mounted);
		_data_->_tmp15_ = _data_->_tmp14_;
		_data_->_tmp16_ = _data_->self->priv->_file;
		_data_->_tmp17_ = files_file_get_exists (_data_->_tmp16_);
		_data_->_tmp18_ = _data_->_tmp17_;
		_data_->_tmp19_ = bool_to_string (_data_->_tmp18_);
		_data_->_tmp20_ = _data_->_tmp19_;
		g_debug ("Directory.vala:492: Cannot load %s.  Connected %s, Mounted %s, Exists " \
"%s", _data_->_tmp9_, _data_->_tmp12_, _data_->_tmp15_, _data_->_tmp20_);
		_g_free0 (_data_->_tmp20_);
		_g_free0 (_data_->_tmp15_);
		_g_free0 (_data_->_tmp12_);
		_data_->_tmp21_ = files_directory_directory_cache;
		_data_->_tmp22_ = _data_->self->priv->_creation_key;
		g_hash_table_remove (_data_->_tmp21_, _data_->_tmp22_);
		_data_->self->priv->is_ready = FALSE;
		files_directory_after_loading (_data_->self, _data_->done_loading_func, _data_->done_loading_func_target);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	if (!_data_->self->priv->is_ready) {
		_data_->self->priv->is_ready = TRUE;
		{
			_data_->_tmp23_ = files_directory_directory_cache;
			g_rec_mutex_lock (&__lock_files_directory_files_directory_directory_cache);
			{
				_data_->_tmp24_ = _data_->self->priv->_creation_key;
				_data_->_tmp25_ = _data_->self->priv->_location;
				if (!g_file_equal (_data_->_tmp24_, _data_->_tmp25_)) {
					_data_->_tmp26_ = _data_->self->priv->_creation_key;
					_data_->_tmp27_ = g_file_get_uri (_data_->_tmp26_);
					_data_->_tmp28_ = _data_->_tmp27_;
					_data_->_tmp29_ = _data_->self->priv->_location;
					_data_->_tmp30_ = g_file_get_uri (_data_->_tmp29_);
					_data_->_tmp31_ = _data_->_tmp30_;
					g_warning ("Directory.vala:509: creation key %s differs from final location %s", _data_->_tmp28_, _data_->_tmp31_);
					_g_free0 (_data_->_tmp31_);
					_g_free0 (_data_->_tmp28_);
					_data_->_tmp32_ = files_directory_directory_cache;
					_data_->_tmp33_ = _data_->self->priv->_creation_key;
					g_hash_table_remove (_data_->_tmp32_, _data_->_tmp33_);
				}
				_data_->_tmp34_ = files_directory_directory_cache;
				_data_->_tmp35_ = _data_->self->priv->_location;
				_data_->_tmp36_ = g_hash_table_lookup (_data_->_tmp34_, _data_->_tmp35_);
				if (((FilesDirectory*) _data_->_tmp36_) == NULL) {
					_data_->_tmp37_ = files_directory_directory_cache;
					_data_->_tmp38_ = _data_->self->priv->_location;
					_data_->_tmp39_ = _g_object_ref0 (_data_->self);
					g_hash_table_insert (_data_->_tmp37_, _data_->_tmp38_, _data_->_tmp39_);
					g_object_add_toggle_ref ((GObject*) _data_->self, (GToggleNotify) files_directory_toggle_ref_notify, NULL);
					g_object_unref ((GObject*) _data_->self);
				}
			}
			__finally0:
			{
				_data_->_tmp40_ = files_directory_directory_cache;
				g_rec_mutex_unlock (&__lock_files_directory_files_directory_directory_cache);
			}
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
				g_clear_error (&_data_->_inner_error0_);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
		}
	}
	_data_->_tmp41_ = _data_->self->priv->_file;
	_data_->_tmp42_ = _data_->_tmp41_->mount;
	if (_data_->_tmp42_ != NULL) {
		g_debug ("Directory.vala:524: Directory has mount point");
		_data_->_tmp43_ = _data_->self->priv->_file;
		_data_->_tmp44_ = _data_->_tmp43_->mount;
		_data_->_tmp45_ = marlin_file_operations_get_trash_dirs_for_mount (_data_->_tmp44_);
		_data_->trash_dirs = _data_->_tmp45_;
		_data_->_tmp46_ = _data_->trash_dirs;
		files_directory_set_has_trash_dirs (_data_->self, _data_->_tmp46_ != NULL);
		(_data_->trash_dirs == NULL) ? NULL : (_data_->trash_dirs = (_g_list_free__g_object_unref0_ (_data_->trash_dirs), NULL));
	} else {
		_data_->_tmp47_ = _data_->self->priv->_is_local;
		files_directory_set_has_trash_dirs (_data_->self, _data_->_tmp47_);
	}
	_data_->_tmp49_ = _data_->self->priv->_has_trash_dirs;
	if (_data_->_tmp49_) {
		_data_->_tmp48_ = getuid () != ((uid_t) 0);
	} else {
		_data_->_tmp48_ = FALSE;
	}
	files_directory_set_has_trash_dirs (_data_->self, _data_->_tmp48_);
	files_directory_set_confirm_trash (_data_->self);
	if (_data_->file_loaded_func == NULL) {
		_data_->_tmp51_ = _data_->self->priv->_is_local;
		_data_->_tmp50_ = _data_->_tmp51_;
	} else {
		_data_->_tmp50_ = FALSE;
	}
	if (_data_->_tmp50_) {
		{
			_data_->_tmp53_ = _data_->self->priv->_location;
			_data_->_tmp54_ = g_file_monitor_directory (_data_->_tmp53_, 0, NULL, &_data_->_inner_error0_);
			_data_->_tmp52_ = _data_->_tmp54_;
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				if (_data_->_inner_error0_->domain == G_IO_ERROR) {
					goto __catch1_g_io_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
				g_clear_error (&_data_->_inner_error0_);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			_data_->_tmp55_ = _data_->_tmp52_;
			_data_->_tmp52_ = NULL;
			_g_object_unref0 (_data_->self->priv->monitor);
			_data_->self->priv->monitor = _data_->_tmp55_;
			_data_->_tmp56_ = _data_->self->priv->monitor;
			g_object_set (_data_->_tmp56_, "rate-limit", 100, NULL);
			_data_->_tmp57_ = _data_->self->priv->monitor;
			g_signal_connect_object (_data_->_tmp57_, "changed", (GCallback) _files_directory_directory_changed_g_file_monitor_changed, _data_->self, 0);
			_g_object_unref0 (_data_->_tmp52_);
		}
		goto __finally1;
		__catch1_g_io_error:
		{
			_data_->e = _data_->_inner_error0_;
			_data_->_inner_error0_ = NULL;
			_data_->_tmp58_ = _data_->e;
			_data_->_tmp59_ = _data_->_tmp58_->message;
			files_directory_set_last_error_message (_data_->self, _data_->_tmp59_);
			_data_->_tmp60_ = _data_->e;
			if (!g_error_matches (_data_->_tmp60_, G_IO_ERROR, G_IO_ERROR_NOT_MOUNTED)) {
				_data_->_tmp61_ = _data_->e;
				_data_->_tmp62_ = _data_->_tmp61_->message;
				_data_->_tmp63_ = _data_->self->priv->_file;
				_data_->_tmp64_ = files_file_get_uri (_data_->_tmp63_);
				_data_->_tmp65_ = _data_->_tmp64_;
				g_debug ("Directory.vala:545: directory monitor failed: %s %s", _data_->_tmp62_, _data_->_tmp65_);
			}
			_g_error_free0 (_data_->e);
		}
		__finally1:
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->_tmp66_ = _data_->self->priv->_is_trash;
	if (_data_->_tmp66_) {
		files_directory_connect_volume_monitor_signals (_data_->self);
	}
	_data_->_state_ = 1;
	files_directory_list_directory_async (_data_->self, _data_->file_loaded_func, _data_->file_loaded_func_target, _data_->done_loading_func, _data_->done_loading_func_target, files_directory_make_ready_ready, _data_);
	return FALSE;
	_state_1:
	files_directory_list_directory_finish (_data_->self, _data_->_res_);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
files_directory_set_confirm_trash (FilesDirectory* self)
{
	gboolean to_confirm = FALSE;
	gboolean _tmp0_;
	FilesPreferences* _tmp10_;
	FilesPreferences* _tmp11_;
	g_return_if_fail (self != NULL);
	to_confirm = TRUE;
	_tmp0_ = self->priv->_is_trash;
	if (_tmp0_) {
		GList* mounts = NULL;
		GVolumeMonitor* _tmp1_;
		GVolumeMonitor* _tmp2_;
		GList* _tmp3_;
		GList* _tmp4_;
		GList* _tmp5_;
		to_confirm = FALSE;
		_tmp1_ = g_volume_monitor_get ();
		_tmp2_ = _tmp1_;
		_tmp3_ = g_volume_monitor_get_mounts (_tmp2_);
		_tmp4_ = _tmp3_;
		_g_object_unref0 (_tmp2_);
		mounts = _tmp4_;
		_tmp5_ = mounts;
		if (_tmp5_ != NULL) {
			GList* _tmp6_;
			_tmp6_ = mounts;
			{
				GList* m_collection = NULL;
				GList* m_it = NULL;
				m_collection = _tmp6_;
				for (m_it = m_collection; m_it != NULL; m_it = m_it->next) {
					GMount* m = NULL;
					m = (GMount*) m_it->data;
					{
						gboolean _tmp7_ = FALSE;
						GMount* _tmp8_;
						_tmp8_ = m;
						if (g_mount_can_eject (_tmp8_)) {
							GMount* _tmp9_;
							_tmp9_ = m;
							_tmp7_ = marlin_file_operations_has_trash_files (_tmp9_);
						} else {
							_tmp7_ = FALSE;
						}
						to_confirm |= _tmp7_;
					}
				}
			}
		}
		(mounts == NULL) ? NULL : (mounts = (_g_list_free__g_object_unref0_ (mounts), NULL));
	}
	_tmp10_ = files_preferences_get_default ();
	_tmp11_ = _tmp10_;
	files_preferences_set_confirm_trash (_tmp11_, to_confirm);
	_g_object_unref0 (_tmp11_);
}

static void
_files_directory_on_mount_changed_g_volume_monitor_mount_changed (GVolumeMonitor* _sender,
                                                                  GMount* mount,
                                                                  gpointer self)
{
	files_directory_on_mount_changed ((FilesDirectory*) self, _sender, mount);
}

static void
_files_directory_on_mount_changed_g_volume_monitor_mount_added (GVolumeMonitor* _sender,
                                                                GMount* mount,
                                                                gpointer self)
{
	files_directory_on_mount_changed ((FilesDirectory*) self, _sender, mount);
}

static void
files_directory_connect_volume_monitor_signals (FilesDirectory* self)
{
	GVolumeMonitor* vm = NULL;
	GVolumeMonitor* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_volume_monitor_get ();
	vm = _tmp0_;
	g_signal_connect_object (vm, "mount-changed", (GCallback) _files_directory_on_mount_changed_g_volume_monitor_mount_changed, self, 0);
	g_signal_connect_object (vm, "mount-added", (GCallback) _files_directory_on_mount_changed_g_volume_monitor_mount_added, self, 0);
	_g_object_unref0 (vm);
}

static void
files_directory_disconnect_volume_monitor_signals (FilesDirectory* self)
{
	GVolumeMonitor* vm = NULL;
	GVolumeMonitor* _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_volume_monitor_get ();
	vm = _tmp0_;
	g_signal_parse_name ("mount-changed", g_volume_monitor_get_type (), &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (vm, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _files_directory_on_mount_changed_g_volume_monitor_mount_changed, self);
	g_signal_parse_name ("mount-added", g_volume_monitor_get_type (), &_tmp2_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (vm, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _files_directory_on_mount_changed_g_volume_monitor_mount_added, self);
	_g_object_unref0 (vm);
}

static void
files_directory_on_mount_changed (FilesDirectory* self,
                                  GVolumeMonitor* vm,
                                  GMount* mount)
{
	FilesDirectoryState _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (vm != NULL);
	g_return_if_fail (mount != NULL);
	_tmp0_ = self->priv->_state;
	if (_tmp0_ == FILES_DIRECTORY_STATE_LOADED) {
		g_signal_emit (self, files_directory_signals[FILES_DIRECTORY_NEED_RELOAD_SIGNAL], 0, TRUE);
	}
}

static void
files_directory_toggle_ref_notify (void* data,
                                   GObject* object,
                                   gboolean is_last)
{
	g_return_if_fail (object != NULL);
	if (is_last) {
		FilesDirectory* dir = NULL;
		FilesDirectory* _tmp0_;
		FilesDirectory* _tmp1_;
		FilesDirectory* _tmp2_;
		_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (object, FILES_TYPE_DIRECTORY, FilesDirectory));
		dir = _tmp0_;
		_tmp1_ = dir;
		g_object_remove_toggle_ref ((GObject*) _tmp1_, (GToggleNotify) files_directory_toggle_ref_notify, NULL);
		_tmp2_ = dir;
		if (!_tmp2_->priv->removed_from_cache) {
			FilesDirectory* _tmp3_;
			_tmp3_ = dir;
			files_directory_remove_dir_from_cache (_tmp3_);
		}
		_g_object_unref0 (dir);
	}
}

void
files_directory_cancel (FilesDirectory* self)
{
	GCancellable* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->cancellable;
	g_cancellable_cancel (_tmp0_);
	files_directory_cancel_timeouts (self);
}

void
files_directory_reload (FilesDirectory* self)
{
	FilesDirectoryState _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	FilesDirectoryState _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_state;
	_tmp1_ = g_enum_to_string (FILES_DIRECTORY_TYPE_STATE, _tmp0_);
	g_debug ("Directory.vala:607: Reload - state is %s", _tmp1_);
	_g_free0 (_tmp1_);
	_tmp3_ = self->priv->_state;
	if (_tmp3_ == FILES_DIRECTORY_STATE_TIMED_OUT) {
		FilesFile* _tmp4_;
		_tmp4_ = self->priv->_file;
		_tmp2_ = _tmp4_->is_mounted;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		GCancellable* _tmp5_;
		GCancellable* _tmp6_;
		FilesFile* _tmp7_;
		GFile* _tmp8_;
		GFile* _tmp9_;
		GCancellable* _tmp10_;
		FilesFile* _tmp11_;
		FilesFile* _tmp12_;
		g_debug ("Directory.vala:609: Unmounting because of timeout");
		_tmp5_ = self->priv->cancellable;
		g_cancellable_cancel (_tmp5_);
		_tmp6_ = g_cancellable_new ();
		_g_object_unref0 (self->priv->cancellable);
		self->priv->cancellable = _tmp6_;
		_tmp7_ = self->priv->_file;
		_tmp8_ = files_file_get_location (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = self->priv->cancellable;
		g_file_unmount_mountable_with_operation (_tmp9_, G_MOUNT_UNMOUNT_FORCE, NULL, _tmp10_, NULL, NULL);
		_tmp11_ = self->priv->_file;
		_g_object_unref0 (_tmp11_->mount);
		_tmp11_->mount = NULL;
		_tmp12_ = self->priv->_file;
		_tmp12_->is_mounted = FALSE;
	}
	files_directory_clear_directory_info (self);
	files_directory_init (self, NULL, NULL, NULL, NULL);
}

/** Called in preparation for a reload **/
static void
files_directory_clear_directory_info (FilesDirectory* self)
{
	FilesDirectoryState _tmp0_;
	GHashTable* _tmp1_;
	GFileMonitor* _tmp2_;
	gboolean _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_state;
	if (_tmp0_ == FILES_DIRECTORY_STATE_LOADING) {
		return;
	}
	files_directory_cancel (self);
	_tmp1_ = self->priv->file_hash;
	g_hash_table_remove_all (_tmp1_);
	_g_object_unref0 (self->priv->monitor);
	self->priv->monitor = NULL;
	(self->priv->sorted_dirs == NULL) ? NULL : (self->priv->sorted_dirs = (g_list_free (self->priv->sorted_dirs), NULL));
	self->priv->sorted_dirs = NULL;
	files_directory_set_displayed_files_count (self, (guint) 0);
	files_directory_set_can_load (self, FALSE);
	files_directory_set_state (self, FILES_DIRECTORY_STATE_NOT_LOADED);
	files_directory_set_loaded_from_cache (self, FALSE);
	_tmp2_ = self->priv->monitor;
	if (_tmp2_ != NULL) {
		GFileMonitor* _tmp3_;
		guint _tmp4_;
		_tmp3_ = self->priv->monitor;
		g_signal_parse_name ("changed", g_file_monitor_get_type (), &_tmp4_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp3_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp4_, 0, NULL, (GCallback) _files_directory_directory_changed_g_file_monitor_changed, self);
	}
	_tmp5_ = self->priv->_is_trash;
	if (_tmp5_) {
		files_directory_disconnect_volume_monitor_signals (self);
	}
}

static void
files_directory_list_cached_files (FilesDirectory* self,
                                   FilesDirectoryFileLoadedFunc file_loaded_func,
                                   gpointer file_loaded_func_target,
                                   FilesDirectoryDoneLoadingFunc done_loading_func,
                                   gpointer done_loading_func_target)
{
	FilesDirectoryState _tmp0_;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_;
	gboolean show_hidden = FALSE;
	GHashTable* _tmp9_;
	GList* _tmp10_;
	g_return_if_fail (self != NULL);
	g_debug ("Directory.vala:649: list cached files");
	_tmp0_ = self->priv->_state;
	if (_tmp0_ != FILES_DIRECTORY_STATE_LOADED) {
		FilesDirectoryState _tmp1_;
		gchar* _tmp2_;
		_tmp1_ = self->priv->_state;
		_tmp2_ = g_enum_to_string (FILES_DIRECTORY_TYPE_STATE, _tmp1_);
		g_critical ("Directory.vala:651: list cached files called in %s state - not expecte" \
"d to happen", _tmp2_);
		_g_free0 (_tmp2_);
		return;
	}
	files_directory_set_state (self, FILES_DIRECTORY_STATE_LOADING);
	files_directory_set_displayed_files_count (self, (guint) 0);
	_tmp4_ = self->priv->_is_trash;
	if (_tmp4_) {
		_tmp3_ = TRUE;
	} else {
		FilesPreferences* _tmp5_;
		FilesPreferences* _tmp6_;
		gboolean _tmp7_;
		gboolean _tmp8_;
		_tmp5_ = files_preferences_get_default ();
		_tmp6_ = _tmp5_;
		_tmp7_ = files_preferences_get_show_hidden_files (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp3_ = _tmp8_;
		_g_object_unref0 (_tmp6_);
	}
	show_hidden = _tmp3_;
	_tmp9_ = self->priv->file_hash;
	_tmp10_ = g_hash_table_get_values (_tmp9_);
	{
		GList* gof_collection = NULL;
		GList* gof_it = NULL;
		gof_collection = _tmp10_;
		for (gof_it = gof_collection; gof_it != NULL; gof_it = gof_it->next) {
			FilesFile* gof = NULL;
			gof = (FilesFile*) gof_it->data;
			{
				FilesFile* _tmp11_;
				_tmp11_ = gof;
				if (_tmp11_ != NULL) {
					FilesFile* _tmp12_;
					_tmp12_ = gof;
					files_directory_after_load_file (self, _tmp12_, show_hidden, file_loaded_func, file_loaded_func_target);
				}
			}
		}
		(gof_collection == NULL) ? NULL : (gof_collection = (g_list_free (gof_collection), NULL));
	}
	files_directory_set_state (self, FILES_DIRECTORY_STATE_LOADED);
	files_directory_set_loaded_from_cache (self, TRUE);
	files_directory_after_loading (self, done_loading_func, done_loading_func_target);
}

static void
files_directory_list_directory_async_data_free (gpointer _data)
{
	FilesDirectoryListDirectoryAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (FilesDirectoryListDirectoryAsyncData, _data_);
}

static void
files_directory_list_directory_async (FilesDirectory* self,
                                      FilesDirectoryFileLoadedFunc file_loaded_func,
                                      gpointer file_loaded_func_target,
                                      FilesDirectoryDoneLoadingFunc done_loading_func,
                                      gpointer done_loading_func_target,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_)
{
	FilesDirectoryListDirectoryAsyncData* _data_;
	FilesDirectory* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (FilesDirectoryListDirectoryAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, files_directory_list_directory_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_data_->file_loaded_func = file_loaded_func;
	_data_->file_loaded_func_target = file_loaded_func_target;
	_data_->done_loading_func = done_loading_func;
	_data_->done_loading_func_target = done_loading_func_target;
	files_directory_list_directory_async_co (_data_);
}

static void
files_directory_list_directory_finish (FilesDirectory* self,
                                       GAsyncResult* _res_)
{
	FilesDirectoryListDirectoryAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
files_directory_list_directory_async_ready (GObject* source_object,
                                            GAsyncResult* _res_,
                                            gpointer _user_data_)
{
	FilesDirectoryListDirectoryAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	files_directory_list_directory_async_co (_data_);
}

static gboolean
_____lambda18_ (FilesDirectory* self)
{
	GCancellable* _tmp0_;
	gboolean result;
	g_warning ("Directory.vala:710: Load timeout expired");
	files_directory_set_state (self, FILES_DIRECTORY_STATE_TIMED_OUT);
	self->priv->load_timeout_id = (guint) 0;
	_tmp0_ = self->priv->cancellable;
	g_cancellable_cancel (_tmp0_);
	self->priv->load_timeout_id = (guint) 0;
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
______lambda18__gsource_func (gpointer self)
{
	gboolean result;
	result = _____lambda18_ ((FilesDirectory*) self);
	return result;
}

static gboolean
files_directory_list_directory_async_co (FilesDirectoryListDirectoryAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	g_debug ("Directory.vala:671: list directory async");
	if (!_data_->self->priv->is_ready) {
		_data_->_tmp0_ = TRUE;
	} else {
		_data_->_tmp1_ = _data_->self->priv->file_hash;
		_data_->_tmp0_ = g_hash_table_size (_data_->_tmp1_) > ((guint) 0);
	}
	if (_data_->_tmp0_) {
		g_critical ("Directory.vala:674: (Re)load directory called when not cleared");
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp2_ = _data_->self->priv->_can_load;
	if (!_data_->_tmp2_) {
		g_critical ("Directory.vala:679: load called when cannot load - not expected to hap" \
"pen");
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp3_ = _data_->self->priv->_state;
	if (_data_->_tmp3_ == FILES_DIRECTORY_STATE_LOADED) {
		g_critical ("Directory.vala:684: load called when already loaded - not expected to " \
"happen");
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	if (_data_->self->priv->load_timeout_id > ((guint) 0)) {
		g_critical ("Directory.vala:688: load called when timeout already running - not exp" \
"ected to happen");
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp4_ = g_cancellable_new ();
	_g_object_unref0 (_data_->self->priv->cancellable);
	_data_->self->priv->cancellable = _data_->_tmp4_;
	_data_->self->permission_denied = FALSE;
	files_directory_set_can_load (_data_->self, TRUE);
	files_directory_set_displayed_files_count (_data_->self, (guint) 0);
	files_directory_set_state (_data_->self, FILES_DIRECTORY_STATE_LOADING);
	_data_->_tmp6_ = _data_->self->priv->_is_trash;
	if (_data_->_tmp6_) {
		_data_->_tmp5_ = TRUE;
	} else {
		_data_->_tmp7_ = files_preferences_get_default ();
		_data_->_tmp8_ = _data_->_tmp7_;
		_data_->_tmp9_ = files_preferences_get_show_hidden_files (_data_->_tmp8_);
		_data_->_tmp10_ = _data_->_tmp9_;
		_data_->_tmp5_ = _data_->_tmp10_;
		_g_object_unref0 (_data_->_tmp8_);
	}
	_data_->show_hidden = _data_->_tmp5_;
	{
		_data_->_tmp11_ = _data_->self->priv->_location;
		_data_->_tmp12_ = files_directory_get_gio_attrs (_data_->self);
		_data_->_tmp13_ = _data_->_tmp12_;
		_data_->_tmp14_ = _data_->self->priv->cancellable;
		_data_->_state_ = 1;
		g_file_enumerate_children_async (_data_->_tmp11_, _data_->_tmp13_, 0, G_PRIORITY_HIGH, _data_->_tmp14_, files_directory_list_directory_async_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp15_ = g_file_enumerate_children_finish (_data_->_tmp11_, _data_->_res_, &_data_->_inner_error0_);
		_data_->e = _data_->_tmp15_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp16_ = _data_->self->priv->_location;
		_data_->_tmp17_ = g_file_get_uri (_data_->_tmp16_);
		_data_->_tmp18_ = _data_->_tmp17_;
		g_debug ("Directory.vala:701: Obtained file enumerator for location %s", _data_->_tmp18_);
		_g_free0 (_data_->_tmp18_);
		while (TRUE) {
			_data_->_tmp19_ = _data_->self->priv->cancellable;
			if (!(!g_cancellable_is_cancelled (_data_->_tmp19_))) {
				break;
			}
			{
				_data_->self->priv->load_timeout_id = g_timeout_add_seconds_full (G_PRIORITY_LOW, (guint) FILES_DIRECTORY_ENUMERATE_TIMEOUT_SEC, ______lambda18__gsource_func, g_object_ref (_data_->self), g_object_unref);
				_data_->_tmp20_ = _data_->e;
				_data_->_tmp21_ = _data_->self->priv->cancellable;
				_data_->_state_ = 2;
				g_file_enumerator_next_files_async (_data_->_tmp20_, 1000, (gint) G_FILE_QUERY_INFO_NOFOLLOW_SYMLINKS, _data_->_tmp21_, files_directory_list_directory_async_ready, _data_);
				return FALSE;
				_state_2:
				_data_->_tmp22_ = g_file_enumerator_next_files_finish (_data_->_tmp20_, _data_->_res_, &_data_->_inner_error0_);
				_data_->files = _data_->_tmp22_;
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					goto __catch1_g_error;
				}
				files_directory_cancel_timeout (_data_->self, &_data_->self->priv->load_timeout_id);
				_data_->_tmp23_ = _data_->files;
				if (_data_->_tmp23_ == NULL) {
					(_data_->files == NULL) ? NULL : (_data_->files = (_g_list_free__g_object_unref0_ (_data_->files), NULL));
					break;
				} else {
					_data_->_tmp24_ = _data_->files;
					{
						_data_->file_info_collection = _data_->_tmp24_;
						for (_data_->file_info_it = _data_->file_info_collection; _data_->file_info_it != NULL; _data_->file_info_it = _data_->file_info_it->next) {
							_data_->file_info = (GFileInfo*) _data_->file_info_it->data;
							{
								_data_->_tmp25_ = _data_->self->priv->_location;
								_data_->_tmp26_ = _data_->file_info;
								_data_->_tmp27_ = g_file_info_get_name (_data_->_tmp26_);
								_data_->_tmp28_ = g_file_get_child (_data_->_tmp25_, _data_->_tmp27_);
								_g_object_unref0 (_data_->loc);
								_data_->loc = _data_->_tmp28_;
								_data_->_tmp29_ = _data_->loc;
								_vala_assert (_data_->_tmp29_ != NULL, "loc != null");
								_data_->_tmp30_ = _data_->loc;
								_data_->_tmp31_ = files_file_cache_lookup (_data_->_tmp30_);
								_g_object_unref0 (_data_->gof);
								_data_->gof = _data_->_tmp31_;
								_data_->_tmp32_ = _data_->gof;
								if (_data_->_tmp32_ == NULL) {
									_data_->_tmp33_ = _data_->loc;
									_data_->_tmp34_ = _data_->self->priv->_location;
									_data_->_tmp35_ = files_file_new (_data_->_tmp33_, _data_->_tmp34_);
									_g_object_unref0 (_data_->gof);
									_data_->gof = _data_->_tmp35_;
								}
								_data_->_tmp36_ = _data_->gof;
								_data_->_tmp37_ = _data_->file_info;
								_data_->_tmp38_ = _g_object_ref0 (_data_->_tmp37_);
								_g_object_unref0 (_data_->_tmp36_->info);
								_data_->_tmp36_->info = _data_->_tmp38_;
								_data_->_tmp39_ = _data_->gof;
								files_file_update (_data_->_tmp39_);
								_data_->_tmp40_ = _data_->self->priv->file_hash;
								_data_->_tmp41_ = _data_->gof;
								_data_->_tmp42_ = files_file_get_location (_data_->_tmp41_);
								_data_->_tmp43_ = _data_->_tmp42_;
								_data_->_tmp44_ = _g_object_ref0 (_data_->_tmp43_);
								_data_->_tmp45_ = _data_->gof;
								_data_->_tmp46_ = _g_object_ref0 (_data_->_tmp45_);
								g_hash_table_insert (_data_->_tmp40_, _data_->_tmp44_, _data_->_tmp46_);
								_data_->_tmp47_ = _data_->gof;
								files_directory_after_load_file (_data_->self, _data_->_tmp47_, _data_->show_hidden, _data_->file_loaded_func, _data_->file_loaded_func_target);
							}
						}
					}
				}
				(_data_->files == NULL) ? NULL : (_data_->files = (_g_list_free__g_object_unref0_ (_data_->files), NULL));
			}
			goto __finally1;
			__catch1_g_error:
			{
				_data_->_vala1_e = _data_->_inner_error0_;
				_data_->_inner_error0_ = NULL;
				_data_->_tmp48_ = _data_->self->priv->_state;
				if (!(_data_->_tmp48_ == FILES_DIRECTORY_STATE_TIMED_OUT)) {
					_data_->_tmp49_ = _data_->_vala1_e;
					_data_->_tmp50_ = _data_->_tmp49_->message;
					files_directory_set_last_error_message (_data_->self, _data_->_tmp50_);
				} else {
					files_directory_set_last_error_message (_data_->self, _ ("Server did not respond within time limit"));
				}
				_data_->_tmp51_ = _data_->_vala1_e;
				_data_->_tmp52_ = _data_->_tmp51_->message;
				g_warning ("Directory.vala:746: Error reported by next_files_async: %s", _data_->_tmp52_);
				_g_error_free0 (_data_->_vala1_e);
			}
			__finally1:
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				_g_object_unref0 (_data_->loc);
				_g_object_unref0 (_data_->gof);
				_g_object_unref0 (_data_->e);
				goto __catch0_g_error;
			}
		}
		_data_->_tmp53_ = _data_->self->priv->cancellable;
		if (!g_cancellable_is_cancelled (_data_->_tmp53_)) {
			files_directory_set_state (_data_->self, FILES_DIRECTORY_STATE_LOADED);
		}
		_g_object_unref0 (_data_->loc);
		_g_object_unref0 (_data_->gof);
		_g_object_unref0 (_data_->e);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->err = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp54_ = _data_->self->priv->_last_error_message;
		_data_->_tmp55_ = _data_->err;
		_data_->_tmp56_ = _data_->_tmp55_->message;
		_data_->_tmp57_ = _data_->self->priv->_file;
		_data_->_tmp58_ = files_file_get_uri (_data_->_tmp57_);
		_data_->_tmp59_ = _data_->_tmp58_;
		g_warning ("Directory.vala:754: Listing directory error: %s, %s %s", _data_->_tmp54_, _data_->_tmp56_, _data_->_tmp59_);
		files_directory_set_can_load (_data_->self, FALSE);
		_data_->_tmp61_ = _data_->err;
		if (g_error_matches (_data_->_tmp61_, G_IO_ERROR, G_IO_ERROR_NOT_FOUND)) {
			_data_->_tmp60_ = TRUE;
		} else {
			_data_->_tmp62_ = _data_->err;
			_data_->_tmp60_ = g_error_matches (_data_->_tmp62_, G_IO_ERROR, G_IO_ERROR_NOT_DIRECTORY);
		}
		if (_data_->_tmp60_) {
			_data_->_tmp63_ = _data_->self->priv->_file;
			files_file_set_exists (_data_->_tmp63_, FALSE);
		} else {
			_data_->_tmp64_ = _data_->err;
			if (g_error_matches (_data_->_tmp64_, G_IO_ERROR, G_IO_ERROR_PERMISSION_DENIED)) {
				_data_->self->permission_denied = TRUE;
			} else {
				_data_->_tmp65_ = _data_->err;
				if (g_error_matches (_data_->_tmp65_, G_IO_ERROR, G_IO_ERROR_NOT_MOUNTED)) {
					_data_->_tmp66_ = _data_->self->priv->_file;
					_g_object_unref0 (_data_->_tmp66_->mount);
					_data_->_tmp66_->mount = NULL;
					_data_->_tmp67_ = _data_->self->priv->_file;
					_data_->_tmp67_->is_mounted = FALSE;
				}
			}
		}
		_g_error_free0 (_data_->err);
	}
	__finally0:
	{
		files_directory_cancel_timeout (_data_->self, &_data_->self->priv->load_timeout_id);
		files_directory_set_loaded_from_cache (_data_->self, FALSE);
		files_directory_after_loading (_data_->self, _data_->done_loading_func, _data_->done_loading_func_target);
	}
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
files_directory_after_load_file (FilesDirectory* self,
                                 FilesFile* gof,
                                 gboolean show_hidden,
                                 FilesDirectoryFileLoadedFunc file_loaded_func,
                                 gpointer file_loaded_func_target)
{
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (gof != NULL);
	if (show_hidden) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp1_ = FALSE;
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = files_file_get_is_hidden (gof);
		_tmp3_ = _tmp2_;
		if (_tmp3_) {
			_tmp1_ = TRUE;
		} else {
			GFileInfo* _tmp4_;
			_tmp4_ = gof->info;
			_tmp1_ = g_file_info_get_is_hidden (_tmp4_);
		}
		_tmp0_ = !_tmp1_;
	}
	if (_tmp0_) {
		guint _tmp5_;
		_tmp5_ = self->priv->_displayed_files_count;
		files_directory_set_displayed_files_count (self, _tmp5_ + 1);
		if (file_loaded_func == NULL) {
			g_signal_emit (self, files_directory_signals[FILES_DIRECTORY_FILE_LOADED_SIGNAL], 0, gof);
		} else {
			file_loaded_func (gof, file_loaded_func_target);
		}
	}
}

static void
files_directory_after_loading (FilesDirectory* self,
                               FilesDirectoryDoneLoadingFunc done_loading_func,
                               gpointer done_loading_func_target)
{
	FilesDirectoryState _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	FilesDirectoryState _tmp3_;
	FilesDirectoryState _tmp5_;
	FilesFile* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_state;
	_tmp1_ = g_enum_to_string (FILES_DIRECTORY_TYPE_STATE, _tmp0_);
	g_debug ("Directory.vala:785: after loading state is %s", _tmp1_);
	_g_free0 (_tmp1_);
	_tmp3_ = self->priv->_state;
	if (_tmp3_ == FILES_DIRECTORY_STATE_LOADING) {
		_tmp2_ = TRUE;
	} else {
		FilesDirectoryState _tmp4_;
		_tmp4_ = self->priv->_state;
		_tmp2_ = _tmp4_ == FILES_DIRECTORY_STATE_TIMED_OUT;
	}
	if (_tmp2_) {
		files_directory_set_state (self, FILES_DIRECTORY_STATE_TIMED_OUT);
		files_directory_set_can_load (self, FALSE);
	}
	_tmp5_ = self->priv->_state;
	if (_tmp5_ != FILES_DIRECTORY_STATE_LOADED) {
		files_directory_clear_directory_info (self);
	}
	if (done_loading_func == NULL) {
		g_signal_emit (self, files_directory_signals[FILES_DIRECTORY_DONE_LOADING_SIGNAL], 0);
	} else {
		done_loading_func (done_loading_func_target);
	}
	_tmp6_ = self->priv->_file;
	if (_tmp6_->is_directory) {
		FilesFile* _tmp7_;
		_tmp7_ = self->priv->_file;
		files_file_set_expanded (_tmp7_, TRUE);
	}
}

void
files_directory_block_monitor (FilesDirectory* self)
{
	gboolean _tmp0_ = FALSE;
	GFileMonitor* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->monitor;
	if (_tmp1_ != NULL) {
		_tmp0_ = !self->priv->monitor_blocked;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GFileMonitor* _tmp2_;
		guint _tmp3_;
		self->priv->monitor_blocked = TRUE;
		_tmp2_ = self->priv->monitor;
		g_signal_parse_name ("changed", g_file_monitor_get_type (), &_tmp3_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _files_directory_directory_changed_g_file_monitor_changed, self);
	}
}

void
files_directory_unblock_monitor (FilesDirectory* self)
{
	gboolean _tmp0_ = FALSE;
	GFileMonitor* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->monitor;
	if (_tmp1_ != NULL) {
		_tmp0_ = self->priv->monitor_blocked;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GFileMonitor* _tmp2_;
		self->priv->monitor_blocked = FALSE;
		_tmp2_ = self->priv->monitor;
		g_signal_connect_object (_tmp2_, "changed", (GCallback) _files_directory_directory_changed_g_file_monitor_changed, self, 0);
	}
}

GList*
files_directory_get_files (FilesDirectory* self)
{
	GHashTable* _tmp0_;
	GList* _tmp1_;
	GList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->file_hash;
	_tmp1_ = g_hash_table_get_values (_tmp0_);
	result = _tmp1_;
	return result;
}

void
files_directory_load_hiddens (FilesDirectory* self)
{
	gboolean _tmp0_;
	FilesDirectoryState _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_can_load;
	if (!_tmp0_) {
		return;
	}
	_tmp1_ = self->priv->_state;
	if (_tmp1_ != FILES_DIRECTORY_STATE_LOADED) {
		files_directory_list_directory_async (self, NULL, NULL, NULL, NULL, NULL, NULL);
	} else {
		files_directory_list_cached_files (self, NULL, NULL, NULL, NULL);
	}
}

void
files_directory_update_files (FilesDirectory* self)
{
	GHashTable* _tmp0_;
	GList* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->file_hash;
	_tmp1_ = g_hash_table_get_values (_tmp0_);
	{
		GList* gof_collection = NULL;
		GList* gof_it = NULL;
		gof_collection = _tmp1_;
		for (gof_it = gof_collection; gof_it != NULL; gof_it = gof_it->next) {
			FilesFile* gof = NULL;
			gof = (FilesFile*) gof_it->data;
			{
				gboolean _tmp2_ = FALSE;
				gboolean _tmp3_ = FALSE;
				FilesFile* _tmp4_;
				_tmp4_ = gof;
				if (_tmp4_ != NULL) {
					FilesFile* _tmp5_;
					GFileInfo* _tmp6_;
					_tmp5_ = gof;
					_tmp6_ = _tmp5_->info;
					_tmp3_ = _tmp6_ != NULL;
				} else {
					_tmp3_ = FALSE;
				}
				if (_tmp3_) {
					gboolean _tmp7_ = FALSE;
					FilesFile* _tmp8_;
					gboolean _tmp9_;
					gboolean _tmp10_;
					_tmp8_ = gof;
					_tmp9_ = files_file_get_is_hidden (_tmp8_);
					_tmp10_ = _tmp9_;
					if (!_tmp10_) {
						_tmp7_ = TRUE;
					} else {
						FilesPreferences* _tmp11_;
						FilesPreferences* _tmp12_;
						gboolean _tmp13_;
						gboolean _tmp14_;
						_tmp11_ = files_preferences_get_default ();
						_tmp12_ = _tmp11_;
						_tmp13_ = files_preferences_get_show_hidden_files (_tmp12_);
						_tmp14_ = _tmp13_;
						_tmp7_ = _tmp14_;
						_g_object_unref0 (_tmp12_);
					}
					_tmp2_ = _tmp7_;
				} else {
					_tmp2_ = FALSE;
				}
				if (_tmp2_) {
					FilesFile* _tmp15_;
					_tmp15_ = gof;
					files_file_update (_tmp15_);
				}
			}
		}
		(gof_collection == NULL) ? NULL : (gof_collection = (g_list_free (gof_collection), NULL));
	}
}

void
files_directory_update_desktop_files (FilesDirectory* self)
{
	GHashTable* _tmp0_;
	GList* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->file_hash;
	_tmp1_ = g_hash_table_get_values (_tmp0_);
	{
		GList* gof_collection = NULL;
		GList* gof_it = NULL;
		gof_collection = _tmp1_;
		for (gof_it = gof_collection; gof_it != NULL; gof_it = gof_it->next) {
			FilesFile* gof = NULL;
			gof = (FilesFile*) gof_it->data;
			{
				gboolean _tmp2_ = FALSE;
				gboolean _tmp3_ = FALSE;
				gboolean _tmp4_ = FALSE;
				FilesFile* _tmp5_;
				_tmp5_ = gof;
				if (_tmp5_ != NULL) {
					FilesFile* _tmp6_;
					GFileInfo* _tmp7_;
					_tmp6_ = gof;
					_tmp7_ = _tmp6_->info;
					_tmp4_ = _tmp7_ != NULL;
				} else {
					_tmp4_ = FALSE;
				}
				if (_tmp4_) {
					gboolean _tmp8_ = FALSE;
					FilesFile* _tmp9_;
					gboolean _tmp10_;
					gboolean _tmp11_;
					_tmp9_ = gof;
					_tmp10_ = files_file_get_is_hidden (_tmp9_);
					_tmp11_ = _tmp10_;
					if (!_tmp11_) {
						_tmp8_ = TRUE;
					} else {
						FilesPreferences* _tmp12_;
						FilesPreferences* _tmp13_;
						gboolean _tmp14_;
						gboolean _tmp15_;
						_tmp12_ = files_preferences_get_default ();
						_tmp13_ = _tmp12_;
						_tmp14_ = files_preferences_get_show_hidden_files (_tmp13_);
						_tmp15_ = _tmp14_;
						_tmp8_ = _tmp15_;
						_g_object_unref0 (_tmp13_);
					}
					_tmp3_ = _tmp8_;
				} else {
					_tmp3_ = FALSE;
				}
				if (_tmp3_) {
					FilesFile* _tmp16_;
					_tmp16_ = gof;
					_tmp2_ = _tmp16_->is_desktop;
				} else {
					_tmp2_ = FALSE;
				}
				if (_tmp2_) {
					FilesFile* _tmp17_;
					_tmp17_ = gof;
					files_file_update_desktop_file (_tmp17_);
				}
			}
		}
		(gof_collection == NULL) ? NULL : (gof_collection = (g_list_free (gof_collection), NULL));
	}
}

FilesFile*
files_directory_file_hash_lookup_location (FilesDirectory* self,
                                           GFile* location)
{
	gboolean _tmp0_ = FALSE;
	FilesFile* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (location != NULL) {
		_tmp0_ = G_TYPE_CHECK_INSTANCE_TYPE (location, g_file_get_type ());
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		FilesFile* _result_ = NULL;
		GHashTable* _tmp1_;
		gconstpointer _tmp2_;
		FilesFile* _tmp3_;
		_tmp1_ = self->priv->file_hash;
		_tmp2_ = g_hash_table_lookup (_tmp1_, location);
		_tmp3_ = _g_object_ref0 ((FilesFile*) _tmp2_);
		_result_ = _tmp3_;
		result = _result_;
		return result;
	} else {
		result = NULL;
		return result;
	}
}

void
files_directory_file_hash_add_file (FilesDirectory* self,
                                    FilesFile* gof)
{
	GHashTable* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	FilesFile* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (gof != NULL);
	_tmp0_ = self->priv->file_hash;
	_tmp1_ = files_file_get_location (gof);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_tmp4_ = _g_object_ref0 (gof);
	g_hash_table_insert (_tmp0_, _tmp3_, _tmp4_);
}

static FilesFile*
files_directory_file_cache_find_or_insert (FilesDirectory* self,
                                           GFile* file,
                                           gboolean* was_in_hash,
                                           gboolean update_hash)
{
	gboolean _vala_was_in_hash = FALSE;
	FilesFile* _result_ = NULL;
	GHashTable* _tmp0_;
	gconstpointer _tmp1_;
	FilesFile* _tmp2_;
	FilesFile* _tmp3_;
	FilesFile* _tmp16_;
	FilesFile* _tmp17_;
	FilesFile* _tmp18_;
	FilesFile* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (file != NULL, NULL);
	_tmp0_ = self->priv->file_hash;
	_tmp1_ = g_hash_table_lookup (_tmp0_, file);
	_tmp2_ = _g_object_ref0 ((FilesFile*) _tmp1_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ == NULL) {
		FilesFile* _tmp4_;
		FilesFile* _tmp5_;
		_vala_was_in_hash = FALSE;
		_tmp4_ = files_file_cache_lookup (file);
		_g_object_unref0 (_result_);
		_result_ = _tmp4_;
		_tmp5_ = _result_;
		if (_tmp5_ == NULL) {
			GFile* _tmp6_;
			FilesFile* _tmp7_;
			GHashTable* _tmp8_;
			GFile* _tmp9_;
			FilesFile* _tmp10_;
			FilesFile* _tmp11_;
			_tmp6_ = self->priv->_location;
			_tmp7_ = files_file_new (file, _tmp6_);
			_g_object_unref0 (_result_);
			_result_ = _tmp7_;
			_tmp8_ = self->priv->file_hash;
			_tmp9_ = _g_object_ref0 (file);
			_tmp10_ = _result_;
			_tmp11_ = _g_object_ref0 (_tmp10_);
			g_hash_table_insert (_tmp8_, _tmp9_, _tmp11_);
		} else {
			if (update_hash) {
				GHashTable* _tmp12_;
				GFile* _tmp13_;
				FilesFile* _tmp14_;
				FilesFile* _tmp15_;
				_tmp12_ = self->priv->file_hash;
				_tmp13_ = _g_object_ref0 (file);
				_tmp14_ = _result_;
				_tmp15_ = _g_object_ref0 (_tmp14_);
				g_hash_table_insert (_tmp12_, _tmp13_, _tmp15_);
			}
		}
	} else {
		_vala_was_in_hash = TRUE;
	}
	_tmp16_ = _result_;
	_tmp16_->is_gone = FALSE;
	_tmp17_ = _result_;
	_tmp18_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, FILES_TYPE_FILE, FilesFile));
	result = _tmp18_;
	_g_object_unref0 (_result_);
	if (was_in_hash) {
		*was_in_hash = _vala_was_in_hash;
	}
	return result;
}

static void
files_directory_query_info_async_data_free (gpointer _data)
{
	FilesDirectoryQueryInfoAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->gof);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (FilesDirectoryQueryInfoAsyncData, _data_);
}

static void
files_directory_query_info_async (FilesDirectory* self,
                                  FilesFile* gof,
                                  GCancellable* cancellable,
                                  GAsyncReadyCallback _callback_,
                                  gpointer _user_data_)
{
	FilesDirectoryQueryInfoAsyncData* _data_;
	FilesDirectory* _tmp0_;
	FilesFile* _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (gof != NULL);
	_data_ = g_slice_new0 (FilesDirectoryQueryInfoAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, files_directory_query_info_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (gof);
	_g_object_unref0 (_data_->gof);
	_data_->gof = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	files_directory_query_info_async_co (_data_);
}

static gboolean
files_directory_query_info_finish (FilesDirectory* self,
                                   GAsyncResult* _res_)
{
	gboolean result;
	FilesDirectoryQueryInfoAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	if (NULL == _data_) {
		gboolean _tmp0_ = FALSE;
		return _tmp0_;
	}
	result = _data_->result;
	return result;
}

static void
files_directory_query_info_async_ready (GObject* source_object,
                                        GAsyncResult* _res_,
                                        gpointer _user_data_)
{
	FilesDirectoryQueryInfoAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	files_directory_query_info_async_co (_data_);
}

static gboolean
files_directory_query_info_async_co (FilesDirectoryQueryInfoAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_g_object_unref0 (_data_->gof->info);
	_data_->gof->info = NULL;
	{
		_data_->_tmp1_ = files_file_get_location (_data_->gof);
		_data_->_tmp2_ = _data_->_tmp1_;
		_data_->_tmp3_ = files_directory_get_gio_attrs (_data_->self);
		_data_->_tmp4_ = _data_->_tmp3_;
		_data_->_state_ = 1;
		g_file_query_info_async (_data_->_tmp2_, _data_->_tmp4_, G_FILE_QUERY_INFO_NONE, G_PRIORITY_DEFAULT, _data_->cancellable, files_directory_query_info_async_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp5_ = g_file_query_info_finish (_data_->_tmp2_, _data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp0_ = _data_->_tmp5_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp6_ = _data_->_tmp0_;
		_data_->_tmp0_ = NULL;
		_g_object_unref0 (_data_->gof->info);
		_data_->gof->info = _data_->_tmp6_;
		_g_object_unref0 (_data_->_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->err = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp7_ = _data_->err;
		_data_->_tmp8_ = _data_->_tmp7_->message;
		files_directory_set_last_error_message (_data_->self, _data_->_tmp8_);
		_data_->_tmp9_ = _data_->err;
		_data_->_tmp10_ = _data_->_tmp9_->message;
		_data_->_tmp11_ = files_file_get_uri (_data_->gof);
		_data_->_tmp12_ = _data_->_tmp11_;
		g_debug ("Directory.vala:905: query info failed, %s %s", _data_->_tmp10_, _data_->_tmp12_);
		_data_->_tmp13_ = _data_->err;
		if (g_error_matches (_data_->_tmp13_, G_IO_ERROR, G_IO_ERROR_NOT_FOUND)) {
			files_file_set_exists (_data_->gof, FALSE);
		}
		_g_error_free0 (_data_->err);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp14_ = _data_->gof->info;
	_data_->result = _data_->_tmp14_ != NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
files_directory_changed_and_refresh (FilesDirectory* self,
                                     FilesFile* gof)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (gof != NULL);
	files_file_update (gof);
	_tmp1_ = files_file_get_is_hidden (gof);
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		_tmp0_ = TRUE;
	} else {
		FilesPreferences* _tmp3_;
		FilesPreferences* _tmp4_;
		gboolean _tmp5_;
		gboolean _tmp6_;
		_tmp3_ = files_preferences_get_default ();
		_tmp4_ = _tmp3_;
		_tmp5_ = files_preferences_get_show_hidden_files (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp0_ = _tmp6_;
		_g_object_unref0 (_tmp4_);
	}
	if (_tmp0_) {
		g_signal_emit (self, files_directory_signals[FILES_DIRECTORY_FILE_CHANGED_SIGNAL], 0, gof);
		g_signal_emit_by_name (gof, "changed");
	}
}

static Block7Data*
block7_data_ref (Block7Data* _data7_)
{
	g_atomic_int_inc (&_data7_->_ref_count_);
	return _data7_;
}

static void
block7_data_unref (void * _userdata_)
{
	Block7Data* _data7_;
	_data7_ = (Block7Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
		FilesDirectory* self;
		self = _data7_->self;
		_g_object_unref0 (_data7_->gof);
		_g_object_unref0 (self);
		g_slice_free (Block7Data, _data7_);
	}
}

static gint
_files_file_compare_by_display_name_gcompare_func (gconstpointer a,
                                                   gconstpointer b)
{
	gint result;
	result = files_file_compare_by_display_name (a, (FilesFile*) b);
	return result;
}

static void
__lambda12_ (Block7Data* _data7_,
             GObject* obj,
             GAsyncResult* res)
{
	FilesDirectory* self;
	GFileInfo* _tmp0_;
	self = _data7_->self;
	g_return_if_fail (res != NULL);
	_tmp0_ = _data7_->gof->info;
	if (_tmp0_ == NULL) {
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		_tmp1_ = files_file_get_basename (_data7_->gof);
		_tmp2_ = _tmp1_;
		g_critical ("Directory.vala:931: %s FILE INFO unavailable", _tmp2_);
	} else {
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_;
		gboolean _tmp5_;
		files_file_update (_data7_->gof);
		_tmp4_ = files_file_get_is_hidden (_data7_->gof);
		_tmp5_ = _tmp4_;
		if (!_tmp5_) {
			_tmp3_ = files_file_is_folder (_data7_->gof);
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			GList* _tmp6_;
			GList* _tmp7_;
			_tmp6_ = self->priv->sorted_dirs;
			_tmp7_ = g_list_find (_tmp6_, _data7_->gof);
			if (_tmp7_ == NULL) {
				self->priv->sorted_dirs = g_list_insert_sorted (self->priv->sorted_dirs, _data7_->gof, _files_file_compare_by_display_name_gcompare_func);
			}
		}
	}
}

static void
___lambda12__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda12_ (self, source_object, res);
	block7_data_unref (self);
}

static void
files_directory_notify_file_added (FilesDirectory* self,
                                   FilesFile* gof,
                                   gboolean is_internal)
{
	Block7Data* _data7_;
	FilesFile* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (gof != NULL);
	_data7_ = g_slice_new0 (Block7Data);
	_data7_->_ref_count_ = 1;
	_data7_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (gof);
	_g_object_unref0 (_data7_->gof);
	_data7_->gof = _tmp0_;
	_tmp2_ = files_file_get_is_hidden (_data7_->gof);
	_tmp3_ = _tmp2_;
	if (!_tmp3_) {
		_tmp1_ = TRUE;
	} else {
		FilesPreferences* _tmp4_;
		FilesPreferences* _tmp5_;
		gboolean _tmp6_;
		gboolean _tmp7_;
		_tmp4_ = files_preferences_get_default ();
		_tmp5_ = _tmp4_;
		_tmp6_ = files_preferences_get_show_hidden_files (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp1_ = _tmp7_;
		_g_object_unref0 (_tmp5_);
	}
	if (_tmp1_) {
		g_signal_emit (self, files_directory_signals[FILES_DIRECTORY_FILE_ADDED_SIGNAL], 0, _data7_->gof, is_internal);
	}
	files_directory_query_info_async (self, _data7_->gof, NULL, ___lambda12__gasync_ready_callback, block7_data_ref (_data7_));
	block7_data_unref (_data7_);
	_data7_ = NULL;
}

static Block8Data*
block8_data_ref (Block8Data* _data8_)
{
	g_atomic_int_inc (&_data8_->_ref_count_);
	return _data8_;
}

static void
block8_data_unref (void * _userdata_)
{
	Block8Data* _data8_;
	_data8_ = (Block8Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data8_->_ref_count_)) {
		FilesDirectory* self;
		self = _data8_->self;
		_g_object_unref0 (_data8_->gof);
		_g_object_unref0 (self);
		g_slice_free (Block8Data, _data8_);
	}
}

static void
__lambda13_ (Block8Data* _data8_)
{
	FilesDirectory* self;
	self = _data8_->self;
	files_directory_changed_and_refresh (self, _data8_->gof);
}

static void
___lambda13__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda13_ (self);
	block8_data_unref (self);
}

static void
files_directory_notify_file_changed (FilesDirectory* self,
                                     FilesFile* gof)
{
	Block8Data* _data8_;
	FilesFile* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (gof != NULL);
	_data8_ = g_slice_new0 (Block8Data);
	_data8_->_ref_count_ = 1;
	_data8_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (gof);
	_g_object_unref0 (_data8_->gof);
	_data8_->gof = _tmp0_;
	files_directory_query_info_async (self, _data8_->gof, NULL, ___lambda13__gasync_ready_callback, block8_data_ref (_data8_));
	block8_data_unref (_data8_);
	_data8_ = NULL;
}

static void
files_directory_notify_file_removed (FilesDirectory* self,
                                     FilesFile* gof)
{
	GHashTable* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp11_;
	gboolean _tmp12_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (gof != NULL);
	_tmp0_ = self->priv->file_hash;
	_tmp1_ = files_file_get_location (gof);
	_tmp2_ = _tmp1_;
	g_hash_table_remove (_tmp0_, _tmp2_);
	_tmp4_ = files_file_get_is_hidden (gof);
	_tmp5_ = _tmp4_;
	if (!_tmp5_) {
		_tmp3_ = TRUE;
	} else {
		FilesPreferences* _tmp6_;
		FilesPreferences* _tmp7_;
		gboolean _tmp8_;
		gboolean _tmp9_;
		_tmp6_ = files_preferences_get_default ();
		_tmp7_ = _tmp6_;
		_tmp8_ = files_preferences_get_show_hidden_files (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp3_ = _tmp9_;
		_g_object_unref0 (_tmp7_);
	}
	if (_tmp3_) {
		g_signal_emit (self, files_directory_signals[FILES_DIRECTORY_FILE_DELETED_SIGNAL], 0, gof);
	}
	_tmp11_ = files_file_get_is_hidden (gof);
	_tmp12_ = _tmp11_;
	if (!_tmp12_) {
		_tmp10_ = files_file_is_folder (gof);
	} else {
		_tmp10_ = FALSE;
	}
	if (_tmp10_) {
		self->priv->sorted_dirs = g_list_remove (self->priv->sorted_dirs, gof);
	}
	files_file_remove_from_caches (gof);
}

static gpointer
_files_directory_fchanges_dup0 (gpointer self)
{
	return self ? files_directory_fchanges_dup (self) : NULL;
}

static void
files_directory_directory_changed (FilesDirectory* self,
                                   GFile* _file,
                                   GFile* other_file,
                                   GFileMonitorEvent event)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (_file != NULL);
	_tmp0_ = files_directory_get_freeze_update (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		if (self->priv->list_fchanges_count < FILES_DIRECTORY_FCHANGES_MAX) {
			FilesDirectoryFChanges fc = {0};
			GFile* _tmp2_;
			FilesDirectoryFChanges _tmp3_;
			FilesDirectoryFChanges _tmp4_;
			FilesDirectoryFChanges* _tmp5_;
			guint _tmp6_;
			memset (&fc, 0, sizeof (FilesDirectoryFChanges));
			_tmp2_ = _g_object_ref0 (_file);
			_g_object_unref0 (fc.file);
			fc.file = _tmp2_;
			fc.event = event;
			_tmp3_ = fc;
			_tmp4_ = _tmp3_;
			_tmp5_ = _files_directory_fchanges_dup0 (&_tmp4_);
			self->priv->list_fchanges = g_list_prepend (self->priv->list_fchanges, _tmp5_);
			_tmp6_ = self->priv->list_fchanges_count;
			self->priv->list_fchanges_count = _tmp6_ + 1;
			files_directory_fchanges_destroy (&fc);
		}
		return;
	} else {
		files_directory_real_directory_changed (self, _file, other_file, event);
	}
}

static gboolean
___lambda11_ (FilesDirectory* self)
{
	gboolean result;
	files_file_changes_consume_changes (TRUE);
	self->priv->idle_consume_changes_id = (guint) 0;
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
____lambda11__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda11_ ((FilesDirectory*) self);
	return result;
}

static void
files_directory_real_directory_changed (FilesDirectory* self,
                                        GFile* _file,
                                        GFile* other_file,
                                        GFileMonitorEvent event)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (_file != NULL);
	_tmp0_ = g_file_get_basename (_file);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_str_has_prefix (_tmp1_, ".goutputstream");
	_g_free0 (_tmp1_);
	if (_tmp2_) {
		return;
	}
	switch (event) {
		case G_FILE_MONITOR_EVENT_CREATED:
		{
			files_file_changes_queue_file_added (_file, FALSE);
			break;
		}
		case G_FILE_MONITOR_EVENT_DELETED:
		{
			files_file_changes_queue_file_removed (_file);
			break;
		}
		case G_FILE_MONITOR_EVENT_ATTRIBUTE_CHANGED:
		{
			files_file_changes_queue_file_changed (_file);
			break;
		}
		case G_FILE_MONITOR_EVENT_CHANGES_DONE_HINT:
		{
			files_file_changes_queue_file_changed (_file);
			break;
		}
		case G_FILE_MONITOR_EVENT_MOVED:
		case G_FILE_MONITOR_EVENT_MOVED_IN:
		case G_FILE_MONITOR_EVENT_MOVED_OUT:
		{
			break;
		}
		case G_FILE_MONITOR_EVENT_RENAMED:
		case G_FILE_MONITOR_EVENT_PRE_UNMOUNT:
		case G_FILE_MONITOR_EVENT_UNMOUNTED:
		case G_FILE_MONITOR_EVENT_CHANGED:
		{
			break;
		}
		default:
		break;
	}
	if (self->priv->idle_consume_changes_id == ((guint) 0)) {
		self->priv->idle_consume_changes_id = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 10, ____lambda11__gsource_func, g_object_ref (self), g_object_unref);
	}
}

void
files_directory_notify_files_changed (GList* files)
{
	gboolean already_present = FALSE;
	FilesDirectory* first_dir = NULL;
	gconstpointer _tmp0_;
	FilesDirectory* _tmp1_;
	FilesDirectory* _tmp2_;
	already_present = FALSE;
	_tmp0_ = files->data;
	_tmp1_ = files_directory_cache_lookup_parent ((GFile*) _tmp0_);
	first_dir = _tmp1_;
	_tmp2_ = first_dir;
	if (_tmp2_ != NULL) {
		{
			GList* loc_collection = NULL;
			GList* loc_it = NULL;
			loc_collection = files;
			for (loc_it = loc_collection; loc_it != NULL; loc_it = loc_it->next) {
				GFile* loc = NULL;
				loc = (GFile*) loc_it->data;
				{
					FilesFile* gof = NULL;
					FilesDirectory* _tmp3_;
					GFile* _tmp4_;
					gboolean _tmp5_ = FALSE;
					FilesFile* _tmp6_;
					FilesDirectory* _tmp7_;
					FilesFile* _tmp8_;
					gof = NULL;
					_tmp3_ = first_dir;
					_tmp4_ = loc;
					_tmp6_ = files_directory_file_cache_find_or_insert (_tmp3_, _tmp4_, &_tmp5_, FALSE);
					already_present = _tmp5_;
					_g_object_unref0 (gof);
					gof = _tmp6_;
					_tmp7_ = first_dir;
					_tmp8_ = gof;
					files_directory_notify_file_changed (_tmp7_, _tmp8_);
					_g_object_unref0 (gof);
				}
			}
		}
	} else {
		{
			GList* loc_collection = NULL;
			GList* loc_it = NULL;
			loc_collection = files;
			for (loc_it = loc_collection; loc_it != NULL; loc_it = loc_it->next) {
				GFile* loc = NULL;
				loc = (GFile*) loc_it->data;
				{
					FilesDirectory* dir = NULL;
					GFile* _tmp9_;
					FilesDirectory* _tmp10_;
					FilesDirectory* _tmp11_;
					_tmp9_ = loc;
					_tmp10_ = files_directory_cache_lookup (_tmp9_);
					dir = _tmp10_;
					_tmp11_ = dir;
					if (_tmp11_ != NULL) {
						FilesDirectory* _tmp12_;
						FilesDirectory* _tmp13_;
						FilesFile* _tmp14_;
						_tmp12_ = dir;
						_tmp13_ = dir;
						_tmp14_ = _tmp13_->priv->_file;
						files_directory_notify_file_changed (_tmp12_, _tmp14_);
					}
					_g_object_unref0 (dir);
				}
			}
		}
	}
	_g_object_unref0 (first_dir);
}

void
files_directory_notify_changes_added (GList* changes)
{
	gboolean already_present = FALSE;
	gboolean files_added = FALSE;
	FilesDirectory* first_dir = NULL;
	gconstpointer _tmp0_;
	GFile* _tmp1_;
	FilesDirectory* _tmp2_;
	FilesDirectory* _tmp3_;
	already_present = FALSE;
	files_added = FALSE;
	_tmp0_ = changes->data;
	_tmp1_ = ((FilesFileChangesChange*) _tmp0_)->from;
	_tmp2_ = files_directory_cache_lookup_parent (_tmp1_);
	first_dir = _tmp2_;
	_tmp3_ = first_dir;
	if (_tmp3_ != NULL) {
		{
			GList* change_collection = NULL;
			GList* change_it = NULL;
			change_collection = changes;
			for (change_it = change_collection; change_it != NULL; change_it = change_it->next) {
				FilesFileChangesChange* change = NULL;
				change = (FilesFileChangesChange*) change_it->data;
				{
					FilesDirectory* dir = NULL;
					FilesFileChangesChange* _tmp4_;
					GFile* _tmp5_;
					FilesDirectory* _tmp6_;
					gboolean _tmp7_ = FALSE;
					FilesDirectory* _tmp8_;
					_tmp4_ = change;
					_tmp5_ = _tmp4_->from;
					_tmp6_ = files_directory_cache_lookup_parent (_tmp5_);
					dir = _tmp6_;
					_tmp8_ = dir;
					if (_tmp8_ != NULL) {
						FilesDirectory* _tmp9_;
						FilesDirectory* _tmp10_;
						_tmp9_ = dir;
						_tmp10_ = first_dir;
						_tmp7_ = _tmp9_ == _tmp10_;
					} else {
						_tmp7_ = FALSE;
					}
					if (_tmp7_) {
						FilesFile* gof = NULL;
						FilesDirectory* _tmp11_;
						FilesFileChangesChange* _tmp12_;
						GFile* _tmp13_;
						gboolean _tmp14_ = FALSE;
						FilesFile* _tmp15_;
						_tmp11_ = first_dir;
						_tmp12_ = change;
						_tmp13_ = _tmp12_->from;
						_tmp15_ = files_directory_file_cache_find_or_insert (_tmp11_, _tmp13_, &_tmp14_, TRUE);
						already_present = _tmp14_;
						gof = _tmp15_;
						if (!already_present) {
							FilesDirectory* _tmp16_;
							FilesFile* _tmp17_;
							FilesFileChangesChange* _tmp18_;
							files_added = TRUE;
							_tmp16_ = first_dir;
							_tmp17_ = gof;
							_tmp18_ = change;
							files_directory_notify_file_added (_tmp16_, _tmp17_, _tmp18_->is_internal);
						}
						_g_object_unref0 (gof);
					} else {
						g_critical ("Directory.vala:1110: Unexpected parent of newly created file");
					}
					_g_object_unref0 (dir);
				}
			}
		}
		if (files_added) {
			FilesDirectory* _tmp19_;
			FilesFile* _tmp20_;
			FilesDirectory* parent = NULL;
			FilesDirectory* _tmp21_;
			FilesFile* _tmp22_;
			GFile* _tmp23_;
			GFile* _tmp24_;
			FilesDirectory* _tmp25_;
			FilesDirectory* _tmp26_;
			_tmp19_ = first_dir;
			_tmp20_ = _tmp19_->priv->_file;
			files_file_ensure_size (_tmp20_);
			_tmp21_ = first_dir;
			_tmp22_ = _tmp21_->priv->_file;
			_tmp23_ = files_file_get_location (_tmp22_);
			_tmp24_ = _tmp23_;
			_tmp25_ = files_directory_cache_lookup_parent (_tmp24_);
			parent = _tmp25_;
			_tmp26_ = parent;
			if (_tmp26_ != NULL) {
				FilesDirectory* _tmp27_;
				FilesDirectory* _tmp28_;
				FilesFile* _tmp29_;
				_tmp27_ = parent;
				_tmp28_ = first_dir;
				_tmp29_ = _tmp28_->priv->_file;
				g_signal_emit (_tmp27_, files_directory_signals[FILES_DIRECTORY_FILE_CHANGED_SIGNAL], 0, _tmp29_);
			}
			_g_object_unref0 (parent);
		}
	}
	_g_object_unref0 (first_dir);
}

void
files_directory_notify_files_added_internally (GList* files)
{
	gboolean already_present = FALSE;
	gboolean files_added = FALSE;
	FilesDirectory* first_dir = NULL;
	gconstpointer _tmp0_;
	FilesDirectory* _tmp1_;
	FilesDirectory* _tmp2_;
	already_present = FALSE;
	files_added = FALSE;
	_tmp0_ = files->data;
	_tmp1_ = files_directory_cache_lookup_parent ((GFile*) _tmp0_);
	first_dir = _tmp1_;
	_tmp2_ = first_dir;
	if (_tmp2_ != NULL) {
		{
			GList* loc_collection = NULL;
			GList* loc_it = NULL;
			loc_collection = files;
			for (loc_it = loc_collection; loc_it != NULL; loc_it = loc_it->next) {
				GFile* loc = NULL;
				loc = (GFile*) loc_it->data;
				{
					FilesFile* gof = NULL;
					FilesDirectory* _tmp3_;
					GFile* _tmp4_;
					gboolean _tmp5_ = FALSE;
					FilesFile* _tmp6_;
					_tmp3_ = first_dir;
					_tmp4_ = loc;
					_tmp6_ = files_directory_file_cache_find_or_insert (_tmp3_, _tmp4_, &_tmp5_, TRUE);
					already_present = _tmp5_;
					gof = _tmp6_;
					if (!already_present) {
						FilesDirectory* _tmp7_;
						FilesFile* _tmp8_;
						files_added = TRUE;
						_tmp7_ = first_dir;
						_tmp8_ = gof;
						files_directory_notify_file_added (_tmp7_, _tmp8_, TRUE);
					}
					_g_object_unref0 (gof);
				}
			}
		}
		if (files_added) {
			FilesDirectory* _tmp9_;
			FilesFile* _tmp10_;
			FilesDirectory* parent = NULL;
			FilesDirectory* _tmp11_;
			FilesFile* _tmp12_;
			GFile* _tmp13_;
			GFile* _tmp14_;
			FilesDirectory* _tmp15_;
			FilesDirectory* _tmp16_;
			_tmp9_ = first_dir;
			_tmp10_ = _tmp9_->priv->_file;
			files_file_ensure_size (_tmp10_);
			_tmp11_ = first_dir;
			_tmp12_ = _tmp11_->priv->_file;
			_tmp13_ = files_file_get_location (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp15_ = files_directory_cache_lookup_parent (_tmp14_);
			parent = _tmp15_;
			_tmp16_ = parent;
			if (_tmp16_ != NULL) {
				FilesDirectory* _tmp17_;
				FilesDirectory* _tmp18_;
				FilesFile* _tmp19_;
				_tmp17_ = parent;
				_tmp18_ = first_dir;
				_tmp19_ = _tmp18_->priv->_file;
				g_signal_emit (_tmp17_, files_directory_signals[FILES_DIRECTORY_FILE_CHANGED_SIGNAL], 0, _tmp19_);
			}
			_g_object_unref0 (parent);
		}
	} else {
		FilesDirectory* parent_dir = NULL;
		GFile* first_parent = NULL;
		gconstpointer _tmp20_;
		GFile* _tmp21_;
		GFile* _tmp22_;
		FilesDirectory* _tmp23_;
		FilesDirectory* _tmp24_;
		parent_dir = NULL;
		_tmp20_ = files->data;
		_tmp21_ = g_file_get_parent ((GFile*) _tmp20_);
		first_parent = _tmp21_;
		_tmp22_ = first_parent;
		_tmp23_ = files_directory_cache_lookup_parent (_tmp22_);
		_g_object_unref0 (parent_dir);
		parent_dir = _tmp23_;
		_tmp24_ = parent_dir;
		if (_tmp24_ != NULL) {
			FilesFile* gof = NULL;
			FilesDirectory* _tmp25_;
			GHashTable* _tmp26_;
			GFile* _tmp27_;
			gconstpointer _tmp28_;
			FilesFile* _tmp29_;
			FilesFile* _tmp30_;
			_tmp25_ = parent_dir;
			_tmp26_ = _tmp25_->priv->file_hash;
			_tmp27_ = first_parent;
			_tmp28_ = g_hash_table_lookup (_tmp26_, _tmp27_);
			_tmp29_ = _g_object_ref0 ((FilesFile*) _tmp28_);
			gof = _tmp29_;
			_tmp30_ = gof;
			if (_tmp30_ != NULL) {
				FilesFile* _tmp31_;
				FilesDirectory* _tmp32_;
				FilesFile* _tmp33_;
				_tmp31_ = gof;
				files_file_ensure_size (_tmp31_);
				_tmp32_ = parent_dir;
				_tmp33_ = gof;
				g_signal_emit (_tmp32_, files_directory_signals[FILES_DIRECTORY_FILE_CHANGED_SIGNAL], 0, _tmp33_);
			}
			_g_object_unref0 (gof);
		}
		_g_object_unref0 (first_parent);
		_g_object_unref0 (parent_dir);
	}
	_g_object_unref0 (first_dir);
}

void
files_directory_notify_files_removed (GList* files)
{
	gboolean files_removed = FALSE;
	FilesDirectory* first_dir = NULL;
	gconstpointer _tmp0_;
	FilesDirectory* _tmp1_;
	FilesDirectory* _tmp2_;
	files_removed = FALSE;
	_tmp0_ = files->data;
	_tmp1_ = files_directory_cache_lookup_parent ((GFile*) _tmp0_);
	first_dir = _tmp1_;
	_tmp2_ = first_dir;
	if (_tmp2_ != NULL) {
		{
			GList* loc_collection = NULL;
			GList* loc_it = NULL;
			loc_collection = files;
			for (loc_it = loc_collection; loc_it != NULL; loc_it = loc_it->next) {
				GFile* loc = NULL;
				loc = (GFile*) loc_it->data;
				{
					FilesFile* gof = NULL;
					FilesDirectory* _tmp3_;
					GHashTable* _tmp4_;
					GFile* _tmp5_;
					gconstpointer _tmp6_;
					FilesFile* _tmp7_;
					FilesFile* _tmp8_;
					_tmp3_ = first_dir;
					_tmp4_ = _tmp3_->priv->file_hash;
					_tmp5_ = loc;
					_tmp6_ = g_hash_table_lookup (_tmp4_, _tmp5_);
					_tmp7_ = _g_object_ref0 ((FilesFile*) _tmp6_);
					gof = _tmp7_;
					_tmp8_ = gof;
					if (_tmp8_ != NULL) {
						FilesDirectory* _tmp9_;
						FilesFile* _tmp10_;
						files_removed = TRUE;
						_tmp9_ = first_dir;
						_tmp10_ = gof;
						files_directory_notify_file_removed (_tmp9_, _tmp10_);
					}
					_g_object_unref0 (gof);
				}
			}
		}
		if (files_removed) {
			FilesDirectory* parent = NULL;
			FilesDirectory* _tmp11_;
			FilesFile* _tmp12_;
			GFile* _tmp13_;
			GFile* _tmp14_;
			FilesDirectory* _tmp15_;
			FilesDirectory* _tmp16_;
			_tmp11_ = first_dir;
			_tmp12_ = _tmp11_->priv->_file;
			_tmp13_ = files_file_get_location (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp15_ = files_directory_cache_lookup_parent (_tmp14_);
			parent = _tmp15_;
			_tmp16_ = parent;
			if (_tmp16_ != NULL) {
				FilesDirectory* _tmp17_;
				FilesFile* _tmp18_;
				FilesDirectory* _tmp19_;
				FilesDirectory* _tmp20_;
				FilesFile* _tmp21_;
				_tmp17_ = first_dir;
				_tmp18_ = _tmp17_->priv->_file;
				files_file_ensure_size (_tmp18_);
				_tmp19_ = parent;
				_tmp20_ = first_dir;
				_tmp21_ = _tmp20_->priv->_file;
				g_signal_emit (_tmp19_, files_directory_signals[FILES_DIRECTORY_FILE_CHANGED_SIGNAL], 0, _tmp21_);
			}
			_g_object_unref0 (parent);
		}
	} else {
		FilesDirectory* parent_dir = NULL;
		GFile* first_parent = NULL;
		gconstpointer _tmp22_;
		GFile* _tmp23_;
		GFile* _tmp24_;
		FilesDirectory* _tmp25_;
		FilesDirectory* _tmp26_;
		parent_dir = NULL;
		_tmp22_ = files->data;
		_tmp23_ = g_file_get_parent ((GFile*) _tmp22_);
		first_parent = _tmp23_;
		_tmp24_ = first_parent;
		_tmp25_ = files_directory_cache_lookup_parent (_tmp24_);
		_g_object_unref0 (parent_dir);
		parent_dir = _tmp25_;
		_tmp26_ = parent_dir;
		if (_tmp26_ != NULL) {
			FilesFile* gof = NULL;
			FilesDirectory* _tmp27_;
			GHashTable* _tmp28_;
			GFile* _tmp29_;
			gconstpointer _tmp30_;
			FilesFile* _tmp31_;
			FilesFile* _tmp32_;
			_tmp27_ = parent_dir;
			_tmp28_ = _tmp27_->priv->file_hash;
			_tmp29_ = first_parent;
			_tmp30_ = g_hash_table_lookup (_tmp28_, _tmp29_);
			_tmp31_ = _g_object_ref0 ((FilesFile*) _tmp30_);
			gof = _tmp31_;
			_tmp32_ = gof;
			if (_tmp32_ != NULL) {
				FilesFile* _tmp33_;
				FilesDirectory* _tmp34_;
				FilesFile* _tmp35_;
				_tmp33_ = gof;
				files_file_ensure_size (_tmp33_);
				_tmp34_ = parent_dir;
				_tmp35_ = gof;
				g_signal_emit (_tmp34_, files_directory_signals[FILES_DIRECTORY_FILE_CHANGED_SIGNAL], 0, _tmp35_);
			}
			_g_object_unref0 (gof);
		} else {
			{
				GList* loc_collection = NULL;
				GList* loc_it = NULL;
				loc_collection = files;
				for (loc_it = loc_collection; loc_it != NULL; loc_it = loc_it->next) {
					GFile* loc = NULL;
					loc = (GFile*) loc_it->data;
					{
						FilesDirectory* dir = NULL;
						GFile* _tmp36_;
						FilesDirectory* _tmp37_;
						FilesDirectory* _tmp38_;
						_tmp36_ = loc;
						_tmp37_ = files_directory_cache_lookup (_tmp36_);
						dir = _tmp37_;
						_tmp38_ = dir;
						if (_tmp38_ != NULL) {
							FilesDirectory* _tmp39_;
							FilesDirectory* _tmp40_;
							FilesFile* _tmp41_;
							_tmp39_ = dir;
							_tmp40_ = dir;
							_tmp41_ = _tmp40_->priv->_file;
							g_signal_emit (_tmp39_, files_directory_signals[FILES_DIRECTORY_FILE_DELETED_SIGNAL], 0, _tmp41_);
						}
						_g_object_unref0 (dir);
					}
				}
			}
		}
		_g_object_unref0 (first_parent);
		_g_object_unref0 (parent_dir);
	}
	_g_object_unref0 (first_dir);
}

void
files_directory_notify_files_moved (GList* files)
{
	GList* list_from = NULL;
	GList* list_to = NULL;
	GList* _tmp8_;
	GList* _tmp9_;
	list_from = NULL;
	list_to = NULL;
	{
		GList* pair_collection = NULL;
		GList* pair_it = NULL;
		pair_collection = files;
		for (pair_it = pair_collection; pair_it != NULL; pair_it = pair_it->next) {
			GArray* pair = NULL;
			pair = (GArray*) pair_it->data;
			{
				GFile* from = NULL;
				GArray* _tmp0_;
				GFile* _tmp1_;
				GFile* to = NULL;
				GArray* _tmp2_;
				GFile* _tmp3_;
				GFile* _tmp4_;
				GFile* _tmp5_;
				GFile* _tmp6_;
				GFile* _tmp7_;
				_tmp0_ = pair;
				_tmp1_ = g_array_index (_tmp0_, GFile*, (guint) 0);
				from = _tmp1_;
				_tmp2_ = pair;
				_tmp3_ = g_array_index (_tmp2_, GFile*, (guint) 1);
				to = _tmp3_;
				_tmp4_ = from;
				_tmp5_ = _g_object_ref0 (_tmp4_);
				list_from = g_list_prepend (list_from, _tmp5_);
				_tmp6_ = to;
				_tmp7_ = _g_object_ref0 (_tmp6_);
				list_to = g_list_prepend (list_to, _tmp7_);
			}
		}
	}
	_tmp8_ = list_from;
	files_directory_notify_files_removed (_tmp8_);
	_tmp9_ = list_to;
	files_directory_notify_files_added_internally (_tmp9_);
	(list_to == NULL) ? NULL : (list_to = (_g_list_free__g_object_unref0_ (list_to), NULL));
	(list_from == NULL) ? NULL : (list_from = (_g_list_free__g_object_unref0_ (list_from), NULL));
}

FilesDirectory*
files_directory_cache_lookup (GFile* file)
{
	GHashTable* _tmp0_;
	FilesDirectory* cached_dir = NULL;
	GHashTable* _tmp1_;
	gconstpointer _tmp2_;
	FilesDirectory* _tmp3_;
	FilesDirectory* _tmp4_;
	GError* _inner_error0_ = NULL;
	FilesDirectory* result;
	g_return_val_if_fail (file != NULL, NULL);
	_tmp0_ = files_directory_directory_cache;
	if (_tmp0_ == NULL) {
		result = NULL;
		return result;
	}
	_tmp1_ = files_directory_directory_cache;
	_tmp2_ = g_hash_table_lookup (_tmp1_, file);
	_tmp3_ = _g_object_ref0 ((FilesDirectory*) _tmp2_);
	cached_dir = _tmp3_;
	_tmp4_ = cached_dir;
	if (_tmp4_ != NULL) {
		gboolean _tmp5_ = FALSE;
		FilesDirectory* _tmp6_;
		_tmp6_ = cached_dir;
		if (FILES_IS_DIRECTORY (_tmp6_)) {
			FilesDirectory* _tmp7_;
			FilesFile* _tmp8_;
			_tmp7_ = cached_dir;
			_tmp8_ = _tmp7_->priv->_file;
			_tmp5_ = _tmp8_ != NULL;
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			gboolean _tmp9_ = FALSE;
			FilesDirectory* _tmp10_;
			FilesFile* _tmp11_;
			GFileInfo* _tmp12_;
			_tmp10_ = cached_dir;
			_tmp11_ = _tmp10_->priv->_file;
			_tmp12_ = _tmp11_->info;
			if (_tmp12_ == NULL) {
				FilesDirectory* _tmp13_;
				gboolean _tmp14_;
				_tmp13_ = cached_dir;
				_tmp14_ = _tmp13_->priv->_can_load;
				_tmp9_ = _tmp14_;
			} else {
				_tmp9_ = FALSE;
			}
			if (_tmp9_) {
				FilesDirectory* _tmp15_;
				FilesFile* _tmp16_;
				_tmp15_ = cached_dir;
				_tmp16_ = _tmp15_->priv->_file;
				files_file_query_update (_tmp16_);
			}
		} else {
			g_critical ("Directory.vala:1235: Invalid directory found in cache");
			_g_object_unref0 (cached_dir);
			cached_dir = NULL;
			{
				GHashTable* _tmp17_;
				_tmp17_ = files_directory_directory_cache;
				g_rec_mutex_lock (&__lock_files_directory_files_directory_directory_cache);
				{
					GHashTable* _tmp18_;
					_tmp18_ = files_directory_directory_cache;
					g_hash_table_remove (_tmp18_, file);
				}
				__finally0:
				{
					GHashTable* _tmp19_;
					_tmp19_ = files_directory_directory_cache;
					g_rec_mutex_unlock (&__lock_files_directory_files_directory_directory_cache);
				}
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_object_unref0 (cached_dir);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
			}
		}
	} else {
		gchar* _tmp20_;
		gchar* _tmp21_;
		_tmp20_ = g_file_get_uri (file);
		_tmp21_ = _tmp20_;
		g_debug ("Directory.vala:1242: Dir %s not in cache", _tmp21_);
		_g_free0 (_tmp21_);
	}
	result = cached_dir;
	return result;
}

FilesDirectory*
files_directory_cache_lookup_parent (GFile* file)
{
	GFile* parent = NULL;
	GFile* _tmp0_;
	FilesDirectory* _tmp1_ = NULL;
	GFile* _tmp2_;
	FilesDirectory* result;
	g_return_val_if_fail (file != NULL, NULL);
	_tmp0_ = g_file_get_parent (file);
	parent = _tmp0_;
	_tmp2_ = parent;
	if (_tmp2_ != NULL) {
		GFile* _tmp3_;
		FilesDirectory* _tmp4_;
		_tmp3_ = parent;
		_tmp4_ = files_directory_cache_lookup (_tmp3_);
		_g_object_unref0 (_tmp1_);
		_tmp1_ = _tmp4_;
	} else {
		FilesDirectory* _tmp5_;
		_tmp5_ = files_directory_cache_lookup (file);
		_g_object_unref0 (_tmp1_);
		_tmp1_ = _tmp5_;
	}
	result = _tmp1_;
	_g_object_unref0 (parent);
	return result;
}

gboolean
files_directory_remove_dir_from_cache (FilesDirectory* dir)
{
	FilesFile* _tmp0_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (dir != NULL, FALSE);
	_tmp0_ = dir->priv->_file;
	if (_tmp0_->is_directory) {
		FilesFile* _tmp1_;
		FilesFile* _tmp2_;
		_tmp1_ = dir->priv->_file;
		_tmp1_->is_expanded = FALSE;
		_tmp2_ = dir->priv->_file;
		g_signal_emit_by_name (_tmp2_, "changed");
	}
	{
		GHashTable* _tmp3_;
		_tmp3_ = files_directory_directory_cache;
		g_rec_mutex_lock (&__lock_files_directory_files_directory_directory_cache);
		{
			gboolean _tmp4_ = FALSE;
			GHashTable* _tmp5_;
			GFile* _tmp6_;
			gconstpointer _tmp7_;
			_tmp5_ = files_directory_directory_cache;
			_tmp6_ = dir->priv->_location;
			_tmp7_ = g_hash_table_lookup (_tmp5_, _tmp6_);
			if (((FilesDirectory*) _tmp7_) != NULL) {
				_tmp4_ = TRUE;
			} else {
				GHashTable* _tmp8_;
				GFile* _tmp9_;
				gconstpointer _tmp10_;
				_tmp8_ = files_directory_directory_cache;
				_tmp9_ = dir->priv->_creation_key;
				_tmp10_ = g_hash_table_lookup (_tmp8_, _tmp9_);
				_tmp4_ = ((FilesDirectory*) _tmp10_) != NULL;
			}
			if (_tmp4_) {
				GHashTable* _tmp11_;
				GFile* _tmp12_;
				GHashTable* _tmp13_;
				GFile* _tmp14_;
				_tmp11_ = files_directory_directory_cache;
				_tmp12_ = dir->priv->_location;
				g_hash_table_remove (_tmp11_, _tmp12_);
				_tmp13_ = files_directory_directory_cache;
				_tmp14_ = dir->priv->_creation_key;
				g_hash_table_remove (_tmp13_, _tmp14_);
				dir->priv->removed_from_cache = TRUE;
				result = TRUE;
				{
					GHashTable* _tmp15_;
					_tmp15_ = files_directory_directory_cache;
					g_rec_mutex_unlock (&__lock_files_directory_files_directory_directory_cache);
				}
				return result;
			}
		}
		__finally0:
		{
			GHashTable* _tmp16_;
			_tmp16_ = files_directory_directory_cache;
			g_rec_mutex_unlock (&__lock_files_directory_files_directory_directory_cache);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp17_ = FALSE;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp17_;
		}
	}
	result = FALSE;
	return result;
}

gboolean
files_directory_purge_dir_from_cache (FilesDirectory* dir)
{
	gboolean removed = FALSE;
	gboolean result;
	g_return_val_if_fail (dir != NULL, FALSE);
	removed = files_directory_remove_dir_from_cache (dir);
	if (removed) {
		GHashTable* _tmp0_;
		GList* _tmp1_;
		_tmp0_ = dir->priv->file_hash;
		_tmp1_ = g_hash_table_get_keys (_tmp0_);
		{
			GList* gfile_collection = NULL;
			GList* gfile_it = NULL;
			gfile_collection = _tmp1_;
			for (gfile_it = gfile_collection; gfile_it != NULL; gfile_it = gfile_it->next) {
				GFile* gfile = NULL;
				gfile = (GFile*) gfile_it->data;
				{
					GFile* _tmp2_;
					FilesDirectory* d = NULL;
					GFile* _tmp3_;
					FilesDirectory* _tmp4_;
					FilesDirectory* _tmp5_;
					_tmp2_ = gfile;
					_vala_assert (_tmp2_ != NULL, "gfile != null");
					_tmp3_ = gfile;
					_tmp4_ = files_directory_cache_lookup (_tmp3_);
					d = _tmp4_;
					_tmp5_ = d;
					if (_tmp5_ != NULL) {
						FilesDirectory* _tmp6_;
						_tmp6_ = d;
						files_directory_remove_dir_from_cache (_tmp6_);
					}
					_g_object_unref0 (d);
				}
			}
			(gfile_collection == NULL) ? NULL : (gfile_collection = (g_list_free (gfile_collection), NULL));
		}
	}
	result = removed;
	return result;
}

void
files_directory_empty_dir_cache (void)
{
	GHashTable* _tmp0_;
	_tmp0_ = files_directory_directory_cache;
	g_hash_table_remove_all (_tmp0_);
}

gboolean
files_directory_has_parent (FilesDirectory* self)
{
	FilesFile* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_file;
	_tmp1_ = files_file_get_directory (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_ != NULL;
	return result;
}

GFile*
files_directory_get_parent (FilesDirectory* self)
{
	FilesFile* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	GFile* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_file;
	_tmp1_ = files_file_get_directory (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	result = _tmp3_;
	return result;
}

gboolean
files_directory_is_loading (FilesDirectory* self)
{
	FilesDirectoryState _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_state;
	result = _tmp0_ == FILES_DIRECTORY_STATE_LOADING;
	return result;
}

gboolean
files_directory_is_loaded (FilesDirectory* self)
{
	FilesDirectoryState _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_state;
	result = _tmp0_ == FILES_DIRECTORY_STATE_LOADED;
	return result;
}

gboolean
files_directory_has_timed_out (FilesDirectory* self)
{
	FilesDirectoryState _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_state;
	result = _tmp0_ == FILES_DIRECTORY_STATE_TIMED_OUT;
	return result;
}

gboolean
files_directory_is_empty (FilesDirectory* self)
{
	gboolean _tmp0_ = FALSE;
	FilesDirectoryState _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->_state;
	if (_tmp1_ == FILES_DIRECTORY_STATE_LOADED) {
		GHashTable* _tmp2_;
		_tmp2_ = self->priv->file_hash;
		_tmp0_ = g_hash_table_size (_tmp2_) == ((guint) 0);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

GList*
files_directory_get_sorted_dirs (FilesDirectory* self)
{
	FilesDirectoryState _tmp0_;
	GList* _tmp1_;
	GHashTable* _tmp3_;
	GList* _tmp4_;
	GList* _tmp13_;
	GList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_state;
	if (_tmp0_ != FILES_DIRECTORY_STATE_LOADED) {
		result = NULL;
		return result;
	}
	_tmp1_ = self->priv->sorted_dirs;
	if (_tmp1_ != NULL) {
		GList* _tmp2_;
		_tmp2_ = self->priv->sorted_dirs;
		result = _tmp2_;
		return result;
	}
	_tmp3_ = self->priv->file_hash;
	_tmp4_ = g_hash_table_get_values (_tmp3_);
	{
		GList* gof_collection = NULL;
		GList* gof_it = NULL;
		gof_collection = _tmp4_;
		for (gof_it = gof_collection; gof_it != NULL; gof_it = gof_it->next) {
			FilesFile* gof = NULL;
			gof = (FilesFile*) gof_it->data;
			{
				gboolean _tmp5_ = FALSE;
				FilesFile* _tmp6_;
				gboolean _tmp7_;
				gboolean _tmp8_;
				_tmp6_ = gof;
				_tmp7_ = files_file_get_is_hidden (_tmp6_);
				_tmp8_ = _tmp7_;
				if (!_tmp8_) {
					gboolean _tmp9_ = FALSE;
					FilesFile* _tmp10_;
					_tmp10_ = gof;
					if (files_file_is_folder (_tmp10_)) {
						_tmp9_ = TRUE;
					} else {
						FilesFile* _tmp11_;
						_tmp11_ = gof;
						_tmp9_ = files_file_is_smb_server (_tmp11_);
					}
					_tmp5_ = _tmp9_;
				} else {
					_tmp5_ = FALSE;
				}
				if (_tmp5_) {
					FilesFile* _tmp12_;
					_tmp12_ = gof;
					self->priv->sorted_dirs = g_list_prepend (self->priv->sorted_dirs, _tmp12_);
				}
			}
		}
		(gof_collection == NULL) ? NULL : (gof_collection = (g_list_free (gof_collection), NULL));
	}
	self->priv->sorted_dirs = g_list_sort (self->priv->sorted_dirs, _files_file_compare_by_display_name_gcompare_func);
	_tmp13_ = self->priv->sorted_dirs;
	result = _tmp13_;
	return result;
}

static void
files_directory_cancel_timeouts (FilesDirectory* self)
{
	g_return_if_fail (self != NULL);
	files_directory_cancel_timeout (self, &self->priv->idle_consume_changes_id);
	files_directory_cancel_timeout (self, &self->priv->load_timeout_id);
	files_directory_cancel_timeout (self, &self->priv->mount_timeout_id);
}

static gboolean
files_directory_cancel_timeout (FilesDirectory* self,
                                guint* id)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if ((*id) > ((guint) 0)) {
		g_source_remove (*id);
		*id = (guint) 0;
		result = TRUE;
		return result;
	} else {
		result = FALSE;
		return result;
	}
}

GFile*
files_directory_get_creation_key (FilesDirectory* self)
{
	GFile* result;
	GFile* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_creation_key;
	result = _tmp0_;
	return result;
}

static void
files_directory_set_creation_key (FilesDirectory* self,
                                  GFile* value)
{
	GFile* old_value;
	g_return_if_fail (self != NULL);
	old_value = files_directory_get_creation_key (self);
	if (old_value != value) {
		GFile* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_creation_key);
		self->priv->_creation_key = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, files_directory_properties[FILES_DIRECTORY_CREATION_KEY_PROPERTY]);
	}
}

GFile*
files_directory_get_location (FilesDirectory* self)
{
	GFile* result;
	GFile* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_location;
	result = _tmp0_;
	return result;
}

static void
files_directory_set_location (FilesDirectory* self,
                              GFile* value)
{
	GFile* old_value;
	g_return_if_fail (self != NULL);
	old_value = files_directory_get_location (self);
	if (old_value != value) {
		GFile* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_location);
		self->priv->_location = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, files_directory_properties[FILES_DIRECTORY_LOCATION_PROPERTY]);
	}
}

GFile*
files_directory_get_selected_file (FilesDirectory* self)
{
	GFile* result;
	GFile* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_selected_file;
	result = _tmp0_;
	return result;
}

static void
files_directory_set_selected_file (FilesDirectory* self,
                                   GFile* value)
{
	GFile* old_value;
	g_return_if_fail (self != NULL);
	old_value = files_directory_get_selected_file (self);
	if (old_value != value) {
		GFile* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_selected_file);
		self->priv->_selected_file = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, files_directory_properties[FILES_DIRECTORY_SELECTED_FILE_PROPERTY]);
	}
}

FilesFile*
files_directory_get_file (FilesDirectory* self)
{
	FilesFile* result;
	FilesFile* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_file;
	result = _tmp0_;
	return result;
}

static void
files_directory_set_file (FilesDirectory* self,
                          FilesFile* value)
{
	FilesFile* old_value;
	g_return_if_fail (self != NULL);
	old_value = files_directory_get_file (self);
	if (old_value != value) {
		FilesFile* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_file);
		self->priv->_file = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, files_directory_properties[FILES_DIRECTORY_FILE_PROPERTY]);
	}
}

FilesDirectoryState
files_directory_get_state (FilesDirectory* self)
{
	FilesDirectoryState result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_state;
	return result;
}

static void
files_directory_set_state (FilesDirectory* self,
                           FilesDirectoryState value)
{
	FilesDirectoryState old_value;
	g_return_if_fail (self != NULL);
	old_value = files_directory_get_state (self);
	if (old_value != value) {
		self->priv->_state = value;
		g_object_notify_by_pspec ((GObject *) self, files_directory_properties[FILES_DIRECTORY_STATE_PROPERTY]);
	}
}

guint
files_directory_get_displayed_files_count (FilesDirectory* self)
{
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_displayed_files_count;
	return result;
}

static void
files_directory_set_displayed_files_count (FilesDirectory* self,
                                           guint value)
{
	guint old_value;
	g_return_if_fail (self != NULL);
	old_value = files_directory_get_displayed_files_count (self);
	if (old_value != value) {
		self->priv->_displayed_files_count = value;
		g_object_notify_by_pspec ((GObject *) self, files_directory_properties[FILES_DIRECTORY_DISPLAYED_FILES_COUNT_PROPERTY]);
	}
}

static const gchar*
files_directory_get_gio_attrs (FilesDirectory* self)
{
	const gchar* result;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp2_ = self->priv->_scheme;
	if (g_strcmp0 (_tmp2_, "network") == 0) {
		_tmp1_ = TRUE;
	} else {
		const gchar* _tmp3_;
		_tmp3_ = self->priv->_scheme;
		_tmp1_ = g_strcmp0 (_tmp3_, "computer") == 0;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp4_;
		_tmp4_ = self->priv->_scheme;
		_tmp0_ = g_strcmp0 (_tmp4_, "smb") == 0;
	}
	if (_tmp0_) {
		result = "*";
		return result;
	} else {
		result = FILES_FILE_GIO_DEFAULT_ATTRIBUTES;
		return result;
	}
}

const gchar*
files_directory_get_scheme (FilesDirectory* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_scheme;
	result = _tmp0_;
	return result;
}

static void
files_directory_set_scheme (FilesDirectory* self,
                            const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = files_directory_get_scheme (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_scheme);
		self->priv->_scheme = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, files_directory_properties[FILES_DIRECTORY_SCHEME_PROPERTY]);
	}
}

gboolean
files_directory_get_is_local (FilesDirectory* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_local;
	return result;
}

static void
files_directory_set_is_local (FilesDirectory* self,
                              gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = files_directory_get_is_local (self);
	if (old_value != value) {
		self->priv->_is_local = value;
		g_object_notify_by_pspec ((GObject *) self, files_directory_properties[FILES_DIRECTORY_IS_LOCAL_PROPERTY]);
	}
}

gboolean
files_directory_get_is_trash (FilesDirectory* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_trash;
	return result;
}

static void
files_directory_set_is_trash (FilesDirectory* self,
                              gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = files_directory_get_is_trash (self);
	if (old_value != value) {
		self->priv->_is_trash = value;
		g_object_notify_by_pspec ((GObject *) self, files_directory_properties[FILES_DIRECTORY_IS_TRASH_PROPERTY]);
	}
}

gboolean
files_directory_get_is_network (FilesDirectory* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_network;
	return result;
}

static void
files_directory_set_is_network (FilesDirectory* self,
                                gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = files_directory_get_is_network (self);
	if (old_value != value) {
		self->priv->_is_network = value;
		g_object_notify_by_pspec ((GObject *) self, files_directory_properties[FILES_DIRECTORY_IS_NETWORK_PROPERTY]);
	}
}

gboolean
files_directory_get_is_recent (FilesDirectory* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_recent;
	return result;
}

static void
files_directory_set_is_recent (FilesDirectory* self,
                               gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = files_directory_get_is_recent (self);
	if (old_value != value) {
		self->priv->_is_recent = value;
		g_object_notify_by_pspec ((GObject *) self, files_directory_properties[FILES_DIRECTORY_IS_RECENT_PROPERTY]);
	}
}

gboolean
files_directory_get_is_admin (FilesDirectory* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_admin;
	return result;
}

static void
files_directory_set_is_admin (FilesDirectory* self,
                              gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = files_directory_get_is_admin (self);
	if (old_value != value) {
		self->priv->_is_admin = value;
		g_object_notify_by_pspec ((GObject *) self, files_directory_properties[FILES_DIRECTORY_IS_ADMIN_PROPERTY]);
	}
}

gboolean
files_directory_get_is_no_info (FilesDirectory* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_no_info;
	return result;
}

static void
files_directory_set_is_no_info (FilesDirectory* self,
                                gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = files_directory_get_is_no_info (self);
	if (old_value != value) {
		self->priv->_is_no_info = value;
		g_object_notify_by_pspec ((GObject *) self, files_directory_properties[FILES_DIRECTORY_IS_NO_INFO_PROPERTY]);
	}
}

gboolean
files_directory_get_has_mounts (FilesDirectory* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_has_mounts;
	return result;
}

static void
files_directory_set_has_mounts (FilesDirectory* self,
                                gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = files_directory_get_has_mounts (self);
	if (old_value != value) {
		self->priv->_has_mounts = value;
		g_object_notify_by_pspec ((GObject *) self, files_directory_properties[FILES_DIRECTORY_HAS_MOUNTS_PROPERTY]);
	}
}

gboolean
files_directory_get_has_trash_dirs (FilesDirectory* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_has_trash_dirs;
	return result;
}

static void
files_directory_set_has_trash_dirs (FilesDirectory* self,
                                    gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = files_directory_get_has_trash_dirs (self);
	if (old_value != value) {
		self->priv->_has_trash_dirs = value;
		g_object_notify_by_pspec ((GObject *) self, files_directory_properties[FILES_DIRECTORY_HAS_TRASH_DIRS_PROPERTY]);
	}
}

gboolean
files_directory_get_can_load (FilesDirectory* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_can_load;
	return result;
}

static void
files_directory_set_can_load (FilesDirectory* self,
                              gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = files_directory_get_can_load (self);
	if (old_value != value) {
		self->priv->_can_load = value;
		g_object_notify_by_pspec ((GObject *) self, files_directory_properties[FILES_DIRECTORY_CAN_LOAD_PROPERTY]);
	}
}

gboolean
files_directory_get_can_open_files (FilesDirectory* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_can_open_files;
	return result;
}

static void
files_directory_set_can_open_files (FilesDirectory* self,
                                    gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = files_directory_get_can_open_files (self);
	if (old_value != value) {
		self->priv->_can_open_files = value;
		g_object_notify_by_pspec ((GObject *) self, files_directory_properties[FILES_DIRECTORY_CAN_OPEN_FILES_PROPERTY]);
	}
}

gboolean
files_directory_get_can_stream_files (FilesDirectory* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_can_stream_files;
	return result;
}

static void
files_directory_set_can_stream_files (FilesDirectory* self,
                                      gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = files_directory_get_can_stream_files (self);
	if (old_value != value) {
		self->priv->_can_stream_files = value;
		g_object_notify_by_pspec ((GObject *) self, files_directory_properties[FILES_DIRECTORY_CAN_STREAM_FILES_PROPERTY]);
	}
}

gboolean
files_directory_get_allow_user_interaction (FilesDirectory* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_allow_user_interaction;
	return result;
}

void
files_directory_set_allow_user_interaction (FilesDirectory* self,
                                            gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = files_directory_get_allow_user_interaction (self);
	if (old_value != value) {
		self->priv->_allow_user_interaction = value;
		g_object_notify_by_pspec ((GObject *) self, files_directory_properties[FILES_DIRECTORY_ALLOW_USER_INTERACTION_PROPERTY]);
	}
}

gboolean
files_directory_get_is_cancelled (FilesDirectory* self)
{
	gboolean result;
	GCancellable* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->cancellable;
	result = g_cancellable_is_cancelled (_tmp0_);
	return result;
}

const gchar*
files_directory_get_last_error_message (FilesDirectory* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_last_error_message;
	result = _tmp0_;
	return result;
}

static void
files_directory_set_last_error_message (FilesDirectory* self,
                                        const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = files_directory_get_last_error_message (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_last_error_message);
		self->priv->_last_error_message = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, files_directory_properties[FILES_DIRECTORY_LAST_ERROR_MESSAGE_PROPERTY]);
	}
}

gboolean
files_directory_get_loaded_from_cache (FilesDirectory* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_loaded_from_cache;
	return result;
}

static void
files_directory_set_loaded_from_cache (FilesDirectory* self,
                                       gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = files_directory_get_loaded_from_cache (self);
	if (old_value != value) {
		self->priv->_loaded_from_cache = value;
		g_object_notify_by_pspec ((GObject *) self, files_directory_properties[FILES_DIRECTORY_LOADED_FROM_CACHE_PROPERTY]);
	}
}

gboolean
files_directory_get_freeze_update (FilesDirectory* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_freeze_update;
	return result;
}

void
files_directory_set_freeze_update (FilesDirectory* self,
                                   gboolean value)
{
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	self->priv->_freeze_update = value;
	if (!value) {
		gboolean _tmp1_;
		_tmp1_ = self->priv->_can_load;
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		if (self->priv->list_fchanges_count >= FILES_DIRECTORY_FCHANGES_MAX) {
			g_signal_emit (self, files_directory_signals[FILES_DIRECTORY_NEED_RELOAD_SIGNAL], 0, TRUE);
		} else {
			if (self->priv->list_fchanges_count > ((guint) 0)) {
				GList* _tmp2_;
				self->priv->list_fchanges = g_list_reverse (self->priv->list_fchanges);
				_tmp2_ = self->priv->list_fchanges;
				{
					GList* fchange_collection = NULL;
					GList* fchange_it = NULL;
					fchange_collection = _tmp2_;
					for (fchange_it = fchange_collection; fchange_it != NULL; fchange_it = fchange_it->next) {
						FilesDirectoryFChanges* _tmp3_;
						FilesDirectoryFChanges* fchange = NULL;
						_tmp3_ = _files_directory_fchanges_dup0 ((FilesDirectoryFChanges*) fchange_it->data);
						fchange = _tmp3_;
						{
							FilesDirectoryFChanges* _tmp4_;
							GFile* _tmp5_;
							FilesDirectoryFChanges* _tmp6_;
							_tmp4_ = fchange;
							_tmp5_ = (*_tmp4_).file;
							_tmp6_ = fchange;
							files_directory_real_directory_changed (self, _tmp5_, NULL, (*_tmp6_).event);
							_files_directory_fchanges_free0 (fchange);
						}
					}
				}
			}
		}
	}
	self->priv->list_fchanges_count = (guint) 0;
	(self->priv->list_fchanges == NULL) ? NULL : (self->priv->list_fchanges = (_g_list_free__files_directory_fchanges_free0_ (self->priv->list_fchanges), NULL));
	self->priv->list_fchanges = NULL;
	g_object_notify_by_pspec ((GObject *) self, files_directory_properties[FILES_DIRECTORY_FREEZE_UPDATE_PROPERTY]);
}

static void
g_cclosure_user_marshal_VOID__OBJECT_BOOLEAN (GClosure * closure,
                                              GValue * return_value,
                                              guint n_param_values,
                                              const GValue * param_values,
                                              gpointer invocation_hint,
                                              gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__OBJECT_BOOLEAN) (gpointer data1, gpointer arg_1, gboolean arg_2, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_BOOLEAN callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_BOOLEAN) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_boolean (param_values + 2), data2);
}

static void
files_directory_fchanges_copy (const FilesDirectoryFChanges* self,
                               FilesDirectoryFChanges* dest)
{
	GFile* _tmp0_;
	GFile* _tmp1_;
	_tmp0_ = (*self).file;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 ((*dest).file);
	(*dest).file = _tmp1_;
	(*dest).event = (*self).event;
}

static void
files_directory_fchanges_destroy (FilesDirectoryFChanges* self)
{
	_g_object_unref0 ((*self).file);
}

static FilesDirectoryFChanges*
files_directory_fchanges_dup (const FilesDirectoryFChanges* self)
{
	FilesDirectoryFChanges* dup;
	dup = g_new0 (FilesDirectoryFChanges, 1);
	files_directory_fchanges_copy (self, dup);
	return dup;
}

static void
files_directory_fchanges_free (FilesDirectoryFChanges* self)
{
	files_directory_fchanges_destroy (self);
	g_free (self);
}

 G_GNUC_NO_INLINE static GType
files_directory_fchanges_get_type_once (void)
{
	GType files_directory_fchanges_type_id;
	files_directory_fchanges_type_id = g_boxed_type_register_static ("FilesDirectoryFChanges", (GBoxedCopyFunc) files_directory_fchanges_dup, (GBoxedFreeFunc) files_directory_fchanges_free);
	return files_directory_fchanges_type_id;
}

static GType
files_directory_fchanges_get_type (void)
{
	static volatile gsize files_directory_fchanges_type_id__once = 0;
	if (g_once_init_enter (&files_directory_fchanges_type_id__once)) {
		GType files_directory_fchanges_type_id;
		files_directory_fchanges_type_id = files_directory_fchanges_get_type_once ();
		g_once_init_leave (&files_directory_fchanges_type_id__once, files_directory_fchanges_type_id);
	}
	return files_directory_fchanges_type_id__once;
}

static void
files_directory_class_init (FilesDirectoryClass * klass,
                            gpointer klass_data)
{
	GHashTable* _tmp0_;
	files_directory_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FilesDirectory_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_files_directory_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_files_directory_set_property;
	G_OBJECT_CLASS (klass)->finalize = files_directory_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILES_DIRECTORY_CREATION_KEY_PROPERTY, files_directory_properties[FILES_DIRECTORY_CREATION_KEY_PROPERTY] = g_param_spec_object ("creation-key", "creation-key", "creation-key", g_file_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILES_DIRECTORY_LOCATION_PROPERTY, files_directory_properties[FILES_DIRECTORY_LOCATION_PROPERTY] = g_param_spec_object ("location", "location", "location", g_file_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILES_DIRECTORY_SELECTED_FILE_PROPERTY, files_directory_properties[FILES_DIRECTORY_SELECTED_FILE_PROPERTY] = g_param_spec_object ("selected-file", "selected-file", "selected-file", g_file_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILES_DIRECTORY_FILE_PROPERTY, files_directory_properties[FILES_DIRECTORY_FILE_PROPERTY] = g_param_spec_object ("file", "file", "file", FILES_TYPE_FILE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILES_DIRECTORY_STATE_PROPERTY, files_directory_properties[FILES_DIRECTORY_STATE_PROPERTY] = g_param_spec_enum ("state", "state", "state", FILES_DIRECTORY_TYPE_STATE, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILES_DIRECTORY_DISPLAYED_FILES_COUNT_PROPERTY, files_directory_properties[FILES_DIRECTORY_DISPLAYED_FILES_COUNT_PROPERTY] = g_param_spec_uint ("displayed-files-count", "displayed-files-count", "displayed-files-count", 0, G_MAXUINT, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILES_DIRECTORY_SCHEME_PROPERTY, files_directory_properties[FILES_DIRECTORY_SCHEME_PROPERTY] = g_param_spec_string ("scheme", "scheme", "scheme", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILES_DIRECTORY_IS_LOCAL_PROPERTY, files_directory_properties[FILES_DIRECTORY_IS_LOCAL_PROPERTY] = g_param_spec_boolean ("is-local", "is-local", "is-local", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILES_DIRECTORY_IS_TRASH_PROPERTY, files_directory_properties[FILES_DIRECTORY_IS_TRASH_PROPERTY] = g_param_spec_boolean ("is-trash", "is-trash", "is-trash", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILES_DIRECTORY_IS_NETWORK_PROPERTY, files_directory_properties[FILES_DIRECTORY_IS_NETWORK_PROPERTY] = g_param_spec_boolean ("is-network", "is-network", "is-network", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILES_DIRECTORY_IS_RECENT_PROPERTY, files_directory_properties[FILES_DIRECTORY_IS_RECENT_PROPERTY] = g_param_spec_boolean ("is-recent", "is-recent", "is-recent", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILES_DIRECTORY_IS_ADMIN_PROPERTY, files_directory_properties[FILES_DIRECTORY_IS_ADMIN_PROPERTY] = g_param_spec_boolean ("is-admin", "is-admin", "is-admin", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILES_DIRECTORY_IS_NO_INFO_PROPERTY, files_directory_properties[FILES_DIRECTORY_IS_NO_INFO_PROPERTY] = g_param_spec_boolean ("is-no-info", "is-no-info", "is-no-info", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILES_DIRECTORY_HAS_MOUNTS_PROPERTY, files_directory_properties[FILES_DIRECTORY_HAS_MOUNTS_PROPERTY] = g_param_spec_boolean ("has-mounts", "has-mounts", "has-mounts", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILES_DIRECTORY_HAS_TRASH_DIRS_PROPERTY, files_directory_properties[FILES_DIRECTORY_HAS_TRASH_DIRS_PROPERTY] = g_param_spec_boolean ("has-trash-dirs", "has-trash-dirs", "has-trash-dirs", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILES_DIRECTORY_CAN_LOAD_PROPERTY, files_directory_properties[FILES_DIRECTORY_CAN_LOAD_PROPERTY] = g_param_spec_boolean ("can-load", "can-load", "can-load", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILES_DIRECTORY_CAN_OPEN_FILES_PROPERTY, files_directory_properties[FILES_DIRECTORY_CAN_OPEN_FILES_PROPERTY] = g_param_spec_boolean ("can-open-files", "can-open-files", "can-open-files", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILES_DIRECTORY_CAN_STREAM_FILES_PROPERTY, files_directory_properties[FILES_DIRECTORY_CAN_STREAM_FILES_PROPERTY] = g_param_spec_boolean ("can-stream-files", "can-stream-files", "can-stream-files", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILES_DIRECTORY_ALLOW_USER_INTERACTION_PROPERTY, files_directory_properties[FILES_DIRECTORY_ALLOW_USER_INTERACTION_PROPERTY] = g_param_spec_boolean ("allow-user-interaction", "allow-user-interaction", "allow-user-interaction", TRUE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILES_DIRECTORY_IS_CANCELLED_PROPERTY, files_directory_properties[FILES_DIRECTORY_IS_CANCELLED_PROPERTY] = g_param_spec_boolean ("is-cancelled", "is-cancelled", "is-cancelled", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILES_DIRECTORY_LAST_ERROR_MESSAGE_PROPERTY, files_directory_properties[FILES_DIRECTORY_LAST_ERROR_MESSAGE_PROPERTY] = g_param_spec_string ("last-error-message", "last-error-message", "last-error-message", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILES_DIRECTORY_LOADED_FROM_CACHE_PROPERTY, files_directory_properties[FILES_DIRECTORY_LOADED_FROM_CACHE_PROPERTY] = g_param_spec_boolean ("loaded-from-cache", "loaded-from-cache", "loaded-from-cache", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILES_DIRECTORY_FREEZE_UPDATE_PROPERTY, files_directory_properties[FILES_DIRECTORY_FREEZE_UPDATE_PROPERTY] = g_param_spec_boolean ("freeze-update", "freeze-update", "freeze-update", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	files_directory_signals[FILES_DIRECTORY_FILE_LOADED_SIGNAL] = g_signal_new ("file-loaded", FILES_TYPE_DIRECTORY, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, FILES_TYPE_FILE);
	files_directory_signals[FILES_DIRECTORY_FILE_ADDED_SIGNAL] = g_signal_new ("file-added", FILES_TYPE_DIRECTORY, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_BOOLEAN, G_TYPE_NONE, 2, FILES_TYPE_FILE, G_TYPE_BOOLEAN);
	files_directory_signals[FILES_DIRECTORY_FILE_CHANGED_SIGNAL] = g_signal_new ("file-changed", FILES_TYPE_DIRECTORY, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, FILES_TYPE_FILE);
	files_directory_signals[FILES_DIRECTORY_FILE_DELETED_SIGNAL] = g_signal_new ("file-deleted", FILES_TYPE_DIRECTORY, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, FILES_TYPE_FILE);
	files_directory_signals[FILES_DIRECTORY_ICON_CHANGED_SIGNAL] = g_signal_new ("icon-changed", FILES_TYPE_DIRECTORY, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, FILES_TYPE_FILE);
	files_directory_signals[FILES_DIRECTORY_DONE_LOADING_SIGNAL] = g_signal_new ("done-loading", FILES_TYPE_DIRECTORY, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	files_directory_signals[FILES_DIRECTORY_THUMBS_LOADED_SIGNAL] = g_signal_new ("thumbs-loaded", FILES_TYPE_DIRECTORY, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	files_directory_signals[FILES_DIRECTORY_NEED_RELOAD_SIGNAL] = g_signal_new ("need-reload", FILES_TYPE_DIRECTORY, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__BOOLEAN, G_TYPE_NONE, 1, G_TYPE_BOOLEAN);
	g_rec_mutex_init (&__lock_files_directory_files_directory_directory_cache);
	_tmp0_ = g_hash_table_new_full (_g_file_hash_ghash_func, _g_file_equal_gequal_func, NULL, _g_object_unref0_);
	_g_hash_table_unref0 (files_directory_directory_cache);
	files_directory_directory_cache = _tmp0_;
	_vala_clear_GMutex (&files_directory_dir_cache_lock);
	g_mutex_init (&files_directory_dir_cache_lock);
}

static void
files_directory_instance_init (FilesDirectory * self,
                               gpointer klass)
{
	gchar* _tmp0_;
	self->priv = files_directory_get_instance_private (self);
	self->priv->load_timeout_id = (guint) 0;
	self->priv->mount_timeout_id = (guint) 0;
	self->icon_size = 32;
	self->permission_denied = FALSE;
	self->network_available = TRUE;
	self->priv->monitor = NULL;
	self->priv->sorted_dirs = NULL;
	self->priv->idle_consume_changes_id = (guint) 0;
	self->priv->monitor_blocked = FALSE;
	self->priv->_allow_user_interaction = TRUE;
	self->priv->is_ready = FALSE;
	_tmp0_ = g_strdup ("");
	self->priv->_last_error_message = _tmp0_;
	self->priv->_loaded_from_cache = FALSE;
	self->priv->list_fchanges = NULL;
	self->priv->list_fchanges_count = (guint) 0;
}

static void
files_directory_finalize (GObject * obj)
{
	FilesDirectory * self;
	FilesFile* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_ = FALSE;
	FilesFile* _tmp5_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FILES_TYPE_DIRECTORY, FilesDirectory);
	_tmp0_ = self->priv->_file;
	_tmp1_ = files_file_get_uri (_tmp0_);
	_tmp2_ = _tmp1_;
	g_debug ("Directory.vala:206: Directory destruct %s", _tmp2_);
	_tmp3_ = self->priv->_is_trash;
	if (_tmp3_) {
		files_directory_disconnect_volume_monitor_signals (self);
	}
	_tmp5_ = self->priv->_file;
	if (_tmp5_ != NULL) {
		FilesFile* _tmp6_;
		_tmp6_ = self->priv->_file;
		_tmp4_ = _tmp6_->is_directory;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		FilesFile* _tmp7_;
		_tmp7_ = self->priv->_file;
		files_file_set_expanded (_tmp7_, FALSE);
	}
	_g_object_unref0 (self->priv->_creation_key);
	_g_object_unref0 (self->priv->_location);
	_g_object_unref0 (self->priv->_selected_file);
	_g_object_unref0 (self->priv->_file);
	_g_hash_table_unref0 (self->priv->file_hash);
	_g_object_unref0 (self->priv->cancellable);
	_g_object_unref0 (self->priv->monitor);
	(self->priv->sorted_dirs == NULL) ? NULL : (self->priv->sorted_dirs = (g_list_free (self->priv->sorted_dirs), NULL));
	_g_free0 (self->priv->_scheme);
	_g_free0 (self->priv->_last_error_message);
	(self->priv->list_fchanges == NULL) ? NULL : (self->priv->list_fchanges = (_g_list_free__files_directory_fchanges_free0_ (self->priv->list_fchanges), NULL));
	G_OBJECT_CLASS (files_directory_parent_class)->finalize (obj);
}

/***
    Copyright (C) 2011 Marlin Developers
                  2015-2018 elementary LLC <https://elementary.io>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, Inc.,, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

    Author: ammonkey <am.monkeyd@gmail.com>
            Jeremy Wootten <jeremywootten@gmail.com>
***/
 G_GNUC_NO_INLINE static GType
files_directory_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FilesDirectoryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) files_directory_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FilesDirectory), 0, (GInstanceInitFunc) files_directory_instance_init, NULL };
	GType files_directory_type_id;
	files_directory_type_id = g_type_register_static (G_TYPE_OBJECT, "FilesDirectory", &g_define_type_info, 0);
	FilesDirectory_private_offset = g_type_add_instance_private (files_directory_type_id, sizeof (FilesDirectoryPrivate));
	return files_directory_type_id;
}

GType
files_directory_get_type (void)
{
	static volatile gsize files_directory_type_id__once = 0;
	if (g_once_init_enter (&files_directory_type_id__once)) {
		GType files_directory_type_id;
		files_directory_type_id = files_directory_get_type_once ();
		g_once_init_leave (&files_directory_type_id__once, files_directory_type_id);
	}
	return files_directory_type_id__once;
}

static void
_vala_files_directory_get_property (GObject * object,
                                    guint property_id,
                                    GValue * value,
                                    GParamSpec * pspec)
{
	FilesDirectory * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FILES_TYPE_DIRECTORY, FilesDirectory);
	switch (property_id) {
		case FILES_DIRECTORY_CREATION_KEY_PROPERTY:
		g_value_set_object (value, files_directory_get_creation_key (self));
		break;
		case FILES_DIRECTORY_LOCATION_PROPERTY:
		g_value_set_object (value, files_directory_get_location (self));
		break;
		case FILES_DIRECTORY_SELECTED_FILE_PROPERTY:
		g_value_set_object (value, files_directory_get_selected_file (self));
		break;
		case FILES_DIRECTORY_FILE_PROPERTY:
		g_value_set_object (value, files_directory_get_file (self));
		break;
		case FILES_DIRECTORY_STATE_PROPERTY:
		g_value_set_enum (value, files_directory_get_state (self));
		break;
		case FILES_DIRECTORY_DISPLAYED_FILES_COUNT_PROPERTY:
		g_value_set_uint (value, files_directory_get_displayed_files_count (self));
		break;
		case FILES_DIRECTORY_SCHEME_PROPERTY:
		g_value_set_string (value, files_directory_get_scheme (self));
		break;
		case FILES_DIRECTORY_IS_LOCAL_PROPERTY:
		g_value_set_boolean (value, files_directory_get_is_local (self));
		break;
		case FILES_DIRECTORY_IS_TRASH_PROPERTY:
		g_value_set_boolean (value, files_directory_get_is_trash (self));
		break;
		case FILES_DIRECTORY_IS_NETWORK_PROPERTY:
		g_value_set_boolean (value, files_directory_get_is_network (self));
		break;
		case FILES_DIRECTORY_IS_RECENT_PROPERTY:
		g_value_set_boolean (value, files_directory_get_is_recent (self));
		break;
		case FILES_DIRECTORY_IS_ADMIN_PROPERTY:
		g_value_set_boolean (value, files_directory_get_is_admin (self));
		break;
		case FILES_DIRECTORY_IS_NO_INFO_PROPERTY:
		g_value_set_boolean (value, files_directory_get_is_no_info (self));
		break;
		case FILES_DIRECTORY_HAS_MOUNTS_PROPERTY:
		g_value_set_boolean (value, files_directory_get_has_mounts (self));
		break;
		case FILES_DIRECTORY_HAS_TRASH_DIRS_PROPERTY:
		g_value_set_boolean (value, files_directory_get_has_trash_dirs (self));
		break;
		case FILES_DIRECTORY_CAN_LOAD_PROPERTY:
		g_value_set_boolean (value, files_directory_get_can_load (self));
		break;
		case FILES_DIRECTORY_CAN_OPEN_FILES_PROPERTY:
		g_value_set_boolean (value, files_directory_get_can_open_files (self));
		break;
		case FILES_DIRECTORY_CAN_STREAM_FILES_PROPERTY:
		g_value_set_boolean (value, files_directory_get_can_stream_files (self));
		break;
		case FILES_DIRECTORY_ALLOW_USER_INTERACTION_PROPERTY:
		g_value_set_boolean (value, files_directory_get_allow_user_interaction (self));
		break;
		case FILES_DIRECTORY_IS_CANCELLED_PROPERTY:
		g_value_set_boolean (value, files_directory_get_is_cancelled (self));
		break;
		case FILES_DIRECTORY_LAST_ERROR_MESSAGE_PROPERTY:
		g_value_set_string (value, files_directory_get_last_error_message (self));
		break;
		case FILES_DIRECTORY_LOADED_FROM_CACHE_PROPERTY:
		g_value_set_boolean (value, files_directory_get_loaded_from_cache (self));
		break;
		case FILES_DIRECTORY_FREEZE_UPDATE_PROPERTY:
		g_value_set_boolean (value, files_directory_get_freeze_update (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_files_directory_set_property (GObject * object,
                                    guint property_id,
                                    const GValue * value,
                                    GParamSpec * pspec)
{
	FilesDirectory * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FILES_TYPE_DIRECTORY, FilesDirectory);
	switch (property_id) {
		case FILES_DIRECTORY_CREATION_KEY_PROPERTY:
		files_directory_set_creation_key (self, g_value_get_object (value));
		break;
		case FILES_DIRECTORY_LOCATION_PROPERTY:
		files_directory_set_location (self, g_value_get_object (value));
		break;
		case FILES_DIRECTORY_SELECTED_FILE_PROPERTY:
		files_directory_set_selected_file (self, g_value_get_object (value));
		break;
		case FILES_DIRECTORY_FILE_PROPERTY:
		files_directory_set_file (self, g_value_get_object (value));
		break;
		case FILES_DIRECTORY_STATE_PROPERTY:
		files_directory_set_state (self, g_value_get_enum (value));
		break;
		case FILES_DIRECTORY_DISPLAYED_FILES_COUNT_PROPERTY:
		files_directory_set_displayed_files_count (self, g_value_get_uint (value));
		break;
		case FILES_DIRECTORY_SCHEME_PROPERTY:
		files_directory_set_scheme (self, g_value_get_string (value));
		break;
		case FILES_DIRECTORY_IS_LOCAL_PROPERTY:
		files_directory_set_is_local (self, g_value_get_boolean (value));
		break;
		case FILES_DIRECTORY_IS_TRASH_PROPERTY:
		files_directory_set_is_trash (self, g_value_get_boolean (value));
		break;
		case FILES_DIRECTORY_IS_NETWORK_PROPERTY:
		files_directory_set_is_network (self, g_value_get_boolean (value));
		break;
		case FILES_DIRECTORY_IS_RECENT_PROPERTY:
		files_directory_set_is_recent (self, g_value_get_boolean (value));
		break;
		case FILES_DIRECTORY_IS_ADMIN_PROPERTY:
		files_directory_set_is_admin (self, g_value_get_boolean (value));
		break;
		case FILES_DIRECTORY_IS_NO_INFO_PROPERTY:
		files_directory_set_is_no_info (self, g_value_get_boolean (value));
		break;
		case FILES_DIRECTORY_HAS_MOUNTS_PROPERTY:
		files_directory_set_has_mounts (self, g_value_get_boolean (value));
		break;
		case FILES_DIRECTORY_HAS_TRASH_DIRS_PROPERTY:
		files_directory_set_has_trash_dirs (self, g_value_get_boolean (value));
		break;
		case FILES_DIRECTORY_CAN_LOAD_PROPERTY:
		files_directory_set_can_load (self, g_value_get_boolean (value));
		break;
		case FILES_DIRECTORY_CAN_OPEN_FILES_PROPERTY:
		files_directory_set_can_open_files (self, g_value_get_boolean (value));
		break;
		case FILES_DIRECTORY_CAN_STREAM_FILES_PROPERTY:
		files_directory_set_can_stream_files (self, g_value_get_boolean (value));
		break;
		case FILES_DIRECTORY_ALLOW_USER_INTERACTION_PROPERTY:
		files_directory_set_allow_user_interaction (self, g_value_get_boolean (value));
		break;
		case FILES_DIRECTORY_LAST_ERROR_MESSAGE_PROPERTY:
		files_directory_set_last_error_message (self, g_value_get_string (value));
		break;
		case FILES_DIRECTORY_LOADED_FROM_CACHE_PROPERTY:
		files_directory_set_loaded_from_cache (self, g_value_get_boolean (value));
		break;
		case FILES_DIRECTORY_FREEZE_UPDATE_PROPERTY:
		files_directory_set_freeze_update (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_clear_GMutex (GMutex * mutex)
{
	GMutex zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GMutex))) {
		g_mutex_clear (mutex);
		memset (mutex, 0, sizeof (GMutex));
	}
}

static void
_vala_clear_GRecMutex (GRecMutex * mutex)
{
	GRecMutex zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GRecMutex))) {
		g_rec_mutex_clear (mutex);
		memset (mutex, 0, sizeof (GRecMutex));
	}
}

static void
_vala_clear_GRWLock (GRWLock * mutex)
{
	GRWLock zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GRWLock))) {
		g_rw_lock_clear (mutex);
		memset (mutex, 0, sizeof (GRWLock));
	}
}

static void
_vala_clear_GCond (GCond * mutex)
{
	GCond zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GCond))) {
		g_cond_clear (mutex);
		memset (mutex, 0, sizeof (GCond));
	}
}

