/* FileView.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from FileView.vala, do not modify */

/*-
 * Copyright (c) 2017 - 2024 elementary LLC. (https://elementary.io),
 *               2013 Julien Spautz <spautz.julien@gmail.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
 * PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by: Julien Spautz <spautz.julien@gmail.com>, Andrei-Costin Zisu <matzipan@gmail.com>
 */

#include "codecore.h"
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <gdk/gdk.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	SCRATCH_FOLDER_MANAGER_FILE_VIEW_0_PROPERTY,
	SCRATCH_FOLDER_MANAGER_FILE_VIEW_ACTIONS_PROPERTY,
	SCRATCH_FOLDER_MANAGER_FILE_VIEW_TOPLEVEL_ACTION_GROUP_PROPERTY,
	SCRATCH_FOLDER_MANAGER_FILE_VIEW_ICON_NAME_PROPERTY,
	SCRATCH_FOLDER_MANAGER_FILE_VIEW_TITLE_PROPERTY,
	SCRATCH_FOLDER_MANAGER_FILE_VIEW_NUM_PROPERTIES
};
static GParamSpec* scratch_folder_manager_file_view_properties[SCRATCH_FOLDER_MANAGER_FILE_VIEW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
typedef struct _ScratchFolderManagerFileViewRestoreSavedStateData ScratchFolderManagerFileViewRestoreSavedStateData;
typedef struct _Block11Data Block11Data;
typedef struct _Block12Data Block12Data;
typedef struct _Block13Data Block13Data;
typedef struct _Block14Data Block14Data;
typedef struct _Block15Data Block15Data;
typedef struct _Block16Data Block16Data;
typedef struct _Block17Data Block17Data;
typedef struct _ScratchFolderManagerFileViewAddFolderData ScratchFolderManagerFileViewAddFolderData;
enum  {
	SCRATCH_FOLDER_MANAGER_FILE_VIEW_ACTIVATE_SIGNAL,
	SCRATCH_FOLDER_MANAGER_FILE_VIEW_RENAME_REQUEST_SIGNAL,
	SCRATCH_FOLDER_MANAGER_FILE_VIEW_NUM_SIGNALS
};
static guint scratch_folder_manager_file_view_signals[SCRATCH_FOLDER_MANAGER_FILE_VIEW_NUM_SIGNALS] = {0};
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ScratchFolderManagerFileViewPrivate {
	GSettings* settings;
	ScratchServicesGitManager* git_manager;
	ScratchServicesPluginsManager* plugins;
	GSimpleActionGroup* _actions;
	GActionGroup* _toplevel_action_group;
	gchar* _icon_name;
	gchar* _title;
};

struct _ScratchFolderManagerFileViewRestoreSavedStateData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ScratchFolderManagerFileView* self;
	GSettings* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gchar** path_collection;
	gint path_collection_length1;
	gint _path_collection_size_;
	gint path_it;
	const gchar* path;
	const gchar* _tmp3_;
	ScratchFolderManagerFile* _tmp4_;
	ScratchFolderManagerFile* _tmp5_;
};

struct _Block11Data {
	int _ref_count_;
	ScratchFolderManagerFileView* self;
	gchar* path;
};

struct _Block12Data {
	int _ref_count_;
	Block11Data * _data11_;
	gulong once;
};

struct _Block13Data {
	int _ref_count_;
	ScratchFolderManagerFileView* self;
	ScratchFolderManagerFolderItem* folder_to_rename;
};

struct _Block14Data {
	int _ref_count_;
	ScratchFolderManagerFileView* self;
	ScratchFolderManagerItem* item_to_delete;
};

struct _Block15Data {
	int _ref_count_;
	ScratchFolderManagerFileView* self;
	ScratchFolderManagerFile* folder;
	gboolean expand;
	gpointer _async_data_;
};

struct _Block16Data {
	int _ref_count_;
	Block15Data * _data15_;
	ScratchDialogsCloseProjectsConfirmationDialog* dialog;
	gboolean close_projects;
};

struct _Block17Data {
	int _ref_count_;
	Block15Data * _data15_;
	ScratchFolderManagerProjectFolderItem* folder_root;
};

struct _ScratchFolderManagerFileViewAddFolderData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ScratchFolderManagerFileView* self;
	ScratchFolderManagerFile* folder;
	gboolean expand;
	Block15Data* _data15_;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	GFile* add_file;
	GFile* _tmp5_;
	GFile* _tmp6_;
	GFile* _tmp7_;
	GList* parents;
	GList* children;
	GeeIterator* _child_it;
	CodeWidgetsSourceListExpandableItem* _tmp8_;
	CodeWidgetsSourceListExpandableItem* _tmp9_;
	GeeCollection* _tmp10_;
	GeeCollection* _tmp11_;
	GeeCollection* _tmp12_;
	GeeIterator* _tmp13_;
	GeeIterator* _tmp14_;
	GeeIterator* _tmp15_;
	CodeWidgetsSourceListItem* child;
	GeeIterator* _tmp16_;
	gpointer _tmp17_;
	ScratchFolderManagerProjectFolderItem* item;
	CodeWidgetsSourceListItem* _tmp18_;
	ScratchFolderManagerProjectFolderItem* _tmp19_;
	GFile* _tmp20_;
	ScratchFolderManagerProjectFolderItem* _tmp21_;
	ScratchFolderManagerFile* _tmp22_;
	ScratchFolderManagerFile* _tmp23_;
	GFile* _tmp24_;
	GFile* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	gboolean _tmp28_;
	ScratchFolderManagerProjectFolderItem* _tmp29_;
	ScratchFolderManagerProjectFolderItem* _tmp30_;
	ScratchFolderManagerProjectFolderItem* _tmp31_;
	ScratchFolderManagerFile* _tmp32_;
	ScratchFolderManagerFile* _tmp33_;
	GFile* _tmp34_;
	GFile* _tmp35_;
	GFile* _tmp36_;
	gchar* _tmp37_;
	gchar* _tmp38_;
	gboolean _tmp39_;
	ScratchFolderManagerProjectFolderItem* _tmp40_;
	ScratchFolderManagerProjectFolderItem* _tmp41_;
	gboolean _tmp42_;
	GList* _tmp43_;
	GList* _tmp44_;
	Block16Data* _data16_;
	GList* _tmp45_;
	gboolean _tmp46_;
	GList* _tmp47_;
	GList* _tmp48_;
	GtkWidget* _tmp49_;
	GList* _tmp50_;
	GList* _tmp51_;
	ScratchDialogsCloseProjectsConfirmationDialog* _tmp52_;
	ScratchDialogsCloseProjectsConfirmationDialog* _tmp53_;
	ScratchDialogsCloseProjectsConfirmationDialog* _tmp54_;
	GList* _tmp55_;
	GList* item_collection;
	GList* item_it;
	ScratchFolderManagerProjectFolderItem* _tmp56_;
	ScratchFolderManagerProjectFolderItem* _vala1_item;
	ScratchFolderManagerProjectFolderItem* _tmp57_;
	GList* _tmp58_;
	GList* _vala1_item_collection;
	GList* _vala1_item_it;
	ScratchFolderManagerProjectFolderItem* _tmp59_;
	ScratchFolderManagerProjectFolderItem* _vala2_item;
	ScratchFolderManagerProjectFolderItem* _tmp60_;
};

static gint ScratchFolderManagerFileView_private_offset;
static gpointer scratch_folder_manager_file_view_parent_class = NULL;
static CodePaneSwitcherIface * scratch_folder_manager_file_view_code_pane_switcher_parent_iface = NULL;

static void scratch_folder_manager_file_view_action_launch_app_with_file_path (ScratchFolderManagerFileView* self,
                                                                        GSimpleAction* action,
                                                                        GVariant* param);
static void _scratch_folder_manager_file_view_action_launch_app_with_file_path_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                                          GVariant* parameter,
                                                                                                          gpointer self);
static void scratch_folder_manager_file_view_action_show_app_chooser (ScratchFolderManagerFileView* self,
                                                               GSimpleAction* action,
                                                               GVariant* param);
static void _scratch_folder_manager_file_view_action_show_app_chooser_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                                 GVariant* parameter,
                                                                                                 gpointer self);
static void scratch_folder_manager_file_view_action_execute_contract_with_file_path (ScratchFolderManagerFileView* self,
                                                                              GSimpleAction* action,
                                                                              GVariant* param);
static void _scratch_folder_manager_file_view_action_execute_contract_with_file_path_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                                                GVariant* parameter,
                                                                                                                gpointer self);
static void scratch_folder_manager_file_view_action_rename_file (ScratchFolderManagerFileView* self,
                                                          GSimpleAction* action,
                                                          GVariant* param);
static void _scratch_folder_manager_file_view_action_rename_file_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                            GVariant* parameter,
                                                                                            gpointer self);
static void scratch_folder_manager_file_view_action_rename_folder (ScratchFolderManagerFileView* self,
                                                            GSimpleAction* action,
                                                            GVariant* param);
static void _scratch_folder_manager_file_view_action_rename_folder_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                              GVariant* parameter,
                                                                                              gpointer self);
static void scratch_folder_manager_file_view_action_delete (ScratchFolderManagerFileView* self,
                                                     GSimpleAction* action,
                                                     GVariant* param);
static void _scratch_folder_manager_file_view_action_delete_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                       GVariant* parameter,
                                                                                       gpointer self);
static void scratch_folder_manager_file_view_add_new_file (ScratchFolderManagerFileView* self,
                                                    GSimpleAction* action,
                                                    GVariant* param);
static void _scratch_folder_manager_file_view_add_new_file_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                      GVariant* parameter,
                                                                                      gpointer self);
static void scratch_folder_manager_file_view_add_new_folder (ScratchFolderManagerFileView* self,
                                                      GSimpleAction* action,
                                                      GVariant* param);
static void _scratch_folder_manager_file_view_add_new_folder_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                        GVariant* parameter,
                                                                                        gpointer self);
static void scratch_folder_manager_file_view_action_close_folder (ScratchFolderManagerFileView* self,
                                                           GSimpleAction* action,
                                                           GVariant* parameter);
static void _scratch_folder_manager_file_view_action_close_folder_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                             GVariant* parameter,
                                                                                             gpointer self);
static void scratch_folder_manager_file_view_action_close_other_folders (ScratchFolderManagerFileView* self,
                                                                  GSimpleAction* action,
                                                                  GVariant* parameter);
static void _scratch_folder_manager_file_view_action_close_other_folders_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                                    GVariant* parameter,
                                                                                                    gpointer self);
static void scratch_folder_manager_file_view_action_set_active_project (ScratchFolderManagerFileView* self,
                                                                 GSimpleAction* action,
                                                                 GVariant* parameter);
static void _scratch_folder_manager_file_view_action_set_active_project_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                                   GVariant* parameter,
                                                                                                   gpointer self);
static CodeWidgetsSourceListItem* scratch_folder_manager_file_view_find_path (ScratchFolderManagerFileView* self,
                                                                       CodeWidgetsSourceListExpandableItem* list,
                                                                       const gchar* path,
                                                                       gboolean expand);
static void scratch_folder_manager_file_view_write_settings (ScratchFolderManagerFileView* self);
static void scratch_folder_manager_file_view_restore_saved_state_data_free (gpointer _data);
static gboolean scratch_folder_manager_file_view_restore_saved_state_co (ScratchFolderManagerFileViewRestoreSavedStateData* _data_);
static void scratch_folder_manager_file_view_add_folder (ScratchFolderManagerFileView* self,
                                                  ScratchFolderManagerFile* folder,
                                                  gboolean expand,
                                                  GAsyncReadyCallback _callback_,
                                                  gpointer _user_data_);
static void scratch_folder_manager_file_view_add_folder_finish (ScratchFolderManagerFileView* self,
                                                         GAsyncResult* _res_);
static void scratch_folder_manager_file_view_restore_saved_state_ready (GObject* source_object,
                                                                 GAsyncResult* _res_,
                                                                 gpointer _user_data_);
static gboolean scratch_folder_manager_file_view_is_open (ScratchFolderManagerFileView* self,
                                                   ScratchFolderManagerFile* folder);
static gint __lambda95_ (ScratchFolderManagerFileView* self,
                  ScratchFolderManagerProjectFolderItem* a,
                  ScratchFolderManagerProjectFolderItem* b);
static gint ___lambda95__gcompare_data_func (gconstpointer a,
                                      gconstpointer b,
                                      gpointer self);
static void scratch_folder_manager_file_view_rename_file (ScratchFolderManagerFileView* self,
                                                   const gchar* path);
static Block11Data* block11_data_ref (Block11Data* _data11_);
static void block11_data_unref (void * _userdata_);
static Block12Data* block12_data_ref (Block12Data* _data12_);
static void block12_data_unref (void * _userdata_);
static void ___lambda85_ (Block12Data* _data12_,
                   const gchar* new_name);
static void ____lambda85__code_widgets_source_list_item_edited (CodeWidgetsSourceListItem* _sender,
                                                         const gchar* new_name,
                                                         gpointer self);
static gboolean __lambda86_ (ScratchFolderManagerFileView* self);
static gboolean ___lambda86__gsource_func (gpointer self);
static void scratch_folder_manager_file_view_rename_folder (ScratchFolderManagerFileView* self,
                                                     const gchar* path);
static Block13Data* block13_data_ref (Block13Data* _data13_);
static void block13_data_unref (void * _userdata_);
static gboolean ___lambda87_ (Block13Data* _data13_);
static gboolean ____lambda87__gsource_func (gpointer self);
static void scratch_folder_manager_file_view_rename_items_with_same_name (ScratchFolderManagerFileView* self,
                                                                   ScratchFolderManagerItem* item);
static Block14Data* block14_data_ref (Block14Data* _data14_);
static void block14_data_unref (void * _userdata_);
static void ____lambda88_ (Block14Data* _data14_);
static void _____lambda88__scratch_folder_manager_project_folder_item_closed (ScratchFolderManagerProjectFolderItem* _sender,
                                                                       gpointer self);
static void scratch_folder_manager_file_view_add_folder_data_free (gpointer _data);
static gboolean scratch_folder_manager_file_view_add_folder_co (ScratchFolderManagerFileViewAddFolderData* _data_);
static Block15Data* block15_data_ref (Block15Data* _data15_);
static void block15_data_unref (void * _userdata_);
static Block16Data* block16_data_ref (Block16Data* _data16_);
static void block16_data_unref (void * _userdata_);
static void ___lambda92_ (Block16Data* _data16_,
                   gint res);
static void ____lambda92__gtk_dialog_response (GtkDialog* _sender,
                                        gint response_id,
                                        gpointer self);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static gboolean __lambda93_ (Block15Data* _data15_);
static Block17Data* block17_data_ref (Block17Data* _data17_);
static void block17_data_unref (void * _userdata_);
static void __lambda94_ (Block17Data* _data17_);
static void ___lambda94__scratch_folder_manager_project_folder_item_closed (ScratchFolderManagerProjectFolderItem* _sender,
                                                                     gpointer self);
static gboolean ___lambda93__gsource_func (gpointer self);
static void _vala_array_add3 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void scratch_folder_manager_file_view_set_actions (ScratchFolderManagerFileView* self,
                                                   GSimpleActionGroup* value);
static void scratch_folder_manager_file_view_set_toplevel_action_group (ScratchFolderManagerFileView* self,
                                                                 GActionGroup* value);
static void g_cclosure_user_marshal_BOOLEAN__OBJECT (GClosure * closure,
                                              GValue * return_value,
                                              guint n_param_values,
                                              const GValue * param_values,
                                              gpointer invocation_hint,
                                              gpointer marshal_data);
static GObject * scratch_folder_manager_file_view_constructor (GType type,
                                                        guint n_construct_properties,
                                                        GObjectConstructParam * construct_properties);
static void _scratch_folder_manager_file_view___lambda101_ (ScratchFolderManagerFileView* self);
static void __scratch_folder_manager_file_view___lambda101__gtk_widget_realize (GtkWidget* _sender,
                                                                         gpointer self);
static void scratch_folder_manager_file_view_finalize (GObject * obj);
static GType scratch_folder_manager_file_view_get_type_once (void);
static void _vala_scratch_folder_manager_file_view_get_property (GObject * object,
                                                          guint property_id,
                                                          GValue * value,
                                                          GParamSpec * pspec);
static void _vala_scratch_folder_manager_file_view_set_property (GObject * object,
                                                          guint property_id,
                                                          const GValue * value,
                                                          GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static const GActionEntry SCRATCH_FOLDER_MANAGER_FILE_VIEW_ACTION_ENTRIES[11] = {{SCRATCH_FOLDER_MANAGER_FILE_VIEW_ACTION_LAUNCH_APP_WITH_FILE_PATH, _scratch_folder_manager_file_view_action_launch_app_with_file_path_gsimple_action_activate_callback, "as"}, {SCRATCH_FOLDER_MANAGER_FILE_VIEW_ACTION_SHOW_APP_CHOOSER, _scratch_folder_manager_file_view_action_show_app_chooser_gsimple_action_activate_callback, "s"}, {SCRATCH_FOLDER_MANAGER_FILE_VIEW_ACTION_EXECUTE_CONTRACT_WITH_FILE_PATH, _scratch_folder_manager_file_view_action_execute_contract_with_file_path_gsimple_action_activate_callback, "as"}, {SCRATCH_FOLDER_MANAGER_FILE_VIEW_ACTION_RENAME_FILE, _scratch_folder_manager_file_view_action_rename_file_gsimple_action_activate_callback, "s"}, {SCRATCH_FOLDER_MANAGER_FILE_VIEW_ACTION_RENAME_FOLDER, _scratch_folder_manager_file_view_action_rename_folder_gsimple_action_activate_callback, "s"}, {SCRATCH_FOLDER_MANAGER_FILE_VIEW_ACTION_DELETE, _scratch_folder_manager_file_view_action_delete_gsimple_action_activate_callback, "s"}, {SCRATCH_FOLDER_MANAGER_FILE_VIEW_ACTION_NEW_FILE, _scratch_folder_manager_file_view_add_new_file_gsimple_action_activate_callback, "s"}, {SCRATCH_FOLDER_MANAGER_FILE_VIEW_ACTION_NEW_FOLDER, _scratch_folder_manager_file_view_add_new_folder_gsimple_action_activate_callback, "s"}, {SCRATCH_FOLDER_MANAGER_FILE_VIEW_ACTION_CLOSE_FOLDER, _scratch_folder_manager_file_view_action_close_folder_gsimple_action_activate_callback, "s"}, {SCRATCH_FOLDER_MANAGER_FILE_VIEW_ACTION_CLOSE_OTHER_FOLDERS, _scratch_folder_manager_file_view_action_close_other_folders_gsimple_action_activate_callback, "s"}, {SCRATCH_FOLDER_MANAGER_FILE_VIEW_ACTION_SET_ACTIVE_PROJECT, _scratch_folder_manager_file_view_action_set_active_project_gsimple_action_activate_callback, "s"}};

static inline gpointer
scratch_folder_manager_file_view_get_instance_private (ScratchFolderManagerFileView* self)
{
	return G_STRUCT_MEMBER_P (self, ScratchFolderManagerFileView_private_offset);
}

static void
_scratch_folder_manager_file_view_action_launch_app_with_file_path_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                                     GVariant* parameter,
                                                                                                     gpointer self)
{
	scratch_folder_manager_file_view_action_launch_app_with_file_path ((ScratchFolderManagerFileView*) self, action, parameter);
}

static void
_scratch_folder_manager_file_view_action_show_app_chooser_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                            GVariant* parameter,
                                                                                            gpointer self)
{
	scratch_folder_manager_file_view_action_show_app_chooser ((ScratchFolderManagerFileView*) self, action, parameter);
}

static void
_scratch_folder_manager_file_view_action_execute_contract_with_file_path_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                                           GVariant* parameter,
                                                                                                           gpointer self)
{
	scratch_folder_manager_file_view_action_execute_contract_with_file_path ((ScratchFolderManagerFileView*) self, action, parameter);
}

static void
_scratch_folder_manager_file_view_action_rename_file_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                       GVariant* parameter,
                                                                                       gpointer self)
{
	scratch_folder_manager_file_view_action_rename_file ((ScratchFolderManagerFileView*) self, action, parameter);
}

static void
_scratch_folder_manager_file_view_action_rename_folder_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                         GVariant* parameter,
                                                                                         gpointer self)
{
	scratch_folder_manager_file_view_action_rename_folder ((ScratchFolderManagerFileView*) self, action, parameter);
}

static void
_scratch_folder_manager_file_view_action_delete_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                  GVariant* parameter,
                                                                                  gpointer self)
{
	scratch_folder_manager_file_view_action_delete ((ScratchFolderManagerFileView*) self, action, parameter);
}

static void
_scratch_folder_manager_file_view_add_new_file_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                 GVariant* parameter,
                                                                                 gpointer self)
{
	scratch_folder_manager_file_view_add_new_file ((ScratchFolderManagerFileView*) self, action, parameter);
}

static void
_scratch_folder_manager_file_view_add_new_folder_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                   GVariant* parameter,
                                                                                   gpointer self)
{
	scratch_folder_manager_file_view_add_new_folder ((ScratchFolderManagerFileView*) self, action, parameter);
}

static void
_scratch_folder_manager_file_view_action_close_folder_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                        GVariant* parameter,
                                                                                        gpointer self)
{
	scratch_folder_manager_file_view_action_close_folder ((ScratchFolderManagerFileView*) self, action, parameter);
}

static void
_scratch_folder_manager_file_view_action_close_other_folders_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                               GVariant* parameter,
                                                                                               gpointer self)
{
	scratch_folder_manager_file_view_action_close_other_folders ((ScratchFolderManagerFileView*) self, action, parameter);
}

static void
_scratch_folder_manager_file_view_action_set_active_project_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                              GVariant* parameter,
                                                                                              gpointer self)
{
	scratch_folder_manager_file_view_action_set_active_project ((ScratchFolderManagerFileView*) self, action, parameter);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

ScratchFolderManagerFileView*
scratch_folder_manager_file_view_construct (GType object_type,
                                            ScratchServicesPluginsManager* plugins_manager)
{
	ScratchFolderManagerFileView * self = NULL;
	CodeWidgetsSourceListExpandableItem* _tmp0_;
	CodeWidgetsSourceListExpandableItem* _tmp1_;
	ScratchServicesPluginsManager* _tmp2_;
	g_return_val_if_fail (plugins_manager != NULL, NULL);
	_tmp0_ = code_widgets_source_list_expandable_item_new ("");
	_tmp1_ = _tmp0_;
	self = (ScratchFolderManagerFileView*) code_widgets_source_list_construct (object_type, _tmp1_);
	_g_object_unref0 (_tmp1_);
	_tmp2_ = _g_object_ref0 (plugins_manager);
	_g_object_unref0 (self->priv->plugins);
	self->priv->plugins = _tmp2_;
	return self;
}

ScratchFolderManagerFileView*
scratch_folder_manager_file_view_new (ScratchServicesPluginsManager* plugins_manager)
{
	return scratch_folder_manager_file_view_construct (SCRATCH_FOLDER_MANAGER_TYPE_FILE_VIEW, plugins_manager);
}

static void
scratch_folder_manager_file_view_action_close_folder (ScratchFolderManagerFileView* self,
                                                      GSimpleAction* action,
                                                      GVariant* parameter)
{
	gchar* path = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	ScratchFolderManagerProjectFolderItem* project_item = NULL;
	CodeWidgetsSourceListExpandableItem* _tmp5_;
	CodeWidgetsSourceListExpandableItem* _tmp6_;
	const gchar* _tmp7_;
	CodeWidgetsSourceListItem* _tmp8_;
	ScratchFolderManagerProjectFolderItem* _tmp9_;
	ScratchFolderManagerProjectFolderItem* _tmp10_;
	ScratchFolderManagerProjectFolderItem* _tmp11_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = g_variant_get_string (parameter, NULL);
	_tmp1_ = g_strdup (_tmp0_);
	path = _tmp1_;
	_tmp3_ = path;
	if (_tmp3_ == NULL) {
		_tmp2_ = TRUE;
	} else {
		const gchar* _tmp4_;
		_tmp4_ = path;
		_tmp2_ = g_strcmp0 (_tmp4_, "") == 0;
	}
	if (_tmp2_) {
		_g_free0 (path);
		return;
	}
	_tmp5_ = code_widgets_source_list_get_root ((CodeWidgetsSourceList*) self);
	_tmp6_ = _tmp5_;
	_tmp7_ = path;
	_tmp8_ = scratch_folder_manager_file_view_find_path (self, _tmp6_, _tmp7_, FALSE);
	_tmp9_ = _g_object_ref0 (SCRATCH_FOLDER_MANAGER_IS_PROJECT_FOLDER_ITEM (_tmp8_) ? ((ScratchFolderManagerProjectFolderItem*) _tmp8_) : NULL);
	project_item = _tmp9_;
	_tmp10_ = project_item;
	if (_tmp10_ == NULL) {
		_g_object_unref0 (project_item);
		_g_free0 (path);
		return;
	}
	_tmp11_ = project_item;
	g_signal_emit_by_name (_tmp11_, "closed");
	_g_object_unref0 (project_item);
	_g_free0 (path);
}

static void
scratch_folder_manager_file_view_action_close_other_folders (ScratchFolderManagerFileView* self,
                                                             GSimpleAction* action,
                                                             GVariant* parameter)
{
	gchar* path = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	ScratchFolderManagerProjectFolderItem* folder_root = NULL;
	CodeWidgetsSourceListExpandableItem* _tmp5_;
	CodeWidgetsSourceListExpandableItem* _tmp6_;
	const gchar* _tmp7_;
	CodeWidgetsSourceListItem* _tmp8_;
	ScratchFolderManagerProjectFolderItem* _tmp9_;
	ScratchFolderManagerProjectFolderItem* _tmp10_;
	ScratchServicesGitManager* _tmp37_;
	const gchar* _tmp38_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = g_variant_get_string (parameter, NULL);
	_tmp1_ = g_strdup (_tmp0_);
	path = _tmp1_;
	_tmp3_ = path;
	if (_tmp3_ == NULL) {
		_tmp2_ = TRUE;
	} else {
		const gchar* _tmp4_;
		_tmp4_ = path;
		_tmp2_ = g_strcmp0 (_tmp4_, "") == 0;
	}
	if (_tmp2_) {
		_g_free0 (path);
		return;
	}
	_tmp5_ = code_widgets_source_list_get_root ((CodeWidgetsSourceList*) self);
	_tmp6_ = _tmp5_;
	_tmp7_ = path;
	_tmp8_ = scratch_folder_manager_file_view_find_path (self, _tmp6_, _tmp7_, FALSE);
	_tmp9_ = _g_object_ref0 (SCRATCH_FOLDER_MANAGER_IS_PROJECT_FOLDER_ITEM (_tmp8_) ? ((ScratchFolderManagerProjectFolderItem*) _tmp8_) : NULL);
	folder_root = _tmp9_;
	_tmp10_ = folder_root;
	if (_tmp10_ == NULL) {
		_g_object_unref0 (folder_root);
		_g_free0 (path);
		return;
	}
	{
		GeeIterator* _child_it = NULL;
		CodeWidgetsSourceListExpandableItem* _tmp11_;
		CodeWidgetsSourceListExpandableItem* _tmp12_;
		GeeCollection* _tmp13_;
		GeeCollection* _tmp14_;
		GeeCollection* _tmp15_;
		GeeIterator* _tmp16_;
		GeeIterator* _tmp17_;
		_tmp11_ = code_widgets_source_list_get_root ((CodeWidgetsSourceList*) self);
		_tmp12_ = _tmp11_;
		_tmp13_ = code_widgets_source_list_expandable_item_get_children (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = _tmp14_;
		_tmp16_ = gee_iterable_iterator ((GeeIterable*) _tmp15_);
		_tmp17_ = _tmp16_;
		_g_object_unref0 (_tmp15_);
		_child_it = _tmp17_;
		while (TRUE) {
			GeeIterator* _tmp18_;
			CodeWidgetsSourceListItem* child = NULL;
			GeeIterator* _tmp19_;
			gpointer _tmp20_;
			ScratchFolderManagerProjectFolderItem* project_folder_item = NULL;
			CodeWidgetsSourceListItem* _tmp21_;
			ScratchFolderManagerProjectFolderItem* _tmp22_;
			ScratchFolderManagerProjectFolderItem* _tmp23_;
			ScratchFolderManagerProjectFolderItem* _tmp24_;
			_tmp18_ = _child_it;
			if (!gee_iterator_next (_tmp18_)) {
				break;
			}
			_tmp19_ = _child_it;
			_tmp20_ = gee_iterator_get (_tmp19_);
			child = (CodeWidgetsSourceListItem*) _tmp20_;
			_tmp21_ = child;
			_tmp22_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, SCRATCH_FOLDER_MANAGER_TYPE_PROJECT_FOLDER_ITEM, ScratchFolderManagerProjectFolderItem));
			project_folder_item = _tmp22_;
			_tmp23_ = project_folder_item;
			_tmp24_ = folder_root;
			if (_tmp23_ != _tmp24_) {
				GActionGroup* _tmp25_;
				ScratchFolderManagerProjectFolderItem* _tmp26_;
				gchar* _tmp27_;
				gchar* _tmp28_;
				gchar* _tmp29_;
				GVariant* _tmp30_;
				GVariant* _tmp31_;
				CodeWidgetsSourceListExpandableItem* _tmp32_;
				CodeWidgetsSourceListExpandableItem* _tmp33_;
				ScratchFolderManagerProjectFolderItem* _tmp34_;
				ScratchServicesGitManager* _tmp35_;
				ScratchFolderManagerProjectFolderItem* _tmp36_;
				_tmp25_ = self->priv->_toplevel_action_group;
				_tmp26_ = project_folder_item;
				_tmp27_ = scratch_folder_manager_item_get_path ((ScratchFolderManagerItem*) _tmp26_);
				_tmp28_ = _tmp27_;
				_tmp29_ = _tmp28_;
				_tmp30_ = g_variant_new_string (_tmp29_);
				g_variant_ref_sink (_tmp30_);
				_tmp31_ = _tmp30_;
				g_action_group_activate_action (_tmp25_, SCRATCH_MAIN_WINDOW_ACTION_CLOSE_PROJECT_DOCS, _tmp31_);
				_g_variant_unref0 (_tmp31_);
				_g_free0 (_tmp29_);
				_tmp32_ = code_widgets_source_list_get_root ((CodeWidgetsSourceList*) self);
				_tmp33_ = _tmp32_;
				_tmp34_ = project_folder_item;
				code_widgets_source_list_expandable_item_remove (_tmp33_, (CodeWidgetsSourceListItem*) _tmp34_);
				_tmp35_ = self->priv->git_manager;
				_tmp36_ = project_folder_item;
				scratch_services_git_manager_remove_project (_tmp35_, _tmp36_);
			}
			_g_object_unref0 (project_folder_item);
			_g_object_unref0 (child);
		}
		_g_object_unref0 (_child_it);
	}
	_tmp37_ = self->priv->git_manager;
	_tmp38_ = path;
	scratch_services_git_manager_set_active_project_path (_tmp37_, _tmp38_);
	scratch_folder_manager_file_view_write_settings (self);
	_g_object_unref0 (folder_root);
	_g_free0 (path);
}

static void
scratch_folder_manager_file_view_action_set_active_project (ScratchFolderManagerFileView* self,
                                                            GSimpleAction* action,
                                                            GVariant* parameter)
{
	gchar* path = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	ScratchFolderManagerProjectFolderItem* folder_root = NULL;
	CodeWidgetsSourceListExpandableItem* _tmp5_;
	CodeWidgetsSourceListExpandableItem* _tmp6_;
	const gchar* _tmp7_;
	CodeWidgetsSourceListItem* _tmp8_;
	ScratchFolderManagerProjectFolderItem* _tmp9_;
	ScratchFolderManagerProjectFolderItem* _tmp10_;
	ScratchServicesGitManager* _tmp11_;
	const gchar* _tmp12_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = g_variant_get_string (parameter, NULL);
	_tmp1_ = g_strdup (_tmp0_);
	path = _tmp1_;
	_tmp3_ = path;
	if (_tmp3_ == NULL) {
		_tmp2_ = TRUE;
	} else {
		const gchar* _tmp4_;
		_tmp4_ = path;
		_tmp2_ = g_strcmp0 (_tmp4_, "") == 0;
	}
	if (_tmp2_) {
		_g_free0 (path);
		return;
	}
	_tmp5_ = code_widgets_source_list_get_root ((CodeWidgetsSourceList*) self);
	_tmp6_ = _tmp5_;
	_tmp7_ = path;
	_tmp8_ = scratch_folder_manager_file_view_find_path (self, _tmp6_, _tmp7_, FALSE);
	_tmp9_ = _g_object_ref0 (SCRATCH_FOLDER_MANAGER_IS_PROJECT_FOLDER_ITEM (_tmp8_) ? ((ScratchFolderManagerProjectFolderItem*) _tmp8_) : NULL);
	folder_root = _tmp9_;
	_tmp10_ = folder_root;
	if (_tmp10_ == NULL) {
		_g_object_unref0 (folder_root);
		_g_free0 (path);
		return;
	}
	_tmp11_ = self->priv->git_manager;
	_tmp12_ = path;
	scratch_services_git_manager_set_active_project_path (_tmp11_, _tmp12_);
	scratch_folder_manager_file_view_write_settings (self);
	_g_object_unref0 (folder_root);
	_g_free0 (path);
}

static void
scratch_folder_manager_file_view_restore_saved_state_data_free (gpointer _data)
{
	ScratchFolderManagerFileViewRestoreSavedStateData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (ScratchFolderManagerFileViewRestoreSavedStateData, _data_);
}

void
scratch_folder_manager_file_view_restore_saved_state (ScratchFolderManagerFileView* self,
                                                      GAsyncReadyCallback _callback_,
                                                      gpointer _user_data_)
{
	ScratchFolderManagerFileViewRestoreSavedStateData* _data_;
	ScratchFolderManagerFileView* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (ScratchFolderManagerFileViewRestoreSavedStateData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, scratch_folder_manager_file_view_restore_saved_state_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	scratch_folder_manager_file_view_restore_saved_state_co (_data_);
}

void
scratch_folder_manager_file_view_restore_saved_state_finish (ScratchFolderManagerFileView* self,
                                                             GAsyncResult* _res_)
{
	ScratchFolderManagerFileViewRestoreSavedStateData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
scratch_folder_manager_file_view_restore_saved_state_ready (GObject* source_object,
                                                            GAsyncResult* _res_,
                                                            gpointer _user_data_)
{
	ScratchFolderManagerFileViewRestoreSavedStateData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	scratch_folder_manager_file_view_restore_saved_state_co (_data_);
}

static gboolean
scratch_folder_manager_file_view_restore_saved_state_co (ScratchFolderManagerFileViewRestoreSavedStateData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->settings;
	_data_->_tmp2_ = _data_->_tmp1_ = g_settings_get_strv (_data_->_tmp0_, "opened-folders");
	{
		_data_->path_collection_length1 = 0;
		_data_->_path_collection_size_ = 0;
		_data_->path_collection = _data_->_tmp2_;
		_data_->path_collection_length1 = _vala_array_length (_data_->_tmp1_);
		for (_data_->path_it = 0; _data_->path_it < _data_->path_collection_length1; _data_->path_it = _data_->path_it + 1) {
			_data_->path = _data_->path_collection[_data_->path_it];
			{
				_data_->_tmp3_ = _data_->path;
				_data_->_tmp4_ = scratch_folder_manager_file_new (_data_->_tmp3_);
				_data_->_tmp5_ = _data_->_tmp4_;
				_data_->_state_ = 1;
				scratch_folder_manager_file_view_add_folder (_data_->self, _data_->_tmp5_, FALSE, scratch_folder_manager_file_view_restore_saved_state_ready, _data_);
				return FALSE;
				_state_1:
				scratch_folder_manager_file_view_add_folder_finish (_data_->self, _data_->_res_);
				_g_object_unref0 (_data_->_tmp5_);
			}
		}
		_data_->path_collection = (_vala_array_free (_data_->path_collection, _data_->path_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

void
scratch_folder_manager_file_view_open_folder (ScratchFolderManagerFileView* self,
                                              ScratchFolderManagerFile* folder)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (folder != NULL);
	if (scratch_folder_manager_file_view_is_open (self, folder)) {
		CodeWidgetsSourceListItem* existing = NULL;
		CodeWidgetsSourceListExpandableItem* _tmp0_;
		CodeWidgetsSourceListExpandableItem* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		CodeWidgetsSourceListItem* _tmp5_;
		CodeWidgetsSourceListItem* _tmp6_;
		CodeWidgetsSourceListItem* _tmp7_;
		CodeWidgetsSourceListItem* _tmp8_;
		_tmp0_ = code_widgets_source_list_get_root ((CodeWidgetsSourceList*) self);
		_tmp1_ = _tmp0_;
		_tmp2_ = scratch_folder_manager_file_get_path (folder);
		_tmp3_ = _tmp2_;
		_tmp4_ = _tmp3_;
		_tmp5_ = scratch_folder_manager_file_view_find_path (self, _tmp1_, _tmp4_, FALSE);
		_tmp6_ = _g_object_ref0 (_tmp5_);
		_tmp7_ = _tmp6_;
		_g_free0 (_tmp4_);
		existing = _tmp7_;
		_tmp8_ = existing;
		if (CODE_WIDGETS_SOURCE_LIST_IS_EXPANDABLE_ITEM (_tmp8_)) {
			CodeWidgetsSourceListItem* _tmp9_;
			_tmp9_ = existing;
			code_widgets_source_list_expandable_item_set_expanded (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, CODE_WIDGETS_SOURCE_LIST_TYPE_EXPANDABLE_ITEM, CodeWidgetsSourceListExpandableItem), TRUE);
		}
		_g_object_unref0 (existing);
		return;
	}
	scratch_folder_manager_file_view_add_folder (self, folder, TRUE, NULL, NULL);
}

void
scratch_folder_manager_file_view_collapse_all (ScratchFolderManagerFileView* self)
{
	g_return_if_fail (self != NULL);
	{
		GeeIterator* _child_it = NULL;
		CodeWidgetsSourceListExpandableItem* _tmp0_;
		CodeWidgetsSourceListExpandableItem* _tmp1_;
		GeeCollection* _tmp2_;
		GeeCollection* _tmp3_;
		GeeCollection* _tmp4_;
		GeeIterator* _tmp5_;
		GeeIterator* _tmp6_;
		_tmp0_ = code_widgets_source_list_get_root ((CodeWidgetsSourceList*) self);
		_tmp1_ = _tmp0_;
		_tmp2_ = code_widgets_source_list_expandable_item_get_children (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = _tmp3_;
		_tmp5_ = gee_iterable_iterator ((GeeIterable*) _tmp4_);
		_tmp6_ = _tmp5_;
		_g_object_unref0 (_tmp4_);
		_child_it = _tmp6_;
		while (TRUE) {
			GeeIterator* _tmp7_;
			CodeWidgetsSourceListItem* child = NULL;
			GeeIterator* _tmp8_;
			gpointer _tmp9_;
			CodeWidgetsSourceListItem* _tmp10_;
			_tmp7_ = _child_it;
			if (!gee_iterator_next (_tmp7_)) {
				break;
			}
			_tmp8_ = _child_it;
			_tmp9_ = gee_iterator_get (_tmp8_);
			child = (CodeWidgetsSourceListItem*) _tmp9_;
			_tmp10_ = child;
			code_widgets_source_list_expandable_item_collapse_all ((CodeWidgetsSourceListExpandableItem*) G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, SCRATCH_FOLDER_MANAGER_TYPE_PROJECT_FOLDER_ITEM, ScratchFolderManagerProjectFolderItem), TRUE, TRUE);
			_g_object_unref0 (child);
		}
		_g_object_unref0 (_child_it);
	}
}

static gint
__lambda95_ (ScratchFolderManagerFileView* self,
             ScratchFolderManagerProjectFolderItem* a,
             ScratchFolderManagerProjectFolderItem* b)
{
	gint _tmp0_ = 0;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gboolean _tmp9_;
	gint result;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp1_ = code_widgets_source_list_item_get_name ((CodeWidgetsSourceListItem*) a);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_utf8_strdown (_tmp2_, (gssize) -1);
	_tmp4_ = _tmp3_;
	_tmp5_ = code_widgets_source_list_item_get_name ((CodeWidgetsSourceListItem*) b);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_utf8_strdown (_tmp6_, (gssize) -1);
	_tmp8_ = _tmp7_;
	_tmp9_ = g_strcmp0 (_tmp4_, _tmp8_) > 0;
	_g_free0 (_tmp8_);
	_g_free0 (_tmp4_);
	if (_tmp9_) {
		_tmp0_ = 0;
	} else {
		_tmp0_ = -1;
	}
	result = _tmp0_;
	return result;
}

static gint
___lambda95__gcompare_data_func (gconstpointer a,
                                 gconstpointer b,
                                 gpointer self)
{
	gint result;
	result = __lambda95_ ((ScratchFolderManagerFileView*) self, (ScratchFolderManagerProjectFolderItem*) a, (ScratchFolderManagerProjectFolderItem*) b);
	return result;
}

void
scratch_folder_manager_file_view_order_folders (ScratchFolderManagerFileView* self)
{
	GeeArrayList* list = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp16_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gee_array_list_new (SCRATCH_FOLDER_MANAGER_TYPE_PROJECT_FOLDER_ITEM, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	list = _tmp0_;
	{
		GeeIterator* _child_it = NULL;
		CodeWidgetsSourceListExpandableItem* _tmp1_;
		CodeWidgetsSourceListExpandableItem* _tmp2_;
		GeeCollection* _tmp3_;
		GeeCollection* _tmp4_;
		GeeCollection* _tmp5_;
		GeeIterator* _tmp6_;
		GeeIterator* _tmp7_;
		_tmp1_ = code_widgets_source_list_get_root ((CodeWidgetsSourceList*) self);
		_tmp2_ = _tmp1_;
		_tmp3_ = code_widgets_source_list_expandable_item_get_children (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = _tmp4_;
		_tmp6_ = gee_iterable_iterator ((GeeIterable*) _tmp5_);
		_tmp7_ = _tmp6_;
		_g_object_unref0 (_tmp5_);
		_child_it = _tmp7_;
		while (TRUE) {
			GeeIterator* _tmp8_;
			CodeWidgetsSourceListItem* child = NULL;
			GeeIterator* _tmp9_;
			gpointer _tmp10_;
			CodeWidgetsSourceListExpandableItem* _tmp11_;
			CodeWidgetsSourceListExpandableItem* _tmp12_;
			CodeWidgetsSourceListItem* _tmp13_;
			GeeArrayList* _tmp14_;
			CodeWidgetsSourceListItem* _tmp15_;
			_tmp8_ = _child_it;
			if (!gee_iterator_next (_tmp8_)) {
				break;
			}
			_tmp9_ = _child_it;
			_tmp10_ = gee_iterator_get (_tmp9_);
			child = (CodeWidgetsSourceListItem*) _tmp10_;
			_tmp11_ = code_widgets_source_list_get_root ((CodeWidgetsSourceList*) self);
			_tmp12_ = _tmp11_;
			_tmp13_ = child;
			code_widgets_source_list_expandable_item_remove (_tmp12_, (CodeWidgetsSourceListItem*) (SCRATCH_FOLDER_MANAGER_IS_PROJECT_FOLDER_ITEM (_tmp13_) ? ((ScratchFolderManagerProjectFolderItem*) _tmp13_) : NULL));
			_tmp14_ = list;
			_tmp15_ = child;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp14_, SCRATCH_FOLDER_MANAGER_IS_PROJECT_FOLDER_ITEM (_tmp15_) ? ((ScratchFolderManagerProjectFolderItem*) _tmp15_) : NULL);
			_g_object_unref0 (child);
		}
		_g_object_unref0 (_child_it);
	}
	_tmp16_ = list;
	gee_list_sort ((GeeList*) _tmp16_, ___lambda95__gcompare_data_func, g_object_ref (self), g_object_unref);
	{
		GeeArrayList* _item_list = NULL;
		GeeArrayList* _tmp17_;
		gint _item_size = 0;
		GeeArrayList* _tmp18_;
		gint _tmp19_;
		gint _tmp20_;
		gint _item_index = 0;
		_tmp17_ = list;
		_item_list = _tmp17_;
		_tmp18_ = _item_list;
		_tmp19_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp18_);
		_tmp20_ = _tmp19_;
		_item_size = _tmp20_;
		_item_index = -1;
		while (TRUE) {
			gint _tmp21_;
			gint _tmp22_;
			ScratchFolderManagerProjectFolderItem* item = NULL;
			GeeArrayList* _tmp23_;
			gpointer _tmp24_;
			CodeWidgetsSourceListExpandableItem* _tmp25_;
			CodeWidgetsSourceListExpandableItem* _tmp26_;
			ScratchFolderManagerProjectFolderItem* _tmp27_;
			_item_index = _item_index + 1;
			_tmp21_ = _item_index;
			_tmp22_ = _item_size;
			if (!(_tmp21_ < _tmp22_)) {
				break;
			}
			_tmp23_ = _item_list;
			_tmp24_ = gee_abstract_list_get ((GeeAbstractList*) _tmp23_, _item_index);
			item = (ScratchFolderManagerProjectFolderItem*) _tmp24_;
			_tmp25_ = code_widgets_source_list_get_root ((CodeWidgetsSourceList*) self);
			_tmp26_ = _tmp25_;
			_tmp27_ = item;
			code_widgets_source_list_expandable_item_add (_tmp26_, (CodeWidgetsSourceListItem*) _tmp27_);
			_g_object_unref0 (item);
		}
	}
	_g_object_unref0 (list);
}

void
scratch_folder_manager_file_view_select_path (ScratchFolderManagerFileView* self,
                                              const gchar* path)
{
	CodeWidgetsSourceListExpandableItem* _tmp0_;
	CodeWidgetsSourceListExpandableItem* _tmp1_;
	CodeWidgetsSourceListItem* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	_tmp0_ = code_widgets_source_list_get_root ((CodeWidgetsSourceList*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = scratch_folder_manager_file_view_find_path (self, _tmp1_, path, FALSE);
	code_widgets_source_list_set_selected ((CodeWidgetsSourceList*) self, _tmp2_);
}

void
scratch_folder_manager_file_view_unselect_all (ScratchFolderManagerFileView* self)
{
	g_return_if_fail (self != NULL);
	code_widgets_source_list_set_selected ((CodeWidgetsSourceList*) self, NULL);
}

void
scratch_folder_manager_file_view_collapse_other_projects (ScratchFolderManagerFileView* self)
{
	const gchar* path = NULL;
	ScratchServicesGitManager* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->git_manager;
	_tmp1_ = scratch_services_git_manager_get_active_project_path (_tmp0_);
	_tmp2_ = _tmp1_;
	path = _tmp2_;
	{
		GeeIterator* _child_it = NULL;
		CodeWidgetsSourceListExpandableItem* _tmp3_;
		CodeWidgetsSourceListExpandableItem* _tmp4_;
		GeeCollection* _tmp5_;
		GeeCollection* _tmp6_;
		GeeCollection* _tmp7_;
		GeeIterator* _tmp8_;
		GeeIterator* _tmp9_;
		_tmp3_ = code_widgets_source_list_get_root ((CodeWidgetsSourceList*) self);
		_tmp4_ = _tmp3_;
		_tmp5_ = code_widgets_source_list_expandable_item_get_children (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = _tmp6_;
		_tmp8_ = gee_iterable_iterator ((GeeIterable*) _tmp7_);
		_tmp9_ = _tmp8_;
		_g_object_unref0 (_tmp7_);
		_child_it = _tmp9_;
		while (TRUE) {
			GeeIterator* _tmp10_;
			CodeWidgetsSourceListItem* child = NULL;
			GeeIterator* _tmp11_;
			gpointer _tmp12_;
			ScratchFolderManagerProjectFolderItem* project_folder = NULL;
			CodeWidgetsSourceListItem* _tmp13_;
			ScratchFolderManagerProjectFolderItem* _tmp14_;
			ScratchFolderManagerProjectFolderItem* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			gchar* _tmp18_;
			const gchar* _tmp19_;
			gboolean _tmp20_;
			_tmp10_ = _child_it;
			if (!gee_iterator_next (_tmp10_)) {
				break;
			}
			_tmp11_ = _child_it;
			_tmp12_ = gee_iterator_get (_tmp11_);
			child = (CodeWidgetsSourceListItem*) _tmp12_;
			_tmp13_ = child;
			_tmp14_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, SCRATCH_FOLDER_MANAGER_TYPE_PROJECT_FOLDER_ITEM, ScratchFolderManagerProjectFolderItem));
			project_folder = _tmp14_;
			_tmp15_ = project_folder;
			_tmp16_ = scratch_folder_manager_item_get_path ((ScratchFolderManagerItem*) _tmp15_);
			_tmp17_ = _tmp16_;
			_tmp18_ = _tmp17_;
			_tmp19_ = path;
			_tmp20_ = g_strcmp0 (_tmp18_, _tmp19_) != 0;
			_g_free0 (_tmp18_);
			if (_tmp20_) {
				ScratchFolderManagerProjectFolderItem* _tmp21_;
				GActionGroup* _tmp22_;
				ScratchFolderManagerProjectFolderItem* _tmp23_;
				gchar* _tmp24_;
				gchar* _tmp25_;
				gchar* _tmp26_;
				GVariant* _tmp27_;
				GVariant* _tmp28_;
				_tmp21_ = project_folder;
				code_widgets_source_list_expandable_item_set_expanded ((CodeWidgetsSourceListExpandableItem*) _tmp21_, FALSE);
				_tmp22_ = self->priv->_toplevel_action_group;
				_tmp23_ = project_folder;
				_tmp24_ = scratch_folder_manager_item_get_path ((ScratchFolderManagerItem*) _tmp23_);
				_tmp25_ = _tmp24_;
				_tmp26_ = _tmp25_;
				_tmp27_ = g_variant_new_string (_tmp26_);
				g_variant_ref_sink (_tmp27_);
				_tmp28_ = _tmp27_;
				g_action_group_activate_action (_tmp22_, SCRATCH_MAIN_WINDOW_ACTION_HIDE_PROJECT_DOCS, _tmp28_);
				_g_variant_unref0 (_tmp28_);
				_g_free0 (_tmp26_);
			} else {
				ScratchFolderManagerProjectFolderItem* _tmp29_;
				gchar* _tmp30_;
				gchar* _tmp31_;
				gchar* _tmp32_;
				const gchar* _tmp33_;
				gboolean _tmp34_;
				_tmp29_ = project_folder;
				_tmp30_ = scratch_folder_manager_item_get_path ((ScratchFolderManagerItem*) _tmp29_);
				_tmp31_ = _tmp30_;
				_tmp32_ = _tmp31_;
				_tmp33_ = path;
				_tmp34_ = g_strcmp0 (_tmp32_, _tmp33_) == 0;
				_g_free0 (_tmp32_);
				if (_tmp34_) {
					ScratchFolderManagerProjectFolderItem* _tmp35_;
					GActionGroup* _tmp36_;
					ScratchFolderManagerProjectFolderItem* _tmp37_;
					gchar* _tmp38_;
					gchar* _tmp39_;
					gchar* _tmp40_;
					GVariant* _tmp41_;
					GVariant* _tmp42_;
					_tmp35_ = project_folder;
					code_widgets_source_list_expandable_item_set_expanded ((CodeWidgetsSourceListExpandableItem*) _tmp35_, TRUE);
					_tmp36_ = self->priv->_toplevel_action_group;
					_tmp37_ = project_folder;
					_tmp38_ = scratch_folder_manager_item_get_path ((ScratchFolderManagerItem*) _tmp37_);
					_tmp39_ = _tmp38_;
					_tmp40_ = _tmp39_;
					_tmp41_ = g_variant_new_string (_tmp40_);
					g_variant_ref_sink (_tmp41_);
					_tmp42_ = _tmp41_;
					g_action_group_activate_action (_tmp36_, SCRATCH_MAIN_WINDOW_ACTION_RESTORE_PROJECT_DOCS, _tmp42_);
					_g_variant_unref0 (_tmp42_);
					_g_free0 (_tmp40_);
				}
			}
			_g_object_unref0 (project_folder);
			_g_object_unref0 (child);
		}
		_g_object_unref0 (_child_it);
	}
}

static CodeWidgetsSourceListItem*
scratch_folder_manager_file_view_find_path (ScratchFolderManagerFileView* self,
                                            CodeWidgetsSourceListExpandableItem* list,
                                            const gchar* path,
                                            gboolean expand)
{
	CodeWidgetsSourceListItem* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (list != NULL, NULL);
	g_return_val_if_fail (path != NULL, NULL);
	{
		GeeIterator* _item_it = NULL;
		GeeCollection* _tmp0_;
		GeeCollection* _tmp1_;
		GeeCollection* _tmp2_;
		GeeIterator* _tmp3_;
		GeeIterator* _tmp4_;
		_tmp0_ = code_widgets_source_list_expandable_item_get_children (list);
		_tmp1_ = _tmp0_;
		_tmp2_ = _tmp1_;
		_tmp3_ = gee_iterable_iterator ((GeeIterable*) _tmp2_);
		_tmp4_ = _tmp3_;
		_g_object_unref0 (_tmp2_);
		_item_it = _tmp4_;
		while (TRUE) {
			GeeIterator* _tmp5_;
			CodeWidgetsSourceListItem* item = NULL;
			GeeIterator* _tmp6_;
			gpointer _tmp7_;
			CodeWidgetsSourceListItem* _tmp8_;
			_tmp5_ = _item_it;
			if (!gee_iterator_next (_tmp5_)) {
				break;
			}
			_tmp6_ = _item_it;
			_tmp7_ = gee_iterator_get (_tmp6_);
			item = (CodeWidgetsSourceListItem*) _tmp7_;
			_tmp8_ = item;
			if (SCRATCH_FOLDER_MANAGER_IS_ITEM (_tmp8_)) {
				ScratchFolderManagerItem* code_item = NULL;
				CodeWidgetsSourceListItem* _tmp9_;
				ScratchFolderManagerItem* _tmp10_;
				ScratchFolderManagerItem* _tmp11_;
				gchar* _tmp12_;
				gchar* _tmp13_;
				gchar* _tmp14_;
				gboolean _tmp15_;
				CodeWidgetsSourceListItem* _tmp17_;
				_tmp9_ = item;
				_tmp10_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, SCRATCH_FOLDER_MANAGER_TYPE_ITEM, ScratchFolderManagerItem));
				code_item = _tmp10_;
				_tmp11_ = code_item;
				_tmp12_ = scratch_folder_manager_item_get_path (_tmp11_);
				_tmp13_ = _tmp12_;
				_tmp14_ = _tmp13_;
				_tmp15_ = g_strcmp0 (_tmp14_, path) == 0;
				_g_free0 (_tmp14_);
				if (_tmp15_) {
					CodeWidgetsSourceListItem* _tmp16_;
					_tmp16_ = item;
					result = G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, CODE_WIDGETS_SOURCE_LIST_TYPE_ITEM, CodeWidgetsSourceListItem);
					_g_object_unref0 (code_item);
					_g_object_unref0 (item);
					_g_object_unref0 (_item_it);
					return result;
				}
				_tmp17_ = item;
				if (CODE_WIDGETS_SOURCE_LIST_IS_EXPANDABLE_ITEM (_tmp17_)) {
					CodeWidgetsSourceListExpandableItem* expander = NULL;
					CodeWidgetsSourceListItem* _tmp18_;
					CodeWidgetsSourceListExpandableItem* _tmp19_;
					ScratchFolderManagerItem* _tmp20_;
					gchar* _tmp21_;
					gchar* _tmp22_;
					gchar* _tmp23_;
					gboolean _tmp24_;
					CodeWidgetsSourceListExpandableItem* _tmp25_;
					gboolean _tmp26_;
					gboolean _tmp27_;
					CodeWidgetsSourceListItem* recurse_item = NULL;
					CodeWidgetsSourceListExpandableItem* _tmp30_;
					CodeWidgetsSourceListItem* _tmp31_;
					CodeWidgetsSourceListItem* _tmp32_;
					_tmp18_ = item;
					_tmp19_ = _g_object_ref0 (CODE_WIDGETS_SOURCE_LIST_IS_EXPANDABLE_ITEM (_tmp18_) ? ((CodeWidgetsSourceListExpandableItem*) _tmp18_) : NULL);
					expander = _tmp19_;
					_tmp20_ = code_item;
					_tmp21_ = scratch_folder_manager_item_get_path (_tmp20_);
					_tmp22_ = _tmp21_;
					_tmp23_ = _tmp22_;
					_tmp24_ = !g_str_has_prefix (path, _tmp23_);
					_g_free0 (_tmp23_);
					if (_tmp24_) {
						_g_object_unref0 (expander);
						_g_object_unref0 (code_item);
						_g_object_unref0 (item);
						continue;
					}
					_tmp25_ = expander;
					_tmp26_ = code_widgets_source_list_expandable_item_get_expanded (_tmp25_);
					_tmp27_ = _tmp26_;
					if (!_tmp27_) {
						if (expand) {
							CodeWidgetsSourceListExpandableItem* _tmp28_;
							CodeWidgetsSourceListExpandableItem* _tmp29_;
							_tmp28_ = expander;
							scratch_folder_manager_folder_item_load_children (G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, SCRATCH_FOLDER_MANAGER_TYPE_FOLDER_ITEM, ScratchFolderManagerFolderItem));
							_tmp29_ = expander;
							code_widgets_source_list_expandable_item_set_expanded (_tmp29_, TRUE);
						} else {
							_g_object_unref0 (expander);
							_g_object_unref0 (code_item);
							_g_object_unref0 (item);
							continue;
						}
					}
					_tmp30_ = expander;
					_tmp31_ = scratch_folder_manager_file_view_find_path (self, _tmp30_, path, expand);
					recurse_item = _tmp31_;
					_tmp32_ = recurse_item;
					if (_tmp32_ != NULL) {
						CodeWidgetsSourceListItem* _tmp33_;
						_tmp33_ = recurse_item;
						result = _tmp33_;
						_g_object_unref0 (expander);
						_g_object_unref0 (code_item);
						_g_object_unref0 (item);
						_g_object_unref0 (_item_it);
						return result;
					}
					_g_object_unref0 (expander);
				}
				_g_object_unref0 (code_item);
			}
			_g_object_unref0 (item);
		}
		_g_object_unref0 (_item_it);
	}
	result = NULL;
	return result;
}

ScratchFolderManagerProjectFolderItem*
scratch_folder_manager_file_view_get_project_for_file (ScratchFolderManagerFileView* self,
                                                       GFile* file)
{
	ScratchFolderManagerProjectFolderItem* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (file != NULL, NULL);
	{
		GeeIterator* _item_it = NULL;
		CodeWidgetsSourceListExpandableItem* _tmp0_;
		CodeWidgetsSourceListExpandableItem* _tmp1_;
		GeeCollection* _tmp2_;
		GeeCollection* _tmp3_;
		GeeCollection* _tmp4_;
		GeeIterator* _tmp5_;
		GeeIterator* _tmp6_;
		_tmp0_ = code_widgets_source_list_get_root ((CodeWidgetsSourceList*) self);
		_tmp1_ = _tmp0_;
		_tmp2_ = code_widgets_source_list_expandable_item_get_children (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = _tmp3_;
		_tmp5_ = gee_iterable_iterator ((GeeIterable*) _tmp4_);
		_tmp6_ = _tmp5_;
		_g_object_unref0 (_tmp4_);
		_item_it = _tmp6_;
		while (TRUE) {
			GeeIterator* _tmp7_;
			CodeWidgetsSourceListItem* item = NULL;
			GeeIterator* _tmp8_;
			gpointer _tmp9_;
			CodeWidgetsSourceListItem* _tmp10_;
			_tmp7_ = _item_it;
			if (!gee_iterator_next (_tmp7_)) {
				break;
			}
			_tmp8_ = _item_it;
			_tmp9_ = gee_iterator_get (_tmp8_);
			item = (CodeWidgetsSourceListItem*) _tmp9_;
			_tmp10_ = item;
			if (SCRATCH_FOLDER_MANAGER_IS_PROJECT_FOLDER_ITEM (_tmp10_)) {
				ScratchFolderManagerProjectFolderItem* folder = NULL;
				CodeWidgetsSourceListItem* _tmp11_;
				ScratchFolderManagerProjectFolderItem* _tmp12_;
				ScratchFolderManagerProjectFolderItem* _tmp13_;
				_tmp11_ = item;
				_tmp12_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, SCRATCH_FOLDER_MANAGER_TYPE_PROJECT_FOLDER_ITEM, ScratchFolderManagerProjectFolderItem));
				folder = _tmp12_;
				_tmp13_ = folder;
				if (scratch_folder_manager_project_folder_item_contains_file (_tmp13_, file)) {
					result = folder;
					_g_object_unref0 (item);
					_g_object_unref0 (_item_it);
					return result;
				}
				_g_object_unref0 (folder);
			}
			_g_object_unref0 (item);
		}
		_g_object_unref0 (_item_it);
	}
	result = NULL;
	return result;
}

CodeWidgetsSourceListItem*
scratch_folder_manager_file_view_expand_to_path (ScratchFolderManagerFileView* self,
                                                 const gchar* path)
{
	CodeWidgetsSourceListExpandableItem* _tmp0_;
	CodeWidgetsSourceListExpandableItem* _tmp1_;
	CodeWidgetsSourceListItem* _tmp2_;
	CodeWidgetsSourceListItem* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (path != NULL, NULL);
	_tmp0_ = code_widgets_source_list_get_root ((CodeWidgetsSourceList*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = scratch_folder_manager_file_view_find_path (self, _tmp1_, path, TRUE);
	result = _tmp2_;
	return result;
}

void
scratch_folder_manager_file_view_search_global (ScratchFolderManagerFileView* self,
                                                const gchar* path,
                                                const gchar* term)
{
	ScratchFolderManagerItem* item_for_path = NULL;
	CodeWidgetsSourceListItem* _tmp0_;
	ScratchFolderManagerItem* _tmp1_;
	ScratchFolderManagerItem* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	_tmp0_ = scratch_folder_manager_file_view_expand_to_path (self, path);
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, SCRATCH_FOLDER_MANAGER_TYPE_ITEM, ScratchFolderManagerItem));
	item_for_path = _tmp1_;
	_tmp2_ = item_for_path;
	if (_tmp2_ != NULL) {
		ScratchFolderManagerProjectFolderItem* search_root = NULL;
		ScratchFolderManagerItem* _tmp3_;
		ScratchFolderManagerProjectFolderItem* _tmp4_;
		ScratchFolderManagerProjectFolderItem* _tmp5_;
		_tmp3_ = item_for_path;
		_tmp4_ = scratch_folder_manager_item_get_root_folder (_tmp3_, NULL);
		search_root = _tmp4_;
		_tmp5_ = search_root;
		if (SCRATCH_FOLDER_MANAGER_IS_PROJECT_FOLDER_ITEM (_tmp5_)) {
			GFile* _tmp6_ = NULL;
			ScratchFolderManagerItem* _tmp7_;
			GFile* start_folder = NULL;
			GFile* _tmp18_;
			gboolean is_explicit = FALSE;
			ScratchFolderManagerItem* _tmp19_;
			ScratchFolderManagerProjectFolderItem* _tmp20_;
			GFile* _tmp21_;
			_tmp7_ = item_for_path;
			if (SCRATCH_FOLDER_MANAGER_IS_FOLDER_ITEM (_tmp7_)) {
				ScratchFolderManagerItem* _tmp8_;
				ScratchFolderManagerFile* _tmp9_;
				ScratchFolderManagerFile* _tmp10_;
				GFile* _tmp11_;
				GFile* _tmp12_;
				_tmp8_ = item_for_path;
				_tmp9_ = scratch_folder_manager_item_get_file (_tmp8_);
				_tmp10_ = _tmp9_;
				_tmp11_ = scratch_folder_manager_file_get_file (_tmp10_);
				_tmp12_ = _tmp11_;
				_tmp6_ = _tmp12_;
			} else {
				ScratchFolderManagerProjectFolderItem* _tmp13_;
				ScratchFolderManagerFile* _tmp14_;
				ScratchFolderManagerFile* _tmp15_;
				GFile* _tmp16_;
				GFile* _tmp17_;
				_tmp13_ = search_root;
				_tmp14_ = scratch_folder_manager_item_get_file ((ScratchFolderManagerItem*) _tmp13_);
				_tmp15_ = _tmp14_;
				_tmp16_ = scratch_folder_manager_file_get_file (_tmp15_);
				_tmp17_ = _tmp16_;
				_tmp6_ = _tmp17_;
			}
			_tmp18_ = _g_object_ref0 (_tmp6_);
			start_folder = _tmp18_;
			_tmp19_ = item_for_path;
			is_explicit = !SCRATCH_FOLDER_MANAGER_IS_PROJECT_FOLDER_ITEM (_tmp19_);
			_tmp20_ = search_root;
			_tmp21_ = start_folder;
			scratch_folder_manager_project_folder_item_global_search (_tmp20_, _tmp21_, term, is_explicit);
			_g_object_unref0 (start_folder);
		}
		_g_object_unref0 (search_root);
	}
	_g_object_unref0 (item_for_path);
}

void
scratch_folder_manager_file_view_clear_badges (ScratchFolderManagerFileView* self)
{
	g_return_if_fail (self != NULL);
	{
		GeeIterator* _child_it = NULL;
		CodeWidgetsSourceListExpandableItem* _tmp0_;
		CodeWidgetsSourceListExpandableItem* _tmp1_;
		GeeCollection* _tmp2_;
		GeeCollection* _tmp3_;
		GeeCollection* _tmp4_;
		GeeIterator* _tmp5_;
		GeeIterator* _tmp6_;
		_tmp0_ = code_widgets_source_list_get_root ((CodeWidgetsSourceList*) self);
		_tmp1_ = _tmp0_;
		_tmp2_ = code_widgets_source_list_expandable_item_get_children (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = _tmp3_;
		_tmp5_ = gee_iterable_iterator ((GeeIterable*) _tmp4_);
		_tmp6_ = _tmp5_;
		_g_object_unref0 (_tmp4_);
		_child_it = _tmp6_;
		while (TRUE) {
			GeeIterator* _tmp7_;
			CodeWidgetsSourceListItem* child = NULL;
			GeeIterator* _tmp8_;
			gpointer _tmp9_;
			CodeWidgetsSourceListItem* _tmp10_;
			_tmp7_ = _child_it;
			if (!gee_iterator_next (_tmp7_)) {
				break;
			}
			_tmp8_ = _child_it;
			_tmp9_ = gee_iterator_get (_tmp8_);
			child = (CodeWidgetsSourceListItem*) _tmp9_;
			_tmp10_ = child;
			if (SCRATCH_FOLDER_MANAGER_IS_PROJECT_FOLDER_ITEM (_tmp10_)) {
				CodeWidgetsSourceListItem* _tmp11_;
				_tmp11_ = child;
				scratch_folder_manager_folder_item_remove_all_badges (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, SCRATCH_FOLDER_MANAGER_TYPE_FOLDER_ITEM, ScratchFolderManagerFolderItem));
			}
			_g_object_unref0 (child);
		}
		_g_object_unref0 (_child_it);
	}
}

void
scratch_folder_manager_file_view_new_branch (ScratchFolderManagerFileView* self,
                                             const gchar* active_project_path)
{
	ScratchFolderManagerProjectFolderItem* active_project = NULL;
	CodeWidgetsSourceListExpandableItem* _tmp0_;
	CodeWidgetsSourceListExpandableItem* _tmp1_;
	CodeWidgetsSourceListItem* _tmp2_;
	gboolean _tmp3_ = FALSE;
	ScratchFolderManagerProjectFolderItem* _tmp4_;
	gchar* branch_name = NULL;
	ScratchDialogsNewBranchDialog* dialog = NULL;
	ScratchFolderManagerProjectFolderItem* _tmp8_;
	ScratchDialogsNewBranchDialog* _tmp9_;
	ScratchDialogsNewBranchDialog* _tmp10_;
	ScratchDialogsNewBranchDialog* _tmp11_;
	ScratchDialogsNewBranchDialog* _tmp16_;
	const gchar* _tmp17_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (active_project_path != NULL);
	_tmp0_ = code_widgets_source_list_get_root ((CodeWidgetsSourceList*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = scratch_folder_manager_file_view_find_path (self, _tmp1_, active_project_path, FALSE);
	active_project = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, SCRATCH_FOLDER_MANAGER_TYPE_PROJECT_FOLDER_ITEM, ScratchFolderManagerProjectFolderItem);
	_tmp4_ = active_project;
	if (_tmp4_ == NULL) {
		_tmp3_ = TRUE;
	} else {
		ScratchFolderManagerProjectFolderItem* _tmp5_;
		gboolean _tmp6_;
		gboolean _tmp7_;
		_tmp5_ = active_project;
		_tmp6_ = scratch_folder_manager_project_folder_item_get_is_git_repo (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp3_ = !_tmp7_;
	}
	if (_tmp3_) {
		gdk_beep ();
		return;
	}
	branch_name = NULL;
	_tmp8_ = active_project;
	_tmp9_ = scratch_dialogs_new_branch_dialog_new (_tmp8_);
	g_object_ref_sink (_tmp9_);
	dialog = _tmp9_;
	_tmp10_ = dialog;
	gtk_widget_show_all ((GtkWidget*) _tmp10_);
	_tmp11_ = dialog;
	if (gtk_dialog_run ((GtkDialog*) _tmp11_) == ((gint) GTK_RESPONSE_APPLY)) {
		ScratchDialogsNewBranchDialog* _tmp12_;
		const gchar* _tmp13_;
		const gchar* _tmp14_;
		gchar* _tmp15_;
		_tmp12_ = dialog;
		_tmp13_ = scratch_dialogs_new_branch_dialog_get_new_branch_name (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = g_strdup (_tmp14_);
		_g_free0 (branch_name);
		branch_name = _tmp15_;
	}
	_tmp16_ = dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp16_);
	_tmp17_ = branch_name;
	if (_tmp17_ != NULL) {
		ScratchFolderManagerProjectFolderItem* _tmp18_;
		const gchar* _tmp19_;
		_tmp18_ = active_project;
		_tmp19_ = branch_name;
		scratch_folder_manager_project_folder_item_new_branch (_tmp18_, _tmp19_);
	}
	_g_object_unref0 (dialog);
	_g_free0 (branch_name);
}

void
scratch_folder_manager_file_view_folder_item_update_hook (ScratchFolderManagerFileView* self,
                                                          GFile* source,
                                                          GFile* dest,
                                                          GFileMonitorEvent event)
{
	ScratchServicesPluginsManager* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	_tmp0_ = self->priv->plugins;
	g_signal_emit_by_name (_tmp0_, "hook-folder-item-change", source, dest, event);
}

static Block11Data*
block11_data_ref (Block11Data* _data11_)
{
	g_atomic_int_inc (&_data11_->_ref_count_);
	return _data11_;
}

static void
block11_data_unref (void * _userdata_)
{
	Block11Data* _data11_;
	_data11_ = (Block11Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data11_->_ref_count_)) {
		ScratchFolderManagerFileView* self;
		self = _data11_->self;
		_g_free0 (_data11_->path);
		_g_object_unref0 (self);
		g_slice_free (Block11Data, _data11_);
	}
}

static Block12Data*
block12_data_ref (Block12Data* _data12_)
{
	g_atomic_int_inc (&_data12_->_ref_count_);
	return _data12_;
}

static void
block12_data_unref (void * _userdata_)
{
	Block12Data* _data12_;
	_data12_ = (Block12Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data12_->_ref_count_)) {
		ScratchFolderManagerFileView* self;
		self = _data12_->_data11_->self;
		block11_data_unref (_data12_->_data11_);
		_data12_->_data11_ = NULL;
		g_slice_free (Block12Data, _data12_);
	}
}

static void
___lambda85_ (Block12Data* _data12_,
              const gchar* new_name)
{
	Block11Data* _data11_;
	ScratchFolderManagerFileView* self;
	CodeWidgetsSourceListItem* _tmp0_;
	CodeWidgetsSourceListItem* _tmp1_;
	gchar* new_path = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	GActionGroup* _tmp8_;
	GVariant* _tmp9_;
	GVariant* _tmp10_;
	gchar* new_uri = NULL;
	gchar* _tmp11_;
	GtkRecentManager* _tmp12_;
	_data11_ = _data12_->_data11_;
	self = _data11_->self;
	g_return_if_fail (new_name != NULL);
	_tmp0_ = code_widgets_source_list_get_selected ((CodeWidgetsSourceList*) self);
	_tmp1_ = _tmp0_;
	g_signal_handler_disconnect ((GObject*) _tmp1_, _data12_->once);
	_tmp2_ = g_path_get_dirname (_data11_->path);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strconcat (_tmp3_, G_DIR_SEPARATOR_S, NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strconcat (_tmp5_, new_name, NULL);
	_tmp7_ = _tmp6_;
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	new_path = _tmp7_;
	_tmp8_ = self->priv->_toplevel_action_group;
	_tmp9_ = g_variant_new_string (_data11_->path);
	g_variant_ref_sink (_tmp9_);
	_tmp10_ = _tmp9_;
	g_action_group_activate_action (_tmp8_, SCRATCH_MAIN_WINDOW_ACTION_CLOSE_TAB, _tmp10_);
	_g_variant_unref0 (_tmp10_);
	_tmp11_ = g_strconcat ("file://", new_path, NULL);
	new_uri = _tmp11_;
	_tmp12_ = gtk_recent_manager_get_default ();
	gtk_recent_manager_add_item (_tmp12_, new_uri);
	g_signal_emit (self, scratch_folder_manager_file_view_signals[SCRATCH_FOLDER_MANAGER_FILE_VIEW_ACTIVATE_SIGNAL], 0, new_path);
	_g_free0 (new_uri);
	_g_free0 (new_path);
}

static void
____lambda85__code_widgets_source_list_item_edited (CodeWidgetsSourceListItem* _sender,
                                                    const gchar* new_name,
                                                    gpointer self)
{
	___lambda85_ (self, new_name);
}

static gboolean
__lambda86_ (ScratchFolderManagerFileView* self)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean result;
	_tmp0_ = code_widgets_source_list_get_editing ((CodeWidgetsSourceList*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		result = G_SOURCE_CONTINUE;
		return result;
	} else {
		scratch_folder_manager_file_view_unselect_all (self);
		result = G_SOURCE_REMOVE;
		return result;
	}
}

static gboolean
___lambda86__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda86_ ((ScratchFolderManagerFileView*) self);
	return result;
}

static void
scratch_folder_manager_file_view_rename_file (ScratchFolderManagerFileView* self,
                                              const gchar* path)
{
	Block11Data* _data11_;
	gchar* _tmp0_;
	CodeWidgetsSourceListItem* _tmp1_;
	CodeWidgetsSourceListItem* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	_data11_ = g_slice_new0 (Block11Data);
	_data11_->_ref_count_ = 1;
	_data11_->self = g_object_ref (self);
	_tmp0_ = g_strdup (path);
	_g_free0 (_data11_->path);
	_data11_->path = _tmp0_;
	scratch_folder_manager_file_view_select_path (self, _data11_->path);
	_tmp1_ = code_widgets_source_list_get_selected ((CodeWidgetsSourceList*) self);
	_tmp2_ = _tmp1_;
	if (code_widgets_source_list_start_editing_item ((CodeWidgetsSourceList*) self, _tmp2_)) {
		Block12Data* _data12_;
		CodeWidgetsSourceListItem* _tmp3_;
		CodeWidgetsSourceListItem* _tmp4_;
		gulong _tmp5_;
		_data12_ = g_slice_new0 (Block12Data);
		_data12_->_ref_count_ = 1;
		_data12_->_data11_ = block11_data_ref (_data11_);
		_data12_->once = (gulong) 0;
		_tmp3_ = code_widgets_source_list_get_selected ((CodeWidgetsSourceList*) self);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_signal_connect_data (_tmp4_, "edited", (GCallback) ____lambda85__code_widgets_source_list_item_edited, block12_data_ref (_data12_), (GClosureNotify) block12_data_unref, 0);
		_data12_->once = _tmp5_;
		block12_data_unref (_data12_);
		_data12_ = NULL;
	}
	g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 200, ___lambda86__gsource_func, g_object_ref (self), g_object_unref);
	block11_data_unref (_data11_);
	_data11_ = NULL;
}

static Block13Data*
block13_data_ref (Block13Data* _data13_)
{
	g_atomic_int_inc (&_data13_->_ref_count_);
	return _data13_;
}

static void
block13_data_unref (void * _userdata_)
{
	Block13Data* _data13_;
	_data13_ = (Block13Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data13_->_ref_count_)) {
		ScratchFolderManagerFileView* self;
		self = _data13_->self;
		_g_object_unref0 (_data13_->folder_to_rename);
		_g_object_unref0 (self);
		g_slice_free (Block13Data, _data13_);
	}
}

static gboolean
___lambda87_ (Block13Data* _data13_)
{
	ScratchFolderManagerFileView* self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean result;
	self = _data13_->self;
	_tmp0_ = code_widgets_source_list_get_editing ((CodeWidgetsSourceList*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		result = G_SOURCE_CONTINUE;
		return result;
	} else {
		ScratchFolderManagerFolderItem* _tmp2_;
		scratch_folder_manager_file_view_unselect_all (self);
		_tmp2_ = _data13_->folder_to_rename;
		code_widgets_source_list_item_set_selectable ((CodeWidgetsSourceListItem*) _tmp2_, FALSE);
	}
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
____lambda87__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda87_ (self);
	return result;
}

static void
scratch_folder_manager_file_view_rename_folder (ScratchFolderManagerFileView* self,
                                                const gchar* path)
{
	Block13Data* _data13_;
	CodeWidgetsSourceListExpandableItem* _tmp0_;
	CodeWidgetsSourceListExpandableItem* _tmp1_;
	CodeWidgetsSourceListItem* _tmp2_;
	ScratchFolderManagerFolderItem* _tmp3_;
	ScratchFolderManagerFolderItem* _tmp4_;
	ScratchFolderManagerFolderItem* _tmp5_;
	ScratchFolderManagerFolderItem* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	_data13_ = g_slice_new0 (Block13Data);
	_data13_->_ref_count_ = 1;
	_data13_->self = g_object_ref (self);
	_tmp0_ = code_widgets_source_list_get_root ((CodeWidgetsSourceList*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = scratch_folder_manager_file_view_find_path (self, _tmp1_, path, FALSE);
	_tmp3_ = _g_object_ref0 (SCRATCH_FOLDER_MANAGER_IS_FOLDER_ITEM (_tmp2_) ? ((ScratchFolderManagerFolderItem*) _tmp2_) : NULL);
	_data13_->folder_to_rename = _tmp3_;
	_tmp4_ = _data13_->folder_to_rename;
	if (_tmp4_ == NULL) {
		g_critical ("FileView.vala:347: Could not find folder from given path to rename: %s", path);
		block13_data_unref (_data13_);
		_data13_ = NULL;
		return;
	}
	_tmp5_ = _data13_->folder_to_rename;
	code_widgets_source_list_item_set_selectable ((CodeWidgetsSourceListItem*) _tmp5_, TRUE);
	_tmp6_ = _data13_->folder_to_rename;
	if (code_widgets_source_list_start_editing_item ((CodeWidgetsSourceList*) self, (CodeWidgetsSourceListItem*) _tmp6_)) {
		g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 200, ____lambda87__gsource_func, block13_data_ref (_data13_), block13_data_unref);
	} else {
		ScratchFolderManagerFolderItem* _tmp7_;
		g_critical ("FileView.vala:367: Could not rename %s", path);
		_tmp7_ = _data13_->folder_to_rename;
		code_widgets_source_list_item_set_selectable ((CodeWidgetsSourceListItem*) _tmp7_, FALSE);
	}
	block13_data_unref (_data13_);
	_data13_ = NULL;
}

static void
scratch_folder_manager_file_view_rename_items_with_same_name (ScratchFolderManagerFileView* self,
                                                              ScratchFolderManagerItem* item)
{
	gchar* item_name = NULL;
	ScratchFolderManagerFile* _tmp0_;
	ScratchFolderManagerFile* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp47_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	_tmp0_ = scratch_folder_manager_item_get_file (item);
	_tmp1_ = _tmp0_;
	_tmp2_ = scratch_folder_manager_file_get_name (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup (_tmp3_);
	item_name = _tmp4_;
	{
		GeeIterator* _child_it = NULL;
		CodeWidgetsSourceListExpandableItem* _tmp5_;
		CodeWidgetsSourceListExpandableItem* _tmp6_;
		GeeCollection* _tmp7_;
		GeeCollection* _tmp8_;
		GeeCollection* _tmp9_;
		GeeIterator* _tmp10_;
		GeeIterator* _tmp11_;
		_tmp5_ = code_widgets_source_list_get_root ((CodeWidgetsSourceList*) self);
		_tmp6_ = _tmp5_;
		_tmp7_ = code_widgets_source_list_expandable_item_get_children (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = _tmp8_;
		_tmp10_ = gee_iterable_iterator ((GeeIterable*) _tmp9_);
		_tmp11_ = _tmp10_;
		_g_object_unref0 (_tmp9_);
		_child_it = _tmp11_;
		while (TRUE) {
			GeeIterator* _tmp12_;
			CodeWidgetsSourceListItem* child = NULL;
			GeeIterator* _tmp13_;
			gpointer _tmp14_;
			gchar* new_other_item_name = NULL;
			gchar* new_item_name = NULL;
			ScratchFolderManagerProjectFolderItem* other_item = NULL;
			CodeWidgetsSourceListItem* _tmp15_;
			ScratchFolderManagerProjectFolderItem* _tmp16_;
			ScratchFolderManagerFile* _tmp17_;
			ScratchFolderManagerFile* _tmp18_;
			GFile* _tmp19_;
			GFile* _tmp20_;
			ScratchFolderManagerProjectFolderItem* _tmp21_;
			ScratchFolderManagerFile* _tmp22_;
			ScratchFolderManagerFile* _tmp23_;
			GFile* _tmp24_;
			GFile* _tmp25_;
			gchar* _tmp26_ = NULL;
			gchar* _tmp27_ = NULL;
			gboolean _tmp28_;
			_tmp12_ = _child_it;
			if (!gee_iterator_next (_tmp12_)) {
				break;
			}
			_tmp13_ = _child_it;
			_tmp14_ = gee_iterator_get (_tmp13_);
			child = (CodeWidgetsSourceListItem*) _tmp14_;
			_tmp15_ = child;
			_tmp16_ = _g_object_ref0 (SCRATCH_FOLDER_MANAGER_IS_PROJECT_FOLDER_ITEM (_tmp15_) ? ((ScratchFolderManagerProjectFolderItem*) _tmp15_) : NULL);
			other_item = _tmp16_;
			_tmp17_ = scratch_folder_manager_item_get_file (item);
			_tmp18_ = _tmp17_;
			_tmp19_ = scratch_folder_manager_file_get_file (_tmp18_);
			_tmp20_ = _tmp19_;
			_tmp21_ = other_item;
			_tmp22_ = scratch_folder_manager_item_get_file ((ScratchFolderManagerItem*) _tmp21_);
			_tmp23_ = _tmp22_;
			_tmp24_ = scratch_folder_manager_file_get_file (_tmp23_);
			_tmp25_ = _tmp24_;
			_tmp28_ = scratch_utils_find_unique_path (_tmp20_, _tmp25_, &_tmp26_, &_tmp27_);
			_g_free0 (new_item_name);
			new_item_name = _tmp26_;
			_g_free0 (new_other_item_name);
			new_other_item_name = _tmp27_;
			if (_tmp28_) {
				const gchar* _tmp29_;
				gint _tmp30_;
				gint _tmp31_;
				const gchar* _tmp32_;
				gint _tmp33_;
				gint _tmp34_;
				ScratchFolderManagerProjectFolderItem* _tmp37_;
				const gchar* _tmp38_;
				const gchar* _tmp39_;
				gint _tmp40_;
				gint _tmp41_;
				const gchar* _tmp42_;
				gint _tmp43_;
				gint _tmp44_;
				_tmp29_ = item_name;
				_tmp30_ = strlen (_tmp29_);
				_tmp31_ = _tmp30_;
				_tmp32_ = new_item_name;
				_tmp33_ = strlen (_tmp32_);
				_tmp34_ = _tmp33_;
				if (_tmp31_ < _tmp34_) {
					const gchar* _tmp35_;
					gchar* _tmp36_;
					_tmp35_ = new_item_name;
					_tmp36_ = g_strdup (_tmp35_);
					_g_free0 (item_name);
					item_name = _tmp36_;
				}
				_tmp37_ = other_item;
				_tmp38_ = code_widgets_source_list_item_get_name ((CodeWidgetsSourceListItem*) _tmp37_);
				_tmp39_ = _tmp38_;
				_tmp40_ = strlen (_tmp39_);
				_tmp41_ = _tmp40_;
				_tmp42_ = new_other_item_name;
				_tmp43_ = strlen (_tmp42_);
				_tmp44_ = _tmp43_;
				if (_tmp41_ < _tmp44_) {
					ScratchFolderManagerProjectFolderItem* _tmp45_;
					const gchar* _tmp46_;
					_tmp45_ = other_item;
					_tmp46_ = new_other_item_name;
					code_widgets_source_list_item_set_name ((CodeWidgetsSourceListItem*) _tmp45_, _tmp46_);
				}
			}
			_g_object_unref0 (other_item);
			_g_free0 (new_item_name);
			_g_free0 (new_other_item_name);
			_g_object_unref0 (child);
		}
		_g_object_unref0 (_child_it);
	}
	_tmp47_ = item_name;
	code_widgets_source_list_item_set_name ((CodeWidgetsSourceListItem*) item, _tmp47_);
	_g_free0 (item_name);
}

static void
scratch_folder_manager_file_view_add_new_folder (ScratchFolderManagerFileView* self,
                                                 GSimpleAction* action,
                                                 GVariant* param)
{
	gchar* path = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	ScratchFolderManagerFolderItem* folder = NULL;
	CodeWidgetsSourceListExpandableItem* _tmp5_;
	CodeWidgetsSourceListExpandableItem* _tmp6_;
	const gchar* _tmp7_;
	CodeWidgetsSourceListItem* _tmp8_;
	ScratchFolderManagerFolderItem* _tmp9_;
	ScratchFolderManagerFolderItem* _tmp10_;
	ScratchFolderManagerFolderItem* _tmp11_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = g_variant_get_string (param, NULL);
	_tmp1_ = g_strdup (_tmp0_);
	path = _tmp1_;
	_tmp3_ = path;
	if (_tmp3_ == NULL) {
		_tmp2_ = TRUE;
	} else {
		const gchar* _tmp4_;
		_tmp4_ = path;
		_tmp2_ = g_strcmp0 (_tmp4_, "") == 0;
	}
	if (_tmp2_) {
		_g_free0 (path);
		return;
	}
	_tmp5_ = code_widgets_source_list_get_root ((CodeWidgetsSourceList*) self);
	_tmp6_ = _tmp5_;
	_tmp7_ = path;
	_tmp8_ = scratch_folder_manager_file_view_find_path (self, _tmp6_, _tmp7_, FALSE);
	_tmp9_ = _g_object_ref0 (SCRATCH_FOLDER_MANAGER_IS_FOLDER_ITEM (_tmp8_) ? ((ScratchFolderManagerFolderItem*) _tmp8_) : NULL);
	folder = _tmp9_;
	_tmp10_ = folder;
	if (_tmp10_ == NULL) {
		_g_object_unref0 (folder);
		_g_free0 (path);
		return;
	}
	_tmp11_ = folder;
	scratch_folder_manager_folder_item_on_add_new (_tmp11_, TRUE);
	_g_object_unref0 (folder);
	_g_free0 (path);
}

static void
scratch_folder_manager_file_view_add_new_file (ScratchFolderManagerFileView* self,
                                               GSimpleAction* action,
                                               GVariant* param)
{
	gchar* path = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	ScratchFolderManagerFolderItem* folder = NULL;
	CodeWidgetsSourceListExpandableItem* _tmp5_;
	CodeWidgetsSourceListExpandableItem* _tmp6_;
	const gchar* _tmp7_;
	CodeWidgetsSourceListItem* _tmp8_;
	ScratchFolderManagerFolderItem* _tmp9_;
	ScratchFolderManagerFolderItem* _tmp10_;
	ScratchFolderManagerFolderItem* _tmp11_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = g_variant_get_string (param, NULL);
	_tmp1_ = g_strdup (_tmp0_);
	path = _tmp1_;
	_tmp3_ = path;
	if (_tmp3_ == NULL) {
		_tmp2_ = TRUE;
	} else {
		const gchar* _tmp4_;
		_tmp4_ = path;
		_tmp2_ = g_strcmp0 (_tmp4_, "") == 0;
	}
	if (_tmp2_) {
		_g_free0 (path);
		return;
	}
	_tmp5_ = code_widgets_source_list_get_root ((CodeWidgetsSourceList*) self);
	_tmp6_ = _tmp5_;
	_tmp7_ = path;
	_tmp8_ = scratch_folder_manager_file_view_find_path (self, _tmp6_, _tmp7_, FALSE);
	_tmp9_ = _g_object_ref0 (SCRATCH_FOLDER_MANAGER_IS_FOLDER_ITEM (_tmp8_) ? ((ScratchFolderManagerFolderItem*) _tmp8_) : NULL);
	folder = _tmp9_;
	_tmp10_ = folder;
	if (_tmp10_ == NULL) {
		_g_object_unref0 (folder);
		_g_free0 (path);
		return;
	}
	_tmp11_ = folder;
	scratch_folder_manager_folder_item_on_add_new (_tmp11_, FALSE);
	_g_object_unref0 (folder);
	_g_free0 (path);
}

static void
scratch_folder_manager_file_view_action_launch_app_with_file_path (ScratchFolderManagerFileView* self,
                                                                   GSimpleAction* action,
                                                                   GVariant* param)
{
	const gchar** params = NULL;
	gsize _tmp0_ = 0;
	const gchar** _tmp1_;
	gint params_length1;
	gint _params_size_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp1_ = g_variant_get_strv (param, &_tmp0_);
	params = _tmp1_;
	params_length1 = _tmp0_;
	_params_size_ = params_length1;
	_tmp2_ = params[1];
	_tmp3_ = params[0];
	scratch_utils_launch_app_with_file (_tmp2_, _tmp3_);
	params = (g_free (params), NULL);
}

static void
scratch_folder_manager_file_view_action_show_app_chooser (ScratchFolderManagerFileView* self,
                                                          GSimpleAction* action,
                                                          GVariant* param)
{
	gchar* path = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	GFile* file = NULL;
	const gchar* _tmp5_;
	GFile* _tmp6_;
	GtkAppChooserDialog* dialog = NULL;
	GtkWindow* _tmp7_;
	GtkWindow* _tmp8_;
	GFile* _tmp9_;
	GtkAppChooserDialog* _tmp10_;
	GtkAppChooserDialog* _tmp11_;
	GtkAppChooserDialog* _tmp12_;
	GtkAppChooserDialog* _tmp13_;
	GtkAppChooserDialog* _tmp20_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = g_variant_get_string (param, NULL);
	_tmp1_ = g_strdup (_tmp0_);
	path = _tmp1_;
	_tmp3_ = path;
	if (_tmp3_ == NULL) {
		_tmp2_ = TRUE;
	} else {
		const gchar* _tmp4_;
		_tmp4_ = path;
		_tmp2_ = g_strcmp0 (_tmp4_, "") == 0;
	}
	if (_tmp2_) {
		_g_free0 (path);
		return;
	}
	_tmp5_ = path;
	_tmp6_ = g_file_new_for_path (_tmp5_);
	file = _tmp6_;
	_tmp7_ = (GtkWindow*) gtk_window_new (GTK_WINDOW_TOPLEVEL);
	g_object_ref_sink (_tmp7_);
	_tmp8_ = _tmp7_;
	_tmp9_ = file;
	_tmp10_ = (GtkAppChooserDialog*) gtk_app_chooser_dialog_new (_tmp8_, GTK_DIALOG_MODAL, _tmp9_);
	g_object_ref_sink (_tmp10_);
	_tmp11_ = _tmp10_;
	_g_object_unref0 (_tmp8_);
	dialog = _tmp11_;
	_tmp12_ = dialog;
	gtk_window_set_deletable ((GtkWindow*) _tmp12_, FALSE);
	_tmp13_ = dialog;
	if (gtk_dialog_run ((GtkDialog*) _tmp13_) == ((gint) GTK_RESPONSE_OK)) {
		GAppInfo* app_info = NULL;
		GtkAppChooserDialog* _tmp14_;
		GAppInfo* _tmp15_;
		GAppInfo* _tmp16_;
		_tmp14_ = dialog;
		_tmp15_ = gtk_app_chooser_get_app_info ((GtkAppChooser*) _tmp14_);
		app_info = _tmp15_;
		_tmp16_ = app_info;
		if (_tmp16_ != NULL) {
			GAppInfo* _tmp17_;
			const gchar* _tmp18_;
			const gchar* _tmp19_;
			_tmp17_ = app_info;
			_tmp18_ = g_app_info_get_id (_tmp17_);
			_tmp19_ = path;
			scratch_utils_launch_app_with_file (_tmp18_, _tmp19_);
		}
		_g_object_unref0 (app_info);
	}
	_tmp20_ = dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp20_);
	_g_object_unref0 (dialog);
	_g_object_unref0 (file);
	_g_free0 (path);
}

static void
scratch_folder_manager_file_view_action_execute_contract_with_file_path (ScratchFolderManagerFileView* self,
                                                                         GSimpleAction* action,
                                                                         GVariant* param)
{
	const gchar** params = NULL;
	gsize _tmp0_ = 0;
	const gchar** _tmp1_;
	gint params_length1;
	gint _params_size_;
	gchar* path = NULL;
	const gchar** _tmp2_;
	gint _tmp2__length1;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gboolean _tmp5_ = FALSE;
	const gchar* _tmp6_;
	gchar* contract_name = NULL;
	const gchar** _tmp8_;
	gint _tmp8__length1;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	gboolean _tmp11_ = FALSE;
	const gchar* _tmp12_;
	const gchar* _tmp14_;
	const gchar* _tmp15_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp1_ = g_variant_get_strv (param, &_tmp0_);
	params = _tmp1_;
	params_length1 = _tmp0_;
	_params_size_ = params_length1;
	_tmp2_ = params;
	_tmp2__length1 = params_length1;
	_tmp3_ = _tmp2_[0];
	_tmp4_ = g_strdup (_tmp3_);
	path = _tmp4_;
	_tmp6_ = path;
	if (_tmp6_ == NULL) {
		_tmp5_ = TRUE;
	} else {
		const gchar* _tmp7_;
		_tmp7_ = path;
		_tmp5_ = g_strcmp0 (_tmp7_, "") == 0;
	}
	if (_tmp5_) {
		_g_free0 (path);
		params = (g_free (params), NULL);
		return;
	}
	_tmp8_ = params;
	_tmp8__length1 = params_length1;
	_tmp9_ = _tmp8_[1];
	_tmp10_ = g_strdup (_tmp9_);
	contract_name = _tmp10_;
	_tmp12_ = contract_name;
	if (_tmp12_ == NULL) {
		_tmp11_ = TRUE;
	} else {
		const gchar* _tmp13_;
		_tmp13_ = contract_name;
		_tmp11_ = g_strcmp0 (_tmp13_, "") == 0;
	}
	if (_tmp11_) {
		_g_free0 (contract_name);
		_g_free0 (path);
		params = (g_free (params), NULL);
		return;
	}
	_tmp14_ = path;
	_tmp15_ = contract_name;
	scratch_utils_execute_contract_with_file_path (_tmp14_, _tmp15_);
	_g_free0 (contract_name);
	_g_free0 (path);
	params = (g_free (params), NULL);
}

static void
scratch_folder_manager_file_view_action_rename_file (ScratchFolderManagerFileView* self,
                                                     GSimpleAction* action,
                                                     GVariant* param)
{
	gchar* path = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	const gchar* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = g_variant_get_string (param, NULL);
	_tmp1_ = g_strdup (_tmp0_);
	path = _tmp1_;
	_tmp3_ = path;
	if (_tmp3_ == NULL) {
		_tmp2_ = TRUE;
	} else {
		const gchar* _tmp4_;
		_tmp4_ = path;
		_tmp2_ = g_strcmp0 (_tmp4_, "") == 0;
	}
	if (_tmp2_) {
		_g_free0 (path);
		return;
	}
	_tmp5_ = path;
	scratch_folder_manager_file_view_rename_file (self, _tmp5_);
	_g_free0 (path);
}

static void
scratch_folder_manager_file_view_action_rename_folder (ScratchFolderManagerFileView* self,
                                                       GSimpleAction* action,
                                                       GVariant* param)
{
	gchar* path = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	const gchar* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = g_variant_get_string (param, NULL);
	_tmp1_ = g_strdup (_tmp0_);
	path = _tmp1_;
	_tmp3_ = path;
	if (_tmp3_ == NULL) {
		_tmp2_ = TRUE;
	} else {
		const gchar* _tmp4_;
		_tmp4_ = path;
		_tmp2_ = g_strcmp0 (_tmp4_, "") == 0;
	}
	if (_tmp2_) {
		_g_free0 (path);
		return;
	}
	_tmp5_ = path;
	scratch_folder_manager_file_view_rename_folder (self, _tmp5_);
	_g_free0 (path);
}

static Block14Data*
block14_data_ref (Block14Data* _data14_)
{
	g_atomic_int_inc (&_data14_->_ref_count_);
	return _data14_;
}

static void
block14_data_unref (void * _userdata_)
{
	Block14Data* _data14_;
	_data14_ = (Block14Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data14_->_ref_count_)) {
		ScratchFolderManagerFileView* self;
		self = _data14_->self;
		_g_object_unref0 (_data14_->item_to_delete);
		_g_object_unref0 (self);
		g_slice_free (Block14Data, _data14_);
	}
}

static void
____lambda88_ (Block14Data* _data14_)
{
	ScratchFolderManagerFileView* self;
	ScratchFolderManagerItem* _tmp0_;
	self = _data14_->self;
	_tmp0_ = _data14_->item_to_delete;
	scratch_folder_manager_item_trash (_tmp0_);
}

static void
_____lambda88__scratch_folder_manager_project_folder_item_closed (ScratchFolderManagerProjectFolderItem* _sender,
                                                                  gpointer self)
{
	____lambda88_ (self);
}

static void
scratch_folder_manager_file_view_action_delete (ScratchFolderManagerFileView* self,
                                                GSimpleAction* action,
                                                GVariant* param)
{
	gchar* path = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	CodeWidgetsSourceListItem* item = NULL;
	CodeWidgetsSourceListExpandableItem* _tmp5_;
	CodeWidgetsSourceListExpandableItem* _tmp6_;
	const gchar* _tmp7_;
	CodeWidgetsSourceListItem* _tmp8_;
	CodeWidgetsSourceListItem* _tmp9_;
	CodeWidgetsSourceListItem* _tmp10_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = g_variant_get_string (param, NULL);
	_tmp1_ = g_strdup (_tmp0_);
	path = _tmp1_;
	_tmp3_ = path;
	if (_tmp3_ == NULL) {
		_tmp2_ = TRUE;
	} else {
		const gchar* _tmp4_;
		_tmp4_ = path;
		_tmp2_ = g_strcmp0 (_tmp4_, "") == 0;
	}
	if (_tmp2_) {
		_g_free0 (path);
		return;
	}
	_tmp5_ = code_widgets_source_list_get_root ((CodeWidgetsSourceList*) self);
	_tmp6_ = _tmp5_;
	_tmp7_ = path;
	_tmp8_ = scratch_folder_manager_file_view_find_path (self, _tmp6_, _tmp7_, FALSE);
	_tmp9_ = _g_object_ref0 (_tmp8_);
	item = _tmp9_;
	_tmp10_ = item;
	if (_tmp10_ != NULL) {
		Block14Data* _data14_;
		CodeWidgetsSourceListItem* _tmp11_;
		ScratchFolderManagerItem* _tmp12_;
		ScratchFolderManagerItem* _tmp13_;
		ScratchFolderManagerItem* _tmp16_;
		_data14_ = g_slice_new0 (Block14Data);
		_data14_->_ref_count_ = 1;
		_data14_->self = g_object_ref (self);
		_tmp11_ = item;
		_tmp12_ = _g_object_ref0 (SCRATCH_FOLDER_MANAGER_IS_ITEM (_tmp11_) ? ((ScratchFolderManagerItem*) _tmp11_) : NULL);
		_data14_->item_to_delete = _tmp12_;
		_tmp13_ = _data14_->item_to_delete;
		if (SCRATCH_FOLDER_MANAGER_IS_PROJECT_FOLDER_ITEM (_tmp13_)) {
			ScratchFolderManagerItem* _tmp14_;
			ScratchFolderManagerItem* _tmp15_;
			_tmp14_ = _data14_->item_to_delete;
			g_signal_connect_data ((ScratchFolderManagerProjectFolderItem*) _tmp14_, "closed", (GCallback) _____lambda88__scratch_folder_manager_project_folder_item_closed, block14_data_ref (_data14_), (GClosureNotify) block14_data_unref, G_CONNECT_AFTER);
			_tmp15_ = _data14_->item_to_delete;
			g_signal_emit_by_name ((ScratchFolderManagerProjectFolderItem*) _tmp15_, "closed");
			block14_data_unref (_data14_);
			_data14_ = NULL;
			_g_object_unref0 (item);
			_g_free0 (path);
			return;
		}
		_tmp16_ = _data14_->item_to_delete;
		scratch_folder_manager_item_trash (_tmp16_);
		block14_data_unref (_data14_);
		_data14_ = NULL;
	}
	_g_object_unref0 (item);
	_g_free0 (path);
}

static void
scratch_folder_manager_file_view_add_folder_data_free (gpointer _data)
{
	ScratchFolderManagerFileViewAddFolderData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (ScratchFolderManagerFileViewAddFolderData, _data_);
}

static void
scratch_folder_manager_file_view_add_folder (ScratchFolderManagerFileView* self,
                                             ScratchFolderManagerFile* folder,
                                             gboolean expand,
                                             GAsyncReadyCallback _callback_,
                                             gpointer _user_data_)
{
	ScratchFolderManagerFileViewAddFolderData* _data_;
	ScratchFolderManagerFileView* _tmp0_;
	ScratchFolderManagerFile* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (folder != NULL);
	_data_ = g_slice_new0 (ScratchFolderManagerFileViewAddFolderData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, scratch_folder_manager_file_view_add_folder_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (folder);
	_g_object_unref0 (_data_->folder);
	_data_->folder = _tmp1_;
	_data_->expand = expand;
	scratch_folder_manager_file_view_add_folder_co (_data_);
}

static void
scratch_folder_manager_file_view_add_folder_finish (ScratchFolderManagerFileView* self,
                                                    GAsyncResult* _res_)
{
	ScratchFolderManagerFileViewAddFolderData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static Block15Data*
block15_data_ref (Block15Data* _data15_)
{
	g_atomic_int_inc (&_data15_->_ref_count_);
	return _data15_;
}

static void
block15_data_unref (void * _userdata_)
{
	Block15Data* _data15_;
	_data15_ = (Block15Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data15_->_ref_count_)) {
		ScratchFolderManagerFileView* self;
		self = _data15_->self;
		_g_object_unref0 (_data15_->folder);
		_g_object_unref0 (self);
		g_slice_free (Block15Data, _data15_);
	}
}

static Block16Data*
block16_data_ref (Block16Data* _data16_)
{
	g_atomic_int_inc (&_data16_->_ref_count_);
	return _data16_;
}

static void
block16_data_unref (void * _userdata_)
{
	Block16Data* _data16_;
	_data16_ = (Block16Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data16_->_ref_count_)) {
		ScratchFolderManagerFileView* self;
		self = _data16_->_data15_->self;
		_g_object_unref0 (_data16_->dialog);
		block15_data_unref (_data16_->_data15_);
		_data16_->_data15_ = NULL;
		g_slice_free (Block16Data, _data16_);
	}
}

static void
___lambda92_ (Block16Data* _data16_,
              gint res)
{
	Block15Data* _data15_;
	ScratchFolderManagerFileView* self;
	ScratchDialogsCloseProjectsConfirmationDialog* _tmp0_;
	_data15_ = _data16_->_data15_;
	self = _data15_->self;
	_tmp0_ = _data16_->dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp0_);
	if (res == ((gint) GTK_RESPONSE_ACCEPT)) {
		_data16_->close_projects = TRUE;
	}
}

static void
____lambda92__gtk_dialog_response (GtkDialog* _sender,
                                   gint response_id,
                                   gpointer self)
{
	___lambda92_ (self, response_id);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static Block17Data*
block17_data_ref (Block17Data* _data17_)
{
	g_atomic_int_inc (&_data17_->_ref_count_);
	return _data17_;
}

static void
block17_data_unref (void * _userdata_)
{
	Block17Data* _data17_;
	_data17_ = (Block17Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data17_->_ref_count_)) {
		ScratchFolderManagerFileView* self;
		self = _data17_->_data15_->self;
		_g_object_unref0 (_data17_->folder_root);
		block15_data_unref (_data17_->_data15_);
		_data17_->_data15_ = NULL;
		g_slice_free (Block17Data, _data17_);
	}
}

static void
__lambda94_ (Block17Data* _data17_)
{
	Block15Data* _data15_;
	ScratchFolderManagerFileView* self;
	GActionGroup* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GVariant* _tmp4_;
	GVariant* _tmp5_;
	CodeWidgetsSourceListExpandableItem* _tmp6_;
	CodeWidgetsSourceListExpandableItem* _tmp7_;
	ScratchServicesGitManager* _tmp29_;
	ScratchServicesGitManager* _tmp30_;
	_data15_ = _data17_->_data15_;
	self = _data15_->self;
	_tmp0_ = self->priv->_toplevel_action_group;
	_tmp1_ = scratch_folder_manager_item_get_path ((ScratchFolderManagerItem*) _data17_->folder_root);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp4_ = g_variant_new_string (_tmp3_);
	g_variant_ref_sink (_tmp4_);
	_tmp5_ = _tmp4_;
	g_action_group_activate_action (_tmp0_, SCRATCH_MAIN_WINDOW_ACTION_CLOSE_PROJECT_DOCS, _tmp5_);
	_g_variant_unref0 (_tmp5_);
	_g_free0 (_tmp3_);
	_tmp6_ = code_widgets_source_list_get_root ((CodeWidgetsSourceList*) self);
	_tmp7_ = _tmp6_;
	code_widgets_source_list_expandable_item_remove (_tmp7_, (CodeWidgetsSourceListItem*) _data17_->folder_root);
	{
		GeeIterator* _child_it = NULL;
		CodeWidgetsSourceListExpandableItem* _tmp8_;
		CodeWidgetsSourceListExpandableItem* _tmp9_;
		GeeCollection* _tmp10_;
		GeeCollection* _tmp11_;
		GeeCollection* _tmp12_;
		GeeIterator* _tmp13_;
		GeeIterator* _tmp14_;
		_tmp8_ = code_widgets_source_list_get_root ((CodeWidgetsSourceList*) self);
		_tmp9_ = _tmp8_;
		_tmp10_ = code_widgets_source_list_expandable_item_get_children (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = _tmp11_;
		_tmp13_ = gee_iterable_iterator ((GeeIterable*) _tmp12_);
		_tmp14_ = _tmp13_;
		_g_object_unref0 (_tmp12_);
		_child_it = _tmp14_;
		while (TRUE) {
			GeeIterator* _tmp15_;
			CodeWidgetsSourceListItem* child = NULL;
			GeeIterator* _tmp16_;
			gpointer _tmp17_;
			ScratchFolderManagerProjectFolderItem* child_folder = NULL;
			CodeWidgetsSourceListItem* _tmp18_;
			ScratchFolderManagerProjectFolderItem* _tmp19_;
			ScratchFolderManagerProjectFolderItem* _tmp20_;
			const gchar* _tmp21_;
			const gchar* _tmp22_;
			ScratchFolderManagerProjectFolderItem* _tmp23_;
			ScratchFolderManagerFile* _tmp24_;
			ScratchFolderManagerFile* _tmp25_;
			const gchar* _tmp26_;
			const gchar* _tmp27_;
			_tmp15_ = _child_it;
			if (!gee_iterator_next (_tmp15_)) {
				break;
			}
			_tmp16_ = _child_it;
			_tmp17_ = gee_iterator_get (_tmp16_);
			child = (CodeWidgetsSourceListItem*) _tmp17_;
			_tmp18_ = child;
			_tmp19_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, SCRATCH_FOLDER_MANAGER_TYPE_PROJECT_FOLDER_ITEM, ScratchFolderManagerProjectFolderItem));
			child_folder = _tmp19_;
			_tmp20_ = child_folder;
			_tmp21_ = code_widgets_source_list_item_get_name ((CodeWidgetsSourceListItem*) _tmp20_);
			_tmp22_ = _tmp21_;
			_tmp23_ = child_folder;
			_tmp24_ = scratch_folder_manager_item_get_file ((ScratchFolderManagerItem*) _tmp23_);
			_tmp25_ = _tmp24_;
			_tmp26_ = scratch_folder_manager_file_get_name (_tmp25_);
			_tmp27_ = _tmp26_;
			if (g_strcmp0 (_tmp22_, _tmp27_) != 0) {
				ScratchFolderManagerProjectFolderItem* _tmp28_;
				_tmp28_ = child_folder;
				scratch_folder_manager_file_view_rename_items_with_same_name (self, (ScratchFolderManagerItem*) _tmp28_);
			}
			_g_object_unref0 (child_folder);
			_g_object_unref0 (child);
		}
		_g_object_unref0 (_child_it);
	}
	_tmp29_ = scratch_services_git_manager_get_instance ();
	_tmp30_ = _tmp29_;
	scratch_services_git_manager_remove_project (_tmp30_, _data17_->folder_root);
	_g_object_unref0 (_tmp30_);
	scratch_folder_manager_file_view_write_settings (self);
}

static void
___lambda94__scratch_folder_manager_project_folder_item_closed (ScratchFolderManagerProjectFolderItem* _sender,
                                                                gpointer self)
{
	__lambda94_ (self);
}

static gboolean
__lambda93_ (Block15Data* _data15_)
{
	ScratchFolderManagerFileView* self;
	Block17Data* _data17_;
	ScratchFolderManagerProjectFolderItem* _tmp0_;
	CodeWidgetsSourceListExpandableItem* _tmp1_;
	CodeWidgetsSourceListExpandableItem* _tmp2_;
	gboolean result;
	self = _data15_->self;
	_data17_ = g_slice_new0 (Block17Data);
	_data17_->_ref_count_ = 1;
	_data17_->_data15_ = block15_data_ref (_data15_);
	_tmp0_ = scratch_folder_manager_project_folder_item_new (_data15_->folder, self);
	_data17_->folder_root = _tmp0_;
	_tmp1_ = code_widgets_source_list_get_root ((CodeWidgetsSourceList*) self);
	_tmp2_ = _tmp1_;
	code_widgets_source_list_expandable_item_add (_tmp2_, (CodeWidgetsSourceListItem*) _data17_->folder_root);
	scratch_folder_manager_file_view_rename_items_with_same_name (self, (ScratchFolderManagerItem*) _data17_->folder_root);
	code_widgets_source_list_expandable_item_set_expanded ((CodeWidgetsSourceListExpandableItem*) _data17_->folder_root, _data15_->expand);
	g_signal_connect_data (_data17_->folder_root, "closed", (GCallback) ___lambda94__scratch_folder_manager_project_folder_item_closed, block17_data_ref (_data17_), (GClosureNotify) block17_data_unref, 0);
	scratch_folder_manager_file_view_write_settings (self);
	scratch_folder_manager_file_view_add_folder_co (_data15_->_async_data_);
	result = G_SOURCE_REMOVE;
	block17_data_unref (_data17_);
	_data17_ = NULL;
	return result;
}

static gboolean
___lambda93__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda93_ (self);
	return result;
}

static gboolean
scratch_folder_manager_file_view_add_folder_co (ScratchFolderManagerFileViewAddFolderData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data15_ = g_slice_new0 (Block15Data);
	_data_->_data15_->_ref_count_ = 1;
	_data_->_data15_->self = g_object_ref (_data_->self);
	_g_object_unref0 (_data_->_data15_->folder);
	_data_->_data15_->folder = _data_->folder;
	_data_->_data15_->expand = _data_->expand;
	_data_->_data15_->_async_data_ = _data_;
	if (scratch_folder_manager_file_view_is_open (_data_->self, _data_->_data15_->folder)) {
		_data_->_tmp0_ = scratch_folder_manager_file_get_path (_data_->_data15_->folder);
		_data_->_tmp1_ = _data_->_tmp0_;
		_data_->_tmp2_ = _data_->_tmp1_;
		g_warning ("FileView.vala:512: Folder '%s' is already open.", _data_->_tmp2_);
		_g_free0 (_data_->_tmp2_);
		block15_data_unref (_data_->_data15_);
		_data_->_data15_ = NULL;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	} else {
		_data_->_tmp3_ = scratch_folder_manager_file_get_is_valid_directory (_data_->_data15_->folder);
		_data_->_tmp4_ = _data_->_tmp3_;
		if (!_data_->_tmp4_) {
			g_warning ("FileView.vala:515: Cannot open invalid directory.");
			block15_data_unref (_data_->_data15_);
			_data_->_data15_ = NULL;
			g_task_return_pointer (_data_->_async_result, _data_, NULL);
			if (_data_->_state_ != 0) {
				while (!g_task_get_completed (_data_->_async_result)) {
					g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
				}
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->_tmp5_ = scratch_folder_manager_file_get_file (_data_->_data15_->folder);
	_data_->_tmp6_ = _data_->_tmp5_;
	_data_->_tmp7_ = _g_object_ref0 (_data_->_tmp6_);
	_data_->add_file = _data_->_tmp7_;
	_data_->parents = NULL;
	_data_->children = NULL;
	{
		_data_->_tmp8_ = code_widgets_source_list_get_root ((CodeWidgetsSourceList*) _data_->self);
		_data_->_tmp9_ = _data_->_tmp8_;
		_data_->_tmp10_ = code_widgets_source_list_expandable_item_get_children (_data_->_tmp9_);
		_data_->_tmp11_ = _data_->_tmp10_;
		_data_->_tmp12_ = _data_->_tmp11_;
		_data_->_tmp13_ = gee_iterable_iterator ((GeeIterable*) _data_->_tmp12_);
		_data_->_tmp14_ = _data_->_tmp13_;
		_g_object_unref0 (_data_->_tmp12_);
		_data_->_child_it = _data_->_tmp14_;
		while (TRUE) {
			_data_->_tmp15_ = _data_->_child_it;
			if (!gee_iterator_next (_data_->_tmp15_)) {
				break;
			}
			_data_->_tmp16_ = _data_->_child_it;
			_data_->_tmp17_ = gee_iterator_get (_data_->_tmp16_);
			_data_->child = (CodeWidgetsSourceListItem*) _data_->_tmp17_;
			_data_->_tmp18_ = _data_->child;
			_data_->_tmp19_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp18_, SCRATCH_FOLDER_MANAGER_TYPE_PROJECT_FOLDER_ITEM, ScratchFolderManagerProjectFolderItem));
			_data_->item = _data_->_tmp19_;
			_data_->_tmp20_ = _data_->add_file;
			_data_->_tmp21_ = _data_->item;
			_data_->_tmp22_ = scratch_folder_manager_item_get_file ((ScratchFolderManagerItem*) _data_->_tmp21_);
			_data_->_tmp23_ = _data_->_tmp22_;
			_data_->_tmp24_ = scratch_folder_manager_file_get_file (_data_->_tmp23_);
			_data_->_tmp25_ = _data_->_tmp24_;
			_data_->_tmp26_ = g_file_get_relative_path (_data_->_tmp20_, _data_->_tmp25_);
			_data_->_tmp27_ = _data_->_tmp26_;
			_data_->_tmp28_ = _data_->_tmp27_ != NULL;
			_g_free0 (_data_->_tmp27_);
			if (_data_->_tmp28_) {
				g_debug ("FileView.vala:527: Trying to add parent of existing project");
				_data_->_tmp29_ = _data_->item;
				_data_->_tmp30_ = _g_object_ref0 (_data_->_tmp29_);
				_data_->children = g_list_append (_data_->children, _data_->_tmp30_);
			} else {
				_data_->_tmp31_ = _data_->item;
				_data_->_tmp32_ = scratch_folder_manager_item_get_file ((ScratchFolderManagerItem*) _data_->_tmp31_);
				_data_->_tmp33_ = _data_->_tmp32_;
				_data_->_tmp34_ = scratch_folder_manager_file_get_file (_data_->_tmp33_);
				_data_->_tmp35_ = _data_->_tmp34_;
				_data_->_tmp36_ = _data_->add_file;
				_data_->_tmp37_ = g_file_get_relative_path (_data_->_tmp35_, _data_->_tmp36_);
				_data_->_tmp38_ = _data_->_tmp37_;
				_data_->_tmp39_ = _data_->_tmp38_ != NULL;
				_g_free0 (_data_->_tmp38_);
				if (_data_->_tmp39_) {
					g_debug ("FileView.vala:530: Trying to add child of existing project");
					_data_->_tmp40_ = _data_->item;
					_data_->_tmp41_ = _g_object_ref0 (_data_->_tmp40_);
					_data_->parents = g_list_append (_data_->parents, _data_->_tmp41_);
				}
			}
			_g_object_unref0 (_data_->item);
			_g_object_unref0 (_data_->child);
		}
		_g_object_unref0 (_data_->_child_it);
	}
	_data_->_tmp43_ = _data_->parents;
	if (g_list_length (_data_->_tmp43_) > ((guint) 0)) {
		_data_->_tmp42_ = TRUE;
	} else {
		_data_->_tmp44_ = _data_->children;
		_data_->_tmp42_ = g_list_length (_data_->_tmp44_) > ((guint) 0);
	}
	if (_data_->_tmp42_) {
		_data_->_data16_ = g_slice_new0 (Block16Data);
		_data_->_data16_->_ref_count_ = 1;
		_data_->_data16_->_data15_ = block15_data_ref (_data_->_data15_);
		_data_->_tmp45_ = _data_->parents;
		_vala_assert (g_list_length (_data_->_tmp45_) <= ((guint) 1), "parents.length () <= 1");
		_data_->_tmp47_ = _data_->parents;
		if (g_list_length (_data_->_tmp47_) == ((guint) 0)) {
			_data_->_tmp46_ = TRUE;
		} else {
			_data_->_tmp48_ = _data_->children;
			_data_->_tmp46_ = g_list_length (_data_->_tmp48_) == ((guint) 0);
		}
		_vala_assert (_data_->_tmp46_, "parents.length () == 0 || children.length () == 0");
		_data_->_tmp49_ = gtk_widget_get_toplevel ((GtkWidget*) _data_->self);
		_data_->_tmp50_ = _data_->parents;
		_data_->_tmp51_ = _data_->children;
		_data_->_tmp52_ = scratch_dialogs_close_projects_confirmation_dialog_new (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp49_, SCRATCH_TYPE_MAIN_WINDOW, ScratchMainWindow), g_list_length (_data_->_tmp50_), g_list_length (_data_->_tmp51_));
		g_object_ref_sink (_data_->_tmp52_);
		_data_->_data16_->dialog = _data_->_tmp52_;
		_data_->_data16_->close_projects = FALSE;
		_data_->_tmp53_ = _data_->_data16_->dialog;
		g_signal_connect_data ((GtkDialog*) _data_->_tmp53_, "response", (GCallback) ____lambda92__gtk_dialog_response, block16_data_ref (_data_->_data16_), (GClosureNotify) block16_data_unref, 0);
		_data_->_tmp54_ = _data_->_data16_->dialog;
		gtk_dialog_run ((GtkDialog*) _data_->_tmp54_);
		if (_data_->_data16_->close_projects) {
			_data_->_tmp55_ = _data_->parents;
			{
				_data_->item_collection = _data_->_tmp55_;
				for (_data_->item_it = _data_->item_collection; _data_->item_it != NULL; _data_->item_it = _data_->item_it->next) {
					_data_->_tmp56_ = _g_object_ref0 ((ScratchFolderManagerProjectFolderItem*) _data_->item_it->data);
					_data_->_vala1_item = _data_->_tmp56_;
					{
						_data_->_tmp57_ = _data_->_vala1_item;
						g_signal_emit_by_name (_data_->_tmp57_, "closed");
						_g_object_unref0 (_data_->_vala1_item);
					}
				}
			}
			_data_->_tmp58_ = _data_->children;
			{
				_data_->_vala1_item_collection = _data_->_tmp58_;
				for (_data_->_vala1_item_it = _data_->_vala1_item_collection; _data_->_vala1_item_it != NULL; _data_->_vala1_item_it = _data_->_vala1_item_it->next) {
					_data_->_tmp59_ = _g_object_ref0 ((ScratchFolderManagerProjectFolderItem*) _data_->_vala1_item_it->data);
					_data_->_vala2_item = _data_->_tmp59_;
					{
						_data_->_tmp60_ = _data_->_vala2_item;
						g_signal_emit_by_name (_data_->_tmp60_, "closed");
						_g_object_unref0 (_data_->_vala2_item);
					}
				}
			}
		} else {
			block16_data_unref (_data_->_data16_);
			_data_->_data16_ = NULL;
			(_data_->children == NULL) ? NULL : (_data_->children = (_g_list_free__g_object_unref0_ (_data_->children), NULL));
			(_data_->parents == NULL) ? NULL : (_data_->parents = (_g_list_free__g_object_unref0_ (_data_->parents), NULL));
			_g_object_unref0 (_data_->add_file);
			block15_data_unref (_data_->_data15_);
			_data_->_data15_ = NULL;
			g_task_return_pointer (_data_->_async_result, _data_, NULL);
			if (_data_->_state_ != 0) {
				while (!g_task_get_completed (_data_->_async_result)) {
					g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
				}
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		block16_data_unref (_data_->_data16_);
		_data_->_data16_ = NULL;
	}
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda93__gsource_func, block15_data_ref (_data_->_data15_), block15_data_unref);
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	(_data_->children == NULL) ? NULL : (_data_->children = (_g_list_free__g_object_unref0_ (_data_->children), NULL));
	(_data_->parents == NULL) ? NULL : (_data_->parents = (_g_list_free__g_object_unref0_ (_data_->parents), NULL));
	_g_object_unref0 (_data_->add_file);
	block15_data_unref (_data_->_data15_);
	_data_->_data15_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static gboolean
scratch_folder_manager_file_view_is_open (ScratchFolderManagerFileView* self,
                                          ScratchFolderManagerFile* folder)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (folder != NULL, FALSE);
	{
		GeeIterator* _child_it = NULL;
		CodeWidgetsSourceListExpandableItem* _tmp0_;
		CodeWidgetsSourceListExpandableItem* _tmp1_;
		GeeCollection* _tmp2_;
		GeeCollection* _tmp3_;
		GeeCollection* _tmp4_;
		GeeIterator* _tmp5_;
		GeeIterator* _tmp6_;
		_tmp0_ = code_widgets_source_list_get_root ((CodeWidgetsSourceList*) self);
		_tmp1_ = _tmp0_;
		_tmp2_ = code_widgets_source_list_expandable_item_get_children (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = _tmp3_;
		_tmp5_ = gee_iterable_iterator ((GeeIterable*) _tmp4_);
		_tmp6_ = _tmp5_;
		_g_object_unref0 (_tmp4_);
		_child_it = _tmp6_;
		while (TRUE) {
			GeeIterator* _tmp7_;
			CodeWidgetsSourceListItem* child = NULL;
			GeeIterator* _tmp8_;
			gpointer _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
			gchar* _tmp12_;
			CodeWidgetsSourceListItem* _tmp13_;
			gchar* _tmp14_;
			gchar* _tmp15_;
			gchar* _tmp16_;
			gboolean _tmp17_;
			_tmp7_ = _child_it;
			if (!gee_iterator_next (_tmp7_)) {
				break;
			}
			_tmp8_ = _child_it;
			_tmp9_ = gee_iterator_get (_tmp8_);
			child = (CodeWidgetsSourceListItem*) _tmp9_;
			_tmp10_ = scratch_folder_manager_file_get_path (folder);
			_tmp11_ = _tmp10_;
			_tmp12_ = _tmp11_;
			_tmp13_ = child;
			_tmp14_ = scratch_folder_manager_item_get_path (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, SCRATCH_FOLDER_MANAGER_TYPE_ITEM, ScratchFolderManagerItem));
			_tmp15_ = _tmp14_;
			_tmp16_ = _tmp15_;
			_tmp17_ = g_strcmp0 (_tmp12_, _tmp16_) == 0;
			_g_free0 (_tmp16_);
			_g_free0 (_tmp12_);
			if (_tmp17_) {
				result = TRUE;
				_g_object_unref0 (child);
				_g_object_unref0 (_child_it);
				return result;
			}
			_g_object_unref0 (child);
		}
		_g_object_unref0 (_child_it);
	}
	result = FALSE;
	return result;
}

static void
_vala_array_add3 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
scratch_folder_manager_file_view_write_settings (ScratchFolderManagerFileView* self)
{
	gchar** to_save = NULL;
	gchar** _tmp0_;
	gint to_save_length1;
	gint _to_save_size_;
	GSettings* _tmp20_;
	gchar** _tmp21_;
	gint _tmp21__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	to_save = _tmp0_;
	to_save_length1 = 0;
	_to_save_size_ = to_save_length1;
	{
		GeeIterator* _main_folder_it = NULL;
		CodeWidgetsSourceListExpandableItem* _tmp1_;
		CodeWidgetsSourceListExpandableItem* _tmp2_;
		GeeCollection* _tmp3_;
		GeeCollection* _tmp4_;
		GeeCollection* _tmp5_;
		GeeIterator* _tmp6_;
		GeeIterator* _tmp7_;
		_tmp1_ = code_widgets_source_list_get_root ((CodeWidgetsSourceList*) self);
		_tmp2_ = _tmp1_;
		_tmp3_ = code_widgets_source_list_expandable_item_get_children (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = _tmp4_;
		_tmp6_ = gee_iterable_iterator ((GeeIterable*) _tmp5_);
		_tmp7_ = _tmp6_;
		_g_object_unref0 (_tmp5_);
		_main_folder_it = _tmp7_;
		while (TRUE) {
			GeeIterator* _tmp8_;
			CodeWidgetsSourceListItem* main_folder = NULL;
			GeeIterator* _tmp9_;
			gpointer _tmp10_;
			gboolean saved = FALSE;
			gchar* folder_path = NULL;
			CodeWidgetsSourceListItem* _tmp11_;
			gchar* _tmp12_;
			gchar* _tmp13_;
			gchar** _tmp14_;
			gint _tmp14__length1;
			_tmp8_ = _main_folder_it;
			if (!gee_iterator_next (_tmp8_)) {
				break;
			}
			_tmp9_ = _main_folder_it;
			_tmp10_ = gee_iterator_get (_tmp9_);
			main_folder = (CodeWidgetsSourceListItem*) _tmp10_;
			saved = FALSE;
			_tmp11_ = main_folder;
			_tmp12_ = scratch_folder_manager_item_get_path (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, SCRATCH_FOLDER_MANAGER_TYPE_ITEM, ScratchFolderManagerItem));
			_tmp13_ = _tmp12_;
			folder_path = _tmp13_;
			_tmp14_ = to_save;
			_tmp14__length1 = to_save_length1;
			{
				gchar** saved_folder_collection = NULL;
				gint saved_folder_collection_length1 = 0;
				gint _saved_folder_collection_size_ = 0;
				gint saved_folder_it = 0;
				saved_folder_collection = _tmp14_;
				saved_folder_collection_length1 = _tmp14__length1;
				for (saved_folder_it = 0; saved_folder_it < saved_folder_collection_length1; saved_folder_it = saved_folder_it + 1) {
					gchar* _tmp15_;
					gchar* saved_folder = NULL;
					_tmp15_ = g_strdup (saved_folder_collection[saved_folder_it]);
					saved_folder = _tmp15_;
					{
						const gchar* _tmp16_;
						const gchar* _tmp17_;
						_tmp16_ = folder_path;
						_tmp17_ = saved_folder;
						if (g_strcmp0 (_tmp16_, _tmp17_) == 0) {
							saved = TRUE;
							_g_free0 (saved_folder);
							break;
						}
						_g_free0 (saved_folder);
					}
				}
			}
			if (!saved) {
				const gchar* _tmp18_;
				gchar* _tmp19_;
				_tmp18_ = folder_path;
				_tmp19_ = g_strdup (_tmp18_);
				_vala_array_add3 (&to_save, &to_save_length1, &_to_save_size_, _tmp19_);
			}
			_g_free0 (folder_path);
			_g_object_unref0 (main_folder);
		}
		_g_object_unref0 (_main_folder_it);
	}
	_tmp20_ = self->priv->settings;
	_tmp21_ = to_save;
	_tmp21__length1 = to_save_length1;
	g_settings_set_strv (_tmp20_, "opened-folders", _tmp21_);
	to_save = (_vala_array_free (to_save, to_save_length1, (GDestroyNotify) g_free), NULL);
}

GSimpleActionGroup*
scratch_folder_manager_file_view_get_actions (ScratchFolderManagerFileView* self)
{
	GSimpleActionGroup* result;
	GSimpleActionGroup* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_actions;
	result = _tmp0_;
	return result;
}

static void
scratch_folder_manager_file_view_set_actions (ScratchFolderManagerFileView* self,
                                              GSimpleActionGroup* value)
{
	GSimpleActionGroup* old_value;
	g_return_if_fail (self != NULL);
	old_value = scratch_folder_manager_file_view_get_actions (self);
	if (old_value != value) {
		GSimpleActionGroup* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_actions);
		self->priv->_actions = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, scratch_folder_manager_file_view_properties[SCRATCH_FOLDER_MANAGER_FILE_VIEW_ACTIONS_PROPERTY]);
	}
}

GActionGroup*
scratch_folder_manager_file_view_get_toplevel_action_group (ScratchFolderManagerFileView* self)
{
	GActionGroup* result;
	GActionGroup* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_toplevel_action_group;
	result = _tmp0_;
	return result;
}

static void
scratch_folder_manager_file_view_set_toplevel_action_group (ScratchFolderManagerFileView* self,
                                                            GActionGroup* value)
{
	GActionGroup* old_value;
	g_return_if_fail (self != NULL);
	old_value = scratch_folder_manager_file_view_get_toplevel_action_group (self);
	if (old_value != value) {
		GActionGroup* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_toplevel_action_group);
		self->priv->_toplevel_action_group = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, scratch_folder_manager_file_view_properties[SCRATCH_FOLDER_MANAGER_FILE_VIEW_TOPLEVEL_ACTION_GROUP_PROPERTY]);
	}
}

static const gchar*
scratch_folder_manager_file_view_real_get_icon_name (CodePaneSwitcher* base)
{
	const gchar* result;
	ScratchFolderManagerFileView* self;
	const gchar* _tmp0_;
	self = (ScratchFolderManagerFileView*) base;
	_tmp0_ = self->priv->_icon_name;
	result = _tmp0_;
	return result;
}

static void
scratch_folder_manager_file_view_real_set_icon_name (CodePaneSwitcher* base,
                                                     const gchar* value)
{
	ScratchFolderManagerFileView* self;
	gchar* old_value;
	self = (ScratchFolderManagerFileView*) base;
	old_value = scratch_folder_manager_file_view_real_get_icon_name (base);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_icon_name);
		self->priv->_icon_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, scratch_folder_manager_file_view_properties[SCRATCH_FOLDER_MANAGER_FILE_VIEW_ICON_NAME_PROPERTY]);
	}
}

static const gchar*
scratch_folder_manager_file_view_real_get_title (CodePaneSwitcher* base)
{
	const gchar* result;
	ScratchFolderManagerFileView* self;
	const gchar* _tmp0_;
	self = (ScratchFolderManagerFileView*) base;
	_tmp0_ = self->priv->_title;
	result = _tmp0_;
	return result;
}

static void
scratch_folder_manager_file_view_real_set_title (CodePaneSwitcher* base,
                                                 const gchar* value)
{
	ScratchFolderManagerFileView* self;
	gchar* old_value;
	self = (ScratchFolderManagerFileView*) base;
	old_value = scratch_folder_manager_file_view_real_get_title (base);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_title);
		self->priv->_title = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, scratch_folder_manager_file_view_properties[SCRATCH_FOLDER_MANAGER_FILE_VIEW_TITLE_PROPERTY]);
	}
}

static void
g_cclosure_user_marshal_BOOLEAN__OBJECT (GClosure * closure,
                                         GValue * return_value,
                                         guint n_param_values,
                                         const GValue * param_values,
                                         gpointer invocation_hint,
                                         gpointer marshal_data)
{
	typedef gboolean (*GMarshalFunc_BOOLEAN__OBJECT) (gpointer data1, gpointer arg_1, gpointer data2);
	register GMarshalFunc_BOOLEAN__OBJECT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	gboolean v_return;
	cc = (GCClosure *) closure;
	g_return_if_fail (return_value != NULL);
	g_return_if_fail (n_param_values == 2);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_BOOLEAN__OBJECT) (marshal_data ? marshal_data : cc->callback);
	v_return = callback (data1, g_value_get_object (param_values + 1), data2);
	g_value_set_boolean (return_value, v_return);
}

static void
_scratch_folder_manager_file_view___lambda101_ (ScratchFolderManagerFileView* self)
{
	GActionGroup* _tmp0_;
	GActionGroup* _tmp1_;
	_tmp0_ = gtk_widget_get_action_group ((GtkWidget*) self, SCRATCH_MAIN_WINDOW_ACTION_GROUP);
	scratch_folder_manager_file_view_set_toplevel_action_group (self, _tmp0_);
	_tmp1_ = self->priv->_toplevel_action_group;
	g_assert_nonnull (_tmp1_);
}

static void
__scratch_folder_manager_file_view___lambda101__gtk_widget_realize (GtkWidget* _sender,
                                                                    gpointer self)
{
	_scratch_folder_manager_file_view___lambda101_ ((ScratchFolderManagerFileView*) self);
}

static GObject *
scratch_folder_manager_file_view_constructor (GType type,
                                              guint n_construct_properties,
                                              GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	ScratchFolderManagerFileView * self;
	GSettings* _tmp0_;
	ScratchServicesGitManager* _tmp1_;
	GSimpleActionGroup* _tmp2_;
	GSimpleActionGroup* _tmp3_;
	GSimpleActionGroup* _tmp4_;
	GSimpleActionGroup* _tmp5_;
	parent_class = G_OBJECT_CLASS (scratch_folder_manager_file_view_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SCRATCH_FOLDER_MANAGER_TYPE_FILE_VIEW, ScratchFolderManagerFileView);
	code_widgets_source_list_set_activate_on_single_click ((CodeWidgetsSourceList*) self, TRUE);
	code_pane_switcher_set_icon_name ((CodePaneSwitcher*) self, "folder-symbolic");
	code_pane_switcher_set_title ((CodePaneSwitcher*) self, _ ("Folders"));
	_tmp0_ = g_settings_new ("io.elementary.code.folder-manager");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp0_;
	_tmp1_ = scratch_services_git_manager_get_instance ();
	_g_object_unref0 (self->priv->git_manager);
	self->priv->git_manager = _tmp1_;
	_tmp2_ = g_simple_action_group_new ();
	_tmp3_ = _tmp2_;
	scratch_folder_manager_file_view_set_actions (self, _tmp3_);
	_g_object_unref0 (_tmp3_);
	_tmp4_ = self->priv->_actions;
	g_action_map_add_action_entries ((GActionMap*) _tmp4_, SCRATCH_FOLDER_MANAGER_FILE_VIEW_ACTION_ENTRIES, (gint) G_N_ELEMENTS (SCRATCH_FOLDER_MANAGER_FILE_VIEW_ACTION_ENTRIES), self);
	_tmp5_ = self->priv->_actions;
	gtk_widget_insert_action_group ((GtkWidget*) self, SCRATCH_FOLDER_MANAGER_FILE_VIEW_ACTION_GROUP, (GActionGroup*) _tmp5_);
	g_signal_connect_object ((GtkWidget*) self, "realize", (GCallback) __scratch_folder_manager_file_view___lambda101__gtk_widget_realize, self, 0);
	return obj;
}

static void
scratch_folder_manager_file_view_class_init (ScratchFolderManagerFileViewClass * klass,
                                             gpointer klass_data)
{
	scratch_folder_manager_file_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ScratchFolderManagerFileView_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_scratch_folder_manager_file_view_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_scratch_folder_manager_file_view_set_property;
	G_OBJECT_CLASS (klass)->constructor = scratch_folder_manager_file_view_constructor;
	G_OBJECT_CLASS (klass)->finalize = scratch_folder_manager_file_view_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SCRATCH_FOLDER_MANAGER_FILE_VIEW_ACTIONS_PROPERTY, scratch_folder_manager_file_view_properties[SCRATCH_FOLDER_MANAGER_FILE_VIEW_ACTIONS_PROPERTY] = g_param_spec_object ("actions", "actions", "actions", g_simple_action_group_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SCRATCH_FOLDER_MANAGER_FILE_VIEW_TOPLEVEL_ACTION_GROUP_PROPERTY, scratch_folder_manager_file_view_properties[SCRATCH_FOLDER_MANAGER_FILE_VIEW_TOPLEVEL_ACTION_GROUP_PROPERTY] = g_param_spec_object ("toplevel-action-group", "toplevel-action-group", "toplevel-action-group", g_action_group_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SCRATCH_FOLDER_MANAGER_FILE_VIEW_ICON_NAME_PROPERTY, scratch_folder_manager_file_view_properties[SCRATCH_FOLDER_MANAGER_FILE_VIEW_ICON_NAME_PROPERTY] = g_param_spec_string ("icon-name", "icon-name", "icon-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SCRATCH_FOLDER_MANAGER_FILE_VIEW_TITLE_PROPERTY, scratch_folder_manager_file_view_properties[SCRATCH_FOLDER_MANAGER_FILE_VIEW_TITLE_PROPERTY] = g_param_spec_string ("title", "title", "title", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	scratch_folder_manager_file_view_signals[SCRATCH_FOLDER_MANAGER_FILE_VIEW_ACTIVATE_SIGNAL] = g_signal_new ("activate", SCRATCH_FOLDER_MANAGER_TYPE_FILE_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	scratch_folder_manager_file_view_signals[SCRATCH_FOLDER_MANAGER_FILE_VIEW_RENAME_REQUEST_SIGNAL] = g_signal_new ("rename-request", SCRATCH_FOLDER_MANAGER_TYPE_FILE_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_BOOLEAN__OBJECT, G_TYPE_BOOLEAN, 1, SCRATCH_FOLDER_MANAGER_TYPE_FILE);
}

static void
scratch_folder_manager_file_view_code_pane_switcher_interface_init (CodePaneSwitcherIface * iface,
                                                                    gpointer iface_data)
{
	scratch_folder_manager_file_view_code_pane_switcher_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_icon_name = scratch_folder_manager_file_view_real_get_icon_name;
	iface->set_icon_name = scratch_folder_manager_file_view_real_set_icon_name;
	iface->get_title = scratch_folder_manager_file_view_real_get_title;
	iface->set_title = scratch_folder_manager_file_view_real_set_title;
}

static void
scratch_folder_manager_file_view_instance_init (ScratchFolderManagerFileView * self,
                                                gpointer klass)
{
	self->priv = scratch_folder_manager_file_view_get_instance_private (self);
}

static void
scratch_folder_manager_file_view_finalize (GObject * obj)
{
	ScratchFolderManagerFileView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SCRATCH_FOLDER_MANAGER_TYPE_FILE_VIEW, ScratchFolderManagerFileView);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->git_manager);
	_g_object_unref0 (self->priv->plugins);
	_g_object_unref0 (self->priv->_actions);
	_g_object_unref0 (self->priv->_toplevel_action_group);
	_g_free0 (self->priv->_icon_name);
	_g_free0 (self->priv->_title);
	G_OBJECT_CLASS (scratch_folder_manager_file_view_parent_class)->finalize (obj);
}

/**
 * SourceList that displays folders and their contents.
 */
 G_GNUC_NO_INLINE static GType
scratch_folder_manager_file_view_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ScratchFolderManagerFileViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) scratch_folder_manager_file_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ScratchFolderManagerFileView), 0, (GInstanceInitFunc) scratch_folder_manager_file_view_instance_init, NULL };
	static const GInterfaceInfo code_pane_switcher_info = { (GInterfaceInitFunc) scratch_folder_manager_file_view_code_pane_switcher_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType scratch_folder_manager_file_view_type_id;
	scratch_folder_manager_file_view_type_id = g_type_register_static (CODE_WIDGETS_TYPE_SOURCE_LIST, "ScratchFolderManagerFileView", &g_define_type_info, 0);
	g_type_add_interface_static (scratch_folder_manager_file_view_type_id, CODE_TYPE_PANE_SWITCHER, &code_pane_switcher_info);
	ScratchFolderManagerFileView_private_offset = g_type_add_instance_private (scratch_folder_manager_file_view_type_id, sizeof (ScratchFolderManagerFileViewPrivate));
	return scratch_folder_manager_file_view_type_id;
}

GType
scratch_folder_manager_file_view_get_type (void)
{
	static gsize scratch_folder_manager_file_view_type_id__once = 0;
	if (g_once_init_enter (&scratch_folder_manager_file_view_type_id__once)) {
		GType scratch_folder_manager_file_view_type_id;
		scratch_folder_manager_file_view_type_id = scratch_folder_manager_file_view_get_type_once ();
		g_once_init_leave (&scratch_folder_manager_file_view_type_id__once, scratch_folder_manager_file_view_type_id);
	}
	return scratch_folder_manager_file_view_type_id__once;
}

static void
_vala_scratch_folder_manager_file_view_get_property (GObject * object,
                                                     guint property_id,
                                                     GValue * value,
                                                     GParamSpec * pspec)
{
	ScratchFolderManagerFileView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SCRATCH_FOLDER_MANAGER_TYPE_FILE_VIEW, ScratchFolderManagerFileView);
	switch (property_id) {
		case SCRATCH_FOLDER_MANAGER_FILE_VIEW_ACTIONS_PROPERTY:
		g_value_set_object (value, scratch_folder_manager_file_view_get_actions (self));
		break;
		case SCRATCH_FOLDER_MANAGER_FILE_VIEW_TOPLEVEL_ACTION_GROUP_PROPERTY:
		g_value_set_object (value, scratch_folder_manager_file_view_get_toplevel_action_group (self));
		break;
		case SCRATCH_FOLDER_MANAGER_FILE_VIEW_ICON_NAME_PROPERTY:
		g_value_set_string (value, code_pane_switcher_get_icon_name ((CodePaneSwitcher*) self));
		break;
		case SCRATCH_FOLDER_MANAGER_FILE_VIEW_TITLE_PROPERTY:
		g_value_set_string (value, code_pane_switcher_get_title ((CodePaneSwitcher*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_scratch_folder_manager_file_view_set_property (GObject * object,
                                                     guint property_id,
                                                     const GValue * value,
                                                     GParamSpec * pspec)
{
	ScratchFolderManagerFileView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SCRATCH_FOLDER_MANAGER_TYPE_FILE_VIEW, ScratchFolderManagerFileView);
	switch (property_id) {
		case SCRATCH_FOLDER_MANAGER_FILE_VIEW_ACTIONS_PROPERTY:
		scratch_folder_manager_file_view_set_actions (self, g_value_get_object (value));
		break;
		case SCRATCH_FOLDER_MANAGER_FILE_VIEW_TOPLEVEL_ACTION_GROUP_PROPERTY:
		scratch_folder_manager_file_view_set_toplevel_action_group (self, g_value_get_object (value));
		break;
		case SCRATCH_FOLDER_MANAGER_FILE_VIEW_ICON_NAME_PROPERTY:
		code_pane_switcher_set_icon_name ((CodePaneSwitcher*) self, g_value_get_string (value));
		break;
		case SCRATCH_FOLDER_MANAGER_FILE_VIEW_TITLE_PROPERTY:
		code_pane_switcher_set_title ((CodePaneSwitcher*) self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

